/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.vmi.client;

import com.kingdee.bos.ctrl.common.ResourceManager;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.KingdeeTreeModel;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.client.TableUI;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.scm.im.inv.vmi.QueryDefFactory;
import com.kingdee.eas.scm.im.inv.vmi.QueryTableDefCollection;
import com.kingdee.eas.scm.im.inv.vmi.QueryTableDefInfo;
import com.kingdee.eas.scm.im.inv.vmi.client.AbstractQueryEditUI;
import com.kingdee.eas.scm.im.inv.vmi.client.QueryTableEditUI;
import com.kingdee.eas.scm.im.inv.vmi.client.QueryTableImportUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class QueryEditUI
extends AbstractQueryEditUI {
    private static final Logger logger = CoreUIObject.getLogger(QueryEditUI.class);
    private DefaultKingdeeTreeNode root;

    @Override
    public void loadFields() {
        super.loadFields();
        this.innerLoadFileds();
    }

    public void innerLoadFileds() {
        QueryTableDefInfo mainTable = this.editData.getMainTable();
        this.fillTreeNode(mainTable);
    }

    private void fillTreeNode(QueryTableDefInfo mainTable) {
        if (mainTable == null) {
            this.queryTree.setModel(null);
            return;
        }
        this.root = this.addTreeNode(null, mainTable);
        this.fillChildrenNode(this.root, mainTable);
        this.queryTree.setModel((TreeModel)new KingdeeTreeModel((TreeNode)this.root));
        this.queryTree.expandAllNodes(true, (TreeNode)this.root);
    }

    private void fillChildrenNode(DefaultKingdeeTreeNode root, QueryTableDefInfo table) {
        if (table == null) {
            return;
        }
        QueryTableDefCollection coll = table.getChildren(this.editData.getEntry());
        for (int i = 0; i < coll.size(); ++i) {
            DefaultKingdeeTreeNode node = this.addTreeNode(root, coll.get(i));
            this.fillChildrenNode(node, coll.get(i));
        }
    }

    private DefaultKingdeeTreeNode addTreeNode(DefaultKingdeeTreeNode parent, QueryTableDefInfo table) {
        if (table == null) {
            return null;
        }
        DefaultKingdeeTreeNode treeNode = null;
        treeNode = new DefaultKingdeeTreeNode((Object)table);
        treeNode.setText(table.getName() + "(" + table.getTableAlias() + ")");
        treeNode.setCustomIcon((Icon)ResourceManager.getIcon(TableUI.class, (String)"bos_table.gif"));
        if (parent == null) {
            return treeNode;
        }
        this.queryTree.addNodeInto((MutableTreeNode)treeNode, (MutableTreeNode)parent);
        this.queryTree.setModel((TreeModel)new KingdeeTreeModel((TreeNode)this.root));
        this.queryTree.expandAllNodes(true, (TreeNode)this.root);
        return treeNode;
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("entry.*"));
        sic.add(new SelectorItemInfo("entry.parentTable.*"));
        return sic;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.afterLoad();
    }

    private void afterLoad() {
        this.initButtonStatus();
    }

    private void initButtonStatus() {
        if (this.getOprtState().equals(OprtState.VIEW)) {
            this.btnEdit.setEnabled(true);
            this.btnSave.setEnabled(false);
            this.btnAdd.setEnabled(false);
            this.btnDel.setEnabled(false);
            this.btnImport.setEnabled(false);
            this.btnModify.setEnabled(false);
        } else if (this.getOprtState().equals(OprtState.EDIT)) {
            this.btnEdit.setEnabled(false);
            this.btnSave.setEnabled(true);
            this.btnAdd.setEnabled(true);
            this.btnDel.setEnabled(true);
            this.btnImport.setEnabled(true);
            this.btnModify.setEnabled(true);
        }
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
        this.initButtonStatus();
    }

    private QueryTableDefInfo createNewQueryTableData() {
        QueryTableDefInfo info = new QueryTableDefInfo();
        info.setId(BOSUuid.create((BOSObjectType)info.getBOSType()));
        info.setIsMainTable(false);
        info.setParent(this.editData);
        return info;
    }

    @Override
    public void actionAdd_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelectPath();
        TreePath path = this.queryTree.getSelectionPath();
        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)path.getLastPathComponent();
        QueryTableDefInfo parent = (QueryTableDefInfo)node.getUserObject();
        QueryTableDefInfo table = this.createNewQueryTableData();
        table.setParentTable(parent);
        UIContext uiContext = new UIContext();
        uiContext.put("query", this.editData);
        uiContext.put("queryTable", table);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(QueryTableEditUI.class.getName(), (Map)uiContext);
        uiWindow.show();
        QueryTableEditUI tableEditUI = (QueryTableEditUI)uiWindow.getUIObject();
        if (tableEditUI.isConfirm()) {
            this.editData.getEntry().add(table);
            this.addTreeNode(node, table);
            this.queryTree.repaint();
        }
    }

    private void checkSelectPath() {
        TreePath path = this.queryTree.getSelectionPath();
        if (path == null) {
            SysUtil.abort();
        }
    }

    @Override
    public void actionImport_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext();
        uiContext.put("BosType", this.editData.getBillBosType());
        uiContext.put("DataQuery", this.editData);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(QueryTableImportUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
        QueryTableImportUI importUI = (QueryTableImportUI)uiWindow.getUIObject();
        if (importUI.isConfirm()) {
            this.fillTreeNode(this.editData.getMainTable());
            this.queryTree.repaint();
        }
    }

    @Override
    public void actionModify_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelectPath();
        TreePath path = this.queryTree.getSelectionPath();
        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)path.getLastPathComponent();
        if (node.isRoot()) {
            return;
        }
        QueryTableDefInfo oldTable = (QueryTableDefInfo)node.getUserObject();
        QueryTableDefInfo newTable = (QueryTableDefInfo)oldTable.clone();
        UIContext uiContext = new UIContext();
        uiContext.put("query", this.editData);
        uiContext.put("queryTable", newTable);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(QueryTableEditUI.class.getName(), (Map)uiContext, null, OprtState.EDIT);
        uiWindow.show();
        QueryTableEditUI tableEditUI = (QueryTableEditUI)uiWindow.getUIObject();
        if (tableEditUI.isConfirm()) {
            newTable.setParent(this.editData);
            this.editData.getEntry().remove(oldTable);
            this.editData.getEntry().add(newTable);
            this.updateTreeNode(node, newTable);
            this.queryTree.repaint();
        }
    }

    private void updateTreeNode(DefaultKingdeeTreeNode node, QueryTableDefInfo table) {
        if (node == null || table == null) {
            return;
        }
        node.setText(table.getName());
        node.setUserObject((Object)table);
    }

    @Override
    public void actionDel_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelectPath();
        TreePath path = this.queryTree.getSelectionPath();
        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)path.getLastPathComponent();
        if (node.isRoot()) {
            return;
        }
        if (this.confirmRemove()) {
            this.deleteTreeNode(node);
            this.queryTree.removeAllChildrenFromParent((MutableTreeNode)node);
            this.queryTree.removeNodeFromParent((MutableTreeNode)node);
            this.queryTree.repaint();
        }
    }

    private void deleteTreeNode(DefaultKingdeeTreeNode node) throws Exception {
        if (node == null) {
            return;
        }
        int count = node.getChildCount();
        DefaultKingdeeTreeNode child = null;
        for (int i = 0; i < count; ++i) {
            child = (DefaultKingdeeTreeNode)node.getChildAt(i);
            this.deleteTreeNode(child);
        }
        QueryTableDefInfo table = (QueryTableDefInfo)node.getUserObject();
        this.editData.getEntry().remove(table);
    }

    protected boolean confirmRemove() {
        return MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Delete")));
    }

    protected IObjectValue createNewData() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return QueryDefFactory.getRemoteInstance();
    }
}

