/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.vmi.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.IParser;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.PreChangeEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.master.cssp.CSSPGroupInfo;
import com.kingdee.eas.basedata.master.cssp.MainDataParser;
import com.kingdee.eas.basedata.master.cssp.UsedStatusEnum;
import com.kingdee.eas.basedata.master.material.client.F7MaterialMultiUISelectorAdaptor;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.scm.common.BillTypeFactory;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.common.IBillType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.scm.cal.util.CalculateClientUtil;
import com.kingdee.eas.scm.common.SCMFetchData;
import com.kingdee.eas.scm.common.SCMFetchDataCondition;
import com.kingdee.eas.scm.common.SCMFetchDataFacadeFactory;
import com.kingdee.eas.scm.common.client.GeneralKDPromptSelectorAdaptor;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.client.SCMGroupClientUtils;
import com.kingdee.eas.scm.common.util.ReportQueryConditionHelper;
import com.kingdee.eas.scm.im.inv.vmi.client.AbstractVMISettleOptConditionUI;
import com.kingdee.eas.scm.im.inv.vmi.client.VMISettleClientUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Container;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class VMISettleOptConditionUI
extends AbstractVMISettleOptConditionUI {
    private static final Logger logger = CoreUIObject.getLogger(VMISettleOptConditionUI.class);
    private Set souIDs;

    public void onLoad() throws Exception {
        super.onLoad();
        this.afterLoad();
    }

    private void afterLoad() throws Exception {
        this.setDefaultValue();
        SCMClientUtils.setMainBizOrgF7forSealUp((KDBizPromptBox)this.bizPromptCompanyOrgUnit, (OrgType)OrgType.Company, (String)this.getViewPermission());
        this.bizPromptCompanyOrgUnit.getQueryAgent().setEnabledMultiSelection(false);
        SCMGroupClientUtils.setBizCustomerF7((KDBizPromptBox)this.prmtCustomer, (Component)((Object)this), (OrgType)OrgType.Company, (boolean)true, null);
        this.setBillTypeFilter(this.bizPromptBillType);
        this.bizPromptSupplier.setRequired(false);
        this.prmtWarehouse.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                VMISettleOptConditionUI.this.setWarehouseFilter();
            }
        });
        this.bizPromptBillType.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                BillTypeInfo billType = (BillTypeInfo)VMISettleOptConditionUI.this.bizPromptBillType.getValue();
                if (billType != null && "50957179-0105-1000-e000-015bc0a812fd463ED552".equals(billType.getId().toString())) {
                    VMISettleOptConditionUI.this.kdlcCustomer.setVisible(true);
                } else {
                    VMISettleOptConditionUI.this.kdlcCustomer.setVisible(false);
                }
            }
        });
        this.prmtWarehouse.setEnabledMultiSelection(true);
        this.prmtCustomer.setEnabledMultiSelection(true);
        SCMClientUtils.addListenerForMultiF7((KDBizPromptBox)this.bizPrmtMaterialFrom, (KDBizPromptBox)this.bizPrmtMaterialTo);
    }

    private void setWarehouseFilter() {
        Set orgSetIds = VMISettleClientUtils.getBizPromptF7SelectIds(this.bizPromptStorageOrgUnit);
        if (orgSetIds == null || orgSetIds.size() == 0) {
            orgSetIds = this.souIDs;
        }
        if (orgSetIds != null && orgSetIds.size() > 0) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)orgSetIds, CompareType.INCLUDE));
            view.setFilter(filter);
            this.prmtWarehouse.setEntityViewInfo(view);
            this.prmtWarehouse.getQueryAgent().resetRuntimeEntityView();
        }
    }

    protected void setDefaultValue() {
        this.setDefaultCompanyOrgUnit(this.bizPromptCompanyOrgUnit);
        this.bizPromptStorageOrgUnit.setData(null);
        this.setDefaultBillType();
        this.bizPromptSupplier.setData(null);
        this.bizPrmtMaterialFrom.setData(null);
        this.bizPrmtMaterialTo.setData(null);
        VMISettleClientUtils.formatStartTime(this.bizDateFrom);
        VMISettleClientUtils.formatEndTime(this.bizDateTo);
        this.setDefaultSettleDate();
        this.prmtCustomer.setData(null);
        this.prmtWarehouse.setData(null);
    }

    private void setDefaultCompanyOrgUnit(KDBizPromptBox box) {
        try {
            CalculateClientUtil.InitCompanyF7((KDBizPromptBox)box, (String)this.getViewPermission());
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException ex) {
            this.handUIException(ex);
        }
    }

    private void setDefaultBillType() {
        IBillType iBillType = null;
        BillTypeInfo aBillTypeInfo = null;
        ObjectUuidPK pk = null;
        if (this.bizPromptBillType.getData() == null) {
            try {
                iBillType = BillTypeFactory.getRemoteInstance();
                pk = new ObjectUuidPK("50957179-0105-1000-e000-0163c0a812fd463ED552");
                aBillTypeInfo = iBillType.getBillTypeInfo((IObjectPK)pk);
                this.bizPromptBillType.setData((Object)aBillTypeInfo);
            }
            catch (EASBizException e) {
                this.handUIException(e);
            }
            catch (BOSException e1) {
                this.handUIException(e1);
            }
        }
    }

    private void setDefaultSettleDate() {
        try {
            this.kdtSettleDate.setValue((Object)SCMClientUtils.getServerDate());
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    @Override
    protected void bizPromptCompanyUnit_dataChanged(DataChangeEvent e) throws Exception {
        Object couObj = this.bizPromptCompanyOrgUnit.getValue();
        if (couObj == null) {
            this.bizPromptCompanyOrgUnit.setData(e.getOldValue());
        }
        this.bizPromptStorageOrgUnit.setValue(null);
        this.bizPromptSupplier.setValue(null);
        this.bizPrmtMaterialFrom.setValue(null);
        this.bizPrmtMaterialTo.setValue(null);
        Set idSet = VMISettleClientUtils.getBizPromptF7SelectIds(this.bizPromptCompanyOrgUnit);
        if (idSet != null && idSet.size() > 0) {
            this.souIDs = VMISettleClientUtils.getStorageOrgUnitInfos(idSet);
            if (this.souIDs != null && this.souIDs.size() > 0) {
                this.setStorageOrgUnitFilter(this.bizPromptStorageOrgUnit, this.souIDs);
                this.setMaterialFilter(this.bizPrmtMaterialFrom, this.souIDs, true);
                this.setMaterialFilter(this.bizPrmtMaterialTo, this.souIDs, false);
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("companyOrgUnit.id", (Object)idSet, CompareType.INCLUDE));
                view.setFilter(filter);
                this.prmtCustomer.setEntityViewInfo(view);
            }
            this.setSupplierFilter(this.bizPromptSupplier, idSet);
        }
    }

    protected void bizPromptStorageOrgUnit_dataChanged(DataChangeEvent e) throws Exception {
        Object couObj = this.bizPromptStorageOrgUnit.getValue();
        if (couObj == null) {
            this.bizPromptStorageOrgUnit.setData(e.getOldValue());
        }
        this.bizPrmtMaterialFrom.setValue(null);
        this.bizPrmtMaterialTo.setValue(null);
        Set souIDs = VMISettleClientUtils.getBizPromptF7SelectIds(this.bizPromptStorageOrgUnit);
        if (souIDs.size() > 0) {
            this.setMaterialFilter(this.bizPrmtMaterialFrom, souIDs, true);
            this.setMaterialFilter(this.bizPrmtMaterialTo, souIDs, false);
        }
    }

    @Override
    public void bizPromptCompanyOrgUnit_preChange(PreChangeEvent e) {
        if (e.getData() == null) {
            this.bizPromptBillType.requestFocus();
            MsgBox.showInfo((String)this.getResource("CompanyOrgUnitNotNull"));
            e.setResult(0);
            return;
        }
    }

    @Override
    public void bizPromptBillType_preChange(PreChangeEvent e) {
        if (e.getData() == null) {
            this.bizPromptBillType.requestFocus();
            MsgBox.showInfo((String)this.getResource("BillTypeNotNull"));
            e.setResult(0);
            return;
        }
    }

    private void setStorageOrgUnitFilter(KDBizPromptBox box, Set storageIDs) {
        if (storageIDs.size() > 0) {
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)storageIDs, CompareType.INCLUDE));
            viewInfo.setFilter(filter);
            box.setEntityViewInfo(viewInfo);
        }
    }

    private void setMaterialFilter(KDBizPromptBox box, Set storageIDs, boolean isMulti) {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("status", (Object)String.valueOf(UsedStatusEnum.APPROVED.getValue()), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("Inventory.status", (Object)String.valueOf(UsedStatusEnum.APPROVED.getValue()), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("StorageOrgUnit.id", (Object)storageIDs, CompareType.INCLUDE));
        view.setFilter(filterInfo);
        box.setQueryInfo("com.kingdee.eas.basedata.master.material.app.F7MaterialInventoryQuery");
        box.setEntityViewInfo(view);
        box.setCommitFormat("$number$");
        box.setDisplayFormat("$number$");
        box.setEditFormat("$name$");
        F7MaterialMultiUISelectorAdaptor selectorAdaptor = SCMGroupClientUtils.setBizMaterialF7((KDBizPromptBox)box, (Component)((Object)this), (OrgType)this.getMainBizOrgType(), (boolean)isMulti, (String)"com.kingdee.eas.basedata.master.material.app.F7MaterialInventoryNoGroupQuery");
        selectorAdaptor.setIsMultiSelect(isMulti);
        box.setCommitParser((IParser)new MainDataParser(box));
        box.setSelector((KDPromptSelector)selectorAdaptor);
        box.addSelectorListener((SelectorListener)selectorAdaptor);
    }

    private void setSupplierFilter(KDBizPromptBox box, Set couSet) throws Exception {
        if (couSet != null && couSet.size() > 0) {
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("companyOrgUnit.id", (Object)couSet, CompareType.INCLUDE));
            filterInfo.getFilterItems().add(new FilterItemInfo("usedStatus", (Object)new Integer(UsedStatusEnum.APPROVED.getValue()), CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("supplierCompany.isFreezePayment", (Object)false, CompareType.EQUALS));
            evi.setFilter(filterInfo);
            String queryInfo = "com.kingdee.eas.basedata.master.cssp.app.F7SupplierCompanyQuery";
            box.setQueryInfo(queryInfo);
            box.setEntityViewInfo(evi);
            box.setCommitFormat("$number$");
            box.setDisplayFormat("$name$");
            box.setEditFormat("$number$");
            GeneralKDPromptSelectorAdaptor selectorAdaptor = new GeneralKDPromptSelectorAdaptor((KDPromptBox)box, "com.kingdee.eas.basedata.master.cssp.client.F7SupplierTreeDetailListUI", (Object)this, CSSPGroupInfo.getBosType(), queryInfo, "browseGroup.id", "companyOrgUnit.id");
            selectorAdaptor.setIsMultiSelect(true);
            box.setCommitParser((IParser)new MainDataParser(box));
            box.setSelector((KDPromptSelector)selectorAdaptor);
            box.addSelectorListener((SelectorListener)selectorAdaptor);
        } else {
            this.setBizSupplierF7(box, null);
        }
    }

    private void setBillTypeFilter(KDBizPromptBox box) throws Exception {
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("50957179-0105-1000-e000-0163c0a812fd463ED552");
        hashSet.add("50957179-0105-1000-e000-0177c0a812fd463ED552");
        hashSet.add("50957179-0105-1000-e000-015bc0a812fd463ED552");
        filter.getFilterItems().add(new FilterItemInfo("id", hashSet, CompareType.INCLUDE));
        ev.setFilter(filter);
        box.setEntityViewInfo(ev);
    }

    public RptParams getCustomCondition() {
        RptParams para = new RptParams();
        para.setObject("companyOrgUnit", this.bizPromptCompanyOrgUnit.getValue());
        para.setObject("storageOrgUnit", this.bizPromptStorageOrgUnit.getValue());
        para.setObject("billType", this.bizPromptBillType.getValue());
        para.setObject("supplier", this.bizPromptSupplier.getValue());
        para.setObject("materialFrom", this.bizPrmtMaterialFrom.getValue());
        para.setObject("materialTo", this.bizPrmtMaterialTo.getValue());
        para.setObject("bizDateFrom", this.bizDateFrom.getValue());
        para.setObject("bizDateTo", this.bizDateTo.getValue());
        para.setObject("settleDate", this.kdtSettleDate.getValue());
        para.setObject("warehouse", this.prmtWarehouse.getValue());
        para.setObject("customer", this.prmtCustomer.getValue());
        return para;
    }

    public void setCustomCondition(RptParams params) {
        this.bizPromptCompanyOrgUnit.setValue(params.getObject("companyOrgUnit"));
        this.bizPromptStorageOrgUnit.setValue(params.getObject("storageOrgUnit"));
        this.bizPromptBillType.setValue(params.getObject("billType"));
        this.bizPromptSupplier.setValue(params.getObject("supplier"));
        this.bizPrmtMaterialFrom.setValue(params.getObject("materialFrom"));
        this.bizPrmtMaterialTo.setValue(params.getObject("materialTo"));
        this.bizDateFrom.setValue(params.getObject("bizDateFrom"));
        this.bizDateTo.setValue(params.getObject("bizDateTo"));
        this.kdtSettleDate.setValue(params.getObject("settleDate"));
        this.prmtWarehouse.setValue(params.getObject("warehouse"));
        this.prmtCustomer.setValue(params.getObject("customer"));
    }

    public CustomerParams getCustomerParams() {
        CustomerParams customerParams = new CustomerParams();
        ReportQueryConditionHelper.fillCustomerParams((CustomerParams)customerParams, (Container)((Object)this));
        return customerParams;
    }

    public void setCustomerParams(CustomerParams cp) {
        if (cp != null && cp.getCustomerParam("RPTPARAMS_KEY_AT_CUSTOMERPARAMS") != null) {
            return;
        }
        this.clear();
        HashMap query = new HashMap();
        HashMap isMulti = new HashMap();
        this.fillComponent((Container)((Object)this), cp, query, isMulti);
        try {
            SCMFetchData fetchData = this.getFetchData(query, isMulti);
            ReportQueryConditionHelper.fillComponent((Container)((Object)this), (CustomerParams)cp, (SCMFetchData)fetchData);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    private void fillComponent(Container container, CustomerParams params, Map query, Map isMulti) {
        Component[] components = container.getComponents();
        if (components != null && components.length != 0) {
            for (int i = 0; i < components.length; ++i) {
                if (components[i] instanceof KDLabel) continue;
                if (components[i] instanceof KDBizPromptBox) {
                    if (params.getCustomerParam(((KDBizPromptBox)components[i]).getName()) == null) continue;
                    query.put(params.getCustomerParam(((KDBizPromptBox)components[i]).getName()), ((KDBizPromptBox)components[i]).getQueryInfo());
                    isMulti.put(params.getCustomerParam(((KDBizPromptBox)components[i]).getName()), ((KDBizPromptBox)components[i]).isEnabledMultiSelection());
                    continue;
                }
                if (!(components[i] instanceof Container)) continue;
                this.fillComponent((Container)components[i], params, query, isMulti);
            }
        }
    }

    private SCMFetchData getFetchData(Map query, Map isMulti) throws Exception {
        SCMFetchDataCondition condition = new SCMFetchDataCondition();
        condition.setIsFetchRptConditionData(true);
        HashMap<String, Object> initPara = new HashMap<String, Object>();
        initPara.put("Condition", condition);
        initPara.put("FetchRptConditionData", query);
        initPara.put("isEnabledMultiSelection", isMulti);
        return SCMFetchDataFacadeFactory.getRemoteInstance().fetchData(null, initPara);
    }

    public boolean verify() {
        Object[] obj;
        if (this.bizPromptCompanyOrgUnit.getData() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)this.getResource("CompanyOrgUnitNotNull"));
            return false;
        }
        if (this.bizPromptCompanyOrgUnit.getData() instanceof Object[] && (obj = (Object[])this.bizPromptCompanyOrgUnit.getData()).length > 0 && obj[0] == null) {
            MsgBox.showWarning((Component)((Object)this), (String)this.getResource("CompanyOrgUnitNotNull"));
            return false;
        }
        if (this.bizPromptBillType.getData() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)this.getResource("BillTypeNotNull"));
            return false;
        }
        if (this.bizDateFrom.getValue() != null && this.bizDateTo.getValue() != null) {
            Date dateFrom = (Date)this.bizDateFrom.getValue();
            Date dateTo = (Date)this.bizDateTo.getValue();
            if (dateFrom.getTime() > dateTo.getTime()) {
                MsgBox.showWarning((Component)((Object)this), (String)this.getResource("DateRangeError"));
                return false;
            }
        }
        if (this.kdtSettleDate.getValue() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)this.getResource("SettleDateNotNull"));
            return false;
        }
        return true;
    }

    protected String getPropertyOfMainBizOrg() {
        return "companyOrgUnit.id";
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.bizPromptCompanyOrgUnit;
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Company;
    }

    protected String getViewPermission() {
        return "vmisettle_settle";
    }

    private String getResource(String key) {
        return EASResource.getString((String)"com.kingdee.eas.scm.im.inv.vmi.VMISettleResource", (String)key);
    }
}

