/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.vmi.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.IParser;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.master.cssp.CSSPGroupInfo;
import com.kingdee.eas.basedata.master.cssp.MainDataParser;
import com.kingdee.eas.basedata.master.cssp.UsedStatusEnum;
import com.kingdee.eas.basedata.master.material.client.F7MaterialMultiUISelectorAdaptor;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.cal.util.CalculateClientUtil;
import com.kingdee.eas.scm.common.client.GeneralKDPromptSelectorAdaptor;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.client.SCMGroupClientUtils;
import com.kingdee.eas.scm.common.filter.ColConnFilterElement;
import com.kingdee.eas.scm.common.filter.CompositeFilterElement;
import com.kingdee.eas.scm.common.filter.FilterElement;
import com.kingdee.eas.scm.common.filter.MultiF7FilterElement;
import com.kingdee.eas.scm.common.filter.RangeFilterElement;
import com.kingdee.eas.scm.common.filter.SingleFilterElement;
import com.kingdee.eas.scm.common.verify.VerifyItem;
import com.kingdee.eas.scm.common.verify.VerifyType;
import com.kingdee.eas.scm.im.inv.client.InvClientUtils;
import com.kingdee.eas.scm.im.inv.vmi.client.AbstractVMISettleReportConditionUI;
import com.kingdee.eas.scm.im.inv.vmi.client.VMISettleClientUtils;
import com.kingdee.eas.scm.im.inv.vmi.client.VMISettleReportUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.util.Date;
import java.util.Set;
import org.apache.log4j.Logger;

public class VMISettleReportConditionUI
extends AbstractVMISettleReportConditionUI {
    private static final Logger logger = CoreUIObject.getLogger(VMISettleReportConditionUI.class);
    private VMISettleReportUI reportUI = null;
    private Set souIDs;

    public VMISettleReportConditionUI(VMISettleReportUI reportUI) throws Exception {
        this.reportUI = reportUI;
        this.addEventListener();
        this.getElementsInfo();
    }

    private void getElementsInfo() {
        CompositeFilterElement elements = new CompositeFilterElement(0);
        elements.add((FilterElement)new RangeFilterElement("number", (Component)this.numberFrom, (Component)this.numberTo));
        elements.add((FilterElement)new RangeFilterElement("supplier.number", (Component)this.bizPrmtSupplierFrom, (Component)this.bizPrmtSupplierTo));
        elements.add((FilterElement)new RangeFilterElement("material.number", (Component)this.bizPrmtMaterialFrom, (Component)this.bizPrmtMaterialTo));
        elements.add((FilterElement)new SingleFilterElement("warehouse.number", (Component)this.prmtWarehouse));
        RangeFilterElement dateElements = new RangeFilterElement("settleDate", (Component)this.kdtSettleDateFrom, (Component)this.kdtSettleDateTo);
        elements.add((FilterElement)dateElements);
        MultiF7FilterElement storageOrgUnitElement = new MultiF7FilterElement("storageOrgUnit.id", this.bizStorageOrgUnit);
        elements.add((FilterElement)storageOrgUnitElement);
        ColConnFilterElement mainOrgElement = new ColConnFilterElement("companyOrgUnit1.id", (Component)this.bizPromptCompanyOrgUnit);
        mainOrgElement.addVerifyItem(new VerifyItem(VerifyType.REQUIRED_TYPE, InvClientUtils.getResource("CompanyOrgUnitNotNull")));
        elements.add((FilterElement)mainOrgElement);
        this.getFilterManager().setElement((FilterElement)elements);
        this.getFilterManager().setMainOrgElement((FilterElement)mainOrgElement, "companyOrgUnit1.id");
    }

    protected void addEventListener() {
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.afterLoad();
    }

    private void afterLoad() {
        this.setDefaultValue();
        SCMClientUtils.setMainBizOrgF7forSealUp((KDBizPromptBox)this.bizPromptCompanyOrgUnit, (OrgType)this.getMainBizOrgType(), (String)this.getViewPermission());
        this.prmtWarehouse.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                VMISettleReportConditionUI.this.setWarehouseFilter();
            }
        });
        this.prmtWarehouse.setEnabledMultiSelection(true);
    }

    private void setWarehouseFilter() {
        Set stoOrgs = VMISettleClientUtils.getBizPromptF7SelectIds(this.bizStorageOrgUnit);
        if (stoOrgs == null || stoOrgs.size() == 0) {
            stoOrgs = this.souIDs;
        }
        if (stoOrgs != null && stoOrgs.size() > 0) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)stoOrgs, CompareType.INCLUDE));
            view.setFilter(filter);
            this.prmtWarehouse.setEntityViewInfo(view);
            this.prmtWarehouse.getQueryAgent().resetRuntimeEntityView();
        }
    }

    public void afterMainOrgChanged(String ids) {
        Set idSet = VMISettleClientUtils.getBizPromptF7SelectIds(this.bizPromptCompanyOrgUnit);
        if (idSet != null && idSet.size() > 0) {
            try {
                this.souIDs = VMISettleClientUtils.getStorageOrgUnitInfos(idSet);
                if (this.souIDs != null && this.souIDs.size() > 0) {
                    this.setStorageOrgUnitFilter(this.bizStorageOrgUnit, this.souIDs);
                    this.setMaterialFilter(this.bizPrmtMaterialFrom, this.souIDs);
                    this.setMaterialFilter(this.bizPrmtMaterialTo, this.souIDs);
                }
                this.setSupplierFilter(this.bizPrmtSupplierFrom, idSet);
                this.setSupplierFilter(this.bizPrmtSupplierFrom, idSet);
            }
            catch (Exception ex) {
                this.handUIException(ex);
            }
        }
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.bizPromptCompanyOrgUnit;
    }

    protected String getPropertyOfMainBizOrg() {
        return "companyOrgUnit1.id";
    }

    protected void bizPromptStorageOrgUnit_dataChanged(DataChangeEvent e) throws Exception {
        Object couObj = this.bizStorageOrgUnit.getValue();
        if (couObj == null) {
            this.bizStorageOrgUnit.setData(e.getOldValue());
        }
        this.bizPrmtMaterialFrom.setValue(null);
        this.bizPrmtMaterialTo.setValue(null);
        Set souIDs = VMISettleClientUtils.getBizPromptF7SelectIds(this.bizStorageOrgUnit);
        if (souIDs.size() > 0) {
            this.setMaterialFilter(this.bizPrmtMaterialFrom, souIDs);
            this.setMaterialFilter(this.bizPrmtMaterialTo, souIDs);
        }
    }

    private void setSupplierFilter(KDBizPromptBox box, Set couSet) throws Exception {
        if (couSet != null && couSet.size() > 0) {
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("companyOrgUnit.id", (Object)couSet, CompareType.INCLUDE));
            filterInfo.getFilterItems().add(new FilterItemInfo("usedStatus", (Object)new Integer(UsedStatusEnum.APPROVED.getValue()), CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("supplierCompany.isFreezePayment", (Object)false, CompareType.EQUALS));
            evi.setFilter(filterInfo);
            String queryInfo = "com.kingdee.eas.basedata.master.cssp.app.F7SupplierCompanyQuery";
            box.setQueryInfo(queryInfo);
            box.setEntityViewInfo(evi);
            box.setCommitFormat("$number$");
            box.setDisplayFormat("$number$");
            box.setEditFormat("$number$");
            GeneralKDPromptSelectorAdaptor selectorAdaptor = new GeneralKDPromptSelectorAdaptor((KDPromptBox)box, "com.kingdee.eas.basedata.master.cssp.client.F7SupplierTreeDetailListUI", (Object)this, CSSPGroupInfo.getBosType(), queryInfo, "browseGroup.id", "companyOrgUnit.id");
            box.setCommitParser((IParser)new MainDataParser(box));
            box.setSelector((KDPromptSelector)selectorAdaptor);
            box.addSelectorListener((SelectorListener)selectorAdaptor);
        } else {
            this.setBizSupplierF7(box, null);
        }
    }

    private void setStorageOrgUnitFilter(KDBizPromptBox box, Set storageIDs) {
        if (storageIDs.size() > 0) {
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)storageIDs, CompareType.INCLUDE));
            viewInfo.setFilter(filter);
            box.setEntityViewInfo(viewInfo);
        }
    }

    private void setMaterialFilter(KDBizPromptBox box, Set storageIDs) {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("status", (Object)String.valueOf(UsedStatusEnum.APPROVED.getValue()), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("Inventory.status", (Object)String.valueOf(UsedStatusEnum.APPROVED.getValue()), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("StorageOrgUnit.id", (Object)storageIDs, CompareType.INCLUDE));
        view.setFilter(filterInfo);
        box.setQueryInfo("com.kingdee.eas.basedata.master.material.app.F7MaterialInventoryQuery");
        box.setEntityViewInfo(view);
        box.setCommitFormat("$number$");
        box.setDisplayFormat("$name$");
        box.setEditFormat("$number$");
        F7MaterialMultiUISelectorAdaptor selectorAdaptor = SCMGroupClientUtils.setBizMaterialF7((KDBizPromptBox)box, (Component)((Object)this), (OrgType)this.getMainBizOrgType(), (boolean)false, (String)"com.kingdee.eas.basedata.master.material.app.F7MaterialInventoryNoGroupQuery");
        box.setCommitParser((IParser)new MainDataParser(box));
        box.setSelector((KDPromptSelector)selectorAdaptor);
        box.addSelectorListener((SelectorListener)selectorAdaptor);
    }

    protected void setDefaultValue() {
        this.bizPromptCompanyOrgUnit.setValue((Object)this.getDefaultMainBizOrg());
        this.bizStorageOrgUnit.setData(null);
        this.bizPrmtSupplierFrom.setData(null);
        this.bizPrmtSupplierTo.setData(null);
        this.bizPrmtMaterialFrom.setData(null);
        this.bizPrmtMaterialTo.setData(null);
        VMISettleClientUtils.formatStartTime(this.kdtSettleDateFrom);
        VMISettleClientUtils.formatEndTime(this.kdtSettleDateTo);
        this.numberFrom.setText(null);
        this.numberTo.setText(null);
        this.prmtWarehouse.setData(null);
    }

    private void setDefaultCompanyOrgUnit(KDBizPromptBox box) {
        try {
            CalculateClientUtil.InitCompanyF7((KDBizPromptBox)box, (String)this.getViewPermission());
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException ex) {
            this.handUIException(ex);
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public boolean verify() {
        Object[] obj;
        if (this.bizPromptCompanyOrgUnit.getData() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)this.getResource("CompanyOrgUnitNotNull"));
            return false;
        }
        if (this.bizPromptCompanyOrgUnit.getData() instanceof Object[] && (obj = (Object[])this.bizPromptCompanyOrgUnit.getData()).length > 0 && obj[0] == null) {
            MsgBox.showWarning((Component)((Object)this), (String)this.getResource("CompanyOrgUnitNotNull"));
            return false;
        }
        if (this.kdtSettleDateFrom.getValue() != null && this.kdtSettleDateTo.getValue() != null) {
            Date dateFrom = (Date)this.kdtSettleDateFrom.getValue();
            Date dateTo = (Date)this.kdtSettleDateTo.getValue();
            if (dateFrom.getTime() > dateTo.getTime()) {
                MsgBox.showWarning((Component)((Object)this), (String)this.getResource("DateRangeError"));
                return false;
            }
        }
        return true;
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Company;
    }

    protected String getViewPermission() {
        return "vmisettlerecord_view";
    }

    private String getResource(String key) {
        return EASResource.getString((String)"com.kingdee.eas.scm.im.inv.vmi.VMISettleResource", (String)key);
    }
}

