/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.vmi.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.resource.BizEnumInfo;
import com.kingdee.bos.metadata.resource.BizEnumValueType;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.assistant.ConvertModeEnum;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeAuxInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.ExchangeTableInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.scm.common.SCMBillCommonFacadeFactory;
import com.kingdee.eas.scm.im.inv.vmi.DataTypeEnum;
import com.kingdee.eas.scm.im.inv.vmi.FieldDefCollection;
import com.kingdee.eas.scm.im.inv.vmi.FieldDefFactory;
import com.kingdee.eas.scm.im.inv.vmi.FieldDefInfo;
import com.kingdee.eas.scm.im.inv.vmi.FieldEntryDefInfo;
import com.kingdee.eas.scm.im.inv.vmi.RelationTypeEnum;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class VMISettleUtil {
    public static FieldDefInfo loadFieldDefInfo(Context ctx, String bosType) throws EASBizException, BOSException {
        FieldDefInfo fieldDefInfo = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("billBosType", (Object)bosType, CompareType.EQUALS));
        SelectorItemCollection coll = new SelectorItemCollection();
        coll.add(new SelectorItemInfo("*"));
        coll.add(new SelectorItemInfo("entry.*"));
        coll.add(new SelectorItemInfo("query.*"));
        coll.add(new SelectorItemInfo("query.entry.*"));
        coll.add(new SelectorItemInfo("query.entry.parent.*"));
        coll.add(new SelectorItemInfo("query.entry.parentTable.*"));
        view.setFilter(filter);
        view.setSelector(coll);
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("entry.seq"));
        view.setSorter(sorter);
        FieldDefCollection fieldDefColl = null;
        fieldDefColl = ctx == null ? FieldDefFactory.getRemoteInstance().getFieldDefCollection(view) : FieldDefFactory.getLocalInstance(ctx).getFieldDefCollection(view);
        if (fieldDefColl.size() > 0) {
            fieldDefInfo = fieldDefColl.get(0);
        }
        return fieldDefInfo;
    }

    public static String getJoinSQL(RelationTypeEnum joinType) {
        String result = "";
        result = RelationTypeEnum.Inner_Join.equals((Object)joinType) ? " INNER JOIN " : (RelationTypeEnum.Left_Join.equals((Object)joinType) ? " LEFT JOIN " : " RIGHT JOIN ");
        return result;
    }

    public static String getDataTypeStr(Context ctx, FieldEntryDefInfo fieldInfo) {
        String dataType = "";
        if (fieldInfo.getDataType() == null) {
            return "Varchar(255)";
        }
        if (fieldInfo.getDataType().equals((Object)DataTypeEnum.String)) {
            dataType = "Varchar(255)";
        } else if (fieldInfo.getDataType().equals((Object)DataTypeEnum.Integer)) {
            dataType = "Int";
        } else if (fieldInfo.getDataType().equals((Object)DataTypeEnum.Date)) {
            dataType = "DateTime";
        } else if (fieldInfo.getDataType().equals((Object)DataTypeEnum.Boolean)) {
            dataType = "Int";
        } else if (fieldInfo.getDataType().equals((Object)DataTypeEnum.BOSUuid)) {
            dataType = "Varchar(44)";
        } else if (fieldInfo.getDataType().equals((Object)DataTypeEnum.BigDecimal)) {
            dataType = "Numeric(21, 10)";
        } else if (fieldInfo.getDataType().equals((Object)DataTypeEnum.Enum)) {
            String eClassName = fieldInfo.getEnumSource();
            IMetaDataLoader loader = null;
            loader = ctx == null ? MetaDataLoaderFactory.getRemoteMetaDataLoader() : MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
            BizEnumInfo bizEnum = (BizEnumInfo)loader.get(MetaDataTypeList.BIZENUM, (IMetaDataPK)MetaDataPK.create((String)eClassName));
            if (BizEnumValueType.INTEGER.equals((Object)bizEnum.getDataType())) {
                dataType = "Int";
            } else if (BizEnumValueType.STRING.equals((Object)bizEnum.getDataType())) {
                dataType = "Varchar(255)";
            }
        } else {
            dataType = "Varchar(255)";
        }
        return dataType;
    }

    public static Set getSelectIds(Object couObj) {
        HashSet<String> idSet = new HashSet<String>();
        CoreBaseInfo info = null;
        if (couObj != null && couObj instanceof Object[]) {
            Object[] obj = (Object[])couObj;
            int len = obj.length;
            for (int i = 0; i < len; ++i) {
                if (obj[i] instanceof Object[]) {
                    Object[] childObj = (Object[])obj[i];
                    int len2 = childObj.length;
                    for (int j = 0; j < len2; ++j) {
                        if (!(childObj[j] instanceof CoreBaseInfo) || (info = (CoreBaseInfo)childObj[j]) == null) continue;
                        idSet.add(info.getId().toString());
                    }
                    continue;
                }
                if (!(obj[i] instanceof CoreBaseInfo) || (info = (CoreBaseInfo)obj[i]) == null) continue;
                idSet.add(info.getId().toString());
            }
        } else if (couObj != null && couObj instanceof Object) {
            info = (CoreBaseInfo)couObj;
            idSet.add(info.getId().toString());
        }
        return idSet;
    }

    public static String getSqlIds(Collection ids) {
        if (ids == null || ids.size() == 0) {
            return null;
        }
        StringBuffer idSql = new StringBuffer();
        Iterator iter = ids.iterator();
        int i = 0;
        while (iter.hasNext()) {
            if (i == 0) {
                idSql.append("'").append(iter.next()).append("'");
            } else {
                idSql.append(",'").append(iter.next()).append("'");
            }
            ++i;
        }
        return idSql.toString();
    }

    public static boolean isAuthoriedForOrg(Context ctx, String companyOrgUnit, String userId, String permission) throws EASBizException, BOSException {
        if (null != companyOrgUnit && userId != null && permission != null) {
            FullOrgUnitCollection result = VMISettleUtil.getAuthOrgByPermItem(ctx, (IObjectPK)new ObjectUuidPK(userId), OrgType.Company, permission);
            for (int i = 0; null != result && i < result.size(); ++i) {
                if (!result.get(i).getId().toString().equals(companyOrgUnit)) continue;
                return true;
            }
        }
        return false;
    }

    public static FullOrgUnitCollection getAuthOrgByPermItem(Context ctx, IObjectPK user, OrgType orgType, String permItem) throws BOSException, EASBizException {
        FullOrgUnitCollection result = null;
        IPermission permission = null;
        permission = ctx == null ? PermissionFactory.getRemoteInstance() : PermissionFactory.getLocalInstance((Context)ctx);
        result = permission.getAuthorizedOrg(user, orgType, null, permItem);
        return result;
    }

    public static ExchangeRateInfo getExchangeRateInfo(Context ctx, CompanyOrgUnitInfo companyOrgUnitInfo, CurrencyInfo sourcecurrencyInfo, CurrencyInfo baseCurrency, Date bizDate) throws EASBizException, BOSException {
        if (companyOrgUnitInfo == null || sourcecurrencyInfo == null || baseCurrency == null) {
            return null;
        }
        ExchangeRateInfo defaultExchangeRateInfo = null;
        defaultExchangeRateInfo = new ExchangeRateInfo();
        ExchangeAuxInfo auxInfo = new ExchangeAuxInfo();
        auxInfo.setConvertMode(ConvertModeEnum.DIRECTEXCHANGERATE);
        auxInfo.setPrecision(2);
        defaultExchangeRateInfo.setConvertRate(BigDecimal.ONE);
        defaultExchangeRateInfo.setExchangeAux(auxInfo);
        CurrencyInfo baseCurrInfo = baseCurrency;
        ObjectUuidPK sourceCurrPK = null;
        ObjectUuidPK destCurrPK = null;
        sourceCurrPK = new ObjectUuidPK(sourcecurrencyInfo.getId());
        destCurrPK = new ObjectUuidPK(baseCurrInfo.getId());
        ExchangeRateInfo tempexrateinfo = null;
        if (baseCurrInfo.getId().equals((Object)sourcecurrencyInfo.getId())) {
            tempexrateinfo = defaultExchangeRateInfo;
        } else {
            ExchangeTableInfo exchangeTableInfo = companyOrgUnitInfo.getBaseExchangeTable();
            ObjectUuidPK excTablepk = null;
            if (exchangeTableInfo == null) {
                return null;
            }
            excTablepk = new ObjectUuidPK(exchangeTableInfo.getId());
            ExchangeRateInfo exchangeRateInfo = null;
            exchangeRateInfo = ctx == null ? SCMBillCommonFacadeFactory.getRemoteInstance().getCurrentExchangeRate((IObjectPK)excTablepk, (IObjectPK)sourceCurrPK, (IObjectPK)destCurrPK, bizDate) : SCMBillCommonFacadeFactory.getLocalInstance((Context)ctx).getCurrentExchangeRate((IObjectPK)excTablepk, (IObjectPK)sourceCurrPK, (IObjectPK)destCurrPK, bizDate);
            if (tempexrateinfo == null) {
                tempexrateinfo = defaultExchangeRateInfo;
            }
        }
        return tempexrateinfo;
    }
}

