/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.vrule;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.common.util.SCMUtil;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.framework.validator.bizrule.app.AbstractServerVRule;
import com.kingdee.eas.scm.im.inv.InvBillBaseEntryInfo;
import com.kingdee.eas.scm.im.inv.InvBillBaseInfo;
import com.kingdee.eas.scm.im.inv.PurInWarehsBillInfo;
import com.kingdee.eas.scm.im.inv.SaleIssueBillInfo;
import java.math.BigDecimal;
import java.text.MessageFormat;

public class CheckAmountPrecisionVRule
extends AbstractServerVRule {
    private final String res = "com.kingdee.eas.scm.im.inv.DataValidCheckResource";
    private final Context ctx;

    public CheckAmountPrecisionVRule(Context ctx) {
        super(ctx);
        this.ctx = ctx;
    }

    public boolean supports(Class<? extends IObjectValue> clazz) {
        return InvBillBaseInfo.class.isAssignableFrom(clazz);
    }

    public void validate(IObjectValue bean) throws BOSException, EASBizException {
        InvBillBaseInfo bill = (InvBillBaseInfo)bean;
        AbstractObjectCollection entrys = (AbstractObjectCollection)bill.get("entry");
        if (entrys == null) {
            entrys = (AbstractObjectCollection)bill.get("entries");
        }
        int basePrecision = this.getBaseCurrencyPrecision(entrys);
        StringBuilder errorMsg = new StringBuilder();
        this.checkAmountPrecision(errorMsg, basePrecision, bill.getBillType().getId().toString(), entrys, 1);
        if (bean instanceof PurInWarehsBillInfo || bean instanceof SaleIssueBillInfo) {
            int precision = this.getCurrencyPrecision(bill);
            this.checkAmountPrecision(errorMsg, precision, bill.getBillType().getId().toString(), entrys, 0);
        }
        if (errorMsg.length() > 0) {
            throw new BOSException("\n\r" + errorMsg.toString());
        }
    }

    private void checkAmountPrecision(StringBuilder msg, int precision, String billTypeId, AbstractObjectCollection entrys, int checkType) throws BOSException {
        String[] checkFields = this.getCheckFields(billTypeId, checkType);
        StringBuilder checkRs = this.doCheckPrecision(entrys, checkFields, precision);
        if (checkRs.length() > 0) {
            String checkErrorType = checkType == 0 ? SCMUtils.getResource((String)"com.kingdee.eas.scm.im.inv.DataValidCheckResource", (String)"CURRENCY_PRECISION_DIFF", (Context)this.ctx) : SCMUtils.getResource((String)"com.kingdee.eas.scm.im.inv.DataValidCheckResource", (String)"BASE_CURRENCY_PRECISON_DIFF", (Context)this.ctx);
            msg.append(MessageFormat.format(checkErrorType, precision));
            msg.append((CharSequence)checkRs);
        }
    }

    public StringBuilder doCheckPrecision(AbstractObjectCollection entrys, String[] checkFields, int precision) throws BOSException {
        String entryPrecisionDetail = SCMUtils.getResource((String)"com.kingdee.eas.scm.im.inv.DataValidCheckResource", (String)"ENTRY_PRECISION_DETAIL", (Context)this.ctx);
        StringBuilder msg = new StringBuilder();
        try {
            for (int i = 0; i < entrys.size(); ++i) {
                InvBillBaseEntryInfo entry = (InvBillBaseEntryInfo)entrys.getObject(i);
                for (String field : checkFields) {
                    BigDecimal value = entry.getBigDecimal(field);
                    if (value == null || (value = value.stripTrailingZeros()).scale() <= precision) continue;
                    EntityObjectInfo billEntryEntity = SCMUtil.getEntityObjectByBosType((BOSObjectType)entry.getBOSType());
                    PropertyInfo propertyInfo = billEntryEntity.getFieldByFullName(field);
                    String fieldsAlias = propertyInfo.getAlias();
                    msg.append(MessageFormat.format(entryPrecisionDetail, i + 1, entry.getMaterial().getNumber(), fieldsAlias, value.scale()));
                }
            }
            return msg;
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    protected String[] getCheckFields(String billTypeId, int checkType) {
        if (checkType == 0) {
            if ("50957179-0105-1000-e000-015fc0a812fd463ED552".equals(billTypeId)) {
                return new String[]{"amount", "tax", "taxAmount", "discountAmount"};
            }
            if ("50957179-0105-1000-e000-015bc0a812fd463ED552".equals(billTypeId)) {
                return new String[]{"nonTaxAmount", "tax", "amount", "discountAmount"};
            }
        } else {
            if ("50957179-0105-1000-e000-015fc0a812fd463ED552".equals(billTypeId)) {
                return new String[]{"localAmount", "localTax", "localTaxAmount", "purchaseFee", "purchaseCost", "actualCost"};
            }
            if ("50957179-0105-1000-e000-0167c0a812fd463ED552".equals(billTypeId)) {
                return new String[]{"actualCost"};
            }
            if ("50957179-0105-1000-e000-0172c0a812fd463ED552".equals(billTypeId)) {
                return new String[]{"actualCost"};
            }
            if ("50957179-0105-1000-e000-017bc0a812fd463ED552".equals(billTypeId)) {
                return new String[]{"actualCost"};
            }
            if ("50957179-0105-1000-e000-015bc0a812fd463ED552".equals(billTypeId)) {
                return new String[]{"localNonTaxAmount", "localTax", "localAmount", "actualCost"};
            }
            if ("50957179-0105-1000-e000-0163c0a812fd463ED552".equals(billTypeId)) {
                return new String[]{"actualCost"};
            }
            if ("50957179-0105-1000-e000-016ec0a812fd463ED552".equals(billTypeId)) {
                return new String[]{"actualCost"};
            }
            if ("50957179-0105-1000-e000-0177c0a812fd463ED552".equals(billTypeId)) {
                return new String[]{"actualCost"};
            }
            if ("3a3b5446-0106-1000-e000-01bcc0a812e6463ED552".equals(billTypeId)) {
                return new String[]{"amount"};
            }
            if ("528d806a-0106-1000-e000-0194c0a812e6463ED552".equals(billTypeId)) {
                return new String[]{"amount"};
            }
        }
        return null;
    }

    private int getBaseCurrencyPrecision(AbstractObjectCollection entrys) throws BOSException {
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)entrys.getObject(0).get("companyOrgUnit");
        if (company.getBaseCurrency() == null || company.getBaseCurrency().get("precision") == null) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)company.getId().toString()));
            view.setFilter(filterInfo);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("baseCurrency.precision"));
            view.setSelector(sic);
            CompanyOrgUnitCollection coll = CompanyOrgUnitFactory.getLocalInstance((Context)this.ctx).getCompanyOrgUnitCollection(view);
            return coll.get(0).getBaseCurrency().getPrecision();
        }
        return company.getBaseCurrency().getPrecision();
    }

    private int getCurrencyPrecision(InvBillBaseInfo bill) throws BOSException {
        CurrencyInfo currency = (CurrencyInfo)bill.get("currency");
        if (currency.get("precision") == null) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)currency.getId().toString()));
            view.setFilter(filterInfo);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("precision"));
            view.setSelector(sic);
            CurrencyCollection collection = CurrencyFactory.getLocalInstance((Context)this.ctx).getCurrencyCollection(view);
            return collection.get(0).getPrecision();
        }
        return currency.getPrecision();
    }
}

