/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.ws.util;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.data.logging.Logger;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.data.ColumnCollection;
import com.kingdee.bos.metadata.data.ColumnInfo;
import com.kingdee.bos.metadata.data.DataTableInfo;
import com.kingdee.bos.metadata.entity.EntityObjectCollection;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.permission.BasePMException;
import com.kingdee.eas.base.uiframe.EASLoginException;
import com.kingdee.eas.base.uiframe.client.LoginHelper;
import com.kingdee.eas.base.uiframe.client.UIConfig;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfo;
import com.kingdee.eas.basedata.master.material.MaterialCostInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialInventoryInfo;
import com.kingdee.eas.basedata.master.material.MaterialPurchasingInfo;
import com.kingdee.eas.basedata.master.material.MaterialSalesInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.scm.im.inv.InventoryInfo;
import com.kingdee.eas.scm.im.inv.ManufactureRecBillEntryInfo;
import com.kingdee.eas.scm.im.inv.ManufactureRecBillInfo;
import com.kingdee.eas.scm.im.inv.OtherIssueBillEntryInfo;
import com.kingdee.eas.scm.im.inv.OtherIssueBillInfo;
import com.kingdee.eas.scm.im.inv.PurInWarehsBillInfo;
import com.kingdee.eas.scm.im.inv.PurInWarehsEntryInfo;
import com.kingdee.eas.scm.im.inv.SaleIssueBillInfo;
import com.kingdee.eas.scm.im.inv.SaleIssueEntryInfo;
import com.kingdee.eas.scm.im.inv.StockTransferBillEntryInfo;
import com.kingdee.eas.scm.im.inv.StockTransferBillInfo;
import com.kingdee.eas.scm.im.inv.ws.ExportObject;
import com.kingdee.eas.scm.im.inv.ws.util.XMLUtil;
import com.kingdee.eas.util.client.EASResource;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Properties;
import javax.swing.tree.MutableTreeNode;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.BasicConfigurator;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.RichTextString;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class MetaUtil {
    private static ArrayList filters = null;
    private static ArrayList entityFilters = null;
    public static final String TAG_BOSTYPE = "bosType";
    public static final String TAG_ALIAS = "alias";
    public static final String TAG_NAME = "name";
    public static final String TAG_FULLNAME = "fullName";
    public static final String TAG_METAENTITY = "metaEntity";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean exportEntityToXml(Context ctx, IMetaDataLoader loader, BOSObjectType billbosType, BOSObjectType billEntitybosType, String filePath) throws Exception {
        if (billbosType == null || loader == null) {
            return false;
        }
        Properties prop = new Properties();
        if (loader != null) {
            EntityObjectInfo billEntityInfo = loader.getEntity(billbosType);
            EntityObjectInfo billEntityEntryInfo = null;
            if (billEntitybosType != null) {
                billEntityEntryInfo = loader.getEntity(billEntitybosType);
            }
            Document doc = XMLUtil.builderDocument();
            Element rootElement = null;
            if (billEntityInfo != null) {
                rootElement = doc.createElement(billEntityInfo.getName());
                Element billHeadElement = doc.createElement("billHead");
                rootElement.appendChild(billHeadElement);
                doc.appendChild(rootElement);
                MetaUtil.buildEntityXml(billEntityInfo, doc, billHeadElement, prop);
            }
            if (billEntityEntryInfo != null) {
                if (rootElement == null) {
                    rootElement = doc.createElement(billEntityEntryInfo.getName());
                    doc.appendChild(rootElement);
                }
                Element billEntiesElement = doc.createElement("billEntries");
                Element billEntry = doc.createElement("entry");
                billEntiesElement.appendChild(billEntry);
                rootElement.appendChild(billEntiesElement);
                MetaUtil.buildEntityXml(billEntityEntryInfo, doc, billEntry, prop);
            }
            filePath = filePath.endsWith("\\") || filePath.endsWith("/") || filePath.endsWith(File.separator) ? filePath + billEntityInfo.getName() + ".xml" : filePath + File.separator + billEntityInfo.getName() + ".xml";
            try (FileOutputStream out = new FileOutputStream(filePath + ".properties");){
                prop.store(out, "");
            }
            return XMLUtil.writeXmlFile((String)filePath, (Document)doc);
        }
        return false;
    }

    private static boolean buildEntityXml(EntityObjectInfo entityInfo, Document doc, Element parent, Properties prop) throws ParserConfigurationException {
        if (entityInfo == null || doc == null || parent == null) {
            return false;
        }
        PropertyCollection properties = entityInfo.getEntityProperties();
        Element propertyElement = null;
        String propValue = null;
        String alias = null;
        for (int i = 0; properties != null && i < properties.size(); ++i) {
            PropertyInfo propertyInfo = properties.get(i);
            if (filters.contains(propertyInfo.getName().toLowerCase(Locale.ENGLISH))) continue;
            propertyElement = doc.createElement(propertyInfo.getName());
            alias = propertyInfo.getAlias();
            if (alias == null || alias.trim().length() == 0) {
                alias = "defalut alias";
            }
            propertyElement.appendChild(doc.createComment(alias));
            parent.appendChild(propertyElement);
            propValue = "\"" + propertyInfo.getName() + "\";";
            prop.setProperty(propertyInfo.getName().toUpperCase(), propValue);
        }
        return true;
    }

    public static boolean exportEntityToFile(Context ctx, BOSObjectType billbosType, BOSObjectType billEntitybosType, String filePath, String fileExtend) throws Exception {
        if (billbosType == null) {
            return false;
        }
        IMetaDataLoader loader = null;
        loader = ctx == null ? MetaDataLoaderFactory.getRemoteMetaDataLoader() : MetaDataLoaderFactory.getMetaDataLoader((Context)ctx);
        return MetaUtil.exportEntityToFile(ctx, loader, billbosType, billEntitybosType, filePath, fileExtend);
    }

    public static boolean exportEntityToFile(Context ctx, IMetaDataLoader loader, BOSObjectType billbosType, BOSObjectType billEntitybosType, String filePath, String fileExtend) throws Exception {
        if (billbosType == null || loader == null) {
            return false;
        }
        if (fileExtend != null && fileExtend.equalsIgnoreCase("xml")) {
            MetaUtil.exportEntityToXml(ctx, loader, billbosType, billEntitybosType, filePath);
        } else {
            MetaUtil.exportEntityToExcel(ctx, loader, billbosType, billEntitybosType, filePath);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exportEntityToExcel(Context ctx, IMetaDataLoader loader, BOSObjectType billbosType, BOSObjectType billEntitybosType, String filePath) throws IOException {
        if (loader != null) {
            EntityObjectInfo billEntityInfo = loader.getEntity(billbosType);
            HSSFWorkbook wb = new HSSFWorkbook();
            HSSFSheet headSheet = MetaUtil.createSheet(wb, EASResource.getString((String)"com.kingdee.eas.scm.im.IMAutoGenerateResource", (String)"102_MetaUtil"), 1, 5);
            MetaUtil.initSheetHead(headSheet);
            if (billEntityInfo != null) {
                MetaUtil.buildExcel(billEntityInfo, headSheet);
            }
            if (billEntitybosType != null) {
                HSSFSheet entrySheet = MetaUtil.createSheet(wb, EASResource.getString((String)"com.kingdee.eas.scm.im.IMAutoGenerateResource", (String)"103_MetaUtil"), 1, 5);
                MetaUtil.initSheetHead(entrySheet);
                EntityObjectInfo billEntityEntryInfo = loader.getEntity(billEntitybosType);
                MetaUtil.buildExcel(billEntityEntryInfo, entrySheet);
            }
            filePath = filePath.endsWith("\\") || filePath.endsWith("/") || filePath.endsWith(File.separator) ? filePath + billEntityInfo.getName() + ".xls" : filePath + File.separator + billEntityInfo.getName() + ".xls";
            try (FileOutputStream out = new FileOutputStream(filePath);){
                wb.write((OutputStream)out);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exportEntityToExcel(Context ctx, IMetaDataLoader loader, BOSObjectType entitybosType, String filePath, String title) throws IOException {
        if (loader != null) {
            File file;
            EntityObjectInfo billEntityInfo = loader.getEntity(entitybosType);
            HSSFWorkbook wb = new HSSFWorkbook();
            HSSFSheet headSheet = MetaUtil.createSheet(wb, title, 1, 8);
            MetaUtil.initSheetHead(headSheet);
            if (billEntityInfo != null) {
                MetaUtil.buildExcel(billEntityInfo, headSheet);
            }
            if (!(file = new File(filePath)).exists()) {
                file.mkdirs();
            }
            String tableName = billEntityInfo.getTable() == null ? billEntityInfo.getName() : billEntityInfo.getTable().getName();
            tableName = tableName + "---" + billEntityInfo.getAlias();
            filePath = filePath.endsWith("\\") || filePath.endsWith("/") || filePath.endsWith(File.separator) ? filePath + tableName + ".xls" : filePath + File.separator + tableName + ".xls";
            try (FileOutputStream out = new FileOutputStream(filePath);){
                wb.write((OutputStream)out);
            }
        }
    }

    private static boolean buildExcel(EntityObjectInfo entityInfo, HSSFSheet sheet) {
        if (entityInfo == null || sheet == null) {
            return false;
        }
        PropertyCollection properties = entityInfo.getEntityProperties();
        PropertyInfo propertyInfo = null;
        DataTableInfo tables = entityInfo.getTable();
        HSSFRow row = null;
        HSSFCell cell = null;
        String dataType = null;
        int columnCount = 8;
        ColumnInfo mapField = null;
        for (int i = 0; properties != null && i < properties.size(); ++i) {
            propertyInfo = properties.get(i);
            row = sheet.createRow(i + 1);
            MetaUtil.createCell(row, columnCount);
            for (int j = 0; j < columnCount; ++j) {
                cell = row.getCell((int)((short)j));
                if (j == 0) {
                    cell.setCellType(CellType.STRING);
                    cell.setCellValue((RichTextString)new HSSFRichTextString(propertyInfo.getName()));
                    continue;
                }
                if (j == 1) {
                    cell.setCellType(CellType.STRING);
                    if (propertyInfo instanceof OwnPropertyInfo) {
                        dataType = ((OwnPropertyInfo)propertyInfo).getDataType().getJavaTypeName();
                    } else if (propertyInfo instanceof LinkPropertyInfo) {
                        dataType = "linkproperty";
                    }
                    cell.setCellValue((RichTextString)new HSSFRichTextString(dataType));
                    continue;
                }
                if (j == 2) {
                    cell.setCellType(CellType.STRING);
                    cell.setCellValue((RichTextString)new HSSFRichTextString(propertyInfo.getAlias()));
                    continue;
                }
                if (j == 3) {
                    mapField = propertyInfo.getMappingField();
                    if (mapField == null) continue;
                    cell.setCellType(CellType.STRING);
                    cell.setCellValue((RichTextString)new HSSFRichTextString(mapField.getName()));
                    continue;
                }
                if (j == 4) {
                    mapField = propertyInfo.getMappingField();
                    if (mapField == null) continue;
                    cell.setCellType(CellType.STRING);
                    cell.setCellValue((RichTextString)new HSSFRichTextString(MetaUtil.geSqlTypeName(tables, mapField.getName())));
                    continue;
                }
                if (j == 5) {
                    mapField = propertyInfo.getMappingField();
                    if (mapField == null) continue;
                    cell.setCellType(CellType.STRING);
                    cell.setCellValue((RichTextString)new HSSFRichTextString(MetaUtil.getSqlDataLeng(tables, mapField.getName())));
                    continue;
                }
                if (j == 6) {
                    mapField = propertyInfo.getMappingField();
                    if (mapField == null) continue;
                    cell.setCellType(CellType.STRING);
                    cell.setCellValue((RichTextString)new HSSFRichTextString(MetaUtil.getSqlDataPrecision(tables, mapField.getName())));
                    continue;
                }
                mapField = propertyInfo.getMappingField();
                if (mapField == null) continue;
                cell.setCellType(CellType.STRING);
                cell.setCellValue((RichTextString)new HSSFRichTextString(MetaUtil.getSqlDataScale(tables, mapField.getName())));
            }
        }
        return true;
    }

    private static String getSqlDataLeng(DataTableInfo tableInfo, String columnName) {
        ColumnCollection columnColl = (ColumnCollection)tableInfo.get("columns");
        ColumnInfo columnInfo = null;
        for (int i = 0; i < columnColl.size(); ++i) {
            columnInfo = columnColl.get(i);
            if (!columnInfo.getName().equals(columnName)) continue;
            return String.valueOf(columnInfo.getLength());
        }
        return "0";
    }

    private static String getSqlDataScale(DataTableInfo tableInfo, String columnName) {
        ColumnCollection columnColl = (ColumnCollection)tableInfo.get("columns");
        ColumnInfo columnInfo = null;
        for (int i = 0; i < columnColl.size(); ++i) {
            columnInfo = columnColl.get(i);
            if (!columnInfo.getName().equals(columnName)) continue;
            return String.valueOf(columnInfo.getScale());
        }
        return "0";
    }

    private static String getSqlDataPrecision(DataTableInfo tableInfo, String columnName) {
        ColumnCollection columnColl = (ColumnCollection)tableInfo.get("columns");
        ColumnInfo columnInfo = null;
        for (int i = 0; i < columnColl.size(); ++i) {
            columnInfo = columnColl.get(i);
            if (!columnInfo.getName().equals(columnName)) continue;
            return String.valueOf(columnInfo.getPrecision());
        }
        return "0";
    }

    public static String geSqlTypeName(DataTableInfo tableInfo, String columnName) {
        ColumnCollection columnColl = (ColumnCollection)tableInfo.get("columns");
        ColumnInfo columnInfo = null;
        for (int i = 0; i < columnColl.size(); ++i) {
            columnInfo = columnColl.get(i);
            if (!columnInfo.getName().equals(columnName)) continue;
            return columnInfo.getTypeName().getName();
        }
        return null;
    }

    public static HSSFSheet createSheet(HSSFWorkbook wb, String sheetName, int rowCount, int colCount) {
        HSSFSheet headSheet = wb.createSheet(sheetName);
        return MetaUtil.createRow(headSheet, rowCount, colCount);
    }

    public static HSSFSheet createRow(HSSFSheet sheet, int rowCount, int colCount) {
        HSSFRow row = null;
        if (sheet != null) {
            for (int i = 0; i < rowCount; ++i) {
                row = sheet.createRow(i);
                MetaUtil.createCell(row, colCount);
            }
        }
        return sheet;
    }

    public static HSSFRow createCell(HSSFRow row, int colCount) {
        if (row != null) {
            for (int i = 0; i < colCount; ++i) {
                row.createCell((int)((short)i));
            }
        }
        return row;
    }

    private static void initSheetHead(HSSFSheet sheet) {
        HSSFRow row = sheet.getRow(0);
        HSSFCell cell0 = row.getCell(0);
        HSSFCell cell1 = row.getCell(1);
        HSSFCell cell2 = row.getCell(2);
        HSSFCell cell3 = row.getCell(3);
        HSSFCell cell4 = row.getCell(4);
        HSSFCell cell5 = row.getCell(5);
        HSSFCell cell6 = row.getCell(6);
        HSSFCell cell7 = row.getCell(7);
        cell0.setCellType(CellType.STRING);
        cell0.setCellValue(EASResource.getString((String)"com.kingdee.eas.scm.im.IMAutoGenerateResource", (String)"104_MetaUtil"));
        cell1.setCellType(CellType.STRING);
        cell1.setCellValue(EASResource.getString((String)"com.kingdee.eas.scm.im.IMAutoGenerateResource", (String)"105_MetaUtil"));
        cell2.setCellType(CellType.STRING);
        cell2.setCellValue(EASResource.getString((String)"com.kingdee.eas.scm.im.IMAutoGenerateResource", (String)"106_MetaUtil"));
        cell3.setCellType(CellType.STRING);
        cell3.setCellValue(EASResource.getString((String)"com.kingdee.eas.scm.im.IMAutoGenerateResource", (String)"107_MetaUtil"));
        cell4.setCellType(CellType.STRING);
        cell4.setCellValue(EASResource.getString((String)"com.kingdee.eas.scm.im.IMAutoGenerateResource", (String)"108_MetaUtil"));
        cell5.setCellType(CellType.STRING);
        cell5.setCellValue(EASResource.getString((String)"com.kingdee.eas.scm.im.IMAutoGenerateResource", (String)"109_MetaUtil"));
        cell6.setCellType(CellType.STRING);
        cell6.setCellValue(EASResource.getString((String)"com.kingdee.eas.scm.im.IMAutoGenerateResource", (String)"110_MetaUtil"));
        cell7.setCellType(CellType.STRING);
        cell7.setCellValue(EASResource.getString((String)"com.kingdee.eas.scm.im.IMAutoGenerateResource", (String)"111_MetaUtil"));
    }

    public static void buildTreeNode(IMetaDataLoader loader, DefaultKingdeeTreeNode rootNode) {
        EntityObjectCollection entryCollection = loader.getEntityCollection();
        ExportObject nodeObject = null;
        DefaultKingdeeTreeNode childNode = null;
        EntityObjectInfo entityInfo = null;
        for (int i = 0; entryCollection != null && i < entryCollection.size(); ++i) {
            childNode = new DefaultKingdeeTreeNode();
            nodeObject = new ExportObject();
            entityInfo = entryCollection.get(i);
            if (!MetaUtil.isExportEntity(entityInfo)) continue;
            nodeObject.setAlias(entityInfo.getAlias());
            nodeObject.setBosType((String)entityInfo.get(TAG_BOSTYPE));
            nodeObject.setEntityName(entityInfo.getName());
            if (nodeObject.getAlias() == null) {
                childNode.setText(nodeObject.getEntityName());
            } else {
                childNode.setText(nodeObject.getAlias());
            }
            childNode.setUserObject((Object)nodeObject);
            rootNode.add((MutableTreeNode)childNode);
        }
    }

    public static void buildMetaTree(Document doc, DefaultKingdeeTreeNode rootNode) {
        NodeList childLists = doc.getElementsByTagName(TAG_METAENTITY);
        NodeList subchildList = null;
        ExportObject nodeObject = null;
        DefaultKingdeeTreeNode childNode = null;
        Element childEle = null;
        for (int i = 0; childLists != null && i < childLists.getLength(); ++i) {
            subchildList = childLists.item(i).getChildNodes();
            nodeObject = new ExportObject();
            childNode = new DefaultKingdeeTreeNode();
            for (int j = 0; subchildList != null && j < subchildList.getLength(); ++j) {
                if (subchildList.item(j).getNodeType() != 1 || (childEle = (Element)subchildList.item(j)).getFirstChild() == null) continue;
                if (childEle.getTagName().equals(TAG_ALIAS)) {
                    nodeObject.setAlias(childEle.getFirstChild().getNodeValue());
                    continue;
                }
                if (childEle.getTagName().equals(TAG_BOSTYPE)) {
                    nodeObject.setBosType(childEle.getFirstChild().getNodeValue());
                    continue;
                }
                if (!childEle.getTagName().equals(TAG_NAME)) continue;
                nodeObject.setEntityName(childEle.getFirstChild().getNodeValue());
            }
            if (nodeObject.getAlias() == null) {
                childNode.setText(nodeObject.getEntityName());
            } else {
                childNode.setText(nodeObject.getAlias());
            }
            childNode.setUserObject((Object)nodeObject);
            rootNode.add((MutableTreeNode)childNode);
        }
    }

    public static void buildMetaTable(Document doc, KDTable kdtbl) {
        NodeList childLists = doc.getElementsByTagName(TAG_METAENTITY);
        NodeList subchildList = null;
        IRow row = null;
        Element childEle = null;
        for (int i = 0; childLists != null && i < childLists.getLength(); ++i) {
            row = kdtbl.addRow();
            subchildList = childLists.item(i).getChildNodes();
            for (int j = 0; subchildList != null && j < subchildList.getLength(); ++j) {
                if (subchildList.item(j).getNodeType() != 1 || (childEle = (Element)subchildList.item(j)).getFirstChild() == null) continue;
                if (childEle.getTagName().equals(TAG_ALIAS)) {
                    row.getCell(1).setValue((Object)childEle.getFirstChild().getNodeValue());
                    continue;
                }
                if (childEle.getTagName().equals(TAG_BOSTYPE)) {
                    row.getCell(2).setValue((Object)childEle.getFirstChild().getNodeValue());
                    continue;
                }
                if (!childEle.getTagName().equals(TAG_NAME)) continue;
                row.getCell(0).setValue((Object)childEle.getFirstChild().getNodeValue());
            }
        }
        kdtbl.refresh();
        kdtbl.reLayoutAndPaint();
    }

    public static void buildEntityDoc(IMetaDataLoader loader, Document doc) {
        EntityObjectCollection entryCollection = loader.getEntityCollection();
        EntityObjectInfo entityInfo = null;
        Element child = null;
        Element tmpElement = null;
        Element rooElement = doc.createElement("metaRoot");
        doc.appendChild(rooElement);
        for (int i = 0; entryCollection != null && i < entryCollection.size(); ++i) {
            entityInfo = entryCollection.get(i);
            if (!MetaUtil.isExportEntity(entityInfo)) continue;
            child = doc.createElement(TAG_METAENTITY);
            tmpElement = doc.createElement(TAG_BOSTYPE);
            tmpElement.appendChild(doc.createTextNode((String)entityInfo.get(TAG_BOSTYPE)));
            child.appendChild(tmpElement);
            tmpElement = doc.createElement(TAG_NAME);
            tmpElement.appendChild(doc.createTextNode(entityInfo.getName()));
            child.appendChild(tmpElement);
            tmpElement = doc.createElement(TAG_ALIAS);
            if (entityInfo.getAlias() != null) {
                tmpElement.appendChild(doc.createTextNode(entityInfo.getAlias()));
            } else {
                tmpElement.appendChild(doc.createTextNode(entityInfo.getName()));
            }
            child.appendChild(tmpElement);
            tmpElement = doc.createElement(TAG_FULLNAME);
            tmpElement.appendChild(doc.createTextNode(entityInfo.getFullName()));
            child.appendChild(tmpElement);
            rooElement.appendChild(child);
        }
    }

    private static boolean isExportEntity(EntityObjectInfo entityInfo) {
        if (entityInfo != null) {
            for (EntityObjectInfo baseEntity = entityInfo.getBaseEntity(); baseEntity != null; baseEntity = baseEntity.getBaseEntity()) {
                if (!entityFilters.contains(baseEntity.getFullName())) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public static void myExport() {
        try {
            SaleIssueBillInfo issueInfo = new SaleIssueBillInfo();
            SaleIssueEntryInfo issueEntryInfo = new SaleIssueEntryInfo();
            MetaUtil.exportEntityToFile(null, issueInfo.getBOSType(), issueEntryInfo.getBOSType(), "D:/temp/bills/", "xml");
            MetaUtil.exportEntityToFile(null, issueInfo.getBOSType(), issueEntryInfo.getBOSType(), "D:/temp/bills/", null);
            ManufactureRecBillInfo manuInfo = new ManufactureRecBillInfo();
            ManufactureRecBillEntryInfo manuEntryInfo = new ManufactureRecBillEntryInfo();
            MetaUtil.exportEntityToFile(null, manuInfo.getBOSType(), manuEntryInfo.getBOSType(), "D:/temp/bills/", "xml");
            MetaUtil.exportEntityToFile(null, manuInfo.getBOSType(), manuEntryInfo.getBOSType(), "D:/temp/bills/", null);
            PurInWarehsBillInfo purWarehInfo = new PurInWarehsBillInfo();
            PurInWarehsEntryInfo purWareEntryhInfo = new PurInWarehsEntryInfo();
            MetaUtil.exportEntityToFile(null, purWarehInfo.getBOSType(), purWareEntryhInfo.getBOSType(), "D:/temp/bills/", "xml");
            MetaUtil.exportEntityToFile(null, purWarehInfo.getBOSType(), purWareEntryhInfo.getBOSType(), "D:/temp/bills/", null);
            OtherIssueBillInfo ortherOutInfo = new OtherIssueBillInfo();
            OtherIssueBillEntryInfo ortherOutEntryInfo = new OtherIssueBillEntryInfo();
            MetaUtil.exportEntityToFile(null, ortherOutInfo.getBOSType(), ortherOutEntryInfo.getBOSType(), "D:/temp/bills", "xml");
            MetaUtil.exportEntityToFile(null, ortherOutInfo.getBOSType(), ortherOutEntryInfo.getBOSType(), "D:/temp/bills", null);
            InventoryInfo invenToryInfo = new InventoryInfo();
            MetaUtil.exportEntityToFile(null, invenToryInfo.getBOSType(), null, "D:/temp/bills", "xml");
            MetaUtil.exportEntityToFile(null, invenToryInfo.getBOSType(), null, "D:/temp/bills", null);
            StockTransferBillInfo stockTransInfo = new StockTransferBillInfo();
            StockTransferBillEntryInfo entryInfo = new StockTransferBillEntryInfo();
            MetaUtil.exportEntityToFile(null, stockTransInfo.getBOSType(), entryInfo.getBOSType(), "D:/temp/bills", "xml");
            MetaUtil.exportEntityToFile(null, stockTransInfo.getBOSType(), entryInfo.getBOSType(), "D:/temp/bills", null);
        }
        catch (Exception e) {
            Logger.error((Throwable)e);
        }
    }

    public static void exportOtherMetaDataInfo() {
        try {
            SaleIssueBillInfo issueInfo = new SaleIssueBillInfo();
            SaleIssueEntryInfo issueEntryInfo = new SaleIssueEntryInfo();
            MetaUtil.exportEntityToFile(null, issueInfo.getBOSType(), issueEntryInfo.getBOSType(), "D:/temp/bills/", null);
            MaterialInfo info = new MaterialInfo();
            MetaUtil.exportEntityToFile(null, info.getBOSType(), null, "D:/temp/bills/", null);
            MaterialCompanyInfo companyInfo = new MaterialCompanyInfo();
            MetaUtil.exportEntityToFile(null, companyInfo.getType(), null, "D:/temp/bills/", null);
            MaterialInventoryInfo materInvInfo = new MaterialInventoryInfo();
            MetaUtil.exportEntityToFile(null, materInvInfo.getBOSType(), null, "D:/temp/bills/", null);
            MaterialSalesInfo materialSalesInfo = new MaterialSalesInfo();
            MetaUtil.exportEntityToFile(null, materialSalesInfo.getBOSType(), null, "D:/temp/bills/", null);
            MaterialPurchasingInfo materialPurchaseInfo = new MaterialPurchasingInfo();
            MetaUtil.exportEntityToFile(null, materialPurchaseInfo.getBOSType(), null, "D:/temp/bills/", null);
            MaterialCostInfo materCostingInfo = new MaterialCostInfo();
            MetaUtil.exportEntityToFile(null, materCostingInfo.getBOSType(), null, "D:/temp/bills/", null);
            MultiMeasureUnitInfo multiMeaureUnitInfo = new MultiMeasureUnitInfo();
            MetaUtil.exportEntityToFile(null, multiMeaureUnitInfo.getBOSType(), null, "D:/temp/bills/", null);
            BOSObjectType recBostype = BOSObjectType.create((String)"FA44FD5B");
            BOSObjectType recEntryBostype = BOSObjectType.create((String)"299A3BD7");
            MetaUtil.exportEntityToFile(null, recBostype, recEntryBostype, "D:/temp/bills/", null);
        }
        catch (Exception e) {
            Logger.error((Throwable)e);
        }
    }

    public static void main(String[] args) {
        BasicConfigurator.configure();
        try {
            Locale CHINESE = new Locale("L2");
            MetaDataLoaderFactory.setClientMetaDataPath((String)UIConfig.getMetaDataDir());
            LoginHelper.login((String)"yaya", (String)"", (String)"eas", (String)"wens1018", (Locale)CHINESE);
            MetaUtil.myExport();
        }
        catch (BasePMException e) {
            Logger.error((Throwable)e);
        }
        catch (EASLoginException e) {
            Logger.error((Throwable)e);
        }
    }

    static {
        filters = new ArrayList();
        filters.add("id");
        filters.add("entry");
        filters.add("parent");
        entityFilters = new ArrayList();
        entityFilters.add("com.kingdee.eas.framework.app.CoreBillBase");
        entityFilters.add("com.kingdee.eas.framework.app.CoreBillEntryBase");
        entityFilters.add("com.kingdee.eas.framework.app.DataBase");
    }
}

