/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.reservation;

import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.eas.ep.depend.MetadataUtils;
import com.kingdee.eas.scm.im.reservation.AbstractReservationSupplyObjectInfo;
import com.kingdee.eas.scm.im.reservation.model.BillReservationTableSettingCollection;
import com.kingdee.eas.scm.im.reservation.model.MatchPropertyCollection;
import com.kingdee.eas.scm.im.reservation.util.MDUtil;
import com.kingdee.eas.scm.util.string.StringUtil;
import java.io.Serializable;

public class ReservationSupplyObjectInfo
extends AbstractReservationSupplyObjectInfo
implements Serializable {
    private EntityObjectInfo billEntity;
    private MatchPropertyCollection matchPropColl;
    BillReservationTableSettingCollection tblSettingCollection = null;

    public ReservationSupplyObjectInfo() {
    }

    protected ReservationSupplyObjectInfo(String pkField) {
        super(pkField);
    }

    private void initEntity() {
        if (this.billEntity == null && !StringUtil.isEmpty((String)this.getBillFullName())) {
            this.billEntity = MetadataUtils.loadEntity((IMetaDataPK)MetaDataPK.create((String)this.getBillFullName()));
        }
    }

    public String getBillAlias() {
        if (StringUtil.isEmpty((String)this.getBillFullName())) {
            return null;
        }
        this.initEntity();
        return this.billEntity.getAlias();
    }

    public String getOrgFieldAlias() {
        if (StringUtil.isEmpty((String)this.getBillFullName()) || StringUtil.isEmpty((String)this.getOrgField())) {
            return null;
        }
        this.initEntity();
        return this.getBillAlias() + "." + MDUtil.getEntityPropertyAlias(this.billEntity, this.getOrgField());
    }

    public String getDateFieldAlias() {
        if (StringUtil.isEmpty((String)this.getBillFullName()) || StringUtil.isEmpty((String)this.getDateField())) {
            return null;
        }
        this.initEntity();
        return this.getBillAlias() + "." + MDUtil.getEntityPropertyAlias(this.billEntity, this.getDateField());
    }

    public MatchPropertyCollection getMatchPropertyCollection(String requestBillFullName) {
        if (this.matchPropColl == null) {
            this.matchPropColl = new MatchPropertyCollection(requestBillFullName, this.getBillFullName(), this.getMatchFilter());
        }
        return this.matchPropColl;
    }

    public FilterInfo getFilterInfo() throws Exception {
        FilterInfo filter = new FilterInfo(this.getDataFilter());
        return filter;
    }

    public SorterItemCollection getSorterItemCollection() throws ParserException {
        SorterItemCollection sorter = new SorterItemCollection();
        if (!StringUtil.isEmpty((String)this.getSortFields())) {
            sorter = new SorterItemCollection("order by " + this.getSortFields());
        }
        return sorter;
    }

    void initTblSettingCollection() {
        if (this.tblSettingCollection == null) {
            String settingStr = this.getBillTableSetting();
            this.tblSettingCollection = new BillReservationTableSettingCollection(settingStr);
        }
    }

    public String getBillIDFieldName() {
        this.initTblSettingCollection();
        return this.tblSettingCollection.getBillIDFieldName();
    }

    public String getEntryIDFieldName() {
        this.initTblSettingCollection();
        return this.tblSettingCollection.getEntryIDFieldName();
    }

    public String getEntryMaterialIDFieldName() {
        this.initTblSettingCollection();
        return this.tblSettingCollection.getEntryMaterialIDFieldName();
    }

    public String getBaseQtyFieldName() {
        this.initTblSettingCollection();
        return this.tblSettingCollection.getBaseQtyFieldName();
    }

    public String getEntryMaterialPropertyName() {
        this.initTblSettingCollection();
        return this.tblSettingCollection.getEntryMaterialPropertyName();
    }

    public String getBaseQtyPropertyName() {
        this.initTblSettingCollection();
        return this.tblSettingCollection.getBaseQtyPropertyName();
    }

    public String getAssistQtyPropertyName() {
        this.initTblSettingCollection();
        return this.tblSettingCollection.getAssistQtyPropertyName();
    }

    public String getAssistQtyFieldName() {
        this.initTblSettingCollection();
        return this.tblSettingCollection.getAssistQtyFieldName();
    }

    public String getOrderByStr() {
        this.initTblSettingCollection();
        return this.tblSettingCollection.getOrderByStr();
    }
}

