/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.reservation.client;

import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.CardinalityType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.entity.RelationshipType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.enums.Enum;
import com.kingdee.util.enums.EnumUtils;
import com.kingdee.util.enums.IntEnum;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BarcodeUtils {
    public static IMetaDataLoader loader = MetaDataLoaderFactory.getMetaDataLoader(null);
    public static final String PROPERTY_FULLNAME_KEY = "fullName";
    public static final String PROPERTY_SEQNO_KEY = "sequenceNumber";
    public static final String PROPERTY_FULLALIAS_KEY = "fullAlias";
    public static final String PROPERTY_LINKEDBOSTYPE = "linkedBosType";
    public static final SimpleDateFormat SIMPLE_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    public static final SimpleDateFormat SIMPLE_TIMESTAMP_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    public static Map entityMap = new HashMap();

    public static EntityObjectInfo getEntityByBosType(String bosType) {
        if (entityMap.get(bosType) != null) {
            return (EntityObjectInfo)entityMap.get(bosType);
        }
        EntityObjectInfo entity = loader.getEntity(BOSObjectType.create((String)bosType));
        if (entity != null) {
            entityMap.put(bosType, entity);
            return entity;
        }
        return null;
    }

    public static Map<String, EntityObjectInfo> getEntryName(EntityObjectInfo entity) {
        HashMap<String, EntityObjectInfo> map = new HashMap<String, EntityObjectInfo>();
        PropertyCollection headProColl = entity.getProperties();
        for (PropertyInfo property : headProColl) {
            RelationshipInfo relation;
            if (!(property instanceof LinkPropertyInfo) || (relation = ((LinkPropertyInfo)property).getRelationship()).getType() != RelationshipType.COMPOSITION && !Boolean.TRUE.toString().equalsIgnoreCase(property.getExtendedProperty("isEntries"))) continue;
            if (relation.getClientObject().getFullName().equals(entity.getFullName()) && (relation.getSupplierCardinality() == CardinalityType.ONE_TO_UNBOUNDED || relation.getSupplierCardinality() == CardinalityType.ZERO_TO_UNBOUNDED)) {
                map.put(property.getName(), relation.getSupplierObject());
                continue;
            }
            if (!relation.getSupplierObject().getFullName().equals(entity.getFullName()) || relation.getClientCardinality() != CardinalityType.ONE_TO_UNBOUNDED && relation.getClientCardinality() != CardinalityType.ZERO_TO_UNBOUNDED) continue;
            map.put(property.getName(), relation.getClientObject());
        }
        return map;
    }

    public static boolean isEntryProperty(EntityObjectInfo parent, PropertyInfo property) {
        RelationshipInfo relation;
        return !(parent == null || property == null || !(property instanceof LinkPropertyInfo) || (relation = ((LinkPropertyInfo)property).getRelationship()).getType() != RelationshipType.COMPOSITION && !Boolean.TRUE.toString().equalsIgnoreCase(property.getExtendedProperty("isEntries")) || !relation.getClientObject().getFullName().equals(parent.getFullName()) || relation.getSupplierCardinality() != CardinalityType.ONE_TO_UNBOUNDED && relation.getSupplierCardinality() != CardinalityType.ZERO_TO_UNBOUNDED);
    }

    public static EntityObjectInfo getEntityByProperty(EntityObjectInfo parent, PropertyInfo property) {
        RelationshipInfo relation;
        EntityObjectInfo result = null;
        if (parent != null && property != null && property instanceof LinkPropertyInfo && ((relation = ((LinkPropertyInfo)property).getRelationship()).getType() == RelationshipType.COMPOSITION || Boolean.TRUE.toString().equalsIgnoreCase(property.getExtendedProperty("isEntries"))) && relation.getClientObject().getFullName().equals(parent.getFullName()) && (relation.getSupplierCardinality() == CardinalityType.ONE_TO_UNBOUNDED || relation.getSupplierCardinality() == CardinalityType.ZERO_TO_UNBOUNDED)) {
            return relation.getSupplierObject();
        }
        return result;
    }

    public static PropertyInfo getSeqNoPropertyInfo() {
        PropertyInfo seqProperty = new PropertyInfo();
        seqProperty.setName(PROPERTY_SEQNO_KEY);
        seqProperty.setAlias(EASResource.getString((String)"com.kingdee.eas.scm.barcode.BARCODEAutoGenerateResource", (String)"81_BarcodeUtils"));
        seqProperty.put("dataType", (Object)"String");
        return seqProperty;
    }

    public static PropertyInfo getPropertyByMuch(String property, EntityObjectInfo entity) {
        if (entity == null) {
            return null;
        }
        if (property.equals(PROPERTY_SEQNO_KEY)) {
            return BarcodeUtils.getSeqNoPropertyInfo();
        }
        PropertyInfo propertyInfo = entity.getPropertyByName(property);
        if (property.indexOf(".") > -1) {
            String[] ss = property.split("\\.");
            propertyInfo = entity.getPropertyByName(ss[0]);
            EntityObjectInfo entry = BarcodeUtils.getEntityByProperty(entity, propertyInfo);
            property = property.substring(property.indexOf(".") + 1, property.length());
            return BarcodeUtils.getPropertyByMuch(property, entry);
        }
        return (PropertyInfo)propertyInfo.clone();
    }

    public static Object getEnum(List emList, String value) {
        for (int i = 0; i < emList.size(); ++i) {
            Enum e = (Enum)emList.get(i);
            String compare1 = e.getName();
            String compare2 = e.getAlias();
            String compare3 = null;
            if (e instanceof IntEnum) {
                compare3 = ((IntEnum)e).getValue() + "";
            }
            if (value == null || !value.equals(compare1) && !value.equals(compare2) && !value.equals(compare3)) continue;
            return emList.get(i);
        }
        return null;
    }

    public static Object getValue(IObjectValue easValue, PropertyInfo propertyInfo, String key) {
        String dataType = propertyInfo.getString("dataType");
        Object value = easValue.get(key);
        if (value != null) {
            if (propertyInfo instanceof LinkPropertyInfo) {
                return easValue.get("number");
            }
            if ("Enum".equals(dataType)) {
                return ((Enum)value).getName();
            }
            if ("Boolean".equals(dataType)) {
                return value;
            }
            if ("Date".equals(dataType) || "TimeStamp".equals(dataType)) {
                String date = null;
                try {
                    date = SIMPLE_DATE_FORMAT.format(value);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return date;
            }
            if ("BigDeciaml".equals(dataType)) {
                return new BigDecimal(value.toString());
            }
            if ("Integer".equals(dataType)) {
                return Integer.parseInt(value.toString());
            }
            return value;
        }
        return null;
    }

    public static void putValue(IObjectValue easValue, PropertyInfo propertyInfo, String key, Object value) {
        String dataType = propertyInfo.getString("dataType");
        if (value == null) {
            easValue.put(key, null);
        } else if ("Enum".equals(dataType)) {
            if (value instanceof java.lang.Enum) {
                easValue.put(key, value);
            } else {
                String enumClass = (String)propertyInfo.get("metadataRef");
                if (enumClass != null) {
                    List emList = EnumUtils.getEnumList((String)enumClass);
                    easValue.put(key, BarcodeUtils.getEnum(emList, value.toString()));
                }
            }
        } else if ("Boolean".equals(dataType)) {
            if (value instanceof Boolean) {
                easValue.put(key, value);
            } else if ("1".equals(value.toString()) || "true".equalsIgnoreCase(value.toString()) || EASResource.getString((String)"com.kingdee.eas.scm.barcode.BARCODEAutoGenerateResource", (String)"82_BarcodeUtils").equals(value.toString())) {
                easValue.put(key, (Object)Boolean.TRUE);
            } else {
                easValue.put(key, (Object)Boolean.FALSE);
            }
        } else if ("Date".equals(dataType) || "TimeStamp".equals(dataType)) {
            if (value instanceof Date) {
                easValue.put(key, value);
            } else {
                try {
                    Date date = SIMPLE_DATE_FORMAT.parse(value.toString());
                    easValue.put(key, (Object)date);
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
            }
        } else if ("BigDecimal".equals(dataType)) {
            if (value instanceof BigDecimal) {
                easValue.put(key, value);
            } else {
                try {
                    easValue.put(key, (Object)new BigDecimal(value.toString()));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        } else if ("Integer".equals(dataType)) {
            if (value instanceof Integer) {
                easValue.put(key, value);
            } else {
                try {
                    easValue.put(key, (Object)Integer.parseInt(value.toString()));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        } else {
            easValue.put(key, value);
        }
    }

    public static String unicodeEncode(String str) {
        str = str == null ? "" : str;
        StringBuffer sb = new StringBuffer(1000);
        sb.setLength(0);
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            sb.append("\\u");
            int j = c >>> 8;
            String tmp = Integer.toHexString(j);
            if (tmp.length() == 1) {
                sb.append("0");
            }
            sb.append(tmp);
            j = c & 0xFF;
            tmp = Integer.toHexString(j);
            if (tmp.length() == 1) {
                sb.append("0");
            }
            sb.append(tmp);
        }
        return new String(sb);
    }

    public static String unicodeDecode(String strText) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < strText.length()) {
            char c = strText.charAt(i);
            if (c == '\\' && i + 1 != strText.length() && strText.charAt(i + 1) == 'u') {
                sb.append((char)Integer.parseInt(strText.substring(i + 2, i + 6), 16));
                i += 6;
                continue;
            }
            sb.append(c);
            ++i;
        }
        return sb.toString();
    }
}

