/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.reservation.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDScrollBar;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ctrl.swing.event.PreChangeEvent;
import com.kingdee.bos.ctrl.swing.event.PreChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ep.depend.MetadataUtils;
import com.kingdee.eas.scm.framework.balance.BalanceFieldModelInfo;
import com.kingdee.eas.scm.framework.balance.BalanceModelFactory;
import com.kingdee.eas.scm.framework.balance.BalanceModelInfo;
import com.kingdee.eas.scm.framework.balance.client.BalanceFieldSelector;
import com.kingdee.eas.scm.framework.client.EntityPropertySelector;
import com.kingdee.eas.scm.im.reservation.client.IMatchFilter;
import com.kingdee.eas.scm.im.reservation.model.MatchProperty;
import com.kingdee.eas.scm.im.reservation.model.MatchPropertyCollection;
import com.kingdee.eas.scm.im.reservation.model.Property;
import com.kingdee.eas.scm.im.reservation.util.ReservationUtil;
import com.kingdee.eas.scm.util.string.StringUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JScrollBar;

public class CommonMatchFilterBalancePanel
extends KDPanel
implements IMatchFilter {
    private static final long serialVersionUID = 6165896786827481182L;
    private static final String commonFilterRes = "com.kingdee.eas.base.commonquery.client.CommonFilterPanel";
    protected static final String[] FILTER_COLUMN_CODEs = new String[]{"destField", "compareSign", "srcField"};
    protected static final String DEST_COLUMN_NAME = ReservationUtil.getResourceString("TARGETFIELD");
    protected static final String COMPARE_COLUMN_NAME = ReservationUtil.getResourceString("COMPARISON_OPERATOR");
    protected static final String SRC_COLUMN_NAME = ReservationUtil.getResourceString("SOURCEFIELD");
    protected static final int FILTER_DESTFIELD = 0;
    protected static final int FILTER_COMPARE_SIGN = 1;
    protected static final int FILTER_SRCFIELD = 2;
    protected static final String COMPARE_SIGN = "=";
    private int[] FILTER_COLUMN_WIDTHs;
    private int SMALL_BUTTON_WIDTH = 22;
    private int SMALL_BUTTON_HEIGHT = 19;
    private int SPACE = 3;
    private int SMALL_SPACE = 1;
    private IUIWindow owner;
    private KDTable kdtTable;
    private ICell currCell;
    private KDWorkButton addRowButton;
    private KDWorkButton delRowButton;
    private KDWorkButton clearButton;
    private MatchPropertyCollection matchColl;
    private MetaDataPK srcEntity;
    private MetaDataPK destEntity;
    private KDBizPromptBox srcPrmtBox;
    private KDBizPromptBox destPrmtBox;
    private int width;
    private int height;
    private int defaultRows;
    private String destTitle;
    private String srcTitle;
    private PreChangeListener fieldPreChangeListener;

    public CommonMatchFilterBalancePanel(IUIWindow owner, MetaDataPK srcEntity, MetaDataPK destEntity, int width, int height, int defaultRows, String destTitle, String srcTitle) {
        this(owner, srcEntity, destEntity, null, width, height, defaultRows, destTitle, srcTitle);
    }

    public CommonMatchFilterBalancePanel(IUIWindow owner, MetaDataPK srcEntity, MetaDataPK destEntity, int width, int height, int defaultRows) {
        this(owner, srcEntity, destEntity, null, width, height, defaultRows, DEST_COLUMN_NAME, SRC_COLUMN_NAME);
    }

    public CommonMatchFilterBalancePanel(IUIWindow owner, MetaDataPK srcEntity, MetaDataPK destEntity, MatchPropertyCollection matchColl, int width, int height, int defaultRows) {
        this(owner, srcEntity, destEntity, matchColl, width, height, defaultRows, DEST_COLUMN_NAME, SRC_COLUMN_NAME);
    }

    public CommonMatchFilterBalancePanel(IUIWindow owner, MetaDataPK srcEntity, MetaDataPK destEntity, MatchPropertyCollection matchColl, int width, int height, int defaultRows, String destTitle, String srcTitle) {
        this.owner = owner;
        this.srcEntity = srcEntity;
        this.destEntity = destEntity;
        this.matchColl = matchColl;
        this.width = width;
        this.height = height;
        this.defaultRows = defaultRows;
        this.destTitle = destTitle;
        this.srcTitle = srcTitle;
        this.FILTER_COLUMN_WIDTHs = this.calculateWidths();
        this.fieldPreChangeListener = new PreChangeListener(){

            public void preChange(PreChangeEvent e) {
                CommonMatchFilterBalancePanel.this.transFieldResult(e);
                e.setResult(1);
            }
        };
        this.jbInit();
    }

    private void jbInit() {
        this.setLayout(null);
        this.setPreferredSize(new Dimension(this.width, this.height));
        this.addRowButton = new KDWorkButton();
        this.addRowButton.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.addRowButton.setToolTipText(EASResource.getString((String)commonFilterRes, (String)"addRow"));
        this.addRowButton.setBounds(this.width - (this.SMALL_BUTTON_WIDTH + this.SPACE) * 3, this.SPACE, this.SMALL_BUTTON_WIDTH, this.SMALL_BUTTON_HEIGHT);
        this.addRowButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CommonMatchFilterBalancePanel.this.addRowButton_actionPerformed(e);
            }
        });
        this.add((Component)this.addRowButton);
        this.delRowButton = new KDWorkButton();
        this.delRowButton.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.delRowButton.setToolTipText(EASResource.getString((String)commonFilterRes, (String)"removeRow"));
        this.delRowButton.setBounds(this.width - (this.SMALL_BUTTON_WIDTH + this.SPACE) * 2, this.SPACE, this.SMALL_BUTTON_WIDTH, this.SMALL_BUTTON_HEIGHT);
        this.delRowButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CommonMatchFilterBalancePanel.this.delRowButton_actionPerformed(e);
            }
        });
        this.add((Component)this.delRowButton);
        this.clearButton = new KDWorkButton();
        this.clearButton.setIcon(EASResource.getIcon((String)"imgTbtn_clear"));
        this.clearButton.setToolTipText(EASResource.getString((String)commonFilterRes, (String)"clear"));
        this.clearButton.setBounds(this.width - this.SMALL_BUTTON_WIDTH - this.SPACE, this.SPACE, this.SMALL_BUTTON_WIDTH, this.SMALL_BUTTON_HEIGHT);
        this.clearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CommonMatchFilterBalancePanel.this.clearButton_actionPerformed(e);
            }
        });
        this.add((Component)this.clearButton);
        this.initTable();
        this.kdtTable.setBounds(this.SPACE, this.SPACE + this.SMALL_BUTTON_HEIGHT + this.SMALL_SPACE, this.width - this.SPACE * 2, this.height - this.SPACE * 3 - this.SMALL_BUTTON_HEIGHT);
        this.add((Component)this.kdtTable);
    }

    private int[] calculateWidths() {
        int unit = (this.width - this.SPACE * 2) / 6;
        return new int[]{2 * unit, unit, 2 * unit};
    }

    protected void initTable() {
        this.kdtTable = new KDTable();
        int columnSize = FILTER_COLUMN_CODEs.length;
        for (int i = 0; i < columnSize; ++i) {
            IColumn iColumn = this.kdtTable.addColumn();
            iColumn.setKey(FILTER_COLUMN_CODEs[i]);
            iColumn.setWidth(this.FILTER_COLUMN_WIDTHs[i]);
            if (i != 1) continue;
            iColumn.getStyleAttributes().setLocked(true);
        }
        IRow headRow = this.kdtTable.addHeadRow();
        headRow.getCell(0).setValue((Object)this.destTitle);
        headRow.getCell(1).setValue((Object)COMPARE_COLUMN_NAME);
        headRow.getCell(2).setValue((Object)this.srcTitle);
        this.initTableEditor();
        this.fillFilterTableBody();
        this.kdtTable.getLayoutManager().setVerticalScrollBar((JScrollBar)new KDScrollBar(1));
        this.kdtTable.getLayoutManager().setHorizonScrollBar((JScrollBar)new KDScrollBar(0));
        this.fillLeftRows();
        this.addTableListener();
    }

    protected void fillFilterTableBody() {
        if (this.matchColl == null || this.matchColl.getMatchPropertyList().size() == 0) {
            return;
        }
        IRow row = null;
        MatchProperty property = null;
        List<MatchProperty> matchPropertyList = this.matchColl.getMatchPropertyList();
        for (int i = 0; i < matchPropertyList.size(); ++i) {
            property = matchPropertyList.get(i);
            row = this.kdtTable.addRow(i);
            row.getCell(FILTER_COLUMN_CODEs[0]).setValue((Object)property.getDestProperty().getAlias());
            row.getCell(FILTER_COLUMN_CODEs[0]).setUserObject((Object)property.getDestProperty());
            row.getCell(FILTER_COLUMN_CODEs[1]).setValue((Object)COMPARE_SIGN);
            row.getCell(FILTER_COLUMN_CODEs[2]).setValue((Object)property.getSrcProperty().getAlias());
            row.getCell(FILTER_COLUMN_CODEs[2]).setUserObject((Object)property.getSrcProperty());
        }
    }

    private void fillLeftRows() {
        int rowCount = this.kdtTable.getRowCount();
        if (rowCount < this.defaultRows) {
            for (int i = 0; i < this.defaultRows - rowCount; ++i) {
                this.addRow();
            }
        }
    }

    protected void addTableListener() {
        this.kdtTable.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStarting(KDTEditEvent e) {
                CommonMatchFilterBalancePanel.this.currCell = CommonMatchFilterBalancePanel.this.kdtTable.getCell(e.getRowIndex(), e.getColIndex());
            }

            public void editStopped(KDTEditEvent e) {
                try {
                    CommonMatchFilterBalancePanel.this.kdtTable_editStopped(e);
                }
                catch (Exception e1) {
                    ExceptionHandler.handle((Throwable)e1);
                }
            }
        });
        this.kdtTable.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
            }
        });
    }

    private void transFieldResult(PreChangeEvent e) {
        if (e.getData() != null) {
            PropertyInfo property = (PropertyInfo)e.getData();
            BalanceFieldModelInfo fieldInfo = (BalanceFieldModelInfo)e.getData();
            e.setData((Object)property.get("fullAlias").toString());
            if (this.currCell != null && this.currCell.getColumnIndex() == 2) {
                this.currCell.setUserObject((Object)this.buildProperty(this.srcEntity.getFullName(), property));
            } else {
                this.currCell.setUserObject((Object)this.buildProperty(this.destEntity.getFullName(), property));
            }
        } else {
            e.setData(null);
            this.currCell.setUserObject(null);
        }
    }

    private Property buildProperty(String entity, PropertyInfo propInfo) {
        if (propInfo == null) {
            return null;
        }
        return new Property(entity, propInfo.get("fullName").toString());
    }

    protected void kdtTable_editStopped(KDTEditEvent e) throws Exception {
        this.increaseRow(e);
        this.editedCellAfter(e);
    }

    private void increaseRow(KDTEditEvent e) throws BOSException {
        Object object;
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        if (colIndex == 2 && rowIndex == this.kdtTable.getRowCount() - 1 && (object = this.kdtTable.getRow(rowIndex).getCell(2).getValue()) != null && object.toString() != null) {
            this.addRow();
        }
    }

    private void editedCellAfter(KDTEditEvent e) throws Exception {
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        Object object = this.kdtTable.getRow(rowIndex).getCell(colIndex).getValue();
        if (object == null) {
            if (colIndex == 0) {
                this.resetCell(this.kdtTable.getRow(rowIndex).getCell(1));
                this.resetCell(this.kdtTable.getRow(rowIndex).getCell(2));
            }
            return;
        }
        if (colIndex == 0) {
            this.kdtTable.getRow(rowIndex).getCell(1).setValue((Object)COMPARE_SIGN);
        }
    }

    private void resetCell(ICell iCell) {
        iCell.setEditor(null);
        iCell.setValue(null);
        if (iCell.getStyleAttributes() != null) {
            iCell.getStyleAttributes().setNumberFormat("");
        }
    }

    protected void addRowButton_actionPerformed(ActionEvent e) {
        this.addRow();
    }

    protected void delRowButton_actionPerformed(ActionEvent e) {
        int selectedRowIndex = this.kdtTable.getSelectManager().getActiveRowIndex();
        if (selectedRowIndex == -1) {
            MsgBox.showWarning((String)EASResource.getString((String)commonFilterRes, (String)"delWarning"));
        }
        this.delRow();
    }

    protected void clearButton_actionPerformed(ActionEvent e) {
        this.clear();
    }

    private void addRow() {
        int currentRowSize = this.kdtTable.getRowCount();
        this.kdtTable.addRow(currentRowSize);
    }

    protected void initTableEditor() {
        if (this.destEntity != null && !StringUtil.isEmpty((String)this.destEntity.getFullName())) {
            this.destPrmtBox = new KDBizPromptBox();
            this.destPrmtBox.setName("destPrmtBox");
            EntityObjectInfo destEntityInfo = MetadataUtils.loadEntity((IMetaDataPK)this.destEntity);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("*"));
            sic.add(new SelectorItemInfo("entry.*"));
            try {
                BalanceModelInfo balanceModelInfo = BalanceModelFactory.getRemoteInstance().getBalanceModelInfo((IObjectPK)new ObjectUuidPK("SOYjDrxMRamtGGENYUm98SPUYjI="), sic);
                BalanceFieldSelector selector = new BalanceFieldSelector(this.owner, balanceModelInfo, null);
                this.destPrmtBox.setSelector((KDPromptSelector)selector);
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
            this.kdtTable.getColumn(FILTER_COLUMN_CODEs[0]).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)this.destPrmtBox));
            this.destPrmtBox.addPreChangeListener(this.fieldPreChangeListener);
        }
        if (this.srcEntity != null && !StringUtil.isEmpty((String)this.srcEntity.getFullName())) {
            this.srcPrmtBox = new KDBizPromptBox();
            this.srcPrmtBox.setName("srcPrmtBox");
            EntityObjectInfo srcEntityInfo = MetadataUtils.loadEntity((IMetaDataPK)this.srcEntity);
            EntityPropertySelector selector = new EntityPropertySelector(this.owner, srcEntityInfo);
            this.srcPrmtBox.setSelector((KDPromptSelector)selector);
            this.kdtTable.getColumn(FILTER_COLUMN_CODEs[2]).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)this.srcPrmtBox));
            this.srcPrmtBox.addPreChangeListener(this.fieldPreChangeListener);
        }
    }

    public void reInitTable(MetaDataPK srcEntity, MetaDataPK destEntity) {
        this.srcEntity = srcEntity;
        this.destEntity = destEntity;
        this.reInitTable();
    }

    public void reInitTable() {
        this.remove((Component)this.kdtTable);
        this.initTable();
        this.kdtTable.setBounds(this.SPACE, this.SPACE + this.SMALL_BUTTON_HEIGHT + this.SMALL_SPACE, this.width - this.SPACE * 2, this.height - this.SPACE * 3 - this.SMALL_BUTTON_HEIGHT);
        this.add((Component)this.kdtTable);
        this.validate();
    }

    private void delRow() {
        int selectedRowIndex = this.kdtTable.getSelectManager().getActiveRowIndex();
        this.kdtTable.removeRow(selectedRowIndex);
    }

    protected void clearTable() {
        int rowCount;
        for (int i = rowCount = this.kdtTable.getRowCount(); i >= 0; --i) {
            this.kdtTable.removeRow(i);
        }
    }

    public void clear() {
        this.clearTable();
        this.fillLeftRows();
    }

    private boolean checkInvaildFilter() {
        IRow row = null;
        int rowCount = this.kdtTable.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            row = this.kdtTable.getRow(i);
            if ((row.getCell(FILTER_COLUMN_CODEs[0]).getValue() != null || row.getCell(FILTER_COLUMN_CODEs[2]).getValue() == null) && (row.getCell(FILTER_COLUMN_CODEs[0]).getValue() == null || row.getCell(FILTER_COLUMN_CODEs[2]).getValue() != null)) continue;
            return true;
        }
        return false;
    }

    @Override
    public MatchPropertyCollection getMatchFilter() {
        List<MatchProperty> filterList = this.innerGetMatchFilter();
        this.matchColl = new MatchPropertyCollection(this.srcEntity.getFullName(), this.destEntity.getFullName(), filterList);
        return this.matchColl;
    }

    @Override
    public void setMatchFilter(MatchPropertyCollection matchColl) {
        this.matchColl = matchColl;
    }

    protected List<MatchProperty> innerGetMatchFilter() {
        ArrayList<MatchProperty> filterList = new ArrayList<MatchProperty>();
        IRow row = null;
        MatchProperty matchProperty = null;
        int count = this.kdtTable.getRowCount();
        for (int i = 0; i < count; ++i) {
            row = this.kdtTable.getRow(i);
            if (this.isBlankRow(row)) continue;
            Property destProperty = (Property)row.getCell(FILTER_COLUMN_CODEs[0]).getUserObject();
            Property srcProperty = (Property)row.getCell(FILTER_COLUMN_CODEs[2]).getUserObject();
            matchProperty = new MatchProperty(srcProperty, destProperty);
            filterList.add(matchProperty);
        }
        return filterList;
    }

    private boolean isBlankRow(IRow row) {
        return row == null || row.getCell(FILTER_COLUMN_CODEs[0]).getValue() == null;
    }

    @Override
    public boolean verify() {
        if (this.checkInvaildFilter()) {
            String str = ReservationUtil.getResourceString("THE_CONDITION_OF_INCOMPLETE");
            MsgBox.showWarning((Component)((Object)this), (String)str);
            return false;
        }
        return true;
    }

    public MetaDataPK getSrcEntity() {
        return this.srcEntity;
    }

    public void setSrcEntity(MetaDataPK srcEntity) {
        this.srcEntity = srcEntity;
    }

    public MetaDataPK getDestEntity() {
        return this.destEntity;
    }

    public void setDestEntity(MetaDataPK destEntity) {
        this.destEntity = destEntity;
    }
}

