/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.reservation.client;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.SQLType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.query.QueryFieldInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.query.SelectorInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.ep.depend.MetadataUtils;
import com.kingdee.eas.scm.im.reservation.ReservationDirectionEnum;
import com.kingdee.eas.scm.im.reservation.SortTypeEnum;
import com.kingdee.eas.scm.im.reservation.client.AbstractNewTableSettingUI;
import com.kingdee.eas.scm.im.reservation.impl.ITableSetting;
import com.kingdee.eas.scm.im.reservation.model.BillReservationTableSettingCollection;
import com.kingdee.eas.scm.im.reservation.model.BillReservationTableSettingProperty;
import com.kingdee.eas.scm.im.reservation.util.ReservationUtil;
import com.kingdee.eas.scm.util.array.ArrayUtil;
import com.kingdee.eas.scm.util.collection.CollectionUtil;
import com.kingdee.eas.scm.util.string.StringUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JComboBox;
import javax.swing.event.ListSelectionEvent;
import org.apache.log4j.Logger;

public class NewTableSettingUI
extends AbstractNewTableSettingUI
implements KDTEditListener,
ITableSetting {
    private static final Logger logger = CoreUIObject.getLogger(NewTableSettingUI.class);
    private boolean isCancel = false;
    ItemListener itemChangeListener = null;
    private boolean isDefault = false;
    BillReservationTableSettingCollection tabSettingCollection = new BillReservationTableSettingCollection();
    int selectRowIndex = -1;
    private String reservation_billtype = "";
    private String billFullName = "";
    private String billQueryPK = "";
    private EntityObjectInfo parentObject = null;
    private EntityObjectInfo entryObject = null;
    private static Map<String, EntityObjectInfo> billEntityMap = new HashMap<String, EntityObjectInfo>();
    private static Map<String, EntityObjectInfo> entryEntityMap = new HashMap<String, EntityObjectInfo>();
    List<KDListProperty> unLoadList = new ArrayList<KDListProperty>();
    Map<String, KDListProperty> unLoadMap = new HashMap<String, KDListProperty>();
    public static final String TB_COLNAME_HEADNAME = "headName";
    public static final String TB_COLNAME_FIELDNAME = "fieldName";
    public static final String TB_COLNAME_ISSHOW = "isShow";
    public static final String TB_COLNAME_ISNUMERIC = "isNumeric";
    public static final String TB_COLNAME_COLUMNWIDTH = "columnWidth";
    public static final String TB_COLNAME_SORTTYPE = "sortType";

    @Override
    public boolean isCancel() {
        return this.isCancel;
    }

    public void setCancel(boolean isCancel) {
        this.isCancel = isCancel;
    }

    public NewTableSettingUI() throws Exception {
        this.itemChangeListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                NewTableSettingUI.this.comboItemChange(e);
            }
        };
    }

    void comboItemChange(ItemEvent e) {
        this.isDefault = false;
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected void btnConfirm_actionPerformed(ActionEvent e) throws Exception {
        super.btnConfirm_actionPerformed(e);
        if (this.isDefault && MsgBox.showConfirm2((String)ReservationUtil.getResourceString("SURE_USE_DEFAULT_SETTING")) != 0) {
            SysUtil.abort();
        }
        if (StringUtil.isEmpty((String)((BillReservationTableSettingProperty)this.comboBillID.getSelectedItem()).getFieldName())) {
            MsgBox.showWarning((String)ReservationUtil.getResourceString("PLEASE_SET_BILLID"));
            SysUtil.abort();
        }
        if (StringUtil.isEmpty((String)((BillReservationTableSettingProperty)this.comboEntryID.getSelectedItem()).getFieldName())) {
            if ("REQUIREBILL".equals(this.reservation_billtype)) {
                MsgBox.showWarning((String)ReservationUtil.getResourceString("PLEASE_SET_ENTRYID"));
                SysUtil.abort();
            } else if (MsgBox.showConfirm2((String)ReservationUtil.getResourceString("SURE_RESERVATION_BILLHEAD_MATERIAL")) != 0) {
                SysUtil.abort();
            }
        }
        if (StringUtil.isEmpty((String)((BillReservationTableSettingProperty)this.comboEntryMaterialID.getSelectedItem()).getFieldName())) {
            MsgBox.showWarning((String)ReservationUtil.getResourceString("PLEASE_SET_MATERIALID"));
        }
        if (StringUtil.isEmpty((String)((BillReservationTableSettingProperty)this.comboBaseQty.getSelectedItem()).getFieldName())) {
            MsgBox.showWarning((String)ReservationUtil.getResourceString("PLEASE_SET_BASEQTY"));
            SysUtil.abort();
        }
        if (StringUtil.isEmpty((String)((BillReservationTableSettingProperty)this.comboAssistQty.getSelectedItem()).getFieldName())) {
            // empty if block
        }
        this.fillTableSettingCollection();
        this.getTabSettingCollection();
        this.setCancel(false);
        this.destroyWindow();
    }

    public BillReservationTableSettingCollection getTabSettingCollection() {
        return this.tabSettingCollection;
    }

    @Override
    public String getTableSettingStr() {
        return this.tabSettingCollection.parse2SettingStr();
    }

    @Override
    public ReservationDirectionEnum getReservationDirection() {
        return null;
    }

    private void fillTableSettingCollection() {
        IRow row = null;
        BillReservationTableSettingProperty property = null;
        this.tabSettingCollection.clear();
        int rowCount = this.tblSetting.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            row = this.tblSetting.getRow(i);
            property = new BillReservationTableSettingProperty();
            if (row.getCell(TB_COLNAME_HEADNAME).getValue() == null) {
                property.setHeadName(ReservationUtil.getResourceString("PROPERTY_NAME_UNDEFINE"));
            } else {
                property.setHeadName(row.getCell(TB_COLNAME_HEADNAME).getValue().toString());
            }
            property.setFieldName(row.getCell(TB_COLNAME_FIELDNAME).getValue().toString());
            property.setNumeric(Boolean.valueOf(row.getCell(TB_COLNAME_ISNUMERIC).getValue().toString()));
            property.setColumnWidth(Integer.parseInt(row.getCell(TB_COLNAME_COLUMNWIDTH).getValue().toString()));
            property.setColumnSeq(i);
            property.setShow(true);
            if (row.getCell(TB_COLNAME_SORTTYPE).getValue() != null) {
                property.setSortType(((SortTypeEnum)((Object)row.getCell(TB_COLNAME_SORTTYPE).getValue())).getValue());
            } else {
                property.setSortType("");
            }
            this.tabSettingCollection.addProperty(property);
        }
        Map uiCtx = this.getUIContext();
        String billBosType = "";
        if (this.parentObject != null) {
            billBosType = this.parentObject.getType().toString();
        }
        String entryBosType = "";
        if (this.entryObject != null) {
            entryBosType = this.entryObject.getType().toString();
        }
        property = (BillReservationTableSettingProperty)this.comboBillID.getSelectedItem();
        property.setBillID(true);
        property.setSortType("NOSORT");
        this.tabSettingCollection.addProperty(property);
        property = (BillReservationTableSettingProperty)this.comboEntryID.getSelectedItem();
        String propertyName_entry = ReservationUtil.getBillEntryPropertyName(this.parentObject);
        property.setPropertyName(propertyName_entry);
        property.setEntryID(true);
        property.setSortType("NOSORT");
        this.tabSettingCollection.addProperty(property);
        property = (BillReservationTableSettingProperty)this.comboEntryMaterialID.getSelectedItem();
        property.setEntryMaterialID(true);
        property.setSortType("NOSORT");
        String field_material = property.getFieldName();
        String propertyName_material = ReservationUtil.getEntryFieldName(billBosType, entryBosType, this.billQueryPK, field_material);
        property.setPropertyName(propertyName_material);
        this.tabSettingCollection.addProperty(property);
        property = (BillReservationTableSettingProperty)this.comboAssistQty.getSelectedItem();
        property.setAssistQty(true);
        property.setSortType("NOSORT");
        String field_assistQty = property.getFieldName();
        String propertyName_assistQty = ReservationUtil.getEntryFieldName(billBosType, entryBosType, this.billQueryPK, field_assistQty);
        property.setPropertyName(propertyName_assistQty);
        this.tabSettingCollection.addProperty(property);
        property = (BillReservationTableSettingProperty)this.comboBaseQty.getSelectedItem();
        property.setBaseQty(true);
        property.setSortType("NOSORT");
        String field_baseQty = property.getFieldName();
        String propertyName_baseQty = ReservationUtil.getEntryFieldName(billBosType, entryBosType, this.billQueryPK, field_baseQty);
        property.setPropertyName(propertyName_baseQty);
        property.setShow(true);
        this.tabSettingCollection.addProperty(property);
    }

    @Override
    protected void btnCancelSetting_actionPerformed(ActionEvent e) throws Exception {
        super.btnCancelSetting_actionPerformed(e);
        this.setCancel(true);
        this.destroyWindow();
    }

    @Override
    protected void btnMoveUp_actionPerformed(ActionEvent e) throws Exception {
        super.btnMoveUp_actionPerformed(e);
        if (this.tblSetting.getRowCount() == 0 || this.tblSetting.getSelectManager().size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
        this.selectRowIndex = this.tblSetting.getSelectManager().get().getTop();
        this.tblSetting.moveRow(this.selectRowIndex, this.selectRowIndex - 1);
        this.tblSetting.getSelectManager().select(this.selectRowIndex - 1, 0);
    }

    @Override
    protected void btnMoveDown_actionPerformed(ActionEvent e) throws Exception {
        super.btnMoveDown_actionPerformed(e);
        if (this.tblSetting.getRowCount() == 0 || this.tblSetting.getSelectManager().size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
        this.selectRowIndex = this.tblSetting.getSelectManager().get().getTop();
        this.tblSetting.moveRow(this.selectRowIndex, this.selectRowIndex + 1);
        this.tblSetting.getSelectManager().select(this.selectRowIndex + 1, 0);
    }

    @Override
    protected void btnMoveTop_actionPerformed(ActionEvent e) throws Exception {
        super.btnMoveTop_actionPerformed(e);
        if (this.tblSetting.getRowCount() == 0 || this.tblSetting.getSelectManager().size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
        this.selectRowIndex = this.tblSetting.getSelectManager().get().getTop();
        this.tblSetting.moveRow(this.selectRowIndex, 0);
        this.tblSetting.getSelectManager().select(0, 0);
    }

    @Override
    protected void btnMoveBottom_actionPerformed(ActionEvent e) throws Exception {
        super.btnMoveBottom_actionPerformed(e);
        if (this.tblSetting.getRowCount() == 0 || this.tblSetting.getSelectManager().size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
        this.selectRowIndex = this.tblSetting.getSelectManager().get().getTop();
        this.tblSetting.moveRow(this.selectRowIndex, this.tblSetting.getRowCount() - 1);
        this.tblSetting.getSelectManager().select(this.tblSetting.getRowCount() - 1, 0);
    }

    void initListFrom() {
        Map uiCtx = this.getUIContext();
        IMetaDataPK billQueryPK = (IMetaDataPK)uiCtx.get("InitDataObject");
        if (billQueryPK == null) {
            SysUtil.abort();
        }
        try {
            this.listFrom.removeAllElements();
            QueryInfo query = MetadataUtils.loadQuery((IMetaDataPK)billQueryPK);
            SelectorInfo selectorInfo = query.getSelector();
            ArrayList fields = selectorInfo.getFields();
            KDListProperty property = null;
            for (QueryFieldInfo field : fields) {
                field.getRefPropertyName();
                if (field.getRefPropertyName().equalsIgnoreCase("id") || this.isUnLoadMapContainsProperty(field.getName())) continue;
                property = new KDListProperty();
                property.setDisplayName(field.getDisplayName());
                property.setFieldName(field.getName());
                property.setNumeric(field.getMappingFieldType() == SQLType.NUMERIC);
                this.listFrom.addElement((Object)property);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void selectItem(ListSelectionEvent e) {
        e.getFirstIndex();
    }

    void addItem(MouseEvent e) {
        e.getSource();
        this.listFrom.getSelectedValues();
    }

    void initCombox() throws Exception {
        BillReservationTableSettingProperty property = null;
        property = new BillReservationTableSettingProperty();
        this.comboBillID.addItem((Object)property);
        this.comboEntryID.addItem((Object)property);
        this.comboEntryMaterialID.addItem((Object)property);
        this.comboAssistQty.addItem((Object)property);
        this.comboBaseQty.addItem((Object)property);
        Map uiCtx = this.getUIContext();
        IMetaDataPK billQueryPK = (IMetaDataPK)uiCtx.get("InitDataObject");
        if (billQueryPK == null) {
            SysUtil.abort();
        }
        QueryInfo query = MetadataUtils.loadQuery((IMetaDataPK)billQueryPK);
        SelectorInfo selectorInfo = query.getSelector();
        ArrayList fields = selectorInfo.getFields();
        for (QueryFieldInfo field : fields) {
            if (field.getRefPropertyName().equalsIgnoreCase("id")) {
                property = new BillReservationTableSettingProperty();
                property.setFieldName(field.getName());
                property.setHeadName(field.getDisplayName());
                this.comboBillID.addItem((Object)property);
                this.comboEntryID.addItem((Object)property);
                this.comboEntryMaterialID.addItem((Object)property);
            }
            if (SQLType.NUMERIC != field.getMappingFieldType()) continue;
            property = new BillReservationTableSettingProperty();
            property.setFieldName(field.getName());
            property.setHeadName(field.getDisplayName());
            property.setNumeric(true);
            this.comboBaseQty.addItem((Object)property);
            this.comboAssistQty.addItem((Object)property);
        }
        this.initCombDefaultValue();
    }

    void initCombDefaultValue() {
        String propertyName_entry = ReservationUtil.getBillEntryPropertyName(this.parentObject);
        if (!StringUtil.isEmpty((String)propertyName_entry)) {
            propertyName_entry = propertyName_entry.toUpperCase();
        }
        String regex1 = "ID";
        String regex2 = propertyName_entry + "\\.ID";
        String regex30 = "MATERIAL.ID";
        String regex31 = "MATERIAL.ID|MATERIAL.*\\.ID|.*MATERIAL.*";
        String regex40 = propertyName_entry + "\\.BASEQTY";
        String regex41 = propertyName_entry + "\\.BASEQTY|.*BASEQTY|.*BASEUNITQTY|.*BASE";
        String regex50 = propertyName_entry + "\\.ASSISTQTY";
        String regex51 = propertyName_entry + "\\.ASSISTQTY|.*ASSISTQTY|.*ASSISTUNITQTY|.*ASSIST";
        this.doCombDefaultValue(this.comboBillID, regex1);
        this.doCombDefaultValue(this.comboEntryID, regex2);
        this.doCombDefaultValue(this.comboEntryMaterialID, regex30, regex31);
        this.doCombDefaultValue(this.comboBaseQty, regex40, regex41);
        this.doCombDefaultValue(this.comboAssistQty, regex50, regex51);
        this.isDefault = true;
    }

    void doCombDefaultValue(KDComboBox combo, Pattern pattern) {
        if (combo == null || pattern == null) {
            return;
        }
        BillReservationTableSettingProperty item = null;
        int count = combo.getItemCount();
        for (int i = 0; i < count; ++i) {
            Matcher matcher;
            item = (BillReservationTableSettingProperty)combo.getItemAt(i);
            if (item.getFieldName() == null || !(matcher = pattern.matcher(item.getFieldName().toUpperCase())).matches()) continue;
            combo.setSelectedIndex(i);
            return;
        }
    }

    void doCombDefaultValue(KDComboBox combo, String firstRegex, String secondRegex) {
        Matcher matcher;
        int i;
        if (combo == null || StringUtil.isEmpty((String)firstRegex)) {
            return;
        }
        Pattern pattern = Pattern.compile(firstRegex);
        BillReservationTableSettingProperty item = null;
        int count = combo.getItemCount();
        for (i = 0; i < count; ++i) {
            item = (BillReservationTableSettingProperty)combo.getItemAt(i);
            if (item.getFieldName() == null || !(matcher = pattern.matcher(item.getFieldName().toUpperCase())).matches()) continue;
            combo.setSelectedIndex(i);
            return;
        }
        if (StringUtil.isEmpty((String)secondRegex)) {
            return;
        }
        pattern = Pattern.compile(secondRegex);
        count = combo.getItemCount();
        for (i = 0; i < count; ++i) {
            item = (BillReservationTableSettingProperty)combo.getItemAt(i);
            if (item.getFieldName() == null || !(matcher = pattern.matcher(item.getFieldName().toUpperCase())).matches()) continue;
            combo.setSelectedIndex(i);
            return;
        }
    }

    void doCombDefaultValue(KDComboBox combo, String firstRegex) {
        this.doCombDefaultValue(combo, firstRegex, null);
    }

    private void addListener() {
        this.comboBillID.addItemListener(this.itemChangeListener);
        this.comboEntryID.addItemListener(this.itemChangeListener);
        this.comboEntryMaterialID.addItemListener(this.itemChangeListener);
        this.comboBaseQty.addItemListener(this.itemChangeListener);
        this.comboAssistQty.addItemListener(this.itemChangeListener);
    }

    private void removeListener() {
        this.comboBillID.removeItemListener(this.itemChangeListener);
        this.comboEntryID.removeItemListener(this.itemChangeListener);
        this.comboEntryMaterialID.removeItemListener(this.itemChangeListener);
        this.comboBaseQty.removeItemListener(this.itemChangeListener);
        this.comboAssistQty.removeItemListener(this.itemChangeListener);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.tblSetting.addKDTEditListener((KDTEditListener)this);
        this.numMaxRowNum.setMaximumNumber((Number)200);
        this.reservation_billtype = (String)this.getUIContext().get("RESERVATION_BILLTYPE");
        this.billFullName = (String)this.getUIContext().get("BILLFULLNAME");
        this.billQueryPK = (String)this.getUIContext().get("BILLQUERYPK");
        if ("SUPPLYBILL".equals(this.reservation_billtype)) {
            this.setUITitle(ReservationUtil.getResourceString("TABLESETTING_TITLE_SUPPLYBILL"));
        } else {
            this.setUITitle(ReservationUtil.getResourceString("TABLESETTING_TITLE_REQUIREBILL"));
        }
        if (billEntityMap.containsKey(this.billFullName)) {
            this.parentObject = billEntityMap.get(this.billFullName);
        } else {
            this.parentObject = MetadataUtils.loadEntity((IMetaDataPK)MetaDataPK.create((String)this.billFullName));
            billEntityMap.put(this.billFullName, this.parentObject);
        }
        if (entryEntityMap.containsKey(this.billFullName)) {
            this.entryObject = entryEntityMap.get(this.billFullName);
        } else {
            this.entryObject = ReservationUtil.getEntryEntityObject(this.parentObject);
            entryEntityMap.put(this.billFullName, this.entryObject);
        }
        this.initCombox();
        this.addListener();
    }

    public void onShow() throws Exception {
        super.onShow();
        this.innerLoadReservationSchemaTableSetting();
        this.innerLoadReservationSchemaTableMaxRow();
        this.initListFrom();
    }

    boolean isUnLoadListContainsProperty(KDListProperty selectProperty) {
        if (selectProperty == null || StringUtil.isEmpty((String)selectProperty.getFieldName())) {
            return false;
        }
        if (CollectionUtil.isEmpty(this.unLoadList)) {
            return false;
        }
        for (KDListProperty property : this.unLoadList) {
            if (property == null || !selectProperty.getFieldName().equals(property.getFieldName())) continue;
            return true;
        }
        return false;
    }

    boolean isUnLoadMapContainsProperty(KDListProperty selectProperty) {
        if (selectProperty == null) {
            return false;
        }
        return this.isUnLoadMapContainsProperty(selectProperty.getFieldName());
    }

    boolean isUnLoadMapContainsProperty(String fieldName) {
        if (StringUtil.isEmpty((String)fieldName)) {
            return false;
        }
        if (CollectionUtil.isEmpty(this.unLoadMap)) {
            return false;
        }
        return this.unLoadMap.containsKey(fieldName);
    }

    @Override
    protected void btnAddSelect_actionPerformed(ActionEvent e) throws Exception {
        Object[] selectItems = this.listFrom.getSelectedValues();
        if (ArrayUtil.isEmpty((Object[])selectItems)) {
            return;
        }
        KDListProperty selectProperty = null;
        int len = selectItems.length;
        for (int i = 0; i < len; ++i) {
            selectProperty = (KDListProperty)selectItems[i];
            this.addProperty2Tbl(selectProperty);
        }
        this.initListFrom();
    }

    private void addProperty2Tbl(KDListProperty selectProperty) {
        IRow row = null;
        this.unLoadList.add(selectProperty);
        this.unLoadMap.put(selectProperty.getFieldName(), selectProperty);
        row = this.tblSetting.addRow();
        row.getCell(TB_COLNAME_HEADNAME).setValue((Object)selectProperty.getDisplayName());
        row.getCell(TB_COLNAME_FIELDNAME).setValue((Object)selectProperty.getFieldName());
        row.getCell(TB_COLNAME_ISNUMERIC).setValue((Object)selectProperty.isNumeric());
        row.getCell(TB_COLNAME_COLUMNWIDTH).setValue((Object)-1);
        ICell cell = row.getCell(TB_COLNAME_SORTTYPE);
        KDComboBox sortCombo = new KDComboBox(SortTypeEnum.getEnumList().toArray());
        cell.getStyleAttributes().setLocked(false);
        cell.setValue((Object)SortTypeEnum.SortType_NOSORT);
        KDTDefaultCellEditor editor = new KDTDefaultCellEditor((JComboBox)sortCombo);
        cell.setEditor((ICellEditor)editor);
    }

    @Override
    protected void btnRemoveSelect_actionPerformed(ActionEvent e) throws Exception {
        if (null == this.tblSetting.getSelectManager() || null == this.tblSetting.getSelectManager().getBlocks()) {
            return;
        }
        ArrayList<Integer> selectRowList = new ArrayList<Integer>();
        ArrayList blockes = this.tblSetting.getSelectManager().getBlocks();
        int blockSize = blockes.size();
        int rowIndex = 0;
        for (int i = 0; i < blockSize; ++i) {
            KDTSelectBlock selectBlock = (KDTSelectBlock)blockes.get(i);
            if (selectBlock == null) continue;
            int begin = selectBlock.getBeginRow();
            int end = selectBlock.getEndRow();
            for (rowIndex = begin; rowIndex <= end; ++rowIndex) {
                selectRowList.add(rowIndex);
            }
        }
        IRow row = null;
        for (int i = selectRowList.size() - 1; i >= 0; --i) {
            rowIndex = (Integer)selectRowList.get(i);
            row = this.tblSetting.removeRow(rowIndex);
            this.unLoadMap.remove(row.getCell(TB_COLNAME_FIELDNAME).getValue().toString());
        }
        this.initListFrom();
    }

    @Override
    protected void btnAddAll_actionPerformed(ActionEvent e) throws Exception {
        KDListProperty selectProperty = null;
        int count = this.listFrom.getElementCount();
        for (int i = 0; i < count; ++i) {
            selectProperty = (KDListProperty)this.listFrom.getElement(i);
            this.addProperty2Tbl(selectProperty);
        }
    }

    @Override
    protected void btnRemoveAll_actionPerformed(ActionEvent e) throws Exception {
        this.tblSetting.removeRows();
        this.unLoadMap.clear();
        this.initListFrom();
    }

    public void editCanceled(KDTEditEvent e) {
    }

    public void editStarted(KDTEditEvent e) {
    }

    public void editStarting(KDTEditEvent e) {
    }

    public void editStopped(KDTEditEvent e) {
    }

    public void editStopping(KDTEditEvent e) {
    }

    public void editValueChanged(KDTEditEvent e) {
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    private void innerLoadReservationSchemaTableSetting() {
        if (this.getUIContext().get("BILLTABLESETTING") == null) {
            return;
        }
        String settingStr = this.getUIContext().get("BILLTABLESETTING").toString();
        BillReservationTableSettingCollection storeBillTableSettingCol = new BillReservationTableSettingCollection(settingStr);
        if (CollectionUtil.isEmpty(storeBillTableSettingCol.getTabSettingCollection())) {
            return;
        }
        IRow row = null;
        KDListProperty selectProperty = null;
        for (BillReservationTableSettingProperty property : storeBillTableSettingCol.getTabSettingCollection()) {
            selectProperty = new KDListProperty();
            selectProperty.setDisplayName(property.getHeadName());
            selectProperty.setFieldName(property.getFieldName());
            selectProperty.setNumeric(property.isNumeric());
            this.unLoadMap.put(selectProperty.getFieldName(), selectProperty);
            if (property.isAssistQty() || property.isBaseQty() || property.isBillID() || property.isEntryID() || property.isEntryMaterialID()) continue;
            row = this.tblSetting.addRow();
            row.getCell(TB_COLNAME_HEADNAME).setValue((Object)property.getHeadName());
            row.getCell(TB_COLNAME_FIELDNAME).setValue((Object)property.getFieldName());
            if (property.isBaseQty()) {
                row.getCell(TB_COLNAME_SORTTYPE).getStyleAttributes().setLocked(true);
            } else {
                row.getCell(TB_COLNAME_SORTTYPE).getStyleAttributes().setLocked(!property.isShow());
                String sortType = property.getSortType();
                ICell cell = row.getCell(TB_COLNAME_SORTTYPE);
                KDComboBox sortCombo = new KDComboBox(SortTypeEnum.getEnumList().toArray());
                cell.setValue((Object)SortTypeEnum.SortType_NOSORT);
                KDTDefaultCellEditor editor = new KDTDefaultCellEditor((JComboBox)sortCombo);
                cell.setEditor((ICellEditor)editor);
                cell.setValue((Object)SortTypeEnum.getEnum(sortType));
            }
            row.getCell(TB_COLNAME_ISNUMERIC).setValue((Object)property.isNumeric());
            row.getCell(TB_COLNAME_COLUMNWIDTH).setValue((Object)property.getColumnWidth());
        }
        for (BillReservationTableSettingProperty property : storeBillTableSettingCol.getTabSettingCollection()) {
            if (property.isBillID()) {
                this.initComboSelectItem(this.comboBillID, property);
            }
            if (property.isEntryID()) {
                this.initComboSelectItem(this.comboEntryID, property);
            }
            if (property.isEntryMaterialID()) {
                this.initComboSelectItem(this.comboEntryMaterialID, property);
            }
            if (property.isBaseQty()) {
                this.initComboSelectItem(this.comboBaseQty, property);
            }
            if (!property.isAssistQty()) continue;
            this.initComboSelectItem(this.comboAssistQty, property);
        }
        this.isDefault = false;
    }

    private void initComboSelectItem(KDComboBox combo, BillReservationTableSettingProperty property) {
        BillReservationTableSettingProperty item = null;
        int count = combo.getItemCount();
        for (int i = 0; i < count; ++i) {
            item = (BillReservationTableSettingProperty)combo.getItemAt(i);
            if (!item.getFieldName().equals(property.getFieldName())) continue;
            combo.setSelectedIndex(i);
            return;
        }
    }

    @Override
    public int getMaxRowCount() {
        return this.numMaxRowNum.getNumberValue() == null ? 200 : this.numMaxRowNum.getNumberValue().intValue();
    }

    private void innerLoadReservationSchemaTableMaxRow() {
        if (this.getUIContext().get("BILLTABLEMAXROW") == null) {
            return;
        }
        this.numMaxRowNum.setNumberValue((Number)((Integer)this.getUIContext().get("BILLTABLEMAXROW")));
        if (this.numMaxRowNum.getNumberValue() == null || this.numMaxRowNum.getNumberValue().intValue() == 0) {
            this.numMaxRowNum.setNumberValue((Number)50);
        }
    }

    class KDListProperty {
        private String displayName = "";
        private String fieldName = "";
        private boolean isNumeric = false;

        KDListProperty() {
        }

        public boolean isNumeric() {
            return this.isNumeric;
        }

        public void setNumeric(boolean isNumeric) {
            this.isNumeric = isNumeric;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public void setFieldName(String fieldName) {
            this.fieldName = fieldName;
        }

        public String toString() {
            return this.displayName;
        }
    }
}

