/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.reservation.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.PreChangeEvent;
import com.kingdee.bos.ctrl.swing.event.PreChangeListener;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.framework.util.EntityControlTypeUtil;
import com.kingdee.eas.basedata.master.material.AsstAttrValueInfo;
import com.kingdee.eas.basedata.master.material.IMaterialGroupStandard;
import com.kingdee.eas.basedata.master.material.MaterialGroupStandardCollection;
import com.kingdee.eas.basedata.master.material.MaterialGroupStandardFactory;
import com.kingdee.eas.basedata.master.material.MaterialGroupStandardInfo;
import com.kingdee.eas.basedata.master.material.MaterialGroupStandardTypeEnum;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.StoreType;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitCollection;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.im.inv.LocationFactory;
import com.kingdee.eas.basedata.scm.im.inv.LocationInfo;
import com.kingdee.eas.basedata.scm.im.inv.StoreTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseFactory;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.common.client.UIHelper;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.scm.common.ISCMBillCommonFacade;
import com.kingdee.eas.scm.common.SCMBillCommonFacadeFactory;
import com.kingdee.eas.scm.common.client.SCMGroupClientUtils;
import com.kingdee.eas.scm.im.inv.InventoryFacadeFactory;
import com.kingdee.eas.scm.im.inv.client.InvClientUtils;
import com.kingdee.eas.scm.im.reservation.client.AbstractObjectReservationFilterUI;
import com.kingdee.eas.scm.im.rpt.IMRptUtils;
import com.kingdee.eas.scm.util.collection.CollectionUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import org.apache.log4j.Logger;

public class ObjectReservationFilterUI
extends AbstractObjectReservationFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(ObjectReservationFilterUI.class);
    private static final long serialVersionUID = 1L;
    HashMap paramHashMap = null;
    private static final String permItem = "inventory";
    protected StorageOrgUnitInfo storageOrgUnitInfo;
    private DataChangeListener warehouseListener = null;
    private DataChangeListener storageListener = null;
    public static final String CTX_ONLY_BASE_SRANDARD = "onlyBaseStandard";
    public static final String CTX_GROUP_STANDARD = "groupStandard";
    public static final String CTX_CU = "cu";
    private CtrlUnitInfo curCtrlUnitInfo;
    private OrgUnitCollection hasPermOrg = null;
    private FilterInfo matpermRuleFilterInfo = null;
    private FilterInfo wareRuleFilterInfo = null;
    private FilterInfo inventoryRuleFilterInfo = null;
    private int idxDefaultMainOrg = -1;
    private OrgUnitInfo[] mainOrgs = null;

    public ObjectReservationFilterUI() throws Exception {
        if (null != this.warehouseListener) {
            this.bizPromptWarehouseFrom.removeDataChangeListener(this.warehouseListener);
        }
        this.warehouseListener = new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                try {
                    ObjectReservationFilterUI.this.prmtWarehouseForm_dataChanged(eventObj);
                }
                catch (Exception exc) {
                    ObjectReservationFilterUI.this.handUIException(exc);
                }
            }
        };
        this.bizPromptWarehouseFrom.addDataChangeListener(this.warehouseListener);
        if (null != this.storageListener) {
            this.bizPromptStorageOrgFrom.removeDataChangeListener(this.storageListener);
        }
        this.storageListener = new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                try {
                    ObjectReservationFilterUI.this.prmtStorageFrom_dataChanged(eventObj);
                }
                catch (Exception exc) {
                    ObjectReservationFilterUI.this.handUIException(exc);
                }
            }
        };
        this.bizPromptStorageOrgFrom.addDataChangeListener(this.storageListener);
        this.comboGroupStandard.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ObjectReservationFilterUI.this.comboGroupStandard_itemStateChanged(e);
            }
        });
        UIHelper.registerProjectF7ForFilter((KDBizPromptBox)this.getMainBizOrgF7(), (KDBizPromptBox)this.prmtProjectNumFrom);
        UIHelper.registerProjectF7ForFilter((KDBizPromptBox)this.getMainBizOrgF7(), (KDBizPromptBox)this.prmtProjectNumTo);
        UIHelper.registerTrackNumberF7ForFilter((KDBizPromptBox)this.getMainBizOrgF7(), (KDBizPromptBox)this.prmtTrackNumFrom);
        UIHelper.registerTrackNumberF7ForFilter((KDBizPromptBox)this.getMainBizOrgF7(), (KDBizPromptBox)this.prmtTrackNumTo);
    }

    private void comboGroupStandard_itemStateChanged(ItemEvent e) {
        Object o = e.getItem();
        MaterialGroupStandardInfo groupInfo = null;
        if (o != null && o instanceof MaterialGroupStandardInfo) {
            groupInfo = (MaterialGroupStandardInfo)o;
        }
        if (this.bizMaterialTypeFrom.getValue() != null || this.bizMaterialTypeTo.getValue() != null) {
            this.bizMaterialTypeFrom.setValue(null);
            this.bizMaterialTypeTo.setValue(null);
        }
        if (null != groupInfo) {
            IMRptUtils.setBizMaterialGroup(this.bizMaterialTypeFrom, groupInfo.getId().toString());
            IMRptUtils.setBizMaterialGroup(this.bizMaterialTypeTo, groupInfo.getId().toString());
        }
    }

    private void prmtWarehouseForm_dataChanged(DataChangeEvent eventObj) {
        String strNumber = this.bizPromptWarehouseFrom.getText();
        if (this.bizPromptWarehouseFrom.getValue() != null && strNumber != null && strNumber.toString().length() > 0) {
            Object[] obj = (Object[])this.bizPromptWarehouseFrom.getValue();
            HashSet<String> set = new HashSet<String>();
            int size = obj.length;
            for (int j = 0; j < size; ++j) {
                WarehouseInfo warehouseInfo = (WarehouseInfo)obj[j];
                set.add(warehouseInfo.getId().toString());
            }
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("Warehouse.id", set, CompareType.INCLUDE));
            EntityViewInfo viewInfo = new EntityViewInfo();
            viewInfo.setFilter(filterInfo);
            this.bizPromptLocationFrom.setEntityViewInfo(viewInfo);
        }
    }

    private void prmtStorageFrom_dataChanged(DataChangeEvent eventObj) {
        String strNumber = this.bizPromptStorageOrgFrom.getText();
        if (this.bizPromptStorageOrgFrom.getValue() != null && strNumber != null && strNumber.toString().length() > 0) {
            Object[] obj = null;
            obj = this.bizPromptStorageOrgFrom.getValue() instanceof Object[] ? (Object[])this.bizPromptStorageOrgFrom.getValue() : new Object[]{(StorageOrgUnitInfo)this.bizPromptStorageOrgFrom.getValue()};
            HashSet<String> set = new HashSet<String>();
            int size = obj.length;
            for (int j = 0; j < size; ++j) {
                StorageOrgUnitInfo storageOrgUnitInfo = (StorageOrgUnitInfo)obj[j];
                set.add(storageOrgUnitInfo.getId().toString());
            }
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", set, CompareType.INCLUDE));
            EntityViewInfo viewInfo = new EntityViewInfo();
            viewInfo.setFilter(filterInfo);
            this.bizPromptWarehouseFrom.setEntityViewInfo(viewInfo);
            InvClientUtils.setMaterialFilterbySou(set, this.bizPromptMaterialNumFrom);
            InvClientUtils.setMaterialFilterbySou(set, this.bizPromptMaterialNumTo);
        }
    }

    private void loadGroupStandard() throws Exception {
        MaterialGroupStandardInfo groupStandard = null;
        Boolean onlyBaseStandard = (Boolean)this.getUIContext().get(CTX_ONLY_BASE_SRANDARD);
        if (onlyBaseStandard != null && onlyBaseStandard.booleanValue()) {
            IMaterialGroupStandard iBiz = MaterialGroupStandardFactory.getRemoteInstance();
            MaterialGroupStandardCollection baseGroupStandardColl = iBiz.getBaseMaterialGroupStandardColl();
            if (baseGroupStandardColl.size() > 0) {
                groupStandard = baseGroupStandardColl.get(0);
            }
        } else {
            groupStandard = (MaterialGroupStandardInfo)this.getUIContext().get(CTX_GROUP_STANDARD);
        }
        if (groupStandard != null) {
            this.comboGroupStandard.removeAllItems();
            this.comboGroupStandard.addItem((Object)groupStandard);
            this.comboGroupStandard.setSelectedIndex(0);
        } else {
            IMaterialGroupStandard iMaterialGroupStandard = MaterialGroupStandardFactory.getRemoteInstance();
            FilterInfo filterInfoCU = EntityControlTypeUtil.getFilterInfoForControlTypeS4((String)this.curCtrlUnitInfo.getId().toString(), (String)this.curCtrlUnitInfo.getLongNumber());
            EntityViewInfo viewInfo = new EntityViewInfo();
            viewInfo.setFilter(filterInfoCU);
            MaterialGroupStandardCollection groupStandardColl = iMaterialGroupStandard.getMaterialGroupStandardCollection(viewInfo);
            this.comboGroupStandard.removeAllItems();
            if (groupStandardColl != null) {
                this.comboGroupStandard.addItems(groupStandardColl.toArray());
            }
            int defaultIndex = 0;
            int size = groupStandardColl.size();
            for (int index = 0; index < size; ++index) {
                if (!groupStandardColl.get(index).getStandardType().equals((Object)MaterialGroupStandardTypeEnum.BasicStandard)) continue;
                defaultIndex = index;
                break;
            }
            this.comboGroupStandard.setSelectedIndex(defaultIndex);
        }
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.bizPromptStorageOrgFrom.setRequired(true);
        this.clear();
        if (this.storageOrgUnitInfo != null) {
            this.bizPromptStorageOrgFrom.setValue((Object)this.storageOrgUnitInfo);
        }
        this.loadStoreTypeEnum((JComboBox)this.comboBoxStoreType);
        this.comboBoxStoreType.setSelectedIndex(-1);
        this.setF7();
        this.curCtrlUnitInfo = (CtrlUnitInfo)this.getUIContext().get(CTX_CU);
        if (this.curCtrlUnitInfo == null) {
            this.curCtrlUnitInfo = SysContext.getSysContext().getCurrentCtrlUnit();
        }
        this.loadGroupStandard();
        this.initSou();
    }

    private void initSou() throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        Object mainOrgs = null;
        FullOrgUnitCollection collection = SCMGroupClientUtils.getAuthOrgByPermItem((IObjectPK)new ObjectStringPK(SysContext.getSysContext().getCurrentUserInfo().getId().toString()), (OrgType)OrgType.ControlUnit, (String)"objectReservation_addnew");
        HashSet<String> idSet = new HashSet<String>();
        if (!CollectionUtil.isEmpty((AbstractObjectCollection)collection)) {
            FullOrgUnitInfo cu = null;
            int size = collection.size();
            for (int i = 0; i < size; ++i) {
                cu = collection.get(i);
                if (cu == null) continue;
                idSet.add(cu.getId().toString());
            }
            filter.getFilterItems().add(new FilterItemInfo("CU.id", idSet, CompareType.INCLUDE));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)Character.valueOf('0'), CompareType.EQUALS));
        }
        filter.getFilterItems().add(new FilterItemInfo("isBizUnit", (Object)1, CompareType.EQUALS));
        view.setFilter(filter);
        this.bizPromptStorageOrgFrom.setEntityViewInfo(view);
        this.bizPromptStorageOrgFrom.addPreChangeListener(new PreChangeListener(){

            public void preChange(PreChangeEvent e) {
                ObjectReservationFilterUI.this.doCheck(e);
            }
        });
        OrgUnitInfo currentMainOrg = SysContext.getSysContext().getCurrentOrgUnit(OrgType.Storage);
        if (currentMainOrg != null && ((StorageOrgUnitInfo)currentMainOrg).isIsBizUnit()) {
            this.bizPromptStorageOrgFrom.setValue((Object)currentMainOrg);
        }
    }

    void doCheck(PreChangeEvent e) {
        if (e.getData() == null) {
            MsgBox.showInfo((String)InvClientUtils.getResource("StorageOrgUnitNotNull"));
            this.bizPromptStorageOrgFrom.requestFocus();
            SysUtil.abort();
        }
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    private void setF7() throws Exception {
        InvClientUtils.getMaterialF7ForReportFilterUI(this.bizPromptMaterialNumFrom, (Object)this);
        InvClientUtils.getMaterialF7ForReportFilterUI(this.bizPromptMaterialNumTo, (Object)this);
    }

    public void clear() {
        this.bizPromptWarehouseFrom.setValue(null);
        this.bizPromptWarehouseTo.setValue(null);
        this.bizPromptLocationFrom.setValue(null);
        this.bizPromptLocationTo.setValue(null);
        this.bizPromptStoreTypeFrom.setValue(null);
        this.bizPromptStoreTypeTo.setValue(null);
        this.bizPromptMaterialNumFrom.setValue(null);
        this.bizPromptMaterialNumTo.setValue(null);
        this.bizPromptAssisAttrFrom.setValue(null);
        this.bizPromptAssisAttrTo.setValue(null);
        this.txtBatchFrom.setText(null);
        this.txtBatchTo.setText(null);
        this.prmtProjectNumFrom.setValue(null);
        this.prmtProjectNumTo.setValue(null);
        this.prmtTrackNumFrom.setValue(null);
        this.prmtTrackNumTo.setValue(null);
        this.comboBoxStoreType.setSelectedIndex(-1);
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Storage;
    }

    public FilterInfo getFilterInfo() {
        StoreType storeType;
        StringBuffer sbFormula = new StringBuffer();
        FilterInfo filter = new FilterInfo();
        FilterItemCollection items = filter.getFilterItems();
        int i = 0;
        String strNumber = null;
        Object[] obj = null;
        Set cuUnitSets = null;
        HashSet<String> oriSet = new HashSet<String>();
        HashSet<String> orgSet = new HashSet<String>();
        FilterItemInfo templateFilterItemInfo = new FilterItemInfo();
        strNumber = this.bizPromptStorageOrgFrom.getText();
        if (this.bizPromptStorageOrgFrom.getValue() != null && strNumber != null && strNumber.toString().length() > 0) {
            obj = this.bizPromptStorageOrgFrom.getValue() instanceof Object[] ? (Object[])this.bizPromptStorageOrgFrom.getValue() : new Object[]{(StorageOrgUnitInfo)this.bizPromptStorageOrgFrom.getValue()};
            int size = obj.length;
            for (int j = 0; j < size; ++j) {
                StorageOrgUnitInfo storageOrgUnitInfo = (StorageOrgUnitInfo)obj[j];
                orgSet.add(storageOrgUnitInfo.getId().toString());
                oriSet.add(storageOrgUnitInfo.getId().toString());
            }
            templateFilterItemInfo = new FilterItemInfo("storageOrgUnit.id", orgSet, CompareType.INCLUDE);
            items.add(templateFilterItemInfo);
            if (i == 0) {
                sbFormula.append("#" + i++);
            } else {
                sbFormula.append(" and #" + i++);
            }
        }
        boolean rettype = false;
        Map matPermMap = null;
        Map warePermMap = null;
        try {
            Map InventoryPermMap = InvClientUtils.getInventoryPemissionSqlMap(orgSet, permItem);
            this.getInventoryMapFilter(InventoryPermMap);
            ISCMBillCommonFacade iScmFacade = SCMBillCommonFacadeFactory.getRemoteInstance();
            if (cuUnitSets != null) {
                matPermMap = iScmFacade.getPermissionEntityViewMap(cuUnitSets, "bd_material_view");
                Map.Entry entry2 = null;
                String couID = null;
                EntityViewInfo view = null;
                for (Map.Entry entry2 : matPermMap.entrySet()) {
                    view = (EntityViewInfo)entry2.getValue();
                    couID = (String)entry2.getKey();
                    if (!rettype) {
                        if (view != null) {
                            matPermMap.put(couID, InvClientUtils.getCUFilterString(view, "material."));
                            continue;
                        }
                        matPermMap.put(couID, " material.number <> ' '");
                        continue;
                    }
                    if (view != null) {
                        matPermMap.put(couID, InvClientUtils.getmaterialPermSql(view, ""));
                        continue;
                    }
                    matPermMap.put(couID, " 1 = 1");
                }
                warePermMap = iScmFacade.getPermissionEntityViewMap(cuUnitSets, "warehous_view");
                for (Map.Entry entry2 : warePermMap.entrySet()) {
                    view = (EntityViewInfo)entry2.getValue();
                    couID = (String)entry2.getKey();
                    if (!rettype) {
                        if (view != null) {
                            warePermMap.put(couID, InvClientUtils.getCUFilterString(view, "warehouse."));
                            continue;
                        }
                        warePermMap.put(couID, " warehouse.number <> ' ' ");
                        continue;
                    }
                    if (view != null) {
                        warePermMap.put(couID, InvClientUtils.getwarePermSql(view, ""));
                        continue;
                    }
                    warePermMap.put(couID, " 1 = 1 ");
                }
                this.getmatMapFilter(matPermMap);
                this.getwareMapFilter(warePermMap);
            }
        }
        catch (EASBizException e1) {
            this.handUIException(e1);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        strNumber = this.bizPromptWarehouseFrom.getText();
        if (this.bizPromptWarehouseFrom.getValue() != null && strNumber != null && strNumber.toString().length() > 0) {
            obj = (Object[])this.bizPromptWarehouseFrom.getValue();
            HashSet<String> whsSet = new HashSet<String>();
            int size = obj.length;
            for (int j = 0; j < size; ++j) {
                WarehouseInfo warehouseInfo = (WarehouseInfo)obj[j];
                whsSet.add(warehouseInfo.getId().toString());
            }
            templateFilterItemInfo = new FilterItemInfo("warehouse.id", whsSet, CompareType.INCLUDE);
            items.add(templateFilterItemInfo);
            if (i == 0) {
                sbFormula.append("#" + i++);
            } else {
                sbFormula.append(" and #" + i++);
            }
        }
        strNumber = this.bizPromptLocationFrom.getText();
        if (this.bizPromptLocationFrom.getValue() != null && strNumber != null && strNumber.toString().length() > 0) {
            obj = (Object[])this.bizPromptLocationFrom.getValue();
            HashSet<String> loSet = new HashSet<String>();
            int size = obj.length;
            for (int j = 0; j < size; ++j) {
                LocationInfo locationInfo = (LocationInfo)obj[j];
                loSet.add(locationInfo.getId().toString());
            }
            templateFilterItemInfo = new FilterItemInfo("location.id", loSet, CompareType.INCLUDE);
            items.add(templateFilterItemInfo);
            if (i == 0) {
                sbFormula.append("#" + i++);
            } else {
                sbFormula.append(" and #" + i++);
            }
        }
        strNumber = this.bizPromptStoreTypeFrom.getText();
        Object value = this.bizPromptStoreTypeFrom.getValue();
        if (value != null && strNumber != null && strNumber.toString().length() > 0) {
            strNumber = value instanceof StoreTypeInfo ? ((StoreTypeInfo)value).getNumber() : value.toString();
            templateFilterItemInfo = new FilterItemInfo("storetype.number", (Object)strNumber.toString().trim(), CompareType.GREATER_EQUALS);
            items.add(templateFilterItemInfo);
            if (i == 0) {
                sbFormula.append("#" + i++);
            } else {
                sbFormula.append(" and #" + i++);
            }
        } else if (strNumber != null && strNumber.toString().length() > 0) {
            templateFilterItemInfo = new FilterItemInfo("storetype.number", (Object)strNumber.toString().trim(), CompareType.GREATER_EQUALS);
            items.add(templateFilterItemInfo);
            if (i == 0) {
                sbFormula.append("#" + i++);
            } else {
                sbFormula.append(" and #" + i++);
            }
        }
        strNumber = this.bizPromptStoreTypeTo.getText();
        value = this.bizPromptStoreTypeTo.getValue();
        if (value != null && strNumber != null && strNumber.toString().length() > 0) {
            strNumber = value instanceof StoreTypeInfo ? ((StoreTypeInfo)value).getNumber() : value.toString();
            templateFilterItemInfo = new FilterItemInfo("storetype.number", (Object)strNumber.toString().trim(), CompareType.LESS_EQUALS);
            items.add(templateFilterItemInfo);
            if (i == 0) {
                sbFormula.append("#" + i++);
            } else {
                sbFormula.append(" and #" + i++);
            }
        } else if (strNumber != null && strNumber.toString().length() > 0) {
            templateFilterItemInfo = new FilterItemInfo("storetype.number", (Object)strNumber.toString().trim(), CompareType.LESS_EQUALS);
            items.add(templateFilterItemInfo);
            if (i == 0) {
                sbFormula.append("#" + i++);
            } else {
                sbFormula.append(" and #" + i++);
            }
        }
        strNumber = this.bizPromptMaterialNumFrom.getText();
        value = this.bizPromptMaterialNumFrom.getValue();
        if (value != null && strNumber != null && strNumber.toString().length() > 0) {
            strNumber = value instanceof MaterialInfo ? ((MaterialInfo)value).getNumber() : value.toString();
            templateFilterItemInfo = new FilterItemInfo("material.number", (Object)strNumber.toString().trim(), CompareType.GREATER_EQUALS);
            items.add(templateFilterItemInfo);
            if (i == 0) {
                sbFormula.append("#" + i++);
            } else {
                sbFormula.append(" and #" + i++);
            }
        } else if (strNumber != null && strNumber.toString().length() > 0) {
            templateFilterItemInfo = new FilterItemInfo("material.number", (Object)strNumber.toString().trim(), CompareType.GREATER_EQUALS);
            items.add(templateFilterItemInfo);
            if (i == 0) {
                sbFormula.append("#" + i++);
            } else {
                sbFormula.append(" and #" + i++);
            }
        }
        strNumber = this.bizPromptMaterialNumTo.getText();
        value = this.bizPromptMaterialNumTo.getValue();
        if (value != null && strNumber != null && strNumber.toString().length() > 0) {
            strNumber = value instanceof MaterialInfo ? ((MaterialInfo)value).getNumber() : value.toString();
            templateFilterItemInfo = new FilterItemInfo("material.number", (Object)strNumber.toString().trim(), CompareType.LESS_EQUALS);
            items.add(templateFilterItemInfo);
            if (i == 0) {
                sbFormula.append("#" + i++);
            } else {
                sbFormula.append(" and #" + i++);
            }
        } else if (strNumber != null && strNumber.toString().length() > 0) {
            templateFilterItemInfo = new FilterItemInfo("material.number", (Object)strNumber.toString().trim(), CompareType.LESS_EQUALS);
            items.add(templateFilterItemInfo);
            if (i == 0) {
                sbFormula.append("#" + i++);
            } else {
                sbFormula.append(" and #" + i++);
            }
        }
        String standerdId = ((MaterialGroupStandardInfo)this.comboGroupStandard.getSelectedItem()).getId().toString();
        IObjectValue from = (IObjectValue)this.bizMaterialTypeFrom.getValue();
        IObjectValue to = (IObjectValue)this.bizMaterialTypeTo.getValue();
        List materialGroup = null;
        try {
            materialGroup = InventoryFacadeFactory.getRemoteInstance().getMaterialGroupLongNumber(from, to, standerdId);
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        if (materialGroup != null && materialGroup.size() != 0) {
            if (i != 0) {
                sbFormula.append(" and (");
            } else {
                sbFormula.append("(");
            }
            for (int j = 0; j < materialGroup.size(); ++j) {
                templateFilterItemInfo = new FilterItemInfo("materialGroup.longNumber", materialGroup.get(j), CompareType.EQUALS);
                items.add(templateFilterItemInfo);
                templateFilterItemInfo = new FilterItemInfo("materialGroup.longNumber", (Object)(materialGroup.get(j) + "!%"), CompareType.LIKE);
                items.add(templateFilterItemInfo);
                if (j == 0) {
                    sbFormula.append("#" + i++ + " or  #" + i++ + "");
                    continue;
                }
                sbFormula.append(" or #" + i++ + " or  #" + i++ + "");
            }
            sbFormula.append(")");
        } else if (from != null || to != null) {
            templateFilterItemInfo = new FilterItemInfo("materialGroup.longNumber", (Object)"XXXXXXXXXXX", CompareType.EQUALS);
            items.add(templateFilterItemInfo);
            if (i == 0) {
                sbFormula.append("#" + i++);
            } else {
                sbFormula.append("  and  #" + i++);
            }
        }
        strNumber = this.bizPromptAssisAttrFrom.getText();
        value = this.bizPromptAssisAttrFrom.getValue();
        if (value != null && strNumber != null && strNumber.toString().length() > 0) {
            strNumber = value instanceof AsstAttrValueInfo ? ((AsstAttrValueInfo)value).getNumber() : value.toString();
            templateFilterItemInfo = new FilterItemInfo("assistProperty.number", (Object)strNumber.toString().trim(), CompareType.GREATER_EQUALS);
            items.add(templateFilterItemInfo);
            if (i == 0) {
                sbFormula.append("#" + i++);
            } else {
                sbFormula.append(" and #" + i++);
            }
        } else if (strNumber != null && strNumber.toString().length() > 0) {
            templateFilterItemInfo = new FilterItemInfo("assistProperty.number", (Object)strNumber.toString().trim(), CompareType.GREATER_EQUALS);
            items.add(templateFilterItemInfo);
            if (i == 0) {
                sbFormula.append("#" + i++);
            } else {
                sbFormula.append(" and #" + i++);
            }
        }
        strNumber = this.bizPromptAssisAttrTo.getText();
        value = this.bizPromptAssisAttrTo.getValue();
        if (value != null && strNumber != null && strNumber.toString().length() > 0) {
            strNumber = value instanceof AsstAttrValueInfo ? ((AsstAttrValueInfo)value).getNumber() : value.toString();
            templateFilterItemInfo = new FilterItemInfo("assistProperty.number", (Object)strNumber.toString().trim(), CompareType.LESS_EQUALS);
            items.add(templateFilterItemInfo);
            if (i == 0) {
                sbFormula.append("#" + i++);
            } else {
                sbFormula.append(" and #" + i++);
            }
        } else if (strNumber != null && strNumber.toString().length() > 0) {
            templateFilterItemInfo = new FilterItemInfo("assistProperty.number", (Object)strNumber.toString().trim(), CompareType.LESS_EQUALS);
            items.add(templateFilterItemInfo);
            if (i == 0) {
                sbFormula.append("#" + i++);
            } else {
                sbFormula.append(" and #" + i++);
            }
        }
        if (this.txtBatchFrom.getText() != null && this.txtBatchFrom.getText().trim().length() > 0) {
            templateFilterItemInfo = new FilterItemInfo("lot", (Object)this.txtBatchFrom.getText().trim(), CompareType.GREATER_EQUALS);
            items.add(templateFilterItemInfo);
            if (i == 0) {
                sbFormula.append("#" + i++);
            } else {
                sbFormula.append(" and #" + i++);
            }
        }
        if (this.txtBatchTo.getText() != null && this.txtBatchTo.getText().trim().length() > 0) {
            templateFilterItemInfo = new FilterItemInfo("lot", (Object)this.txtBatchTo.getText().trim(), CompareType.LESS_EQUALS);
            items.add(templateFilterItemInfo);
            if (i == 0) {
                sbFormula.append("#" + i++);
            } else {
                sbFormula.append(" and #" + i++);
            }
        }
        strNumber = this.prmtProjectNumFrom.getText();
        value = this.prmtProjectNumFrom.getValue();
        if (value != null && !StringUtils.isEmpty((String)strNumber)) {
            strNumber = value instanceof ProjectInfo ? ((ProjectInfo)value).getNumber() : value.toString();
            templateFilterItemInfo = new FilterItemInfo("project.number", (Object)strNumber.toString().trim(), CompareType.GREATER_EQUALS);
            items.add(templateFilterItemInfo);
            if (i == 0) {
                sbFormula.append("#" + i++);
            } else {
                sbFormula.append(" and #" + i++);
            }
        } else if (!StringUtils.isEmpty((String)strNumber)) {
            templateFilterItemInfo = new FilterItemInfo("project.number", (Object)strNumber.toString().trim(), CompareType.GREATER_EQUALS);
            items.add(templateFilterItemInfo);
            if (i == 0) {
                sbFormula.append("#" + i++);
            } else {
                sbFormula.append(" and #" + i++);
            }
        }
        strNumber = this.prmtProjectNumTo.getText();
        value = this.prmtProjectNumTo.getValue();
        if (value != null && !StringUtils.isEmpty((String)strNumber)) {
            strNumber = value instanceof ProjectInfo ? ((ProjectInfo)value).getNumber() : value.toString();
            templateFilterItemInfo = new FilterItemInfo("project.number", (Object)strNumber.toString().trim(), CompareType.LESS_EQUALS);
            items.add(templateFilterItemInfo);
            if (i == 0) {
                sbFormula.append("#" + i++);
            } else {
                sbFormula.append(" and #" + i++);
            }
        } else if (!StringUtils.isEmpty((String)strNumber)) {
            templateFilterItemInfo = new FilterItemInfo("project.number", (Object)strNumber.toString().trim(), CompareType.LESS_EQUALS);
            items.add(templateFilterItemInfo);
            if (i == 0) {
                sbFormula.append("#" + i++);
            } else {
                sbFormula.append(" and #" + i++);
            }
        }
        strNumber = this.prmtTrackNumFrom.getText();
        value = this.prmtTrackNumFrom.getValue();
        if (value != null && !StringUtils.isEmpty((String)strNumber)) {
            strNumber = value instanceof TrackNumberInfo ? ((TrackNumberInfo)value).getNumber() : value.toString();
            templateFilterItemInfo = new FilterItemInfo("trackNumber.number", (Object)strNumber.toString().trim(), CompareType.GREATER_EQUALS);
            items.add(templateFilterItemInfo);
            if (i == 0) {
                sbFormula.append("#" + i++);
            } else {
                sbFormula.append(" and #" + i++);
            }
        } else if (!StringUtils.isEmpty((String)strNumber)) {
            templateFilterItemInfo = new FilterItemInfo("trackNumber.number", (Object)strNumber.toString().trim(), CompareType.GREATER_EQUALS);
            items.add(templateFilterItemInfo);
            if (i == 0) {
                sbFormula.append("#" + i++);
            } else {
                sbFormula.append(" and #" + i++);
            }
        }
        strNumber = this.prmtTrackNumTo.getText();
        value = this.prmtTrackNumTo.getValue();
        if (value != null && !StringUtils.isEmpty((String)strNumber)) {
            strNumber = value instanceof TrackNumberInfo ? ((TrackNumberInfo)value).getNumber() : value.toString();
            templateFilterItemInfo = new FilterItemInfo("trackNumber.number", (Object)strNumber.toString().trim(), CompareType.LESS_EQUALS);
            items.add(templateFilterItemInfo);
            if (i == 0) {
                sbFormula.append("#" + i++);
            } else {
                sbFormula.append(" and #" + i++);
            }
        } else if (!StringUtils.isEmpty((String)strNumber)) {
            templateFilterItemInfo = new FilterItemInfo("trackNumber.number", (Object)strNumber.toString().trim(), CompareType.LESS_EQUALS);
            items.add(templateFilterItemInfo);
            if (i == 0) {
                sbFormula.append("#" + i++);
            } else {
                sbFormula.append(" and #" + i++);
            }
        }
        if (this.comboBoxStoreType.getSelectedItem() != null && (storeType = (StoreType)this.comboBoxStoreType.getSelectedItem()).getValue() != 0) {
            templateFilterItemInfo = new FilterItemInfo("materialCost.storeType", (Object)new Integer(storeType.getValue()), CompareType.EQUALS);
            items.add(templateFilterItemInfo);
            if (i == 0) {
                sbFormula.append("#" + i++);
            } else {
                sbFormula.append(" and #" + i++);
            }
        }
        if (sbFormula.toString().length() != 0) {
            filter.setMaskString(sbFormula.toString());
        }
        if (this.matpermRuleFilterInfo != null) {
            try {
                filter.mergeFilter(this.matpermRuleFilterInfo, "AND");
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
        if (this.wareRuleFilterInfo != null) {
            try {
                filter.mergeFilter(this.wareRuleFilterInfo, "AND");
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
        if (this.inventoryRuleFilterInfo != null) {
            try {
                filter.mergeFilter(this.inventoryRuleFilterInfo, "AND");
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
        logger.debug((Object)filter.getFilterItems());
        return filter;
    }

    private void getmatMapFilter(Map matpermMap) {
        this.matpermRuleFilterInfo = null;
        Map.Entry entry2 = null;
        String orgid = null;
        String matperm = null;
        FilterInfo matFilter = new FilterInfo();
        if (matpermMap != null && matpermMap.size() > 0) {
            try {
                for (Map.Entry entry2 : matpermMap.entrySet()) {
                    orgid = (String)entry2.getKey();
                    matperm = (String)entry2.getValue();
                    matFilter = new FilterInfo(matperm);
                    if (this.matpermRuleFilterInfo == null) {
                        this.matpermRuleFilterInfo = matFilter;
                        continue;
                    }
                    this.matpermRuleFilterInfo.mergeFilter(matFilter, "OR");
                }
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
    }

    private void getwareMapFilter(Map warepermMap) {
        this.wareRuleFilterInfo = null;
        Map.Entry entry2 = null;
        String orgid = null;
        String wareperm = null;
        FilterInfo wareFilter = new FilterInfo();
        FilterInfo wareFilter2 = new FilterInfo();
        if (warepermMap != null && warepermMap.size() > 0) {
            try {
                for (Map.Entry entry2 : warepermMap.entrySet()) {
                    orgid = (String)entry2.getKey();
                    wareperm = (String)entry2.getValue();
                    wareFilter = new FilterInfo(wareperm + " AND storageOrgUnit.ID = '" + orgid + "' or warehouse.number is null ");
                    wareFilter2 = new FilterInfo(wareperm + " or warehouse.number is null ");
                    if (this.wareRuleFilterInfo == null) {
                        this.wareRuleFilterInfo = wareFilter2;
                        continue;
                    }
                    this.wareRuleFilterInfo.mergeFilter(wareFilter2, "OR");
                }
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
    }

    public FilterInfo getmatpermRuleFilterInfo() {
        return this.matpermRuleFilterInfo;
    }

    public FilterInfo getwareRuleFilterInfo() {
        return this.wareRuleFilterInfo;
    }

    public FilterInfo getInventoryRuleFilterInfo() {
        return this.inventoryRuleFilterInfo;
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        this.clear();
        try {
            if (entityViewInfo.getFilter() == null || entityViewInfo.getFilter().getFilterItems() == null || entityViewInfo.getFilter().getFilterItems().size() == 0) {
                return;
            }
            FilterItemCollection currentFilterItemCollection = entityViewInfo.getFilter().getFilterItems();
            int currentFilterItemCollectionSize = currentFilterItemCollection.size();
            EntityViewInfo view = null;
            FilterInfo filter = null;
            for (int i = 0; i < currentFilterItemCollectionSize; ++i) {
                String number;
                Object[] obj;
                StorageOrgUnitCollection col;
                FilterItemInfo filterItemInfo = currentFilterItemCollection.get(i);
                if (filterItemInfo.getPropertyName().equals("storageOrgUnit.id") && filterItemInfo.getCompareType().getName().equals(CompareType.INCLUDE.getName())) {
                    view = new EntityViewInfo();
                    filter = new FilterInfo();
                    filterItemInfo.setPropertyName("id");
                    filter.getFilterItems().add(filterItemInfo);
                    view.setFilter(filter);
                    col = StorageOrgUnitFactory.getRemoteInstance().getStorageOrgUnitCollection(view);
                    obj = col.toArray();
                    this.bizPromptStorageOrgFrom.setValue((Object)obj);
                }
                if (filterItemInfo.getPropertyName().equals("warehouse.id") && filterItemInfo.getCompareType().getName().equals(CompareType.INCLUDE.getName())) {
                    view = new EntityViewInfo();
                    filter = new FilterInfo();
                    filterItemInfo.setPropertyName("id");
                    filter.getFilterItems().add(filterItemInfo);
                    view.setFilter(filter);
                    col = WarehouseFactory.getRemoteInstance().getWarehouseCollection(view);
                    obj = col.toArray();
                    this.bizPromptWarehouseFrom.setValue((Object)obj);
                }
                if (filterItemInfo.getPropertyName().equals("location.id") && filterItemInfo.getCompareType().getName().equals(CompareType.INCLUDE.getName())) {
                    view = new EntityViewInfo();
                    filter = new FilterInfo();
                    filterItemInfo.setPropertyName("id");
                    filter.getFilterItems().add(filterItemInfo);
                    view.setFilter(filter);
                    col = LocationFactory.getRemoteInstance().getLocationCollection(view);
                    obj = col.toArray();
                    this.bizPromptLocationFrom.setValue((Object)obj);
                }
                if (filterItemInfo.getPropertyName().equals("storetype.number") && filterItemInfo.getCompareType().getName().equals(CompareType.GREATER_EQUALS.getName())) {
                    number = filterItemInfo.getCompareValue().toString();
                    this.bizPromptStoreTypeFrom.setText(number);
                }
                if (filterItemInfo.getPropertyName().equals("storetype.number") && filterItemInfo.getCompareType().getName().equals(CompareType.LESS_EQUALS.getName())) {
                    number = filterItemInfo.getCompareValue().toString();
                    this.bizPromptStoreTypeTo.setText(number);
                }
                if (filterItemInfo.getPropertyName().equals("material.number") && filterItemInfo.getCompareType().getName().equals(CompareType.GREATER_EQUALS.getName())) {
                    number = filterItemInfo.getCompareValue().toString();
                    this.bizPromptMaterialNumFrom.setText(number);
                }
                if (filterItemInfo.getPropertyName().equals("material.number") && filterItemInfo.getCompareType().getName().equals(CompareType.LESS_EQUALS.getName())) {
                    number = filterItemInfo.getCompareValue().toString();
                    this.bizPromptMaterialNumTo.setText(number);
                }
                if (filterItemInfo.getPropertyName().equals("assistProperty.number") && filterItemInfo.getCompareType().getName().equals(CompareType.GREATER_EQUALS.getName())) {
                    number = filterItemInfo.getCompareValue().toString();
                    this.bizPromptAssisAttrFrom.setText(number);
                }
                if (filterItemInfo.getPropertyName().equals("assistProperty.number") && filterItemInfo.getCompareType().getName().equals(CompareType.LESS_EQUALS.getName())) {
                    number = filterItemInfo.getCompareValue().toString();
                    this.bizPromptAssisAttrTo.setText(number);
                }
                if (filterItemInfo.getPropertyName().equals("lot") && filterItemInfo.getCompareType().getName().equals(CompareType.GREATER_EQUALS.getName())) {
                    number = filterItemInfo.getCompareValue().toString();
                    this.txtBatchFrom.setText(number);
                }
                if (filterItemInfo.getPropertyName().equals("lot") && filterItemInfo.getCompareType().getName().equals(CompareType.LESS_EQUALS.getName())) {
                    number = filterItemInfo.getCompareValue().toString();
                    this.txtBatchTo.setText(number);
                }
                if (filterItemInfo.getPropertyName().equals("project.number") && filterItemInfo.getCompareType().getName().equals(CompareType.GREATER_EQUALS.getName())) {
                    number = filterItemInfo.getCompareValue().toString();
                    this.prmtProjectNumFrom.setText(number);
                }
                if (filterItemInfo.getPropertyName().equals("project.number") && filterItemInfo.getCompareType().getName().equals(CompareType.LESS_EQUALS.getName())) {
                    number = filterItemInfo.getCompareValue().toString();
                    this.prmtProjectNumTo.setText(number);
                }
                if (filterItemInfo.getPropertyName().equals("trackNumber.number") && filterItemInfo.getCompareType().getName().equals(CompareType.GREATER_EQUALS.getName())) {
                    number = filterItemInfo.getCompareValue().toString();
                    this.prmtTrackNumFrom.setText(number);
                }
                if (filterItemInfo.getPropertyName().equals("trackNumber.number") && filterItemInfo.getCompareType().getName().equals(CompareType.LESS_EQUALS.getName())) {
                    number = filterItemInfo.getCompareValue().toString();
                    this.prmtTrackNumTo.setText(number);
                }
                if (!filterItemInfo.getPropertyName().equals("materialCost.storeType") || filterItemInfo.getCompareValue() == null) continue;
                number = filterItemInfo.getCompareValue().toString();
                Iterator iterator = StoreType.iterator();
                while (iterator.hasNext()) {
                    StoreType storeType = (StoreType)iterator.next();
                    if (Integer.valueOf(number).intValue() != storeType.getValue()) continue;
                    this.comboBoxStoreType.setSelectedItem((Object)storeType);
                }
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    private void loadStoreTypeEnum(JComboBox cb) {
        DefaultComboBoxModel<StoreType> model = new DefaultComboBoxModel<StoreType>();
        Iterator i = StoreType.iterator();
        while (i.hasNext()) {
            StoreType e = (StoreType)i.next();
            model.addElement(e);
        }
        cb.setModel(model);
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.bizPromptStorageOrgFrom;
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }

    public OrgUnitCollection getMainBizOrgs() {
        OrgUnitCollection orgCol = super.getMainBizOrgs();
        if (orgCol == null || orgCol.size() == 0) {
            return this.hasPermOrg;
        }
        return orgCol;
    }

    private void getInventoryMapFilter(Map warepermMap) {
        this.inventoryRuleFilterInfo = null;
        Map.Entry entry2 = null;
        String orgid = null;
        Object wareperm = null;
        FilterInfo wareFilter = new FilterInfo();
        FilterInfo wareFilter2 = new FilterInfo();
        if (warepermMap != null && warepermMap.size() > 0) {
            try {
                for (Map.Entry entry2 : warepermMap.entrySet()) {
                    orgid = (String)entry2.getKey();
                    wareFilter = (FilterInfo)entry2.getValue();
                    wareFilter = wareFilter == null ? new FilterInfo(" storageOrgUnit.ID = '" + orgid + "'") : new FilterInfo(wareFilter.toSql().toString() + " AND storageOrgUnit.ID = '" + orgid + "'");
                    if (this.inventoryRuleFilterInfo == null) {
                        this.inventoryRuleFilterInfo = wareFilter;
                        continue;
                    }
                    this.inventoryRuleFilterInfo.mergeFilter(wareFilter, "OR");
                }
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
    }

    public boolean verify() {
        if (this.bizPromptStorageOrgFrom.getValue() == null) {
            MsgBox.showInfo((String)InvClientUtils.getResource("StorageOrgUnitNotNull"));
            SysUtil.abort();
        }
        return true;
    }
}

