/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.reservation.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.KingdeeTreeModel;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.framework.util.EntityControlTypeUtil;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.material.IMaterialGroupStandard;
import com.kingdee.eas.basedata.master.material.MaterialGroupInfo;
import com.kingdee.eas.basedata.master.material.MaterialGroupStandardCollection;
import com.kingdee.eas.basedata.master.material.MaterialGroupStandardFactory;
import com.kingdee.eas.basedata.master.material.MaterialGroupStandardInfo;
import com.kingdee.eas.basedata.master.material.MaterialGroupStandardTypeEnum;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.util.StringUtil;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.SaleOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeCollection;
import com.kingdee.eas.basedata.scm.common.BillTypeFactory;
import com.kingdee.eas.basedata.scm.common.BillTypeGroupEnum;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.common.IBillType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.scm.common.client.SCMClientHelper;
import com.kingdee.eas.scm.im.inv.client.InvClientUtils;
import com.kingdee.eas.scm.im.reservation.IReservation;
import com.kingdee.eas.scm.im.reservation.ReservationFactory;
import com.kingdee.eas.scm.im.reservation.ReservationInfo;
import com.kingdee.eas.scm.im.reservation.ReservationTypeEnum;
import com.kingdee.eas.scm.im.reservation.client.AbstractObjectReservationListUI;
import com.kingdee.eas.scm.im.reservation.client.ObjectReservationFilterUI;
import com.kingdee.eas.scm.im.reservation.client.ReservationTypePriorityOptionUI;
import com.kingdee.eas.scm.util.collection.CollectionUtil;
import com.kingdee.eas.scm.util.numeric.NumericUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class ObjectReservationListUI
extends AbstractObjectReservationListUI
implements TreeSelectionListener,
TreeWillExpandListener,
KDTEditListener {
    private static final Logger logger = CoreUIObject.getLogger(ObjectReservationListUI.class);
    private String reservationObjectID = null;
    private int reservationType = 0;
    DataChangeListener customerDataChangeListener = null;
    DataChangeListener salesmanDataChangeListener = null;
    DataChangeListener adminOrgUnitDataChangeListener = null;
    DataChangeListener saleOrgUnitDataChangeListener = null;
    DataChangeListener storageOrgUnitDataChangeListener = null;
    private final String ROOTTAG = "root";
    private final String SUBTAG = "sub";
    private KDTreeNode rootTreeNode = null;
    private ObjectReservationFilterUI filterUI = null;
    public CommonQueryDialog commonQueryDialog = null;
    private static final BOSUuid rootUuid = BOSUuid.read((String)"111111111111111111111111111=");
    boolean kDTreeMaterialFirstLoad = true;
    public static final String CTX_ONLY_BASE_SRANDARD = "onlyBaseStandard";
    public static final String CTX_GROUP_STANDARD = "groupStandard";
    public static final String CTX_CU = "cu";
    private String groupStandardID;
    private CtrlUnitInfo curCtrlUnitInfo;
    private ItemListener groupStandardListener = null;
    private ItemListener reservationTypeListener = null;
    private HashSet materialGroupSet = new HashSet();
    private FilterInfo matFilter = null;
    private FilterInfo wareFilter = null;
    private FilterInfo inventoryFilter = null;
    private Set authorizedStorageSet = new LinkedHashSet();
    private Set authorizedSouIdSet = new HashSet();
    private static final String permItem = "inventory";
    List<ReservationInfo> reservationObjectList = new ArrayList<ReservationInfo>();
    static final String TB_INVENTORYID = "id";
    static final String TB_MATERIAL_NUMBER = "material.number";
    static final String TB_TOTALRESERVATIONBASEQTY = "totalReservationBaseQty";
    static final String TB_TOTALUNRESERVATIONBASEQTY = "totalUnReservationBaseQty";
    static final String TB_CURRESERVATIONBASEQTY = "curReservationBaseQty";
    static final String TB_BASEQTY = "baseQty";
    Map<String, String> materialMap = new HashMap<String, String>();
    private static boolean hasMoreThanOne = false;

    void initCustomerDataChangeListener() {
        if (null == this.customerDataChangeListener) {
            this.customerDataChangeListener = new DataChangeListener(){

                public void dataChanged(DataChangeEvent e) {
                    ObjectReservationListUI.this.prmtCustomerDataChange(e);
                }
            };
        }
        this.prmtCustomer.addDataChangeListener(this.customerDataChangeListener);
    }

    private void prmtCustomerDataChange(DataChangeEvent e) {
        if (null == e) {
            return;
        }
        if (null == e.getNewValue()) {
            this.reservationObjectID = null;
        }
        if (e.getNewValue().equals(e.getOldValue())) {
            return;
        }
        this.reservationObjectID = ((CustomerInfo)this.prmtCustomer.getValue()).getId().toString();
    }

    void initSalesManDataChangeListener() {
        if (null == this.salesmanDataChangeListener) {
            this.salesmanDataChangeListener = new DataChangeListener(){

                public void dataChanged(DataChangeEvent e) {
                    ObjectReservationListUI.this.prmtSalesmanDataChange(e);
                }
            };
        }
        this.prmtSalesman.setQueryInfo("com.kingdee.eas.basedata.scm.sd.sale.app.F7SalePersonQuery");
        this.prmtSalesman.setDisplayFormat("$name$");
        this.prmtSalesman.setEditFormat("$person.number$");
        this.prmtSalesman.setCommitFormat("$person.number$;$person.idNum$");
        this.prmtSalesman.addDataChangeListener(this.salesmanDataChangeListener);
        SCMClientHelper scmClientHelper = new SCMClientHelper((CoreUIObject)this);
        scmClientHelper.setSalePersonDisplay(this.prmtSalesman);
        scmClientHelper.initSalePersonDisplay(this.prmtSalesman);
    }

    private void prmtSalesmanDataChange(DataChangeEvent e) {
        if (null == e) {
            return;
        }
        if (null == e.getNewValue()) {
            this.reservationObjectID = null;
        }
        if (e.getNewValue().equals(e.getOldValue())) {
            return;
        }
        this.reservationObjectID = ((PersonInfo)this.prmtSalesman.getValue()).getId().toString();
    }

    void initAdminOrgUnitDataChangeListener() {
        if (null == this.adminOrgUnitDataChangeListener) {
            this.adminOrgUnitDataChangeListener = new DataChangeListener(){

                public void dataChanged(DataChangeEvent e) {
                    ObjectReservationListUI.this.prmtAdminOrgUnitDataChange(e);
                }
            };
        }
        this.prmtAdminOrgUnit.addDataChangeListener(this.adminOrgUnitDataChangeListener);
    }

    private void prmtAdminOrgUnitDataChange(DataChangeEvent e) {
        if (null == e) {
            return;
        }
        if (null == e.getNewValue()) {
            this.reservationObjectID = null;
        }
        if (e.getNewValue().equals(e.getOldValue())) {
            return;
        }
        this.reservationObjectID = ((AdminOrgUnitInfo)this.prmtAdminOrgUnit.getValue()).getId().toString();
    }

    void initSaleOrgUnitDataChangeListener() {
        if (null == this.saleOrgUnitDataChangeListener) {
            this.saleOrgUnitDataChangeListener = new DataChangeListener(){

                public void dataChanged(DataChangeEvent e) {
                    ObjectReservationListUI.this.prmtSaleOrgUnitDataChange(e);
                }
            };
        }
        this.prmtSaleOrgUnit.addDataChangeListener(this.saleOrgUnitDataChangeListener);
    }

    private void prmtSaleOrgUnitDataChange(DataChangeEvent e) {
        if (null == e) {
            return;
        }
        if (null == e.getNewValue()) {
            this.reservationObjectID = null;
        }
        if (e.getNewValue().equals(e.getOldValue())) {
            return;
        }
        this.reservationObjectID = ((SaleOrgUnitInfo)this.prmtSaleOrgUnit.getValue()).getId().toString();
    }

    void initStorageOrgUnitDataChangeListener() {
        if (null == this.storageOrgUnitDataChangeListener) {
            this.storageOrgUnitDataChangeListener = new DataChangeListener(){

                public void dataChanged(DataChangeEvent e) {
                    ObjectReservationListUI.this.prmtStorageOrgUnitDataChange(e);
                }
            };
        }
        this.prmtStorageOrgUnit.addDataChangeListener(this.storageOrgUnitDataChangeListener);
    }

    private void prmtStorageOrgUnitDataChange(DataChangeEvent e) {
        if (null == e || null == e.getNewValue()) {
            return;
        }
        StorageOrgUnitInfo sou = (StorageOrgUnitInfo)e.getNewValue();
        OrgUnitCollection orgCol = InvClientUtils.getSaleOrgsInfo(sou);
        HashSet<String> saleOrgIDSet = new HashSet<String>();
        int size = orgCol.size();
        for (int i = 0; i < size; ++i) {
            saleOrgIDSet.add(orgCol.get(i).getId().toString());
        }
        EntityViewInfo view = InvClientUtils.getSaleOrgF7Filter(orgCol);
        this.prmtSaleOrgUnit.setEntityViewInfo(view);
        EntityViewInfo salemanView = new EntityViewInfo();
        FilterInfo salemanFilter = new FilterInfo();
        salemanFilter.getFilterItems().add(new FilterItemInfo("saleOrg.id", saleOrgIDSet, CompareType.INCLUDE));
        salemanView.setFilter(salemanFilter);
        this.prmtSalesman.setEntityViewInfo(salemanView);
        EntityViewInfo customerView = new EntityViewInfo();
        FilterInfo customerFilter = new FilterInfo();
        customerFilter.getFilterItems().add(new FilterItemInfo("saleOrgUnit.id", saleOrgIDSet, CompareType.INCLUDE));
        customerView.setFilter(customerFilter);
        this.prmtCustomer.setEntityViewInfo(customerView);
        EntityViewInfo adminView = new EntityViewInfo();
        FilterInfo adminFilter = new FilterInfo();
        adminFilter.getFilterItems().add(new FilterItemInfo("cu.id", (Object)sou.getCU().getId().toString(), CompareType.EQUALS));
        adminView.setFilter(adminFilter);
        this.prmtAdminOrgUnit.setEntityViewInfo(adminView);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
    }

    protected void menuItemImportData_actionPerformed(ActionEvent e) throws Exception {
        super.menuItemImportData_actionPerformed(e);
    }

    public void actionPageSetup_actionPerformed(ActionEvent e) throws Exception {
        super.actionPageSetup_actionPerformed(e);
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    public void actionHelp_actionPerformed(ActionEvent e) throws Exception {
        super.actionHelp_actionPerformed(e);
    }

    public void actionAbout_actionPerformed(ActionEvent e) throws Exception {
        super.actionAbout_actionPerformed(e);
    }

    public void actionOnLoad_actionPerformed(ActionEvent e) throws Exception {
        super.actionOnLoad_actionPerformed(e);
    }

    public void actionSendMessage_actionPerformed(ActionEvent e) throws Exception {
        super.actionSendMessage_actionPerformed(e);
    }

    public void actionCalculator_actionPerformed(ActionEvent e) throws Exception {
        super.actionCalculator_actionPerformed(e);
    }

    public void actionExport_actionPerformed(ActionEvent e) throws Exception {
        super.actionExport_actionPerformed(e);
    }

    public void actionExportSelected_actionPerformed(ActionEvent e) throws Exception {
        super.actionExportSelected_actionPerformed(e);
    }

    public void actionRegProduct_actionPerformed(ActionEvent e) throws Exception {
        super.actionRegProduct_actionPerformed(e);
    }

    public void actionPersonalSite_actionPerformed(ActionEvent e) throws Exception {
        super.actionPersonalSite_actionPerformed(e);
    }

    public void actionProcductVal_actionPerformed(ActionEvent e) throws Exception {
        super.actionProcductVal_actionPerformed(e);
    }

    public void actionExportSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionExportSave_actionPerformed(e);
    }

    public void actionExportSelectedSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionExportSelectedSave_actionPerformed(e);
    }

    public void actionKnowStore_actionPerformed(ActionEvent e) throws Exception {
        super.actionKnowStore_actionPerformed(e);
    }

    public void actionAnswer_actionPerformed(ActionEvent e) throws Exception {
        super.actionAnswer_actionPerformed(e);
    }

    public void actionRemoteAssist_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemoteAssist_actionPerformed(e);
    }

    public void actionPopupCopy_actionPerformed(ActionEvent e) throws Exception {
        super.actionPopupCopy_actionPerformed(e);
    }

    public void actionHTMLForMail_actionPerformed(ActionEvent e) throws Exception {
        super.actionHTMLForMail_actionPerformed(e);
    }

    public void actionExcelForMail_actionPerformed(ActionEvent e) throws Exception {
        super.actionExcelForMail_actionPerformed(e);
    }

    public void actionHTMLForRpt_actionPerformed(ActionEvent e) throws Exception {
        super.actionHTMLForRpt_actionPerformed(e);
    }

    public void actionExcelForRpt_actionPerformed(ActionEvent e) throws Exception {
        super.actionExcelForRpt_actionPerformed(e);
    }

    public void actionLinkForRpt_actionPerformed(ActionEvent e) throws Exception {
        super.actionLinkForRpt_actionPerformed(e);
    }

    public void actionPopupPaste_actionPerformed(ActionEvent e) throws Exception {
        super.actionPopupPaste_actionPerformed(e);
    }

    public void actionToolBarCustom_actionPerformed(ActionEvent e) throws Exception {
        super.actionToolBarCustom_actionPerformed(e);
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        super.actionView_actionPerformed(e);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemove_actionPerformed(e);
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
    }

    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrint_actionPerformed(e);
    }

    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrintPreview_actionPerformed(e);
    }

    public void actionLocate_actionPerformed(ActionEvent e) throws Exception {
        super.actionLocate_actionPerformed(e);
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        super.actionQuery_actionPerformed(e);
    }

    public void actionImportData_actionPerformed(ActionEvent e) throws Exception {
        super.actionImportData_actionPerformed(e);
    }

    public void actionAttachment_actionPerformed(ActionEvent e) throws Exception {
        super.actionAttachment_actionPerformed(e);
    }

    public void actionExportData_actionPerformed(ActionEvent e) throws Exception {
        super.actionExportData_actionPerformed(e);
    }

    public void actionToExcel_actionPerformed(ActionEvent e) throws Exception {
        super.actionToExcel_actionPerformed(e);
    }

    public void actionStartWorkFlow_actionPerformed(ActionEvent e) throws Exception {
        super.actionStartWorkFlow_actionPerformed(e);
    }

    public void actionPublishReport_actionPerformed(ActionEvent e) throws Exception {
        super.actionPublishReport_actionPerformed(e);
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancel_actionPerformed(e);
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancelCancel_actionPerformed(e);
    }

    public void actionQueryScheme_actionPerformed(ActionEvent e) throws Exception {
        super.actionQueryScheme_actionPerformed(e);
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    protected String getEditUIName() {
        return null;
    }

    public OrgType getMainType() {
        return super.getMainType();
    }

    private boolean initKDTreeMain(JTree kdTree) throws Exception {
        kdTree.setModel(new DefaultTreeModel((TreeNode)this.createRootNode()));
        kdTree.setShowsRootHandles(true);
        this.expandAll(kdTree, new TreePath(this.rootTreeNode));
        return true;
    }

    private void expandAll(JTree tree, TreePath parent) {
        KDTreeNode node = (KDTreeNode)parent.getLastPathComponent();
        if (node.getChildCount() > 0) {
            Enumeration e = node.children();
            while (e.hasMoreElements()) {
                KDTreeNode n = (KDTreeNode)e.nextElement();
                TreePath path = parent.pathByAddingChild(n);
                this.expandAll(tree, path);
            }
        }
        tree.expandPath(parent);
    }

    private void addChildrenToNode(BillTypeGroupEnum billTypeGroupEnum, KDTreeNode treeNode) throws Exception {
        IBillType iBillType = BillTypeFactory.getRemoteInstance();
        EntityViewInfo entityView = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("billTypeGroup", (Object)new Integer(12), CompareType.EQUALS));
        entityView.getSelector().add(new SelectorItemInfo(TB_INVENTORYID));
        entityView.getSelector().add(new SelectorItemInfo("name"));
        entityView.getSelector().add(new SelectorItemInfo("number"));
        entityView.setFilter(filterInfo);
        BillTypeCollection collection = iBillType.getBillTypeCollection(entityView);
        if (collection != null && collection.size() > 0) {
            for (int i = 0; i < collection.size(); ++i) {
                BillTypeInfo aBillTypeInfo = collection.get(i);
                KDTreeNode childrenNode = new KDTreeNode((Object)aBillTypeInfo);
                treeNode.add((MutableTreeNode)childrenNode);
            }
        }
    }

    public void onLoad() throws Exception {
        this.getAuthorizedStorageSet();
        this.curCtrlUnitInfo = (CtrlUnitInfo)this.getUIContext().get(CTX_CU);
        if (this.curCtrlUnitInfo == null) {
            this.curCtrlUnitInfo = SysContext.getSysContext().getCurrentCtrlUnit();
        }
        this.initReservationListener();
        this.loadGroupStandard();
        this.firstExpendkDTreeMaterial();
        this.kDTreeMaterial.addTreeSelectionListener((TreeSelectionListener)this);
        this.kDTreeMaterial.addTreeWillExpandListener((TreeWillExpandListener)this);
        super.onLoad();
        this.comboReservationType.setSelectedIndex(0);
        this.comboReservationType.setSelectedIndex(1);
        this.initCustomerDataChangeListener();
        this.initSalesManDataChangeListener();
        this.initAdminOrgUnitDataChangeListener();
        this.initSaleOrgUnitDataChangeListener();
        this.initStorageOrgUnitDataChangeListener();
        this.initCurReservationBaseQtyCell();
        this.tblMain.addKDTEditListener((KDTEditListener)this);
    }

    void initCurReservationBaseQtyCell() {
        KDFormattedTextField detailTable_curReservationBaseQty_TextField = new KDFormattedTextField();
        detailTable_curReservationBaseQty_TextField.setName("detailTable_curReservationBaseQty_TextField");
        detailTable_curReservationBaseQty_TextField.setVisible(true);
        detailTable_curReservationBaseQty_TextField.setEditable(true);
        detailTable_curReservationBaseQty_TextField.setHorizontalAlignment(2);
        detailTable_curReservationBaseQty_TextField.setDataType(1);
        detailTable_curReservationBaseQty_TextField.setPrecision(6);
        detailTable_curReservationBaseQty_TextField.setSupportedEmpty(true);
        KDTDefaultCellEditor detailTable_curReservationBaseQty_CellEditor = new KDTDefaultCellEditor((JTextField)detailTable_curReservationBaseQty_TextField);
        this.getDetailTable().getColumn(TB_CURRESERVATIONBASEQTY).getStyleAttributes().setLocked(false);
        this.getDetailTable().getColumn(TB_CURRESERVATIONBASEQTY).setEditor((ICellEditor)detailTable_curReservationBaseQty_CellEditor);
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    public void onShow() throws Exception {
        super.onShow();
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        try {
            this.materialTree_valueChanged(e);
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }

    private CustomerQueryPanel getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new ObjectReservationFilterUI();
        }
        return this.filterUI;
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        if (this.commonQueryDialog == null) {
            if (this.mainQuery == null) {
                this.mainQuery = new EntityViewInfo();
            }
            this.commonQueryDialog = super.initCommonQueryDialog();
            try {
                this.commonQueryDialog.addUserPanel((KDPanel)this.getFilterUI());
            }
            catch (Exception e) {
                this.handUIException(e);
                SysUtil.abort();
            }
        }
        return this.commonQueryDialog;
    }

    private IRowSet getMaterialGroupSet() throws Exception {
        MaterialGroupStandardInfo materialGroupStandard;
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        viewInfo.setFilter(fi);
        if (this.filterUI == null) {
            this.getFilterUI();
        }
        if ((materialGroupStandard = (MaterialGroupStandardInfo)this.comboGroupStandard.getSelectedItem()) != null) {
            fi.getFilterItems().add(new FilterItemInfo("groupStandard.id", (Object)materialGroupStandard.getId().toString()));
        }
        MetaDataPK queryPK = MetaDataPK.create((String)"com.kingdee.eas.scm.im.inv.InventoryMaterialGroupQuery");
        IQueryExecutor queryExcu = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)queryPK);
        queryExcu.setObjectView(viewInfo);
        return queryExcu.executeQuery();
    }

    private void addMaterialGroupNodes(KDTreeNode treeNode) throws Exception {
        IRowSet rs = this.getMaterialGroupSet();
        while (rs.next()) {
        }
    }

    public DefaultKingdeeTreeNode buildkDTreeMaterialByRowSet(IRowSet rows) throws Exception {
        if (rows == null) {
            return null;
        }
        DefaultKingdeeTreeNode rootTreeNode = null;
        DefaultKingdeeTreeNode parentNode = null;
        KDTreeNode subTreeNode = null;
        HashMap<String, Object> nodeMap = new HashMap<String, Object>();
        MaterialGroupInfo mGroupInfo = this.createRootMaterialGroupInfo();
        rootTreeNode = new DefaultKingdeeTreeNode((Object)mGroupInfo);
        rootTreeNode.setAllowsChildren(true);
        rootTreeNode.setText(EASResource.getString((String)"com.kingdee.eas.scm.im.IMAutoGenerateResource", (String)"56_InventoryListUI"));
        nodeMap.put(mGroupInfo.getId().toString(), rootTreeNode);
        while (rows.next()) {
            mGroupInfo = this.createMaterialGroup(rows);
            subTreeNode = new KDTreeNode((Object)mGroupInfo);
            if (!nodeMap.containsKey(mGroupInfo.getParent().getId().toString())) continue;
            parentNode = (DefaultKingdeeTreeNode)nodeMap.get(mGroupInfo.getParent().getId().toString());
            parentNode.add((MutableTreeNode)subTreeNode);
            subTreeNode.setText(mGroupInfo.getNumber() + "(" + mGroupInfo.getName() + ")");
            subTreeNode.setAllowsChildren(true);
            nodeMap.put(mGroupInfo.getId().toString(), subTreeNode);
        }
        this.fillkDTreeMaterialLeaf(rootTreeNode);
        return rootTreeNode;
    }

    private MaterialGroupInfo createRootMaterialGroupInfo() throws Exception {
        MaterialGroupInfo mGroupInfo = new MaterialGroupInfo();
        mGroupInfo.setId(rootUuid);
        mGroupInfo.setName(EASResource.getString((String)"com.kingdee.eas.scm.im.IMAutoGenerateResource", (String)"56_InventoryListUI"));
        mGroupInfo.setNumber("");
        return mGroupInfo;
    }

    private MaterialGroupInfo createMaterialGroup(IRowSet row) throws Exception {
        MaterialGroupInfo mGroupInfo = new MaterialGroupInfo();
        mGroupInfo.setId(BOSUuid.read((String)row.getString(TB_INVENTORYID)));
        mGroupInfo.setName(row.getString("name"));
        mGroupInfo.setNumber(row.getString("number"));
        mGroupInfo.setLongNumber(row.getString("longNumber"));
        mGroupInfo.setLevel(row.getInt("level"));
        mGroupInfo.setIsLeaf(row.getBoolean("isLeaf"));
        MaterialGroupInfo parentInfo = new MaterialGroupInfo();
        if (row.getString("parent.id") == null || row.getString("parent.id").equals("")) {
            parentInfo.setId(rootUuid);
        } else {
            parentInfo.setId(BOSUuid.read((String)row.getString("parent.id")));
        }
        mGroupInfo.setParent(parentInfo);
        return mGroupInfo;
    }

    public void fillkDTreeMaterialLeaf(DefaultKingdeeTreeNode parentNode) throws Exception {
        MaterialGroupInfo mGroupInfo = (MaterialGroupInfo)parentNode.getUserObject();
        IRowSet rows = null;
        rows = mGroupInfo.getId().equals((Object)rootUuid) && this.kDTreeMaterialFirstLoad ? this.getNoGroupMaterialSet() : this.getMaterialSet(mGroupInfo);
        MaterialInfo materialInfo = new MaterialInfo();
        KDTreeNode subTreeNode = null;
        while (rows.next()) {
            materialInfo = this.createMaterial(rows);
            subTreeNode = new KDTreeNode((Object)materialInfo);
            subTreeNode.setText(materialInfo.getNumber() + "(" + materialInfo.getName() + ")");
            subTreeNode.setAllowsChildren(false);
            parentNode.add((MutableTreeNode)subTreeNode);
        }
    }

    private IRowSet getNoGroupMaterialSet() throws Exception {
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.getSelector().add(new SelectorItemInfo("name"));
        viewInfo.getSelector().add(new SelectorItemInfo("number"));
        viewInfo.getSelector().add(new SelectorItemInfo(TB_INVENTORYID));
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("materialGroup.id", null));
        viewInfo.setFilter(fi);
        MetaDataPK queryPK = MetaDataPK.create((String)"com.kingdee.eas.basedata.master.material.app.MaterialQuery");
        IQueryExecutor queryExcu = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)queryPK);
        queryExcu.setObjectView(viewInfo);
        return queryExcu.executeQuery();
    }

    private IRowSet getMaterialSet(MaterialGroupInfo mGroupInfo) throws Exception {
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.getSelector().add(new SelectorItemInfo("materialGroup.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("name"));
        viewInfo.getSelector().add(new SelectorItemInfo("number"));
        viewInfo.getSelector().add(new SelectorItemInfo(TB_INVENTORYID));
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("materialGroup.id", (Object)mGroupInfo.getId().toString()));
        viewInfo.setFilter(fi);
        MetaDataPK queryPK = MetaDataPK.create((String)"com.kingdee.eas.basedata.master.material.app.MaterialQuery");
        IQueryExecutor queryExcu = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)queryPK);
        queryExcu.setObjectView(viewInfo);
        return queryExcu.executeQuery();
    }

    private MaterialInfo createMaterial(IRowSet row) throws Exception {
        MaterialInfo materialInfo = new MaterialInfo();
        materialInfo.setId(BOSUuid.read((String)row.getString(TB_INVENTORYID)));
        materialInfo.setName(row.getString("name"));
        materialInfo.setNumber(row.getString("number"));
        return materialInfo;
    }

    public void firstExpendkDTreeMaterial() throws Exception {
        if (this.kDTreeMaterialFirstLoad) {
            this.fillkDTreeMaterial();
            this.kDTreeMaterialFirstLoad = false;
        }
    }

    private void fillkDTreeMaterial() throws Exception {
        this.kDTreeMaterial.setModel((TreeModel)new KingdeeTreeModel((TreeNode)this.createRootNode()));
        this.kDTreeMaterial.setShowsRootHandles(true);
        if (this.kDTreeMaterial.getModel() != null) {
            ((KingdeeTreeModel)this.kDTreeMaterial.getModel()).setAsksAllowsChildren(true);
            this.kDTreeMaterial.setShowsRootHandles(true);
        }
    }

    private DefaultKingdeeTreeNode createRootNode() throws Exception {
        IRowSet rows = this.getMaterialGroupSet();
        return this.buildkDTreeMaterialByRowSet(rows);
    }

    private void initReservationListener() {
        this.comboReservationType.removeItemListener(this.reservationTypeListener);
        this.comboReservationType.removeItem((Object)ReservationTypeEnum.ReservationType_Null);
        this.comboReservationType.removeItem((Object)ReservationTypeEnum.ReservationType_Bill);
        this.reservationTypeListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ObjectReservationListUI.this.reservationTypeChange(e);
            }
        };
        this.comboReservationType.addItemListener(this.reservationTypeListener);
    }

    private void reservationTypeChange(ItemEvent e) {
        int selectValue;
        ReservationTypeEnum reservationTypeEnum = (ReservationTypeEnum)((Object)this.comboReservationType.getSelectedItem());
        this.reservationType = selectValue = reservationTypeEnum.getValue();
    }

    private void loadGroupStandard() throws Exception {
        this.groupStandardListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ObjectReservationListUI.this.itemChanaged(e);
            }
        };
        this.comboGroupStandard.removeItemListener(this.groupStandardListener);
        MaterialGroupStandardInfo groupStandard = null;
        Boolean onlyBaseStandard = (Boolean)this.getUIContext().get(CTX_ONLY_BASE_SRANDARD);
        if (onlyBaseStandard != null && onlyBaseStandard.booleanValue()) {
            IMaterialGroupStandard iBiz = MaterialGroupStandardFactory.getRemoteInstance();
            MaterialGroupStandardCollection baseGroupStandardColl = iBiz.getBaseMaterialGroupStandardColl();
            if (baseGroupStandardColl.size() > 0) {
                groupStandard = baseGroupStandardColl.get(0);
            }
        } else {
            groupStandard = (MaterialGroupStandardInfo)this.getUIContext().get(CTX_GROUP_STANDARD);
        }
        if (groupStandard != null) {
            this.comboGroupStandard.removeAllItems();
            this.comboGroupStandard.addItem((Object)groupStandard);
            this.comboGroupStandard.setSelectedIndex(0);
            this.groupStandardID = groupStandard.getId().toString();
        } else {
            IMaterialGroupStandard iMaterialGroupStandard = MaterialGroupStandardFactory.getRemoteInstance();
            FilterInfo filterInfoCU = EntityControlTypeUtil.getFilterInfoForControlTypeS4((String)this.curCtrlUnitInfo.getId().toString(), (String)this.curCtrlUnitInfo.getLongNumber());
            EntityViewInfo viewInfo = new EntityViewInfo();
            viewInfo.setFilter(filterInfoCU);
            MaterialGroupStandardCollection groupStandardColl = iMaterialGroupStandard.getMaterialGroupStandardCollection(viewInfo);
            this.comboGroupStandard.removeAllItems();
            if (groupStandardColl != null) {
                this.comboGroupStandard.addItems(groupStandardColl.toArray());
            }
            int defaultIndex = 0;
            int size = groupStandardColl.size();
            for (int index = 0; index < size; ++index) {
                if (!groupStandardColl.get(index).getStandardType().equals((Object)MaterialGroupStandardTypeEnum.BasicStandard)) continue;
                defaultIndex = index;
                break;
            }
            this.comboGroupStandard.setSelectedIndex(defaultIndex);
            MaterialGroupStandardInfo groupStandardInfo = groupStandardColl.get(defaultIndex);
            this.groupStandardID = groupStandardInfo.getId().toString();
            this.comboGroupStandard.addItemListener(this.groupStandardListener);
        }
    }

    private void itemChanaged(ItemEvent e) {
        try {
            this.fillkDTreeMaterial();
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }

    protected void materialTree_valueChanged(TreeSelectionEvent e) throws Exception {
        this.firstExpendkDTreeMaterial();
        if (e.getNewLeadSelectionPath() != null) {
            try {
                TreePath path = this.kDTreeMaterial.getSelectionPath();
                if (path == null) {
                    return;
                }
                DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)path.getLastPathComponent();
                if (node != null && node.getUserObject() instanceof MaterialGroupInfo && !this.materialGroupSet.contains(((MaterialGroupInfo)node.getUserObject()).getId())) {
                    this.fillkDTreeMaterialLeaf(node);
                    this.materialGroupSet.add(((MaterialGroupInfo)node.getUserObject()).getId());
                }
                this.mainQuery = this.getQueryViewInfo();
                this.refreshList();
            }
            catch (Exception ex) {
                this.handUIException(ex);
            }
        }
    }

    public void materialTree_treeWillExpand(TreeExpansionEvent e) throws Exception {
        this.firstExpendkDTreeMaterial();
        if (e.getPath() != null) {
            try {
                TreePath path = e.getPath();
                if (path == null) {
                    return;
                }
                DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)path.getLastPathComponent();
                if (node.getUserObject() instanceof MaterialGroupInfo && !this.materialGroupSet.contains(((MaterialGroupInfo)node.getUserObject()).getId())) {
                    this.fillkDTreeMaterialLeaf(node);
                    this.kDTreeMaterial.repaint();
                }
            }
            catch (Exception ex) {
                this.handUIException(ex);
            }
        }
    }

    @Override
    public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
    }

    @Override
    public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
        try {
            this.materialTree_treeWillExpand(event);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        if (null == viewInfo || null == viewInfo.getFilter()) {
            viewInfo = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo(TB_INVENTORYID, (Object)"111"));
            viewInfo.setFilter(filter);
        }
        if (null == viewInfo || null == viewInfo.getFilter() || CollectionUtil.isEmpty((AbstractObjectCollection)viewInfo.getFilter().getFilterItems())) {
            viewInfo.getFilter().getFilterItems().add(new FilterItemInfo(TB_INVENTORYID, (Object)"111"));
        }
        IQueryExecutor queryExcu = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)queryPK);
        queryExcu.setObjectView(viewInfo);
        Object rs = null;
        return super.getQueryExecutor(queryPK, viewInfo);
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    public EntityViewInfo getQueryViewInfo() throws BOSException {
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo evFilter = new FilterInfo();
        FilterInfo authorizedStorageFilter = new FilterInfo();
        evFilter = this.mergeFilter(evFilter, this.getStoreOrgUnitFilterInfo(), "AND");
        TreePath path = this.kDTreeMaterial.getSelectionPath();
        if (path != null) {
            MaterialInfo materialInfo;
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)path.getLastPathComponent();
            if (node.getUserObject() instanceof MaterialGroupInfo) {
                MaterialGroupInfo materialGroupInfo = (MaterialGroupInfo)node.getUserObject();
                if (!materialGroupInfo.getId().equals((Object)rootUuid)) {
                    evFilter = this.mergeFilter(evFilter, this.getMaterialGroupFilterInfo(materialGroupInfo), "AND");
                }
            } else if (node.getUserObject() instanceof MaterialInfo && !(materialInfo = (MaterialInfo)node.getUserObject()).getId().equals((Object)rootUuid)) {
                evFilter = this.mergeFilter(evFilter, this.getMaterialFilterInfo(materialInfo), "AND");
            }
        }
        if (this.matFilter != null) {
            evFilter.mergeFilter(this.matFilter, "AND");
        }
        if (this.wareFilter != null) {
            evFilter.mergeFilter(this.wareFilter, "AND");
        }
        if (this.inventoryFilter != null) {
            evFilter.mergeFilter(this.inventoryFilter, "AND");
        }
        authorizedStorageFilter.getFilterItems().add(new FilterItemInfo("storageOrgUnit.number", (Object)this.authorizedStorageSet, CompareType.INCLUDE));
        evFilter = this.mergeFilter(evFilter, authorizedStorageFilter, "AND");
        ev.setFilter(evFilter);
        return ev;
    }

    public FilterInfo getStoreOrgUnitFilterInfo() {
        Object object = null;
        FilterInfo filterInfo = new FilterInfo();
        if (object != null) {
            try {
                if (object instanceof StorageOrgUnitInfo) {
                    filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)((StorageOrgUnitInfo)object).getId(), CompareType.EQUALS));
                } else if (object instanceof FullOrgUnitInfo) {
                    filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)((FullOrgUnitInfo)object).getId(), CompareType.EQUALS));
                }
            }
            catch (Exception e1) {
                this.handUIException(e1);
            }
        }
        return filterInfo;
    }

    public FilterInfo getMaterialGroupFilterInfo(MaterialGroupInfo materialGroupInfo) {
        FilterInfo filterInfo = new FilterInfo();
        if (materialGroupInfo != null && !materialGroupInfo.getNumber().equals("")) {
            filterInfo.getFilterItems().add(new FilterItemInfo("materialGroup.number", (Object)materialGroupInfo.getNumber(), CompareType.EQUALS));
            FilterInfo filterInfo2 = new FilterInfo();
            String longNumer = materialGroupInfo.getLongNumber();
            if (!StringUtil.isEmpty((String)longNumer)) {
                filterInfo2.getFilterItems().add(new FilterItemInfo("materialGroup.longnumber", (Object)(longNumer + "%"), CompareType.LIKE));
            }
            try {
                filterInfo.mergeFilter(filterInfo2, "or");
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
        }
        return filterInfo;
    }

    public FilterInfo mergeFilter(FilterInfo filterInfo, FilterInfo addFilterInfo, String logicStr) throws BOSException {
        if (filterInfo.getFilterItems().size() > 0) {
            if (addFilterInfo.getFilterItems().size() > 0) {
                filterInfo.mergeFilter(addFilterInfo, logicStr);
            }
        } else {
            filterInfo = addFilterInfo;
        }
        if (filterInfo.getFilterItems().size() > 0 && (filterInfo.getMaskString() == null || filterInfo.getMaskString().equals(""))) {
            filterInfo.setMaskString("#0");
        }
        return filterInfo;
    }

    public FilterInfo getMaterialFilterInfo(MaterialInfo materialInfo) {
        FilterInfo filterInfo = new FilterInfo();
        if (materialInfo != null && !materialInfo.getNumber().equals("")) {
            filterInfo.getFilterItems().add(new FilterItemInfo(TB_MATERIAL_NUMBER, (Object)materialInfo.getNumber(), CompareType.EQUALS));
        }
        return filterInfo;
    }

    protected void getAuthorizedStorageSet() {
        ObjectUuidPK userPK = new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId());
        Object[] storageOrgs = null;
        try {
            FullOrgUnitCollection coll = PermissionFactory.getRemoteInstance().getAuthorizedOrg((IObjectPK)userPK, OrgType.Storage, null, permItem);
            storageOrgs = coll.toArray();
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        int count = storageOrgs.length;
        if (count > 0) {
            OrgUnitInfo orgUnit = null;
            String number = null;
            for (int i = 0; i < count; ++i) {
                orgUnit = (OrgUnitInfo)storageOrgs[i];
                if (orgUnit == null || (number = orgUnit.getNumber()) == null) continue;
                this.authorizedSouIdSet.add(orgUnit.getId().toString());
                this.authorizedStorageSet.add(number);
            }
        }
    }

    private void checkReservationValidate() {
        int isOK;
        BigDecimal curReservationBaseQty;
        ReservationTypeEnum reservationType = (ReservationTypeEnum)((Object)this.comboReservationType.getSelectedItem());
        int selectValue = reservationType.getValue();
        if (this.getDetailTable() == null || this.getDetailTable().getRowCount() == 0) {
            SysUtil.abort();
        }
        if (this.hasMoreThanOneMaterial()) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.scm.im.reservation.RESERVATIONAutoGenerateResource", (String)"33_ObjectReservationListUI"));
            SysUtil.abort();
        }
        BigDecimal totalUnReservationBaseQty = this.getTotalUnReservationBaseQty();
        if (null != this.fmtReservationBaseQty.getValue() && totalUnReservationBaseQty.compareTo(curReservationBaseQty = (BigDecimal)this.fmtReservationBaseQty.getValue()) < 0 && (isOK = MsgBox.showConfirm2((String)EASResource.getString((String)"com.kingdee.eas.scm.im.reservation.RESERVATIONAutoGenerateResource", (String)"34_ObjectReservationListUI"))) != 0) {
            SysUtil.abort();
        }
        IRow row = null;
        BigDecimal curReservationBaseQty2 = NumericUtil.BIGDECIMAL_ZERO;
        BigDecimal unReservationBaseQty = NumericUtil.BIGDECIMAL_ZERO;
        int size = this.getDetailTable().getRowCount();
        for (int i = 0; i < size; ++i) {
            row = this.getDetailTable().getRow(i);
            curReservationBaseQty2 = (BigDecimal)row.getCell(TB_CURRESERVATIONBASEQTY).getValue();
            unReservationBaseQty = (BigDecimal)row.getCell(TB_TOTALUNRESERVATIONBASEQTY).getValue();
            if (curReservationBaseQty2 == null || curReservationBaseQty2.compareTo(NumericUtil.BIGDECIMAL_ZERO) == 0 || curReservationBaseQty2.compareTo(unReservationBaseQty) <= 0) continue;
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.scm.im.reservation.RESERVATIONAutoGenerateResource", (String)"35_ObjectReservationListUI"));
            row.getCell(TB_CURRESERVATIONBASEQTY).setValue(null);
        }
    }

    boolean hasMoreThanOneMaterial() {
        if (null == this.getDetailTable() || 0 == this.getDetailTable().getRowCount()) {
            return false;
        }
        HashMap materialMap = new HashMap();
        IRow row = null;
        int size = this.getDetailTable().getRowCount();
        for (int i = 0; i < size; ++i) {
            row = this.getDetailTable().getRow(i);
            materialMap.put(row.getCell(TB_MATERIAL_NUMBER).getValue().toString(), null);
            if (materialMap.size() <= 1) continue;
            return true;
        }
        return false;
    }

    private void fillReservationData() {
        this.reservationObjectList.clear();
        boolean isSelectTable = this.getDetailTable().getSelectManager().size() != 0;
        BigDecimal totalUnReservationBaseQty = NumericUtil.BIGDECIMAL_ZERO;
        ArrayList retList = new ArrayList();
        BigDecimal curReservationBaseQty = (BigDecimal)this.fmtReservationBaseQty.getValue();
        if (curReservationBaseQty == null || curReservationBaseQty.compareTo(NumericUtil.BIGDECIMAL_ZERO) == 0) {
            return;
        }
        BigDecimal baseqty = NumericUtil.BIGDECIMAL_ZERO;
        BigDecimal totalreservationbaseqty = NumericUtil.BIGDECIMAL_ZERO;
        BigDecimal unreservationbaseqty = NumericUtil.BIGDECIMAL_ZERO;
        int index_baseqty = this.getDetailTable().getColumnIndex(TB_BASEQTY);
        int index_totalreservationbaseqty = this.getDetailTable().getColumnIndex(TB_TOTALRESERVATIONBASEQTY);
        int index_unreservationbaseqty = this.getDetailTable().getColumnIndex(TB_TOTALUNRESERVATIONBASEQTY);
        int index_curreservationbaseqty = this.getDetailTable().getColumnIndex(TB_CURRESERVATIONBASEQTY);
        ReservationInfo reservationInfo = null;
        int rowCount = this.getDetailTable().getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            IRow row = this.getDetailTable().getRow(i);
            baseqty = row.getCell(index_baseqty).getValue() == null ? NumericUtil.BIGDECIMAL_ZERO : (BigDecimal)row.getCell(index_baseqty).getValue();
            unreservationbaseqty = baseqty.subtract(totalreservationbaseqty = row.getCell(index_totalreservationbaseqty).getValue() == null ? NumericUtil.BIGDECIMAL_ZERO : (BigDecimal)row.getCell(index_totalreservationbaseqty).getValue());
            if (unreservationbaseqty.compareTo(NumericUtil.BIGDECIMAL_ZERO) == 0) continue;
            reservationInfo = new ReservationInfo();
            reservationInfo.setId(BOSUuid.create((String)"8D307D69"));
            reservationInfo.setReservationType((ReservationTypeEnum)((Object)this.comboReservationType.getSelectedItem()));
            reservationInfo.setObjectID(this.reservationObjectID);
            reservationInfo.setInventoryID(row.getCell(TB_INVENTORYID).getValue().toString());
            StorageOrgUnitInfo sou = new StorageOrgUnitInfo();
            sou.setId(BOSUuid.read((String)row.getCell("storageOrgUnit.id").getValue().toString()));
            reservationInfo.setStorageOrg(sou);
            if (curReservationBaseQty.compareTo(unreservationbaseqty) > 0) {
                row.getCell(index_curreservationbaseqty).setValue((Object)unreservationbaseqty);
                curReservationBaseQty = curReservationBaseQty.subtract(unreservationbaseqty);
                reservationInfo.setReservationBaseQty(unreservationbaseqty);
            } else {
                row.getCell(index_curreservationbaseqty).setValue((Object)curReservationBaseQty);
                reservationInfo.setReservationBaseQty(curReservationBaseQty);
                curReservationBaseQty = NumericUtil.BIGDECIMAL_ZERO;
            }
            MeasureUnitInfo baseUnit = new MeasureUnitInfo();
            baseUnit.setId(BOSUuid.read((String)row.getCell("baseUnit.id").getValue().toString()));
            reservationInfo.setBaseUnit(baseUnit);
            MaterialInfo material = new MaterialInfo();
            material.setId(BOSUuid.read((String)row.getCell("material.id").getValue().toString()));
            reservationInfo.setMaterial(material);
            if (curReservationBaseQty.compareTo(NumericUtil.BIGDECIMAL_ZERO) == 0) break;
        }
    }

    void buildObjectReservationList() {
        this.reservationObjectList.clear();
        IRow row = null;
        ReservationInfo reservationInfo = null;
        int size = this.getDetailTable().getRowCount();
        for (int i = 0; i < size; ++i) {
            row = this.getDetailTable().getRow(i);
            if (row.getCell(TB_CURRESERVATIONBASEQTY).getValue() == null) continue;
            reservationInfo = new ReservationInfo();
            reservationInfo.setId(BOSUuid.create((String)"8D307D69"));
            reservationInfo.setReservationType((ReservationTypeEnum)((Object)this.comboReservationType.getSelectedItem()));
            reservationInfo.setObjectID(this.reservationObjectID);
            reservationInfo.setInventoryID(row.getCell(TB_INVENTORYID).getValue().toString());
            StorageOrgUnitInfo sou = new StorageOrgUnitInfo();
            sou.setId(BOSUuid.read((String)row.getCell("storageOrgUnit.id").getValue().toString()));
            reservationInfo.setStorageOrg(sou);
            MeasureUnitInfo baseUnit = new MeasureUnitInfo();
            baseUnit.setId(BOSUuid.read((String)row.getCell("baseUnit.id").getValue().toString()));
            reservationInfo.setBaseUnit(baseUnit);
            MaterialInfo material = new MaterialInfo();
            material.setId(BOSUuid.read((String)row.getCell("material.id").getValue().toString()));
            reservationInfo.setMaterial(material);
            reservationInfo.setReservationBaseQty((BigDecimal)row.getCell(TB_CURRESERVATIONBASEQTY).getValue());
            this.reservationObjectList.add(reservationInfo);
        }
    }

    void clearCurReservationCell() {
        IRow row = null;
        int size = this.getDetailTable().getRowCount();
        for (int i = 0; i < size; ++i) {
            row = this.getDetailTable().getRow(i);
            row.getCell(TB_CURRESERVATIONBASEQTY).setValue(null);
        }
    }

    void doObjectReservation() throws BOSException, EASBizException, Exception {
        this.buildObjectReservationList();
        if (CollectionUtil.isEmpty(this.reservationObjectList)) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.scm.im.reservation.RESERVATIONAutoGenerateResource", (String)"36_ObjectReservationListUI"));
            SysUtil.abort();
        }
        IReservation iReservation = ReservationFactory.getRemoteInstance();
        iReservation.doObjectReservation(this.reservationObjectList);
        this.refreshList();
        String msg = EASResource.getString((String)"com.kingdee.eas.scm.im.reservation.RESERVATIONAutoGenerateResource", (String)"37_ObjectReservationListUI");
        this.setMessageText(msg);
        this.showMessage();
    }

    private BigDecimal getTotalUnReservationBaseQty() {
        int i;
        BigDecimal totalUnReservationBaseQty = NumericUtil.BIGDECIMAL_ZERO;
        ArrayList<BigDecimal> retList = new ArrayList<BigDecimal>();
        BigDecimal baseqty = NumericUtil.BIGDECIMAL_ZERO;
        BigDecimal totalreservationbaseqty = NumericUtil.BIGDECIMAL_ZERO;
        int index_baseqty = this.getDetailTable().getColumnIndex(TB_BASEQTY);
        int index_totalreservationbaseqty = this.getDetailTable().getColumnIndex(TB_TOTALRESERVATIONBASEQTY);
        int rowCount = this.getDetailTable().getRowCount();
        for (i = 0; i < rowCount; ++i) {
            IRow row = this.getDetailTable().getRow(i);
            baseqty = (BigDecimal)row.getCell(index_baseqty).getValue();
            totalreservationbaseqty = (BigDecimal)row.getCell(index_totalreservationbaseqty).getValue();
            if (baseqty == null) continue;
            if (totalreservationbaseqty == null) {
                retList.add(baseqty);
                continue;
            }
            retList.add(baseqty.subtract(totalreservationbaseqty));
        }
        int size = retList.size();
        for (i = 0; i < size; ++i) {
            totalUnReservationBaseQty = totalUnReservationBaseQty.add((BigDecimal)retList.get(i));
        }
        return totalUnReservationBaseQty;
    }

    @Override
    protected void btnFillData_actionPerformed(ActionEvent e) throws Exception {
        this.fillReservationData();
        super.btnFillData_actionPerformed(e);
    }

    @Override
    protected void btnSaveReservation_actionPerformed(ActionEvent e) throws Exception {
        this.checkReservationValidate();
        this.clearCurReservationCell();
        this.fillReservationData();
        this.doObjectReservation();
        super.btnSaveReservation_actionPerformed(e);
    }

    @Override
    public void actionSaveObjectReservation_actionPerformed(ActionEvent e) throws Exception {
        this.checkReservationValidate();
        this.doObjectReservation();
        super.actionSaveObjectReservation_actionPerformed(e);
    }

    protected KDTable getDetailTable() {
        return this.tblMain;
    }

    protected void getRowSetBeforeFillTable(IRowSet rowSet) {
        super.getRowSetBeforeFillTable(rowSet);
        HashMap materialMap = new HashMap();
        hasMoreThanOne = false;
        int precision = 0;
        try {
            block2: while (rowSet.next()) {
                precision = rowSet.getInt("multiBaseUnit.qtyPrecision");
                if (rowSet.getBigDecimal(TB_TOTALRESERVATIONBASEQTY) == null) {
                    rowSet.updateBigDecimal(TB_TOTALRESERVATIONBASEQTY, NumericUtil.BIGDECIMAL_ZERO);
                }
                rowSet.updateBigDecimal(TB_TOTALUNRESERVATIONBASEQTY, rowSet.getBigDecimal(TB_BASEQTY).subtract(rowSet.getBigDecimal(TB_TOTALRESERVATIONBASEQTY)));
                materialMap.put(rowSet.getString(TB_MATERIAL_NUMBER), null);
                if (this.reservationObjectList.size() <= 0) continue;
                ReservationInfo reservationInfo = null;
                int size = this.reservationObjectList.size();
                for (int i = 0; i < size; ++i) {
                    reservationInfo = this.reservationObjectList.get(i);
                    if (StringUtil.isEmpty((String)reservationInfo.getInventoryID()) || !reservationInfo.getInventoryID().equals(rowSet.getString(TB_INVENTORYID))) continue;
                    rowSet.updateBigDecimal(TB_CURRESERVATIONBASEQTY, reservationInfo.getReservationBaseQty());
                    this.reservationObjectList.remove(i);
                    continue block2;
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        this.fmtReservationBaseQty.setPrecision(precision);
        ((KDFormattedTextField)this.getDetailTable().getColumn(TB_CURRESERVATIONBASEQTY).getEditor().getComponent()).setPrecision(precision);
        if (materialMap.size() > 1) {
            hasMoreThanOne = true;
            materialMap.clear();
            materialMap = null;
            return;
        }
    }

    protected void aftertablefilldata(KDTDataRequestEvent e) {
        super.afterTableFillData(e);
    }

    @Override
    protected void btnQuickQuery_actionPerformed(ActionEvent e) throws Exception {
        if (this.prmtStorageOrgUnit.getText() != null && this.prmtStorageOrgUnit.getText().trim().length() > 0 || this.prmtMaterial.getText() != null && this.prmtMaterial.getText().trim().length() > 0) {
            this.mainQuery = this.getQuickQueryViewInfo();
            this.refreshList();
        } else {
            MsgBox.showConfirm2((String)EASResource.getString((String)"com.kingdee.eas.scm.im.inv.WarehsManageResource", (String)"StorageOrgAndMaterailNotBlank"));
        }
    }

    public EntityViewInfo getQuickQueryViewInfo() throws BOSException {
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo evFilter = new FilterInfo();
        evFilter = this.mergeFilter(evFilter, this.getStoreOrgUnitFilterInfo(), "AND");
        FilterInfo materialFilter = new FilterInfo();
        if (this.prmtMaterial.getValue() != null) {
            materialFilter.getFilterItems().add(new FilterItemInfo("material.id", (Object)((MaterialInfo)this.prmtMaterial.getValue()).getId().toString(), CompareType.EQUALS));
        }
        FilterInfo souFilter = new FilterInfo();
        if (this.prmtStorageOrgUnit.getValue() != null) {
            souFilter.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)((StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue()).getId().toString(), CompareType.EQUALS));
        }
        evFilter = this.mergeFilter(evFilter, materialFilter, "AND");
        evFilter = this.mergeFilter(evFilter, souFilter, "AND");
        FilterInfo authorizedStorageFilter = new FilterInfo();
        authorizedStorageFilter.getFilterItems().add(new FilterItemInfo("storageOrgUnit.number", (Object)this.authorizedStorageSet, CompareType.INCLUDE));
        evFilter = this.mergeFilter(evFilter, authorizedStorageFilter, "AND");
        if (this.matFilter != null) {
            evFilter.mergeFilter(this.matFilter, "AND");
        }
        if (this.wareFilter != null) {
            evFilter.mergeFilter(this.wareFilter, "AND");
        }
        ev.setFilter(evFilter);
        return ev;
    }

    public void editCanceled(KDTEditEvent e) {
    }

    public void editStarted(KDTEditEvent e) {
    }

    public void editStarting(KDTEditEvent e) {
    }

    public void editStopped(KDTEditEvent e) {
        try {
            this.tableValueChanged(e);
        }
        catch (Exception ex) {
            this.handUIException(ex);
        }
    }

    public void editStopping(KDTEditEvent e) {
    }

    public void editValueChanged(KDTEditEvent e) {
    }

    public void tableValueChanged(KDTEditEvent e) throws Exception {
        if (e.getValue() == null) {
            return;
        }
        int selectRow = e.getRowIndex();
        int selectCol = e.getColIndex();
        KDTable table = (KDTable)e.getSource();
        String colName = table.getColumnKey(e.getColIndex());
        IRow row = null;
        row = table.getRow(selectRow);
        if (TB_CURRESERVATIONBASEQTY.equals(colName)) {
            e.getOldValue();
            BigDecimal curReservationBaseQty = NumericUtil.BIGDECIMAL_ZERO;
            BigDecimal unReservationBaseQty = NumericUtil.BIGDECIMAL_ZERO;
            curReservationBaseQty = (BigDecimal)e.getValue();
            unReservationBaseQty = (BigDecimal)row.getCell(TB_TOTALUNRESERVATIONBASEQTY).getValue();
            if (curReservationBaseQty.compareTo(unReservationBaseQty) > 0) {
                MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.scm.im.reservation.RESERVATIONAutoGenerateResource", (String)"35_ObjectReservationListUI"));
                row.getCell(TB_CURRESERVATIONBASEQTY).setValue(null);
            }
            this.fmtReservationBaseQty.setValue((Object)NumericUtil.BIGDECIMAL_ZERO);
            int size = this.getDetailTable().getRowCount();
            for (int i = 0; i < size; ++i) {
                row = this.getDetailTable().getRow(i);
                if (row.getCell(TB_CURRESERVATIONBASEQTY).getValue() == null) continue;
                this.fmtReservationBaseQty.setValue((Object)((BigDecimal)this.fmtReservationBaseQty.getValue()).add((BigDecimal)row.getCell(TB_CURRESERVATIONBASEQTY).getValue()));
            }
        }
    }

    @Override
    public void actionReservationPriority_actionPerformed(ActionEvent e) throws Exception {
        super.actionReservationPriority_actionPerformed(e);
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"className", (Object)this.getMetaDataPK().getFullName());
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(ReservationTypePriorityOptionUI.class.getName(), (Map)uiContext, null, null);
        uiWindow.show();
    }
}

