/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.reservation.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.query.BizEnumValueDTO;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.basedata.scm.common.UseStatusEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.scm.im.reservation.ReservationExCollection;
import com.kingdee.eas.scm.im.reservation.ReservationExFactory;
import com.kingdee.eas.scm.im.reservation.ReservationExInfo;
import com.kingdee.eas.scm.im.reservation.client.AbstractReservationExListUI;
import com.kingdee.eas.scm.im.reservation.util.ReservationUtil;
import com.kingdee.eas.scm.util.collection.CollectionUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public class ReservationExListUI
extends AbstractReservationExListUI {
    private static final Logger logger = CoreUIObject.getLogger(ReservationExListUI.class);
    private static final String COL_STATE = "state";
    private String bdScmRes = "com.kingdee.eas.basedata.scm.common.SCMResource";
    private String bdScmImRes = "com.kingdee.eas.basedata.scm.im.inv.BDScmImInvResource";
    private String currentCUID = SysContext.getSysContext().getCurrentCtrlUnit().getId().toString();

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        super.actionView_actionPerformed(e);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkStateEnableEdit();
        super.actionEdit_actionPerformed(e);
    }

    protected KDTable getDetailTable() {
        return this.tblMain;
    }

    protected void checkStateEnableEdit() throws Exception {
        this.checkSelected();
        IRow row = KDTableUtil.getSelectedRow((KDTable)this.getDetailTable());
        BizEnumValueDTO state = (BizEnumValueDTO)row.getCell(COL_STATE).getValue();
        if (state.getInt() == 1) {
            MsgBox.showInfo((String)ReservationUtil.getResourceString("RESERVATIONSCHEMA_HAS_ACTIVE_CANNOT_EDIT"));
            SysUtil.abort();
        }
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkStateEnableRemove();
        super.actionRemove_actionPerformed(e);
    }

    protected void checkStateEnableRemove() throws Exception {
        this.checkSelected();
        IRow row = KDTableUtil.getSelectedRow((KDTable)this.getDetailTable());
        BizEnumValueDTO state = (BizEnumValueDTO)row.getCell(COL_STATE).getValue();
        if (state.getInt() != 0) {
            MsgBox.showInfo((String)ReservationUtil.getResourceString("RESERVATIONSCHEMA_ISNOT_SAVESTATE_CANNOT_DELETE"));
            SysUtil.abort();
        }
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        super.actionQuery_actionPerformed(e);
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.setstate(UseStatusEnum.INACTIVE, e);
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        this.setstate(UseStatusEnum.ACTIVE, e);
    }

    private void setstate(UseStatusEnum state, ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList pks = this.getSelectedIdValues();
        boolean isNotCUEnable = false;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        HashSet set = new HashSet(pks);
        filter.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
        view.setFilter(filter);
        ReservationExCollection col = ReservationExFactory.getRemoteInstance().getReservationExCollection(view);
        ReservationExInfo reservationEx = null;
        ArrayList<String> numberList = new ArrayList<String>();
        if (!CollectionUtil.isEmpty((AbstractObjectCollection)col)) {
            int size = col.size();
            for (int i = 0; i < size; ++i) {
                reservationEx = col.get(i);
                String cu = reservationEx.getCU() != null ? reservationEx.getCU().getId().toString() : null;
                numberList.add(reservationEx.getNumber());
                if (this.currentCUID.equals(cu)) continue;
                isNotCUEnable = true;
                pks.remove(reservationEx.getId().toString());
            }
        }
        if (isNotCUEnable) {
            String msg = EASResource.getString((String)this.bdScmImRes, (String)"CANTNOT_EDIT_DATA_CU");
            MsgBox.showInfo((Component)((Object)this), (String)msg);
            return;
        }
        List errors = ReservationExFactory.getRemoteInstance().setState(pks, state);
        if (UseStatusEnum.ACTIVE.equals((Object)state)) {
            this.setLog(numberList, "invupdatetype_enable", ReservationUtil.getResourceString("METHOD_ACTIVE"));
        } else {
            this.setLog(numberList, "invupdatetype_disable", ReservationUtil.getResourceString("METHOD_INACTIVE"));
        }
        StringBuffer errMsg = new StringBuffer();
        String msg = null;
        boolean isSuccess = true;
        if (null != errors && errors.size() > 0) {
            Iterator iter = errors.iterator();
            EASBizException ex = null;
            while (iter.hasNext()) {
                ex = (EASBizException)((Object)iter.next());
                if (ex == null) continue;
                errMsg.append(ex.getMessage());
                errMsg.append("\n");
            }
            isSuccess = false;
        }
        if (UseStatusEnum.ACTIVE.equals((Object)state)) {
            msg = isSuccess ? EASResource.getString((String)this.bdScmRes, (String)"EnableSuccess") : EASResource.getString((String)this.bdScmImRes, (String)"Msg_Start_Error");
        } else {
            String string = msg = isSuccess ? EASResource.getString((String)this.bdScmRes, (String)"DisableSuccess") : EASResource.getString((String)this.bdScmImRes, (String)"Msg_Forbid_Error");
        }
        if (errMsg.length() > 0) {
            MsgBox.showDetailAndOK((Component)((Object)this), (String)msg, (String)errMsg.toString(), (int)2);
        }
        this.refresh(e);
        this.setMessageText(msg);
        this.showMessage();
    }

    private void setLog(List<String> numberList, String logItemName, String methodName) throws Exception {
        if (numberList == null || numberList.size() == 0) {
            return;
        }
        for (int i = 0; i < numberList.size(); ++i) {
            IObjectPK pk = LogUtil.beginLog(null, (String)methodName, (BOSObjectType)BOSObjectType.create((String)"0306CFFC"), null, (String)numberList.get(i), (String)logItemName);
            LogUtil.afterLog(null, (IObjectPK)pk);
        }
    }

    protected ICoreBase getBizInterface() throws Exception {
        return ReservationExFactory.getRemoteInstance();
    }

    protected String getEditUIName() {
        return "com.kingdee.eas.scm.im.reservation.client.ReservationExEditUI";
    }

    public void onLoad() throws Exception {
        super.onLoad();
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }
}

