/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.reservation.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.framework.IDynamicObject;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.base.commonquery.client.IProcessor;
import com.kingdee.eas.base.commonquery.client.IPromptBoxFactory;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitCollection;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.SCMBillEntryBaseInfo;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.client.SCMCommonProcessor;
import com.kingdee.eas.scm.common.client.SCMPromptBoxFactory;
import com.kingdee.eas.scm.im.reservation.IReservation;
import com.kingdee.eas.scm.im.reservation.ReservationFactory;
import com.kingdee.eas.scm.im.reservation.client.AbstractReservationListUI;
import com.kingdee.eas.scm.im.reservation.client.ReservationFilterUI;
import com.kingdee.eas.scm.im.reservation.util.ReservationUtil;
import com.kingdee.eas.scm.util.collection.CollectionUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.apache.log4j.Logger;

public class ReservationListUI
extends AbstractReservationListUI {
    private static final long serialVersionUID = -327849750271319092L;
    private static final Logger logger = CoreUIObject.getLogger(ReservationListUI.class);
    Map<String, IObjectValue> objectMap = new HashMap<String, IObjectValue>();
    Map<String, String> bosTypeMap = new HashMap<String, String>();
    Map matBaseUnitMap = new HashMap();
    Map matAssistUnitMap = new HashMap();
    private ReservationFilterUI filterUI = null;
    private CommonQueryDialog commonQuerydialog = null;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e == null || e.getType() == 1) {
            return;
        }
        super.tblMain_tableClicked(e);
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        this.checkCUReservationPermission("reservation_view");
        super.actionView_actionPerformed(e);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkCUReservationPermission("reservation_delete");
        this.checkSelected();
        if (0 != MsgBox.showConfirm2((String)ReservationUtil.getResourceString("SURE_CANCELRESERVATION"))) {
            return;
        }
        long begintime = System.currentTimeMillis();
        ArrayList idList = this.getSelectedIdValues();
        ((IReservation)this.getBizInterface()).cancelReservation(idList);
        this.refreshList();
        long endtime = System.currentTimeMillis();
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        super.actionQuery_actionPerformed(e);
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancel_actionPerformed(e);
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancelCancel_actionPerformed(e);
    }

    protected ICoreBase getBizInterface() throws Exception {
        return ReservationFactory.getRemoteInstance();
    }

    protected String getEditUIName() {
        return null;
    }

    protected void getRowSetBeforeFillTable(IRowSet rowSet) {
        super.getRowSetBeforeFillTable(rowSet);
        try {
            IDynamicObject iDynamicObject = DynamicObjectFactory.getRemoteInstance();
            IObjectValue model = null;
            this.setMatUnitPrecisionMap();
            while (rowSet.next()) {
                String materialId;
                EntityObjectInfo entity;
                if (rowSet.getString("objectID") != null) {
                    String objectID = rowSet.getString("objectID");
                    if (this.objectMap.get(objectID) != null) {
                        model = this.objectMap.get(objectID);
                    } else {
                        ObjectUuidPK objectPK = new ObjectUuidPK(objectID);
                        model = iDynamicObject.getValue(objectPK.getObjectType(), (IObjectPK)objectPK);
                        this.objectMap.put(objectID, model);
                    }
                    rowSet.updateString("objectID", (String)model.get("name"));
                }
                if (rowSet.getString("requireBillBosType") != null) {
                    String requireBillBosTypeID = rowSet.getString("requireBillBosType");
                    String requireBillAlias = "";
                    if (this.bosTypeMap.get(requireBillBosTypeID) != null) {
                        requireBillAlias = this.bosTypeMap.get(requireBillBosTypeID);
                    } else {
                        entity = ReservationUtil.getEntityObjectInfo(requireBillBosTypeID);
                        requireBillAlias = entity.getAlias();
                        this.bosTypeMap.put(requireBillBosTypeID, requireBillAlias);
                    }
                    rowSet.updateString("requireBillBosType", requireBillAlias);
                }
                if (rowSet.getString("supplierBillBosType") != null) {
                    String supplierBillBosTypeID = rowSet.getString("supplierBillBosType");
                    String supplierBillAlias = "";
                    if (this.bosTypeMap.get(supplierBillBosTypeID) != null) {
                        supplierBillAlias = this.bosTypeMap.get(supplierBillBosTypeID);
                    } else {
                        entity = ReservationUtil.getEntityObjectInfo(supplierBillBosTypeID);
                        supplierBillAlias = entity.getAlias();
                        this.bosTypeMap.put(supplierBillBosTypeID, supplierBillAlias);
                    }
                    rowSet.updateString("supplierBillBosType", supplierBillAlias);
                }
                if (rowSet.getString("material.id") != null && rowSet.getString("baseUnit.id") != null) {
                    materialId = rowSet.getString("material.id");
                    String baseUnitId = rowSet.getString("baseUnit.id");
                    if (this.matBaseUnitMap.get(materialId + "|" + baseUnitId) != null) {
                        int qtyPrecision = (Integer)this.matBaseUnitMap.get(materialId + "|" + baseUnitId);
                        BigDecimal reservationBaseQty = rowSet.getBigDecimal("reservationBaseQty");
                        rowSet.updateBigDecimal("reservationBaseQty", reservationBaseQty.setScale(qtyPrecision, 4));
                    }
                }
                if (rowSet.getString("material.id") == null || rowSet.getString("assistUnit.id") == null) continue;
                materialId = rowSet.getString("material.id");
                String assistUnitId = rowSet.getString("assistUnit.id");
                if (this.matAssistUnitMap.get(materialId + "|" + assistUnitId) == null) continue;
                int qtyPrecision = (Integer)this.matAssistUnitMap.get(materialId + "|" + assistUnitId);
                BigDecimal reservationAssistQty = rowSet.getBigDecimal("reservationAssistQty");
                if (reservationAssistQty == null) {
                    reservationAssistQty = BigDecimal.ZERO;
                }
                rowSet.updateBigDecimal("reservationAssistQty", reservationAssistQty.setScale(qtyPrecision, 4));
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    private void setMatUnitPrecisionMap() throws Exception {
        int qtyPrecision;
        String idStr;
        int i;
        SCMBillBaseInfo info;
        ArrayList<IObjectValue> entries = null;
        entries = (ArrayList<IObjectValue>)this.getUIContext().get("ENTRIESINFO");
        if (entries == null) {
            entries = new ArrayList<IObjectValue>();
        }
        if (entries.size() == 0 && (info = (SCMBillBaseInfo)this.getUIContext().get("BILLINFO")) != null && info.getEntries() != null) {
            for (int i2 = 0; i2 < info.getEntries().size(); ++i2) {
                entries.add(info.getEntries().getObject(i2));
            }
        }
        HashSet<String> materialIdSet = new HashSet<String>();
        HashSet<String> baseUnitIdSet = new HashSet<String>();
        HashSet<String> assistUnitIdSet = new HashSet<String>();
        SCMBillEntryBaseInfo entry = null;
        for (int i3 = 0; i3 < entries.size() && (entry = (SCMBillEntryBaseInfo)entries.get(i3)).getMaterial() != null; ++i3) {
            materialIdSet.add(entry.getMaterial().getId().toString());
            if (entry.getBaseUnit() != null) {
                baseUnitIdSet.add(entry.getBaseUnit().getId().toString());
            }
            if (entry.getAssistUnit() == null) continue;
            assistUnitIdSet.add(entry.getAssistUnit().getId().toString());
        }
        MultiMeasureUnitCollection matBaseUnitCol = null;
        MultiMeasureUnitCollection matAssistUnitCol = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("material.id", materialIdSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("measureUnit.id", baseUnitIdSet, CompareType.INCLUDE));
        view.setFilter(filter);
        matBaseUnitCol = MultiMeasureUnitFactory.getRemoteInstance().getMultiMeasureUnitCollection(view);
        filter.getFilterItems().clear();
        filter.getFilterItems().add(new FilterItemInfo("material.id", materialIdSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("measureUnit.id", assistUnitIdSet, CompareType.INCLUDE));
        matAssistUnitCol = MultiMeasureUnitFactory.getRemoteInstance().getMultiMeasureUnitCollection(view);
        for (i = 0; i < matBaseUnitCol.size(); ++i) {
            idStr = matBaseUnitCol.get(i).getMaterial().getId().toString() + "|" + matBaseUnitCol.get(i).getMeasureUnit().getId().toString();
            qtyPrecision = matBaseUnitCol.get(i).getQtyPrecision();
            this.matBaseUnitMap.put(idStr, qtyPrecision);
        }
        for (i = 0; i < matAssistUnitCol.size(); ++i) {
            idStr = matAssistUnitCol.get(i).getMaterial().getId().toString() + "|" + matAssistUnitCol.get(i).getMeasureUnit().getId().toString();
            qtyPrecision = matAssistUnitCol.get(i).getQtyPrecision();
            this.matAssistUnitMap.put(idStr, qtyPrecision);
        }
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        String bill_query_reservation = (String)this.getUIContext().get("BILLQUERYRESERVATION");
        if ("BILLQUERYRESERVATION".equals(bill_query_reservation)) {
            try {
                FilterInfo filter;
                this.btnQuery.setVisible(false);
                IObjectValue model = (IObjectValue)this.getUIContext().get("BILLINFO");
                List entries = null;
                entries = (List)this.getUIContext().get("ENTRIESINFO");
                List<String> list = ReservationUtil.getBillReservationList(null, model, entries);
                if (viewInfo == null) {
                    viewInfo = new EntityViewInfo();
                }
                if ((filter = viewInfo.getFilter()) == null) {
                    filter = new FilterInfo();
                }
                FilterInfo billFilter = new FilterInfo();
                StringBuffer mask = new StringBuffer(50);
                if (!CollectionUtil.isEmpty(list)) {
                    HashSet<String> idSet = new HashSet<String>(list);
                    billFilter.getFilterItems().add(new FilterItemInfo("requireBillEntryID", idSet, CompareType.INCLUDE));
                    billFilter.getFilterItems().add(new FilterItemInfo("supplierBillEntryID", idSet, CompareType.INCLUDE));
                    mask.append("(#0 or #1)");
                    billFilter.setMaskString(mask.toString());
                } else {
                    billFilter.getFilterItems().add(new FilterItemInfo("requireBillID", (Object)"1", CompareType.EQUALS));
                    billFilter.getFilterItems().add(new FilterItemInfo("supplierBillID", (Object)"1", CompareType.EQUALS));
                }
                filter.mergeFilter(billFilter, "AND");
                viewInfo.setFilter(filter);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return super.getQueryExecutor(queryPK, viewInfo);
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        if (this.commonQuerydialog == null) {
            if (this.mainQuery == null) {
                this.mainQuery = new EntityViewInfo();
            }
            this.commonQuerydialog = super.initCommonQueryDialog();
            this.commonQuerydialog.setWidth(450);
            this.commonQuerydialog.setHeight(320);
            try {
                if (this.filterUI == null) {
                    this.filterUI = new ReservationFilterUI();
                }
                SCMPromptBoxFactory scmF7Factory = new SCMPromptBoxFactory((CustomerQueryPanel)this.filterUI, this.getMainBizOrgType());
                this.commonQuerydialog.setPromptBoxFactory((IPromptBoxFactory)scmF7Factory);
                this.commonQuerydialog.setProcessor((IProcessor)new SCMCommonProcessor());
                this.commonQuerydialog.addUserPanel((KDPanel)this.filterUI);
            }
            catch (Exception e) {
                this.handUIException(e);
                SysUtil.abort();
            }
        }
        return this.commonQuerydialog;
    }

    protected boolean initDefaultFilter() {
        String bill_query_reservation = (String)this.getUIContext().get("BILLQUERYRESERVATION");
        return !"BILLQUERYRESERVATION".equals(bill_query_reservation);
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    protected boolean isFootVisible() {
        return true;
    }

    protected boolean isLazyMode() {
        return true;
    }

    protected IRow appendFootRow() {
        return super.appendFootRow();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        Icon imgTbtn_stocklock = EASResource.getIcon((String)"com.kingdee.eas.scm.im.reservation.InvReservationResource.imgTbtn_stocklock");
        this.btnRemove.setIcon(imgTbtn_stocklock);
        SCMClientUtils.setTableColumnsFormat((KDTable)this.tblMain, (String[])new String[]{"reservationBaseQty", "reservationAssistQty"}, (String)SCMClientUtils.getFormatPattern((int)8, (boolean)true));
    }

    public void checkCUReservationPermission(String permissionItem) {
        CtrlUnitInfo cu = SysContext.getSysContext().getCurrentCtrlUnit();
        if (cu != null) {
            ObjectUuidPK userPK = new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId());
            ObjectUuidPK cuPK = new ObjectUuidPK(cu.getId());
            try {
                IPermission ipermission = PermissionFactory.getRemoteInstance();
                ipermission.checkFunctionPermission((IObjectPK)userPK, (IObjectPK)cuPK, permissionItem);
            }
            catch (Exception ex) {
                this.handUIException(ex);
                this.abort();
            }
        }
    }

    protected String[] getQueryHideField() {
        return new String[]{"objectID", "requireBillBosType", "supplierBillBosType", "material.id", "assistUnit.id", "baseUnit.id", "reservationBaseQty", "reservationAssistQty", "storageOrg.id"};
    }
}

