/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.reservation.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.BizEnumValueDTO;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.framework.util.EntityControlTypeUtil;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.scm.common.UseStatusEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.scm.im.reservation.ReservationSchemaCollection;
import com.kingdee.eas.scm.im.reservation.ReservationSchemaFactory;
import com.kingdee.eas.scm.im.reservation.ReservationSchemaInfo;
import com.kingdee.eas.scm.im.reservation.client.AbstractReservationSchemaListUI;
import com.kingdee.eas.scm.im.reservation.util.ReservationUtil;
import com.kingdee.eas.scm.util.collection.CollectionUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class ReservationSchemaListUI
extends AbstractReservationSchemaListUI {
    private static final long serialVersionUID = 1L;
    private static final String COL_STATE = "schemaState";
    private static final String COL_CUID = "cu.id";
    private static final String COL_SCHEDULED = "scheduled";
    private String bdScmRes = "com.kingdee.eas.basedata.scm.common.SCMResource";
    private String bdScmImRes = "com.kingdee.eas.basedata.scm.im.inv.BDScmImInvResource";
    private String currentCUID;

    public ReservationSchemaListUI() throws Exception {
        this.splitPanel.setDividerSize(0);
        this.splitPanel.setDividerLocation(1000);
        this.currentCUID = SysContext.getSysContext().getCurrentCtrlUnit().getId().toString();
        this.btnViewReport.setIcon(EASResource.getIcon((String)"imgTbtn_preview2"));
        this.tblMain.addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                if (!e.getSelectBlock().equals((Object)e.getPrevSelectBlock())) {
                    ReservationSchemaListUI.this.splitPanel.setDividerSize(0);
                    ReservationSchemaListUI.this.splitPanel.setDividerLocation(1000);
                }
            }
        });
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        this.checkCUReservationPermission("reservationSchema_view");
        super.actionView_actionPerformed(e);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkCUReservationPermission("reservationSchema_update");
        this.checkScheduledEnableEdit();
        this.checkCUEnable();
        this.checkStateEnableEdit();
        super.actionEdit_actionPerformed(e);
    }

    protected void checkScheduledEnableEdit() {
        this.checkSelected();
        IRow row = KDTableUtil.getSelectedRow((KDTable)this.getDetailTable());
        if (((Boolean)row.getCell(COL_SCHEDULED).getValue()).booleanValue()) {
            MsgBox.showWarning((String)ReservationUtil.getResourceString("SCHEDULED_SCHEMA_CANNOT_EDIT"));
            SysUtil.abort();
        }
    }

    protected void checkCUEnable() throws Exception {
        this.checkSelected();
        IRow row = KDTableUtil.getSelectedRow((KDTable)this.getDetailTable());
        String cuid = row.getCell(COL_CUID).getValue().toString();
        if (cuid != null) {
            EntityControlTypeUtil.checkCanEdit((String)"S3", (String)this.currentCUID, (String)cuid);
        }
    }

    protected void checkStateEnableEdit() throws Exception {
        this.checkSelected();
        IRow row = KDTableUtil.getSelectedRow((KDTable)this.getDetailTable());
        BizEnumValueDTO state = (BizEnumValueDTO)row.getCell(COL_STATE).getValue();
        if (state.getInt() == 1) {
            MsgBox.showInfo((String)ReservationUtil.getResourceString("RESERVATIONSCHEMA_HAS_ACTIVE_CANNOT_EDIT"));
            SysUtil.abort();
        }
    }

    protected void checkStateEnableRemove() throws Exception {
        this.checkSelected();
        IRow row = KDTableUtil.getSelectedRow((KDTable)this.getDetailTable());
        BizEnumValueDTO state = (BizEnumValueDTO)row.getCell(COL_STATE).getValue();
        if (state.getInt() != 0) {
            MsgBox.showInfo((String)ReservationUtil.getResourceString("RESERVATIONSCHEMA_ISNOT_SAVESTATE_CANNOT_DELETE"));
            SysUtil.abort();
        }
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkCUReservationPermission("reservationSchema_delete");
        this.checkScheduledEnableRemove();
        this.checkCUEnable();
        this.checkStateEnableRemove();
        super.actionRemove_actionPerformed(e);
    }

    protected void checkScheduledEnableRemove() {
        this.checkSelected();
        IRow row = KDTableUtil.getSelectedRow((KDTable)this.getDetailTable());
        if (((Boolean)row.getCell(COL_SCHEDULED).getValue()).booleanValue()) {
            MsgBox.showWarning((String)ReservationUtil.getResourceString("SCHEDULED_SCHEMA_CANNOT_DELETE"));
            SysUtil.abort();
        }
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.checkCUReservationPermission("reservationSchema_disable");
        this.setstate(UseStatusEnum.INACTIVE, e);
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        this.checkCUReservationPermission("reservationSchema_enable");
        this.setstate(UseStatusEnum.ACTIVE, e);
    }

    private void setstate(UseStatusEnum state, ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList pks = this.getSelectedIdValues();
        boolean isNotCUEnable = false;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        HashSet set = new HashSet(pks);
        filter.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
        view.setFilter(filter);
        ReservationSchemaCollection col = ReservationSchemaFactory.getRemoteInstance().getReservationSchemaCollection(view);
        ReservationSchemaInfo reserSchema = null;
        ArrayList<String> numberList = new ArrayList<String>();
        if (!CollectionUtil.isEmpty((AbstractObjectCollection)col)) {
            int size = col.size();
            for (int i = 0; i < size; ++i) {
                reserSchema = col.get(i);
                String cu = reserSchema.getCU() != null ? reserSchema.getCU().getId().toString() : null;
                numberList.add(reserSchema.getNumber());
                if (this.currentCUID.equals(cu)) continue;
                isNotCUEnable = true;
                pks.remove(reserSchema.getId().toString());
            }
        }
        if (isNotCUEnable) {
            String msg = EASResource.getString((String)this.bdScmImRes, (String)"CANTNOT_EDIT_DATA_CU");
            MsgBox.showInfo((Component)((Object)this), (String)msg);
            return;
        }
        List errors = ReservationSchemaFactory.getRemoteInstance().setState(pks, state);
        if (UseStatusEnum.ACTIVE.equals((Object)state)) {
            this.setLog(numberList, "invupdatetype_enable", ReservationUtil.getResourceString("METHOD_ACTIVE"));
        } else {
            this.setLog(numberList, "invupdatetype_disable", ReservationUtil.getResourceString("METHOD_INACTIVE"));
        }
        StringBuffer errMsg = new StringBuffer();
        String msg = null;
        boolean isSuccess = true;
        if (null != errors && errors.size() > 0) {
            Iterator iter = errors.iterator();
            EASBizException ex = null;
            while (iter.hasNext()) {
                ex = (EASBizException)((Object)iter.next());
                if (ex == null) continue;
                errMsg.append(ex.getMessage());
                errMsg.append("\n");
            }
            isSuccess = false;
        }
        if (UseStatusEnum.ACTIVE.equals((Object)state)) {
            msg = isSuccess ? EASResource.getString((String)this.bdScmRes, (String)"EnableSuccess") : EASResource.getString((String)this.bdScmImRes, (String)"Msg_Start_Error");
        } else {
            String string = msg = isSuccess ? EASResource.getString((String)this.bdScmRes, (String)"DisableSuccess") : EASResource.getString((String)this.bdScmImRes, (String)"Msg_Forbid_Error");
        }
        if (errMsg.length() > 0) {
            MsgBox.showDetailAndOK((Component)((Object)this), (String)msg, (String)errMsg.toString(), (int)2);
        }
        this.refresh(e);
        this.setMessageText(msg);
        this.showMessage();
    }

    @Override
    public void actionViewReport_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        ReservationSchemaInfo schema = ReservationSchemaFactory.getRemoteInstance().getReservationSchemaInfo((IObjectPK)new ObjectUuidPK(id));
        this.txtReportor.setText(schema.toReport());
        this.txtReportor.setEditable(false);
        this.splitPanel.setDividerSize(5);
        this.splitPanel.setDividerLocation(450);
    }

    private void setLog(List<String> numberList, String logItemName, String methodName) throws Exception {
        if (numberList == null || numberList.size() == 0) {
            return;
        }
        for (int i = 0; i < numberList.size(); ++i) {
            IObjectPK pk = LogUtil.beginLog(null, (String)methodName, (BOSObjectType)BOSObjectType.create((String)"99D32C6A"), null, (String)numberList.get(i), (String)logItemName);
            LogUtil.afterLog(null, (IObjectPK)pk);
        }
    }

    protected ICoreBase getBizInterface() throws Exception {
        return ReservationSchemaFactory.getRemoteInstance();
    }

    protected String getEditUIName() {
        return "com.kingdee.eas.scm.im.reservation.client.ReservationSchemaEditUI";
    }

    protected KDTable getDetailTable() {
        return this.tblMain;
    }

    protected boolean isIgnoreCUFilter() {
        return false;
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        CtrlUnitInfo cu = SysContext.getSysContext().getCurrentCtrlUnit();
        FilterInfo cuFilter = new FilterInfo();
        if (cu != null) {
            cuFilter.getFilterItems().add(new FilterItemInfo(COL_CUID, (Object)cu.getId().toString(), CompareType.EQUALS));
            if (viewInfo != null) {
                FilterInfo filter = viewInfo.getFilter();
                try {
                    filter.mergeFilter(cuFilter, "AND");
                    viewInfo.setFilter(filter);
                }
                catch (BOSException e) {
                    e.printStackTrace();
                }
            }
        }
        return super.getQueryExecutor(queryPK, viewInfo);
    }

    public void checkCUReservationPermission(String permissionItem) {
        CtrlUnitInfo cu = SysContext.getSysContext().getCurrentCtrlUnit();
        if (cu != null) {
            ObjectUuidPK userPK = new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId());
            ObjectUuidPK cuPK = new ObjectUuidPK(cu.getId());
            try {
                IPermission ipermission = PermissionFactory.getRemoteInstance();
                ipermission.checkFunctionPermission((IObjectPK)userPK, (IObjectPK)cuPK, permissionItem);
            }
            catch (Exception ex) {
                this.handUIException(ex);
                this.abort();
            }
        }
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.setNumberColumn("schemaNumber");
    }
}

