/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.reservation.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.common.BizActionEnum;
import com.kingdee.eas.scm.im.reservation.IReservation;
import com.kingdee.eas.scm.im.reservation.InvReservationException;
import com.kingdee.eas.scm.im.reservation.ReservationCollection;
import com.kingdee.eas.scm.im.reservation.ReservationFactory;
import com.kingdee.eas.scm.im.reservation.ReservationInfo;
import com.kingdee.eas.scm.im.reservation.impl.IReservationBillActionCheck;
import com.kingdee.eas.scm.im.reservation.util.ReservationUtil;
import com.kingdee.eas.scm.util.collection.CollectionUtil;
import com.kingdee.eas.scm.util.filehandle.ResourceUtil;
import com.kingdee.eas.scm.util.string.StringUtil;
import com.kingdee.eas.util.client.EASResource;
import java.util.ArrayList;
import java.util.List;

public class ReservationBillActionCheckImpl
implements IReservationBillActionCheck {
    private BizActionEnum bizAction = null;

    public ReservationBillActionCheckImpl() {
        this(null);
    }

    public ReservationBillActionCheckImpl(BizActionEnum bizAction) {
        this.bizAction = bizAction;
    }

    @Override
    public void setBizAction(BizActionEnum bizAction) {
        this.bizAction = bizAction;
    }

    @Override
    public List<EASBizException> reservationBillActionCheck(Context ctx, IObjectCollection billCollection) throws BOSException, EASBizException {
        ArrayList<EASBizException> batchList = new ArrayList<EASBizException>();
        if (CollectionUtil.isEmpty((IObjectCollection)billCollection)) {
            return batchList;
        }
        List<Object> list = new ArrayList();
        IObjectValue model = null;
        int size = billCollection.size();
        for (int i = 0; i < size; ++i) {
            model = billCollection.getObject(i);
            list = this.reservationBillActionCheck(ctx, model);
            batchList.addAll(list);
        }
        return batchList;
    }

    @Override
    public List<EASBizException> reservationBillActionCheck(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ArrayList<EASBizException> list = new ArrayList<EASBizException>();
        if (null == model || null == model.getBOSType() || model.get("id") == null) {
            return list;
        }
        String billId = model.get("id").toString();
        IReservation iReservation = null;
        iReservation = ctx == null ? ReservationFactory.getRemoteInstance() : ReservationFactory.getLocalInstance(ctx);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("requireBillID", (Object)billId, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("isAutoReservation", (Object)1, CompareType.NOTEQUALS));
        filter.getFilterItems().add(new FilterItemInfo("reservationBaseQty", (Object)0, CompareType.GREATER));
        view.setFilter(filter);
        ReservationCollection col = iReservation.getReservationCollection(view);
        if (!CollectionUtil.isEmpty((AbstractObjectCollection)col)) {
            InvReservationException ex = new InvReservationException(InvReservationException.REQUIREBILL_HAS_HANDLERESERVATION, new Object[]{(String)model.get("number"), this.getOperation()});
            list.add(ex);
            return list;
        }
        view = new EntityViewInfo();
        filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("supplierBillID", (Object)billId, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("isAutoReservation", (Object)1, CompareType.NOTEQUALS));
        filter.getFilterItems().add(new FilterItemInfo("reservationBaseQty", (Object)0, CompareType.GREATER));
        view.setFilter(filter);
        col = iReservation.getReservationCollection(view);
        if (!CollectionUtil.isEmpty((AbstractObjectCollection)col)) {
            ReservationInfo info = null;
            StringBuffer sb = new StringBuffer(128);
            int size = col.size();
            for (int i = 0; i < size; ++i) {
                info = col.get(i);
                if (StringUtil.isEmpty((String)info.getRequireBillNum())) continue;
                sb.append("," + info.getRequireBillNum());
            }
            if (sb.length() > 0) {
                sb.delete(0, 1);
            }
            InvReservationException ex = new InvReservationException(InvReservationException.SUPPLYBILL_HAS_BEEN_RESERVATIONED, new Object[]{(String)model.get("number"), sb.toString(), this.getOperation()});
            list.add(ex);
            return list;
        }
        view = new EntityViewInfo();
        filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("requireBillID", (Object)billId, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("supplierBillID", (Object)billId, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("isAutoReservation", (Object)1, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("reservationBaseQty", (Object)0, CompareType.GREATER));
        filter.setMaskString("(#0 or #1) AND #2 AND #3");
        view.setFilter(filter);
        col = iReservation.getReservationCollection(view);
        if (CollectionUtil.isEmpty((AbstractObjectCollection)col)) {
            return list;
        }
        ArrayList<String> idList = new ArrayList<String>();
        ReservationInfo reservationInfo = null;
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            reservationInfo = col.get(i);
            idList.add(reservationInfo.getId().toString());
        }
        ReservationUtil.requestMutex(ctx, idList);
        iReservation.cancelReservation(idList);
        ReservationUtil.releaseMutex(ctx, idList);
        return list;
    }

    protected String getOperation() {
        String option = "";
        option = this.bizAction != null ? ResourceUtil.getMessage((String)"com.kingdee.eas.scm.im.reservation.RESERVATIONAutoGenerateResource", (String)"41_ReservationBillActionCheckImpl", (String[])new String[]{this.bizAction.getAlias()}) : EASResource.getString((String)"com.kingdee.eas.scm.im.reservation.RESERVATIONAutoGenerateResource", (String)"42_ReservationBillActionCheckImpl");
        return option;
    }
}

