/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.reservation.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.DataTableInfo;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.mm.common.app.SQLUtils;
import com.kingdee.eas.scm.framework.balance.BalanceModelInfo;
import com.kingdee.eas.scm.framework.balance.OperationTypeEnum;
import com.kingdee.eas.scm.framework.balance.app.engine.InsertNewRecordHelper;
import com.kingdee.eas.scm.framework.balance.app.log.IBalanceLogger;
import com.kingdee.eas.scm.framework.balance.app.plugin.BalancePlugInAdapter;
import com.kingdee.eas.scm.framework.balance.app.plugin.HandlerParameter;
import com.kingdee.eas.scm.im.inv.IInventory;
import com.kingdee.eas.scm.im.inv.InventoryFactory;
import com.kingdee.eas.scm.im.inv.InventoryInfo;
import com.kingdee.eas.scm.im.reservation.IReservation;
import com.kingdee.eas.scm.im.reservation.InvReservationException;
import com.kingdee.eas.scm.im.reservation.ReservationCollection;
import com.kingdee.eas.scm.im.reservation.ReservationFactory;
import com.kingdee.eas.scm.im.reservation.ReservationInfo;
import com.kingdee.eas.scm.im.reservation.model.InvUpdateModel;
import com.kingdee.eas.scm.im.reservation.model.ReservationModel;
import com.kingdee.eas.scm.im.reservation.util.ReservationUtil;
import com.kingdee.eas.scm.util.app.db.KsqlUtil;
import com.kingdee.eas.scm.util.collection.CollectionUtil;
import com.kingdee.eas.scm.util.numeric.NumericUtil;
import com.kingdee.eas.scm.util.string.StringUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

public class InvRealTimeBalanceReservationPlugInHandler
extends BalancePlugInAdapter {
    private IBalanceLogger logger;
    private List<InvUpdateModel> billEntryCollection = null;
    private String entryTableName = "";
    private String field_roid = "";
    private String field_rid = "";

    public void handleAfterFinalDataBeforeLock(Context ctx, String finalTempTable, HandlerParameter params) throws BOSException, EASBizException {
        this.logger = params.getLogger();
        this.updateBalanceIdToDetailTable(ctx, params.getBalanceModelInfo(), params.getDetailTempTable(), finalTempTable);
        this.handleReservation(ctx, params.getDetailTempTable(), params);
    }

    private void initReservationData(Context ctx, String detailTempTable, HandlerParameter updateParam) throws BOSException, EASBizException {
        LinkPropertyInfo property = ReservationUtil.getBillEntryProperty(ctx, updateParam.getBillBosType());
        DataTableInfo tableInfo = property.getRelationship().getSupplierObject().getTable();
        if (tableInfo == null) {
            return;
        }
        this.entryTableName = tableInfo.getName();
        this.field_roid = "FRESERVATIONBILLOBJECTID";
        this.field_rid = "FRESERVATIONID";
        String sql = "SELECT temp.FID as FID, temp.FBILLENTRYID as FBILLENTRYID, temp.FUNITID as FUNITID,temp.FASSISTUNITID as FASSISTUNITID,temp.FBASEUNITID as FBASEUNITID,isnull(temp.FCURSTOREQTY, 0) as FCURSTOREQTY,isnull(temp.FCURSTOREASSISTQTY, 0) as FCURSTOREASSISTQTY,isnull(temp.FBASEQTY, 0) as FBASEQTY,entry.fid, entry." + this.field_roid + " as FRESERVATIONBILLOBJECTID, entry." + this.field_rid + " as FRESERVATIONID FROM " + detailTempTable + " as temp inner join " + this.entryTableName + " as entry on temp.FBILLENTRYID=entry.fid where entry." + this.field_rid + " IS NOT NULL or entry." + this.field_roid + " IS NOT NULL";
        this.billEntryCollection = InvRealTimeBalanceReservationPlugInHandler.getInvUpdateInfoList(ctx, sql);
    }

    private void updateBalanceIdToDetailTable(Context ctx, BalanceModelInfo balanceModelInfo, String detailTempTable, String finalTempTable) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("update ").append(detailTempTable).append(" as tmp set (FID) = ").append("\r\n");
        sql.append("(select bal.FID from ").append(finalTempTable).append(" bal ").append("\r\n");
        sql.append("where ").append(InsertNewRecordHelper.getMatchCondition((BalanceModelInfo)balanceModelInfo, (String)"tmp", (String)"bal")).append(")");
        this.logger.debugSQL("\u66f4\u65b0\u65b0ID\u5230\u4e34\u65f6\u8868\u4e2dSQL: ", sql.toString());
        KsqlUtil.execute((Context)ctx, (String)sql.toString());
    }

    public void handleReservation(Context ctx, String detailTempTable, HandlerParameter updateParam) throws BOSException, EASBizException {
        if (ctx == null || updateParam == null || StringUtil.isEmpty((String)detailTempTable)) {
            return;
        }
        if ("FC910EF3".equals(updateParam.getBillBosType())) {
            return;
        }
        boolean isAudit = updateParam.getOPType() == OperationTypeEnum.Positive;
        this.initReservationData(ctx, detailTempTable, updateParam);
        if (CollectionUtil.isEmpty(this.billEntryCollection)) {
            return;
        }
        InvUpdateModel invUpdateModel = null;
        String billEntryID = "";
        String inventoryID = "";
        BigDecimal baseQty = NumericUtil.BIGDECIMAL_ZERO;
        BigDecimal assistQty = NumericUtil.BIGDECIMAL_ZERO;
        if (isAudit) {
            int size = this.billEntryCollection.size();
            for (int i = 0; i < size; ++i) {
                invUpdateModel = this.billEntryCollection.get(i);
                billEntryID = invUpdateModel.getBillEntryID();
                if (StringUtil.isEmpty((String)billEntryID)) {
                    throw new InvReservationException(InvReservationException.TEMPTABLE_ENTRYID_ISNULL);
                }
                inventoryID = invUpdateModel.getInventoryID();
                baseQty = invUpdateModel.getBaseQty();
                assistQty = invUpdateModel.getAssistQty();
                String reservationBillObjectID = invUpdateModel.getReservationBillObjectId();
                String reservationID = invUpdateModel.getReservationId();
                if (StringUtil.isEmpty((String)reservationBillObjectID) || StringUtil.isEmpty((String)inventoryID)) continue;
                if (invUpdateModel.isAddExistingQty()) {
                    this.reservationTransfer(ctx, inventoryID, reservationID, reservationBillObjectID, billEntryID, baseQty, assistQty);
                    continue;
                }
                this.reservationRelease(ctx, inventoryID, reservationID, reservationBillObjectID, billEntryID, baseQty, assistQty);
            }
        } else {
            Object[][] obj = new Object[this.billEntryCollection.size()][1];
            int size = this.billEntryCollection.size();
            for (int i = 0; i < size; ++i) {
                invUpdateModel = this.billEntryCollection.get(i);
                String reservationID = invUpdateModel.getReservationId();
                if (StringUtil.isEmpty((String)reservationID)) continue;
                obj[i][0] = invUpdateModel.getBillEntryID();
                if (!invUpdateModel.isAddExistingQty()) continue;
                String[] arr = reservationID.split(",");
                ArrayList<String> idList = new ArrayList<String>();
                int len = arr.length;
                for (int n = 0; n < len; ++n) {
                    idList.add(arr[n]);
                }
                String ids = CollectionUtil.convertList2String(idList);
                String updateSql = "UPDATE T_IM_RESERVATION SET FINVENTORYID=NULL WHERE FID IN (" + ids + ")";
                DbUtil.execute((Context)ctx, (String)updateSql);
            }
            String updateSql = "update " + this.entryTableName + " set " + this.field_rid + "=null where fid=?";
            KsqlUtil.executeBatch((Context)ctx, (String)updateSql, (Object[][])obj);
        }
    }

    private void reservationTransfer(Context ctx, String inventoryID, String reservationID, String reservationBillObjectID, String entryID, BigDecimal inBaseQty, BigDecimal inAssistQty) throws BOSException, EASBizException {
        this.logger.info("*******************\u9884\u7559\u8f6c\u79fb\u64cd\u4f5c\u5f00\u59cb*******************");
        if (StringUtil.isEmpty((String)inventoryID) || StringUtil.isEmpty((String)entryID) || !NumericUtil.isGreaterthanZero((BigDecimal)inBaseQty)) {
            return;
        }
        try {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("reservationType", (Object)1, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("inventoryID", null, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("supplierBillEntryID", (Object)reservationBillObjectID, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("supplierBillID", (Object)reservationBillObjectID, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("supplierBillEntryID", null, CompareType.EQUALS));
            String mask = "#0 AND #1 AND (#2 OR (#3 AND #4))";
            if (!StringUtil.isEmpty((String)reservationID)) {
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)reservationID, CompareType.EQUALS));
                mask = mask + " AND #5";
            }
            filter.setMaskString(mask);
            view.setFilter(filter);
            SorterItemCollection sortItemCol = new SorterItemCollection();
            SorterItemInfo sortItem = new SorterItemInfo("reservationBeginDate");
            sortItem.setSortType(SortType.ASCEND);
            sortItemCol.add(sortItem);
            view.setSorter(sortItemCol);
            IReservation iReservation = ReservationFactory.getLocalInstance(ctx);
            ReservationCollection col = iReservation.getReservationCollection(view);
            if (CollectionUtil.isEmpty((AbstractObjectCollection)col)) {
                return;
            }
            ReservationUtil.lockReservationRecords(ctx, (IObjectCollection)col);
            ReservationInfo reservationInfo = null;
            BigDecimal reservationBaseQty = NumericUtil.BIGDECIMAL_ZERO;
            BigDecimal reservationAssistQty = NumericUtil.BIGDECIMAL_ZERO;
            StringBuffer reservationIdBuffer = new StringBuffer();
            int size = col.size();
            if (size > 15) {
                size = 15;
            }
            for (int i = 0; i < size; ++i) {
                IObjectPK pk;
                reservationInfo = col.get(i);
                reservationID = reservationInfo.getId().toString();
                reservationBaseQty = reservationInfo.getReservationBaseQty();
                reservationAssistQty = reservationInfo.getReservationAssistQty();
                ReservationInfo newReservationInfo = (ReservationInfo)reservationInfo.clone();
                newReservationInfo.setInventoryID(inventoryID);
                newReservationInfo.setId(null);
                Calendar calendar = Calendar.getInstance(ctx.getLocale());
                calendar.set(11, 0);
                calendar.set(12, 0);
                calendar.set(13, 0);
                calendar.set(14, 0);
                newReservationInfo.setReservationBeginDate(new Timestamp(calendar.getTimeInMillis()));
                if (inBaseQty.compareTo(reservationBaseQty) <= 0) {
                    newReservationInfo.setReservationBaseQty(inBaseQty);
                    pk = iReservation.save((CoreBaseInfo)newReservationInfo);
                    reservationIdBuffer.append("," + pk.toString());
                    this.logger.info("1.\u9884\u7559\u8bb0\u5f55\u3010" + reservationID + "\u3011\u8f6c\u79fb\u4e3a\u5373\u65f6\u5e93\u5b58\u9884\u7559\uff1a" + inBaseQty);
                    if (inBaseQty.compareTo(reservationBaseQty) == 0) {
                        iReservation.delete((IObjectPK)new ObjectUuidPK(reservationInfo.getId().toString()));
                        this.logger.info("2.\u9884\u7559\u8bb0\u5f55\u3010" + reservationID + "\u3011\u9884\u7559\u6570\u91cf\u4e3a0\uff0c\u5220\u9664\u9884\u7559\u8bb0\u5f55");
                    } else {
                        reservationInfo.setReservationBaseQty(reservationBaseQty.subtract(inBaseQty));
                        if (reservationAssistQty.compareTo(NumericUtil.BIGDECIMAL_ZERO) > 0) {
                            reservationInfo.setReservationAssistQty(reservationAssistQty.subtract(inAssistQty));
                        }
                        iReservation.save((CoreBaseInfo)reservationInfo);
                        this.logger.info("3.\u9884\u7559\u8bb0\u5f55\u3010" + reservationID + "\u3011\u51cf\u5c11\u9884\u7559\u6570\u91cf\uff1a" + inBaseQty);
                    }
                    inBaseQty = NumericUtil.BIGDECIMAL_ZERO;
                    break;
                }
                newReservationInfo.setReservationBaseQty(reservationBaseQty);
                pk = iReservation.save((CoreBaseInfo)newReservationInfo);
                reservationIdBuffer.append("," + pk.toString());
                this.logger.info("4.\u9884\u7559\u8bb0\u5f55\u3010" + reservationID + "\u3011\u8f6c\u79fb\u4e3a\u5373\u65f6\u5e93\u5b58\u9884\u7559\uff1a" + reservationBaseQty);
                reservationInfo.setReservationBaseQty(NumericUtil.BIGDECIMAL_ZERO);
                iReservation.save((CoreBaseInfo)reservationInfo);
                iReservation.delete((IObjectPK)new ObjectUuidPK(reservationInfo.getId().toString()));
                this.logger.info("5.\u9884\u7559\u8bb0\u5f55\u3010" + reservationID + "\u3011\u9884\u7559\u6570\u91cf\u4e3a0\uff0c\u5220\u9664\u9884\u7559\u8bb0\u5f55");
                inBaseQty = inBaseQty.subtract(reservationBaseQty);
            }
            if (reservationIdBuffer.length() > 1) {
                String updateSql = "update " + this.entryTableName + " set " + this.field_rid + "=? where fid=?";
                DbUtil.execute((Context)ctx, (String)updateSql, (Object[])new Object[]{reservationIdBuffer.toString(), entryID});
            }
            this.logger.info("*******************\u9884\u7559\u8f6c\u79fb\u64cd\u4f5c\u7ed3\u675f*******************");
        }
        catch (Exception e) {
            this.logger.error("\u9884\u7559\u8f6c\u79fb\u5f02\u5e38\uff1a" + e.getMessage());
            throw new InvReservationException(InvReservationException.RESERVATIONTRANSFER_EXCEPTION);
        }
    }

    private void reservationRelease(Context ctx, String inventoryID, String reservationID, String reservationBillObjectID, String entryID, BigDecimal issueBaseQty, BigDecimal issueAssistQty) throws BOSException, EASBizException {
        this.logger.info("*******************\u89e3\u9664\u9884\u7559\u64cd\u4f5c\u5f00\u59cb*******************");
        String reservationInventoryID = "";
        if (StringUtil.isEmpty((String)inventoryID) || StringUtil.isEmpty((String)reservationBillObjectID) || StringUtil.isEmpty((String)entryID) || issueBaseQty == null) {
            return;
        }
        if (issueBaseQty.signum() == -1) {
            issueBaseQty = issueBaseQty.abs();
        }
        if (issueAssistQty.signum() == -1) {
            issueAssistQty = issueAssistQty.abs();
        }
        try {
            IReservation iReservation = ReservationFactory.getLocalInstance(ctx);
            if (StringUtil.isEmpty((String)reservationID)) {
                if (reservationBillObjectID.equals(entryID)) {
                    FilterInfo filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("requireBillEntryID", (Object)reservationBillObjectID, CompareType.EQUALS));
                    iReservation.delete(filter);
                    return;
                }
                return;
            }
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("reservationType", (Object)1, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("inventoryID", null, CompareType.NOTEQUALS));
            if (!StringUtil.isEmpty((String)reservationID)) {
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)reservationID, CompareType.EQUALS));
            }
            filter.getFilterItems().add(new FilterItemInfo("requireBillEntryID", (Object)reservationBillObjectID, CompareType.EQUALS));
            view.setFilter(filter);
            ReservationCollection col = iReservation.getReservationCollection(view);
            if (CollectionUtil.isEmpty((AbstractObjectCollection)col)) {
                return;
            }
            ReservationUtil.lockReservationRecords(ctx, (IObjectCollection)col);
            ReservationInfo reservationInfo = null;
            BigDecimal reservationBaseQty = NumericUtil.BIGDECIMAL_ZERO;
            BigDecimal reservationAssistQty = NumericUtil.BIGDECIMAL_ZERO;
            int size = col.size();
            for (int i = 0; i < size; ++i) {
                reservationInfo = col.get(i);
                reservationBaseQty = reservationInfo.getReservationBaseQty();
                reservationAssistQty = reservationInfo.getReservationAssistQty() == null ? NumericUtil.BIGDECIMAL_ZERO : reservationInfo.getReservationAssistQty();
                this.logger.info("1.\u9884\u7559\u8bb0\u5f55\u3010" + reservationInfo.getId().toString() + "\u3011\u7684\u9884\u7559\u6570\u91cf\u4e3a\u3010" + reservationInfo.getReservationBaseQty() + "\u3011");
                reservationInventoryID = reservationInfo.getInventoryID();
                this.logger.info("2.\u51fa\u5e93\u5339\u914d\u7684\u5373\u65f6\u5e93\u5b58\u3010" + inventoryID + "\u3011,\u9884\u7559\u8bb0\u5f55\u3010" + reservationInfo.getId().toString() + "\u3011\u9884\u7559\u7684\u5373\u65f6\u5e93\u5b58\u3010" + reservationInventoryID + "\u3011");
                if (!inventoryID.equals(reservationInventoryID)) {
                    reservationInfo.setInventoryID(inventoryID);
                    this.logger.info("3.\u9884\u7559\u8bb0\u5f55\u3010" + reservationInfo.getId().toString() + "\u3011\u9884\u7559\u7684\u5373\u65f6\u5e93\u5b58ID\u4e0e\u51fa\u5e93\u5339\u914d\u7684\u5373\u65f6\u5e93\u5b58ID\u4e0d\u4e00\u81f4,\u5c06\u9884\u7559\u8bb0\u5f55\u4e2d\u7684\u5373\u65f6\u5e93\u5b58ID\u66ff\u6362\u6210\u5e93\u5b58\u66f4\u65b0\u5339\u914d\u5230\u7684\u5373\u65f6\u5e93\u5b58ID");
                    IInventory iInv = InventoryFactory.getLocalInstance(ctx);
                    InventoryInfo invInfo = iInv.getInventoryInfo((IObjectPK)new ObjectUuidPK(inventoryID));
                    BigDecimal invBaseQty = invInfo.getBaseQty();
                    BigDecimal invAssistQty = invInfo.getCurStoreAssistQty() == null ? NumericUtil.BIGDECIMAL_ZERO : invInfo.getCurStoreAssistQty();
                    ReservationModel reservationModel = ReservationUtil.getInventoryReservationData(ctx, inventoryID);
                    BigDecimal invTotalReservationBaseQty = NumericUtil.BIGDECIMAL_ZERO;
                    invTotalReservationBaseQty = reservationModel.getTotalReservationBaseQty();
                    BigDecimal invTotalReservationAssistQty = NumericUtil.BIGDECIMAL_ZERO;
                    invTotalReservationAssistQty = reservationModel.getTotalReservationAssistQty();
                    this.logger.info("4.\u51fa\u5e93\u5339\u914d\u7684\u5373\u65f6\u5e93\u5b58\u3010" + inventoryID + "\u3011,\u73b0\u5b58\u91cf\u4e3a\u3010" + invBaseQty + "\u3011,\u7d2f\u8ba1\u5df2\u9884\u7559\u6570\u91cf\u4e3a\u3010" + invTotalReservationBaseQty + "\u3011;\u9884\u7559\u8bb0\u5f55\u9884\u7559\u6570\u91cf\u4e3a\u3010" + reservationBaseQty + "\u3011");
                    if (reservationBaseQty.compareTo(invBaseQty.subtract(invTotalReservationBaseQty)) > 0) {
                        reservationInfo.setReservationBaseQty(invBaseQty.subtract(invTotalReservationBaseQty));
                        if (reservationAssistQty.compareTo(NumericUtil.BIGDECIMAL_ZERO) > 0) {
                            reservationInfo.setReservationAssistQty(invAssistQty.subtract(invTotalReservationAssistQty));
                        }
                        this.logger.info("5.\u5373\u65f6\u5e93\u5b58\u73b0\u5b58\u91cf-\u5df2\u9884\u7559\u603b\u6570\u91cf<\u9884\u7559\u8bb0\u5f55\u7684\u5df2\u9884\u7559\u6570\u91cf,\u5219\u4fee\u6539\u9884\u7559\u8bb0\u5f55\u7684\u9884\u7559\u6570\u91cf\u4e3a\u5373\u65f6\u5e93\u5b58\u73b0\u5b58\u91cf-\u5df2\u9884\u7559\u603b\u6570\u91cf\uff1a\u3010" + invBaseQty.subtract(invTotalReservationBaseQty) + "\u3011");
                    }
                    iReservation.update((IObjectPK)new ObjectUuidPK(reservationInfo.getId().toString()), reservationInfo);
                }
                this.logger.info("6.\u9884\u7559\u8bb0\u5f55\u3010" + reservationInfo.getId().toString() + "\u3011\u7684\u9884\u7559\u6570\u91cf\u4e3a\u3010" + reservationInfo.getReservationBaseQty() + "\u3011");
                this.logger.info("7.\u5355\u636e\u51fa\u5e93\u6570\u91cf\u4e3a\u3010" + issueBaseQty + "\u3011");
                if (issueBaseQty.compareTo(reservationInfo.getReservationBaseQty()) <= 0) {
                    reservationBaseQty = reservationInfo.getReservationBaseQty();
                    BigDecimal newReservationBaseQty = reservationBaseQty.subtract(issueBaseQty);
                    if (newReservationBaseQty.compareTo(NumericUtil.BIGDECIMAL_ZERO) == 0) {
                        iReservation.delete((IObjectPK)new ObjectUuidPK(reservationInfo.getId().toString()));
                        this.logger.info("8.\u9884\u7559\u8bb0\u5f55\u3010" + reservationInfo.getId().toString() + "\u3011\u9884\u7559\u6570\u91cf=\u51fa\u5e93\u6570\u91cf,\u89e3\u9664\u5168\u90e8\u9884\u7559");
                        continue;
                    }
                    reservationInfo.setReservationBaseQty(newReservationBaseQty);
                    BigDecimal bigDecimal = reservationAssistQty = reservationInfo.getReservationAssistQty() == null ? NumericUtil.BIGDECIMAL_ZERO : reservationInfo.getReservationAssistQty();
                    if (reservationAssistQty.compareTo(NumericUtil.BIGDECIMAL_ZERO) > 0) {
                        BigDecimal newReservationAssistQty = reservationAssistQty.subtract(issueAssistQty);
                        reservationInfo.setReservationAssistQty(newReservationAssistQty);
                    }
                    iReservation.update((IObjectPK)new ObjectUuidPK(reservationInfo.getId().toString()), reservationInfo);
                    this.logger.info("9.\u9884\u7559\u8bb0\u5f55\u3010" + reservationInfo.getId().toString() + "\u3011\u9884\u7559\u6570\u91cf>\u51fa\u5e93\u6570\u91cf,\u89e3\u9664\u90e8\u5206\u9884\u7559\u3010" + issueBaseQty + "\u3011,\u5269\u4f59\u9884\u7559\u6570\u91cf\u3010" + newReservationBaseQty + "\u3011");
                    continue;
                }
                iReservation.delete((IObjectPK)new ObjectUuidPK(reservationInfo.getId().toString()));
                this.logger.info("10.\u9884\u7559\u8bb0\u5f55\u3010" + reservationInfo.getId().toString() + "\u3011\u9884\u7559\u6570\u91cf<\u51fa\u5e93\u6570\u91cf,\u89e3\u9664\u5168\u90e8\u9884\u7559");
            }
            this.logger.info("*******************\u89e3\u9664\u9884\u7559\u64cd\u4f5c\u7ed3\u675f*******************");
        }
        catch (Exception e) {
            this.logger.error("\u89e3\u9664\u9884\u7559\u5f02\u5e38\uff1a" + e.getMessage());
            throw new InvReservationException(InvReservationException.RESERVATIONRELEASE_EXCEPTION);
        }
    }

    private static List<InvUpdateModel> getInvUpdateInfoList(Context ctx, String sql) throws BOSException {
        ArrayList<InvUpdateModel> list = new ArrayList<InvUpdateModel>();
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            InvUpdateModel invUpdateInfo = null;
            while (rs.next()) {
                invUpdateInfo = new InvUpdateModel();
                invUpdateInfo.setBillEntryID(rs.getString("FBILLENTRYID"));
                invUpdateInfo.setBaseUnitID(rs.getString("FBASEUNITID"));
                invUpdateInfo.setBaseQty(rs.getBigDecimal("FBASEQTY"));
                invUpdateInfo.setUnitId(rs.getString("FUNITID"));
                invUpdateInfo.setQty(rs.getBigDecimal("FCURSTOREQTY"));
                invUpdateInfo.setAssistUnitID(rs.getString("FASSISTUNITID"));
                invUpdateInfo.setAssistQty(rs.getBigDecimal("FCURSTOREASSISTQTY"));
                invUpdateInfo.setInventoryID(rs.getString("FID"));
                invUpdateInfo.setAddExistingQty(rs.getBigDecimal("FBASEQTY").signum() == 1);
                invUpdateInfo.setReservationId(rs.getString("FRESERVATIONID"));
                invUpdateInfo.setReservationBillObjectId(rs.getString("FRESERVATIONBILLOBJECTID"));
                list.add(invUpdateInfo);
            }
        }
        catch (Exception e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
        return list;
    }
}

