/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.rpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.headfootdesigner.HeadFootModel;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.foot.KDTFootManager;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.master.material.IMaterial;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.LocateDialogUI;
import com.kingdee.eas.framework.client.RealModeIDList;
import com.kingdee.eas.framework.config.ITablePreferenceHelper;
import com.kingdee.eas.framework.report.ICommRptBase;
import com.kingdee.eas.framework.report.client.CommRptBaseConditionUI;
import com.kingdee.eas.framework.report.util.DefaultKDTableInsertHandler;
import com.kingdee.eas.framework.report.util.KDTableUtil;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.framework.report.util.RptTableHeader;
import com.kingdee.eas.scm.cal.CostAdjustBillFactory;
import com.kingdee.eas.scm.cal.client.CostAdjustBillEditUI;
import com.kingdee.eas.scm.cal.util.CalculateUtil;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.util.ReportQueryConditionHelper;
import com.kingdee.eas.scm.im.inv.DecomposeBillFactory;
import com.kingdee.eas.scm.im.inv.InvStateAdjustBillFactory;
import com.kingdee.eas.scm.im.inv.ManufactureRecBillFactory;
import com.kingdee.eas.scm.im.inv.MaterialReqBillFactory;
import com.kingdee.eas.scm.im.inv.MoveInWarehsBillFactory;
import com.kingdee.eas.scm.im.inv.MoveIssueBillFactory;
import com.kingdee.eas.scm.im.inv.MoveLocationBillFactory;
import com.kingdee.eas.scm.im.inv.OtherInWarehsBillFactory;
import com.kingdee.eas.scm.im.inv.OtherIssueBillFactory;
import com.kingdee.eas.scm.im.inv.PurInWarehsBillFactory;
import com.kingdee.eas.scm.im.inv.SaleIssueBillFactory;
import com.kingdee.eas.scm.im.inv.client.DecomposeBillEditUI;
import com.kingdee.eas.scm.im.inv.client.InvStateAdjustBillEditUI;
import com.kingdee.eas.scm.im.inv.client.ManufactureRecBillEditUI;
import com.kingdee.eas.scm.im.inv.client.MaterialReqBillEditUI;
import com.kingdee.eas.scm.im.inv.client.MoveInWarehsBillEditUI;
import com.kingdee.eas.scm.im.inv.client.MoveIssueBillEditUI;
import com.kingdee.eas.scm.im.inv.client.MoveLocationBillEditUI;
import com.kingdee.eas.scm.im.inv.client.OtherInWarehsBillEditUI;
import com.kingdee.eas.scm.im.inv.client.OtherIssueBillEditUI;
import com.kingdee.eas.scm.im.inv.client.PurInWarehsBillEditUI;
import com.kingdee.eas.scm.im.inv.client.SaleIssueBillEditUI;
import com.kingdee.eas.scm.im.rpt.IMRptUtils;
import com.kingdee.eas.scm.im.rpt.InOutStoreDetailReporFacadeFactory;
import com.kingdee.eas.scm.im.rpt.client.AbstractInOutStoreDetailReportUI;
import com.kingdee.eas.scm.im.rpt.client.InOutStoreDetailReportConditionUI;
import com.kingdee.eas.scm.util.SCMRptUtil;
import com.kingdee.eas.scm.util.datetime.DateTimeUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class InOutStoreDetailReportUI
extends AbstractInOutStoreDetailReportUI {
    private static final long serialVersionUID = -6023289518996919231L;
    private static final Logger logger = CoreUIObject.getLogger(InOutStoreDetailReportUI.class);
    private Object[] pkCollection;
    private ArrayList allIdList;
    private int currentPKIndex = -1;
    private String permItem_print = "inoutstoredetailreport_print";
    private static String AUTO_GENERATE_RESOURCE = "com.kingdee.eas.scm.im.IMAutoGenerateResource";
    private boolean firstLoadData = true;

    public InOutStoreDetailReportUI() throws Exception {
        this.initToolbar();
        this.tbl.setEditable(false);
        this.tbl.getActionMap().remove("Delete");
        this.tbl.checkParsed();
        this.tbl.getDataRequestManager().addDataRequestListener((KDTDataRequestListener)this);
        this.tbl.getDataRequestManager().setDataRequestMode(1);
        this.enableExportExcel(this.tbl);
        this.tbl.getDataRequestManager().setExportMemoryCallback(false);
    }

    public void onLoad() throws Exception {
        if (this.getUIContext().get("rptParams") != null) {
            this.params = (RptParams)this.getUIContext().get("rptParams");
            this.currentPKIndex = -1;
            this.init();
        }
        super.onLoad();
        this.btnFirst.setVisible(false);
        this.btnPre.setVisible(false);
        this.btnNext.setVisible(false);
        this.btnLast.setVisible(false);
        this.menuItemFirst.setVisible(false);
        this.menuItemPre.setVisible(false);
        this.menuItemNext.setVisible(false);
        this.menuItemLast.setVisible(false);
        if (this.tHelper != null) {
            this.tHelper.setCanMoveColumn(true);
        }
    }

    private void initToolbar() {
        this.btnFirst.setIcon(EASResource.getIcon((String)"imgTbtn_first"));
        this.btnPre.setIcon(EASResource.getIcon((String)"imgTbtn_previous"));
        this.btnNext.setIcon(EASResource.getIcon((String)"imgTbtn_next"));
        this.btnLast.setIcon(EASResource.getIcon((String)"imgTbtn_last"));
        this.btnViewUI.setIcon(EASResource.getIcon((String)"imgTbtn_bill"));
        this.btnQuery.setIcon(EASResource.getIcon((String)"imgTbtn_filter"));
        this.btnRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.menuItemFirst.setIcon(EASResource.getIcon((String)"imgTbtn_first"));
        this.menuItemPre.setIcon(EASResource.getIcon((String)"imgTbtn_previous"));
        this.menuItemNext.setIcon(EASResource.getIcon((String)"imgTbtn_next"));
        this.menuItemLast.setIcon(EASResource.getIcon((String)"imgTbtn_last"));
        this.menuViewDetail.setIcon(EASResource.getIcon((String)"imgTbtn_bill"));
    }

    protected ICommRptBase getRemoteInstance() throws BOSException {
        return InOutStoreDetailReporFacadeFactory.getRemoteInstance();
    }

    protected KDTable getTableForPrintSetting() {
        return this.tbl;
    }

    protected RptParams getParamsForInit() {
        return null;
    }

    protected CommRptBaseConditionUI getQueryDialogUserPanel() throws Exception {
        InOutStoreDetailReportConditionUI condUI = new InOutStoreDetailReportConditionUI();
        condUI.setSize(508, 470);
        return condUI;
    }

    protected void query() {
        this.tbl.removeColumns();
        this.tbl.removeRows();
    }

    protected String getUIFullName() {
        return "com.kingdee.eas.scm.im.rpt.client.InOutStoreDetailReportUI";
    }

    public boolean isAsynchronism() {
        return true;
    }

    public void getData(KDTDataRequestEvent e) {
        try {
            this.tbl.getDataRequestManager().removeDataRequestListener((KDTDataRequestListener)this);
            int start = e.getFirstRow();
            int length = e.getLastRow() - start + 1;
            this.setAmtAuthorizedOrgs();
            RptParams para = (RptParams)this.params.clone();
            para.setString("tempTable", this.getTempTable());
            RptRowSet rs = null;
            if (start == 0 && this.firstLoadData) {
                this.firstLoadData = false;
                RptParams rptCt = InOutStoreDetailReporFacadeFactory.getRemoteInstance().createTempTable(para);
                this.setTempTable(rptCt.getString("tempTable"));
                RptTableHeader header = (RptTableHeader)rptCt.getObject("header");
                header.getColumn("bizDate").setFormatPattern(DateTimeUtil.strDateFormat);
                KDTableUtil.setHeader((RptTableHeader)header, (KDTable)this.tbl);
                int freezeCol = this.tbl.getColumnIndex("billStatus");
                this.tbl.getViewManager().setFreezeView(-1, freezeCol + 1);
                if (this.tHelper != null) {
                    this.tHelper.setDefaultUserData(null);
                }
                this.initUserConfig();
                Map queryHeader = (Map)rptCt.getObject("queryHeader");
                SCMRptUtil.setQueryHeader((KDTable)this.tbl, (ITablePreferenceHelper)this.tHelper, (Map)queryHeader);
                para.setString("tempTable", this.getTempTable());
                RptParams rpt = InOutStoreDetailReporFacadeFactory.getRemoteInstance().query(para, start, length);
                rs = (RptRowSet)rpt.getObject("rowset");
                int totalCount = rptCt.getInt("totalCount");
                this.tbl.setRowCount(totalCount);
                if (rs != null) {
                    SCMRptUtil.insertRows((RptRowSet)rs, (int)start, (CoreUI)this, (KDTable)this.tbl, (ITablePreferenceHelper)this.tHelper);
                }
                this.appendFootRow(rptCt);
            } else {
                RptParams rpt = InOutStoreDetailReporFacadeFactory.getRemoteInstance().query(para, start, length);
                rs = (RptRowSet)rpt.getObject("rowset");
                if (rs != null) {
                    SCMRptUtil.insertRows((RptRowSet)rs, (int)start, (CoreUI)this, (KDTable)this.tbl, (ITablePreferenceHelper)this.tHelper);
                }
            }
            this.afterDataFill(e, para);
            this.setBackGroundColorKDTable(start, rs.getRowCount());
            this.tbl.getDataRequestManager().addDataRequestListener((KDTDataRequestListener)this);
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }

    private void setBackGroundColorKDTable(int from, int len) {
        for (int i = from; i < from + len; ++i) {
            Color necessaryColor;
            IRow tRow;
            if (this.tbl.getRow(i) == null || this.tbl.getRow(i).getCell("storageOrgUnit") == null) continue;
            String storageorgunit = (String)this.tbl.getRow(i).getCell("storageOrgUnit").getValue();
            if (storageorgunit != null && storageorgunit.indexOf(this.getResource("preiod_start")) > -1) {
                tRow = this.tbl.getRow(i);
                necessaryColor = new Color(252, 251, 204);
                tRow.getStyleAttributes().setBackground(necessaryColor);
                continue;
            }
            if (storageorgunit == null || storageorgunit.indexOf(this.getResource("preiod_end")) <= -1) continue;
            tRow = this.tbl.getRow(i);
            necessaryColor = new Color(252, 251, 204);
            tRow.getStyleAttributes().setBackground(necessaryColor);
        }
    }

    public void tbl_afterDataFill(KDTDataRequestEvent e) {
        int from = e.getFirstRow();
        int last = e.getLastRow();
        for (int i = from; i <= last; ++i) {
            Object scaleObj = this.tbl.getRow(i).getCell("qtyPrecision").getValue();
            if (scaleObj == null) continue;
            int scale = Integer.parseInt(scaleObj.toString());
            this.tbl.getRow(i).getCell("riInQty").getStyleAttributes().setNumberFormat(CalculateUtil.getFormatPattern((int)scale));
            this.tbl.getRow(i).getCell("riOutQty").getStyleAttributes().setNumberFormat(CalculateUtil.getFormatPattern((int)scale));
        }
    }

    protected void getAllDataOfId() {
        if (this.params.getObject("idList") != null) {
            IRowSet result = (IRowSet)this.params.getObject("idList");
            this.allIdList = new ArrayList();
            try {
                while (result.next()) {
                    this.allIdList.add(result.getString("FId"));
                }
                this.tbl.setRowCount(this.allIdList.size());
            }
            catch (SQLException e) {
                this.handUIExceptionAndAbort(e);
            }
        }
    }

    public void setQtyScan(int from, int last) {
        for (int i = from; i < last; ++i) {
            Object scaleObj;
            if (this.tbl.getRow(i) == null || (scaleObj = this.tbl.getRow(i).getCell("qtyPrecision").getValue()) == null) continue;
            int scale = Integer.parseInt(scaleObj.toString());
            this.tbl.getRow(i).getCell("riInQty").getStyleAttributes().setNumberFormat(SCMClientUtils.getFormatPattern((int)scale, (boolean)true));
            this.tbl.getRow(i).getCell("riOutQty").getStyleAttributes().setNumberFormat(SCMClientUtils.getFormatPattern((int)scale, (boolean)true));
        }
    }

    private void afterDataFill(KDTDataRequestEvent e, RptParams params) throws EASBizException, BOSException {
        Boolean ckShowBeginEnd = (Boolean)params.getObject("ckShowBeginEnd");
        if (!ckShowBeginEnd.booleanValue()) {
            return;
        }
        boolean checkedMaterial = params.getBoolean("checkedMaterial");
        boolean checkedWarehouse = params.getBoolean("checkedWarehouse");
        String fieldName = null;
        int index_ix = 0;
        int beqty_ix = 0;
        int beprice_ix = 0;
        int beamt_ix = 0;
        int inqty_ix = 0;
        int inprice_ix = 0;
        int inamt_ix = 0;
        int outqty_ix = 0;
        int outprice_ix = 0;
        int outamt_ix = 0;
        int inassqty_ix = 0;
        int outassqty_ix = 0;
        int beassqty_ix = 0;
        int columnCount = this.tbl.getColumnCount();
        for (int c = 0; c < columnCount; ++c) {
            fieldName = this.tbl.getColumnKey(c).toLowerCase();
            if (fieldName.equals("storageorgunit")) {
                index_ix = c;
            }
            if (fieldName.equals("endbaseqty")) {
                beqty_ix = c;
            }
            if (fieldName.equals("endassqty")) {
                beassqty_ix = c;
            }
            if (fieldName.equals("endprice")) {
                beprice_ix = c;
            }
            if (fieldName.equals("endamt")) {
                beamt_ix = c;
            }
            if (fieldName.equals("riinbaseqty")) {
                inqty_ix = c;
            }
            if (fieldName.equals("riinassiqty")) {
                inassqty_ix = c;
            }
            if (fieldName.equals("riinprice")) {
                inprice_ix = c;
            }
            if (fieldName.equals("riinamt")) {
                inamt_ix = c;
            }
            if (fieldName.equals("rioutbaseqty")) {
                outqty_ix = c;
            }
            if (fieldName.equals("rioutassiqty")) {
                outassqty_ix = c;
            }
            if (fieldName.equals("rioutprice")) {
                outprice_ix = c;
            }
            if (!fieldName.equals("rioutamt")) continue;
            outamt_ix = c;
        }
        String beginOrgUnit = this.getResource("120_InOutStoreDetailReporFacadeControllerBean");
        if (beginOrgUnit == null) {
            beginOrgUnit = this.getResource("121_InOutStoreDetailReporFacadeControllerBean");
        }
        if (beginOrgUnit == null) {
            beginOrgUnit = this.getResource("122_InOutStoreDetailReporFacadeControllerBean");
        }
        int from = e.getFirstRow();
        int last = e.getLastRow();
        IRow row = null;
        IRow uprow = null;
        String scale = null;
        String up = null;
        BigDecimal zero = new BigDecimal("0.00");
        BigDecimal one = new BigDecimal("1.00");
        BigDecimal beginQty = zero;
        BigDecimal beginassQty = zero;
        BigDecimal beginPrice = zero;
        BigDecimal beginAmt = zero;
        BigDecimal upQty = zero;
        BigDecimal upassQty = zero;
        BigDecimal upPrice = zero;
        BigDecimal upAmt = zero;
        BigDecimal inQty = zero;
        BigDecimal inassQty = zero;
        BigDecimal inPrice = zero;
        BigDecimal inAmt = zero;
        BigDecimal outQty = zero;
        BigDecimal outassQty = zero;
        BigDecimal outPrice = zero;
        BigDecimal outAmt = zero;
        BigDecimal endQty = zero;
        BigDecimal endassQty = zero;
        BigDecimal endPrice = zero;
        BigDecimal endAmt = zero;
        BigDecimal baseStatConvert = zero;
        BigDecimal endStatUnitQty = zero;
        int statUnitPrecision = 1;
        for (int i = from; i <= last; ++i) {
            row = this.tbl.getRow(i);
            if (row == null) {
                return;
            }
            if (row.getCell(index_ix) == null || row.getCell(beqty_ix) == null || row.getCell(beassqty_ix) == null || row.getCell(beprice_ix) == null || row.getCell(beamt_ix) == null || row.getCell(inqty_ix) == null || row.getCell(inassqty_ix) == null || row.getCell(inprice_ix) == null || row.getCell(inamt_ix) == null || row.getCell(outqty_ix) == null || row.getCell(outassqty_ix) == null || row.getCell(outprice_ix) == null || row.getCell(outamt_ix) == null) {
                return;
            }
            Object scaleObj = row.getCell(index_ix).getValue();
            if (scaleObj == null) continue;
            scale = scaleObj.toString();
            if (scale.indexOf(this.getResource("preiod_start")) > -1) {
                beginQty = row.getCell(beqty_ix).getValue() == null ? zero : new BigDecimal(row.getCell(beqty_ix).getValue().toString());
                beginassQty = row.getCell(beassqty_ix).getValue() == null ? zero : new BigDecimal(row.getCell(beassqty_ix).getValue().toString());
                beginPrice = row.getCell(beprice_ix).getValue() == null ? zero : new BigDecimal(row.getCell(beprice_ix).getValue().toString());
                BigDecimal bigDecimal = beginAmt = row.getCell(beamt_ix).getValue() == null ? zero : new BigDecimal(row.getCell(beamt_ix).getValue().toString());
            }
            if (scale.indexOf(this.getResource("preiod_start")) >= 0 || scale.indexOf(this.getResource("preiod_end")) >= 0) continue;
            uprow = this.tbl.getRow(i - 1);
            if (uprow != null) {
                Object upObj = uprow.getCell(index_ix).getValue();
                if (upObj != null) {
                    up = upObj.toString();
                    if (beginOrgUnit.equals(up)) {
                        upQty = beginQty;
                        upassQty = beginassQty;
                        upPrice = beginPrice;
                        upAmt = beginAmt;
                    } else {
                        upQty = uprow.getCell(beqty_ix).getValue() == null ? zero : (BigDecimal)uprow.getCell(beqty_ix).getValue();
                        upassQty = uprow.getCell(beassqty_ix).getValue() == null ? zero : (BigDecimal)uprow.getCell(beassqty_ix).getValue();
                        upPrice = uprow.getCell(beprice_ix).getValue() == null ? zero : (BigDecimal)uprow.getCell(beprice_ix).getValue();
                        upAmt = uprow.getCell(beamt_ix).getValue() == null ? zero : (BigDecimal)uprow.getCell(beamt_ix).getValue();
                    }
                }
            } else {
                if (checkedMaterial) {
                    params.setString("materialNumber", (String)row.getCell("materialNumber").getValue());
                }
                if (checkedWarehouse) {
                    params.setString("warehouse", (String)row.getCell("warehouse").getValue());
                }
                RptRowSet rs = InOutStoreDetailReporFacadeFactory.getRemoteInstance().getSumInOutData(i, params);
                BigDecimal sumInOutQty = zero;
                BigDecimal sumInOutAmt = zero;
                BigDecimal sumInOutAssiQty = zero;
                if (rs.next()) {
                    sumInOutQty = rs.getBigDecimal("inOutBaseQty");
                    sumInOutAssiQty = rs.getBigDecimal("inOutAssiQty");
                    sumInOutAmt = rs.getBigDecimal("inOutAmt");
                }
                if (!checkedMaterial && !checkedWarehouse) {
                    IRow firstRow = this.tbl.getRow(0);
                    beginQty = firstRow.getCell(beqty_ix).getValue() == null ? zero : new BigDecimal(firstRow.getCell(beqty_ix).getValue().toString());
                    beginassQty = firstRow.getCell(beassqty_ix).getValue() == null ? zero : new BigDecimal(firstRow.getCell(beassqty_ix).getValue().toString());
                    beginAmt = firstRow.getCell(beamt_ix).getValue() == null ? zero : new BigDecimal(firstRow.getCell(beamt_ix).getValue().toString());
                }
                upQty = beginQty.add(sumInOutQty);
                upassQty = beginassQty.add(sumInOutAssiQty);
                upAmt = beginAmt.add(sumInOutAmt);
            }
            inQty = row.getCell(inqty_ix).getValue() == null ? zero : (BigDecimal)row.getCell(inqty_ix).getValue();
            inassQty = row.getCell(inassqty_ix).getValue() == null ? zero : (BigDecimal)row.getCell(inassqty_ix).getValue();
            inPrice = row.getCell(inprice_ix).getValue() == null ? zero : (BigDecimal)row.getCell(inprice_ix).getValue();
            inAmt = row.getCell(inamt_ix).getValue() == null ? zero : (BigDecimal)row.getCell(inamt_ix).getValue();
            outQty = row.getCell(outqty_ix).getValue() == null ? zero : (BigDecimal)row.getCell(outqty_ix).getValue();
            outassQty = row.getCell(outassqty_ix).getValue() == null ? zero : (BigDecimal)row.getCell(outassqty_ix).getValue();
            outPrice = row.getCell(outprice_ix).getValue() == null ? zero : (BigDecimal)row.getCell(outprice_ix).getValue();
            outAmt = row.getCell(outamt_ix).getValue() == null ? zero : (BigDecimal)row.getCell(outamt_ix).getValue();
            endQty = upQty.add(inQty).subtract(outQty);
            endAmt = upAmt.add(inAmt).subtract(outAmt);
            endassQty = upassQty.add(inassQty).subtract(outassQty);
            endPrice = endQty.compareTo(BigDecimal.ZERO) != 0 ? endAmt.divide(endQty, params.getInt("spinPricePrecission"), 4) : BigDecimal.ZERO;
            baseStatConvert = row.getCell("BaseStatConverRate").getValue() == null ? one : (BigDecimal)row.getCell("BaseStatConverRate").getValue();
            statUnitPrecision = row.getCell("StatUnitPrecision").getValue() == null ? 1 : ((BigDecimal)row.getCell("StatUnitPrecision").getValue()).intValue();
            endStatUnitQty = endQty.divide(baseStatConvert, statUnitPrecision, 4);
            row.getCell(beqty_ix).setValue((Object)endQty);
            row.getCell(beassqty_ix).setValue((Object)endassQty);
            row.getCell(beprice_ix).setValue((Object)endPrice);
            row.getCell(beamt_ix).setValue((Object)endAmt);
            row.getCell("EndStatUnitQty").setValue((Object)endStatUnitQty);
        }
    }

    private String getResource(String key) {
        return EASResource.getString((String)AUTO_GENERATE_RESOURCE, (String)key);
    }

    private void getMaterialPKList(RptParams params) throws EASBizException, BOSException {
        this.pkCollection = InOutStoreDetailReporFacadeFactory.getRemoteInstance().getMaterialPKArray(params);
    }

    private void getMaterialID() {
        String matID = null;
        Object pk = null;
        try {
            if (this.currentPKIndex != -2) {
                if (this.currentPKIndex == -1) {
                    this.changeMaterialID(6);
                }
                matID = (pk = this.getCurrentPKInCollection()) != null ? pk.toString() : null;
                this.params.setString("CurrentMaterialID", matID);
            }
        }
        catch (EASBizException e) {
            logger.error((Object)e);
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
    }

    private Object getCurrentPKInCollection() {
        if (this.pkCollection == null) {
            this.currentPKIndex = -1;
            return null;
        }
        if (this.pkCollection.length <= 0) {
            this.currentPKIndex = -1;
            return null;
        }
        if (this.pkCollection.length >= 1 && this.currentPKIndex >= this.pkCollection.length) {
            this.currentPKIndex = this.pkCollection.length - 1;
        } else if (this.currentPKIndex <= 0) {
            this.currentPKIndex = 0;
        }
        return this.pkCollection[this.currentPKIndex];
    }

    private void changeMaterialID(int changeAction) throws BOSException, EASBizException {
        switch (changeAction) {
            case 6: {
                this.currentPKIndex = 0;
                break;
            }
            case 7: {
                --this.currentPKIndex;
                break;
            }
            case 8: {
                ++this.currentPKIndex;
                break;
            }
            case 9: {
                if (this.pkCollection == null) {
                    return;
                }
                if (this.pkCollection.length == 0) {
                    return;
                }
                this.currentPKIndex = this.pkCollection.length - 1;
            }
        }
    }

    private String getEditUIModal() {
        return "com.kingdee.eas.base.uiframe.client.UINewFrameFactory";
    }

    private String getEditUIName() {
        String billType = new String(this.getCellValue("billType"));
        if (billType.equals("103")) {
            return PurInWarehsBillEditUI.class.getName();
        }
        if (billType.equals("105")) {
            return ManufactureRecBillEditUI.class.getName();
        }
        if (billType.equals("107")) {
            return MoveInWarehsBillEditUI.class.getName();
        }
        if (billType.equals("109")) {
            return OtherInWarehsBillEditUI.class.getName();
        }
        if (billType.equals("102")) {
            return SaleIssueBillEditUI.class.getName();
        }
        if (billType.equals("104")) {
            return MaterialReqBillEditUI.class.getName();
        }
        if (billType.equals("106")) {
            return MoveIssueBillEditUI.class.getName();
        }
        if (billType.equals("108")) {
            return OtherIssueBillEditUI.class.getName();
        }
        if (billType.equals("410")) {
            return CostAdjustBillEditUI.class.getName();
        }
        if (billType.equals("120")) {
            return MoveLocationBillEditUI.class.getName();
        }
        if (billType.equals("110")) {
            return InvStateAdjustBillEditUI.class.getName();
        }
        if (billType.equals("130")) {
            return DecomposeBillEditUI.class.getName();
        }
        return null;
    }

    protected String getEditUIPermission() {
        String billType = new String(this.getCellValue("billType"));
        if (billType.equals("103")) {
            return "purinwarehs_view";
        }
        if (billType.equals("105")) {
            return "manufacturerec_view";
        }
        if (billType.equals("107")) {
            return "moveinwarehs_view";
        }
        if (billType.equals("109")) {
            return "otherinwarehs_view";
        }
        if (billType.equals("102")) {
            return "saleissue_view";
        }
        if (billType.equals("104")) {
            return "materialreq_view";
        }
        if (billType.equals("106")) {
            return "moveissue_view";
        }
        if (billType.equals("108")) {
            return "otherissue_view";
        }
        if (billType.equals("410")) {
            return "costadjust_view";
        }
        if (billType.equals("120")) {
            return "movelocation_view";
        }
        if (billType.equals("110")) {
            return "invstateadjust_view";
        }
        return null;
    }

    private boolean checkObjectExists() throws BOSException, EASBizException, Exception {
        if (this.getSelectedKeyValue() == null) {
            return false;
        }
        if (!this.getBizInterface().exists((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)this.getSelectedKeyValue())))) {
            throw new EASBizException(EASBizException.CHECKEXIST);
        }
        return true;
    }

    private ICoreBase getBizInterface() throws Exception {
        String billType = new String(this.getCellValue("billType"));
        if (billType.equals("103")) {
            return PurInWarehsBillFactory.getRemoteInstance();
        }
        if (billType.equals("105")) {
            return ManufactureRecBillFactory.getRemoteInstance();
        }
        if (billType.equals("107")) {
            return MoveInWarehsBillFactory.getRemoteInstance();
        }
        if (billType.equals("109")) {
            return OtherInWarehsBillFactory.getRemoteInstance();
        }
        if (billType.equals("102")) {
            return SaleIssueBillFactory.getRemoteInstance();
        }
        if (billType.equals("104")) {
            return MaterialReqBillFactory.getRemoteInstance();
        }
        if (billType.equals("106")) {
            return MoveIssueBillFactory.getRemoteInstance();
        }
        if (billType.equals("108")) {
            return OtherIssueBillFactory.getRemoteInstance();
        }
        if (billType.equals("410")) {
            return CostAdjustBillFactory.getRemoteInstance();
        }
        if (billType.equals("120")) {
            return MoveLocationBillFactory.getRemoteInstance();
        }
        if (billType.equals("110")) {
            return InvStateAdjustBillFactory.getRemoteInstance();
        }
        if (billType.equals("130")) {
            return DecomposeBillFactory.getRemoteInstance();
        }
        return null;
    }

    protected String getCellValue(String cellField) {
        KDTSelectBlock selectBlock = this.tbl.getSelectManager().get();
        if (selectBlock != null) {
            Object keyValue;
            int rowIndex = selectBlock.getTop();
            IRow row = this.tbl.getRow(rowIndex);
            if (row == null) {
                return null;
            }
            ICell cell = row.getCell(cellField);
            if (cell == null) {
                MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_KeyField_Fail"));
                SysUtil.abort();
            }
            if ((keyValue = cell.getValue()) != null) {
                return keyValue.toString();
            }
        }
        return null;
    }

    protected String getSelectedKeyValue() {
        KDTSelectBlock selectBlock = this.tbl.getSelectManager().get();
        if (selectBlock != null) {
            Object keyValue;
            int rowIndex = selectBlock.getTop();
            IRow row = this.tbl.getRow(rowIndex);
            if (row == null) {
                return null;
            }
            ICell cell = row.getCell(this.getKeyFieldName());
            if (cell == null) {
                MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_KeyField_Fail"));
                SysUtil.abort();
            }
            if (!((keyValue = cell.getValue()) == null || keyValue.equals("0") || keyValue.equals(" ") || keyValue.equals(""))) {
                return keyValue.toString();
            }
            return null;
        }
        return null;
    }

    private String getKeyFieldName() {
        return "FBillID";
    }

    @Override
    protected void tbl_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getClickCount() == 2) {
            ActionEvent evt = new ActionEvent(this.btnViewUI, 0, "Double Clicked");
            ItemAction actView = this.getActionFromActionEvent(evt);
            actView.actionPerformed(evt);
        }
    }

    public void setAmtAuthorizedOrgs() throws EASBizException, BOSException {
        Object[] orgIDs = null;
        StorageOrgUnitInfo storageOrg = (StorageOrgUnitInfo)this.params.getObject("storageOrgUnit");
        Object[] storageOrgUnits = (Object[])this.params.getObject("storageOrgUnits");
        if (storageOrg == null && storageOrgUnits == null) {
            return;
        }
        if (storageOrg != null) {
            orgIDs = new Object[]{storageOrg.getId().toString()};
        } else if (storageOrgUnits != null) {
            orgIDs = storageOrgUnits;
        }
        Object[] noAmtAuthOrg = IMRptUtils.filterNoAuthorizedOrgs(orgIDs, OrgType.Storage, "inoutstoredetailreport_view_amount");
        this.params.setObject("noAmtAuthOrg", (Object)noAmtAuthOrg);
    }

    @Override
    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        if (!this.checkObjectExists()) {
            return;
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)this.getSelectedKeyValue());
        String storageOrgUnitId = this.getCellValue("FStorageOrgUnitId");
        String editUIPermission = this.getEditUIPermission();
        if (storageOrgUnitId != null && editUIPermission != null) {
            IPermission iPermission = PermissionFactory.getRemoteInstance();
            iPermission.checkFunctionPermission(this.getUserPk(), (IObjectPK)new ObjectUuidPK(storageOrgUnitId), editUIPermission);
        }
        this.prepareUIContext(uiContext, e);
        IUIWindow uiWindow = null;
        uiWindow = SwingUtilities.getWindowAncestor((Component)((Object)this)) != null && SwingUtilities.getWindowAncestor((Component)((Object)this)) instanceof JDialog ? UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(this.getEditUIName(), (Map)uiContext, null, OprtState.VIEW) : UIFactory.createUIFactory((String)this.getEditUIModal()).create(this.getEditUIName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    protected void prepareUIContext(UIContext uiContext, ActionEvent e) {
        RealModeIDList idList = new RealModeIDList();
        idList.add(this.getSelectedKeyValue());
        uiContext.put((Object)"IDList", (Object)idList);
    }

    private void checkSelected() {
        if (this.tbl.getSelectManager().size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
    }

    protected boolean isAllowLoadPrintSetting() {
        return false;
    }

    protected void preparePrintPageHeader(HeadFootModel header) {
        StyleAttributes sa = Styles.getDefaultSA();
        StringBuffer sb = new StringBuffer();
        sb.append(this.getResource("212_InOutStoreDetailReportUI")).append("&[materialNumber]");
        sb.append(this.getResource("213_InOutStoreDetailReportUI")).append("&[materialName]");
        sb.append("&| ");
        header.addRow(sb.toString(), sa);
        sb = new StringBuffer();
        sb.append(this.getResource("214_InOutStoreDetailReportUI")).append("&[model]");
        sb.append(this.getResource("215_InOutStoreDetailReportUI")).append("&[baseUnit]");
        sb.append("&| ");
        header.addRow(sb.toString(), sa);
    }

    protected Map preparePrintVariantMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        String materialid = this.params.getString("CurrentMaterialID");
        MaterialInfo material = null;
        if (materialid != null) {
            try {
                IMaterial imaterial = MaterialFactory.getRemoteInstance();
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add("*");
                sic.add("baseUnit.*");
                sic.add("assistUnit.*");
                material = (MaterialInfo)imaterial.getValue((IObjectPK)new ObjectUuidPK(materialid), sic);
            }
            catch (EASBizException e) {
                logger.error((Object)e);
            }
            catch (BOSException e) {
                logger.error((Object)e);
            }
            map.put("materialName", material.getName());
            map.put("materialNumber", material.getNumber());
            map.put("model", material.getModel());
            map.put("baseUnit", material.getBaseUnit().getName());
            if (material.getAssistUnit() != null) {
                map.put("assistUnit", material.getAssistUnit().getName());
            }
        }
        return map;
    }

    @Override
    public void actionFirst_actionPerformed(ActionEvent e) throws Exception {
        super.actionFirst_actionPerformed(e);
        this.changeMaterialID(6);
        this.query();
    }

    @Override
    public void actionPre_actionPerformed(ActionEvent e) throws Exception {
        super.actionPre_actionPerformed(e);
        this.changeMaterialID(7);
        this.query();
    }

    @Override
    public void actionNext_actionPerformed(ActionEvent e) throws Exception {
        super.actionNext_actionPerformed(e);
        this.changeMaterialID(8);
        this.query();
    }

    @Override
    public void actionLast_actionPerformed(ActionEvent e) throws Exception {
        super.actionLast_actionPerformed(e);
        this.changeMaterialID(9);
        this.query();
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.firstLoadData = true;
        super.actionRefresh_actionPerformed(e);
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        this.firstLoadData = true;
        super.actionQuery_actionPerformed(e);
    }

    protected boolean showQueryDialog(boolean useDefaultSolution) {
        try {
            CommRptBaseConditionUI pc;
            if (this.userPanel == null) {
                this.userPanel = this.getCustomerQueryPanel();
                ReportQueryConditionHelper.initQueryDialog((CustomerQueryPanel)((CommRptBaseConditionUI)this.userPanel), (CommonQueryDialog)this.queryDialog, (Map)this.getUIContext(), (IMetaDataPK)this.getQueryMetaDataPK(), (String)((Object)((Object)this)).getClass().getName(), (RptParams)this.params, (RptParams)this.getUIContextInitParams());
            }
            CustomerParams[] cp = ReportQueryConditionHelper.getCustomerParams((boolean)useDefaultSolution, (CustomerQueryPanel)this.userPanel, (CoreUI)this, (IMetaDataPK)this.getQueryMetaDataPK());
            boolean ok = false;
            if ((this.params == null && cp == null || !useDefaultSolution) && this.queryDialog.show()) {
                CommRptBaseConditionUI rbqp = (CommRptBaseConditionUI)this.queryDialog.getUserPanel(0);
                pc = (CommRptBaseConditionUI)this.queryDialog.getUserPanel(1);
                this.params = rbqp.getCustomCondition();
                if (pc != null) {
                    this.params.putAll(pc.getCustomCondition().toMap());
                }
                ok = true;
            }
            if (this.getUIContext().get("rptParams") == null && cp != null) {
                CommRptBaseConditionUI rptConditionUI = this.getQueryDialogUserPanel();
                rptConditionUI.initUIContentLayout();
                rptConditionUI.onInit(this.getUIContextInitParams());
                rptConditionUI.onLoad();
                rptConditionUI.loadFields();
                rptConditionUI.setCustomerParams(cp[0]);
                rptConditionUI.loadData(null);
                this.params = rptConditionUI.getCustomCondition();
                pc = (CommRptBaseConditionUI)this.queryDialog.getCommonQueryParam().getPanels().get(1);
                if (pc != null && cp[1] != null) {
                    pc.initUIContentLayout();
                    pc.onInit(this.getUIContextInitParams());
                    pc.onLoad();
                    pc.loadFields();
                    pc.setCustomerParams(cp[1]);
                    pc.loadData(null);
                    this.params.putAll(pc.getCustomCondition().toMap());
                }
            }
            if (this.params != null && (ok || useDefaultSolution)) {
                this.queryWithWrap();
                return true;
            }
        }
        catch (Exception e) {
            logger.error((Object)"@showQueryDialog", (Throwable)e);
            this.handleException(e);
        }
        return false;
    }

    protected IRow appendFootRow(RptParams params) {
        try {
            RptRowSet singleRowSet = null;
            singleRowSet = (RptRowSet)params.getObject("totalRs");
            if (singleRowSet == null) {
                return null;
            }
            DefaultKDTableInsertHandler handler = new DefaultKDTableInsertHandler(singleRowSet);
            if (singleRowSet.next()) {
                singleRowSet.setValue("fstorageorgunit", null);
            }
            IRow footRow = null;
            KDTFootManager footRowManager = this.tbl.getFootManager();
            if (footRowManager == null) {
                String total = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Total");
                footRowManager = new KDTFootManager(this.tbl);
                footRowManager.addFootView();
                this.tbl.setFootManager(footRowManager);
                footRow = footRowManager.addFootRow(0);
                footRow.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.getAlignment((String)"right"));
                this.tbl.getIndexColumn().setWidthAdjustMode((short)1);
                this.tbl.getIndexColumn().setWidth(30);
                footRowManager.addIndexText(0, total);
            } else {
                footRow = footRowManager.getFootRow(0);
                if (footRow == null) {
                    footRow = footRowManager.addFootRow(0);
                    footRow.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.getAlignment((String)"right"));
                }
            }
            if (singleRowSet != null && handler != null) {
                handler.setTableRowData(footRow, SCMRptUtil.sortRowData((Object[])singleRowSet.toRowArray(), (CoreUI)this, (KDTable)this.tbl, (ITablePreferenceHelper)this.tHelper));
            }
            footRow.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.getAlignment((String)"right"));
            footRow.getStyleAttributes().setFontColor(Color.BLACK);
            footRow.getStyleAttributes().setBackground(new Color(246, 246, 191));
            return footRow;
        }
        catch (Exception E) {
            E.printStackTrace();
            logger.error((Object)E);
            return null;
        }
    }

    public Object getTablePreferenceSchemaKey() {
        BOSUuid object = null;
        if (this.queryDialog.getCurrentSolutionInfo() != null) {
            object = this.queryDialog.getCurrentSolutionInfo().getId();
        }
        if (object == null && ReportQueryConditionHelper.getDefaultSolution() != null) {
            object = ReportQueryConditionHelper.getDefaultSolution().getId();
        }
        return object;
    }

    public void beforePrintOrPreview() {
        StorageOrgUnitInfo storageOrg = (StorageOrgUnitInfo)this.params.getObject("storageOrgUnit");
        Object[] storageOrgUnits = (Object[])this.params.getObject("storageOrgUnits");
        if (storageOrg == null && storageOrgUnits == null) {
            return;
        }
        if (storageOrg != null) {
            IMRptUtils.checkHasAuthorized(storageOrg.getId().toString(), OrgType.Storage, this.permItem_print);
        }
        if (storageOrgUnits != null) {
            for (int i = 0; i < storageOrgUnits.length; ++i) {
                IMRptUtils.checkHasAuthorized((String)storageOrgUnits[i], OrgType.Storage, this.permItem_print);
            }
        }
        try {
            this.getMaterialPKList(this.params);
        }
        catch (EASBizException e) {
            logger.error((Object)e);
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        this.getMaterialID();
    }

    @Override
    public void actionLocate_actionPerformed(ActionEvent e) throws Exception {
        String uiName = LocateDialogUI.class.getName();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"curTable", (Object)this.getDetailTable());
        if (this.getDetailTable() == null) {
            return;
        }
        if (this.getDetailTable().getRowCount() <= 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoEntry"));
            return;
        }
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(uiName, (Map)uiContext, null, OprtState.ADDNEW, 32);
        uiWindow.show();
    }

    protected KDTable getDetailTable() {
        return this.tbl;
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnLocate.setIcon(EASResource.getIcon((String)"imgTbtn_speedgoto"));
    }
}

