/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.rpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.KDToolkit;
import com.kingdee.bos.ctrl.kdf.headfootdesigner.HeadFootModel;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTMenuManager;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.kdf.table.foot.KDTFootManager;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDPopupMenu;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.StoreType;
import com.kingdee.eas.basedata.org.IStorageOrgUnit;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.LocateDialogUI;
import com.kingdee.eas.framework.config.ITablePreferenceHelper;
import com.kingdee.eas.framework.report.ICommRptBase;
import com.kingdee.eas.framework.report.IVirtualRptBaseFacade;
import com.kingdee.eas.framework.report.SimpleCompanyUserObject;
import com.kingdee.eas.framework.report.client.CommRptBaseConditionUI;
import com.kingdee.eas.framework.report.util.DefaultKDTableInsertHandler;
import com.kingdee.eas.framework.report.util.KDTableInsertHandler;
import com.kingdee.eas.framework.report.util.KDTableUtil;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.framework.report.util.RptTableHeader;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.util.ReportQueryConditionHelper;
import com.kingdee.eas.scm.im.rpt.IMRptUtils;
import com.kingdee.eas.scm.im.rpt.InOutStoreGatherReportFacadeFactory;
import com.kingdee.eas.scm.im.rpt.client.AbstractInOutStoreGatherReportUI;
import com.kingdee.eas.scm.im.rpt.client.InOutStoreDetailReportUI;
import com.kingdee.eas.scm.im.rpt.client.InOutStoreGatherReportConditionUI;
import com.kingdee.eas.scm.util.SCMRptUtil;
import com.kingdee.eas.scm.util.string.StringUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import org.apache.log4j.Logger;

public class InOutStoreGatherReportUI
extends AbstractInOutStoreGatherReportUI {
    private static final long serialVersionUID = -8774923382803313382L;
    private static final Logger logger = CoreUIObject.getLogger(InOutStoreGatherReportUI.class);
    private boolean firstLoadData = true;
    private RptParams toDetailRptParams;
    private static final String resClassName = "com.kingdee.eas.scm.im.rpt.IMRptResource";
    public static final String OrgTempTable = "orgTempTable";
    private int hasRowCount = 0;

    public InOutStoreGatherReportUI() throws Exception {
        this.tbl.setEditable(false);
        this.tbl.getActionMap().remove("Delete");
        this.menuViewDetail.setIcon(EASResource.getIcon((String)"imgTbtn_bill"));
        this.btnViewUI.setIcon(EASResource.getIcon((String)"imgTbtn_bill"));
        this.btnQuery.setIcon(EASResource.getIcon((String)"imgTbtn_filter"));
        this.btnRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.tbl.checkParsed();
        this.tbl.getDataRequestManager().addDataRequestListener((KDTDataRequestListener)this);
        this.tbl.getDataRequestManager().setDataRequestMode(1);
        this.tbl.getDataRequestManager().setPageRowCount(1000);
        this.tbl.getDataRequestManager().setExportPageRowCount(500);
        this.enableExportExcel(this.tbl);
        this.tbl.getDataRequestManager().setExportMemoryCallback(false);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.toDetailRptParams = new RptParams();
        this.setkdDate();
        if (this.tHelper != null) {
            this.tHelper.setCanMoveColumn(true);
        }
    }

    public void setkdDate() {
        this.dateFrom.setValue(this.params.getObject("dateFrom"));
        this.dateTo.setValue(this.params.getObject("dateTo"));
    }

    public String[] getMergeColumnKeys() {
        return null;
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected void tbl_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getClickCount() == 2) {
            int colIndex = this.tbl.getSelectManager().getActiveColumnIndex();
            if (this.tbl.getColumnIndex("FMaterialGroupName") != colIndex && this.tbl.getColumnIndex("FStorageOrgName") != colIndex) {
                ActionEvent evt = new ActionEvent(this.btnViewUI, 0, "Double Clicked");
                ItemAction actView = this.getActionFromActionEvent(evt);
                actView.actionPerformed(evt);
            }
        }
    }

    @Override
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.firstLoadData = true;
        this.insertRowCount = 0;
        super.actionRefresh_actionPerformed(e);
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        this.firstLoadData = true;
        this.insertRowCount = 0;
        super.actionQuery_actionPerformed(e);
        this.setkdDate();
    }

    protected ICommRptBase getRemoteInstance() throws BOSException {
        return InOutStoreGatherReportFacadeFactory.getRemoteInstance();
    }

    protected boolean enableTablePreferences() {
        return true;
    }

    protected KDTable getTableForPrintSetting() {
        return this.tbl;
    }

    protected RptParams getParamsForInit() {
        return null;
    }

    protected CommRptBaseConditionUI getQueryDialogUserPanel() throws Exception {
        InOutStoreGatherReportConditionUI condUI = new InOutStoreGatherReportConditionUI();
        Dimension d = KDToolkit.getScreenSize();
        int h = 580;
        if (d != null && d.height < 768) {
            h = 540;
        }
        d = new Dimension(650, h);
        condUI.setSize(d);
        return condUI;
    }

    protected void query() {
        this.tbl.removeColumns();
        this.tbl.removeRows();
        super.query();
    }

    public Object getTablePreferenceSchemaKey() {
        BOSUuid object = null;
        if (this.queryDialog.getCurrentSolutionInfo() != null) {
            object = this.queryDialog.getCurrentSolutionInfo().getId();
        }
        if (object == null && ReportQueryConditionHelper.getDefaultSolution() != null) {
            object = ReportQueryConditionHelper.getDefaultSolution().getId();
        }
        return object;
    }

    public void getData(KDTDataRequestEvent e) {
        this.tbl.getDataRequestManager().removeDataRequestListener((KDTDataRequestListener)this);
        int start = e.getFirstRow();
        int length = e.getLastRow() - start + 1;
        RptParams para = new RptParams();
        para.setString("tempTable", this.getTempTable());
        para.setString(OrgTempTable, this.getOrgTempTable());
        para.setObject("storageOrgUnit", this.params.getObject("storageOrgUnit"));
        para.setObject("fullStorageOrgUnit", this.params.getObject("fullStorageOrgUnit"));
        para.setObject("dateFrom", this.params.getObject("dateFrom"));
        para.setObject("dateTo", this.params.getObject("dateTo"));
        para.setObject("materialFrom", this.params.getObject("materialFrom"));
        para.setObject("materialTo", this.params.getObject("materialTo"));
        para.setObject("materialTypeFrom", this.params.getObject("materialTypeFrom"));
        para.setObject("materialTypeTo", this.params.getObject("materialTypeTo"));
        para.setObject("materialGroupStandard", this.params.getObject("materialGroupStandard"));
        para.setObject("warehouseFrom", this.params.getObject("warehouseFrom"));
        para.setObject("warehouseTo", this.params.getObject("warehouseTo"));
        para.setObject("locationFrom", this.params.getObject("locationFrom"));
        para.setObject("locationTo", this.params.getObject("locationTo"));
        para.setObject("asstAttrFrom", this.params.getObject("asstAttrFrom"));
        para.setObject("asstAttrTo", this.params.getObject("asstAttrTo"));
        para.setObject("lotFrom", this.params.getObject("lotFrom"));
        para.setObject("lotTo", this.params.getObject("lotTo"));
        para.setObject("txtLotLike", this.params.getObject("txtLotLike"));
        para.setObject("projectNumFrom", this.params.getObject("projectNumFrom"));
        para.setObject("projectNumTo", this.params.getObject("projectNumTo"));
        para.setObject("trackNumFrom", this.params.getObject("trackNumFrom"));
        para.setObject("trackNumTo", this.params.getObject("trackNumTo"));
        para.setObject("ckBxShowProject", this.params.getObject("ckBxShowProject"));
        para.setObject("ckBxShowTrackNum", this.params.getObject("ckBxShowTrackNum"));
        para.setObject("ckBxShowsumRow", this.params.getObject("ckBxShowsumRow"));
        para.setObject("ckBoxLevelGather", this.params.getObject("ckBoxLevelGather"));
        para.setObject("ckBoxShowGatherLine", this.params.getObject("ckBoxShowGatherLine"));
        para.setInt("coBoxGatherCondition", this.params.getInt("coBoxGatherCondition"));
        para.setObject("ckBxIn", this.params.getObject("ckBxIn"));
        para.setObject("ckBxOut", this.params.getObject("ckBxOut"));
        para.setObject("ckBxCostAdjIn", this.params.getObject("ckBxCostAdjIn"));
        para.setObject("ckBxCostAdjOut", this.params.getObject("ckBxCostAdjOut"));
        para.setObject("ckBxLocIn", this.params.getObject("ckBxLocIn"));
        para.setObject("ckBxLocOut", this.params.getObject("ckBxLocOut"));
        para.setObject("RIType", this.params.getObject("RIType"));
        para.setObject("ckBxShowLot", this.params.getObject("ckBxShowLot"));
        para.setObject("ckBxShowAsstAttr", this.params.getObject("ckBxShowAsstAttr"));
        para.setObject("ckBxShowWhs", this.params.getObject("ckBxShowWhs"));
        if (this.params.getObject("ckBxShowLocation") == null) {
            para.setObject("ckBxShowLocation", (Object)new Boolean(false));
        } else {
            para.setObject("ckBxShowLocation", this.params.getObject("ckBxShowLocation"));
        }
        para.setObject("ckBxByStatUnit", this.params.getObject("ckBxByStatUnit"));
        para.setObject("ckBxByStatUnit", this.params.getObject("ckBxByStatUnit"));
        para.setObject("ckBxShowQty", this.params.getObject("ckBxShowQty"));
        para.setObject("ckBxShowAmt", this.params.getObject("ckBxShowAmt"));
        para.setObject("ckBxShowAssistQty", this.params.getObject("ckBxShowAssistQty"));
        para.setObject("ckBxShowPrice", this.params.getObject("ckBxShowPrice"));
        IMRptUtils.setParams4Precision(para, this.params);
        para.setObject("ckBxOnlyShowDetail", this.params.getObject("ckBxOnlyShowDetail"));
        para.setInt("coBoxZeroCondition", this.params.getInt("coBoxZeroCondition"));
        para.setInt("coBoxBillStatus", this.params.getInt("coBoxBillStatus"));
        para.setObject("amtPermssionOrg", this.params.getObject("amtPermssionOrg"));
        para.setObject("ckBxIscalculate", this.params.getObject("ckBxIscalculate"));
        para.setObject("shortNameFrom", this.params.getObject("shortNameFrom"));
        para.setObject("shortNameTo", this.params.getObject("shortNameTo"));
        if (this.params.getObject("ckBxShowMShortName") == null) {
            para.setObject("ckBxShowMShortName", (Object)new Boolean(false));
        } else {
            para.setObject("ckBxShowMShortName", this.params.getObject("ckBxShowMShortName"));
        }
        para.setObject("ckBxStatusAdjIn", this.params.getObject("ckBxStatusAdjIn"));
        para.setObject("ckBxStatusAdjOut", this.params.getObject("ckBxStatusAdjOut"));
        para.setObject("ckBxDecomposeIn", this.params.getObject("ckBxDecomposeIn"));
        para.setObject("ckBxDecomposeOut", this.params.getObject("ckBxDecomposeOut"));
        para.setObject("ckBxShowUpdateInventoryBill", this.params.getObject("ckBxShowUpdateInventoryBill"));
        Date nowBegin = new Date();
        try {
            RptParams rpt;
            if (start == 0 && this.firstLoadData) {
                try {
                    rpt = InOutStoreGatherReportFacadeFactory.getRemoteInstance().createTempTable(para);
                    this.setTempTable(rpt.getString("tempTable"));
                    this.setOrgTempTable(rpt.getString(OrgTempTable));
                    this.params.setObject("idList", rpt.getObject("idList"));
                    this.params.setObject("tempTable", (Object)this.getTempTable());
                    this.params.setString(OrgTempTable, this.getOrgTempTable());
                    this.params.setObject("riTypeColMap", rpt.getObject("riTypeColMap"));
                    this.params.setObject("detailTempTable", (Object)rpt.getString("detailTempTable"));
                    para.setString("tempTable", this.getTempTable());
                    para.setString(OrgTempTable, this.getOrgTempTable());
                    if (logger.isInfoEnabled()) {
                        logger.info((Object)("\u7269\u6599\u6536\u53d1\u4e8b\u52a1\u6c47\u603b\u8868--\u672c\u6b21\u67e5\u8be2\u4f7f\u7528\u7684\u4e34\u65f6\u8868\u540d\u4e3a: " + rpt.getString("tempTable")));
                    }
                    RptTableHeader header = (RptTableHeader)rpt.getObject("header");
                    KDTableUtil.setHeader((RptTableHeader)header, (KDTable)this.tbl);
                    Map queryHeader = (Map)rpt.getObject("queryHeader");
                    if (queryHeader != null && !queryHeader.isEmpty()) {
                        SCMRptUtil.setQueryHeader((KDTable)this.tbl, (ITablePreferenceHelper)this.tHelper, (Map)queryHeader);
                    }
                    if (this.tHelper != null) {
                        this.tHelper.setDefaultUserData(null);
                    }
                    this.initUserConfig();
                    this.tbl.getColumn(this.getTreeCol()).getStyleAttributes().setLocked(true);
                    this.tbl.setRowCount(rpt.getInt("totalCount"));
                    this.fmtColumnPrecision();
                    rpt = InOutStoreGatherReportFacadeFactory.getRemoteInstance().query(para, start, length);
                    this.hasRowCount += length;
                    RptRowSet rs = (RptRowSet)rpt.getObject("rowset");
                    this.insertRows(rs, start, this.tbl, true, (KDTableInsertHandler)new DefaultKDTableInsertHandler(rs), 0);
                    this.appendFootRow(this.params);
                    this.firstLoadData = false;
                }
                catch (BOSException ex) {
                    logger.error((Object)ex);
                    this.handleException((Exception)((Object)ex));
                }
            } else {
                para.setString("tempTable", this.getTempTable());
                rpt = InOutStoreGatherReportFacadeFactory.getRemoteInstance().query(para, start, length);
                RptRowSet rs = (RptRowSet)rpt.getObject("rowset");
                this.hasRowCount += length;
                this.insertRows(rs, start, this.tbl, true, (KDTableInsertHandler)new DefaultKDTableInsertHandler(rs), this.insertRowCount);
            }
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
        this.tbl.getDataRequestManager().addDataRequestListener((KDTDataRequestListener)this);
        this.tbl.getColumn(0).getStyleAttributes().setBackground(Color.white);
        Date nowEnd = new Date();
        float waitSecond = (float)(nowEnd.getTime() - nowBegin.getTime()) / 1000.0f;
        logger.debug((Object)("getData used of times : " + waitSecond + " second."));
    }

    public void insertRows(RptRowSet rs, int insertRowIndex, KDTable table, boolean refreshUI, KDTableInsertHandler handler, int insertRowCount) {
        table.setRefresh(false);
        boolean ckBoxLevelGather = (Boolean)this.params.getObject("ckBoxLevelGather");
        int coBoxGatherCondition = this.params.getInt("coBoxGatherCondition");
        String none = EASResource.getString((String)resClassName, (String)"none");
        String noMaterialType = none + EASResource.getString((String)resClassName, (String)"materialType");
        String noMaterialCostType = none + EASResource.getString((String)resClassName, (String)"materialCostType");
        while (rs.next()) {
            IRow row = this.isExpand ? table.addRow(insertRowIndex++) : table.setRow(insertRowIndex++);
            SimpleCompanyUserObject companyUserObject = new SimpleCompanyUserObject();
            if (rs.getString("FStorageOrgName").equals("zzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzz")) {
                companyUserObject.setCompanyId("zzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzz");
                companyUserObject.setName(EASResource.getString((String)"com.kingdee.eas.scm.im.IMAutoGenerateResource", (String)"216_InOutStoreGatherReportUI"));
                companyUserObject.setBlockId("zzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzz");
                companyUserObject.setExpanded(true);
                companyUserObject.setisIconEmpty(true);
                rs.setValue("FStorageOrgName", null);
            } else {
                if (ckBoxLevelGather) {
                    if (coBoxGatherCondition == 0) {
                        companyUserObject.setCompanyId(rs.getString("fmaterialgroupid"));
                        if (!"X".equals(rs.getString("fmaterialgroupname"))) {
                            companyUserObject.setName(rs.getString("fmaterialgroupname"));
                        } else {
                            companyUserObject.setName(noMaterialType);
                        }
                        companyUserObject.setBlockId(rs.getString("FBlockID"));
                    } else {
                        if (rs.getString("FMaterialCostType") != null && !"X".equals(rs.getString("FMaterialCostType"))) {
                            int materialcosttype = Integer.parseInt(rs.getString("fmaterialcosttype").trim());
                            rs.setValue("FMaterialCostTypeName", (Object)StoreType.getEnum((int)materialcosttype).getAlias());
                        } else {
                            rs.setValue("FMaterialCostType", (Object)"X");
                            rs.setValue("FMaterialCostTypeName", (Object)noMaterialCostType);
                        }
                        companyUserObject.setCompanyId(rs.getString("fmaterialcosttype"));
                        companyUserObject.setName(rs.getString("FMaterialCostTypeName"));
                        companyUserObject.setBlockId(rs.getString("fmaterialcosttype"));
                    }
                } else {
                    companyUserObject.setCompanyId(rs.getString("fstorageorgunitid"));
                    companyUserObject.setName(rs.getString("FStorageOrgName"));
                    companyUserObject.setBlockId(rs.getString("fmaterialid"));
                }
                companyUserObject.setExpanded(false);
            }
            int isleaf = rs.getInt("fisleaf");
            if (isleaf == 1) {
                companyUserObject.setLeaf(true);
            } else {
                companyUserObject.setLeaf(false);
            }
            companyUserObject.setLevel(rs.getInt("flevel"));
            handler.setTableRowData(row, SCMRptUtil.sortRowData((Object[])rs.toRowArray(), (CoreUI)this, (KDTable)table, (ITablePreferenceHelper)this.tHelper));
            ICell cell = row.getCell(this.getTreeCol());
            cell.setValue((Object)companyUserObject);
            cell.setUserObject((Object)companyUserObject);
        }
        if (refreshUI) {
            table.setRefresh(true);
        }
        if (rs.getRowCount() > 0) {
            table.reLayoutAndPaint();
        } else {
            table.repaint();
        }
        this.setCellTreeRenderer();
    }

    protected IVirtualRptBaseFacade getVirtualRemoteInstance() throws BOSException {
        return InOutStoreGatherReportFacadeFactory.getRemoteInstance();
    }

    public RptParams findData(int rowIndex, SimpleCompanyUserObject companyUserObject) throws Exception {
        boolean ckBoxLevelGather = (Boolean)this.params.getObject("ckBoxLevelGather");
        Boolean ckBoxShowGatherLine = (Boolean)this.params.getObject("ckBoxShowGatherLine");
        if (!ckBoxLevelGather || ckBoxShowGatherLine.booleanValue()) {
            // empty if block
        }
        RptParams para = new RptParams();
        IRow row = this.getTable().getRow(rowIndex);
        para.setString("fparentid", companyUserObject.getCompanyId());
        Boolean ckBxOnlyShowDetail = (Boolean)this.params.getObject("ckBxOnlyShowDetail");
        String tempTable = null;
        tempTable = ckBxOnlyShowDetail == false ? this.params.getString("detailTempTable") : this.params.getString("tempTable");
        para.setString("tempTable", tempTable);
        para.setString(OrgTempTable, this.getOrgTempTable());
        para.setString("fmaterialid", (String)row.getCell("fmaterialid").getValue());
        para.setString("fstorageorgunitid", (String)row.getCell("FStorageOrgUnitID").getValue());
        para.setString("findex", row.getCell("FIndex").getValue().toString());
        para.setObject("ckBoxLevelGather", this.params.getObject("ckBoxLevelGather"));
        para.setObject("ckBoxShowGatherLine", this.params.getObject("ckBoxShowGatherLine"));
        para.setInt("coBoxGatherCondition", this.params.getInt("coBoxGatherCondition"));
        para.setObject("warehouseFrom", this.params.getObject("warehouseFrom"));
        para.setObject("warehouseTo", this.params.getObject("warehouseTo"));
        para.setObject("locationFrom", this.params.getObject("locationFrom"));
        para.setObject("locationTo", this.params.getObject("locationTo"));
        para.setObject("asstAttrFrom", this.params.getObject("asstAttrFrom"));
        para.setObject("asstAttrTo", this.params.getObject("asstAttrTo"));
        para.setObject("lotFrom", this.params.getObject("lotFrom"));
        para.setObject("lotTo", this.params.getObject("lotTo"));
        para.setObject("txtLotLike", this.params.getObject("txtLotLike"));
        para.setObject("projectNumFrom", this.params.getObject("projectNumFrom"));
        para.setObject("projectNumTo", this.params.getObject("projectNumTo"));
        para.setObject("trackNumFrom", this.params.getObject("trackNumFrom"));
        para.setObject("trackNumTo", this.params.getObject("trackNumTo"));
        para.setObject("ckBxShowProject", this.params.getObject("ckBxShowProject"));
        para.setObject("ckBxShowTrackNum", this.params.getObject("ckBxShowTrackNum"));
        para.setObject("ckBoxLot", this.params.getObject("ckBoxLot"));
        para.setObject("ckBxIn", this.params.getObject("ckBxIn"));
        para.setObject("ckBxOut", this.params.getObject("ckBxOut"));
        para.setObject("ckBxCostAdjIn", this.params.getObject("ckBxCostAdjIn"));
        para.setObject("ckBxCostAdjOut", this.params.getObject("ckBxCostAdjOut"));
        para.setObject("ckBxLocIn", this.params.getObject("ckBxLocIn"));
        para.setObject("ckBxLocOut", this.params.getObject("ckBxLocOut"));
        para.setObject("RIType", this.params.getObject("RIType"));
        para.setObject("ckBxShowLot", this.params.getObject("ckBxShowLot"));
        para.setObject("ckBxShowAsstAttr", this.params.getObject("ckBxShowAsstAttr"));
        para.setObject("ckBxShowWhs", this.params.getObject("ckBxShowWhs"));
        para.setObject("ckBxShowLocation", this.params.getObject("ckBxShowLocation"));
        if (this.params.getObject("ckBxShowLocation") == null) {
            para.setObject("ckBxShowLocation", (Object)new Boolean(false));
        } else {
            para.setObject("ckBxShowLocation", this.params.getObject("ckBxShowLocation"));
        }
        para.setObject("ckBxByStatUnit", this.params.getObject("ckBxByStatUnit"));
        para.setObject("ckBxShowQty", this.params.getObject("ckBxShowQty"));
        para.setObject("ckBxShowAmt", this.params.getObject("ckBxShowAmt"));
        para.setObject("ckBxShowAssistQty", this.params.getObject("ckBxShowAssistQty"));
        para.setObject("ckBxShowPrice", this.params.getObject("ckBxShowPrice"));
        IMRptUtils.setParams4Precision(para, this.params);
        para.setObject("ckBxOnlyShowDetail", this.params.getObject("ckBxOnlyShowDetail"));
        para.setInt("coBoxZeroCondition", this.params.getInt("coBoxZeroCondition"));
        para.setInt("coBoxBillStatus", this.params.getInt("coBoxBillStatus"));
        para.setObject("shortNameFrom", this.params.getObject("shortNameFrom"));
        para.setObject("shortNameTo", this.params.getObject("shortNameTo"));
        if (this.params.getObject("ckBxShowMShortName") == null) {
            para.setObject("ckBxShowMShortName", (Object)new Boolean(false));
        } else {
            para.setObject("ckBxShowMShortName", this.params.getObject("ckBxShowMShortName"));
        }
        para.setObject("ckBxStatusAdjIn", this.params.getObject("ckBxStatusAdjIn"));
        para.setObject("ckBxStatusAdjOut", this.params.getObject("ckBxStatusAdjOut"));
        para.setObject("ckBxDecomposeIn", this.params.getObject("ckBxDecomposeIn"));
        para.setObject("ckBxDecomposeOut", this.params.getObject("ckBxDecomposeOut"));
        IVirtualRptBaseFacade report = this.getVirtualRemoteInstance();
        RptParams result = report.findData(para, -1, -1, this.getTempTable(), (Object)companyUserObject);
        this.insertRowIndex += 100;
        return result;
    }

    public void setOrgTempTable(String orgTempTable) {
        this.params.setObject(OrgTempTable, (Object)orgTempTable);
    }

    public String getOrgTempTable() {
        if (null != this.params) {
            return this.params.getString(OrgTempTable);
        }
        return "";
    }

    public String getTreeCol() {
        if (((Boolean)this.params.getObject("ckBoxLevelGather")).booleanValue()) {
            return "FMaterialGroupName";
        }
        return "FStorageOrgName";
    }

    private void checkSelected() {
        if (this.tbl.getSelectManager().size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
    }

    protected void putDetailParams() throws BOSException, EASBizException {
        KDTSelectBlock selectBlock = this.tbl.getSelectManager().get();
        Vector<String> v = new Vector<String>();
        String riType = null;
        boolean isIncludeRI = false;
        if (selectBlock != null) {
            int i;
            Map riTypeColMap = (Map)this.params.getObject("riTypeColMap");
            int rowIndex = selectBlock.getTop();
            int colBeginIndex = selectBlock.getBeginCol();
            int colEndIndex = selectBlock.getEndCol();
            IRow row = this.tbl.getRow(rowIndex);
            if (row == null) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
                SysUtil.abort();
            }
            if (selectBlock.getMode() == 2) {
                colEndIndex = this.tbl.getColumnCount() - 1;
            }
            for (i = colBeginIndex; i <= colEndIndex; ++i) {
                riType = this.getRIType(this.tbl.getColumn(i).getKey(), riTypeColMap);
                if (riType == null) continue;
                isIncludeRI = true;
                break;
            }
            if (!isIncludeRI) {
                colEndIndex = this.tbl.getColumnCount() - 1;
                colBeginIndex = 0;
            }
            for (i = colBeginIndex; i <= colEndIndex; ++i) {
                riType = this.getRIType(this.tbl.getColumn(i).getKey(), riTypeColMap);
                if (riType == null || v.contains(riType)) continue;
                v.add(riType);
            }
            if (v.size() == 0) {
                MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"mustContainRIColumn"));
                SysUtil.abort();
            }
            ICell mCell = row.getCell("fmaterialid");
            ICell matnameCell = row.getCell("FMaterialName");
            ICell matnumberCell = row.getCell("FMaterialNumber");
            ICell oCell = row.getCell("FStorageOrgUnitID");
            ICell unitCell = row.getCell("FStatUnitID");
            ICell wCell = row.getCell("FWarehouseID");
            ICell locCell = row.getCell("FLocationName");
            ICell moveInCell = row.getCell("FMoveInQty");
            ICell moveOutCell = row.getCell("FMoveOutQty");
            int index = 1;
            if (row.getCell("FIndex") != null && row.getCell("FIndex").getValue() != null) {
                if (row.getCell("FIndex").getValue() instanceof Integer) {
                    index = (Integer)row.getCell("FIndex").getValue();
                } else if (row.getCell("FIndex").getValue() instanceof BigDecimal) {
                    index = ((BigDecimal)row.getCell("FIndex").getValue()).intValue();
                }
            }
            ICell asstCell = row.getCell("FAssistPropertyID");
            ICell lCell = row.getCell("FLot");
            row.getCell("FParentId");
            ICell beginQtyCell = null;
            Boolean ckBxByStatUnit = (Boolean)this.params.getObject("ckBxByStatUnit");
            beginQtyCell = ckBxByStatUnit != false ? row.getCell("FOriBeginQty") : row.getCell("FBeginQty");
            ICell beginAmtCell = row.getCell("FBeginAmt");
            ICell beginAssQtyCell = row.getCell("FBeginAssQty");
            if (mCell.getValue() == null || ((String)mCell.getValue()).equals("X")) {
                MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"mustContainMaterialColumn"));
                SysUtil.abort();
            }
            Object[] storageOrgUnit = null;
            storageOrgUnit = this.getAllLeafStorageOrg((String)oCell.getValue());
            IPermission iPermission = PermissionFactory.getRemoteInstance();
            for (int i2 = 0; i2 < storageOrgUnit.length; ++i2) {
                iPermission.checkFunctionPermission(this.getUserPk(), (IObjectPK)new ObjectUuidPK(storageOrgUnit[i2].toString()), "inoutstoredetailreport_view");
            }
            this.toDetailRptParams.setObject("dateFrom", this.dateFrom.getValue());
            this.toDetailRptParams.setObject("dateTo", this.dateTo.getValue());
            this.toDetailRptParams.setObject("CurrentMaterialID", mCell.getValue());
            this.toDetailRptParams.setObject("storageOrgUnits", (Object)storageOrgUnit);
            this.toDetailRptParams.setObject("ckBxByStatUnit", this.params.getObject("ckBxByStatUnit"));
            this.toDetailRptParams.setObject("FMaterialName", matnameCell.getValue());
            this.toDetailRptParams.setObject("FMaterialNumber", matnumberCell.getValue());
            if (this.params.getObject("materialGroupStandard") != null) {
                this.toDetailRptParams.setObject("materialGroupStandard", this.params.getObject("materialGroupStandard"));
            }
            if (wCell != null && wCell.getValue() != null) {
                this.toDetailRptParams.setObject("warehouseID", wCell.getValue());
            } else {
                if (this.params.getObject("warehouseFrom") != null) {
                    this.toDetailRptParams.setObject("warehouseFrom", this.params.getObject("warehouseFrom"));
                }
                if (this.params.getObject("warehouseTo") != null) {
                    this.toDetailRptParams.setObject("warehouseTo", this.params.getObject("warehouseTo"));
                }
            }
            this.toDetailRptParams.setInt("coBoxBillStatus", this.params.getInt("coBoxBillStatus"));
            this.toDetailRptParams.setObject("assiAsstPropFrom", this.params.getObject("asstAttrFrom"));
            this.toDetailRptParams.setObject("assiAsstPropTo", this.params.getObject("asstAttrTo"));
            this.toDetailRptParams.setBoolean("ckShowBeginEnd", true);
            this.toDetailRptParams.setBoolean("ckShowNoData", true);
            this.toDetailRptParams.setBoolean("ckBxShowMShortName", this.params.getObject("ckBxShowMShortName") == null ? true : this.params.getBoolean("ckBxShowMShortName"));
            if (locCell != null) {
                BigDecimal ZERO;
                if (locCell.getValue() != null) {
                    this.toDetailRptParams.setObject("FLocationName", locCell.getValue());
                } else if (index == 0) {
                    this.toDetailRptParams.setObject("FLocationName", (Object)"null");
                } else {
                    if (this.params.getObject("locationFrom") != null) {
                        this.toDetailRptParams.setObject("locationFrom", this.params.getObject("locationFrom"));
                    }
                    if (this.params.getObject("locationTo") != null) {
                        this.toDetailRptParams.setObject("locationTo", this.params.getObject("locationTo"));
                    }
                    this.toDetailRptParams.setObject("FLocationName", null);
                }
                BigDecimal moveInQty = ZERO = new BigDecimal("0.00");
                BigDecimal moveOutQty = ZERO;
                String moveBillFlag = "0";
                if (moveInCell.getValue() != null) {
                    moveInQty = (BigDecimal)moveInCell.getValue();
                }
                if (moveOutCell.getValue() != null) {
                    moveOutQty = (BigDecimal)moveOutCell.getValue();
                }
                if (moveInQty.compareTo(ZERO) == 0 && moveOutQty.compareTo(ZERO) == 0) {
                    moveBillFlag = "0";
                } else if (moveInQty.compareTo(ZERO) == 0 && moveOutQty.compareTo(ZERO) != 0) {
                    moveBillFlag = "1";
                } else if (moveInQty.compareTo(ZERO) != 0 && moveOutQty.compareTo(ZERO) == 0) {
                    moveBillFlag = "2";
                }
                this.toDetailRptParams.setObject("moveBillFlag", (Object)moveBillFlag);
            } else {
                if (this.params.getObject("locationFrom") != null) {
                    this.toDetailRptParams.setObject("locationFrom", this.params.getObject("locationFrom"));
                }
                if (this.params.getObject("locationTo") != null) {
                    this.toDetailRptParams.setObject("locationTo", this.params.getObject("locationTo"));
                }
                this.toDetailRptParams.setObject("FLocationName", null);
            }
            this.toDetailRptParams.setObject("riArray", (Object)v.toArray());
            if (lCell != null) {
                if (lCell.getValue() != null) {
                    this.toDetailRptParams.setObject("lot", lCell.getValue());
                } else if (index == 0) {
                    this.toDetailRptParams.setObject("lot", (Object)"null");
                } else {
                    if (this.params.getObject("lotFrom") != null && !this.params.getString("lotFrom").trim().equals("")) {
                        this.toDetailRptParams.setObject("lotFrom", this.params.getObject("lotFrom"));
                    }
                    if (this.params.getObject("lotTo") != null && !this.params.getString("lotTo").trim().equals("")) {
                        this.toDetailRptParams.setObject("lotTo", this.params.getObject("lotTo"));
                    }
                }
            } else {
                if (this.params.getObject("lotFrom") != null && !this.params.getString("lotFrom").trim().equals("")) {
                    this.toDetailRptParams.setObject("lotTo", this.params.getObject("lotTo"));
                }
                if (this.params.getObject("lotTo") != null && !this.params.getString("lotTo").trim().equals("")) {
                    this.toDetailRptParams.setObject("lotTo", this.params.getObject("lotTo"));
                }
            }
            if (asstCell != null && this.tbl.getColumn("FAssistProperty") != null) {
                if (asstCell.getValue() != null) {
                    this.toDetailRptParams.setObject("asstAttrID", asstCell.getValue());
                } else if (index == 0) {
                    this.toDetailRptParams.setObject("asstAttrID", (Object)"null");
                } else {
                    if (this.params.getObject("asstAttrFrom") != null) {
                        this.toDetailRptParams.setObject("asstAttrFrom", this.params.getObject("asstAttrFrom"));
                    }
                    if (this.params.getObject("asstAttrTo") != null) {
                        this.toDetailRptParams.setObject("asstAttrTo", this.params.getObject("asstAttrTo"));
                    }
                }
            } else {
                if (this.params.getObject("asstAttrFrom") != null) {
                    this.toDetailRptParams.setObject("asstAttrFrom", this.params.getObject("asstAttrFrom"));
                }
                if (this.params.getObject("asstAttrTo") != null) {
                    this.toDetailRptParams.setObject("asstAttrTo", this.params.getObject("asstAttrTo"));
                }
            }
            if (ckBxByStatUnit.booleanValue()) {
                ObjectUuidPK pk;
                MeasureUnitInfo mu = null;
                MaterialInfo mi = null;
                String muID = null;
                String miID = null;
                BigDecimal beginQty = (BigDecimal)beginQtyCell.getValue();
                BigDecimal beginAmt = (BigDecimal)beginAmtCell.getValue();
                BigDecimal beginAssQty = (BigDecimal)beginAssQtyCell.getValue();
                if (unitCell != null && (muID = (String)unitCell.getValue()) != null) {
                    pk = new ObjectUuidPK(muID);
                    try {
                        mu = MeasureUnitFactory.getRemoteInstance().getMeasureUnitInfo((IObjectPK)pk);
                    }
                    catch (Exception e) {
                        this.handleException(e);
                    }
                }
                if (mCell != null && (miID = (String)mCell.getValue()) != null) {
                    pk = new ObjectUuidPK(miID);
                    try {
                        mi = MaterialFactory.getRemoteInstance().getMaterialInfo((IObjectPK)pk);
                    }
                    catch (Exception e) {
                        this.handleException(e);
                    }
                }
                this.toDetailRptParams.setObject("beginQty", (Object)beginQty);
                this.toDetailRptParams.setObject("beginAmt", (Object)beginAmt);
                this.toDetailRptParams.setObject("beginAssQty", (Object)beginAssQty);
            } else {
                this.toDetailRptParams.setObject("beginQty", beginQtyCell.getValue());
                this.toDetailRptParams.setObject("beginAmt", beginAmtCell.getValue());
                this.toDetailRptParams.setObject("beginAssQty", beginAssQtyCell.getValue());
            }
            boolean ckBxShowProject = this.params.getBoolean("ckBxShowProject");
            if (ckBxShowProject) {
                ICell projectCell = null;
                projectCell = row.getCell("FProjectNumber");
                if (projectCell.getValue() != null) {
                    this.toDetailRptParams.setObject("project", projectCell.getValue());
                } else if (index == 0) {
                    this.toDetailRptParams.setObject("project", (Object)"null");
                } else {
                    if (this.params.getObject("projectNumFrom") != null) {
                        this.toDetailRptParams.setObject("projectNumFrom", this.params.getObject("projectNumFrom"));
                    }
                    if (this.params.getObject("projectNumTo") != null) {
                        this.toDetailRptParams.setObject("projectNumTo", this.params.getObject("projectNumTo"));
                    }
                }
            } else {
                if (this.params.getObject("projectNumFrom") != null) {
                    this.toDetailRptParams.setObject("projectNumFrom", this.params.getObject("projectNumFrom"));
                }
                if (this.params.getObject("projectNumTo") != null) {
                    this.toDetailRptParams.setObject("projectNumTo", this.params.getObject("projectNumTo"));
                }
            }
            boolean ckBxShowTrackNum = this.params.getBoolean("ckBxShowTrackNum");
            if (ckBxShowTrackNum) {
                ICell trackCell = null;
                trackCell = row.getCell("FTrackNumber");
                if (trackCell.getValue() != null) {
                    this.toDetailRptParams.setObject("track", trackCell.getValue());
                } else if (index == 0) {
                    this.toDetailRptParams.setObject("track", (Object)"null");
                } else {
                    if (this.params.getObject("trackNumFrom") != null) {
                        this.toDetailRptParams.setObject("trackNumFrom", this.params.getObject("trackNumFrom"));
                    }
                    if (this.params.getObject("trackNumTo") != null) {
                        this.toDetailRptParams.setObject("trackNumTo", this.params.getObject("trackNumTo"));
                    }
                }
            } else {
                if (this.params.getObject("trackNumFrom") != null) {
                    this.toDetailRptParams.setObject("trackNumFrom", this.params.getObject("trackNumFrom"));
                }
                if (this.params.getObject("trackNumTo") != null) {
                    this.toDetailRptParams.setObject("trackNumTo", this.params.getObject("trackNumTo"));
                }
            }
            this.toDetailRptParams.setObject("amtPermssionOrg", this.params.getObject("amtPermssionOrg"));
            this.toDetailRptParams.setObject("ckBxShowUpdateInventoryBill", this.params.getObject("ckBxShowUpdateInventoryBill"));
        }
    }

    private String getRIType(String columnName, Map riTypeColMap) {
        if (columnName.startsWith("FCostAdjIn")) {
            return "CostAdjIn";
        }
        if (columnName.startsWith("FCostAdjOut")) {
            return "CostAdjOut";
        }
        if (columnName.startsWith("FMoveIn")) {
            return "MoveIn";
        }
        if (columnName.startsWith("FMoveOut")) {
            return "MoveOut";
        }
        if (columnName.startsWith("FStateAdjustIn")) {
            return "StateAdjustIn";
        }
        if (columnName.startsWith("FStateAdjustOut")) {
            return "StateAdjustOut";
        }
        if (columnName.startsWith("FDecomposeIn")) {
            return "DecomposeIn";
        }
        if (columnName.startsWith("FDecomposeOut")) {
            return "DecomposeOut";
        }
        if (columnName.startsWith("FRITypeQty")) {
            return (String)riTypeColMap.get(columnName);
        }
        return null;
    }

    protected Object[] getAllLeafStorageOrg(String storageOrgUnitID) {
        Vector<String> v = new Vector<String>();
        Vector<String> leafV = new Vector<String>();
        Object[] fullStorageOrg = (Object[])this.params.getObject("fullStorageOrgUnit");
        OrgUnitInfo currOrg = null;
        OrgUnitInfo storageOrg = null;
        int n = fullStorageOrg.length;
        for (int i = 0; i < n; ++i) {
            String fid = ((OrgUnitInfo)fullStorageOrg[i]).get("id").toString();
            if (!fid.equals(storageOrgUnitID)) continue;
            currOrg = (OrgUnitInfo)fullStorageOrg[i];
            break;
        }
        if (currOrg == null) {
            return leafV.toArray();
        }
        boolean isleaf = currOrg.isIsLeaf();
        String longnumber = (String)currOrg.get("longnumber");
        String longnumber2 = null;
        if (isleaf) {
            v.add(storageOrgUnitID);
        } else {
            int n2 = fullStorageOrg.length;
            for (int i = 0; i < n2; ++i) {
                storageOrg = (OrgUnitInfo)fullStorageOrg[i];
                if (storageOrg.getId() == null || storageOrg.getId().toString().equals(storageOrgUnitID) || (longnumber2 = (String)storageOrg.get("longnumber")).indexOf(longnumber) <= -1) continue;
                v.add(storageOrg.getId().toString());
            }
        }
        Object[] orgs = v.toArray();
        try {
            IStorageOrgUnit iStorage = StorageOrgUnitFactory.getRemoteInstance();
            StringBuffer oql = new StringBuffer();
            oql.append("select fid where isBizUnit = 1 and id in (");
            int size = orgs.length;
            for (int i = 0; i < size; ++i) {
                if (i != 0) {
                    oql.append(",");
                }
                oql.append("'").append(orgs[i]).append("'");
            }
            oql.append(")");
            CoreBaseCollection storageColl = iStorage.getCollection(oql.toString());
            int size2 = storageColl.size();
            for (int i = 0; i < size2; ++i) {
                leafV.add(storageColl.get(i).getId().toString());
            }
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        return leafV.toArray();
    }

    protected void initListener() {
        Object[] listeners = this.getTable().getListenerList().getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != KDTMouseListener.class) continue;
            this.getTable().removeKDTMouseListener((KDTMouseListener)listeners[i + 1]);
        }
        this.getTable().addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                if (e.getButton() == 3) {
                    KDTMenuManager tm = InOutStoreGatherReportUI.this.getMenuManager(InOutStoreGatherReportUI.this.getTable());
                    if (tm == null) {
                        return;
                    }
                    KDPopupMenu menu = tm.getMenu();
                    if (menu == null) {
                        menu = new KDPopupMenu();
                    }
                    menu.setUserObject((Object)e);
                    if (e.getButton() == 3 && e.getClickCount() == 1) {
                        menu.show(e.getOriginView(), e.getX(), e.getY());
                    }
                } else {
                    int row = e.getRowIndex();
                    int column = e.getColIndex();
                    if (e.getClickCount() == 1) {
                        InOutStoreGatherReportUI.this.cellClicked(row, column, e.getX(), e.getY());
                    } else if (e.getClickCount() == 2) {
                        try {
                            InOutStoreGatherReportUI.this.tbl_tableClicked(e);
                        }
                        catch (Exception e1) {
                            logger.error((Object)e1);
                        }
                    }
                }
            }
        });
    }

    protected KDTable getTable() {
        return this.tbl;
    }

    public void fmtColumnPrecision() {
        String qtyFmt = SCMClientUtils.getFormatPattern((int)this.params.getInt("spinQtyPrecission"));
        String amtFmt = SCMClientUtils.getFormatPattern((int)this.params.getInt("spinAmountPrecission"));
        String assistQtyFmt = SCMClientUtils.getFormatPattern((int)this.params.getInt("spinAssQtyPrecission"));
        String priceFmt = SCMClientUtils.getFormatPattern((int)this.params.getInt("spinPricePrecission"));
        int columnCount = this.tbl.getColumnCount();
        String key = "";
        for (int i = 0; i < columnCount; ++i) {
            key = this.tbl.getColumnKey(i);
            if (key.indexOf("Qty") > -1) {
                if (key.indexOf("AssQty") > -1) {
                    this.tbl.getColumn(i).getStyleAttributes().setNumberFormat(assistQtyFmt);
                    continue;
                }
                this.tbl.getColumn(i).getStyleAttributes().setNumberFormat(qtyFmt);
                continue;
            }
            if (key.indexOf("Amt") > -1) {
                this.tbl.getColumn(i).getStyleAttributes().setNumberFormat(amtFmt);
                continue;
            }
            if (key.indexOf("Price") <= -1) continue;
            this.tbl.getColumn(i).getStyleAttributes().setNumberFormat(priceFmt);
        }
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrint_actionPerformed(e);
    }

    @Override
    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrintPreview_actionPerformed(e);
    }

    @Override
    public void actionFirst_actionPerformed(ActionEvent e) throws Exception {
        super.actionFirst_actionPerformed(e);
    }

    @Override
    public void actionPre_actionPerformed(ActionEvent e) throws Exception {
        super.actionPre_actionPerformed(e);
    }

    @Override
    public void actionNext_actionPerformed(ActionEvent e) throws Exception {
        super.actionNext_actionPerformed(e);
    }

    @Override
    public void actionLast_actionPerformed(ActionEvent e) throws Exception {
        super.actionLast_actionPerformed(e);
    }

    private String getEditUIName() {
        return InOutStoreDetailReportUI.class.getName();
    }

    public void viewUIPreChecked() {
    }

    @Override
    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.toDetailRptParams = new RptParams();
        this.putDetailParams();
        IMRptUtils.setParams4Precision(this.toDetailRptParams, this.params);
        UIContext uiContext = new UIContext((Object)this);
        String orgStr = this.toStringObjArray((Object[])this.toDetailRptParams.getObject("storageOrgUnits"));
        String riStr = this.toStringObjArray((Object[])this.toDetailRptParams.getObject("riArray"));
        uiContext.put((Object)"param1", (Object)this.toDetailRptParams.getObject("dateFrom").toString());
        uiContext.put((Object)"param2", (Object)this.toDetailRptParams.getObject("dateTo").toString());
        uiContext.put((Object)"param3", (Object)this.toDetailRptParams.getObject("CurrentMaterialID").toString());
        uiContext.put((Object)"param4", (Object)orgStr);
        uiContext.put((Object)"param5", (Object)riStr);
        if (this.toDetailRptParams.getObject("warehouseID") != null) {
            uiContext.put((Object)"param6", (Object)this.toDetailRptParams.getObject("warehouseID").toString());
        } else {
            uiContext.put((Object)"param6", null);
        }
        uiContext.put((Object)"rptParams", (Object)this.toDetailRptParams);
        IUIWindow uiWindow = null;
        uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create(this.getEditUIName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    protected void disposeUIWindow() {
        super.disposeUIWindow();
        try {
            if (!StringUtil.isEmpty((String)this.getOrgTempTable())) {
                InOutStoreGatherReportFacadeFactory.getRemoteInstance().dropTempTable(this.getOrgTempTable());
            }
        }
        catch (EASBizException e) {
            logger.error((Object)e);
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
    }

    public String toStringObjArray(Object[] objArray) {
        String rtnStr = "";
        if (objArray != null && objArray.length != 0) {
            for (int i = 0; i < objArray.length; ++i) {
                rtnStr = rtnStr + objArray[i] + ",";
            }
        }
        return rtnStr;
    }

    protected boolean isAllowLoadPrintSetting() {
        return true;
    }

    protected void preparePrintPageHeader(HeadFootModel header) {
        StyleAttributes sa = Styles.getDefaultSA();
        StringBuffer sb = new StringBuffer();
        sb.append(EASResource.getString((String)"com.kingdee.eas.scm.im.IMAutoGenerateResource", (String)"217_InOutStoreGatherReportUI")).append(" &[dateFrom]");
        sb.append(EASResource.getString((String)"com.kingdee.eas.scm.im.IMAutoGenerateResource", (String)"218_InOutStoreGatherReportUI")).append(" &[dateTo]");
        sb.append("&| &| ");
        header.addRow(sb.toString(), sa);
    }

    protected Map preparePrintVariantMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        Date dateFrom = (Date)this.params.getObject("dateFrom");
        Date dateTo = (Date)this.params.getObject("dateTo");
        map.put("dateFrom", IMRptUtils.getFmtDate(dateFrom));
        map.put("dateTo", IMRptUtils.getFmtDate(dateTo));
        return map;
    }

    protected boolean showQueryDialog(boolean useDefaultSolution) {
        try {
            CommRptBaseConditionUI pc;
            if (this.userPanel == null) {
                this.userPanel = this.getCustomerQueryPanel();
                ReportQueryConditionHelper.initQueryDialog((CustomerQueryPanel)((CommRptBaseConditionUI)this.userPanel), (CommonQueryDialog)this.queryDialog, (Map)this.getUIContext(), (IMetaDataPK)this.getQueryMetaDataPK(), (String)((Object)((Object)this)).getClass().getName(), (RptParams)this.params, (RptParams)this.getUIContextInitParams());
            }
            CustomerParams[] cp = ReportQueryConditionHelper.getCustomerParams((boolean)useDefaultSolution, (CustomerQueryPanel)this.userPanel, (CoreUI)this, (IMetaDataPK)this.getQueryMetaDataPK());
            boolean ok = false;
            if ((this.params == null && cp == null || !useDefaultSolution) && this.queryDialog.show()) {
                CommRptBaseConditionUI rbqp = (CommRptBaseConditionUI)this.queryDialog.getUserPanel(0);
                pc = (CommRptBaseConditionUI)this.queryDialog.getUserPanel(1);
                this.params = rbqp.getCustomCondition();
                if (pc != null) {
                    this.params.putAll(pc.getCustomCondition().toMap());
                }
                ok = true;
            }
            if (cp != null) {
                CommRptBaseConditionUI rptConditionUI = this.getQueryDialogUserPanel();
                rptConditionUI.initUIContentLayout();
                rptConditionUI.onInit(this.getUIContextInitParams());
                rptConditionUI.onLoad();
                rptConditionUI.loadFields();
                rptConditionUI.setCustomerParams(cp[0]);
                rptConditionUI.loadData(null);
                this.params = rptConditionUI.getCustomCondition();
                pc = (CommRptBaseConditionUI)this.queryDialog.getCommonQueryParam().getPanels().get(1);
                if (pc != null && cp[1] != null) {
                    pc.initUIContentLayout();
                    pc.onInit(this.getUIContextInitParams());
                    pc.onLoad();
                    pc.loadFields();
                    pc.setCustomerParams(cp[1]);
                    pc.loadData(null);
                    this.params.putAll(pc.getCustomCondition().toMap());
                }
            }
            if (this.params != null && (ok || useDefaultSolution)) {
                this.queryWithWrap();
                return true;
            }
        }
        catch (Exception e) {
            logger.error((Object)"@showQueryDialog", (Throwable)e);
            this.handleException(e);
        }
        return false;
    }

    protected void getAllDataOfId() {
        if (this.params.getObject("idList") != null) {
            RptRowSet result = (RptRowSet)this.params.getObject("idList");
            this.allIdList = new ArrayList();
            while (result.next()) {
                this.allIdList.add(result.getString("FId"));
            }
            this.getTable().setRowCount(this.allIdList.size());
            this.setButtonEnabled(true);
        } else {
            super.getAllDataOfId();
        }
    }

    protected String getUIFullName() {
        return "com.kingdee.eas.scm.im.rpt.client.InOutStoreGatherReportUI";
    }

    public boolean isAsynchronism() {
        return true;
    }

    protected IRow appendFootRow(KDTableInsertHandler handler, RptRowSet rs) {
        Boolean ckBxShowsumRow = (Boolean)this.params.getObject("ckBxShowsumRow");
        if (!ckBxShowsumRow.booleanValue()) {
            return null;
        }
        try {
            IRow footRow = null;
            KDTFootManager footRowManager = this.tbl.getFootManager();
            if (footRowManager == null) {
                String total = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Total");
                footRowManager = new KDTFootManager(this.tbl);
                footRowManager.addFootView();
                this.tbl.setFootManager(footRowManager);
                footRow = footRowManager.addFootRow(0);
                footRow.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.getAlignment((String)"right"));
                this.tbl.getIndexColumn().setWidthAdjustMode((short)1);
                this.tbl.getIndexColumn().setWidth(30);
                footRowManager.addIndexText(0, total);
            } else {
                footRow = footRowManager.getFootRow(0);
            }
            if (rs != null && handler != null) {
                handler.setTableRowData(footRow, SCMRptUtil.sortRowData((Object[])rs.toRowArray(), (CoreUI)this, (KDTable)this.tbl, (ITablePreferenceHelper)this.tHelper));
            }
            footRow.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.getAlignment((String)"right"));
            footRow.getStyleAttributes().setFontColor(Color.BLACK);
            footRow.getStyleAttributes().setBackground(new Color(246, 246, 191));
            return footRow;
        }
        catch (Exception E) {
            logger.error((Object)E);
            return null;
        }
    }

    protected IRow appendFootRow(RptParams params) {
        Boolean ckBxShowsumRow = (Boolean)params.getObject("ckBxShowsumRow");
        if (!ckBxShowsumRow.booleanValue()) {
            IRow footRow = null;
            KDTFootManager footRowManager = this.tbl.getFootManager();
            if (footRowManager != null && (footRow = footRowManager.getFootRow(0)) != null) {
                footRowManager.getFoot().removeRow(footRow.getRowIndex());
            }
            return null;
        }
        try {
            RptRowSet singleRowSet = null;
            singleRowSet = InOutStoreGatherReportFacadeFactory.getRemoteInstance().calFootRow(params);
            if (singleRowSet == null) {
                return null;
            }
            DefaultKDTableInsertHandler handler = new DefaultKDTableInsertHandler(singleRowSet);
            if (singleRowSet.next()) {
                singleRowSet.setValue("FStorageOrgName", null);
            }
            IRow footRow = null;
            KDTFootManager footRowManager = this.tbl.getFootManager();
            if (footRowManager == null) {
                String total = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Total");
                footRowManager = new KDTFootManager(this.tbl);
                footRowManager.addFootView();
                this.tbl.setFootManager(footRowManager);
                footRow = footRowManager.addFootRow(0);
                footRow.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.getAlignment((String)"right"));
                this.tbl.getIndexColumn().setWidthAdjustMode((short)1);
                this.tbl.getIndexColumn().setWidth(30);
                footRowManager.addIndexText(0, total);
            } else {
                footRow = footRowManager.getFootRow(0);
                if (footRow == null) {
                    footRow = footRowManager.addFootRow(0);
                    footRow.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.getAlignment((String)"right"));
                }
            }
            if (singleRowSet != null && handler != null) {
                handler.setTableRowData(footRow, SCMRptUtil.sortRowData((Object[])singleRowSet.toRowArray(), (CoreUI)this, (KDTable)this.tbl, (ITablePreferenceHelper)this.tHelper));
            }
            footRow.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.getAlignment((String)"right"));
            footRow.getStyleAttributes().setFontColor(Color.BLACK);
            footRow.getStyleAttributes().setBackground(new Color(246, 246, 191));
            return footRow;
        }
        catch (Exception E) {
            logger.error((Object)E);
            return null;
        }
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }

    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.INVENTORYMANAGEMENT;
    }

    @Override
    public void actionLocate_actionPerformed(ActionEvent e) throws Exception {
        String uiName = LocateDialogUI.class.getName();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"curTable", (Object)this.getDetailTable());
        if (this.getDetailTable() == null) {
            return;
        }
        if (this.getDetailTable().getRowCount() <= 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoEntry"));
            return;
        }
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(uiName, (Map)uiContext, null, OprtState.ADDNEW, 32);
        uiWindow.show();
    }

    protected KDTable getDetailTable() {
        return this.tbl;
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnLocate.setIcon(EASResource.getIcon((String)"imgTbtn_speedgoto"));
    }
}

