/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.rpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.client.f7.SCMRptMultiOrgsF7;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.scm.im.inv.client.InvClientUtils;
import com.kingdee.eas.scm.im.rpt.IMRptUtils;
import com.kingdee.eas.scm.im.rpt.client.AbstractInOutTransactionFilterUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Vector;
import javax.swing.event.ChangeEvent;
import org.apache.log4j.Logger;

public class InOutTransactionFilterUI
extends AbstractInOutTransactionFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(InOutTransactionFilterUI.class);
    private static final String resClassName = "com.kingdee.eas.scm.im.rpt.IMRptResource";
    private SCMRptMultiOrgsF7 f7;
    private static final String permItem = "InOutTransaction_view";
    private Object[] fullStorageOrgUnit;
    private Object stDate = null;
    private Object enDate = null;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected void bizStorageOrgUnit_stateChanged(ChangeEvent e) throws Exception {
        super.bizStorageOrgUnit_stateChanged(e);
    }

    @Override
    public void loadFields() {
        super.loadFields();
        Date ed = IMRptUtils.getDate(new Date());
        long tl = ed.getTime();
        Date bd = new Date(tl - 604800000L);
        this.kdDateFrom.setValue((Object)bd);
        this.kdDateTo.setValue((Object)ed);
        this.coBoxGatherCondition.setEnabled(false);
        this.chkLot.setSelected(false);
        this.chkAssistProperty.setSelected(false);
        this.onlyQty.setSelected(true);
        this.chkTotal.setSelected(true);
        try {
            this.addF7Listener();
            this.setF7();
        }
        catch (Exception e) {
            super.handUIException((Throwable)e);
        }
    }

    public boolean verify() {
        Object[] storageOrg;
        if (this.bizStorageOrgUnit.getValue() == null || ((Object[])this.bizStorageOrgUnit.getValue()).length == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"storageOrgUnitNotNull"));
            return false;
        }
        if (((Object[])this.bizStorageOrgUnit.getValue()).length == 1 && ((storageOrg = (Object[])this.bizStorageOrgUnit.getValue())[0] == null || storageOrg[0].toString().length() == 0)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"storageOrgUnitNotNull"));
            return false;
        }
        Date dateFrom = (Date)this.kdDateFrom.getValue();
        Date dateTo = (Date)this.kdDateTo.getValue();
        if (dateFrom == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"STARTDATE_NOT_NULL"));
            this.kdDateFrom.requestFocus();
            return false;
        }
        if (dateTo == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"END_DATE_NULL"));
            this.kdDateTo.requestFocus();
            return false;
        }
        if (dateTo.getTime() < dateFrom.getTime()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"END_BEFORE_START"));
            this.kdDateTo.requestFocus();
            return false;
        }
        String[] storageOrgIDs = new String[this.fullStorageOrgUnit.length];
        int size = this.fullStorageOrgUnit.length;
        for (int i = 0; i < size; ++i) {
            storageOrgIDs[i] = ((FullOrgUnitInfo)this.fullStorageOrgUnit[i]).getId().toString();
        }
        try {
            if (!IMRptUtils.checkSameCurrency(storageOrgIDs)) {
                return false;
            }
        }
        catch (BOSException e) {
            super.handUIException((Throwable)e);
        }
        if (this.kdRadioQtyAndAmount.isSelected() && !this.checkViewAmountStatus()) {
            this.onlyQty.setSelected(true);
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"rptPermission"));
            return false;
        }
        if (!this.isSelectTranType()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"rptSelectTranType"));
            return false;
        }
        return true;
    }

    public void onInit(RptParams initParams) throws Exception {
        this.f7 = new SCMRptMultiOrgsF7(this.bizStorageOrgUnit, OrgType.Storage, permItem, EASResource.getString((String)resClassName, (String)"storageOrgUnitMutilF7"));
        this.stDate = this.kdDateFrom.getValue();
        this.enDate = this.kdDateTo.getValue();
    }

    public RptParams getCustomCondition() {
        RptParams para = new RptParams();
        para.setObject("storageOrgUnit", this.bizStorageOrgUnit.getValue());
        para.setObject("fullStorageOrgUnit", (Object)this.fullStorageOrgUnit);
        para.setObject("dateFrom", this.kdDateFrom.getValue());
        para.setObject("dateTo", this.kdDateTo.getValue());
        para.setObject("materialFrom", this.bizMaterialFrom.getValue());
        para.setObject("materialTo", this.bizMaterialTo.getValue());
        para.setObject("materialTypeFrom", this.bizMaterialTypeFrom.getValue());
        para.setInt("coBoxGatherCondition", this.coBoxGatherCondition.getSelectedIndex());
        para.setObject("promptAssistPropertyEnd", this.promptAssistPropertyEnd.getValue());
        para.setObject("promptAssistProptyStart", this.promptAssistProptyStart.getValue());
        para.setObject("promptLotStart", (Object)this.promptLotStart.getText());
        para.setObject("propmptLotEnd", (Object)this.propmptLotEnd.getText());
        para.setObject("promptWarehouseEnd", this.promptWarehouseEnd.getValue());
        para.setObject("promptWarehouseStart", this.promptWarehouseStart.getValue());
        para.setObject("chkTotal", (Object)this.chkTotal.isSelected());
        para.setObject("onlyQty", (Object)this.onlyQty.isSelected());
        para.setObject("kdRadioQtyAndAmount", (Object)this.kdRadioQtyAndAmount.isSelected());
        para.setObject("kdTextTypeNoStart", (Object)this.kdTextTypeNoStart.getText());
        para.setObject("kdTextTypeNoEnd", (Object)this.kdTextTypeNoEnd.getText());
        para.setBoolean("chkAssistProperty", this.chkAssistProperty.isSelected());
        para.setBoolean("chkLot", this.chkLot.isSelected());
        para.setObject("chkCostAdjustIn", (Object)this.chkCostAdjustIn.isSelected());
        para.setObject("chkCostAdjustOut", (Object)this.chkCostAdjustOut.isSelected());
        para.setObject("chkCostIn", (Object)this.chkCostIn.isSelected());
        para.setObject("chkCostOut", (Object)this.chkCostOut.isSelected());
        para.setObject("chkExcepIn", (Object)this.chkExcepIn.isSelected());
        para.setObject("chkExcepOut", (Object)this.chkExcepOut.isSelected());
        para.setObject("productOut", (Object)this.productOut.isSelected());
        para.setObject("chkMoveIn", (Object)this.chkMoveIn.isSelected());
        para.setObject("chkMoveOut", (Object)this.chkMoveOut.isSelected());
        para.setObject("chkProductIn", (Object)this.chkProductIn.isSelected());
        para.setObject("chkPurIn", (Object)this.chkPurIn.isSelected());
        para.setObject("chkPurOut", (Object)this.chkPurOut.isSelected());
        para.setObject("chkSaleBack", (Object)this.chkSaleBack.isSelected());
        para.setObject("chksaleOut", (Object)this.chksaleOut.isSelected());
        para.setObject("chkTakeback", (Object)this.chkTakeback.isSelected());
        para.setObject("chkTakeout", (Object)this.chkTakeout.isSelected());
        para.setObject("chkPurInUnion", (Object)this.chkPurInUnion.isSelected());
        para.setObject("chkProductInUnion", (Object)this.chkProductInUnion.isSelected());
        para.setObject("chkSaleoutUnion", (Object)this.chkSaleoutUnion.isSelected());
        para.setObject("chkTakeoutUnion", (Object)this.chkTakeoutUnion.isSelected());
        para.setObject("chkPurInUnionIsEnabled", (Object)this.chkPurInUnion.isEnabled());
        para.setObject("chkProductInUnionIsEnabled", (Object)this.chkProductInUnion.isEnabled());
        para.setObject("chkSaleoutUnionIsIsEnabled", (Object)this.chkSaleoutUnion.isEnabled());
        para.setObject("chkTakeoutUnioIsEnabled", (Object)this.chkTakeoutUnion.isEnabled());
        return para;
    }

    private boolean checkViewAmountStatus() {
        boolean isAllow = true;
        boolean isEntry = false;
        try {
            IPermission permisson = PermissionFactory.getRemoteInstance();
            Object[] storageOrg = (Object[])this.bizStorageOrgUnit.getValue();
            BOSUuid bosid = null;
            int n = storageOrg.length;
            for (int i = 0; storageOrg != null && i < n; ++i) {
                Collection userColl;
                if (!isEntry) {
                    isEntry = true;
                }
                if (!((FullOrgUnitInfo)storageOrg[i]).isIsLeaf() || this.isExistUser(userColl = permisson.getAuthorizedUsers((IObjectPK)new ObjectUuidPK(bosid = (BOSUuid)((FullOrgUnitInfo)storageOrg[i]).get("id")), "InOutTrans_view_amount"))) continue;
                isAllow = false;
                break;
            }
        }
        catch (BOSException e) {
            logger.error((Object)e);
            isAllow = false;
        }
        catch (EASBizException e) {
            logger.error((Object)e);
            isAllow = false;
        }
        return isAllow && isEntry;
    }

    private boolean isExistUser(Collection userColl) {
        if (userColl == null) {
            return false;
        }
        HashSet collSet = (HashSet)userColl;
        String userid = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        return collSet.contains(userid);
    }

    public void setCustomCondition(RptParams params) {
        this.bizStorageOrgUnit.setValue(params.getObject("storageOrgUnit"));
        this.kdDateFrom.setValue(params.getObject("dateFrom"));
        this.kdDateTo.setValue(params.getObject("dateTo"));
        this.bizMaterialFrom.setValue(params.getObject("materialFrom"));
        this.bizMaterialTo.setValue(params.getObject("materialTo"));
        this.bizMaterialTypeFrom.setValue(params.getObject("materialTypeFrom"));
        this.coBoxGatherCondition.setSelectedIndex(params.getInt("coBoxGatherCondition"));
        this.promptAssistProptyStart.setValue(params.getObject("promptAssistProptyStart"));
        this.promptAssistPropertyEnd.setValue(params.getObject("promptAssistPropertyEnd"));
        this.promptLotStart.setText(params.getString("promptLotStart"));
        this.propmptLotEnd.setText(params.getString("propmptLotEnd"));
        this.promptWarehouseEnd.setValue(params.getObject("promptWarehouseEnd"));
        this.promptWarehouseStart.setValue(params.getObject("promptWarehouseStart"));
        this.chkTotal.setSelected(params.getBoolean("chkTotal"));
        this.onlyQty.setSelected(params.getBoolean("onlyQty"));
        this.kdRadioQtyAndAmount.setSelected(((Boolean)params.getObject("kdRadioQtyAndAmount")).booleanValue());
        this.kdTextTypeNoStart.setText(params.getString("kdTextTypeNoStart"));
        this.kdTextTypeNoEnd.setText(params.getString("kdTextTypeNoEnd"));
        this.chkCostAdjustIn.setSelected(((Boolean)params.getObject("chkCostAdjustIn")).booleanValue());
        this.chkCostAdjustOut.setSelected(((Boolean)params.getObject("chkCostAdjustOut")).booleanValue());
        this.chkCostIn.setSelected(((Boolean)params.getObject("chkCostIn")).booleanValue());
        this.chkCostOut.setSelected(((Boolean)params.getObject("chkCostOut")).booleanValue());
        this.chkExcepIn.setSelected(((Boolean)params.getObject("chkExcepIn")).booleanValue());
        this.chkExcepOut.setSelected(((Boolean)params.getObject("chkExcepOut")).booleanValue());
        this.chkLot.setSelected(((Boolean)params.getObject("chkLot")).booleanValue());
        this.chkMoveIn.setSelected(((Boolean)params.getObject("chkMoveIn")).booleanValue());
        this.chkMoveOut.setSelected(((Boolean)params.getObject("chkMoveOut")).booleanValue());
        this.chkProductIn.setSelected(((Boolean)params.getObject("chkProductIn")).booleanValue());
        this.chkPurIn.setSelected(((Boolean)params.getObject("chkPurIn")).booleanValue());
        this.chkPurOut.setSelected(((Boolean)params.getObject("chkPurOut")).booleanValue());
        this.chkSaleBack.setSelected(((Boolean)params.getObject("chkSaleBack")).booleanValue());
        this.chksaleOut.setSelected(((Boolean)params.getObject("chksaleOut")).booleanValue());
        this.chkTakeback.setSelected(((Boolean)params.getObject("chkTakeback")).booleanValue());
        this.chkTakeout.setSelected(((Boolean)params.getObject("chkTakeout")).booleanValue());
        this.productOut.setSelected(params.getBoolean("productOut"));
        this.chkPurInUnion.setSelected(params.getBoolean("chkPurInUnion"));
        this.chkProductInUnion.setSelected(params.getBoolean("chkProductInUnion"));
        this.chkSaleoutUnion.setSelected(params.getBoolean("chkSaleoutUnion"));
        this.chkTakeoutUnion.setSelected(params.getBoolean("chkTakeoutUnion"));
        this.chkPurInUnion.setEnabled(params.getBoolean("chkPurInUnionIsEnabled"));
        this.chkProductInUnion.setEnabled(params.getBoolean("chkProductInUnionIsEnabled"));
        this.chkSaleoutUnion.setEnabled(params.getBoolean("chkSaleoutUnionIsIsEnabled"));
        this.chkTakeoutUnion.setEnabled(params.getBoolean("chkTakeoutUnioIsEnabled"));
        if (this.chkTotal.isSelected()) {
            this.setTranTypeEnabled(false);
        } else {
            this.setTranTypeEnabled(true);
        }
        if (this.chkProductInUnion.isSelected()) {
            this.chkProductIn.setEnabled(false);
            this.productOut.setEnabled(false);
        }
        if (this.chkPurInUnion.isSelected()) {
            this.chkPurIn.setEnabled(false);
            this.chkPurOut.setEnabled(false);
        }
        if (this.chkSaleoutUnion.isSelected()) {
            this.chksaleOut.setEnabled(false);
            this.chkSaleBack.setEnabled(false);
        }
        if (this.chkTakeoutUnion.isSelected()) {
            this.chkTakeout.setEnabled(false);
            this.chkTakeback.setEnabled(false);
        }
    }

    private void setF7() throws Exception {
        InvClientUtils.getMaterialF7ForFilterUI(this.bizMaterialFrom, (Object)this);
        InvClientUtils.getMaterialF7ForFilterUI(this.bizMaterialTo, (Object)this);
        IMRptUtils.setBizMaterialGroup(this.bizMaterialTypeFrom);
    }

    protected void addF7Listener() {
        this.bizStorageOrgUnit.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                try {
                    InOutTransactionFilterUI.this.bizStorageOrgUnit_dataChanged(e);
                }
                catch (Exception e1) {
                    logger.error((Object)e);
                }
            }
        });
        this.promptWarehouseStart.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                InOutTransactionFilterUI.this.promptWarehouseStart_willShow(e);
            }
        });
        this.promptWarehouseEnd.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                InOutTransactionFilterUI.this.promptWarehouseEnd_willShow(e);
            }
        });
    }

    protected void bizStorageOrgUnit_dataChanged(DataChangeEvent e) {
        this.fullStorageOrgUnit = (Object[])this.f7.getFullData();
        if (this.fullStorageOrgUnit != null) {
            Vector<String> vOrgs = new Vector<String>();
            for (int i = 0; i < this.fullStorageOrgUnit.length; ++i) {
                vOrgs.add(((FullOrgUnitInfo)this.fullStorageOrgUnit[i]).getId().toString());
            }
            if (this.fullStorageOrgUnit.length > 0) {
                IMRptUtils.setRptWarehouseFilter(vOrgs.toArray(), this.promptWarehouseStart);
                IMRptUtils.setRptWarehouseFilter(vOrgs.toArray(), this.promptWarehouseEnd);
            }
        }
    }

    protected void promptWarehouseStart_willShow(SelectorEvent e) {
        this.storageOrgUnitCheck();
    }

    protected void promptWarehouseEnd_willShow(SelectorEvent e) {
        this.storageOrgUnitCheck();
    }

    protected void storageOrgUnitCheck() {
        Object[] storageOrg;
        if (this.bizStorageOrgUnit.getValue() == null || ((Object[])this.bizStorageOrgUnit.getValue()).length == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"storageOrgUnitNotNull"));
            SysUtil.abort();
        } else if (((Object[])this.bizStorageOrgUnit.getValue()).length == 1 && ((storageOrg = (Object[])this.bizStorageOrgUnit.getValue())[0] == null || storageOrg[0].toString().length() == 0)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"storageOrgUnitNotNull"));
            SysUtil.abort();
        }
    }

    @Override
    protected void chkAssistProperty_actionPerformed(ActionEvent e) throws Exception {
        if (this.chkAssistProperty.isSelected()) {
            this.promptAssistProptyStart.setEnabled(true);
            this.promptAssistPropertyEnd.setEnabled(true);
        } else {
            this.promptAssistProptyStart.setEnabled(false);
            this.promptAssistPropertyEnd.setEnabled(false);
        }
    }

    @Override
    protected void chkLot_actionPerformed(ActionEvent e) throws Exception {
        if (this.chkLot.isSelected()) {
            this.promptLotStart.setEnabled(true);
            this.propmptLotEnd.setEnabled(true);
        } else {
            this.promptLotStart.setEnabled(false);
            this.propmptLotEnd.setEnabled(false);
        }
    }

    @Override
    protected void chkTotal_actionPerformed(ActionEvent e) throws Exception {
        if (this.chkTotal.isSelected()) {
            this.setTranTypeEnabled(false);
            this.setTranTypeSelected(false);
            this.setTranTypeUnionEnable(false);
            this.setTranTypeUnionSelect(false);
        } else {
            this.setTranTypeEnabled(true);
            this.setTranTypeSelected(true);
            this.setTranTypeUnionEnable(true);
        }
    }

    public void clear() {
        super.clear();
        this.setDefaultParams();
    }

    private void setDefaultParams() {
        this.bizStorageOrgUnit.setValue(null);
        this.kdDateFrom.setValue(this.stDate);
        this.kdDateTo.setValue(this.enDate);
        this.bizMaterialFrom.setValue(null);
        this.bizMaterialTo.setValue(null);
        this.bizMaterialTypeFrom.setValue(null);
        this.promptAssistProptyStart.setValue(null);
        this.promptAssistPropertyEnd.setValue(null);
        this.chkLot.setEnabled(true);
        this.chkLot.setSelected(false);
        this.promptLotStart.setText(null);
        this.promptLotStart.setEnabled(false);
        this.propmptLotEnd.setText(null);
        this.propmptLotEnd.setEnabled(false);
        this.promptWarehouseEnd.setValue(null);
        this.promptWarehouseStart.setValue(null);
        this.chkTotal.setSelected(true);
        this.onlyQty.setSelected(true);
        this.kdRadioQtyAndAmount.setSelected(false);
        this.kdTextTypeNoStart.setText(null);
        this.kdTextTypeNoEnd.setText(null);
        this.setTranTypeEnabled(false);
        this.setTranTypeSelected(false);
        this.setTranTypeUnionEnable(false);
        this.setTranTypeUnionSelect(false);
    }

    private void setTranTypeEnabled(boolean value) {
        this.chkCostAdjustIn.setEnabled(value);
        this.chkCostAdjustOut.setEnabled(value);
        this.chkCostOut.setEnabled(value);
        this.chkCostIn.setEnabled(value);
        this.chkExcepIn.setEnabled(value);
        this.chkExcepOut.setEnabled(value);
        this.chkMoveIn.setEnabled(value);
        this.chkMoveOut.setEnabled(value);
        this.chkProductIn.setEnabled(value);
        this.chkPurIn.setEnabled(value);
        this.chkPurOut.setEnabled(value);
        this.chkSaleBack.setEnabled(value);
        this.chksaleOut.setEnabled(value);
        this.chkTakeback.setEnabled(value);
        this.chkTakeout.setEnabled(value);
        this.productOut.setEnabled(value);
    }

    private void setTranTypeSelected(boolean value) {
        this.chkCostAdjustIn.setSelected(value);
        this.chkCostAdjustOut.setSelected(value);
        this.chkCostOut.setSelected(value);
        this.chkCostIn.setSelected(value);
        this.chkExcepIn.setSelected(value);
        this.chkExcepOut.setSelected(value);
        this.chkMoveIn.setSelected(value);
        this.chkMoveOut.setSelected(value);
        this.chkPurIn.setSelected(value);
        this.chkPurOut.setSelected(value);
        this.chkSaleBack.setSelected(value);
        this.chksaleOut.setSelected(value);
        this.chkTakeback.setSelected(value);
        this.chkTakeout.setSelected(value);
        this.chkProductIn.setSelected(value);
        this.productOut.setSelected(value);
    }

    @Override
    protected void chkProductInUnion_actionPerformed(ActionEvent e) throws Exception {
        if (this.chkProductInUnion.isSelected()) {
            this.chkProductIn.setEnabled(false);
            this.chkProductIn.setSelected(true);
            this.productOut.setEnabled(false);
            this.productOut.setSelected(true);
        } else {
            this.chkProductIn.setEnabled(true);
            this.productOut.setEnabled(true);
        }
    }

    @Override
    protected void chkPurInUnion_actionPerformed(ActionEvent e) throws Exception {
        if (this.chkPurInUnion.isSelected()) {
            this.chkPurIn.setEnabled(false);
            this.chkPurIn.setSelected(true);
            this.chkPurOut.setEnabled(false);
            this.chkPurOut.setSelected(true);
        } else {
            this.chkPurIn.setEnabled(true);
            this.chkPurOut.setEnabled(true);
        }
    }

    @Override
    protected void chkSaleoutUnion_actionPerformed(ActionEvent e) throws Exception {
        if (this.chkSaleoutUnion.isSelected()) {
            this.chksaleOut.setEnabled(false);
            this.chksaleOut.setSelected(true);
            this.chkSaleBack.setEnabled(false);
            this.chkSaleBack.setSelected(true);
        } else {
            this.chksaleOut.setEnabled(true);
            this.chkSaleBack.setEnabled(true);
        }
    }

    @Override
    protected void chkTakeoutUnion_actionPerformed(ActionEvent e) throws Exception {
        if (this.chkTakeoutUnion.isSelected()) {
            this.chkTakeout.setEnabled(false);
            this.chkTakeout.setSelected(true);
            this.chkTakeback.setEnabled(false);
            this.chkTakeback.setSelected(true);
        } else {
            this.chkTakeout.setEnabled(true);
            this.chkTakeback.setEnabled(true);
        }
    }

    private void setTranTypeUnionEnable(boolean value) {
        this.chkPurInUnion.setEnabled(value);
        this.chkProductInUnion.setEnabled(value);
        this.chkSaleoutUnion.setEnabled(value);
        this.chkTakeoutUnion.setEnabled(value);
    }

    private void setTranTypeUnionSelect(boolean value) {
        this.chkPurInUnion.setSelected(value);
        this.chkProductInUnion.setSelected(value);
        this.chkSaleoutUnion.setSelected(value);
        this.chkTakeoutUnion.setSelected(value);
    }

    private boolean isSelectTranType() {
        KDCheckBox[] chkBoxs = new KDCheckBox[]{this.chkTotal, this.chkCostAdjustIn, this.chkCostAdjustOut, this.chkCostOut, this.chkCostIn, this.chkExcepIn, this.chkExcepOut, this.chkMoveIn, this.chkMoveOut, this.chkProductIn, this.chkPurIn, this.chkPurOut, this.chkSaleBack, this.chksaleOut, this.chkTakeback, this.chkTakeout, this.productOut, this.chkPurInUnion, this.chkProductInUnion, this.chkSaleoutUnion, this.chkTakeoutUnion};
        boolean isSelected = false;
        for (int i = 0; i < chkBoxs.length; ++i) {
            if (!chkBoxs[i].isSelected()) continue;
            isSelected = true;
            break;
        }
        return isSelected;
    }
}

