/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.rpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.IParser;
import com.kingdee.bos.ctrl.kdf.headfootdesigner.HeadFootModel;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTMenuManager;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDPopupMenu;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.master.cssp.MainDataParser;
import com.kingdee.eas.basedata.master.material.IMaterial;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialGroupInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.client.F7MaterialMultiUI;
import com.kingdee.eas.basedata.master.material.client.F7MaterialMultiUISelectorAdaptor;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.basedata.org.IStorageOrgUnit;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.SCMRptMultiOrgsF7;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.report.IVirtualRptBaseFacade;
import com.kingdee.eas.framework.report.SimpleCompanyUserObject;
import com.kingdee.eas.framework.report.util.DefaultKDTableInsertHandler;
import com.kingdee.eas.framework.report.util.KDTableInsertHandler;
import com.kingdee.eas.framework.report.util.KDTableUtil;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.framework.report.util.RptTableHeader;
import com.kingdee.eas.scm.common.client.MaterialQueryListUI;
import com.kingdee.eas.scm.common.constants.QueryInfoConstants;
import com.kingdee.eas.scm.common.util.SortUtil;
import com.kingdee.eas.scm.im.rpt.InventoryGeneralRptFacadeFactory;
import com.kingdee.eas.scm.im.rpt.client.AbstractInventoryGeneralRptUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.UuidException;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Vector;
import org.apache.log4j.Logger;

public class InventoryGeneralRptUI
extends AbstractInventoryGeneralRptUI {
    private static final Logger logger = CoreUIObject.getLogger(InventoryGeneralRptUI.class);
    private IUIWindow materialWindow = null;
    protected HashMap hmQueryCon = null;
    private MaterialInfo[] currentMaterial = null;
    private StorageOrgUnitInfo currentStorageOrg = null;
    private SCMRptMultiOrgsF7 f7;
    private Object[] fullStorageOrgUnit;
    private boolean firstLoad = true;
    private static final String permItem = "im_inventorygeneralrpt_view";
    private static final String resClassName = "com.kingdee.eas.scm.im.rpt.IMRptResource";
    private boolean firstLoadData = true;

    public InventoryGeneralRptUI() throws Exception {
        this.tbl.setEditable(false);
        this.tbl.getActionMap().remove("Delete");
        this.tbl.checkParsed();
        this.tbl.getDataRequestManager().addDataRequestListener((KDTDataRequestListener)this);
        this.tbl.getDataRequestManager().setDataRequestMode(1);
        this.enableExportExcel(this.tbl);
        this.getTable().getDataRequestManager().setExportMemoryCallback(true);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        try {
            this.setCurrentMaterial();
            this.params = new RptParams();
            this.initRpt();
            this.materialBizPromptBox.setLabelVisible(false);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    public HashMap getHmQueryCon() {
        return this.hmQueryCon;
    }

    public void setHmQueryCon(HashMap hmQueryCon) {
        this.hmQueryCon = hmQueryCon;
        this.setCurrentStorageOrg();
        this.setCurrentMaterial();
    }

    public void initRpt() throws Exception {
        this.btnQuery.setVisible(false);
        this.menuItemQuery.setVisible(false);
        this.btnViewDetail.setIcon(EASResource.getIcon((String)"imgTbtn_bill"));
        this.btnQuery.setIcon(EASResource.getIcon((String)"imgTbtn_filter"));
        this.btnRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.materialBizPromptBox.setCommitParser((IParser)new MainDataParser(this.materialBizPromptBox));
        F7MaterialMultiUISelectorAdaptor selectorLisenterMaterial = null;
        try {
            MaterialGroupInfo info = new MaterialGroupInfo();
            selectorLisenterMaterial = new F7MaterialMultiUISelectorAdaptor((KDPromptBox)this.materialBizPromptBox, (Component)new F7MaterialMultiUI(), (Object)this, info.getBOSType().toString(), QueryInfoConstants.getMaterialQueryInfo((OrgType)OrgType.Storage), "materialGroup.id", "StorageOrgUnit.id", true);
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
        selectorLisenterMaterial.setIsMultiSelect(false);
        selectorLisenterMaterial.setQueryProperty("helpCode", "or");
        this.materialBizPromptBox.setSelector(selectorLisenterMaterial);
        this.materialBizPromptBox.addSelectorListener(selectorLisenterMaterial);
        this.materialBizPromptBox.setQueryInfo(QueryInfoConstants.getMaterialNoGroupQueryInfo((OrgType)OrgType.Storage));
        selectorLisenterMaterial.setIsMultiSelect(true);
        this.materialBizPromptBox.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                InventoryGeneralRptUI.this.changeRpt();
            }
        });
        this.f7 = new SCMRptMultiOrgsF7(this.bizStorageOrg, OrgType.Storage, permItem, EASResource.getString((String)resClassName, (String)"storageOrgUnitMutilF7"));
        this.f7.setNeedWait4UIOpen(false);
        this.setDefaultStorageOrg();
        this.tbl.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                try {
                    InventoryGeneralRptUI.this.tbl_tableClicked(e);
                }
                catch (Exception exc) {
                    InventoryGeneralRptUI.this.handUIException(exc);
                }
            }
        });
        this.firstLoad = false;
    }

    public String[] getMergeColumnKeys() {
        String[] strMergeColKeys = new String[]{"FOrgUnitName"};
        return null;
    }

    protected boolean showQueryDialog(boolean useDefaultSolution) {
        return true;
    }

    public String getUITitle() {
        return EASResource.getString((String)resClassName, (String)"inventoryGeneralRpt");
    }

    protected void query() {
        this.firstLoadData = true;
        if (this.bizStorageOrg.getValue() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.scm.im.rpt.IMRptResource.storageOrgUnitNotNull"));
            SysUtil.abort();
        }
        if (this.currentMaterial != null && this.bizStorageOrg.getValue() != null) {
            this.fullStorageOrgUnit = (Object[])this.f7.getFullData();
        }
        this.tbl.removeColumns();
        this.tbl.removeRows();
        super.query();
    }

    public void changeRpt() {
        if (this.materialBizPromptBox.getValue() instanceof MaterialInfo[]) {
            this.currentMaterial = (MaterialInfo[])this.materialBizPromptBox.getValue();
        } else if (this.materialBizPromptBox.getValue() instanceof Object[]) {
            Object[] objects = (Object[])this.materialBizPromptBox.getValue();
            this.currentMaterial = new MaterialInfo[objects.length];
            for (int i = 0; i < objects.length; ++i) {
                this.currentMaterial[i] = (MaterialInfo)objects[i];
            }
        }
        this.query();
    }

    @Override
    protected void bizStorageOrg_dataChanged(DataChangeEvent e) throws Exception {
        if (this.bizStorageOrg.getValue() != null) {
            OrgUnitCollection orgUnitCollection = new OrgUnitCollection();
            Object[] fullStorageOrgUnit = (Object[])this.bizStorageOrg.getValue();
            for (int i = 0; i < fullStorageOrgUnit.length; ++i) {
                if (fullStorageOrgUnit[i] == null) continue;
                orgUnitCollection.add((OrgUnitInfo)fullStorageOrgUnit[i]);
            }
            this.materialBizPromptBox.setMainBizOrgs(orgUnitCollection, OrgType.Storage);
            if (!this.firstLoad) {
                this.query();
            }
        }
    }

    protected String getUIFullName() {
        return "com.kingdee.eas.scm.im.rpt.client.InventoryGeneralRptUI";
    }

    public boolean isAsynchronism() {
        return this.getUIContext() == null || this.getUIContext().get("isAsynchronism") == null || !"isAsynchronism".equals(this.getUIContext().get("isAsynchronism"));
    }

    public void getData(KDTDataRequestEvent e) {
        this.tbl.getDataRequestManager().removeDataRequestListener((KDTDataRequestListener)this);
        try {
            int from = e.getFirstRow();
            int len = e.getLastRow() - from + 1;
            RptParams para = new RptParams();
            if (from == 0 && this.firstLoadData) {
                try {
                    this.firstLoadData = false;
                    para.clear();
                    para.putAll(this.params.toMap());
                    para.setObject("material", (Object)this.currentMaterial);
                    para.setObject("storageOrgSet", (Object)this.fullStorageOrgUnit);
                    para.setInt("queryType", this.kDComboBox1.getSelectedIndex());
                    para.setString("tempTable", this.getTempTable());
                    RptParams rpt = InventoryGeneralRptFacadeFactory.getRemoteInstance().createTempTable(para);
                    this.tbl.setRowCount(rpt.getInt("totalCount"));
                    this.setTempTable(rpt.getString("tempTable"));
                    RptTableHeader header = (RptTableHeader)rpt.getObject("header");
                    KDTableUtil.setHeader((RptTableHeader)header, (KDTable)this.tbl);
                    this.initUserConfig();
                    this.tbl.setRowCount(rpt.getInt("totalCount"));
                    para.setString("tempTable", this.getTempTable());
                    rpt = InventoryGeneralRptFacadeFactory.getRemoteInstance().query(para, from, len);
                    RptRowSet rs = (RptRowSet)rpt.getObject("rowset");
                    this.insertRows(rs, from, this.tbl, true, (KDTableInsertHandler)new DefaultKDTableInsertHandler(rs), 0);
                    this.tbl.getDataRequestManager().addDataRequestListener((KDTDataRequestListener)this);
                }
                catch (Exception ex) {
                    logger.error((Object)ex);
                    this.handUIExceptionAndAbort(ex);
                }
            } else {
                para.setString("tempTable", this.getTempTable());
                RptParams rpt = InventoryGeneralRptFacadeFactory.getRemoteInstance().query(para, from, len);
                RptRowSet rs = (RptRowSet)rpt.getObject("rowset");
                this.insertRows(rs, from, this.tbl, true, (KDTableInsertHandler)new DefaultKDTableInsertHandler(rs), this.insertRowCount);
                this.tbl.getDataRequestManager().addDataRequestListener((KDTDataRequestListener)this);
            }
        }
        catch (Exception ee) {
            logger.error((Object)ee);
            this.handUIException(ee);
        }
    }

    private void setCurrentMaterial() {
        HashMap hm = this.getHmQueryCon();
        if (hm != null) {
            Object m = hm.get("MATERIAL");
            if (m instanceof MaterialInfo) {
                this.currentMaterial = new MaterialInfo[1];
                this.currentMaterial[0] = (MaterialInfo)m;
            } else if (m instanceof MaterialInfo[]) {
                this.currentMaterial = (MaterialInfo[])m;
            }
            this.materialBizPromptBox.setValue((Object)this.currentMaterial);
        }
    }

    private void setCurrentStorageOrg() {
        HashMap hm = this.getHmQueryCon();
        if (hm != null) {
            this.currentStorageOrg = (StorageOrgUnitInfo)hm.get("STORAGEORGUNIT");
            FullOrgUnitInfo[] OrgUnits = null;
            if (this.currentStorageOrg != null) {
                EntityViewInfo entityViewInfo = new EntityViewInfo();
                FilterInfo filterInfo = new FilterInfo();
                entityViewInfo.getSelector().add(new SelectorItemInfo("parent"));
                entityViewInfo.getSelector().add(new SelectorItemInfo("id"));
                entityViewInfo.getSelector().add(new SelectorItemInfo("name"));
                entityViewInfo.getSelector().add(new SelectorItemInfo("level"));
                entityViewInfo.getSelector().add(new SelectorItemInfo("longnumber"));
                entityViewInfo.getSelector().add(new SelectorItemInfo("number"));
                entityViewInfo.getSelector().add(new SelectorItemInfo("isleaf"));
                Object orgUnitInfo = null;
                try {
                    IFullOrgUnit iFullOrgUnit = FullOrgUnitFactory.getRemoteInstance();
                    filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)this.currentStorageOrg.getId().toString(), CompareType.EQUALS));
                    entityViewInfo.setFilter(filterInfo);
                    FullOrgUnitCollection coll = iFullOrgUnit.getFullOrgUnitCollection(entityViewInfo);
                    OrgUnits = new FullOrgUnitInfo[]{coll.get(0)};
                    OrgUnits[0].setLevel(1);
                    OrgUnits[0].setParent(null);
                }
                catch (BOSException e) {
                    logger.error((Object)e);
                }
                this.bizStorageOrg.setValue(OrgUnits);
            }
        }
    }

    private void setDefaultStorageOrg() {
        FullOrgUnitInfo[] orgUnits = this.getRootStorageOrgUnit();
        this.bizStorageOrg.setValue((Object)orgUnits);
    }

    public void insertRows(RptRowSet rs, int insertRowIndex, KDTable table, boolean refreshUI, KDTableInsertHandler handler, int insertRowCount) {
        table.setRefresh(false);
        IRow row = null;
        ICell cell = null;
        int rowIndex = insertRowIndex + insertRowCount;
        SimpleCompanyUserObject companyUserObject = null;
        for (int i = 0; i < rs.getRowCount(); ++i) {
            if (i != 0) {
                rs.moveTo(i - 1);
                rs.moveTo(i);
            } else {
                rs.moveTo(i);
            }
            row = this.isExpand ? table.addRow(rowIndex++) : table.setRow(rowIndex++);
            companyUserObject = new SimpleCompanyUserObject();
            if (rs.getString("FOrgUnitID") == null) {
                companyUserObject.setName(EASResource.getString((String)"com.kingdee.eas.scm.im.IMAutoGenerateResource", (String)"219_InventoryGeneralRptUI"));
                companyUserObject.setCompanyId(BOSUuid.create((String)"88888888").toString());
                companyUserObject.setBlockId(rs.getString("FStoreTypeID"));
            } else {
                companyUserObject.setCompanyId(rs.getString("FOrgUnitID"));
                companyUserObject.setBlockId(rs.getString("FStoreTypeID"));
                companyUserObject.setName(rs.getString("FOrgUnitName"));
            }
            companyUserObject.setNumber(rs.getString("FMaterialNum"));
            companyUserObject.setExpanded(false);
            int isleaf = rs.getInt("Fisleaf");
            if (isleaf == 1) {
                companyUserObject.setLeaf(true);
            } else {
                companyUserObject.setLeaf(false);
            }
            companyUserObject.setLevel(rs.getInt("Flevel"));
            handler.setTableRowData(row, rs.toRowArray());
            cell = row.getCell(this.getTreeCol());
            cell.setValue((Object)companyUserObject);
            cell.setUserObject((Object)companyUserObject);
        }
        if (refreshUI) {
            table.setRefresh(true);
        }
        if (rs.getRowCount() > 0) {
            table.reLayoutAndPaint();
        } else {
            table.repaint();
        }
        this.setCellTreeRenderer();
    }

    protected Object[] getAuthorizedStorageSet() {
        ObjectUuidPK userPK = new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId());
        Object[] storageOrgs = null;
        Vector<String> v = new Vector<String>();
        try {
            FullOrgUnitCollection coll = PermissionFactory.getRemoteInstance().getAuthorizedOrg((IObjectPK)userPK, OrgType.Storage, null, null);
            storageOrgs = coll.toArray();
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        if (storageOrgs == null) {
            return v.toArray();
        }
        int count = storageOrgs.length;
        if (count > 0) {
            OrgUnitInfo orgUnit = null;
            Object number = null;
            for (int i = 0; i < count; ++i) {
                orgUnit = (OrgUnitInfo)storageOrgs[i];
                if (orgUnit == null) continue;
                v.add(orgUnit.getId().toString());
            }
        }
        return v.toArray();
    }

    protected FullOrgUnitInfo[] getRootStorageOrgUnit() {
        ObjectUuidPK userPK = new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId());
        CtrlUnitInfo cuInfo = SysContext.getSysContext().getCurrentUserInfo().getCU();
        Object storageOrgs = null;
        LinkedHashSet<String> orgUnitSet = new LinkedHashSet<String>();
        FullOrgUnitInfo[] fullOrgUnits = null;
        try {
            FullOrgUnitInfo curOrgUnit;
            int i;
            FullOrgUnitCollection coll = PermissionFactory.getRemoteInstance().getAuthorizedOrg((IObjectPK)userPK, OrgType.Storage, null, permItem);
            IFullOrgUnit iFullOrgUnit = FullOrgUnitFactory.getRemoteInstance();
            EntityViewInfo entityViewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            int count = 0;
            ArrayList orgUnitIds = new ArrayList();
            ArrayList orgUnitParentIds = new ArrayList();
            String orgUnitParentId = "";
            FullOrgUnitInfo orgUnit = null;
            for (i = 0; i < coll.size(); ++i) {
                orgUnit = coll.get(i);
                orgUnitSet.add(orgUnit.getId().toString());
            }
            entityViewInfo.getSelector().add(new SelectorItemInfo("parent"));
            entityViewInfo.getSelector().add(new SelectorItemInfo("id"));
            entityViewInfo.getSelector().add(new SelectorItemInfo("name"));
            entityViewInfo.getSelector().add(new SelectorItemInfo("level"));
            entityViewInfo.getSelector().add(new SelectorItemInfo("longnumber"));
            entityViewInfo.getSelector().add(new SelectorItemInfo("number"));
            entityViewInfo.getSelector().add(new SelectorItemInfo("isStorageOrgUnit"));
            if (orgUnitSet.size() > 0) {
                filterInfo.getFilterItems().add(new FilterItemInfo("id", orgUnitSet, CompareType.INCLUDE));
                entityViewInfo.setFilter(filterInfo);
                coll = iFullOrgUnit.getFullOrgUnitCollection(entityViewInfo);
            }
            orgUnitSet.clear();
            count = coll.size();
            if (count > 0) {
                fullOrgUnits = new FullOrgUnitInfo[count];
                for (i = 0; i < coll.size(); ++i) {
                    fullOrgUnits[i] = orgUnit = coll.get(i);
                }
                fullOrgUnits = (FullOrgUnitInfo[])SortUtil.sortDataByNumber((DataBaseInfo[])fullOrgUnits, (boolean)true);
            }
            if ((curOrgUnit = (FullOrgUnitInfo)SysContext.getSysContext().getCurrentOrgUnit()).isIsStorageOrgUnit()) {
                orgUnitSet.add(curOrgUnit.getId().toString());
            } else if (fullOrgUnits != null && fullOrgUnits.length > 0) {
                orgUnitSet.add(fullOrgUnits[0].getId().toString());
            }
            if (orgUnitSet.size() > 0) {
                filterInfo.getFilterItems().add(new FilterItemInfo("id", orgUnitSet, CompareType.INCLUDE));
                entityViewInfo.setFilter(filterInfo);
                coll = iFullOrgUnit.getFullOrgUnitCollection(entityViewInfo);
            }
            fullOrgUnits = new FullOrgUnitInfo[coll.size()];
            for (int i2 = 0; i2 < coll.size(); ++i2) {
                orgUnit = coll.get(i2);
                orgUnit.setLevel(1);
                fullOrgUnits[i2] = orgUnit;
            }
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        return fullOrgUnits;
    }

    protected IVirtualRptBaseFacade getVirtualRemoteInstance() throws BOSException {
        return InventoryGeneralRptFacadeFactory.getRemoteInstance();
    }

    public RptParams findData(int rowIndex, SimpleCompanyUserObject companyUserObject) throws Exception {
        RptParams pp = new RptParams();
        IRow row = this.getTable().getRow(rowIndex);
        pp.setString("fparentid", companyUserObject.getCompanyId().toString());
        pp.setString("flevel", Integer.toString(companyUserObject.getLevel()));
        pp.setString("fstoretypeid", companyUserObject.getBlockId());
        pp.setString("FMaterialNum", companyUserObject.getNumber());
        pp.setString("tempTable", this.getTempTable());
        IVirtualRptBaseFacade report = this.getVirtualRemoteInstance();
        RptParams result = report.findData(pp, -1, -1, this.getTempTable(), (Object)companyUserObject);
        this.insertRowIndex += 100;
        return result;
    }

    public HashMap getSelectedKeyParams() {
        KDTSelectBlock selectBlock = this.tbl.getSelectManager().get();
        HashMap<String, Object> hm = new HashMap<String, Object>();
        if (selectBlock != null) {
            int rowIndex = selectBlock.getTop();
            IRow row = this.tbl.getRow(rowIndex);
            if (row == null) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
                SysUtil.abort();
            }
            ICell cell = row.getCell("FStorageOrgUnitID");
            ICell cell2 = row.getCell("FWarehouseID");
            ICell cell3 = row.getCell("FStoreTypeID");
            if (cell == null || cell2 == null) {
                MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_KeyField_Fail"));
                SysUtil.abort();
            }
            String storageOrgUnitID = (String)cell.getValue();
            IStorageOrgUnit iStorageOrgUnit = null;
            StorageOrgUnitInfo storageOrgUnitInfo = null;
            if (storageOrgUnitID != null) {
                try {
                    iStorageOrgUnit = StorageOrgUnitFactory.getRemoteInstance();
                    storageOrgUnitInfo = (StorageOrgUnitInfo)iStorageOrgUnit.getValue((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)storageOrgUnitID)));
                }
                catch (EASBizException e) {
                    logger.error((Object)e);
                }
                catch (BOSException e) {
                    logger.error((Object)e);
                }
                catch (UuidException e) {
                    logger.error((Object)e);
                }
                hm.put("STORAGEORGUNIT", storageOrgUnitInfo);
                hm.put("WAREHOUSE", cell2.getValue());
                hm.put("STORETYPE", cell3.getValue());
                ICell cellM = row.getCell("FMaterialID");
                if (cellM != null && cellM.getValue() != null) {
                    MaterialInfo material = new MaterialInfo();
                    material.setId(BOSUuid.read((String)cellM.getValue().toString()));
                    hm.put("MATERIAL", material);
                }
            }
        }
        return hm;
    }

    public String getTreeCol() {
        return "FOrgUnitName";
    }

    protected void initListener() {
        Object[] listeners = this.getTable().getListenerList().getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != KDTMouseListener.class) continue;
            this.getTable().removeKDTMouseListener((KDTMouseListener)listeners[i + 1]);
        }
        this.getTable().addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                if (e.getButton() == 3) {
                    KDTMenuManager tm = InventoryGeneralRptUI.this.getMenuManager(InventoryGeneralRptUI.this.getTable());
                    if (tm == null) {
                        return;
                    }
                    KDPopupMenu menu = tm.getMenu();
                    if (menu == null) {
                        menu = new KDPopupMenu();
                    }
                    menu.setUserObject((Object)e);
                    if (e.getButton() == 3 && e.getClickCount() == 1) {
                        menu.show(e.getOriginView(), e.getX(), e.getY());
                    }
                } else {
                    int row = e.getRowIndex();
                    int column = e.getColIndex();
                    if (e.getClickCount() == 1) {
                        InventoryGeneralRptUI.this.cellClicked(row, column, e.getX(), e.getY());
                    } else if (e.getClickCount() == 2) {
                        InventoryGeneralRptUI.this.tblDoubleClicked(row, column, e.getX(), e.getY());
                    }
                }
            }
        });
    }

    protected KDTable getTable() {
        return this.tbl;
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected KDTable getTableForPrintSetting() {
        return this.tbl;
    }

    @Override
    public void actionViewDetail_actionPerformed(ActionEvent e) throws Exception {
        StorageOrgUnitInfo storageOrgInfo;
        HashMap hm = this.getSelectedKeyParams();
        if (hm.get("STORAGEORGUNIT") == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.scm.im.rpt.IMRptResource.overSelectRange"));
            SysUtil.abort();
        } else if (this.kDComboBox1.getSelectedIndex() == 0 && !(storageOrgInfo = (StorageOrgUnitInfo)hm.get("STORAGEORGUNIT")).isIsLeaf()) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.scm.im.rpt.IMRptResource.entityStorageOrgMust"));
            SysUtil.abort();
        }
        if (hm.get("MATERIAL") == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.scm.im.rpt.IMRptResource.materialNotNull"));
            SysUtil.abort();
        }
        UIContext uiContext = new UIContext((Object)this);
        if (this.materialWindow == null) {
            this.materialWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.scm.common.client.MaterialQueryListUI", (Map)uiContext, null, OprtState.EDIT);
        }
        MaterialQueryListUI aMaterialQueryListUI = (MaterialQueryListUI)this.materialWindow.getUIObject();
        aMaterialQueryListUI.setHmQueryCon(this.getSelectedKeyParams());
        aMaterialQueryListUI.setSetAndBackButtonVisiable(false);
        aMaterialQueryListUI.setFromF12(false);
        aMaterialQueryListUI.executQuery();
        this.materialWindow.show();
    }

    protected void tbl_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getClickCount() == 2) {
            int colIndex = this.tbl.getColumnIndex("FOrgUnitName");
            if (this.tbl.getSelectManager().getActiveColumnIndex() != colIndex) {
                ActionEvent evt = new ActionEvent(this.btnViewDetail, 0, "Double Clicked");
                ItemAction actView = this.getActionFromActionEvent(evt);
                actView.actionPerformed(evt);
            }
        }
    }

    protected boolean isAllowLoadPrintSetting() {
        return false;
    }

    @Override
    protected void kDComboBox1_itemStateChanged(ItemEvent e) throws Exception {
        if (this.materialBizPromptBox.getValue() != null) {
            this.query();
        }
    }

    protected void preparePrintPageHeader(HeadFootModel header) {
        StyleAttributes sa = Styles.getDefaultSA();
        StringBuffer sb = new StringBuffer();
        sb.append(EASResource.getString((String)"com.kingdee.eas.scm.im.IMAutoGenerateResource", (String)"212_InOutStoreDetailReportUI")).append("&[materialNumber]");
        sb.append(EASResource.getString((String)"com.kingdee.eas.scm.im.IMAutoGenerateResource", (String)"220_InventoryGeneralRptUI")).append("&[model]");
        sb.append("&| &| ");
        header.addRow(sb.toString(), sa);
        sb = new StringBuffer();
        sb.append(EASResource.getString((String)"com.kingdee.eas.scm.im.IMAutoGenerateResource", (String)"221_InventoryGeneralRptUI")).append("&[baseUnit]");
        sb.append(EASResource.getString((String)"com.kingdee.eas.scm.im.IMAutoGenerateResource", (String)"222_InventoryGeneralRptUI")).append("&[assistUnit]");
        sb.append("&| &| ");
        header.addRow(sb.toString(), sa);
    }

    protected Map preparePrintVariantMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        MaterialInfo material = (MaterialInfo)this.materialBizPromptBox.getValue();
        String materialid = null;
        if (material != null) {
            materialid = material.getId().toString();
        }
        if (materialid != null) {
            try {
                IMaterial imaterial = MaterialFactory.getRemoteInstance();
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add("*");
                sic.add("baseUnit.*");
                sic.add("assistUnit.*");
                material = (MaterialInfo)imaterial.getValue((IObjectPK)new ObjectUuidPK(materialid), sic);
            }
            catch (EASBizException e) {
                logger.error((Object)e);
            }
            catch (BOSException e) {
                logger.error((Object)e);
            }
            map.put("materialName", material.getName());
            map.put("materialNumber", material.getNumber());
            map.put("model", material.getModel());
            map.put("baseUnit", material.getBaseUnit().getName());
            if (material.getAssistUnit() != null) {
                map.put("assistUnit", material.getAssistUnit().getName());
            }
        }
        return map;
    }

    protected String getPrintStr(String printStr, int len) {
        if (printStr == null) {
            printStr = "";
        }
        for (int i = printStr.length(); i < len; ++i) {
            printStr = printStr + "X";
        }
        return printStr;
    }

    public void actionPageSetup_actionPerformed(ActionEvent e) throws Exception {
        super.actionPageSetup_actionPerformed(e);
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    public void actionHelp_actionPerformed(ActionEvent e) throws Exception {
        super.actionHelp_actionPerformed(e);
    }

    public void actionAbout_actionPerformed(ActionEvent e) throws Exception {
        super.actionAbout_actionPerformed(e);
    }

    public void actionOnLoad_actionPerformed(ActionEvent e) throws Exception {
        super.actionOnLoad_actionPerformed(e);
    }

    public void actionSendMessage_actionPerformed(ActionEvent e) throws Exception {
        super.actionSendMessage_actionPerformed(e);
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.firstLoadData = true;
        if (this.materialBizPromptBox.getValue() == null) {
            return;
        }
        super.actionRefresh_actionPerformed(e);
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        this.firstLoadData = true;
        super.actionQuery_actionPerformed(e);
    }

    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrint_actionPerformed(e);
    }

    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrintPreview_actionPerformed(e);
    }
}

