/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.rpt.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.framework.util.EntityControlTypeUtil;
import com.kingdee.eas.basedata.master.material.IMaterialGroupStandard;
import com.kingdee.eas.basedata.master.material.MaterialGroupStandardCollection;
import com.kingdee.eas.basedata.master.material.MaterialGroupStandardFactory;
import com.kingdee.eas.basedata.master.material.MaterialGroupStandardInfo;
import com.kingdee.eas.basedata.master.material.MaterialGroupStandardTypeEnum;
import com.kingdee.eas.basedata.master.material.client.F7MaterialMultiUISelectorAdaptor;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.IStorageOrgUnit;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitCollection;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.NewOrgUnitFilterInfoProducer;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.mm.common.client.UIHelper;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.util.ReportQueryConditionHelper;
import com.kingdee.eas.scm.common.util.SCMUtil;
import com.kingdee.eas.scm.im.inv.client.InvClientUtils;
import com.kingdee.eas.scm.im.rpt.IMRptUtils;
import com.kingdee.eas.scm.im.rpt.client.AbstractInventoryTypeDetailReportConditionUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Date;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.event.ChangeEvent;
import org.apache.log4j.Logger;

public class InventoryTypeDetailReportConditionUI
extends AbstractInventoryTypeDetailReportConditionUI {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = CoreUIObject.getLogger(InventoryTypeDetailReportConditionUI.class);
    private static final String resClassName = "com.kingdee.eas.scm.im.rpt.IMRptResource";
    private static final String permItem_view = "invTypeDetail_view";
    public static final String CTX_ONLY_BASE_SRANDARD = "onlyBaseStandard";
    public static final String CTX_GROUP_STANDARD = "groupStandard";
    public static final String CTX_CU = "cu";
    private String groupStandardID;
    private CtrlUnitInfo curCtrlUnitInfo;
    private FocusListener txtLotLikeListener = null;
    private DataChangeListener warehouseListener = null;
    private static final String LotLike_TEXT = EASResource.getString((String)"com.kingdee.eas.scm.im.rpt.IMRptResource", (String)"LotLike_TEXT");
    private boolean isSwitchSolution = false;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void loadFields() {
        super.loadFields();
        try {
            this.setF7();
            this.addListener();
            this.curCtrlUnitInfo = (CtrlUnitInfo)this.getUIContext().get(CTX_CU);
            if (this.curCtrlUnitInfo == null) {
                this.curCtrlUnitInfo = SysContext.getSysContext().getCurrentCtrlUnit();
            }
            this.loadGroupStandard();
            Date ed = IMRptUtils.getDate(new Date());
            long tl = ed.getTime();
            Date bd = new Date(tl - 604800000L);
            this.kdDateFrom.setValue((Object)bd);
            this.kdDateTo.setValue((Object)ed);
            this.loadStatusEnum((JComboBox)this.cmbStatus);
        }
        catch (Exception e) {
            super.handUIException((Throwable)e);
        }
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.ckBxShowMShortName.setVisible(true);
        this.txtMShortNameFrom.setVisible(true);
        this.txtMShortNameTo.setVisible(true);
        this.ckBxShowMShortName.setSelected(false);
        this.txtMShortNameFrom.setEnabled(false);
        this.txtMShortNameTo.setEnabled(false);
        UIHelper.registerProjectF7ForFilter((KDBizPromptBox)this.bizStorageOrgUnit, (KDBizPromptBox)this.prmtProjectFrom);
        UIHelper.registerProjectF7ForFilter((KDBizPromptBox)this.bizStorageOrgUnit, (KDBizPromptBox)this.prmtProjectTo);
        UIHelper.registerTrackNumberF7ForFilter((KDBizPromptBox)this.bizStorageOrgUnit, (KDBizPromptBox)this.prmtTrackNumFrom);
        UIHelper.registerTrackNumberF7ForFilter((KDBizPromptBox)this.bizStorageOrgUnit, (KDBizPromptBox)this.prmtTrackNumTo);
        this.bizWarehouseFrom.setEnabledMultiSelection(true);
        SCMClientUtils.addListenerForMultiF7((KDBizPromptBox)this.bizWarehouseFrom, (KDBizPromptBox)this.bizWarehouseTo);
        this.bizLocationFrom.setEnabledMultiSelection(true);
        SCMClientUtils.addListenerForMultiF7((KDBizPromptBox)this.bizLocationFrom, (KDBizPromptBox)this.bizLocationTo);
        this.bizTransTypeFrom.setEnabledMultiSelection(true);
        SCMClientUtils.addListenerForMultiF7((KDBizPromptBox)this.bizTransTypeFrom, (KDBizPromptBox)this.bizTransTypeTo);
    }

    private void loadGroupStandard() throws Exception {
        MaterialGroupStandardInfo groupStandard = null;
        Boolean onlyBaseStandard = (Boolean)this.getUIContext().get(CTX_ONLY_BASE_SRANDARD);
        if (onlyBaseStandard != null && onlyBaseStandard.booleanValue()) {
            IMaterialGroupStandard iBiz = MaterialGroupStandardFactory.getRemoteInstance();
            MaterialGroupStandardCollection baseGroupStandardColl = iBiz.getBaseMaterialGroupStandardColl();
            if (baseGroupStandardColl.size() > 0) {
                groupStandard = baseGroupStandardColl.get(0);
            }
        } else {
            groupStandard = (MaterialGroupStandardInfo)this.getUIContext().get(CTX_GROUP_STANDARD);
        }
        if (groupStandard != null) {
            this.comboGroupStandard.removeAllItems();
            this.comboGroupStandard.addItem((Object)groupStandard);
            this.comboGroupStandard.setSelectedIndex(0);
            this.groupStandardID = groupStandard.getId().toString();
        } else {
            IMaterialGroupStandard iMaterialGroupStandard = MaterialGroupStandardFactory.getRemoteInstance();
            FilterInfo filterInfoCU = EntityControlTypeUtil.getFilterInfoForControlTypeS4((String)this.curCtrlUnitInfo.getId().toString(), (String)this.curCtrlUnitInfo.getLongNumber());
            EntityViewInfo viewInfo = new EntityViewInfo();
            viewInfo.setFilter(filterInfoCU);
            MaterialGroupStandardCollection groupStandardColl = iMaterialGroupStandard.getMaterialGroupStandardCollection(viewInfo);
            this.comboGroupStandard.removeAllItems();
            if (groupStandardColl != null) {
                this.comboGroupStandard.addItems(groupStandardColl.toArray());
            }
            int defaultIndex = 0;
            int size = groupStandardColl.size();
            for (int index = 0; index < size; ++index) {
                if (!groupStandardColl.get(index).getStandardType().equals((Object)MaterialGroupStandardTypeEnum.BasicStandard)) continue;
                defaultIndex = index;
                break;
            }
            this.comboGroupStandard.setSelectedIndex(defaultIndex);
            MaterialGroupStandardInfo groupStandardInfo = groupStandardColl.get(defaultIndex);
            this.groupStandardID = groupStandardInfo.getId().toString();
        }
    }

    private void addListener() {
        this.bizStorageOrgUnit.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                InventoryTypeDetailReportConditionUI.this.bizStorageOrgUnit_dataChanged(e);
            }
        });
        this.bizMaterialFrom.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                InventoryTypeDetailReportConditionUI.this.bizMaterial_willShow(e);
            }
        });
        this.bizMaterialTo.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                InventoryTypeDetailReportConditionUI.this.bizMaterial_willShow(e);
            }
        });
        this.bizWarehouseFrom.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                InventoryTypeDetailReportConditionUI.this.bizWarehouseFrom_willShow(e);
            }
        });
        this.bizWarehouseTo.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                InventoryTypeDetailReportConditionUI.this.bizWarehouseTo_willShow(e);
            }
        });
        this.comboGroupStandard.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                InventoryTypeDetailReportConditionUI.this.comboGroupStandard_itemStateChanged(e);
            }
        });
        this.ckBxShowMShortName.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                try {
                    InventoryTypeDetailReportConditionUI.this.ckBxShowMShortName_itemStateChanged(e);
                }
                catch (Exception exc) {
                    InventoryTypeDetailReportConditionUI.this.handUIException(exc);
                }
            }
        });
        this.txtLotLikeListener = new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                if (InventoryTypeDetailReportConditionUI.this.txtLotLike.getText().trim().length() > 0 && LotLike_TEXT.equals(InventoryTypeDetailReportConditionUI.this.txtLotLike.getText())) {
                    InventoryTypeDetailReportConditionUI.this.txtLotLike.setText(null);
                    InventoryTypeDetailReportConditionUI.this.txtLotLike.setCustomForegroundColor(Color.BLACK);
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (InventoryTypeDetailReportConditionUI.this.txtLotLike.getText().trim().length() <= 0) {
                    InventoryTypeDetailReportConditionUI.this.txtLotLike.setText(LotLike_TEXT);
                    InventoryTypeDetailReportConditionUI.this.txtLotLike.setCustomForegroundColor(Color.GRAY);
                }
            }
        };
        this.txtLotLike.addFocusListener(this.txtLotLikeListener);
        if (this.warehouseListener == null) {
            this.warehouseListener = new DataChangeListener(){

                public void dataChanged(DataChangeEvent eventObj) {
                    try {
                        InventoryTypeDetailReportConditionUI.this.wareHouse_dataChanged(eventObj);
                    }
                    catch (Exception exc) {
                        InventoryTypeDetailReportConditionUI.this.handUIException(exc);
                    }
                }
            };
        }
        this.bizWarehouseFrom.addDataChangeListener(this.warehouseListener);
        this.bizWarehouseTo.addDataChangeListener(this.warehouseListener);
    }

    private void wareHouse_dataChanged(DataChangeEvent e) {
        KDBizPromptBox prmtWarehouse = (KDBizPromptBox)e.getSource();
        Object value = prmtWarehouse.getValue();
        if (value == null || StringUtils.isEmpty((String)value.toString())) {
            return;
        }
        FilterInfo filterInfo = new FilterInfo();
        String[] numArray = SCMUtil.getF7Numbers((Object)value, (Boolean)false, (String)",");
        if (numArray[0] != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("Warehouse.number", (Object)numArray[0]));
        } else if (numArray[1] != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("Warehouse.number", (Object)numArray[1], CompareType.INCLUDE));
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filterInfo);
        if ("bizWarehouseFrom".equals(prmtWarehouse.getName())) {
            this.bizLocationFrom.setEntityViewInfo(viewInfo);
        } else {
            this.bizLocationTo.setEntityViewInfo(viewInfo);
        }
    }

    protected void ckBxShowMShortName_itemStateChanged(ItemEvent e) throws Exception {
        boolean isSelected = this.ckBxShowMShortName.isSelected();
        if (!this.isSwitchSolution) {
            this.txtMShortNameFrom.setText(null);
            this.txtMShortNameTo.setText(null);
        }
        if (isSelected) {
            this.txtMShortNameFrom.setEnabled(true);
            this.txtMShortNameTo.setEnabled(true);
        } else {
            this.txtMShortNameFrom.setEnabled(false);
            this.txtMShortNameTo.setEnabled(false);
        }
    }

    private void comboGroupStandard_itemStateChanged(ItemEvent e) {
        Object o = e.getItem();
        MaterialGroupStandardInfo groupInfo = null;
        if (o != null && o instanceof MaterialGroupStandardInfo) {
            groupInfo = (MaterialGroupStandardInfo)o;
        }
        if (!(this.isSwitchSolution || this.bizMaterialTypeFrom.getValue() == null && this.bizMaterialTypeTo.getValue() == null)) {
            this.bizMaterialTypeFrom.setValue(null);
            this.bizMaterialTypeTo.setValue(null);
        }
        if (null != groupInfo) {
            IMRptUtils.setBizMaterialGroup(this.bizMaterialTypeFrom, groupInfo.getId().toString());
            IMRptUtils.setBizMaterialGroup(this.bizMaterialTypeTo, groupInfo.getId().toString());
        }
    }

    protected void bizStorageOrgUnit_dataChanged(DataChangeEvent e) {
        if (this.bizStorageOrgUnit.getValue() != null) {
            StorageOrgUnitInfo storageOrg = (StorageOrgUnitInfo)this.bizStorageOrgUnit.getValue();
            IMRptUtils.setRptWarehouseFilter(new Object[]{storageOrg.getId().toString()}, this.bizWarehouseFrom);
            IMRptUtils.setRptWarehouseFilter(new Object[]{storageOrg.getId().toString()}, this.bizWarehouseTo);
            InvClientUtils.getMaterialF7ByStorageOrgUnit(this.bizMaterialFrom, new Object[]{storageOrg.getId().toString()}, (Object)this);
            InvClientUtils.getMaterialF7ByStorageOrgUnit(this.bizMaterialTo, new Object[]{storageOrg.getId().toString()}, (Object)this);
        }
    }

    protected void bizMaterial_willShow(SelectorEvent e) {
        this.storageOrgUnitCheck();
    }

    protected void bizWarehouseFrom_willShow(SelectorEvent e) {
        this.storageOrgUnitCheck();
    }

    protected void bizWarehouseTo_willShow(SelectorEvent e) {
        this.storageOrgUnitCheck();
    }

    protected void storageOrgUnitCheck() {
        if (this.bizStorageOrgUnit.getValue() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"storageOrgUnitNotNull"));
            SysUtil.abort();
        }
    }

    private void setF7() throws Exception {
        this.bizInvTypeFrom.setEnabledMultiSelection(true);
        InvClientUtils.getMaterialF7ForReportFilterUI(this.bizMaterialFrom, (Object)this);
        InvClientUtils.getMaterialF7ForReportFilterUI(this.bizMaterialTo, (Object)this);
        this.bizMaterialFrom.setEnabledMultiSelection(true);
        F7MaterialMultiUISelectorAdaptor materialSelector = (F7MaterialMultiUISelectorAdaptor)this.bizMaterialFrom.getSelector();
        materialSelector.setIsMultiSelect(true);
        SCMClientUtils.addListenerForMultiF7((KDBizPromptBox)this.bizMaterialFrom, (KDBizPromptBox)this.bizMaterialTo);
        SCMClientUtils.setMainBizOrgF7((KDBizPromptBox)this.bizStorageOrgUnit, (OrgType)OrgType.Storage, (String)permItem_view);
    }

    @Override
    protected void bizStorageOrgUnit_stateChanged(ChangeEvent e) throws Exception {
        super.bizStorageOrgUnit_stateChanged(e);
    }

    @Override
    protected void cmbStatus_itemStateChanged(ItemEvent e) throws Exception {
        super.cmbStatus_itemStateChanged(e);
    }

    public void onInit(RptParams initParams) throws Exception {
    }

    public RptParams getCustomCondition() {
        RptParams para = new RptParams();
        para.setObject("storageOrgUnit", this.bizStorageOrgUnit.getValue());
        para.setObject("dateFrom", this.kdDateFrom.getValue());
        para.setObject("dateTo", this.kdDateTo.getValue());
        para.setObject("billNoFrom", (Object)this.txtBillNoFrom.getText());
        para.setObject("billNoTo", (Object)this.txtBillNoTo.getText());
        para.setObject("transTypeFrom", this.bizTransTypeFrom.getValue());
        para.setObject("transTypeTo", this.bizTransTypeTo.getValue());
        para.setObject("materialFrom", this.bizMaterialFrom.getValue());
        para.setObject("materialTo", this.bizMaterialTo.getValue());
        para.setObject("materialGroupStandard", this.comboGroupStandard.getSelectedItem());
        para.setObject("materialTypeFrom", this.bizMaterialTypeFrom.getValue());
        para.setObject("materialTypeTo", this.bizMaterialTypeTo.getValue());
        para.setObject("warehouseFrom", this.bizWarehouseFrom.getValue());
        para.setObject("warehouseTo", this.bizWarehouseTo.getValue());
        para.setObject("locationFrom", this.bizLocationFrom.getValue());
        para.setObject("locationTo", this.bizLocationTo.getValue());
        para.setObject("assiAsstPropFrom", this.bizAsstAttrFrom.getValue());
        para.setObject("assiAsstPropTo", this.bizAsstAttrTo.getValue());
        para.setObject("txtLotFrom", (Object)this.txtLotFrom.getText());
        para.setObject("txtLotTo", (Object)this.txtLotTo.getText());
        if (!LotLike_TEXT.equals(this.txtLotLike.getText())) {
            para.setObject("txtLotLike", (Object)this.txtLotLike.getText());
        }
        para.setBoolean("ckShowBeginEnd", this.ckShowBeginEnd.isSelected());
        int coBoxBillStatus = ((BillBaseStatusEnum)this.cmbStatus.getSelectedItem()).getValue();
        para.setBoolean("ckShowNoData", this.ckShowNoData.isSelected());
        para.setInt("coBoxBillStatus", coBoxBillStatus);
        para.setObject("ckBxShowMShortName", (Object)this.ckBxShowMShortName.isSelected());
        para.setObject("shortNameFrom", (Object)this.txtMShortNameFrom.getText());
        para.setObject("shortNameTo", (Object)this.txtMShortNameTo.getText());
        para.setObject("invTypeFrom", this.bizInvTypeFrom.getValue());
        para.setBoolean("checkedWarehouse", this.KDWareHouseCheckBox.isSelected());
        para.setBoolean("checkedMaterial", this.KDMaterialCheckBox.isSelected());
        para.setObject("projectFrom", (Object)this.prmtProjectFrom.getText());
        para.setObject("projectTo", (Object)this.prmtProjectTo.getText());
        para.setObject("trackNumFrom", (Object)this.prmtTrackNumFrom.getText());
        para.setObject("trackNumTo", (Object)this.prmtTrackNumTo.getText());
        para.setObject("ckBxShowUpdateInventoryBill", (Object)this.ckBxShowUpdateInventoryBill.isSelected());
        return para;
    }

    public void setCustomCondition(RptParams params) {
        this.bizStorageOrgUnit.setValue(params.getObject("storageOrgUnit"));
        this.kdDateFrom.setValue(params.getObject("dateFrom"));
        this.kdDateTo.setValue(params.getObject("dateTo"));
        this.txtBillNoFrom.setText((String)params.getObject("billNoFrom"));
        this.txtBillNoTo.setText((String)params.getObject("billNoTo"));
        this.bizTransTypeFrom.setValue(params.getObject("transTypeFrom"));
        this.bizTransTypeTo.setValue(params.getObject("transTypeTo"));
        this.bizMaterialFrom.setValue(params.getObject("materialFrom"));
        this.bizMaterialTo.setValue(params.getObject("materialTo"));
        this.comboGroupStandard.setSelectedItem(params.getObject("materialGroupStandard"));
        this.bizMaterialTypeFrom.setValue(params.getObject("materialTypeFrom"));
        this.bizMaterialTypeTo.setValue(params.getObject("materialTypeTo"));
        this.bizWarehouseFrom.setValue(params.getObject("warehouseFrom"));
        this.bizWarehouseTo.setValue(params.getObject("warehouseTo"));
        this.bizLocationFrom.setValue(params.getObject("locationFrom"));
        this.bizLocationTo.setValue(params.getObject("locationTo"));
        this.bizAsstAttrFrom.setValue(params.getObject("assiAsstPropFrom"));
        this.bizAsstAttrTo.setValue(params.getObject("assiAsstPropTo"));
        this.txtLotFrom.setText((String)params.getObject("txtLotFrom"));
        this.txtLotTo.setText((String)params.getObject("txtLotTo"));
        this.txtLotLike.setText((String)params.getObject("txtLotLike"));
        this.ckShowBeginEnd.setSelected(params.getBoolean("ckShowBeginEnd"));
        this.ckShowNoData.setSelected(params.getBoolean("ckShowNoData"));
        this.cmbStatus.setSelectedIndex(params.getInt("coBoxBillStatus"));
        if ((Boolean)params.getObject("ckBxShowMShortName") != null) {
            this.ckBxShowMShortName.setSelected(((Boolean)params.getObject("ckBxShowMShortName")).booleanValue());
        } else {
            this.ckBxShowMShortName.setSelected(false);
        }
        this.txtMShortNameFrom.setText((String)params.getObject("shortNameFrom"));
        this.txtMShortNameTo.setText((String)params.getObject("shortNameTo"));
        this.bizInvTypeFrom.setValue(params.getObject("invTypeFrom"));
        this.KDWareHouseCheckBox.setSelected(params.getBoolean("checkedWarehouse"));
        this.KDMaterialCheckBox.setSelected(params.getBoolean("checkedMaterial"));
        this.prmtProjectFrom.setValue(params.getObject("projectNumFrom"));
        this.prmtProjectTo.setValue(params.getObject("projectNumTo"));
        this.prmtTrackNumFrom.setValue(params.getObject("trackNumFrom"));
        this.prmtTrackNumTo.setValue(params.getObject("trackNumTo"));
    }

    private void loadStatusEnum(JComboBox cb) {
        DefaultComboBoxModel<BillBaseStatusEnum> model = new DefaultComboBoxModel<BillBaseStatusEnum>();
        model.addElement(BillBaseStatusEnum.NULL);
        model.addElement(BillBaseStatusEnum.SUBMITED);
        model.addElement(BillBaseStatusEnum.AUDITED);
        cb.setModel(model);
    }

    public boolean verify() {
        if (this.bizStorageOrgUnit.getValue() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"storageOrgUnitNotNull"));
            return false;
        }
        Date dateFrom = (Date)this.kdDateFrom.getValue();
        Date dateTo = (Date)this.kdDateTo.getValue();
        if (dateFrom == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"STARTDATE_NOT_NULL"));
            this.kdDateFrom.requestFocus();
            return false;
        }
        if (dateTo == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"END_DATE_NULL"));
            this.kdDateTo.requestFocus();
            return false;
        }
        if (dateTo.getTime() < dateFrom.getTime()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"END_BEFORE_START"));
            this.kdDateTo.requestFocus();
            return false;
        }
        return true;
    }

    public void clear() {
        super.clear();
        this.bizStorageOrgUnit.setValue((Object)this.getDefaultMainBizOrg());
        Date ed = IMRptUtils.getDate(new Date());
        long tl = ed.getTime();
        Date bd = new Date(tl - 604800000L);
        this.kdDateFrom.setValue((Object)bd);
        this.kdDateTo.setValue((Object)ed);
        this.txtBillNoFrom.setText("");
        this.txtBillNoTo.setText("");
        this.bizTransTypeFrom.setValue(null);
        this.bizTransTypeTo.setValue(null);
        this.bizMaterialFrom.setValue(null);
        this.bizMaterialTo.setValue(null);
        this.bizMaterialTypeFrom.setValue(null);
        this.bizMaterialTypeTo.setValue(null);
        this.bizWarehouseFrom.setValue(null);
        this.bizWarehouseTo.setValue(null);
        this.bizLocationFrom.setValue(null);
        this.bizLocationTo.setValue(null);
        this.bizAsstAttrFrom.setValue(null);
        this.bizAsstAttrTo.setValue(null);
        this.txtLotFrom.setText("");
        this.txtLotTo.setText("");
        this.txtLotLike.setText(LotLike_TEXT);
        this.txtLotLike.setCustomForegroundColor(Color.GRAY);
        this.ckShowBeginEnd.setSelected(false);
        this.ckShowNoData.setSelected(false);
        this.ckBxShowUpdateInventoryBill.setSelected(false);
        this.ckBxShowMShortName.setSelected(false);
        this.txtMShortNameFrom.setText(null);
        this.txtMShortNameTo.setText(null);
        this.bizInvTypeFrom.setValue(null);
        this.KDWareHouseCheckBox.setSelected(false);
        this.KDMaterialCheckBox.setSelected(false);
        this.prmtProjectFrom.setValue(null);
        this.prmtProjectTo.setValue(null);
        this.prmtTrackNumFrom.setValue(null);
        this.prmtTrackNumTo.setValue(null);
        this.cmbStatus.setSelectedItem((Object)BillBaseStatusEnum.AUDITED);
        try {
            this.loadGroupStandard();
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    public void setCustomerParams(CustomerParams cp) {
        if (cp != null && cp.getCustomerParam("RPTPARAMS_KEY_AT_CUSTOMERPARAMS") != null) {
            return;
        }
        this.isSwitchSolution = true;
        this.clear();
        ReportQueryConditionHelper.fillComponent((Container)((Object)this), (CustomerParams)cp);
        if (LotLike_TEXT.equals(cp.getCustomerParam("txtLotLike"))) {
            this.txtLotLike.setText(LotLike_TEXT);
        } else {
            this.txtLotLike.setText(cp.getCustomerParam("txtLotLike"));
        }
        this.initComponentValue();
        this.isSwitchSolution = false;
    }

    private void initComponentValue() {
        KDBizPromptBox[] f7 = new KDBizPromptBox[]{this.bizTransTypeTo};
        Object obj = null;
        int len = f7.length;
        for (int i = 0; i < len; ++i) {
            if (!(f7[i].getValue() instanceof Object[])) continue;
            obj = ((Object[])f7[i].getValue())[0];
            f7[i].setValue(obj);
        }
    }

    public CustomerParams getCustomerParams() {
        CustomerParams customerParams = new CustomerParams();
        ReportQueryConditionHelper.fillCustomerParams((CustomerParams)customerParams, (Container)((Object)this));
        return customerParams;
    }

    public OrgUnitInfo getDefaultMainBizOrg() {
        StorageOrgUnitInfo orgUnitInfo = null;
        try {
            NewOrgUnitFilterInfoProducer iProducer = new NewOrgUnitFilterInfoProducer(OrgType.Storage, permItem_view);
            FilterInfo info = iProducer.getFilterInfo();
            EntityViewInfo storageOrgUnitView = new EntityViewInfo();
            storageOrgUnitView.setFilter(info);
            SelectorItemCollection sic = new SelectorItemCollection();
            SorterItemCollection sort = new SorterItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("number"));
            sic.add(new SelectorItemInfo("name"));
            SorterItemInfo sorterItem = new SorterItemInfo("number");
            sorterItem.setSortType(SortType.ASCEND);
            sort.add(sorterItem);
            storageOrgUnitView.setSorter(sort);
            storageOrgUnitView.setSelector(sic);
            IStorageOrgUnit storageOrgUnit = StorageOrgUnitFactory.getRemoteInstance();
            StorageOrgUnitCollection col = storageOrgUnit.getStorageOrgUnitCollection(storageOrgUnitView);
            OrgUnitInfo currentMainOrg = SysContext.getSysContext().getCurrentOrgUnit(OrgType.Storage);
            if (currentMainOrg != null && col.size() > 0) {
                for (int i = 0; i < col.size(); ++i) {
                    if (!currentMainOrg.getId().toString().equals(col.get(i).getId().toString())) continue;
                    orgUnitInfo = currentMainOrg;
                    break;
                }
            }
            if (col.size() > 0 && orgUnitInfo == null) {
                orgUnitInfo = col.get(0);
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        return orgUnitInfo;
    }
}

