/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.rpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.headfootdesigner.HeadFootModel;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.report.ICommRptBase;
import com.kingdee.eas.framework.report.client.CommRptBaseConditionUI;
import com.kingdee.eas.framework.report.util.DefaultKDTableInsertHandler;
import com.kingdee.eas.framework.report.util.KDTableInsertHandler;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.scm.common.util.ReportQueryConditionHelper;
import com.kingdee.eas.scm.im.rpt.IMRptUtils;
import com.kingdee.eas.scm.im.rpt.MatStoreDateAnalyseRptFacadeFactory;
import com.kingdee.eas.scm.im.rpt.client.AbstractMatStoreDateAnalyseReportUI;
import com.kingdee.eas.scm.im.rpt.client.MatStoreDateAnalyseConditionUI;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.util.Map;
import org.apache.log4j.Logger;

public class MatStoreDateAnalyseReportUI
extends AbstractMatStoreDateAnalyseReportUI {
    private static final long serialVersionUID = -8874096320952769675L;
    private static final Logger logger = CoreUIObject.getLogger(MatStoreDateAnalyseReportUI.class);
    String[] qtyColumns = new String[]{"qty", "baseQty"};
    String[] priceColumns = new String[]{"price"};
    String[] amountColumns = new String[]{"amount"};
    String[] qtyDayColumns = new String[]{"storeDays"};
    Object[] allOrgs = null;
    int rowCount = 0;

    public MatStoreDateAnalyseReportUI() throws Exception {
        this.kDTable1.checkParsed();
        this.kDTable1.getDataRequestManager().setDataRequestMode(1);
        this.kDTable1.getDataRequestManager().addDataRequestListener((KDTDataRequestListener)this);
        this.enableExportExcel(this.kDTable1);
        this.actionQuery.setDaemonRun(true);
        this.actionRefresh.setDaemonRun(true);
        this.kDTable1.getDataRequestManager().setExportMemoryCallback(true);
    }

    private void setColumnDisplayFormat() {
        int index;
        int qIndex = this.qtyColumns.length;
        int priceIndex = this.priceColumns.length;
        int amountIndex = this.amountColumns.length;
        int qtyDayIndex = this.qtyDayColumns.length;
        int currencyPrecision = this.params.getInt("currencyPrecision");
        String formatString = null;
        IColumn selectCol = null;
        for (index = 0; index < qIndex; ++index) {
            selectCol = this.kDTable1.getColumn(this.qtyColumns[index]);
            formatString = "###,###.000000;-###,###.000000;;";
            selectCol.getStyleAttributes().setNumberFormat(formatString);
        }
        for (index = 0; index < priceIndex; ++index) {
            selectCol = this.kDTable1.getColumn(this.priceColumns[index]);
            formatString = "###,###.000000;-###,###.000000;;";
            selectCol.getStyleAttributes().setNumberFormat(formatString);
        }
        for (index = 0; index < qtyDayIndex; ++index) {
            selectCol = this.kDTable1.getColumn(this.qtyDayColumns[index]);
            formatString = "###,###.00;-###,###.00;0.00;";
            selectCol.getStyleAttributes().setNumberFormat(formatString);
        }
        StringBuffer strBuffer = new StringBuffer();
        for (int i = 0; i < currencyPrecision; ++i) {
            strBuffer.append("0");
        }
        for (int index2 = 0; index2 < amountIndex; ++index2) {
            selectCol = this.kDTable1.getColumn(this.amountColumns[index2]);
            formatString = "###,###." + strBuffer.toString() + ";-###,###." + strBuffer.toString() + ";;";
            selectCol.getStyleAttributes().setNumberFormat(formatString);
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void actionPageSetup_actionPerformed(ActionEvent e) throws Exception {
        super.actionPageSetup_actionPerformed(e);
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    public void actionHelp_actionPerformed(ActionEvent e) throws Exception {
        super.actionHelp_actionPerformed(e);
    }

    public void actionAbout_actionPerformed(ActionEvent e) throws Exception {
        super.actionAbout_actionPerformed(e);
    }

    public void actionOnLoad_actionPerformed(ActionEvent e) throws Exception {
        super.actionOnLoad_actionPerformed(e);
    }

    public void actionSendMessage_actionPerformed(ActionEvent e) throws Exception {
        super.actionSendMessage_actionPerformed(e);
    }

    public void actionCalculator_actionPerformed(ActionEvent e) throws Exception {
        super.actionCalculator_actionPerformed(e);
    }

    public void actionExport_actionPerformed(ActionEvent e) throws Exception {
        super.actionExport_actionPerformed(e);
    }

    public void actionExportSelected_actionPerformed(ActionEvent e) throws Exception {
        super.actionExportSelected_actionPerformed(e);
    }

    public void actionRegProduct_actionPerformed(ActionEvent e) throws Exception {
        super.actionRegProduct_actionPerformed(e);
    }

    public void actionPersonalSite_actionPerformed(ActionEvent e) throws Exception {
        super.actionPersonalSite_actionPerformed(e);
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        super.actionQuery_actionPerformed(e);
    }

    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        this.checkCanPrint();
        super.actionPrint_actionPerformed(e);
        IObjectPK pk = LogUtil.beginLog(null, (String)"1", (BOSObjectType)new BOSObjectType("157CCAE5"), null, (String)EASResource.getString((String)"com.kingdee.eas.scm.im.IMAutoGenerateResource", (String)"228_MatStoreDateAnalyseReportUI"), (String)"im_MatStoreDateAnalyseReport_print");
        LogUtil.afterLog(null, (IObjectPK)pk);
    }

    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        this.checkCanPrint();
        super.actionPrintPreview_actionPerformed(e);
        IObjectPK pk = LogUtil.beginLog(null, (String)"1", (BOSObjectType)new BOSObjectType("157CCAE5"), null, (String)EASResource.getString((String)"com.kingdee.eas.scm.im.IMAutoGenerateResource", (String)"228_MatStoreDateAnalyseReportUI"), (String)"im_MatStoreDateAnalyseReport_print");
        LogUtil.afterLog(null, (IObjectPK)pk);
    }

    private void checkCanPrint() {
        if (this.allOrgs != null) {
            int size = this.allOrgs.length;
            for (int index = 0; index < size; ++index) {
                IMRptUtils.checkHasAuthorized(((FullOrgUnitInfo)this.allOrgs[index]).getId().toString(), OrgType.Storage, "MatStoreDateAnalyseReport_print");
            }
        }
    }

    public void actionChart_actionPerformed(ActionEvent e) throws Exception {
        super.actionChart_actionPerformed(e);
    }

    protected ICommRptBase getRemoteInstance() throws BOSException {
        return MatStoreDateAnalyseRptFacadeFactory.getRemoteInstance();
    }

    protected KDTable getTableForPrintSetting() {
        return this.kDTable1;
    }

    protected RptParams getParamsForInit() {
        return null;
    }

    protected CommRptBaseConditionUI getQueryDialogUserPanel() throws Exception {
        MatStoreDateAnalyseConditionUI condUI = new MatStoreDateAnalyseConditionUI();
        condUI.setSize(440, 400);
        return condUI;
    }

    protected void query() {
        try {
            this.params = MatStoreDateAnalyseRptFacadeFactory.getRemoteInstance().createTempTable(this.params);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.kDTable1.removeRows();
        if (this.rowCount > 0) {
            this.kDTable1.reLayoutAndPaint();
        } else {
            this.kDTable1.repaint();
        }
        this.setColumnDisplayFormat();
        this.setColumsDisplayByParams(this.params);
    }

    public void tableDataRequest(KDTDataRequestEvent e) {
        try {
            this.allOrgs = (Object[])this.params.getObject("printStorageOrgs");
            int from = e.getFirstRow();
            int len = e.getLastRow() - from + 1;
            RptParams rpt = MatStoreDateAnalyseRptFacadeFactory.getRemoteInstance().query(this.params, from, len);
            RptRowSet rs = (RptRowSet)rpt.getObject("rowset");
            this.rowCount = rs.getRowCount();
            this.insertRows(rs, from, this.kDTable1);
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }

    public void setColumsDisplayByParams(RptParams params) {
        if (!params.getBoolean("isStatWarehouse")) {
            this.kDTable1.getColumn("warehouse").getStyleAttributes().setHided(true);
        } else {
            this.kDTable1.getColumn("warehouse").getStyleAttributes().setHided(false);
        }
        if (!params.getBoolean("isStatLocation")) {
            this.kDTable1.getColumn("location").getStyleAttributes().setHided(true);
        } else {
            this.kDTable1.getColumn("location").getStyleAttributes().setHided(false);
        }
        if (!params.getBoolean("isStatAssist")) {
            this.kDTable1.getColumn("materialAttr").getStyleAttributes().setHided(true);
        } else {
            this.kDTable1.getColumn("materialAttr").getStyleAttributes().setHided(false);
        }
        if (!params.getBoolean("isStatLot")) {
            this.kDTable1.getColumn("lot").getStyleAttributes().setHided(true);
        } else {
            this.kDTable1.getColumn("lot").getStyleAttributes().setHided(false);
        }
        if (!params.getBoolean("isStatUnit")) {
            this.kDTable1.getColumn("qty").getStyleAttributes().setHided(true);
            this.kDTable1.getColumn("unit").getStyleAttributes().setHided(true);
        } else {
            this.kDTable1.getColumn("qty").getStyleAttributes().setHided(false);
            this.kDTable1.getColumn("unit").getStyleAttributes().setHided(false);
        }
        Boolean ckBxShowMShortName = (Boolean)params.getObject("ckBxShowMShortName");
        if (ckBxShowMShortName != null && ckBxShowMShortName.booleanValue()) {
            this.kDTable1.getColumn("materialShortName").getStyleAttributes().setHided(false);
        } else {
            this.kDTable1.getColumn("materialShortName").getStyleAttributes().setHided(true);
        }
    }

    public void onLoad() throws Exception {
        FullOrgUnitInfo[] orgs = new FullOrgUnitInfo[1];
        FullOrgUnitInfo org = new FullOrgUnitInfo();
        org.setId(BOSUuid.create((String)"ZZZZZZZZ"));
        orgs[0] = org;
        this.params = new RptParams();
        this.params.setObject("fullStorageOrgs", (Object)orgs);
        this.params.setInt("storeDaysAbove", 0);
        this.params.setInt("stayDaysAbove", 0);
        this.params.setInt("currencyPrecision", 0);
        super.onLoad();
        this.actionQuery.setDaemonRun(true);
        this.kDTable1.setEditable(false);
        int count = this.kDTable1.getColumnCount();
        if (count > 2) {
            this.kDTable1.getViewManager().setFreezeView(-1, 3);
        }
    }

    protected void preparePrintPageHeader(HeadFootModel header) {
    }

    public void insertRows(RptRowSet rs, int insertRowIndex, KDTable table) {
        this.insertRows(rs, insertRowIndex, table, (KDTableInsertHandler)new DefaultKDTableInsertHandler(rs));
    }

    public void insertRows(RptRowSet rs, int insertRowIndex, KDTable table, KDTableInsertHandler handler) {
        this.insertRows(rs, insertRowIndex, table, true, handler);
    }

    public void insertRows(RptRowSet rs, int insertRowIndex, KDTable table, boolean refreshUI, KDTableInsertHandler handler) {
        table.setRefresh(false);
        while (rs.next()) {
            IRow row = table.addRow(insertRowIndex++);
            if (rs.getString("FBillNumber") == null) {
                row.getStyleAttributes().setBackground(new Color(252, 251, 223));
            }
            handler.setTableRowData(row, rs.toRowArray());
        }
        if (refreshUI) {
            table.setRefresh(true);
        }
    }

    protected boolean showQueryDialog(boolean useDefaultSolution) {
        try {
            if (this.userPanel == null) {
                this.userPanel = this.getCustomerQueryPanel();
                ReportQueryConditionHelper.initQueryDialog((CustomerQueryPanel)((CommRptBaseConditionUI)this.userPanel), (CommonQueryDialog)this.queryDialog, (Map)this.getUIContext(), (IMetaDataPK)this.getQueryMetaDataPK(), (String)((Object)((Object)this)).getClass().getName(), (RptParams)this.params, (RptParams)this.getUIContextInitParams());
            }
            CustomerParams cp = ReportQueryConditionHelper.getDefaultCustomerParams((boolean)useDefaultSolution, (CustomerQueryPanel)this.userPanel, (CoreUI)this, (IMetaDataPK)this.getQueryMetaDataPK());
            boolean ok = false;
            if ((cp == null || !useDefaultSolution) && this.queryDialog.show()) {
                CommRptBaseConditionUI rbqp = (CommRptBaseConditionUI)this.queryDialog.getUserPanel(0);
                this.params = rbqp.getCustomCondition();
                ok = true;
            }
            if (cp != null) {
                CommRptBaseConditionUI rptConditionUI = this.getQueryDialogUserPanel();
                rptConditionUI.initUIContentLayout();
                rptConditionUI.onInit(this.getUIContextInitParams());
                rptConditionUI.onLoad();
                rptConditionUI.loadFields();
                rptConditionUI.setCustomerParams(cp);
                rptConditionUI.loadData(null);
                this.params = rptConditionUI.getCustomCondition();
            }
            if (this.params != null && this.params.size() != 4 && (ok || useDefaultSolution)) {
                this.queryWithWrap();
                return true;
            }
        }
        catch (Exception e) {
            logger.error((Object)"@showQueryDialog", (Throwable)e);
            this.handleException(e);
        }
        return false;
    }

    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.INVENTORYMANAGEMENT;
    }
}

