/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.rpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.SCMRptMultiOrgsF7;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.util.FilterUtility;
import com.kingdee.eas.scm.cal.CalRptUtilFacadeFactory;
import com.kingdee.eas.scm.cal.CalculateException;
import com.kingdee.eas.scm.cal.ICalRptUtilFacade;
import com.kingdee.eas.scm.cal.util.CalculateUtil;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.client.ISCMBillStatusControl;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.client.SCMGroupClientUtils;
import com.kingdee.eas.scm.common.filter.CompositeFilterElement;
import com.kingdee.eas.scm.common.filter.FilterElement;
import com.kingdee.eas.scm.common.filter.MultiOrgsFilterElement;
import com.kingdee.eas.scm.common.filter.SingleFilterElement;
import com.kingdee.eas.scm.common.util.SCMQueryFormat;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.common.verify.VerifyItem;
import com.kingdee.eas.scm.common.verify.VerifyType;
import com.kingdee.eas.scm.im.rpt.IMRptUtils;
import com.kingdee.eas.scm.im.rpt.client.AbstractMaterialReqRptFilterUI;
import com.kingdee.eas.scm.im.rpt.client.MyCompanyFilterElement;
import com.kingdee.eas.scm.im.rpt.client.MyFilterElement;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedHashSet;
import org.apache.log4j.Logger;

public class MaterialReqRptFilterUI
extends AbstractMaterialReqRptFilterUI
implements ISCMBillStatusControl {
    private static final Logger logger = CoreUIObject.getLogger(MaterialReqRptFilterUI.class);
    private boolean isNull;
    int DateType = 1;
    private static KDBizPromptBox temporgPK;
    private static final String resClassName = "com.kingdee.eas.scm.sc.report.SCReportResource";
    private static SCMRptMultiOrgsF7 f7PurOrgUnit;

    public MaterialReqRptFilterUI() throws Exception {
        this.isReport = true;
        f7PurOrgUnit = new SCMRptMultiOrgsF7(this.prmtInvUnit, OrgType.Storage, EASResource.getString((String)resClassName, (String)"storageOrgUnitMutilF7"));
        f7PurOrgUnit.setPermItemName(this.getViewPermission());
        f7PurOrgUnit.setUseCache(true);
        f7PurOrgUnit.setNeedWait4UIOpen(false);
        this.prmtInvUnit.setEnabledMultiSelection(true);
        CompositeFilterElement elements = new CompositeFilterElement(0);
        MultiOrgsFilterElement mainOrgElement = new MultiOrgsFilterElement("fullOrgUnit", f7PurOrgUnit, this.prmtInvUnit);
        mainOrgElement.addVerifyItem(new VerifyItem(VerifyType.REQUIRED_TYPE, SCMClientUtils.getResource((String)"STORAGENOTNULL")));
        elements.add((FilterElement)mainOrgElement);
        elements.add((FilterElement)new SingleFilterElement("YearFrom", (Component)this.kDSpinnerYearFrom));
        elements.add((FilterElement)new SingleFilterElement("PeriodFrom", (Component)this.kDSpinnerPeriodFrom));
        elements.add((FilterElement)new SingleFilterElement("YearTo", (Component)this.kDSpinnerYearTo));
        elements.add((FilterElement)new SingleFilterElement("PeriodTo", (Component)this.kDSpinnerPeriodTo));
        elements.add((FilterElement)new SingleFilterElement("materialNumFrom", (Component)this.prmtMatrFrom));
        elements.add((FilterElement)new SingleFilterElement("materialNumTo", (Component)this.prmtMatrTo));
        elements.add((FilterElement)new SingleFilterElement("SupplierFrom", (Component)this.prmtSupplierFrom));
        elements.add((FilterElement)new SingleFilterElement("SupplierTo", (Component)this.prmtSupplierTo));
        elements.add((FilterElement)new SingleFilterElement("Stock", (Component)this.prmtStock));
        elements.add((FilterElement)new SingleFilterElement("BillStatus", (Component)this.kDComboBox1));
        elements.add((FilterElement)new SingleFilterElement("PeriodType", (Component)this.kdRBtnDate));
        elements.add((FilterElement)new MyFilterElement("orgPK", (Component)this.prmtInvUnit));
        elements.add((FilterElement)new MyCompanyFilterElement("companyPK", (Component)this.prmtInvUnit));
        SingleFilterElement element = new SingleFilterElement("bizDateFrom", (Component)this.pkBizDateFrom);
        element.setDefaultValue((Object)SCMUtils.getSCMQueryTime(null, (String)"startDate"));
        element.setCompareType(CompareType.GREATER_EQUALS);
        elements.add((FilterElement)element);
        element = new SingleFilterElement("bizDateTo", (Component)this.pkBizDateTo);
        element.setDefaultValue((Object)SCMUtils.getSCMQueryTime(null, (String)"endDate"));
        element.setCompareType(CompareType.LESS_EQUALS);
        elements.add((FilterElement)element);
        this.getFilterManager().setElement((FilterElement)elements);
        this.getFilterManager().setMainOrgElement((FilterElement)mainOrgElement, "storageOrgUnit.id");
        this.setBizOrgF7ByType(this.prmtInvUnit, OrgType.Storage, this.getMainBizOrgType(), true);
        this.setBizMaterialF7(this.prmtMatrFrom, false, null);
        this.setBizMaterialF7(this.prmtMatrTo, false, null);
        this.setNeedMainOrgF7s(new KDBizPromptBox[]{this.prmtInvUnit, this.prmtSupplierFrom, this.prmtSupplierTo});
        this.kdRBtnDate.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                MaterialReqRptFilterUI.this.kDSpinnerYearFrom.setEnabled(false);
                MaterialReqRptFilterUI.this.kDSpinnerYearTo.setEnabled(false);
                MaterialReqRptFilterUI.this.kDSpinnerPeriodFrom.setEnabled(false);
                MaterialReqRptFilterUI.this.kDSpinnerPeriodTo.setEnabled(false);
                MaterialReqRptFilterUI.this.pkBizDateFrom.setEnabled(true);
                MaterialReqRptFilterUI.this.pkBizDateTo.setEnabled(true);
                MaterialReqRptFilterUI.this.DateType = 1;
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        });
        this.kdRBtnPeriod.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                MaterialReqRptFilterUI.this.kDSpinnerYearFrom.setEnabled(true);
                MaterialReqRptFilterUI.this.kDSpinnerYearTo.setEnabled(true);
                MaterialReqRptFilterUI.this.kDSpinnerPeriodFrom.setEnabled(true);
                MaterialReqRptFilterUI.this.kDSpinnerPeriodTo.setEnabled(true);
                MaterialReqRptFilterUI.this.pkBizDateFrom.setEnabled(false);
                MaterialReqRptFilterUI.this.pkBizDateTo.setEnabled(false);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        });
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        this.isNull = false;
        super.onLoad();
        this.prmtInvUnit.setQueryInfo("com.kingdee.eas.scm.im.inv.app.F7StorageOrgUnitQuery");
        this.prmtStock.setQueryInfo("com.kingdee.eas.basedata.scm.im.inv.app.F7WarehouseQueryForMultiOrg");
        this.prmtInvUnit.setEnabledMultiSelection(true);
        this.kdRBtnDate.setSelected(true);
        if (this.kdRBtnDate.isSelected()) {
            this.RdBtninit(false);
        }
        SCMQueryFormat.formatBillStatus((ISCMBillStatusControl)this, (KDComboBox)this.kDComboBox1);
        if (this.prmtInvUnit.getValue() != null) {
            CompanyOrgUnitInfo cou = null;
            StorageOrgUnitInfo storageOrgUnitInfo = null;
            OrgUnitInfo orgInfo = null;
            if (this.prmtInvUnit.getValue() instanceof OrgUnitInfo[]) {
                orgInfo = ((OrgUnitInfo[])this.prmtInvUnit.getValue())[0];
            } else if (this.prmtInvUnit.getValue() instanceof OrgUnitInfo) {
                orgInfo = (OrgUnitInfo)this.prmtInvUnit.getValue();
            }
            if (orgInfo != null) {
                String id = orgInfo.getId().toString();
                storageOrgUnitInfo = (StorageOrgUnitInfo)SCMGroupClientUtils.getOrgUnitInfoByType((String)id, (OrgType)OrgType.Storage);
                IOrgUnitRelation iUnitRel = OrgUnitRelationFactory.getRemoteInstance();
                OrgUnitCollection orgCol = iUnitRel.getToUnit(storageOrgUnitInfo.getId().toString(), 4, 1);
                if (orgCol.get(0) != null) {
                    cou = (CompanyOrgUnitInfo)orgCol.get(0);
                }
                this.f7Manager.registerBizSupplierF7(this.prmtSupplierFrom, null, null, (OrgUnitInfo)cou, OrgType.Company, false);
                this.f7Manager.registerBizSupplierF7(this.prmtSupplierTo, null, null, (OrgUnitInfo)cou, OrgType.Company, false);
                MaterialReqRptFilterUI.loadYearPeriod(cou, this.kDSpinnerYearFrom, this.kDSpinnerYearTo, this.kDSpinnerPeriodFrom, this.kDSpinnerPeriodTo);
            }
        }
        this.kDComboBox1.setSelectedItem((Object)BillBaseStatusEnum.AUDITED);
        this.pkBizDateFrom.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent arg0) {
                MaterialReqRptFilterUI.this.checkFromDate(arg0);
            }
        });
        this.pkBizDateTo.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent arg0) {
                MaterialReqRptFilterUI.this.checkToDate(arg0);
            }
        });
        this.addF7Listener();
    }

    protected void addF7Listener() {
        this.prmtInvUnit.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                try {
                    MaterialReqRptFilterUI.this.bizStorageOrgUnit_dataChanged(e);
                }
                catch (Exception e1) {
                    MaterialReqRptFilterUI.this.handUIException(e1);
                }
            }
        });
        this.prmtStock.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                MaterialReqRptFilterUI.this.prmtStock_willShow(e);
            }
        });
    }

    protected void bizStorageOrgUnit_dataChanged(DataChangeEvent e) throws BOSException, EASBizException {
        OrgUnitInfo orgInfo = null;
        CompanyOrgUnitInfo cou = null;
        if (this.prmtInvUnit.getValue() != null) {
            StringBuffer storageOrgUnitStrList = new StringBuffer();
            if (this.prmtInvUnit.getValue() instanceof Object[]) {
                Object[] storageOrgUnit = (Object[])this.prmtInvUnit.getValue();
                int n = storageOrgUnit.length;
                for (int i = 0; i < n; ++i) {
                    boolean fisleaf;
                    if (((FullOrgUnitInfo)storageOrgUnit[i]).get("isleaf") == null || !(fisleaf = ((Boolean)((FullOrgUnitInfo)storageOrgUnit[i]).get("isleaf")).booleanValue())) continue;
                    storageOrgUnitStrList.append(((FullOrgUnitInfo)storageOrgUnit[i]).getId().toString());
                    storageOrgUnitStrList.append(",");
                }
                orgInfo = (FullOrgUnitInfo)storageOrgUnit[0];
            } else if (this.prmtInvUnit.getValue() instanceof OrgUnitInfo) {
                orgInfo = (OrgUnitInfo)this.prmtInvUnit.getValue();
                storageOrgUnitStrList.append(orgInfo.getId().toString());
            }
            if (!"".equals(storageOrgUnitStrList.toString())) {
                storageOrgUnitStrList.delete(storageOrgUnitStrList.length() - 1, storageOrgUnitStrList.length());
                String ids = storageOrgUnitStrList.toString();
                Object[] idObject = null;
                idObject = ids.indexOf(",") != -1 ? ids.split(",") : new Object[]{ids};
                IMRptUtils.setRptWarehouseFilter(idObject, this.prmtStock);
            }
            if (orgInfo != null) {
                String id = orgInfo.getId().toString();
                StorageOrgUnitInfo storageOrgUnitInfo = (StorageOrgUnitInfo)SCMGroupClientUtils.getOrgUnitInfoByType((String)id, (OrgType)OrgType.Storage);
                CompanyOrgUnitInfo cInfo = (CompanyOrgUnitInfo)SCMGroupClientUtils.getOrgUnitInfoByType((String)id, (OrgType)OrgType.Company);
                IOrgUnitRelation iUnitRel = OrgUnitRelationFactory.getRemoteInstance();
                OrgUnitCollection orgCol = iUnitRel.getToUnit(storageOrgUnitInfo.getId().toString(), 4, 1);
                if (orgCol.get(0) != null) {
                    cou = (CompanyOrgUnitInfo)orgCol.get(0);
                } else if (cInfo != null) {
                    cou = cInfo;
                }
                this.f7Manager.registerBizSupplierF7(this.prmtSupplierFrom, null, null, (OrgUnitInfo)cou, OrgType.Company, false);
                this.f7Manager.registerBizSupplierF7(this.prmtSupplierTo, null, null, (OrgUnitInfo)cou, OrgType.Company, false);
            }
        }
    }

    protected void prmtStock_willShow(SelectorEvent e) {
        this.storageOrgUnitCheck();
    }

    protected void storageOrgUnitCheck() {
        if (this.prmtInvUnit.getValue() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.scm.im.rpt.IMRptResource", (String)"storageOrgUnitNotNull"));
            SysUtil.abort();
        }
    }

    protected void checkFromDate(DataChangeEvent e) {
        if (!this.checkBizDate()) {
            this.pkBizDateFrom.setValue(e.getOldValue());
            MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.scm.im.IMAutoGenerateResource", (String)"227_MaterialReqRptFilterUI"));
            SysUtil.abort();
        }
    }

    protected void checkToDate(DataChangeEvent e) {
        if (!this.checkBizDate()) {
            this.pkBizDateTo.setValue(e.getOldValue());
            MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.scm.im.IMAutoGenerateResource", (String)"227_MaterialReqRptFilterUI"));
            SysUtil.abort();
        }
    }

    protected boolean checkBizDate() {
        if (this.pkBizDateTo.getValue() != null && this.pkBizDateFrom.getValue() != null) {
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
            Calendar c1 = Calendar.getInstance();
            Calendar c2 = Calendar.getInstance();
            try {
                Date temp1 = df.parse(df.format((Date)this.pkBizDateFrom.getValue()));
                Date temp2 = df.parse(df.format((Date)this.pkBizDateTo.getValue()));
                c1.setTime(temp1);
                c2.setTime(temp2);
            }
            catch (ParseException e) {
                logger.error((Object)e);
            }
            if (c1.after(c2)) {
                return false;
            }
        }
        return true;
    }

    protected void checkSpinnerDate() {
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.prmtInvUnit;
    }

    protected String getPropertyOfMainBizOrg() {
        return "storageOrgUnit.id";
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Storage;
    }

    public static void loadYearPeriod(CompanyOrgUnitInfo companyInfo, KDSpinner spAccPeriodYear, KDSpinner spAccPeriodYearTo, KDSpinner spAccPeriodMonth, KDSpinner spAccPeriodMonthTo) throws EASBizException, BOSException {
        ICalRptUtilFacade iCalRptUtil;
        Object[] reslut;
        if (companyInfo == null) {
            return;
        }
        if (companyInfo != null) {
            PeriodInfo curPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)companyInfo);
            PeriodInfo periodInfo = SystemStatusCtrolUtils.getStartPeriod(null, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)companyInfo);
            if (periodInfo == null) {
                throw new CalculateException(CalculateException.REPORT_ACCOUNT_NOTSTART);
            }
            if (curPeriodInfo == null) {
                throw new CalculateException(CalculateException.REPORT_ACCOUNT_NOTCURRENT);
            }
        }
        if ((reslut = (iCalRptUtil = CalRptUtilFacadeFactory.getRemoteInstance()).fetchInitFilterData(companyInfo.getId().toString())) != null) {
            CalculateUtil.AccountPeriodInfo actPeriodInfo = (CalculateUtil.AccountPeriodInfo)reslut[1];
            CalculateUtil.appliesPeriodControl((KDSpinner)spAccPeriodYear, (KDSpinner)spAccPeriodYearTo, (KDSpinner)spAccPeriodMonth, (KDSpinner)spAccPeriodMonthTo, (CalculateUtil.AccountPeriodInfo)actPeriodInfo, (boolean)true, (boolean)false);
        }
    }

    private void setSupplierF7(KDBizPromptBox bizMaterialBox, boolean isSubContract) throws Exception {
        this.addF7Filter(bizMaterialBox, this.getSupplierFilter(isSubContract));
    }

    private FilterInfo getSupplierFilter(boolean isSubContract) throws Exception {
        FilterInfo filterInfo = new FilterInfo();
        FilterItemInfo info = null;
        PurchaseOrgUnitInfo cou = null;
        StorageOrgUnitInfo storageOrgUnitInfo = null;
        Object orgInfo = null;
        if (isSubContract && this.prmtInvUnit.getValue() != null && (orgInfo = this.prmtInvUnit.getValue()) != null) {
            String id = ((OrgUnitInfo)orgInfo).getId().toString();
            storageOrgUnitInfo = (StorageOrgUnitInfo)SCMGroupClientUtils.getOrgUnitInfoByType((String)id, (OrgType)OrgType.Storage);
            IOrgUnitRelation iUnitRel = OrgUnitRelationFactory.getRemoteInstance();
            OrgUnitCollection orgCol = iUnitRel.getToUnit(storageOrgUnitInfo.getId().toString(), 4, 3);
            if (orgCol.get(0) != null) {
                cou = (PurchaseOrgUnitInfo)orgCol.get(0);
                info = new FilterItemInfo("adminCU", (Object)cou.getId().toString());
            }
        }
        if (info == null) {
            return null;
        }
        return filterInfo;
    }

    private void addF7Filter(KDBizPromptBox bizMaterialBox, FilterInfo filterInfo) {
        if (bizMaterialBox != null) {
            EntityViewInfo entityViewInfo = bizMaterialBox.getEntityViewInfo();
            if (entityViewInfo == null || !FilterUtility.hasFilterItem((FilterInfo)entityViewInfo.getFilter())) {
                entityViewInfo = new EntityViewInfo();
                entityViewInfo.setFilter(filterInfo);
            } else {
                try {
                    entityViewInfo.setFilter(filterInfo);
                }
                catch (Exception e) {
                    this.handUIException(e);
                }
            }
            bizMaterialBox.setEntityViewInfo(entityViewInfo);
        }
    }

    public Object[] getAdditiveBillStatus() {
        return null;
    }

    public Object[] getUnVisibleBillStatus() {
        return new Object[]{BillBaseStatusEnum.ADD, BillBaseStatusEnum.RELEASED, BillBaseStatusEnum.BLOCKED, BillBaseStatusEnum.CLOSED, BillBaseStatusEnum.DELETED, BillBaseStatusEnum.ALTERING, BillBaseStatusEnum.FINISH, BillBaseStatusEnum.COMPLETE, BillBaseStatusEnum.NULL, BillBaseStatusEnum.VERSION};
    }

    private void RdBtninit(boolean flag) {
        if (flag) {
            this.kDSpinnerYearFrom.setEnabled(true);
            this.kDSpinnerYearTo.setEnabled(true);
            this.kDSpinnerPeriodFrom.setEnabled(true);
            this.kDSpinnerPeriodTo.setEnabled(true);
            this.pkBizDateFrom.setEnabled(false);
            this.pkBizDateTo.setEnabled(false);
        } else {
            this.kDSpinnerYearFrom.setEnabled(false);
            this.kDSpinnerYearTo.setEnabled(false);
            this.kDSpinnerPeriodFrom.setEnabled(false);
            this.kDSpinnerPeriodTo.setEnabled(false);
            this.pkBizDateFrom.setEnabled(true);
            this.pkBizDateTo.setEnabled(true);
        }
    }

    public void afterMainOrgChanged(String ids) {
        if (!this.isNull) {
            this.prmtStock.setText(null);
        }
        this.isNull = this.getMainBizOrgF7().getText() == null || this.getMainBizOrgF7().getText().length() <= 0;
    }

    private void setWareHouseF7(KDBizPromptBox bizStorageOrgBox, boolean isSubContract) throws Exception {
        this.addF7Filter(bizStorageOrgBox, this.getWareHouseFilter(isSubContract));
    }

    private FilterInfo getWareHouseFilter(boolean isSubContract) throws Exception {
        LinkedHashSet storageOrgUnit;
        FilterInfo filterInfo = new FilterInfo();
        FilterItemInfo info = null;
        if (isSubContract && (storageOrgUnit = this.getStorageOrgUnitNumber()) != null && storageOrgUnit.size() > 0) {
            info = new FilterItemInfo("storageOrg.number", (Object)this.getStorageOrgUnitNumber(), CompareType.INCLUDE);
        }
        if (info == null) {
            return null;
        }
        filterInfo.getFilterItems().add(info);
        return filterInfo;
    }

    private LinkedHashSet getStorageOrgUnitNumber() {
        LinkedHashSet<String> storageOrgUnit = new LinkedHashSet<String>();
        if (this.prmtInvUnit.getValue() != null) {
            if (this.prmtInvUnit.getValue() instanceof FullOrgUnitInfo) {
                StorageOrgUnitInfo sou = new StorageOrgUnitInfo();
                FullOrgUnitInfo fou = (FullOrgUnitInfo)this.prmtInvUnit.getValue();
                sou.setNumber(fou.getNumber());
            } else if (this.prmtInvUnit.getValue() instanceof Object[]) {
                Object[] sous = (Object[])this.prmtInvUnit.getValue();
                for (int i = 0; i < sous.length; ++i) {
                    if (sous[0] instanceof FullOrgUnitInfo) {
                        FullOrgUnitInfo fou = (FullOrgUnitInfo)sous[i];
                        storageOrgUnit.add(fou.getNumber());
                        continue;
                    }
                    storageOrgUnit.add(((StorageOrgUnitInfo)sous[i]).getNumber());
                }
            } else {
                storageOrgUnit.add(((StorageOrgUnitInfo)this.prmtInvUnit.getValue()).getNumber());
            }
            return storageOrgUnit;
        }
        return null;
    }

    public void clear() {
        super.getFilterManager().clearAll();
        this.setDefaultValue();
        OrgUnitInfo aOrgUnitInfo = this.getDefaultMainBizOrg();
        if (aOrgUnitInfo != null && this.getMainBizOrgF7() != null) {
            this.getMainBizOrgF7().setValue((Object)new OrgUnitInfo[]{aOrgUnitInfo.castToFullOrgUnitInfo()});
        }
    }

    protected String getViewPermission() {
        return "MaterialReqReportView";
    }
}

