/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.rpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.headfootdesigner.HeadFootModel;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestListener;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.report.ICommRptBase;
import com.kingdee.eas.framework.report.client.CommRptBaseConditionUI;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.scm.common.YesOrNoEnum;
import com.kingdee.eas.scm.common.util.ReportQueryConditionHelper;
import com.kingdee.eas.scm.im.inv.IMaterialSerialNumber;
import com.kingdee.eas.scm.im.inv.MaterialSerialNumberFactory;
import com.kingdee.eas.scm.im.inv.SerialNumberStatusEnum;
import com.kingdee.eas.scm.im.rpt.client.AbstractMaterialSerialNumberReportUI;
import com.kingdee.eas.scm.im.rpt.client.MaterialSerialNumberConditionUI;
import java.math.BigDecimal;
import java.util.Map;
import org.apache.log4j.Logger;

public class MaterialSerialNumberReportUI
extends AbstractMaterialSerialNumberReportUI {
    private static final long serialVersionUID = 7912133559421334272L;
    private static final Logger logger = CoreUIObject.getLogger(MaterialSerialNumberReportUI.class);

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected ICommRptBase getRemoteInstance() throws BOSException {
        return null;
    }

    protected KDTable getTableForOA() {
        return this.kDTable1;
    }

    protected KDTable getTableForPrintSetting() {
        return this.kDTable1;
    }

    protected boolean isAllowOAMenu() {
        return true;
    }

    protected RptParams getParamsForInit() {
        return null;
    }

    protected CommRptBaseConditionUI getQueryDialogUserPanel() throws Exception {
        MaterialSerialNumberConditionUI condUI = new MaterialSerialNumberConditionUI();
        condUI.setSize(400, 300);
        return condUI;
    }

    protected void query() {
        try {
            this.kDTable1.removeRows();
            this.getDataToTable();
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }

    public void tableDataRequest(KDTDataRequestEvent e) {
    }

    public void onLoad() throws Exception {
        this.kDTable1.checkParsed();
        super.onLoad();
        this.kDTable1.getDataRequestManager().addDataRequestListener((KDTDataRequestListener)this);
        this.kDTable1.getColumn("qty").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.kDTable1.setEditable(false);
        int freezeCol = this.kDTable1.getColumnIndex("sn");
        this.kDTable1.getViewManager().setFreezeView(-1, freezeCol + 1);
    }

    public void getDataToTable() throws Exception {
        IMaterialSerialNumber iMaterialSerialNumber = MaterialSerialNumberFactory.getRemoteInstance();
        RptRowSet rs = iMaterialSerialNumber.materialSNRpt(this.params);
        this.setDateToTable(this.kDTable1, rs);
    }

    private void setDateToTable(KDTable table, RptRowSet rptRs) throws Exception {
        BigDecimal ZERO;
        table.setRefresh(false);
        int insertRowIndex = 0;
        int qtyPrecision = 4;
        int snStatus = -1;
        int isReversed = 0;
        BigDecimal qty = ZERO = new BigDecimal("0.00");
        Object o = null;
        while (rptRs.next()) {
            IRow row = table.addRow(insertRowIndex++);
            o = rptRs.getObject("qtyPrecision");
            if (o != null) {
                qtyPrecision = Integer.valueOf(o.toString().trim());
            }
            if ((qty = rptRs.getBigDecimal("qty")) != null) {
                if (qty.compareTo(ZERO) != 0) {
                    qty = qty.setScale(qtyPrecision, 4);
                    rptRs.setValue("qty", (Object)qty);
                } else {
                    rptRs.setValue("qty", null);
                }
            }
            snStatus = rptRs.getInt("snStatus");
            rptRs.setValue("snStatus", (Object)SerialNumberStatusEnum.getEnum(snStatus));
            isReversed = rptRs.getInt("isReversed");
            rptRs.setValue("isReversed", (Object)YesOrNoEnum.getEnum((int)isReversed));
            Object[] rowData = rptRs.toRowArray();
            int n = rowData.length;
            for (int i = 0; i < n; ++i) {
                row.getCell(i).setValue(rowData[i]);
            }
        }
        table.setRefresh(true);
    }

    protected void preparePrintPageHeader(HeadFootModel header) {
    }

    protected boolean showQueryDialog(boolean useDefaultSolution) {
        try {
            if (this.userPanel == null) {
                this.userPanel = this.getCustomerQueryPanel();
                ReportQueryConditionHelper.initQueryDialog((CustomerQueryPanel)((CommRptBaseConditionUI)this.userPanel), (CommonQueryDialog)this.queryDialog, (Map)this.getUIContext(), (IMetaDataPK)this.getQueryMetaDataPK(), (String)((Object)((Object)this)).getClass().getName(), (RptParams)this.params, (RptParams)this.getUIContextInitParams());
            }
            CustomerParams cp = ReportQueryConditionHelper.getDefaultCustomerParams((boolean)useDefaultSolution, (CustomerQueryPanel)this.userPanel, (CoreUI)this, (IMetaDataPK)this.getQueryMetaDataPK());
            boolean ok = false;
            if ((cp == null || !useDefaultSolution) && this.queryDialog.show()) {
                CommRptBaseConditionUI rbqp = (CommRptBaseConditionUI)this.queryDialog.getUserPanel(0);
                this.params = rbqp.getCustomCondition();
                ok = true;
            }
            if (cp != null) {
                CommRptBaseConditionUI rptConditionUI = this.getQueryDialogUserPanel();
                rptConditionUI.initUIContentLayout();
                rptConditionUI.onInit(this.getUIContextInitParams());
                rptConditionUI.onLoad();
                rptConditionUI.loadFields();
                rptConditionUI.setCustomerParams(cp);
                rptConditionUI.loadData(null);
                this.params = rptConditionUI.getCustomCondition();
            }
            if (this.params != null && (ok || useDefaultSolution)) {
                this.queryWithWrap();
                return true;
            }
        }
        catch (Exception e) {
            logger.error((Object)"@showQueryDialog", (Throwable)e);
            this.handleException(e);
        }
        return false;
    }
}

