/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.rpt.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.param.ParamSimpleInfo;
import com.kingdee.eas.basedata.framework.util.EntityControlTypeUtil;
import com.kingdee.eas.basedata.master.material.IMaterialGroupStandard;
import com.kingdee.eas.basedata.master.material.MaterialGroupStandardCollection;
import com.kingdee.eas.basedata.master.material.MaterialGroupStandardFactory;
import com.kingdee.eas.basedata.master.material.MaterialGroupStandardInfo;
import com.kingdee.eas.basedata.master.material.MaterialGroupStandardTypeEnum;
import com.kingdee.eas.basedata.master.material.client.F7MaterialMultiUISelectorAdaptor;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitCollection;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.client.f7.SCMRptMultiOrgsF7;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.mm.common.client.UIHelper;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.filter.CompositeFilterElement;
import com.kingdee.eas.scm.common.filter.FilterElement;
import com.kingdee.eas.scm.common.filter.MultiF7FilterElement;
import com.kingdee.eas.scm.common.filter.MultiOrgsFilterElement;
import com.kingdee.eas.scm.common.filter.SingleFilterElement;
import com.kingdee.eas.scm.im.inv.client.InvClientUtils;
import com.kingdee.eas.scm.im.rpt.IMRptUtils;
import com.kingdee.eas.scm.im.rpt.RptPriceEnum;
import com.kingdee.eas.scm.im.rpt.client.AbstractMaterialStayRptFilterUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Vector;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import org.apache.log4j.Logger;

public class MaterialStayRptFilterUI
extends AbstractMaterialStayRptFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(MaterialStayRptFilterUI.class);
    private static final String resClassName = "com.kingdee.eas.scm.im.rpt.IMRptResource";
    private SCMRptMultiOrgsF7 multiStorageF7;
    private Object[] fullStorageOrgs;
    private Object[] selectWarehouses;
    private Object[] printStorageOrgs;
    public static final String CTX_ONLY_BASE_SRANDARD = "onlyBaseStandard";
    public static final String CTX_GROUP_STANDARD = "groupStandard";
    public static final String CTX_CU = "cu";
    private String groupStandardID;
    private int currencyPrecision = 2;
    private CtrlUnitInfo curCtrlUnitInfo;
    private boolean firstLoad = true;
    private int defaultGroupIndex = 0;
    private MaterialGroupStandardCollection groupStandardColl;

    public MaterialStayRptFilterUI() throws Exception {
        this.isContainsFreeze.setSelected(true);
        this.showLastBillDate.setSelected(false);
        this.showLastBillDate.setVisible(false);
        this.isReport = true;
        this.curCtrlUnitInfo = (CtrlUnitInfo)this.getUIContext().get(CTX_CU);
        if (this.curCtrlUnitInfo == null) {
            this.curCtrlUnitInfo = SysContext.getSysContext().getCurrentCtrlUnit();
        }
        this.setF7Control();
        this.initElementsInfo();
        this.loadGroupStandard();
        this.kDTxtStayDateAbove.setModel((SpinnerModel)new SpinnerNumberModel(0, 0, 80000, 1));
    }

    public void onLoad() throws Exception {
        super.onLoad();
        UIHelper.registerProjectF7ForFilter((KDBizPromptBox)this.kDBizStorage, (KDBizPromptBox)this.prmtProjectFrom);
        UIHelper.registerProjectF7ForFilter((KDBizPromptBox)this.kDBizStorage, (KDBizPromptBox)this.prmtProjectTo);
        UIHelper.registerTrackNumberF7ForFilter((KDBizPromptBox)this.kDBizStorage, (KDBizPromptBox)this.prmtTrackNumFrom);
        UIHelper.registerTrackNumberF7ForFilter((KDBizPromptBox)this.kDBizStorage, (KDBizPromptBox)this.prmtTrackNumTo);
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Storage;
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.kDBizStorage;
    }

    protected String getPropertyOfMainBizOrg() {
        return "storageOrgUnit.id";
    }

    public void clear() {
        super.getFilterManager().clearAll();
        this.setDefaultValue();
        this.isReport = false;
        OrgUnitInfo aOrgUnitInfo = this.getDefaultMainBizOrg();
        this.isReport = true;
        if (aOrgUnitInfo != null && this.getMainBizOrgF7() != null) {
            this.getMainBizOrgF7().setValue((Object)new OrgUnitInfo[]{aOrgUnitInfo.castToFullOrgUnitInfo()});
        }
        this.kDTxtStayDateAbove.setValue((Object)0, false);
        this.kDRadioNoInOut.setSelected(true);
        this.kDRadioNoOut.setSelected(false);
        this.kDRadioNotOutNotIn.setSelected(false);
        this.isContainsTransf.setSelected(false);
        this.isContainsFreeze.setSelected(true);
        this.kDCheckInCluWarehs.setSelected(false, false);
        this.kDCheckInCludeLocation.setSelected(false);
        this.kDCheckInCludeProject.setSelected(false);
        this.kDCheckIncluLot.setSelected(false);
        this.kDCheckIncluAssist.setSelected(false);
        this.kDCheckInCludeTrackNumber.setSelected(false);
        this.kDCheckIncluUnitQty.setSelected(false);
        this.kDCheckInCludeStoreStatus.setSelected(false);
    }

    protected String getViewPermission() {
        return "MaterialStayReport_view";
    }

    private void initElementsInfo() {
        CompositeFilterElement elements = new CompositeFilterElement(0);
        elements.add((FilterElement)new MultiOrgsFilterElement("fullStorageOrgs", this.multiStorageF7, this.kDBizStorage));
        elements.add((FilterElement)new SingleFilterElement("warehs", (Component)this.kDBizWarehs));
        elements.add((FilterElement)new MultiF7FilterElement("materialFrom", this.kDBizMaterialFrom, Boolean.valueOf(false)));
        elements.add((FilterElement)new SingleFilterElement("materialTo", (Component)this.kDBizMaterialTo));
        elements.add((FilterElement)new SingleFilterElement("materialTypeFrom", (Component)this.bizMaterialTypeFrom));
        elements.add((FilterElement)new SingleFilterElement("materialTypeTo", (Component)this.bizMaterialTypeTo));
        elements.add((FilterElement)new SingleFilterElement("assistFrom", (Component)this.kDBizAssistFrom));
        elements.add((FilterElement)new SingleFilterElement("assistTo", (Component)this.kDBizAssistTo));
        elements.add((FilterElement)new SingleFilterElement("lotFrom", (Component)this.txtLotFrom));
        elements.add((FilterElement)new SingleFilterElement("lotTo", (Component)this.txtLotTo));
        elements.add((FilterElement)new SingleFilterElement("stayDays", (Component)this.kDTxtStayDateAbove));
        elements.add((FilterElement)new SingleFilterElement("stayNoInOut", (Component)this.kDRadioNoInOut));
        elements.add((FilterElement)new SingleFilterElement("stayNoOutHasIn", (Component)this.kDRadioNoOut));
        elements.add((FilterElement)new SingleFilterElement("stayNoOut", (Component)this.kDRadioNotOutNotIn));
        elements.add((FilterElement)new SingleFilterElement("inCluStansferBill", (Component)this.isContainsTransf));
        elements.add((FilterElement)new SingleFilterElement("inCluFreeze", (Component)this.isContainsFreeze));
        elements.add((FilterElement)new SingleFilterElement("showLastBillDate", (Component)this.showLastBillDate));
        elements.add((FilterElement)new SingleFilterElement("inCluWarehs", (Component)this.kDCheckInCluWarehs));
        elements.add((FilterElement)new SingleFilterElement("inCluLocation", (Component)this.kDCheckInCludeLocation));
        elements.add((FilterElement)new SingleFilterElement("inCluTrackNumber", (Component)this.kDCheckInCludeTrackNumber));
        elements.add((FilterElement)new SingleFilterElement("projectFrom", (Component)this.prmtProjectFrom));
        elements.add((FilterElement)new SingleFilterElement("projectTo", (Component)this.prmtProjectTo));
        elements.add((FilterElement)new SingleFilterElement("inCluProject", (Component)this.kDCheckInCludeProject));
        elements.add((FilterElement)new SingleFilterElement("trackNumberFrom", (Component)this.prmtTrackNumFrom));
        elements.add((FilterElement)new SingleFilterElement("trackNumberTo", (Component)this.prmtTrackNumTo));
        elements.add((FilterElement)new SingleFilterElement("inCluLot", (Component)this.kDCheckIncluLot));
        elements.add((FilterElement)new SingleFilterElement("inCluAssist", (Component)this.kDCheckIncluAssist));
        elements.add((FilterElement)new SingleFilterElement("inCluUnit", (Component)this.kDCheckIncluUnitQty));
        elements.add((FilterElement)new SingleFilterElement("inCluStoreStatus", (Component)this.kDCheckInCludeStoreStatus));
        SingleFilterElement sfePriceSelect = new SingleFilterElement("priceSelect", (Component)this.comboPriceEnum);
        sfePriceSelect.setDefaultValue((Object)RptPriceEnum.BEGIN_WEIGHTED_AVERAGE_PRICE);
        elements.add((FilterElement)sfePriceSelect);
        elements.add((FilterElement)new SingleFilterElement("materialGroupStandard", (Component)this.comboGroupStandard){

            public void addRptParams(RptParams cp) {
                String number = null;
                if (MaterialStayRptFilterUI.this.comboGroupStandard.getSelectedItem() != null) {
                    number = ((MaterialGroupStandardInfo)MaterialStayRptFilterUI.this.comboGroupStandard.getSelectedItem()).getId().toString();
                }
                cp.setObject(this.getId(), number);
            }

            public void clear() {
                MaterialStayRptFilterUI.this.comboGroupStandard.setSelectedIndex(MaterialStayRptFilterUI.this.defaultGroupIndex);
            }

            public void addCustomerParam(CustomerParams cp, String key, Object obj) {
                String number = ((MaterialGroupStandardInfo)MaterialStayRptFilterUI.this.comboGroupStandard.getSelectedItem()).getId().toString();
                if (key != null && number != null) {
                    cp.addCustomerParam(key, number);
                }
            }

            protected String getNumber(Object obj) {
                return ((MaterialGroupStandardInfo)MaterialStayRptFilterUI.this.comboGroupStandard.getSelectedItem()).getId().toString();
            }

            protected void setNumber(Object obj, String value) {
                if (MaterialStayRptFilterUI.this.groupStandardColl == null || MaterialStayRptFilterUI.this.groupStandardColl.size() == 0) {
                    MaterialStayRptFilterUI.this.comboGroupStandard.setSelectedIndex(MaterialStayRptFilterUI.this.defaultGroupIndex);
                } else {
                    for (int i = 0; i < MaterialStayRptFilterUI.this.groupStandardColl.size(); ++i) {
                        if (!value.equals(MaterialStayRptFilterUI.this.groupStandardColl.get(i).getId().toString())) continue;
                        MaterialStayRptFilterUI.this.comboGroupStandard.setSelectedIndex(i);
                    }
                }
            }
        });
        this.getFilterManager().setElement((FilterElement)elements);
    }

    private void loadGroupStandard() throws Exception {
        MaterialGroupStandardInfo groupStandard = null;
        Boolean onlyBaseStandard = (Boolean)this.getUIContext().get(CTX_ONLY_BASE_SRANDARD);
        if (onlyBaseStandard != null && onlyBaseStandard.booleanValue()) {
            IMaterialGroupStandard iBiz = MaterialGroupStandardFactory.getRemoteInstance();
            MaterialGroupStandardCollection baseGroupStandardColl = iBiz.getBaseMaterialGroupStandardColl();
            if (baseGroupStandardColl.size() > 0) {
                groupStandard = baseGroupStandardColl.get(0);
            }
        } else {
            groupStandard = (MaterialGroupStandardInfo)this.getUIContext().get(CTX_GROUP_STANDARD);
        }
        if (groupStandard != null) {
            this.comboGroupStandard.removeAllItems();
            this.comboGroupStandard.addItem((Object)groupStandard);
            this.comboGroupStandard.setSelectedIndex(0);
            this.groupStandardID = groupStandard.getId().toString();
        } else {
            IMaterialGroupStandard iMaterialGroupStandard = MaterialGroupStandardFactory.getRemoteInstance();
            FilterInfo filterInfoCU = EntityControlTypeUtil.getFilterInfoForControlTypeS4((String)this.curCtrlUnitInfo.getId().toString(), (String)this.curCtrlUnitInfo.getLongNumber());
            EntityViewInfo viewInfo = new EntityViewInfo();
            viewInfo.setFilter(filterInfoCU);
            this.groupStandardColl = iMaterialGroupStandard.getMaterialGroupStandardCollection(viewInfo);
            this.comboGroupStandard.removeAllItems();
            if (this.groupStandardColl != null) {
                this.comboGroupStandard.addItems(this.groupStandardColl.toArray());
            }
            int size = this.groupStandardColl.size();
            for (int index = 0; index < size; ++index) {
                if (!this.groupStandardColl.get(index).getStandardType().equals((Object)MaterialGroupStandardTypeEnum.BasicStandard)) continue;
                this.defaultGroupIndex = index;
                break;
            }
            this.comboGroupStandard.setSelectedIndex(this.defaultGroupIndex);
            MaterialGroupStandardInfo groupStandardInfo = this.groupStandardColl.get(this.defaultGroupIndex);
            this.groupStandardID = groupStandardInfo.getId().toString();
        }
    }

    private void setF7Control() {
        if (this.firstLoad) {
            this.multiStorageF7 = new SCMRptMultiOrgsF7(this.kDBizStorage, OrgType.Storage, "MaterialStayReport_view", EASResource.getString((String)resClassName, (String)"storageOrgUnitMutilF7"));
            this.fullStorageOrgs = (Object[])this.multiStorageF7.getFullData();
            this.kDBizStorage.addDataChangeListener(new DataChangeListener(){

                public void dataChanged(DataChangeEvent eventObj) {
                    MaterialStayRptFilterUI.access$202(MaterialStayRptFilterUI.this, (Object[])MaterialStayRptFilterUI.this.multiStorageF7.getFullData());
                    MaterialStayRptFilterUI.access$402(MaterialStayRptFilterUI.this, (Object[])MaterialStayRptFilterUI.this.multiStorageF7.getData());
                    if (MaterialStayRptFilterUI.this.fullStorageOrgs != null) {
                        Vector<String> vOrgs = new Vector<String>();
                        for (int i = 0; i < MaterialStayRptFilterUI.this.fullStorageOrgs.length; ++i) {
                            vOrgs.add(((FullOrgUnitInfo)MaterialStayRptFilterUI.this.fullStorageOrgs[i]).getId().toString());
                        }
                        if (MaterialStayRptFilterUI.this.fullStorageOrgs.length > 0) {
                            IMRptUtils.setRptWarehouseFilter(vOrgs.toArray(), MaterialStayRptFilterUI.this.kDBizWarehs);
                        }
                        int size = MaterialStayRptFilterUI.this.fullStorageOrgs.length;
                        for (int i = 0; i < size; ++i) {
                            CompanyOrgUnitInfo currCom = null;
                            currCom = InvClientUtils.getCompanyInfo(((FullOrgUnitInfo)MaterialStayRptFilterUI.this.fullStorageOrgs[i]).getId().toString());
                            if (currCom == null) continue;
                            try {
                                MaterialStayRptFilterUI.this.currencyPrecision = InvClientUtils.getLocalCurrencyPrecision(currCom);
                                return;
                            }
                            catch (Exception e) {
                                logger.error((Object)e);
                            }
                        }
                    }
                }
            });
            this.kDBizWarehs.setEnabledMultiSelection(true);
            this.kDBizWarehs.addDataChangeListener(new DataChangeListener(){

                public void dataChanged(DataChangeEvent eventObj) {
                    MaterialStayRptFilterUI.access$702(MaterialStayRptFilterUI.this, (Object[])MaterialStayRptFilterUI.this.kDBizWarehs.getValue());
                }
            });
            this.kDBizWarehs.addSelectorListener(new SelectorListener(){

                public void willShow(SelectorEvent e) {
                    MaterialStayRptFilterUI.this.kDBizWarehs_willShow(e);
                }
            });
            this.kDCheckInCludeLocation.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent arg0) {
                    MaterialStayRptFilterUI.this.kDCheckInCludeLocation_actionPerformed(arg0);
                }
            });
            this.kDCheckInCluWarehs.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    MaterialStayRptFilterUI.this.kDCheckInCluWarehs_actionPerformed(e);
                }
            });
            this.comboGroupStandard.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    MaterialStayRptFilterUI.this.comboGroupStandard_itemStateChanged(e);
                }
            });
            this.firstLoad = false;
        }
        InvClientUtils.getMaterialF7ForReportFilterUI(this.kDBizMaterialFrom, (Object)this);
        InvClientUtils.getMaterialF7ForReportFilterUI(this.kDBizMaterialTo, (Object)this);
        this.kDBizMaterialFrom.setEnabledMultiSelection(true);
        F7MaterialMultiUISelectorAdaptor selectorMaterial = (F7MaterialMultiUISelectorAdaptor)this.kDBizMaterialFrom.getSelector();
        selectorMaterial.setIsMultiSelect(true);
        SCMClientUtils.addListenerForMultiF7((KDBizPromptBox)this.kDBizMaterialFrom, (KDBizPromptBox)this.kDBizMaterialTo);
    }

    private void comboGroupStandard_itemStateChanged(ItemEvent e) {
        Object o = e.getItem();
        MaterialGroupStandardInfo groupInfo = null;
        if (o != null && o instanceof MaterialGroupStandardInfo) {
            groupInfo = (MaterialGroupStandardInfo)o;
        }
        if (this.bizMaterialTypeFrom.getValue() != null || this.bizMaterialTypeTo.getValue() != null) {
            this.bizMaterialTypeFrom.setValue(null);
            this.bizMaterialTypeTo.setValue(null);
        }
        if (groupInfo != null) {
            IMRptUtils.setBizMaterialGroup(this.bizMaterialTypeFrom, groupInfo.getId().toString());
            IMRptUtils.setBizMaterialGroup(this.bizMaterialTypeTo, groupInfo.getId().toString());
        }
    }

    private void kDCheckInCludeLocation_actionPerformed(ItemEvent arg0) {
        if (this.kDCheckInCludeLocation.isSelected()) {
            this.kDCheckInCluWarehs.setSelected(true);
        }
    }

    private void kDCheckInCluWarehs_actionPerformed(ItemEvent e) {
        if (!this.kDCheckInCluWarehs.isSelected() && this.kDCheckInCludeLocation.isSelected()) {
            this.kDCheckInCluWarehs.setSelected(true);
        }
    }

    protected void kDBizWarehs_willShow(SelectorEvent e) {
        this.storageOrgUnitCheck();
    }

    protected void storageOrgUnitCheck() {
        Object[] storageOrg;
        if (this.kDBizStorage.getValue() == null || ((Object[])this.kDBizStorage.getValue()).length == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"storageOrgUnitNotNull"));
            SysUtil.abort();
        } else if (((Object[])this.kDBizStorage.getValue()).length == 1 && ((storageOrg = (Object[])this.kDBizStorage.getValue())[0] == null || storageOrg[0].toString().length() == 0)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"storageOrgUnitNotNull"));
            SysUtil.abort();
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public boolean verify() {
        if (this.kDBizStorage.getText() == null || this.kDBizStorage.getText().length() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"storageOrgUnitNotNull"));
            return false;
        }
        String[] storageOrgIDs = new String[this.fullStorageOrgs.length];
        ArrayList<String> orgIdStrList = new ArrayList<String>();
        int size = this.fullStorageOrgs.length;
        for (int i = 0; i < size; ++i) {
            storageOrgIDs[i] = ((FullOrgUnitInfo)this.fullStorageOrgs[i]).getId().toString();
            orgIdStrList.add(storageOrgIDs[i]);
        }
        try {
            if (!IMRptUtils.checkSameCurrency(storageOrgIDs)) {
                return false;
            }
            if ((Integer)this.kDTxtStayDateAbove.getValue() < 0) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"stayDaysAboveCannotBellowZero"));
                return false;
            }
            ArrayList<String> paramNumberList = new ArrayList<String>();
            paramNumberList.add("INM004");
            ArrayList paramList = ParamControlFactory.getRemoteInstance().getParamHashMapBatch(paramNumberList, orgIdStrList);
            ParamSimpleInfo paramInfo = null;
            HashSet<String> paramSet = new HashSet<String>();
            HashSet<String> trueNumber = new HashSet<String>();
            HashSet<String> falseNumber = new HashSet<String>();
            HashSet<String> allSet = new HashSet<String>();
            StringBuffer trueNumbers = new StringBuffer();
            StringBuffer falseNumbers = new StringBuffer();
            for (int i = 0; i < paramList.size(); ++i) {
                paramInfo = (ParamSimpleInfo)paramList.get(i);
                paramSet.add(paramInfo.getParamValue());
                if (paramInfo.getParamValue() != null && paramInfo.getParamValue().equals("true")) {
                    trueNumber.add(paramInfo.getOrgUnitPK().toString());
                    allSet.add(paramInfo.getOrgUnitPK().toString());
                    continue;
                }
                falseNumber.add(paramInfo.getOrgUnitPK().toString());
                allSet.add(paramInfo.getOrgUnitPK().toString());
            }
            EntityViewInfo entityView = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", allSet, CompareType.INCLUDE));
            entityView.getSelector().add(new SelectorItemInfo("name"));
            entityView.setFilter(filter);
            StorageOrgUnitCollection storageOrgUnitIInfo = StorageOrgUnitFactory.getRemoteInstance().getStorageOrgUnitCollection(entityView);
            for (int i = 0; i < storageOrgUnitIInfo.size(); ++i) {
                if (trueNumber.contains(storageOrgUnitIInfo.get(i).getId().toString())) {
                    trueNumbers.append(storageOrgUnitIInfo.get(i).getName());
                    trueNumbers.append("  \u3001");
                    continue;
                }
                falseNumbers.append(storageOrgUnitIInfo.get(i).getName());
                falseNumbers.append("  \u3001");
            }
            if (paramSet.size() > 1) {
                String errHeadStr = EASResource.getString((String)resClassName, (String)"MATERIALSTAY_STORAGE_INM004PARAM_NOTSAME");
                String trueStorge = EASResource.getString((String)resClassName, (String)"TrueSto");
                String falseStorge = EASResource.getString((String)resClassName, (String)"falseSto");
                StringBuffer bf = new StringBuffer();
                if (trueNumber.size() > 0) {
                    bf.append("\n");
                    bf.append(trueStorge);
                    bf.append("\n");
                    bf.append(trueNumbers.substring(0, trueNumbers.length() - 1));
                }
                bf.append("\n");
                if (falseNumber.size() > 0) {
                    bf.append("\n");
                    bf.append(falseStorge);
                    bf.append("\n");
                    bf.append(falseNumbers.substring(0, falseNumbers.length() - 1));
                }
                MsgBox.showDetailAndOK((Component)((Object)this), (String)errHeadStr, (String)bf.toString(), (int)1);
                return false;
            }
        }
        catch (Exception e) {
            super.handUIException((Throwable)e);
        }
        return true;
    }

    private static String getTitle() {
        return EASResource.getString((String)"promotInfoBox");
    }

    static /* synthetic */ Object[] access$202(MaterialStayRptFilterUI x0, Object[] x1) {
        x0.fullStorageOrgs = x1;
        return x1;
    }

    static /* synthetic */ Object[] access$402(MaterialStayRptFilterUI x0, Object[] x1) {
        x0.printStorageOrgs = x1;
        return x1;
    }

    static /* synthetic */ Object[] access$702(MaterialStayRptFilterUI x0, Object[] x1) {
        x0.selectWarehouses = x1;
        return x1;
    }
}

