/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.rpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.headfootdesigner.HeadFootModel;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestListener;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.framework.report.ICommRptBase;
import com.kingdee.eas.framework.report.client.CommRptBaseConditionUI;
import com.kingdee.eas.framework.report.util.KDTableUtil;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.scm.im.rpt.IMRptUtils;
import com.kingdee.eas.scm.im.rpt.OutTransactionGatherRptFacadeFactory;
import com.kingdee.eas.scm.im.rpt.client.AbstractOutTransactionGatherReportUI;
import com.kingdee.eas.scm.im.rpt.client.OutTransactionGatherConditionUI;
import com.kingdee.eas.util.client.EASResource;
import java.awt.event.ActionEvent;
import org.apache.log4j.Logger;

public class OutTransactionGatherReportUI
extends AbstractOutTransactionGatherReportUI {
    private static final Logger logger = CoreUIObject.getLogger(OutTransactionGatherReportUI.class);
    private String resource = "com.kingdee.eas.scm.im.rpt.IMRptResource";
    String[] qtyColumns = new String[]{"qty"};
    String[] priceColumns = new String[]{"unitActualCost", "price"};
    String[] amountColumns = new String[]{"actualCost", "amount"};
    FullOrgUnitCollection allOrgs = null;

    public OutTransactionGatherReportUI() throws Exception {
        this.kdTable.checkParsed();
        this.kdTable.getDataRequestManager().addDataRequestListener((KDTDataRequestListener)this);
        this.kdTable.getDataRequestManager().setDataRequestMode(1);
        this.enableExportExcel(this.kdTable);
        this.setColumnDisplayFormat();
    }

    private void setColumnDisplayFormat() {
        int index;
        int qIndex = this.qtyColumns.length;
        int priceIndex = this.priceColumns.length;
        int amountIndex = this.amountColumns.length;
        String formatString = null;
        IColumn selectCol = null;
        for (index = 0; index < qIndex; ++index) {
            selectCol = this.kdTable.getColumn(this.qtyColumns[index]);
            formatString = "###,###.0000;-###,###.0000;;";
            selectCol.getStyleAttributes().setNumberFormat(formatString);
        }
        for (index = 0; index < priceIndex; ++index) {
            selectCol = this.kdTable.getColumn(this.priceColumns[index]);
            formatString = "###,###.000000;-###,###.000000;;";
            selectCol.getStyleAttributes().setNumberFormat(formatString);
        }
        for (index = 0; index < amountIndex; ++index) {
            selectCol = this.kdTable.getColumn(this.amountColumns[index]);
            formatString = "###,###.00;-###,###.00;;";
            selectCol.getStyleAttributes().setNumberFormat(formatString);
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void actionPageSetup_actionPerformed(ActionEvent e) throws Exception {
        super.actionPageSetup_actionPerformed(e);
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    public void actionHelp_actionPerformed(ActionEvent e) throws Exception {
        super.actionHelp_actionPerformed(e);
    }

    public void actionAbout_actionPerformed(ActionEvent e) throws Exception {
        super.actionAbout_actionPerformed(e);
    }

    public void actionOnLoad_actionPerformed(ActionEvent e) throws Exception {
        super.actionOnLoad_actionPerformed(e);
    }

    public void actionSendMessage_actionPerformed(ActionEvent e) throws Exception {
        super.actionSendMessage_actionPerformed(e);
    }

    public void actionCalculator_actionPerformed(ActionEvent e) throws Exception {
        super.actionCalculator_actionPerformed(e);
    }

    public void actionExport_actionPerformed(ActionEvent e) throws Exception {
        super.actionExport_actionPerformed(e);
    }

    public void actionExportSelected_actionPerformed(ActionEvent e) throws Exception {
        super.actionExportSelected_actionPerformed(e);
    }

    public void actionRegProduct_actionPerformed(ActionEvent e) throws Exception {
        super.actionRegProduct_actionPerformed(e);
    }

    public void actionPersonalSite_actionPerformed(ActionEvent e) throws Exception {
        super.actionPersonalSite_actionPerformed(e);
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        super.actionQuery_actionPerformed(e);
    }

    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        this.checkCanPrint();
        super.actionPrint_actionPerformed(e);
    }

    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        this.checkCanPrint();
        super.actionPrintPreview_actionPerformed(e);
    }

    private void checkCanPrint() {
        if (this.allOrgs != null) {
            int size = this.allOrgs.size();
            for (int index = 0; index < size; ++index) {
                IMRptUtils.checkHasAuthorized(this.allOrgs.get(index).getId().toString(), OrgType.Storage, "OutTransactionGatherReport_print");
            }
        }
    }

    public void actionChart_actionPerformed(ActionEvent e) throws Exception {
        super.actionChart_actionPerformed(e);
    }

    protected ICommRptBase getRemoteInstance() throws BOSException {
        return OutTransactionGatherRptFacadeFactory.getRemoteInstance();
    }

    protected KDTable getTableForPrintSetting() {
        return this.kdTable;
    }

    protected RptParams getParamsForInit() {
        return null;
    }

    protected CommRptBaseConditionUI getQueryDialogUserPanel() throws Exception {
        OutTransactionGatherConditionUI condUI = new OutTransactionGatherConditionUI();
        condUI.setSize(430, 300);
        return condUI;
    }

    protected void query() {
        this.kdTable.removeRows();
    }

    public void tableDataRequest(KDTDataRequestEvent e) {
        try {
            if (this.params.getObject("permmisionOrgs") != null) {
                this.allOrgs = (FullOrgUnitCollection)this.params.getObject("permmisionOrgs");
            }
            int from = e.getFirstRow();
            int len = e.getLastRow() - from + 1;
            if (from == 0) {
                this.params = OutTransactionGatherRptFacadeFactory.getRemoteInstance().createTempTable(this.params);
            }
            this.setDisplayStatColumnNames();
            RptParams rpt = OutTransactionGatherRptFacadeFactory.getRemoteInstance().query(this.params, from, len);
            RptRowSet rs = (RptRowSet)rpt.getObject("rowset");
            KDTableUtil.insertRows((RptRowSet)rs, (int)from, (KDTable)this.kdTable);
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
        this.setMergeColumn(this.kdTable);
    }

    private void setDisplayStatColumnNames() {
        if (this.params.getBoolean("isStatByDepart")) {
            this.kdTable.getHead().getRow(0).getCell(3).setValue((Object)this.getResource("department"));
            this.kdTable.getHead().getRow(0).getCell(4).setValue((Object)this.getResource("department"));
        } else {
            this.kdTable.getHead().getRow(0).getCell(3).setValue((Object)this.getResource("transactionType"));
            this.kdTable.getHead().getRow(0).getCell(4).setValue((Object)this.getResource("transactionType"));
        }
    }

    private String getResource(String strKey) {
        if (strKey == null || strKey.trim().length() == 0) {
            return null;
        }
        return EASResource.getString((String)this.resource, (String)strKey);
    }

    private void setMergeColumn(KDTable kdTable) {
        String[] mergeColumnKeys = new String[]{"materialNum", "materialName", "materialMode", "stateProjectNum", "stateProjectName"};
        if (mergeColumnKeys != null && mergeColumnKeys.length > 0) {
            kdTable.checkParsed();
            kdTable.getGroupManager().setGroup(true);
            for (int i = 0; i < mergeColumnKeys.length; ++i) {
                kdTable.getColumn(mergeColumnKeys[i]).setGroup(true);
                kdTable.getColumn(mergeColumnKeys[i]).setMergeable(true);
            }
        }
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.kdTable.setEditable(false);
        this.kdTable.getActionMap().remove("Delete");
        int count = this.kdTable.getColumnCount();
        if (count > 4) {
            this.kdTable.getViewManager().setFreezeView(-1, 5);
        }
    }

    protected void preparePrintPageHeader(HeadFootModel header) {
    }
}

