/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.rpt.client;

import com.kingdee.bos.ctrl.kdf.headfootdesigner.HeadFootModel;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.util.SCMConstant;
import com.kingdee.eas.scm.im.inv.StockTransferBillFactory;
import com.kingdee.eas.scm.im.inv.TransferOrderBillFactory;
import com.kingdee.eas.scm.im.inv.client.InvClientUtils;
import com.kingdee.eas.scm.im.inv.client.StockTransferBillEditUI;
import com.kingdee.eas.scm.im.inv.client.TransferOrderBillEditUI;
import com.kingdee.eas.scm.im.rpt.client.AbstractStockTransferRptDetailUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

public class StockTransferRptDetailUI
extends AbstractStockTransferRptDetailUI {
    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected String getEditUIName() {
        if (this.getSelectedKeyValue() != null && SCMConstant.BOSTYPE_TRANSFERORDER.equalsIgnoreCase(BOSUuid.read((String)this.getSelectedKeyValue()).getType().toString())) {
            return TransferOrderBillEditUI.class.getName();
        }
        return StockTransferBillEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        if (this.getSelectedKeyValue() != null && SCMConstant.BOSTYPE_TRANSFERORDER.equalsIgnoreCase(BOSUuid.read((String)this.getSelectedKeyValue()).getType().toString())) {
            return TransferOrderBillFactory.getRemoteInstance();
        }
        return StockTransferBillFactory.getRemoteInstance();
    }

    protected FilterInfo getDefaultFilterForQuery() {
        Object materialID = this.getUIContext().get("MATERIALID");
        Object issueOrgID = this.getUIContext().get("ISSUEORGID");
        Object receiptOrgID = this.getUIContext().get("RECEIPTORGID");
        Object dateFrom = this.getUIContext().get("dateFrom");
        Object dateTo = this.getUIContext().get("dateTo");
        FilterInfo filter = new FilterInfo();
        if (materialID != null) {
            filter.getFilterItems().add(new FilterItemInfo("material.id", (Object)materialID.toString()));
        }
        if (issueOrgID != null) {
            filter.getFilterItems().add(new FilterItemInfo("issueStorageOrgUnit.id", (Object)issueOrgID.toString()));
        }
        if (receiptOrgID != null) {
            filter.getFilterItems().add(new FilterItemInfo("recStoUnit", (Object)receiptOrgID.toString()));
        }
        if (dateFrom != null) {
            filter.getFilterItems().add(new FilterItemInfo("bizDate", dateFrom, CompareType.GREATER_EQUALS));
        }
        if (dateTo != null) {
            filter.getFilterItems().add(new FilterItemInfo("bizDate", dateTo, CompareType.LESS_EQUALS));
        }
        return filter;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        Object temp = this.getUIContext().get("MATERIALNAME");
        if (temp != null) {
            this.txtMaterialName.setText(temp.toString());
        }
        if ((temp = this.getUIContext().get("MATERIALNUM")) != null) {
            this.txtMaterialNum.setText(temp.toString());
        }
        if ((temp = this.getUIContext().get("ISSUEORGNAME")) != null) {
            this.txtIssueOrg.setText(temp.toString());
        }
        if ((temp = this.getUIContext().get("RECEIPTORGNAME")) != null) {
            this.txtReceiptOrg.setText(temp.toString());
        }
        this.btnView.setIcon(EASResource.getIcon((String)"imgTbtn_bill"));
    }

    public String getUITitle() {
        return InvClientUtils.getResource("stockTransDetail");
    }

    protected void getRowSetBeforeFillTable(IRowSet rowSet) {
        int basePre = 2;
        int assPre = 2;
        int unitPre = 2;
        String[] QTY_COLUMNS = new String[]{"entry.qty", "entry.issueQty", "entry.receiptQty"};
        String[] BASEQTY_COLLUMNS = new String[]{"entry.baseQty", "entry.receiptBaseQty", "entry.issueBaseQty"};
        String assCol = "entry.assistQty";
        try {
            while (rowSet.next()) {
                unitPre = rowSet.getInt("mulUnit.qtyPrecision");
                basePre = rowSet.getInt("mulBaseUnit.qtyPrecision");
                assPre = rowSet.getInt("mulAssistUnit.qtyPrecision");
                SCMClientUtils.iniColumnsPrecision((int)unitPre, (String[])QTY_COLUMNS, (IRowSet)rowSet);
                SCMClientUtils.iniColumnsPrecision((int)basePre, (String[])BASEQTY_COLLUMNS, (IRowSet)rowSet);
                SCMClientUtils.iniColumnsPrecision((int)assPre, (String)assCol, (IRowSet)rowSet);
            }
        }
        catch (SQLException ex) {
            this.handUIException(ex);
        }
    }

    protected void preparePrintPageHeader(HeadFootModel header) {
        StyleAttributes sa = Styles.getDefaultSA();
        StringBuffer sb = new StringBuffer();
        sb.append(EASResource.getString((String)"com.kingdee.eas.scm.im.rpt.IMRptResource", (String)"materialName")).append(": ").append(this.getUIContext().get("MATERIALNAME"));
        sb.append("&|").append(EASResource.getString((String)"com.kingdee.eas.scm.im.rpt.IMRptResource", (String)"materialNumber")).append(": ").append(this.getUIContext().get("MATERIALNUM"));
        sb.append("&|\u3000&|");
        header.addRow(sb.toString(), sa);
        sb = new StringBuffer();
        sb.append(EASResource.getString((String)"com.kingdee.eas.scm.im.rpt.IMRptResource", (String)"issueStorageOrg")).append(": ").append(this.getUIContext().get("ISSUEORGNAME"));
        sb.append("&|").append(EASResource.getString((String)"com.kingdee.eas.scm.im.rpt.IMRptResource", (String)"inWarehsStorageOrg")).append(": ").append(this.getUIContext().get("RECEIPTORGNAME"));
        sb.append("&|\u3000&|");
        header.addRow(sb.toString(), sa);
    }

    protected boolean isAllowLoadPrintSetting() {
        return false;
    }

    protected Map preparePrintVariantMap() {
        HashMap map = new HashMap();
        map.put("MATERIALNAME", this.getUIContext().get("MATERIALNAME"));
        map.put("MATERIALNUM", this.getUIContext().get("MATERIALNUM"));
        map.put("ISSUEORGNAME", this.getUIContext().get("ISSUEORGNAME"));
        map.put("RECEIPTORGNAME", this.getUIContext().get("RECEIPTORGNAME"));
        return map;
    }
}

