/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.pur;

import com.kingdee.eas.scm.sm.pur.QuotaVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class QuotaVOCollection
implements Serializable {
    private static final long serialVersionUID = 1L;
    private List<QuotaVO> items = new ArrayList<QuotaVO>();

    public QuotaVO getQuotaVO(int index) {
        return this.items.get(index);
    }

    public void addQuotaVO(QuotaVO quotaVO) {
        if (quotaVO != null) {
            this.items.add(quotaVO);
        }
    }

    public void merge(QuotaVOCollection voCol) {
        if (voCol != null) {
            for (int i = 0; i < voCol.size(); ++i) {
                this.addQuotaVO(voCol.getQuotaVO(i));
            }
        }
    }

    public int size() {
        return this.items.size();
    }

    public void sort() {
        Collections.sort(this.items);
        String lastEntryId = null;
        for (int i = 0; i < this.items.size(); ++i) {
            QuotaVO quotaVO = this.items.get(i);
            if (lastEntryId == null || !lastEntryId.equals(quotaVO.getSrcBillEntryId())) {
                quotaVO.setFirstPerEntry(true);
            }
            lastEntryId = quotaVO.getSrcBillEntryId();
        }
    }

    public String toString() {
        StringBuffer displayMsg = new StringBuffer();
        displayMsg.append("QuotaVOCollection: {");
        for (int i = 0; i < this.items.size(); ++i) {
            displayMsg.append("item ").append(i).append(": ");
            displayMsg.append(this.items.get(i)).append(" \n");
        }
        displayMsg.append("} \n ");
        return displayMsg.toString();
    }

    public void sortForWeb() {
        Collections.sort(this.items, new Comparator(){

            public int compare(Object o1, Object o2) {
                if (((QuotaVO)o2).getNumber().toString().compareTo(((QuotaVO)o1).getNumber().toString()) > 0) {
                    return 1;
                }
                if (((QuotaVO)o2).getNumber().toString().compareTo(((QuotaVO)o1).getNumber().toString()) == 0) {
                    return ((QuotaVO)o1).getEntrySeq().toString().compareTo(((QuotaVO)o2).getEntrySeq().toString());
                }
                return -1;
            }
        });
    }

    public void sortForQty() {
        Collections.sort(this.items, new Comparator(){

            public int compare(Object o1, Object o2) {
                if (((QuotaVO)o2).getUnAssBaseOrderQty().compareTo(((QuotaVO)o1).getUnAssBaseOrderQty()) > 0) {
                    return 1;
                }
                return -1;
            }
        });
    }
}

