/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.pur.calculate;

import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.eas.basedata.scm.common.DiscountModeEnum;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.SCMBillEntryBaseInfo;
import com.kingdee.eas.scm.common.util.CalculateUtils;
import com.kingdee.eas.scm.sm.pur.calculate.ICal;
import com.kingdee.util.enums.IntEnum;
import java.math.BigDecimal;
import org.apache.log4j.Logger;

public abstract class AbstractCal
implements ICal {
    private static Logger logger = Logger.getLogger(AbstractCal.class);
    public String NULL;
    protected String PRICE;
    protected String TAXPRICE;
    private String ACTUALPRICE;
    private String ACTUALTAXPRICE;
    private String AMOUNT;
    private String LOCALAMOUNT;
    private String TAXAMOUNT;
    private String LOCALTAXAMOUNT;
    private String TAX;
    private String DISCOUNTAMOUNT;
    private String CONTAINTAX;
    protected String ISPRICE_EXCLUDE_TAX;
    protected String TAXRATE;
    private String QTY;
    private String DISCOUNTTYPE;
    private String DISCOUNT;
    private String HEAD_AMOUNT;
    private String HEAD_LOCALAMOUNT;
    private String HEAD_TAXAMOUNT;
    private String HEAD_LOCALTAXAMOUNT;
    private String HEAD_TAX;
    private int PRICE_PRECISION;
    private int CURRENY_PRECISION;
    private int MULUNIT_PRECISION;
    private int TAX_PRECISION;
    private int DISCOUNT_PRECISION;
    private int amoutScale;
    private boolean isInTax;
    protected BigDecimal ZERO;
    protected BigDecimal one;
    protected BigDecimal oneHundred;

    public AbstractCal() {
        this.PRICE = this.NULL = "null";
        this.TAXPRICE = this.NULL;
        this.ACTUALPRICE = this.NULL;
        this.ACTUALTAXPRICE = this.NULL;
        this.AMOUNT = this.NULL;
        this.LOCALAMOUNT = this.NULL;
        this.TAXAMOUNT = this.NULL;
        this.LOCALTAXAMOUNT = this.NULL;
        this.TAX = this.NULL;
        this.DISCOUNTAMOUNT = this.NULL;
        this.CONTAINTAX = this.NULL;
        this.ISPRICE_EXCLUDE_TAX = this.NULL;
        this.TAXRATE = this.NULL;
        this.QTY = this.NULL;
        this.DISCOUNTTYPE = this.NULL;
        this.DISCOUNT = this.NULL;
        this.HEAD_AMOUNT = this.NULL;
        this.HEAD_LOCALAMOUNT = this.NULL;
        this.HEAD_TAXAMOUNT = this.NULL;
        this.HEAD_LOCALTAXAMOUNT = this.NULL;
        this.HEAD_TAX = this.NULL;
        this.PRICE_PRECISION = 4;
        this.CURRENY_PRECISION = 4;
        this.MULUNIT_PRECISION = 4;
        this.TAX_PRECISION = 4;
        this.DISCOUNT_PRECISION = 4;
        this.amoutScale = 2;
        this.isInTax = false;
        this.ZERO = new BigDecimal("0.00");
        this.one = new BigDecimal("1.0");
        this.oneHundred = new BigDecimal("100.0");
    }

    public int getAmoutscale() {
        return this.amoutScale;
    }

    public void setAmoutscale(int amoutScale) {
        this.amoutScale = amoutScale;
    }

    public String getTAXRATE() {
        return this.TAXRATE;
    }

    public void setTAXRATE(String taxrate) {
        this.TAXRATE = taxrate;
    }

    public String getPRICE() {
        return this.PRICE;
    }

    public void setPRICE(String price) {
        this.PRICE = price;
    }

    public String getTAXPRICE() {
        return this.TAXPRICE;
    }

    public void setTAXPRICE(String taxprice) {
        this.TAXPRICE = taxprice;
    }

    public String getACTUALPRICE() {
        return this.ACTUALPRICE;
    }

    public void setACTUALPRICE(String actualprice) {
        this.ACTUALPRICE = actualprice;
    }

    public String getACTUALTAXPRICE() {
        return this.ACTUALTAXPRICE;
    }

    public void setACTUALTAXPRICE(String actualtaxprice) {
        this.ACTUALTAXPRICE = actualtaxprice;
    }

    public String getAMOUNT() {
        return this.AMOUNT;
    }

    public void setAMOUNT(String amount) {
        this.AMOUNT = amount;
    }

    public String getLOCALAMOUNT() {
        return this.LOCALAMOUNT;
    }

    public void setLOCALAMOUNT(String lOCALAMOUNT) {
        this.LOCALAMOUNT = lOCALAMOUNT;
    }

    public String getLOCALTAXAMOUNT() {
        return this.LOCALTAXAMOUNT;
    }

    public void setLOCALTAXAMOUNT(String lOCALTAXAMOUNT) {
        this.LOCALTAXAMOUNT = lOCALTAXAMOUNT;
    }

    public String getTAXAMOUNT() {
        return this.TAXAMOUNT;
    }

    public void setTAXAMOUNT(String taxamount) {
        this.TAXAMOUNT = taxamount;
    }

    public String getTAX() {
        return this.TAX;
    }

    public void setTAX(String tax) {
        this.TAX = tax;
    }

    public String getDISCOUNTAMOUNT() {
        return this.DISCOUNTAMOUNT;
    }

    public void setDISCOUNTAMOUNT(String discountamount) {
        this.DISCOUNTAMOUNT = discountamount;
    }

    public String getCONTAINTAX() {
        return this.CONTAINTAX;
    }

    public void setCONTAINTAX(String containtax) {
        this.CONTAINTAX = containtax;
    }

    public String getISPRICE_EXCLUDE_TAX() {
        return this.ISPRICE_EXCLUDE_TAX;
    }

    public void setISPRICE_EXCLUDE_TAX(String isprice_exclude_tax) {
        this.ISPRICE_EXCLUDE_TAX = isprice_exclude_tax;
    }

    public String getQTY() {
        return this.QTY;
    }

    public void setQTY(String qty) {
        this.QTY = qty;
    }

    public String getDISCOUNTTYPE() {
        return this.DISCOUNTTYPE;
    }

    public void setDISCOUNTTYPE(String discounttype) {
        this.DISCOUNTTYPE = discounttype;
    }

    public String getDISCOUNT() {
        return this.DISCOUNT;
    }

    public void setDISCOUNT(String discount) {
        this.DISCOUNT = discount;
    }

    public String getHEAD_AMOUNT() {
        return this.HEAD_AMOUNT;
    }

    public void setHEAD_AMOUNT(String head_amount) {
        this.HEAD_AMOUNT = head_amount;
    }

    public String getHEAD_TAXAMOUNT() {
        return this.HEAD_TAXAMOUNT;
    }

    public void setHEAD_TAXAMOUNT(String head_taxamount) {
        this.HEAD_TAXAMOUNT = head_taxamount;
    }

    public String getHEAD_TAX() {
        return this.HEAD_TAX;
    }

    public void setHEAD_TAX(String head_tax) {
        this.HEAD_TAX = head_tax;
    }

    public String getHEAD_LOCALAMOUNT() {
        return this.HEAD_LOCALAMOUNT;
    }

    public void setHEAD_LOCALAMOUNT(String hEAD_LOCALAMOUNT) {
        this.HEAD_LOCALAMOUNT = hEAD_LOCALAMOUNT;
    }

    public String getHEAD_LOCALTAXAMOUNT() {
        return this.HEAD_LOCALTAXAMOUNT;
    }

    public void setHEAD_LOCALTAXAMOUNT(String hEAD_LOCALTAXAMOUNT) {
        this.HEAD_LOCALTAXAMOUNT = hEAD_LOCALTAXAMOUNT;
    }

    public int getPRICE_PRECISION() {
        return this.PRICE_PRECISION;
    }

    public void setPRICE_PRECISION(int pRICE_PRECISION) {
        this.PRICE_PRECISION = pRICE_PRECISION;
    }

    public int getCURRENY_PRECISION() {
        return this.CURRENY_PRECISION;
    }

    public void setCURRENY_PRECISION(int cURRENY_PRECISION) {
        this.CURRENY_PRECISION = cURRENY_PRECISION;
    }

    public int getMULUNIT_PRECISION() {
        return this.MULUNIT_PRECISION;
    }

    public void setMULUNIT_PRECISION(int mULUNIT_PRECISION) {
        this.MULUNIT_PRECISION = mULUNIT_PRECISION;
    }

    public int getTAX_PRECISION() {
        return this.TAX_PRECISION;
    }

    public void setTAX_PRECISION(int tAX_PRECISION) {
        this.TAX_PRECISION = tAX_PRECISION;
    }

    public int getDISCOUNT_PRECISION() {
        return this.DISCOUNT_PRECISION;
    }

    public void setDISCOUNT_PRECISION(int dISCOUNT_PRECISION) {
        this.DISCOUNT_PRECISION = dISCOUNT_PRECISION;
    }

    protected abstract void initFiledValue();

    protected abstract AbstractObjectCollection getEntry(SCMBillBaseInfo var1);

    @Override
    public void calEntryPrice(SCMBillBaseInfo info, SCMBillEntryBaseInfo entryInfo) {
        boolean containTax = this.isInTax();
        if (!containTax) {
            return;
        }
        BigDecimal taxPrice = this.getEntryBigDecimalValue(entryInfo, this.TAXPRICE);
        BigDecimal taxRate = this.getEntryBigDecimalValue(entryInfo, this.TAXRATE);
        logger.error((Object)("@@@@\u8fdb\u5165\u8ba1\u7b97\u5355\u4ef7\u65b9\u6cd5calEntryPrice\uff0c\u7a0e\u7387=" + taxRate + ",\u542b\u7a0e\u5355\u4ef7=" + taxPrice + ",\u7a0e\u7387\u5b57\u6bb5\u540d=" + this.TAXRATE));
        int scale = taxPrice.scale();
        BigDecimal price = null;
        boolean is_price_exclude_tax = this.getHeadBooleanValue(info, this.ISPRICE_EXCLUDE_TAX);
        price = is_price_exclude_tax ? CalculateUtils.calPrice((BigDecimal)taxPrice, (BigDecimal)taxRate, (int)scale) : CalculateUtils.calPriceIsPriceInTax((BigDecimal)taxRate, (BigDecimal)taxPrice, (int)scale);
        entryInfo.put(this.PRICE, (Object)price);
    }

    @Override
    public void calEntryActualPrice(SCMBillBaseInfo info, SCMBillEntryBaseInfo entryInfo) {
        if (this.ACTUALPRICE == null) {
            return;
        }
        BigDecimal amount = this.getEntryBigDecimalValue(entryInfo, this.AMOUNT);
        BigDecimal qty = this.getEntryBigDecimalValue(entryInfo, this.QTY);
        BigDecimal discount = this.getEntryBigDecimalValue(entryInfo, this.DISCOUNT);
        BigDecimal price = this.getEntryBigDecimalValue(entryInfo, this.PRICE);
        int scale = this.getEntryBigDecimalValue(entryInfo, this.PRICE).scale();
        BigDecimal actualPrice = null;
        actualPrice = discount == null || discount != null && discount.compareTo(BigDecimal.ZERO) == 0 ? price : CalculateUtils.calActualPrice((BigDecimal)amount, (BigDecimal)qty, (int)scale);
        entryInfo.put(this.ACTUALPRICE, (Object)actualPrice);
    }

    @Override
    public void calEntryActualTaxPrice(SCMBillBaseInfo info, SCMBillEntryBaseInfo entryInfo) {
        if (this.ACTUALTAXPRICE == null) {
            return;
        }
        BigDecimal taxAmount = this.getEntryBigDecimalValue(entryInfo, this.TAXAMOUNT);
        BigDecimal qty = this.getEntryBigDecimalValue(entryInfo, this.QTY);
        BigDecimal discount = this.getEntryBigDecimalValue(entryInfo, this.DISCOUNT);
        BigDecimal taxPrice = this.getEntryBigDecimalValue(entryInfo, this.TAXPRICE);
        int scale = this.getEntryBigDecimalValue(entryInfo, this.PRICE).scale();
        BigDecimal actualTaxPrice = null;
        actualTaxPrice = discount == null || discount != null && discount.compareTo(BigDecimal.ZERO) == 0 ? taxPrice : CalculateUtils.calActualTaxPrice((BigDecimal)taxAmount, (BigDecimal)qty, (int)scale);
        entryInfo.put(this.ACTUALTAXPRICE, (Object)actualTaxPrice);
    }

    @Override
    public void calEntryAmount(SCMBillBaseInfo info, SCMBillEntryBaseInfo entryInfo) {
        boolean containTax = this.isInTax();
        BigDecimal taxAmount = this.getEntryBigDecimalValue(entryInfo, this.TAXAMOUNT);
        BigDecimal discount = this.getEntryBigDecimalValue(entryInfo, this.DISCOUNT);
        BigDecimal tax = this.getEntryBigDecimalValue(entryInfo, this.TAX);
        BigDecimal qty = this.getEntryBigDecimalValue(entryInfo, this.QTY);
        BigDecimal price = this.getEntryBigDecimalValue(entryInfo, this.PRICE);
        BigDecimal amount = this.ZERO;
        int scale = 2;
        scale = this.getEntryBigDecimalValue(entryInfo, this.TAXAMOUNT).scale();
        DiscountModeEnum discountType = (DiscountModeEnum)this.getEntryEnum(entryInfo, this.DISCOUNTTYPE);
        if (discountType == null) {
            discountType = DiscountModeEnum.PERCENT;
        }
        amount = containTax ? CalculateUtils.calAmountInTax((BigDecimal)taxAmount, (BigDecimal)tax, (int)scale) : (discountType.equals((Object)DiscountModeEnum.PERCENT) ? CalculateUtils.calAmountByDiscountPercent((BigDecimal)qty, (BigDecimal)price, (BigDecimal)discount, (int)scale) : CalculateUtils.calAmountByDiscountAmount((BigDecimal)qty, (BigDecimal)price, (BigDecimal)discount, (int)scale));
        entryInfo.put(this.AMOUNT, (Object)amount);
    }

    @Override
    public void calEntryDiscountAmount(SCMBillBaseInfo info, SCMBillEntryBaseInfo entryInfo) {
        boolean containTax = this.isInTax();
        BigDecimal qty = this.getEntryBigDecimalValue(entryInfo, this.QTY);
        BigDecimal taxPrice = this.getEntryBigDecimalValue(entryInfo, this.TAXPRICE);
        BigDecimal taxRate = this.getEntryBigDecimalValue(entryInfo, this.TAXRATE);
        BigDecimal discount = this.getEntryBigDecimalValue(entryInfo, this.DISCOUNT);
        BigDecimal discountAmount = this.ZERO;
        int scale = 2;
        scale = this.getEntryBigDecimalValue(entryInfo, this.TAXAMOUNT).scale();
        DiscountModeEnum discountType = (DiscountModeEnum)this.getEntryEnum(entryInfo, this.DISCOUNTTYPE);
        if (discountType == null) {
            discountType = DiscountModeEnum.PERCENT;
        }
        discountAmount = discountType.equals((Object)DiscountModeEnum.PERCENT) ? CalculateUtils.calDiscountAmountByPercent((BigDecimal)discount, (BigDecimal)qty, (BigDecimal)taxPrice, (int)scale) : CalculateUtils.calDiscountAmountByPerunit((BigDecimal)discount, (BigDecimal)qty, (BigDecimal)taxRate, (int)scale, (boolean)containTax);
        entryInfo.put(this.DISCOUNTAMOUNT, (Object)discountAmount);
    }

    @Override
    public void calEntryTax(SCMBillBaseInfo info, SCMBillEntryBaseInfo entryInfo) {
        boolean is_price_exclude_tax;
        boolean containTax = this.isInTax();
        BigDecimal amount = this.getEntryBigDecimalValue(entryInfo, this.AMOUNT);
        BigDecimal taxAmount = this.getEntryBigDecimalValue(entryInfo, this.TAXAMOUNT);
        BigDecimal taxRate = this.getEntryBigDecimalValue(entryInfo, this.TAXRATE);
        BigDecimal tax = this.ZERO;
        int scale = this.getAmoutscale();
        tax = containTax ? ((is_price_exclude_tax = this.getHeadBooleanValue(info, this.ISPRICE_EXCLUDE_TAX)) ? CalculateUtils.calTaxWhenPriceExludeTax((BigDecimal)taxAmount, (BigDecimal)taxRate, (int)scale) : CalculateUtils.calTaxWhenPriceInludeTax((BigDecimal)taxAmount, (BigDecimal)taxRate, (int)scale)) : CalculateUtils.calTax((BigDecimal)amount, (BigDecimal)taxRate, (int)scale);
        entryInfo.put(this.TAX, (Object)tax);
    }

    @Override
    public void calEntryTaxAmount(SCMBillBaseInfo info, SCMBillEntryBaseInfo entryInfo) {
        boolean containTax = this.isInTax();
        BigDecimal qty = this.getEntryBigDecimalValue(entryInfo, this.QTY);
        BigDecimal taxPrice = this.getEntryBigDecimalValue(entryInfo, this.TAXPRICE);
        BigDecimal discount = this.getEntryBigDecimalValue(entryInfo, this.DISCOUNT);
        BigDecimal taxAmount = this.ZERO;
        int scale = 2;
        scale = this.getEntryBigDecimalValue(entryInfo, this.AMOUNT).compareTo(this.ZERO) == 0 ? this.getAmoutscale() : this.getEntryBigDecimalValue(entryInfo, this.AMOUNT).scale();
        DiscountModeEnum discountType = (DiscountModeEnum)this.getEntryEnum(entryInfo, this.DISCOUNTTYPE);
        if (discountType == null) {
            discountType = DiscountModeEnum.PERCENT;
        }
        if (containTax) {
            taxAmount = discountType.equals((Object)DiscountModeEnum.PERCENT) ? this.calTotalTaxAmountByDiscountPercent(qty, taxPrice, discount, scale) : CalculateUtils.calTotalTaxAmountByDiscountAmount((BigDecimal)qty, (BigDecimal)taxPrice, (BigDecimal)discount, (int)scale);
        } else {
            BigDecimal amount = this.getEntryBigDecimalValue(entryInfo, this.AMOUNT);
            BigDecimal tax = this.getEntryBigDecimalValue(entryInfo, this.TAX);
            taxAmount = CalculateUtils.calTotalTaxAmount((BigDecimal)amount, (BigDecimal)tax, (int)scale);
        }
        entryInfo.put(this.TAXAMOUNT, (Object)taxAmount);
    }

    public BigDecimal calTotalTaxAmountByDiscountPercent(BigDecimal qty, BigDecimal taxPrice, BigDecimal discount, int scale) {
        BigDecimal zero = new BigDecimal("0.0");
        BigDecimal one = new BigDecimal("1.0");
        BigDecimal oneHundred = new BigDecimal("100.0");
        BigDecimal discountAmount = new BigDecimal("0.0");
        qty = qty == null ? zero : qty;
        taxPrice = taxPrice == null ? zero : taxPrice;
        discountAmount = taxPrice.multiply(qty).multiply(discount).divide(oneHundred, 10, 4);
        BigDecimal totalTaxAmount = taxPrice.multiply(qty).subtract(discountAmount).divide(one, scale, 4);
        return totalTaxAmount;
    }

    @Override
    public void calEntryTaxPrice(SCMBillBaseInfo info, SCMBillEntryBaseInfo entryInfo) {
        BigDecimal price = this.getEntryBigDecimalValue(entryInfo, this.PRICE);
        BigDecimal taxRate = this.getEntryBigDecimalValue(entryInfo, this.TAXRATE);
        int scale = price.scale();
        BigDecimal taxPrice = CalculateUtils.calTaxPrice((BigDecimal)price, (BigDecimal)taxRate, (int)scale);
        entryInfo.put(this.TAXPRICE, (Object)taxPrice);
    }

    @Override
    public void calTotalAmount(SCMBillBaseInfo info, SCMBillEntryBaseInfo entryInfo) {
        BigDecimal totalAmount = this.ZERO;
        SCMBillEntryBaseInfo temp_entryInfo = null;
        for (int i = 0; i < this.getEntry(info).size(); ++i) {
            temp_entryInfo = (SCMBillEntryBaseInfo)this.getEntry(info).getObject(i);
            totalAmount = totalAmount.add(this.getEntryBigDecimalValue(temp_entryInfo, this.AMOUNT));
        }
        info.put(this.HEAD_AMOUNT, (Object)totalAmount);
    }

    public void calLocalTotalAmount(SCMBillBaseInfo info, SCMBillEntryBaseInfo entryInfo) {
    }

    @Override
    public void calTotalTax(SCMBillBaseInfo info, SCMBillEntryBaseInfo entryInfo) {
        BigDecimal totalTax = this.ZERO;
        SCMBillEntryBaseInfo temp_entryInfo = null;
        for (int i = 0; i < this.getEntry(info).size(); ++i) {
            temp_entryInfo = (SCMBillEntryBaseInfo)this.getEntry(info).getObject(i);
            totalTax = totalTax.add(this.getEntryBigDecimalValue(temp_entryInfo, this.TAX));
        }
        info.put(this.HEAD_TAX, (Object)totalTax);
    }

    @Override
    public void calTotalTaxAmount(SCMBillBaseInfo info, SCMBillEntryBaseInfo entryInfo) {
        BigDecimal totalTaxAmount = this.ZERO;
        SCMBillEntryBaseInfo temp_entryInfo = null;
        for (int i = 0; i < this.getEntry(info).size(); ++i) {
            temp_entryInfo = (SCMBillEntryBaseInfo)this.getEntry(info).getObject(i);
            totalTaxAmount = totalTaxAmount.add(this.getEntryBigDecimalValue(temp_entryInfo, this.TAXAMOUNT));
        }
        info.put(this.HEAD_TAXAMOUNT, (Object)totalTaxAmount);
    }

    public void calLocalTotalTaxAmount(SCMBillBaseInfo info, SCMBillEntryBaseInfo entryInfo) {
    }

    @Override
    public void calEntryBaseQty(SCMBillBaseInfo info, SCMBillEntryBaseInfo entryInfo) {
    }

    @Override
    public void calEntryAssistQty(SCMBillBaseInfo info, SCMBillEntryBaseInfo entryInfo) {
    }

    protected BigDecimal getEntryBigDecimalValue(SCMBillEntryBaseInfo entryInfo, String fieldName) {
        if (fieldName.equals(this.NULL)) {
            return this.ZERO;
        }
        BigDecimal value = this.ZERO;
        if (entryInfo.get(fieldName) == null) {
            return value;
        }
        if (entryInfo.get(fieldName) instanceof BigDecimal) {
            value = (BigDecimal)entryInfo.get(fieldName);
        } else if (entryInfo.get(fieldName) instanceof Integer) {
            value = new BigDecimal(entryInfo.get(fieldName).toString());
        }
        return value;
    }

    protected boolean getHeadBooleanValue(SCMBillBaseInfo info, String fieldName) {
        return info.getBoolean(fieldName);
    }

    private IntEnum getEntryEnum(SCMBillEntryBaseInfo entryInfo, String fieldName) {
        if (fieldName.equals(this.NULL)) {
            return null;
        }
        IntEnum enums = (IntEnum)entryInfo.get(fieldName);
        if (enums == null) {
            return null;
        }
        return enums;
    }

    @Override
    public boolean isInTax() {
        return this.isInTax;
    }

    @Override
    public void setInTax(boolean isInTax) {
        this.isInTax = isInTax;
    }

    @Override
    public void calByEntryTaxPriceChange(SCMBillBaseInfo info, SCMBillEntryBaseInfo entryInfo) {
        this.calEntryPrice(info, entryInfo);
        this.calEntryTaxAmount(info, entryInfo);
        this.calEntryTax(info, entryInfo);
        this.calEntryAmount(info, entryInfo);
        this.calEntryActualPrice(info, entryInfo);
        this.calEntryActualTaxPrice(info, entryInfo);
        this.calEntryDiscountAmount(info, entryInfo);
        this.calTotalAmount(info, entryInfo);
        this.calTotalTax(info, entryInfo);
        this.calTotalTaxAmount(info, entryInfo);
        this.calLocalTotalAmount(info, entryInfo);
        this.calLocalTotalTaxAmount(info, entryInfo);
    }

    @Override
    public void calByEntryPriceChange(SCMBillBaseInfo info, SCMBillEntryBaseInfo entryInfo) {
        this.calEntryTaxPrice(info, entryInfo);
        this.calEntryDiscountAmount(info, entryInfo);
        this.calEntryAmount(info, entryInfo);
        this.calEntryActualPrice(info, entryInfo);
        this.calEntryTax(info, entryInfo);
        this.calEntryTaxAmount(info, entryInfo);
        this.calEntryActualTaxPrice(info, entryInfo);
        this.calTotalAmount(info, entryInfo);
        this.calTotalTax(info, entryInfo);
        this.calTotalTaxAmount(info, entryInfo);
        this.calLocalTotalAmount(info, entryInfo);
        this.calLocalTotalTaxAmount(info, entryInfo);
    }
}

