/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.pur.calculate;

import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.SCMBillEntryBaseInfo;
import com.kingdee.eas.scm.common.util.CalculateUtils;
import com.kingdee.eas.scm.sm.pur.PurRequestEntryInfo;
import com.kingdee.eas.scm.sm.pur.PurRequestInfo;
import com.kingdee.eas.scm.sm.pur.calculate.PurRequestCal;
import java.math.BigDecimal;

public class PurRequestBatchEditCal
extends PurRequestCal {
    private int DEFAULT_PRECISION = 10;
    private BigDecimal oldHeadValue = this.ZERO;
    private BigDecimal oldEntryValue = this.ZERO;
    private BigDecimal newHeadValue = this.ZERO;
    private BigDecimal newEntryValue = this.ZERO;

    protected BigDecimal validateNullValue(BigDecimal value) {
        if (value == null) {
            return this.ZERO;
        }
        return value;
    }

    @Override
    public void calTotalAmount(SCMBillBaseInfo info, SCMBillEntryBaseInfo entryInfo) {
        this.oldHeadValue = info.getBigDecimal(this.getHEAD_AMOUNT());
        this.oldEntryValue = entryInfo.getBigDecimal("oldAmount");
        SCMBillEntryBaseInfo temp_entryInfo = (SCMBillEntryBaseInfo)this.getEntry(info).getObject(0);
        this.newEntryValue = this.getEntryBigDecimalValue(temp_entryInfo, this.getAMOUNT());
        this.newHeadValue = this.oldHeadValue.add(this.newEntryValue.subtract(this.oldEntryValue));
        info.put(this.getHEAD_AMOUNT(), (Object)this.newHeadValue);
    }

    @Override
    public void calLocalTotalAmount(SCMBillBaseInfo info, SCMBillEntryBaseInfo entryInfo) {
        this.oldHeadValue = info.getBigDecimal(this.getHEAD_LOCALAMOUNT());
        this.oldEntryValue = entryInfo.getBigDecimal("oldLocalAmount");
        SCMBillEntryBaseInfo temp_entryInfo = (SCMBillEntryBaseInfo)this.getEntry(info).getObject(0);
        this.newEntryValue = this.getEntryBigDecimalValue(temp_entryInfo, this.getLOCALAMOUNT());
        this.newHeadValue = this.oldHeadValue.add(this.newEntryValue.subtract(this.oldEntryValue));
        info.put(this.getHEAD_LOCALAMOUNT(), (Object)this.newHeadValue);
    }

    @Override
    public void calTotalTax(SCMBillBaseInfo info, SCMBillEntryBaseInfo entryInfo) {
        this.oldHeadValue = info.getBigDecimal(this.getHEAD_TAX());
        this.oldEntryValue = entryInfo.getBigDecimal("oldTax");
        SCMBillEntryBaseInfo temp_entryInfo = (SCMBillEntryBaseInfo)this.getEntry(info).getObject(0);
        this.newEntryValue = this.getEntryBigDecimalValue(temp_entryInfo, this.getTAX());
        this.newHeadValue = this.oldHeadValue.add(this.newEntryValue.subtract(this.oldEntryValue));
        info.put(this.getHEAD_TAX(), (Object)this.newHeadValue);
    }

    @Override
    public void calTotalTaxAmount(SCMBillBaseInfo info, SCMBillEntryBaseInfo entryInfo) {
        this.oldHeadValue = info.getBigDecimal(this.getHEAD_TAXAMOUNT());
        this.oldEntryValue = entryInfo.getBigDecimal("oldTaxAmount");
        SCMBillEntryBaseInfo temp_entryInfo = (SCMBillEntryBaseInfo)this.getEntry(info).getObject(0);
        this.newEntryValue = this.getEntryBigDecimalValue(temp_entryInfo, this.getTAXAMOUNT());
        this.newHeadValue = this.oldHeadValue.add(this.newEntryValue.subtract(this.oldEntryValue));
        info.put(this.getHEAD_TAXAMOUNT(), (Object)this.newHeadValue);
    }

    @Override
    public void calLocalTotalTaxAmount(SCMBillBaseInfo info, SCMBillEntryBaseInfo entryInfo) {
        this.oldHeadValue = info.getBigDecimal(this.getHEAD_LOCALTAXAMOUNT());
        this.oldEntryValue = entryInfo.getBigDecimal("oldLocalTaxAmount");
        SCMBillEntryBaseInfo temp_entryInfo = (SCMBillEntryBaseInfo)this.getEntry(info).getObject(0);
        this.newEntryValue = this.getEntryBigDecimalValue(temp_entryInfo, this.getLOCALTAXAMOUNT());
        this.newHeadValue = this.oldHeadValue.add(this.newEntryValue.subtract(this.oldEntryValue));
        info.put(this.getHEAD_LOCALTAXAMOUNT(), (Object)this.newHeadValue);
    }

    public void calByEntryQtyChange(PurRequestInfo info, PurRequestEntryInfo entryInfo) {
        boolean theIsInTax = info.isIsInTax();
        if (theIsInTax) {
            this.calEntryTax(info, entryInfo);
            this.calEntryAmount(info, entryInfo);
            this.calEntryActualPrice(info, entryInfo);
            this.calEntryActualTaxPrice(info, entryInfo);
            this.calEntryDiscountAmount(info, entryInfo);
            this.calTotalAmount(info, entryInfo);
            this.calTotalTax(info, entryInfo);
            this.calTotalTaxAmount(info, entryInfo);
            this.calLocalTotalAmount(info, entryInfo);
            this.calLocalTotalTaxAmount(info, entryInfo);
        } else {
            this.calEntryDiscountAmount(info, entryInfo);
            this.calEntryAmount(info, entryInfo);
            this.calEntryActualPrice(info, entryInfo);
            this.calEntryTax(info, entryInfo);
            this.calEntryTaxAmount(info, entryInfo);
            this.calEntryActualTaxPrice(info, entryInfo);
            this.calTotalAmount(info, entryInfo);
            this.calTotalTax(info, entryInfo);
            this.calTotalTaxAmount(info, entryInfo);
            this.calLocalTotalAmount(info, entryInfo);
            this.calLocalTotalTaxAmount(info, entryInfo);
        }
    }

    public void calByEntryUnitChange(PurRequestInfo info, PurRequestEntryInfo entryInfo) {
        boolean theIsInTax = info.isIsInTax();
        if (theIsInTax) {
            this.calTaxPrice(info, entryInfo);
            this.calPriceByTaxPrice(info, entryInfo);
            this.calActualPrice(info, entryInfo);
            this.calActualTaxPrice(info, entryInfo);
        } else {
            this.calPriceByAmount(info, entryInfo);
            this.calActualPrice(info, entryInfo);
            this.calTaxPrice(info, entryInfo);
            this.calActualTaxPrice(info, entryInfo);
        }
    }

    private void calTaxPrice(PurRequestInfo info, PurRequestEntryInfo entryInfo) {
        BigDecimal discountRate = this.validateNullValue(entryInfo.getDiscountRate());
        BigDecimal qty = this.validateNullValue(entryInfo.getQty());
        BigDecimal taxAmount = this.validateNullValue(entryInfo.getTaxAmount());
        BigDecimal taxPrice = null;
        if (qty != null && qty.compareTo(this.ZERO) != 0) {
            if (discountRate == null) {
                discountRate = new BigDecimal("0.00");
            }
            discountRate = this.one.subtract(discountRate.divide(this.oneHundred, this.DEFAULT_PRECISION, 4));
            if (taxAmount != null && qty != null) {
                taxPrice = taxAmount.divide(qty, this.DEFAULT_PRECISION, 4);
                taxPrice = discountRate.compareTo(this.ZERO) == 0 ? this.ZERO : taxPrice.divide(discountRate, this.DEFAULT_PRECISION, 4);
            }
        }
        entryInfo.put(this.TAXPRICE, taxPrice);
    }

    private void calPriceByTaxPrice(PurRequestInfo info, PurRequestEntryInfo entryInfo) {
        BigDecimal taxPrice = this.validateNullValue(entryInfo.getTaxPrice()).abs();
        BigDecimal taxRate = this.validateNullValue(entryInfo.getTaxRate());
        BigDecimal price = CalculateUtils.calPrice((BigDecimal)taxPrice, (BigDecimal)taxRate, (int)this.DEFAULT_PRECISION);
        if (!info.isIsPriceInTax()) {
            price = CalculateUtils.calPriceIsPriceInTax((BigDecimal)taxRate, (BigDecimal)taxPrice, (int)this.DEFAULT_PRECISION);
        }
        entryInfo.put(this.PRICE, price);
    }

    private void calPriceByAmount(PurRequestInfo info, PurRequestEntryInfo entryInfo) {
        BigDecimal amount = this.validateNullValue(entryInfo.getAmount());
        BigDecimal qty = this.validateNullValue(entryInfo.getQty());
        BigDecimal discountRate = this.validateNullValue(entryInfo.getDiscountRate());
        discountRate = this.validateNullValue(discountRate);
        BigDecimal price = CalculateUtils.calPrice((BigDecimal)amount, (BigDecimal)qty, (BigDecimal)discountRate, (int)this.DEFAULT_PRECISION);
        entryInfo.setPrice(price);
    }

    private void calActualPrice(PurRequestInfo info, PurRequestEntryInfo entryInfo) {
        BigDecimal amount = this.validateNullValue(entryInfo.getAmount());
        BigDecimal qty = this.validateNullValue(entryInfo.getQty());
        BigDecimal discountRate = this.validateNullValue(entryInfo.getDiscountRate());
        BigDecimal actualPrice = this.ZERO;
        if (discountRate == null || discountRate.compareTo(this.ZERO) == 0) {
            BigDecimal price;
            actualPrice = price = this.validateNullValue(entryInfo.getPrice());
        } else if (amount != null && qty != null && qty.compareTo(this.ZERO) != 0) {
            actualPrice = amount.divide(qty, this.DEFAULT_PRECISION, 4);
        }
        entryInfo.setActualPrice(actualPrice);
    }

    private void calActualTaxPrice(PurRequestInfo info, PurRequestEntryInfo entryInfo) {
        BigDecimal discountRate = this.validateNullValue(entryInfo.getDiscountRate());
        BigDecimal actualTaxPrice = this.ZERO;
        if ((discountRate == null || discountRate.compareTo(this.ZERO) == 0) && entryInfo.getTaxPrice() != null) {
            BigDecimal taxPrice;
            actualTaxPrice = taxPrice = entryInfo.getTaxPrice();
        } else {
            BigDecimal taxAmount = this.validateNullValue(entryInfo.getTaxAmount());
            BigDecimal qty = this.validateNullValue(entryInfo.getQty());
            if (taxAmount != null && qty != null && qty.compareTo(this.ZERO) != 0) {
                actualTaxPrice = taxAmount.divide(qty, this.DEFAULT_PRECISION, 4);
            }
        }
        entryInfo.setActualTaxPrice(actualTaxPrice);
    }
}

