/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.pur.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.ObjectNotFoundException;
import com.kingdee.bos.framework.batch.BatchExecuteResult;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.workflow.exception.AlreadyInProcessQueueException;
import com.kingdee.bos.workflow.exception.MatchAssignmentException;
import com.kingdee.bos.workflow.exception.MissMatchParticipantException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.batchaction.ActionResult;
import com.kingdee.eas.framework.batchaction.ActionResultEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.scm.common.BizActionEnum;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class BatchResolveResultClientUtil {
    private static final Logger logger = CoreUIObject.getLogger(BatchResolveResultClientUtil.class);
    private static CoreUI ui = null;
    private static BizActionEnum action = null;
    private static ICoreBase bizInterface = null;
    private static ICoreBase bizEntryInterface = null;

    public BatchResolveResultClientUtil() {
    }

    public BatchResolveResultClientUtil(CoreUI coreui, BizActionEnum btaction, ICoreBase billInterface, ICoreBase entryInterface) {
        ui = coreui;
        action = btaction;
        bizInterface = billInterface;
        bizEntryInterface = entryInterface;
    }

    public void resolveResult(BatchExecuteResult result, String[] IDs, boolean isEntryID) throws EASBizException, BOSException {
        int i;
        Map<String, String> billMap = null;
        Map<String, Object[]> entryMap = null;
        String tab = "        ";
        if (!isEntryID) {
            billMap = this.getIdNum(IDs);
        } else {
            entryMap = this.getEntryIdNumAndSeq(IDs);
        }
        ArrayList<String> errors = new ArrayList<String>();
        if (result != null && result.getBatchResult() == null) {
            Throwable[] exps = result.getExceptions();
            for (i = 0; i < exps.length; ++i) {
                if (exps[i] == null) continue;
                String error = this.handleWorkFlowException((Exception)exps[i]);
                if (exps[i] instanceof ObjectNotFoundException) {
                    error = new EASBizException(EASBizException.CHECKEXIST).getMessage();
                }
                if (exps[i].getCause() != null) {
                    error = exps[i].getCause().getMessage();
                }
                if (error == null) {
                    error = exps[i].getMessage();
                }
                error = !isEntryID ? (billMap.get(IDs[i]) == null ? new EASBizException(EASBizException.CHECKEXIST).getMessage() : billMap.get(IDs[i]) + tab + error) : (entryMap.get(IDs[i]) == null ? new EASBizException(EASBizException.CHECKEXIST).getMessage() : entryMap.get(IDs[i])[0] + tab + entryMap.get(IDs[i])[1] + tab + error);
                errors.add(error);
            }
        } else if (result != null) {
            BatchActionResults actionResults = (BatchActionResults)result.getBatchResult();
            for (i = 0; i < IDs.length; ++i) {
                String id = IDs[i];
                ActionResult actionResult = actionResults.getActionResult((Object)id);
                if (actionResult.getResult().equals((Object)ActionResultEnum.SUCCESS)) continue;
                if (!isEntryID) {
                    if (billMap.get(id) == null) {
                        errors.add(new EASBizException(EASBizException.CHECKEXIST).getMessage());
                        continue;
                    }
                    if (actionResult.getException() != null && actionResult.getException().getMessage() != null) {
                        errors.add(billMap.get(id) + tab + actionResult.getException().getMessage());
                        continue;
                    }
                    errors.add(billMap.get(id) + tab + actionResult.getMessage());
                    continue;
                }
                if (entryMap.get(IDs[i]) == null) {
                    errors.add(new EASBizException(EASBizException.CHECKEXIST).getMessage());
                    continue;
                }
                if (actionResult.getException() != null && actionResult.getException().getMessage() != null) {
                    errors.add(entryMap.get(IDs[i])[0] + tab + entryMap.get(IDs[i])[1] + tab + actionResult.getException().getMessage());
                    continue;
                }
                errors.add(entryMap.get(IDs[i])[0] + tab + entryMap.get(IDs[i])[1] + tab + actionResult.getMessage());
            }
        }
        SysContext ctx = SysContext.getSysContext();
        if (errors.size() > 0) {
            Object errorMsg;
            StringBuffer sb = new StringBuffer();
            if (isEntryID) {
                errorMsg = new StringBuffer(EASResource.getString((String)"com.kingdee.eas.scm.common.ActionResource", (String)"ENTRY_TITLE", (Object[])new String[]{tab}));
                sb.append((StringBuffer)errorMsg).append("\n");
            } else {
                errorMsg = new StringBuffer(EASResource.getString((String)"com.kingdee.eas.scm.common.ActionResource", (String)"HEAD_TITLE", (Object[])new String[]{tab}));
                sb.append((StringBuffer)errorMsg).append("\n");
            }
            for (String error : errors) {
                sb.append(error);
                sb.append("\n");
            }
            String title = EASResource.getString((String)"com.kingdee.eas.scm.common.ActionResource", (String)"ERROR_ENTRY_MSG", (Object[])new String[]{String.valueOf(IDs.length), String.valueOf(errors.size()), this.getAction().getAlias(ctx.getLocale())});
            MsgBox.showDetailAndOK((Component)this.getOwnerUI(), (String)title, (String)sb.toString(), (int)0);
        }
    }

    private String handleWorkFlowException(Exception e) {
        String error = null;
        SysContext ctx = SysContext.getSysContext();
        if (e instanceof MissMatchParticipantException) {
            error = ResourceBase.getString((String)"com.kingdee.eas.framework.FrameWorkResource", (String)"Msg_MissMatchParticipant", (Locale)ctx.getLocale());
        } else if (e instanceof MatchAssignmentException) {
            error = ResourceBase.getString((String)"com.kingdee.eas.framework.FrameWorkResource", (String)"Msg_WFMatch", (Locale)ctx.getLocale());
        } else if (e instanceof AlreadyInProcessQueueException) {
            error = ResourceBase.getString((String)"com.kingdee.eas.framework.FrameWorkResource", (String)"Msg_AlreadyInProcessQueue", (Locale)ctx.getLocale());
        }
        return error;
    }

    private Map<String, String> getIdNum(String[] IDs) throws EASBizException, BOSException {
        HashSet<String> idsSet = new HashSet<String>();
        for (int i = 0; i < IDs.length; ++i) {
            idsSet.add(IDs[i]);
        }
        HashMap<String, String> map = new HashMap<String, String>();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", idsSet, CompareType.INCLUDE));
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        view.setSelector(sic);
        CoreBaseCollection collection = this.getBizInterface().getCollection(view);
        for (int i = 0; i < collection.size(); ++i) {
            map.put(collection.get(i).getId().toString(), collection.get(i).get("number").toString());
        }
        return map;
    }

    private Map<String, Object[]> getEntryIdNumAndSeq(String[] IDs) throws EASBizException, BOSException {
        HashSet<String> idsSet = new HashSet<String>();
        for (int i = 0; i < IDs.length; ++i) {
            idsSet.add(IDs[i]);
        }
        HashMap<String, Object[]> map = new HashMap<String, Object[]>();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", idsSet, CompareType.INCLUDE));
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("seq"));
        sic.add(new SelectorItemInfo("parent.id"));
        sic.add(new SelectorItemInfo("parent.number"));
        sic.add(new SelectorItemInfo("parent.name"));
        view.setSelector(sic);
        CoreBaseCollection collection = this.getBizEntryInterface().getCollection(view);
        for (int i = 0; i < collection.size(); ++i) {
            map.put(collection.get(i).getId().toString(), new Object[]{((SCMBillBaseInfo)collection.get(i).get("parent")).getNumber(), collection.get(i).get("seq")});
        }
        return map;
    }

    private CoreUI getOwnerUI() {
        return ui;
    }

    private BizActionEnum getAction() {
        return action;
    }

    private ICoreBase getBizInterface() throws EASBizException, BOSException {
        return bizInterface;
    }

    private ICoreBase getBizEntryInterface() throws EASBizException, BOSException {
        return bizEntryInterface;
    }
}

