/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.pur.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTActiveCellEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTActiveCellListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.resource.BizEnumValueInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.IProcessor;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.ReasonCodeInfo;
import com.kingdee.eas.basedata.scm.common.client.ReasonF7Until;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.cas.SourceTypeEnum;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.client.UserQueryFilterProcessor;
import com.kingdee.eas.scm.sm.pur.IPurExpenseInvoice;
import com.kingdee.eas.scm.sm.pur.PurExpenseInvoiceFactory;
import com.kingdee.eas.scm.sm.pur.PurExpenseInvoiceInfo;
import com.kingdee.eas.scm.sm.pur.client.AbstractPurExpenseInvoiceListUI;
import com.kingdee.eas.scm.sm.pur.client.PurExpenseInvoiceEditUI;
import com.kingdee.eas.scm.sm.pur.client.PurExpenseInvoiceQueryUI;
import com.kingdee.eas.tools.datatask.DatataskParameter;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;

public class PurExpenseInvoiceListUI
extends AbstractPurExpenseInvoiceListUI {
    private static final Logger logger = CoreUIObject.getLogger(PurExpenseInvoiceListUI.class);
    public static final String RES_PROMPT = "com.kingdee.eas.scm.sm.pur.PurExpenseInvoiceResource";
    private static final String TB_ID = "id";
    private static final String TB_BASESTATE = "baseState";
    private static final String TB_INVOICEDATE = "invoiceDate";
    private static final String TB_ISREVERSE = "isReversed";
    private static final String TB_Precision = "precision";
    private static final String[] AMOUTCOLS = new String[]{"price", "amount", "amountHome", "amountTax", "amountTaxHome", "amountWithoutTa", "amountHomeNoTax"};
    private int currentRow = -1;
    UserInfo user = SysContext.getSysContext().getCurrentUserInfo();
    IObjectPK userPk = new ObjectUuidPK(this.user.getId());
    CommonQueryDialog conditionDialog = null;
    PurExpenseInvoiceQueryUI conditionPanel = null;
    Map companyOrgisArScmRelateMap = new HashMap();

    public PurExpenseInvoiceListUI() throws Exception {
        boolean isArScmRelate = false;
        isArScmRelate = SCMClientUtils.isAPRelationSCM((CompanyOrgUnitInfo)SysContext.getSysContext().getCurrentFIUnit());
        this.companyOrgisArScmRelateMap.put(SysContext.getSysContext().getCurrentFIUnit().getId().toString(), new Boolean(isArScmRelate));
        if (isArScmRelate) {
            this.btnVoucher.setEnabled(false);
            this.menuItemVoucher.setEnabled(false);
            this.btnDelVoucher.setEnabled(false);
            this.menuItemDelVoucher.setEnabled(false);
        } else {
            this.btnVoucher.setEnabled(true);
            this.menuItemVoucher.setEnabled(true);
            this.btnDelVoucher.setEnabled(true);
            this.menuItemDelVoucher.setEnabled(true);
        }
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.tblMain.getGroupManager().setGroup(true);
        this.tblMain.getViewManager().setFreezeView(0, this.tblMain.getColumnIndex(TB_INVOICEDATE));
        this.initForm();
        this.tblMain.addKDTDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
            }
        });
        this.changeVoucherBtn();
        this.tblMain.repaint();
    }

    private void disPlayDataToRed(KDTDataRequestEvent e) {
        int last = e.getLastRow();
        for (int i = e.getFirstRow(); i <= last; ++i) {
            if (this.tblMain.getCell(i, TB_ISREVERSE).getValue() == null || !(this.tblMain.getCell(i, TB_ISREVERSE).getValue() instanceof Boolean) || !((Boolean)this.tblMain.getCell(i, TB_ISREVERSE).getValue()).booleanValue()) continue;
            for (int j = 0; j < AMOUTCOLS.length; ++j) {
                BigDecimal value = (BigDecimal)this.tblMain.getCell(i, AMOUTCOLS[j]).getValue();
                if (value == null) continue;
                this.tblMain.getCell(i, AMOUTCOLS[j]).setValue((Object)value.abs());
                this.tblMain.getCell(i, AMOUTCOLS[j]).getStyleAttributes().setFontColor(Color.RED);
            }
        }
    }

    private PurExpenseInvoiceInfo getInfoById(String id) throws EASBizException, BOSException {
        ObjectUuidPK pk = new ObjectUuidPK(id);
        return (PurExpenseInvoiceInfo)PurExpenseInvoiceFactory.getRemoteInstance().getValue((IObjectPK)pk);
    }

    private int getPrecision(PurExpenseInvoiceInfo info) {
        CurrencyInfo cInfo = null;
        try {
            cInfo = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(info.getCurrency().getId()));
        }
        catch (Exception exc) {
            this.handleException(exc);
        }
        return cInfo == null ? 2 : cInfo.getPrecision();
    }

    private void initAmoutPrecision(KDTDataRequestEvent e) {
        int last = e.getLastRow();
        for (int i = e.getFirstRow(); i <= last; ++i) {
            PurExpenseInvoiceInfo pInfo = null;
            if (this.tblMain.getCell(i, TB_ID).getValue() == null) continue;
            try {
                pInfo = this.getInfoById((String)this.tblMain.getCell(i, TB_ID).getValue());
            }
            catch (Exception exc) {
                this.handleException(exc);
            }
            if (pInfo == null) continue;
            SCMClientUtils.changeTableColPrecision((int)this.getPrecision(pInfo), (KDTable)this.tblMain, (String[])AMOUTCOLS);
        }
    }

    private void initAmountPrecision(KDTDataRequestEvent e) {
        int last = e.getLastRow();
        for (int i = e.getFirstRow(); i <= last; ++i) {
            if (this.tblMain.getCell(i, TB_Precision).getValue() != null) {
                int precision = Integer.parseInt(this.tblMain.getCell(i, TB_Precision).getValue().toString());
                SCMClientUtils.changeTableColPrecision((int)precision, (KDTable)this.tblMain, (String[])AMOUTCOLS);
                continue;
            }
            SCMClientUtils.changeTableColPrecision((int)2, (KDTable)this.tblMain, (String[])AMOUTCOLS);
        }
    }

    private void initForm() {
        this.btnAudit.setIcon(EASResource.getIcon((String)"imgTbtn_auditing"));
        this.btnFreeze.setIcon(EASResource.getIcon((String)"imgTbtn_freeze"));
        this.btnUnFreeze.setIcon(EASResource.getIcon((String)"imgTbtn_ffreeze"));
        this.btnCancel.setIcon(EASResource.getIcon((String)"imgTbtn_blankout"));
        this.btnVerify.setIcon(EASResource.getIcon((String)"imgTbtn_redclash"));
        this.kDMenuItemCancel.setIcon(EASResource.getIcon((String)"imgTbtn_blankout"));
        this.kDMenuItemBlock.setIcon(EASResource.getIcon((String)"imgTbtn_freeze"));
        this.kDMenuItemUnBlock.setIcon(EASResource.getIcon((String)"imgTbtn_ffreeze"));
        this.kDMenuItemReverse.setIcon(EASResource.getIcon((String)"imgTbtn_redclash"));
        this.tblMain.addKDTActiveCellListener(new KDTActiveCellListener(){

            public void activeCellChanged(KDTActiveCellEvent e) {
                PurExpenseInvoiceListUI.this.currentRow = e.getRowIndex();
            }
        });
    }

    private void setButtonStatus(int rowIndex) {
        boolean isViewable = false;
        boolean isEditable = false;
        boolean isRemovable = false;
        boolean isAuditable = false;
        boolean isAuditVisiable = false;
        boolean isUnAuditable = false;
        boolean isUnAuditVisiable = false;
        boolean isFreezable = false;
        boolean isFreezeVisiable = false;
        boolean isUnFreezable = false;
        boolean isUnFreezeVisiable = false;
        boolean isVerifible = false;
        boolean isVerifyVisiable = false;
        boolean isCancelable = false;
        boolean isCancelVisiable = false;
        if (rowIndex >= 0 && rowIndex < this.tblMain.getRowCount() && (BizEnumValueInfo)this.tblMain.getCell(rowIndex, TB_BASESTATE).getValue() != null) {
            int baseStatus = ((BizEnumValueInfo)this.tblMain.getCell(rowIndex, TB_BASESTATE).getValue()).getInt();
            if (baseStatus == 0) {
                isAuditable = true;
                isAuditVisiable = true;
            }
            if (baseStatus == 1) {
                isViewable = true;
                isEditable = true;
                isRemovable = true;
            }
            if (baseStatus == 2) {
                isAuditable = true;
                isAuditVisiable = true;
                isRemovable = true;
                isEditable = true;
                isViewable = true;
                isCancelable = true;
                isCancelVisiable = true;
            }
            if (baseStatus == 3) {
                isViewable = true;
            }
            if (baseStatus == 4) {
                isViewable = true;
                isFreezable = true;
                isFreezeVisiable = true;
                isVerifible = true;
                isVerifyVisiable = true;
            }
            if (baseStatus == 6) {
                isViewable = true;
                isUnFreezable = true;
                isUnFreezeVisiable = true;
            }
            if (baseStatus == 7) {
                // empty if block
            }
            this.btnEdit.setEnabled(isEditable);
            this.btnView.setEnabled(isViewable);
            this.btnRemove.setEnabled(isRemovable);
            this.btnAudit.setEnabled(isAuditable);
            this.btnUnAudit.setEnabled(isUnAuditable);
            this.btnCancel.setEnabled(isCancelable);
            this.btnFreeze.setEnabled(isFreezable);
            this.btnUnFreeze.setEnabled(isUnFreezable);
            this.btnVerify.setEnabled(isVerifible);
        }
    }

    public CommonQueryDialog initCommonQueryDialog() {
        if (this.conditionDialog == null) {
            this.conditionDialog = new CommonQueryDialog();
            this.conditionDialog.setOwner((Component)this.getUIContext().get("OwnerWindow"));
            this.conditionDialog.setShowFilter(true);
            this.conditionDialog.setShowSorter(true);
            this.conditionDialog.setWidth(430);
            this.conditionDialog.setHeight(310);
            try {
                this.conditionDialog.addUserPanel(this.getConditionPanel());
                UserQueryFilterProcessor userFilter = new UserQueryFilterProcessor();
                userFilter.setOwner((IUIObject)this.conditionPanel);
                this.conditionDialog.setProcessor((IProcessor)userFilter);
            }
            catch (Exception e) {
                this.handUIException(e);
            }
            this.conditionDialog.setQueryObjectPK(this.mainQueryPK);
            this.conditionDialog.setParentUIClassName(PurExpenseInvoiceListUI.class.getName());
        }
        return this.conditionDialog;
    }

    protected boolean initDefaultFilter() {
        return true;
    }

    public KDPanel getConditionPanel() throws Exception {
        if (this.conditionPanel == null) {
            this.conditionPanel = new PurExpenseInvoiceQueryUI();
        }
        return this.conditionPanel;
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected String getEditUIName() {
        return PurExpenseInvoiceEditUI.class.getName();
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return PurExpenseInvoiceFactory.getRemoteInstance();
    }

    @Override
    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkEdit();
        super.actionEdit_actionPerformed(e);
    }

    private void checkEdit() {
        int size = this.tblMain.getSelectManager().size();
        for (int j = 0; j < size; ++j) {
            KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get(j);
            if (selectBlock == null) continue;
            int num = selectBlock.getEndRow();
            for (int i = selectBlock.getTop(); i <= num && i >= 0; ++i) {
                IRow row = this.tblMain.getRow(i);
                if (!row.getCell(TB_ISREVERSE).getValue().toString().equalsIgnoreCase("true")) continue;
                MsgBox.showError((String)EASResource.getString((String)RES_PROMPT, (String)"reverse_cannot_edit"));
                SysUtil.abort();
            }
        }
    }

    @Override
    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemove_actionPerformed(e);
    }

    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.checkAudit();
        if (MsgBox.showConfirm2((String)EASResource.getString((String)RES_PROMPT, (String)"prompt_request_audit")) != 0) {
            return;
        }
        String[] billIdlist = SCMClientUtils.filterDistnctID((String[])SCMClientUtils.getSelectRowFieldValue((KDTable)this.tblMain, (String)this.getKeyFieldName()));
        int count = billIdlist.length;
        if (count != 0) {
            IObjectPK[] pks = new IObjectPK[count];
            for (int i = 0; i < count; ++i) {
                pks[i] = new ObjectStringPK(billIdlist[i]);
            }
            try {
                ((IPurExpenseInvoice)this.getBizInterface()).audit(pks);
                this.setMessageText(EASResource.getString((String)RES_PROMPT, (String)"prompt_audit_success"));
                this.showMessage();
                this.refreshList();
            }
            catch (Exception ex) {
                this.handleException(ex);
            }
        }
    }

    public void actionUnAudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.checkUnAudit();
        if (MsgBox.showConfirm2((String)EASResource.getString((String)RES_PROMPT, (String)"prompt_request_unaudit")) != 0) {
            return;
        }
        String[] billIdlist = SCMClientUtils.filterDistnctID((String[])SCMClientUtils.getSelectRowFieldValue((KDTable)this.tblMain, (String)this.getKeyFieldName()));
        int count = billIdlist.length;
        if (count != 0) {
            IObjectPK[] pks = new IObjectPK[count];
            for (int i = 0; i < count; ++i) {
                pks[i] = new ObjectStringPK(billIdlist[i]);
            }
            try {
                ((IPurExpenseInvoice)this.getBizInterface()).unAudit(pks);
                this.setMessageText(EASResource.getString((String)RES_PROMPT, (String)"prompt_unaudit_success"));
                this.showMessage();
                this.refreshList();
            }
            catch (Exception ex) {
                this.handleException(ex);
            }
        }
    }

    private void checkUnAudit() {
        int size = this.tblMain.getSelectManager().size();
        for (int j = 0; j < size; ++j) {
            KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get(j);
            if (selectBlock == null) continue;
            int num = selectBlock.getEndRow();
            for (int i = selectBlock.getTop(); i <= num && i >= 0; ++i) {
                IRow row = this.tblMain.getRow(i);
                String baseStatus = row.getCell(TB_BASESTATE).getValue().toString();
                if (baseStatus.trim().equalsIgnoreCase(BillBaseStatusEnum.AUDITED.toString())) continue;
                MsgBox.showError((String)EASResource.getString((String)RES_PROMPT, (String)"check_unaudit"));
                SysUtil.abort();
            }
        }
    }

    @Override
    public void actionRevoke_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.checkCancel();
        super.actionRevoke_actionPerformed(e);
        ReasonCodeInfo reasonCodeInfo = ReasonF7Until.getReasonCode((IUIWindow)ReasonF7Until.showRevokedReasonUI((Map)this.getUIContext(), (IUIWindow)this.getUIWindow()));
        String[] billIdlist = SCMClientUtils.filterDistnctID((String[])SCMClientUtils.getSelectRowFieldValue((KDTable)this.tblMain, (String)this.getKeyFieldName()));
        int count = billIdlist.length;
        if (count != 0) {
            IObjectPK[] pks = new IObjectPK[count];
            if (reasonCodeInfo == null) {
                SysUtil.abort();
            } else {
                try {
                    ReasonCodeInfo[] reasonCodeInfos = new ReasonCodeInfo[count];
                    for (int i = 0; i < count; ++i) {
                        pks[i] = new ObjectStringPK(billIdlist[i]);
                        reasonCodeInfos[i] = reasonCodeInfo;
                    }
                    ((IPurExpenseInvoice)this.getBizInterface()).cancelWithReason(pks, (IObjectValue[])reasonCodeInfos);
                    this.setMessageText(EASResource.getString((String)RES_PROMPT, (String)"prompt_cancel_success"));
                    this.showMessage();
                    this.refreshList();
                }
                catch (Exception ex) {
                    this.handleException(ex);
                }
            }
        }
    }

    private void checkCancel() {
        int size = this.tblMain.getSelectManager().size();
        for (int j = 0; j < size; ++j) {
            KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get(j);
            if (selectBlock == null) continue;
            int num = selectBlock.getEndRow();
            for (int i = selectBlock.getTop(); i <= num && i >= 0; ++i) {
                IRow row = this.tblMain.getRow(i);
                String baseStatus = row.getCell(TB_BASESTATE).getValue().toString();
                if (baseStatus.trim().equalsIgnoreCase(BillBaseStatusEnum.SUBMITED.toString())) continue;
                MsgBox.showError((String)EASResource.getString((String)RES_PROMPT, (String)"check_cancel"));
                SysUtil.abort();
            }
        }
    }

    @Override
    public void actionFreeze_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.checkBlock();
        super.actionFreeze_actionPerformed(e);
        ReasonCodeInfo reasonCodeInfo = ReasonF7Until.getReasonCode((IUIWindow)ReasonF7Until.showBlockedReasonUI((Map)this.getUIContext(), (IUIWindow)this.getUIWindow()));
        ArrayList list = super.getSelectedIdValues();
        int count = list.size();
        IObjectPK[] pks = new IObjectPK[count];
        if (count != 0) {
            if (reasonCodeInfo == null) {
                SysUtil.abort();
            } else {
                try {
                    ReasonCodeInfo[] reasonCodeInfos = new ReasonCodeInfo[count];
                    for (int i = 0; i < count; ++i) {
                        pks[i] = new ObjectStringPK(list.get(i).toString());
                        reasonCodeInfos[i] = reasonCodeInfo;
                    }
                    ((IPurExpenseInvoice)this.getBizInterface()).freezeWithReason(pks, (IObjectValue[])reasonCodeInfos);
                    this.setMessageText(EASResource.getString((String)RES_PROMPT, (String)"prompt_freeze_success"));
                    this.showMessage();
                    this.refreshList();
                }
                catch (Exception ex) {
                    this.handleException(ex);
                }
            }
        }
    }

    private void checkBlock() {
        int size = this.tblMain.getSelectManager().size();
        for (int j = 0; j < size; ++j) {
            KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get(j);
            if (selectBlock == null) continue;
            int num = selectBlock.getEndRow();
            for (int i = selectBlock.getTop(); i <= num && i >= 0; ++i) {
                IRow row = this.tblMain.getRow(i);
                String baseStatus = row.getCell(TB_BASESTATE).getValue().toString();
                if (baseStatus.trim().equalsIgnoreCase(BillBaseStatusEnum.AUDITED.toString())) continue;
                MsgBox.showError((String)EASResource.getString((String)RES_PROMPT, (String)"check_block"));
                SysUtil.abort();
            }
        }
    }

    @Override
    public void actionUnFreeze_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.checkUnBlock();
        super.actionUnFreeze_actionPerformed(e);
        ArrayList list = super.getSelectedIdValues();
        int count = list.size();
        IObjectPK[] pks = new IObjectPK[count];
        if (count != 0) {
            for (int i = 0; i < count; ++i) {
                pks[i] = new ObjectStringPK(list.get(i).toString());
            }
            try {
                ((IPurExpenseInvoice)this.getBizInterface()).unFreeze(pks);
                this.setMessageText(EASResource.getString((String)RES_PROMPT, (String)"prompt_unfreeze_success"));
                this.showMessage();
                this.refreshList();
            }
            catch (Exception ex) {
                this.handleException(ex);
            }
        }
    }

    private void checkUnBlock() {
        int size = this.tblMain.getSelectManager().size();
        for (int j = 0; j < size; ++j) {
            KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get(j);
            if (selectBlock == null) continue;
            int num = selectBlock.getEndRow();
            for (int i = selectBlock.getTop(); i <= num && i >= 0; ++i) {
                IRow row = this.tblMain.getRow(i);
                String baseStatus = row.getCell(TB_BASESTATE).getValue().toString();
                if (baseStatus.trim().equalsIgnoreCase(BillBaseStatusEnum.BLOCKED.toString())) continue;
                MsgBox.showError((String)EASResource.getString((String)RES_PROMPT, (String)"check_unblock"));
                SysUtil.abort();
            }
        }
    }

    @Override
    public void actionVerify_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.checkReverser();
        if (MsgBox.showConfirm2((String)EASResource.getString((String)RES_PROMPT, (String)"prompt_request_verify")) != 0) {
            return;
        }
        super.actionVerify_actionPerformed(e);
        String[] billIdlist = SCMClientUtils.filterDistnctID((String[])SCMClientUtils.getSelectRowFieldValue((KDTable)this.tblMain, (String)this.getKeyFieldName()));
        int count = billIdlist.length;
        if (count != 0) {
            IObjectPK[] pks = new IObjectPK[count];
            for (int i = 0; i < count; ++i) {
                pks[i] = new ObjectStringPK(billIdlist[i]);
            }
            try {
                IObjectPK[] newPKs = ((IPurExpenseInvoice)this.getBizInterface()).createReverse(pks);
                this.setMessageText(EASResource.getString((String)RES_PROMPT, (String)"prompt_verify_success"));
                this.showMessage();
                this.refreshList();
            }
            catch (Exception ex) {
                this.handleException(ex);
            }
        }
    }

    private void checkReverser() {
        int size = this.tblMain.getSelectManager().size();
        for (int j = 0; j < size; ++j) {
            KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get(j);
            if (selectBlock == null) continue;
            int num = selectBlock.getEndRow();
            for (int i = selectBlock.getTop(); i <= num && i >= 0; ++i) {
                IRow row = this.tblMain.getRow(i);
                String baseStatus = row.getCell(TB_BASESTATE).getValue().toString();
                if (baseStatus.trim().equalsIgnoreCase(BillBaseStatusEnum.AUDITED.toString()) && !row.getCell(TB_ISREVERSE).getValue().toString().equalsIgnoreCase("true")) continue;
                MsgBox.showError((String)EASResource.getString((String)RES_PROMPT, (String)"check_reverse"));
                SysUtil.abort();
            }
        }
    }

    public void actionImportData_actionPerformed(ActionEvent e) throws Exception {
        this.logUIOperation("LOG_IMPORT");
        super.actionImportData_actionPerformed(e);
    }

    private void logUIOperation(String key) {
        String operName = SCMClientUtils.getResource((String)key);
        IObjectPK pk = LogUtil.beginLog(null, (String)operName, (BOSObjectType)new PurExpenseInvoiceInfo().getBOSType(), null, (String)operName);
        LogUtil.afterLog(null, (IObjectPK)pk);
    }

    protected ArrayList getImportParam() {
        String solutionName;
        DatataskParameter param = new DatataskParameter();
        param.solutionName = solutionName = "eas.scm.PurExpenseInvoice";
        param.alias = EASResource.getString((String)RES_PROMPT, (String)"PurExpenseInvoice");
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        return paramList;
    }

    @Override
    public SelectorItemCollection getBOTPSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("billType.id"));
        sic.add(new SelectorItemInfo("billType.name"));
        sic.add(new SelectorItemInfo("billType.number"));
        sic.add(new SelectorItemInfo("settlementType.id"));
        sic.add(new SelectorItemInfo("settlementType.name"));
        sic.add(new SelectorItemInfo("settlementType.number"));
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("currency.name"));
        sic.add(new SelectorItemInfo("currency.number"));
        sic.add(new SelectorItemInfo("companyOrgUnit.id"));
        sic.add(new SelectorItemInfo("companyOrgUnit.name"));
        sic.add(new SelectorItemInfo("companyOrgUnit.number"));
        sic.add(new SelectorItemInfo("paymentType.id"));
        sic.add(new SelectorItemInfo("paymentType.name"));
        sic.add(new SelectorItemInfo("paymentType.number"));
        sic.add(new SelectorItemInfo("purchaseOrgUnit.id"));
        sic.add(new SelectorItemInfo("purchaseOrgUnit.name"));
        sic.add(new SelectorItemInfo("purchaseOrgUnit.number"));
        sic.add(new SelectorItemInfo("reasonCode.id"));
        sic.add(new SelectorItemInfo("reasonCode.name"));
        sic.add(new SelectorItemInfo("reasonCode.number"));
        sic.add(new SelectorItemInfo("entries.measureUnit.id"));
        sic.add(new SelectorItemInfo("entries.measureUnit.name"));
        sic.add(new SelectorItemInfo("entries.measureUnit.number"));
        sic.add(new SelectorItemInfo("entries.expenseItem.id"));
        sic.add(new SelectorItemInfo("entries.expenseItem.name"));
        sic.add(new SelectorItemInfo("entries.expenseItem.number"));
        sic.add(new SelectorItemInfo("entries.expenseItem.expenseType.id"));
        sic.add(new SelectorItemInfo("entries.expenseItem.expenseType.name"));
        sic.add(new SelectorItemInfo("entries.expenseItem.expenseType.number"));
        sic.add(new SelectorItemInfo("supplier.id"));
        sic.add(new SelectorItemInfo("supplier.name"));
        sic.add(new SelectorItemInfo("supplier.number"));
        sic.add(new SelectorItemInfo("entries.price"));
        sic.add(new SelectorItemInfo("entries.qty"));
        sic.add(new SelectorItemInfo("entries.taxRate"));
        sic.add(new SelectorItemInfo("entries.tax"));
        return sic;
    }

    public String[] getMergeColumnKeys() {
        return new String[]{"number", TB_BASESTATE, TB_INVOICEDATE, "supplier", "companyOrgUnit", "purchaseOrgUnit", "paymentType", "settlementType", "reasonCode", TB_ISREVERSE, "isCost", TB_ID, TB_Precision, "isFiVourcher", "VourcherNumber"};
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filter = super.getDefaultFilterForQuery();
        FilterInfo companyOrgFilter = SCMClientUtils.getF7FilterInfoByAuthorizedCompanyOrg((String)"companyOrgUnit.id");
        try {
            filter.mergeFilter(companyOrgFilter, "AND");
        }
        catch (Exception ex) {
            this.handUIException(ex);
        }
        return filter;
    }

    @Override
    public void actionVoucher_actionPerformed(ActionEvent e) throws Exception {
        this.canCreateVoucher();
        super.actionVoucher_actionPerformed(e);
    }

    private void canCreateVoucher() {
        int size = this.tblMain.getSelectManager().size();
        if (size == 0 || this.tblMain.getSelectManager().getActiveRowIndex() < 0) {
            SysUtil.abort();
        }
        for (int j = 0; j < size; ++j) {
            KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get(j);
            if (selectBlock == null) continue;
            int num = selectBlock.getEndRow();
            for (int i = selectBlock.getTop(); i <= num && i >= 0; ++i) {
                IRow row = this.tblMain.getRow(i);
                BizEnumValueInfo value = (BizEnumValueInfo)row.getCell(TB_BASESTATE).getValue();
                if (value.getValue().equals(String.valueOf(BillBaseStatusEnum.AUDITED.getValue()))) continue;
                MsgBox.showError((String)EASResource.getString((String)RES_PROMPT, (String)"expInv_cannotVoucher"));
                SysUtil.abort();
            }
        }
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        super.tblMain_tableClicked(e);
        if (e.getClickCount() == 1) {
            this.changeVoucherBtn();
        }
    }

    private void changeVoucherBtn() throws Exception {
        PurExpenseInvoiceInfo info = this.getSelectedPurExpInvInfo();
        if (info != null && info.getCompanyOrgUnit() != null) {
            if (this.companyOrgisArScmRelateMap.get(info.getCompanyOrgUnit().getId().toString()) == null) {
                boolean isArScmRelate = false;
                isArScmRelate = SCMClientUtils.isAPRelationSCM((CompanyOrgUnitInfo)info.getCompanyOrgUnit());
                this.companyOrgisArScmRelateMap.put(info.getCompanyOrgUnit().getId().toString(), new Boolean(isArScmRelate));
            }
            if (((Boolean)this.companyOrgisArScmRelateMap.get(info.getCompanyOrgUnit().getId().toString())).booleanValue()) {
                this.btnVoucher.setEnabled(false);
                this.menuItemVoucher.setEnabled(false);
                this.btnDelVoucher.setEnabled(false);
                this.menuItemDelVoucher.setEnabled(false);
            } else {
                this.btnVoucher.setEnabled(true);
                this.menuItemVoucher.setEnabled(true);
                this.btnDelVoucher.setEnabled(true);
                this.menuItemDelVoucher.setEnabled(true);
            }
        }
    }

    private PurExpenseInvoiceInfo getSelectedPurExpInvInfo() throws Exception {
        PurExpenseInvoiceInfo purExpInvoiceInfo = null;
        int size = this.tblMain.getSelectManager().size();
        if (size == 0 || this.tblMain.getSelectManager().getActiveRowIndex() < 0) {
            return null;
        }
        IPurExpenseInvoice iPurExpenseInvoice = PurExpenseInvoiceFactory.getRemoteInstance();
        for (int j = 0; j < size; ++j) {
            KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get(j);
            if (selectBlock == null) continue;
            int num = selectBlock.getEndRow();
            for (int i = selectBlock.getTop(); i <= num && i >= 0; ++i) {
                IRow row = this.tblMain.getRow(i);
                ObjectStringPK pk = new ObjectStringPK(row.getCell(TB_ID).getValue().toString());
                purExpInvoiceInfo = iPurExpenseInvoice.getPurExpenseInvoiceInfo((IObjectPK)pk);
            }
        }
        return purExpInvoiceInfo;
    }

    protected CompanyOrgUnitInfo getCompanyOrgUnitInfo() throws Exception {
        IPurExpenseInvoice ipurExpInvoice = PurExpenseInvoiceFactory.getRemoteInstance();
        String[] billIdlist = this.getSelectedListId();
        ObjectStringPK pk = new ObjectStringPK(billIdlist[0]);
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("companyOrgUnit.id"));
        sic.add(new SelectorItemInfo("companyOrgUnit.name"));
        sic.add(new SelectorItemInfo("companyOrgUnit.number"));
        PurExpenseInvoiceInfo purExpinvInfo = ipurExpInvoice.getPurExpenseInvoiceInfo((IObjectPK)pk, sic);
        return purExpinvInfo.getCompanyOrgUnit();
    }

    private String[] getSelectedListId() {
        KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get();
        HashMap<String, String> mapId = new HashMap<String, String>();
        if (selectBlock != null) {
            for (int i = selectBlock.getTop(); i <= selectBlock.getEndRow(); ++i) {
                IRow row = this.tblMain.getRow(i);
                ICell cell = row.getCell(this.getKeyFieldName());
                Object keyValue = cell.getValue();
                if (keyValue == null || mapId.containsKey(keyValue.toString())) continue;
                mapId.put(keyValue.toString(), keyValue.toString());
            }
        }
        String[] listId = null;
        if (mapId != null && mapId.size() > 0) {
            Iterator iterat = mapId.keySet().iterator();
            listId = new String[mapId.size()];
            int index = 0;
            while (iterat.hasNext()) {
                listId[index] = (String)iterat.next();
                ++index;
            }
        }
        return listId;
    }

    protected void getRowSetBeforeFillTable(IRowSet rowSet) {
        this.initColPrecision(rowSet);
    }

    private void initColPrecision(IRowSet rowSet) {
        int amountPre = 2;
        int localAmountPre = 2;
        String[] AMOUNT_COLUMNS = new String[]{"totalAmount", "entries.amount", "totalTax", "entries.amountTax", "entries.amountWithoutTa", "entries.price"};
        String[] LOCALAMOUNT_COLUMNS = new String[]{"entries.amountHome", "entries.amountTaxHome", "entries.amountHomeNoTax"};
        try {
            while (rowSet.next()) {
                amountPre = rowSet.getInt("currency.precision");
                localAmountPre = rowSet.getInt("baseCurrency.precision");
                SCMClientUtils.iniColumnsPrecision((int)amountPre, (String[])AMOUNT_COLUMNS, (IRowSet)rowSet);
                SCMClientUtils.iniColumnsPrecision((int)localAmountPre, (String[])LOCALAMOUNT_COLUMNS, (IRowSet)rowSet);
            }
        }
        catch (SQLException ex) {
            this.handUIException(ex);
        }
    }

    public void actionTraceDown_actionPerformed(ActionEvent e) throws Exception {
        this.getUIContext().put("UI_System", SourceTypeEnum.AP);
        super.actionTraceDown_actionPerformed(e);
    }

    protected void logPrint() {
        this.logUIOperation("LOG_PRINT");
    }

    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.PURCHASINGMANAGEMENT;
    }
}

