/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.pur.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.master.cssp.CSSPGroupInfo;
import com.kingdee.eas.basedata.master.cssp.client.F7SupplierTreeDetailListUI;
import com.kingdee.eas.basedata.master.material.MaterialGroupInfo;
import com.kingdee.eas.basedata.master.material.client.F7MaterialTreeListUI;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgRelationInnerUtils;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitRelationCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitInfo;
import com.kingdee.eas.framework.client.EditUI;
import com.kingdee.eas.framework.client.ListUI;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.client.GeneralKDPromptSelectorAdaptor;
import com.kingdee.eas.scm.sm.pur.PurInvoiceInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import java.awt.Component;
import java.math.BigDecimal;

public class PurInvoiceUIUtil {
    public static void setMaterialF7(KDBizPromptBox prmtMateiral, Object owner) {
        try {
            GeneralKDPromptSelectorAdaptor selectorLisenterMaterial = null;
            selectorLisenterMaterial = new GeneralKDPromptSelectorAdaptor((KDPromptBox)prmtMateiral, (Component)new F7MaterialTreeListUI(), owner, MaterialGroupInfo.getBosType(), "com.kingdee.eas.basedata.master.material.app.F7MaterialFIQuery", "materialGroup.id");
            selectorLisenterMaterial.setQueryProperty("helpCode", "or");
            prmtMateiral.setCommitFormat("$number$;$helpCode$");
            prmtMateiral.setSelector((KDPromptSelector)selectorLisenterMaterial);
            prmtMateiral.addSelectorListener((SelectorListener)selectorLisenterMaterial);
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
            SysUtil.abort();
        }
    }

    public static void setSupplierF7(KDBizPromptBox prmtSupplier, Object owner) {
        try {
            GeneralKDPromptSelectorAdaptor selectorLisenterSupplier = null;
            selectorLisenterSupplier = new GeneralKDPromptSelectorAdaptor((KDPromptBox)prmtSupplier, (Component)new F7SupplierTreeDetailListUI(), owner, CSSPGroupInfo.getBosType(), "com.kingdee.eas.basedata.master.cssp.app.F7SupplierCompanyQuery", "browseGroup.id", "com.kingdee.eas.basedata.master.cssp.app.F7SupplierCompanyQueryWithDefaultStandard");
            selectorLisenterSupplier.setQueryProperty("mnemonicCode", "or");
            prmtSupplier.setCommitFormat("$number$;$mnemonicCode$");
            prmtSupplier.setSelector((KDPromptSelector)selectorLisenterSupplier);
            prmtSupplier.addSelectorListener((SelectorListener)selectorLisenterSupplier);
        }
        catch (Exception er) {
            ExceptionHandler.handle((Throwable)er);
            SysUtil.abort();
        }
    }

    public static void setPurInvoiceBizTypeF7(KDBizPromptBox prmtBizType) {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("billType.number", (Object)"230", CompareType.EQUALS));
        viewInfo.setFilter(filter);
        prmtBizType.setEntityViewInfo(viewInfo);
    }

    public static String getPurInvResource(String key) {
        return EASResource.getString((String)"com.kingdee.eas.scm.sm.pur.PurInvoiceResource", (String)key);
    }

    public static boolean isRelateCreateInv(PurInvoiceInfo purInvoiceInfo) {
        return purInvoiceInfo.getSourceBillType() != null;
    }

    public static void showSuccessMsg(EditUI ui, String msgResource) {
        ui.setMessageText(PurInvoiceUIUtil.getPurInvResource(msgResource));
        ui.showMessage();
    }

    public static void showSuccessMsg(ListUI ui, String msgResource) {
        ui.setMessageText(PurInvoiceUIUtil.getPurInvResource(msgResource));
        ui.showMessage();
    }

    public static String checkCanCancel(String status) {
        String errorStr = null;
        if (status != null) {
            if (status.equals(String.valueOf(BillBaseStatusEnum.AUDITED.getValue()))) {
                errorStr = PurInvoiceUIUtil.getPurInvResource("IsAudit_CantCancel");
            } else if (status.equals(String.valueOf(BillBaseStatusEnum.CLOSED.getValue()))) {
                errorStr = PurInvoiceUIUtil.getPurInvResource("IsClosed_CantCancel");
            } else if (status.equals(String.valueOf(BillBaseStatusEnum.DELETED.getValue()))) {
                errorStr = PurInvoiceUIUtil.getPurInvResource("IsCanceled_Cantcancel");
            } else if (status.equals(String.valueOf(BillBaseStatusEnum.TEMPORARILYSAVED.getValue()))) {
                errorStr = PurInvoiceUIUtil.getPurInvResource("TempSaved_CantCancel");
            } else if (!status.equals(String.valueOf(BillBaseStatusEnum.SUBMITED.getValue()))) {
                errorStr = PurInvoiceUIUtil.getPurInvResource("NotSubmited_CantCancel");
            }
        }
        return errorStr;
    }

    public static boolean isRelationUnit(PurchaseOrgUnitInfo purOrgInfo, CompanyOrgUnitInfo companyUnit) throws Exception {
        boolean ret = false;
        IOrgUnitRelation iUnitRel = OrgUnitRelationFactory.getRemoteInstance();
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("fromUnit", (Object)purOrgInfo.getId().toString(), CompareType.EQUALS));
        filter.setMaskString("#0");
        viewInfo.setFilter(filter);
        viewInfo.getSelector().add(new SelectorItemInfo("*"));
        viewInfo.getSelector().add(new SelectorItemInfo("typeRelation.*"));
        OrgUnitRelationCollection col = iUnitRel.getOrgUnitRelationCollection(viewInfo);
        FullOrgUnitInfo[] unitInfos = null;
        unitInfos = OrgRelationInnerUtils.getDelegateUnitsFromRelationCollection((OrgUnitRelationCollection)col, (OrgType)OrgType.Purchase, (OrgType)OrgType.Company);
        for (int i = 0; i < unitInfos.length; ++i) {
            if (!unitInfos[i].getId().equals((Object)companyUnit.getId())) continue;
            ret = true;
        }
        return ret;
    }

    public static BigDecimal getLittleRate(BigDecimal ratePercent) {
        BigDecimal rate = null;
        if (ratePercent == null) {
            return new BigDecimal("0.00");
        }
        int length = ratePercent.toString().length();
        if (length < 4) {
            length = 4;
        }
        rate = ratePercent.divide(new BigDecimal("100.0"), length, 4);
        return rate;
    }

    public static BigDecimal calculateTaxPrice(BigDecimal taxRate, BigDecimal price) {
        BigDecimal taxPrice = new BigDecimal("0.00");
        if (taxRate == null) {
            taxRate = new BigDecimal("0.00");
        }
        if (price != null) {
            taxRate = PurInvoiceUIUtil.getLittleRate(taxRate);
            taxPrice = price.add(price.multiply(taxRate));
        }
        return taxPrice;
    }

    public static BigDecimal caculatePriceFromAmount(BigDecimal amount, BigDecimal qty, BigDecimal discountRate) {
        BigDecimal price = null;
        if (amount == null || amount.compareTo(new BigDecimal("0.00")) == 0 || qty == null || qty.compareTo(new BigDecimal("0.00")) == 0) {
            return new BigDecimal("0.00");
        }
        if (discountRate == null) {
            discountRate = new BigDecimal("0.00");
        }
        discountRate = PurInvoiceUIUtil.getLittleRate(discountRate);
        int scale = amount.scale() + qty.scale();
        price = amount.divide(qty.multiply(new BigDecimal("1.00").subtract(discountRate)), scale, 4);
        return price;
    }

    public static BigDecimal calculateTaxPriceFromTotalTaxPrice(BigDecimal totalTaxPrice, BigDecimal qty, BigDecimal discountRate) {
        BigDecimal taxPrice = null;
        if (totalTaxPrice == null || totalTaxPrice.compareTo(new BigDecimal("0.00")) == 0 || qty == null || qty.compareTo(new BigDecimal("0.00")) == 0) {
            return new BigDecimal("0.00");
        }
        if (discountRate == null) {
            discountRate = new BigDecimal("0.00");
        }
        discountRate = PurInvoiceUIUtil.getLittleRate(discountRate);
        int scale = totalTaxPrice.scale() + qty.scale();
        taxPrice = totalTaxPrice.divide(qty.multiply(new BigDecimal("1.00").subtract(discountRate)), scale, 4);
        return taxPrice;
    }
}

