/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.pur.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDBigDecimalTextField;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.util.EqualsUtil;
import com.kingdee.eas.base.netctrl.MutexLockType;
import com.kingdee.eas.base.netctrl.MutexParameter;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.framework.util.KDTableUtil;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.RowTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.batchaction.ActionLevelEnum;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchSelectionEntries;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.common.action.ActionProxy;
import com.kingdee.eas.scm.common.action.ActionProxyFactory;
import com.kingdee.eas.scm.common.action.ISupportBatchAction;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.sm.pur.ChangeTypeEnum;
import com.kingdee.eas.scm.sm.pur.PurOrderChangeEntryFactory;
import com.kingdee.eas.scm.sm.pur.PurOrderChangeEntryInfo;
import com.kingdee.eas.scm.sm.pur.PurOrderChangeFactory;
import com.kingdee.eas.scm.sm.pur.PurOrderChangeInfo;
import com.kingdee.eas.scm.sm.pur.PurOrderEntryInfo;
import com.kingdee.eas.scm.sm.pur.client.AbstractPurOrderChangeEditUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.Uuid;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class PurOrderChangeEditUI
extends AbstractPurOrderChangeEditUI {
    private static final Logger logger = CoreUIObject.getLogger(PurOrderChangeEditUI.class);
    private static final String PURORDERNUMBER = "purOrderEntryByNumber";
    private static final String PURORDER = "purOrder";
    private static final String PURORDERENTRYSEQ = "purOrderEntrySeq";
    private static final String PURREQUEST = "purRequest";
    private static final String MATERIALNUMBER = "materialNumber";
    private static final String MATERIALNAME = "materialName";
    private static final String MODEL = "model";
    private static final String MEASUREUNIT = "measureUnit";
    private static final String APPROVALQTY = "approvalQty";
    private static final String BASEQTY = "baseQty";
    private static final String CHANGEQTY = "changeQty";
    private static final String CHANGEBASEQTY = "changeBaseQty";
    private static final String REALCHANGEQTY = "realChangeQty";
    private static final String REALCHANGEBASEQTY = "realChangeBaseQty";
    public static final String AFTERCHANGEQTY = "afterChangeQty";
    public static final String AFTERCHANGEBASEQTY = "afterChangeBaseQty";
    private static final String BASEUNIT = "baseUnit";
    private static final String PRICE = "price";
    private static final String CHANGEDELIVERTIME = "deliverTime";
    private static final String ORIGINDELIVER = "originDeliver";
    private static final String PROJECTNUMBER = "projectNumber";
    private static final String TRACENUMBER = "traceNumber";
    private static final String REMARK = "remark";
    private static final String PURCHASEGROUP = "purchaseGroup";
    private static final String PURCHASER = "purchaser";
    private static final String SUPPLIER = "supplier";
    private static final String REASON = "reason";
    private static final String ID = "ID";
    private static final String PURORDERID = "purOrderID";
    private static final String PURORDERENTRYID = "purOrderEntryID";
    public static final String CHANGEDAYS = "changeDays";
    public static final String REALCHANGEDAYS = "realChangeDays";
    private static BigDecimal allowChangeQty = new BigDecimal("0.00");
    private static final BigDecimal BIGZERO = new BigDecimal("0.00");
    private boolean isHasWork = false;
    private static final String[] QTYPRECISION_QTY = new String[]{"approvalQty", "changeQty", "realChangeQty", "afterChangeQty"};
    private static final String[] QTYPRECISION_BASEQTY = new String[]{"baseQty", "changeBaseQty", "realChangeBaseQty", "afterChangeBaseQty"};
    private static final String[] QTY_COL = new String[]{"changeQty", "realChangeQty", "changeBaseQty", "realChangeBaseQty"};
    private DataChangeListener prmtPurchaseOrgUnitListener;
    private ItemListener comboChangeTypeListener = null;
    private boolean isCopy = false;
    private Timestamp currentCopydate = null;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected KDTable getDetailTable() {
        return this.kdtEntries;
    }

    @Override
    public void loadFields() {
        this.removeListener();
        super.loadFields();
        if (this.getOprtState().equals("ADDNEW") && this.editData.getEntries().size() == 0) {
            this.addLine(this.getDetailTable());
        } else {
            int rowCount = this.kdtEntries.getRowCount();
            if (rowCount != 0) {
                for (int i = 0; i < rowCount; ++i) {
                    this.setQtyColPrecision(i);
                }
            }
        }
        this.addListener();
    }

    protected IObjectValue createNewData() {
        PurOrderChangeInfo purOrderChangeInfo = null;
        try {
            purOrderChangeInfo = (PurOrderChangeInfo)PurOrderChangeFactory.getRemoteInstance().createNewData(this.isUseAgent());
            purOrderChangeInfo.setCU(SysContext.getSysContext().getCurrentCtrlUnit());
            OrgUnitInfo orgUnitInfo = this.getDefaultMainBizOrg();
            if (orgUnitInfo instanceof PurchaseOrgUnitInfo) {
                purOrderChangeInfo.setPurchaseOrgUnit((PurchaseOrgUnitInfo)orgUnitInfo);
            } else {
                purOrderChangeInfo.setPurchaseOrgUnit(null);
            }
            PurOrderChangeEntryInfo entry = (PurOrderChangeEntryInfo)this.createNewDetailData(this.getDetailTable());
            purOrderChangeInfo.getEntries().add(entry);
            purOrderChangeInfo.setChangeType(ChangeTypeEnum.fieldChange);
        }
        catch (EASBizException e) {
            super.handleException((Exception)((Object)e));
        }
        catch (BOSException e) {
            super.handleException((Exception)((Object)e));
        }
        return purOrderChangeInfo;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return PurOrderChangeFactory.getRemoteInstance();
    }

    protected IObjectValue createNewDetailData(KDTable table) {
        PurOrderChangeEntryInfo purOrderChangeEntryInfo = new PurOrderChangeEntryInfo();
        purOrderChangeEntryInfo.setApprovalQty(BIGZERO);
        purOrderChangeEntryInfo.setBaseQty(BIGZERO);
        purOrderChangeEntryInfo.setChangeQty(BIGZERO);
        purOrderChangeEntryInfo.setChangeBaseQty(BIGZERO);
        purOrderChangeEntryInfo.setRealChangeQty(BIGZERO);
        purOrderChangeEntryInfo.setRealChangeBaseQty(BIGZERO);
        return purOrderChangeEntryInfo;
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Purchase;
    }

    protected KDBizPromptBox getMainBizOrg() {
        return this.prmtPurchaseOrgUnit;
    }

    public KDBizPromptBox getMainOrgUnit() {
        return this.prmtPurchaseOrgUnit;
    }

    public KDTextField getNumTextField() {
        return this.txtNumber;
    }

    public void onLoad() throws Exception {
        this.setUITitle(EASResource.getString((String)"com.kingdee.eas.scm.sm.pur.PurUIResource", (String)"PURORDERCHANGE"));
        this.initPurchaseOrgF7();
        this.getDetailTable().addRows(1);
        super.onLoad();
        super.confirmChangeBizOrgUnit(this.prmtPurchaseOrgUnit, PURORDERNUMBER);
        this.setPurOrderF7();
        this.kdtEntries.getColumn(CHANGEDELIVERTIME).getStyleAttributes().setNumberFormat(SCMClientUtils.strDateFormat);
        this.setMaterialF7();
        this.addDateEditor(CHANGEDELIVERTIME);
        this.addNumEditor(CHANGEQTY);
        this.setEntriesTableStrLength();
        this.initDiscardStatus();
        this.initBtnStatus();
        if (this.kDSourceBillType.getValue() != null) {
            this.prmtPurchaseOrgUnit.setEditable(false);
            this.prmtPurchaseOrgUnit.setEnabled(false);
            this.kdtEntries.getColumn(PURORDERNUMBER).getStyleAttributes().setLocked(true);
            this.btnInsertLine.setEnabled(false);
            this.btnAddLine.setEnabled(false);
            this.actionInsertLine.setEnabled(false);
            this.actionAddLine.setEnabled(false);
        }
        this.displayPriceColumnByPermission();
    }

    private void initBtnStatus() {
        this.menuTable.setVisible(false);
        this.btnUnAudit.setVisible(false);
        this.btnCreateFrom.setVisible(false);
        this.menuItemUnAudit.setVisible(false);
        this.menuItemCopyLine.setVisible(false);
        this.actionUnAudit.setEnabled(false);
        this.btnTraceDown.setVisible(false);
        this.actionTraceDown.setEnabled(false);
    }

    protected void initListener() {
        super.initListener();
    }

    public void addListener() {
        this.prmtPurchaseOrgUnitListener = new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                try {
                    PurOrderChangeEditUI.this.prmtPurchaseOrgUnit_dataChanged(e);
                }
                catch (Exception exc) {
                    PurOrderChangeEditUI.this.handUIException(exc);
                }
            }
        };
        this.prmtPurchaseOrgUnit.addDataChangeListener(this.prmtPurchaseOrgUnitListener);
        this.comboChangeTypeListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                try {
                    PurOrderChangeEditUI.this.comboChangeType_dataChanged(e);
                }
                catch (Exception exc) {
                    PurOrderChangeEditUI.this.handUIException(exc);
                }
            }
        };
        this.comboChangeType.addItemListener(this.comboChangeTypeListener);
    }

    protected void comboChangeType_dataChanged(ItemEvent e) throws Exception {
        if (e.getStateChange() == 1 && this.getDetailTable().getRowCount3() != 0) {
            int result = MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.scm.sm.pur.PurUIResource", (String)"CLEAR_ENTRY"));
            if (result == 0) {
                this.getDetailTable().removeRows();
                this.addLine(this.getDetailTable());
            } else {
                this.comboChangeType.removeItemListener(this.comboChangeTypeListener);
                if (e.getItem() == ChangeTypeEnum.entryChange) {
                    this.comboChangeType.setSelectedItem((Object)ChangeTypeEnum.fieldChange);
                } else {
                    this.comboChangeType.setSelectedItem((Object)ChangeTypeEnum.entryChange);
                }
                this.comboChangeType.addItemListener(this.comboChangeTypeListener);
                SysUtil.abort();
            }
        }
    }

    private void removeListener() {
        if (this.prmtPurchaseOrgUnitListener != null) {
            this.prmtPurchaseOrgUnit.removeDataChangeListener(this.prmtPurchaseOrgUnitListener);
        }
        if (this.comboChangeTypeListener != null) {
            this.comboChangeType.removeItemListener(this.comboChangeTypeListener);
        }
    }

    private void initPurchaseOrgF7() {
        try {
            this.setMainBizOrgF7(this.prmtPurchaseOrgUnit, OrgType.Purchase);
        }
        catch (Exception ex) {
            this.handUIException(ex);
        }
    }

    private void setPurOrderF7() {
        KDBizPromptBox kdBizPromptBox = new KDBizPromptBox();
        kdBizPromptBox.setQueryInfo("com.kingdee.eas.scm.sm.pur.app.F7PurOrderEntryQuery");
        kdBizPromptBox.setEditFormat("$parent.number$");
        kdBizPromptBox.setDisplayFormat("$parent.number$");
        kdBizPromptBox.setCommitFormat("$parent.number$");
        kdBizPromptBox.setEnabledMultiSelection(true);
        this.kdtEntries.getColumn(PURORDERNUMBER).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)kdBizPromptBox));
        IColumn colF7 = this.kdtEntries.getColumn(PURORDERNUMBER);
        ObjectValueRender avr = new ObjectValueRender();
        avr.setFormat((IDataFormat)new BizDataFormat("$parent.number$"));
        colF7.setRenderer((IBasicRender)avr);
        IColumn materialColF7 = this.kdtEntries.getColumn(MATERIALNUMBER);
        ObjectValueRender materialAvr = new ObjectValueRender();
        materialAvr.setFormat((IDataFormat)new BizDataFormat("$number$"));
        materialColF7.setRenderer((IBasicRender)materialAvr);
    }

    private void initPurOrderF7() {
        PurchaseOrgUnitInfo purchaseOrgUnitInfo = (PurchaseOrgUnitInfo)this.prmtPurchaseOrgUnit.getData();
        SelectorItemCollection sic = this.getPropetySelector();
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        if (purchaseOrgUnitInfo != null || purchaseOrgUnitInfo.getId() != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("purchaseOrgUnit.id", (Object)purchaseOrgUnitInfo.getId().toString(), CompareType.EQUALS));
        }
        if (this.comboChangeType.getSelectedItem().equals((Object)ChangeTypeEnum.entryChange)) {
            filterInfo.getFilterItems().add(new FilterItemInfo("baseStatus", (Object)4, CompareType.EQUALS));
        } else {
            filterInfo.getFilterItems().add(new FilterItemInfo("baseStatus", (Object)"4,7", CompareType.INCLUDE));
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("sourceBillEntryId", null, CompareType.IS));
        filterInfo.getFilterItems().add(new FilterItemInfo("baseStatus", (Object)"4,7", CompareType.INCLUDE));
        Integer rowConut = this.kdtEntries.getRowCount();
        if (rowConut > 0) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < rowConut; ++i) {
                if (this.kdtEntries.getCell(i, PURORDERENTRYID).getValue() == null) continue;
                sb.append(this.kdtEntries.getCell(i, PURORDERENTRYID).getValue().toString());
                if (i == rowConut - 1) continue;
                sb.append(",");
            }
            if (!sb.toString().equals("")) {
                filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)sb.toString(), CompareType.NOTINCLUDE));
            }
        }
        viewInfo.setFilter(filterInfo);
        ((KDBizPromptBox)this.kdtEntries.getColumn(PURORDERNUMBER).getEditor().getComponent()).setEntityViewInfo(viewInfo);
        ((KDBizPromptBox)this.kdtEntries.getColumn(PURORDERNUMBER).getEditor().getComponent()).setSelectorCollection(sic);
        IColumn colF7 = this.kdtEntries.getColumn(PURORDERNUMBER);
        ObjectValueRender avr = new ObjectValueRender();
        avr.setFormat((IDataFormat)new BizDataFormat("$parent.number$"));
        colF7.setRenderer((IBasicRender)avr);
    }

    private SelectorItemCollection getPropetySelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("parent.id"));
        sic.add(new SelectorItemInfo("parent.number"));
        sic.add(new SelectorItemInfo("purRequestID"));
        sic.add(new SelectorItemInfo("baseUnit.name"));
        sic.add(new SelectorItemInfo("baseUnit.qtyPrecision"));
        sic.add(new SelectorItemInfo("project.number"));
        sic.add(new SelectorItemInfo("project.id"));
        sic.add(new SelectorItemInfo("project.name"));
        sic.add(new SelectorItemInfo("trackNo.number"));
        sic.add(new SelectorItemInfo("trackNo.id"));
        sic.add(new SelectorItemInfo("trackNo.name"));
        sic.add(new SelectorItemInfo("rowType.id"));
        sic.add(new SelectorItemInfo("rowType.isHasMaterialNumber"));
        sic.add(new SelectorItemInfo("parent.purchaseGroup.number"));
        sic.add(new SelectorItemInfo("parent.purchaseGroup.id"));
        sic.add(new SelectorItemInfo("parent.purchaseGroup.name"));
        sic.add(new SelectorItemInfo("parent.purchasePerson.number"));
        sic.add(new SelectorItemInfo("parent.purchasePerson.id"));
        sic.add(new SelectorItemInfo("parent.purchasePerson.name"));
        sic.add(new SelectorItemInfo("parent.supplier.number"));
        sic.add(new SelectorItemInfo("parent.supplier.id"));
        sic.add(new SelectorItemInfo("parent.supplier.name"));
        sic.add(new SelectorItemInfo(PRICE));
        sic.add(new SelectorItemInfo("deliveryDate"));
        sic.add(new SelectorItemInfo(BASEQTY));
        sic.add(new SelectorItemInfo("qty"));
        sic.add(new SelectorItemInfo("material.number"));
        sic.add(new SelectorItemInfo("material.name"));
        sic.add(new SelectorItemInfo("material.model"));
        sic.add(new SelectorItemInfo("unit.name"));
        sic.add(new SelectorItemInfo("unit.qtyPrecision"));
        sic.add(new SelectorItemInfo("seq"));
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("totalReceiveQty"));
        sic.add(new SelectorItemInfo("totalReceiptQty"));
        sic.add(new SelectorItemInfo("totalReturnedQty"));
        sic.add(new SelectorItemInfo("totalSupplyStockQty"));
        sic.add(new SelectorItemInfo(MATERIALNAME));
        sic.add(new SelectorItemInfo("sourceBillType.name"));
        sic.add(new SelectorItemInfo("sourceBillType.id"));
        sic.add(new SelectorItemInfo("sourceBillType.number"));
        sic.add(new SelectorItemInfo("sourceBillEntrySeq"));
        sic.add(new SelectorItemInfo("baseStatus"));
        sic.add(new SelectorItemInfo("noNumMaterialModel"));
        return sic;
    }

    private void prmtPurchaseOrgUnit_dataChanged(DataChangeEvent e) throws EASBizException, BOSException {
        if (e.getNewValue() == null || EqualsUtil.equals((Object)e.getOldValue(), (Object)e.getNewValue())) {
            return;
        }
        this.initPurOrderF7();
        this.displayPriceColumnByPermission();
    }

    private void displayPriceColumnByPermission() throws BOSException, EASBizException {
        if (this.prmtPurchaseOrgUnit.getData() == null) {
            return;
        }
        PurchaseOrgUnitInfo purchaseOrgUnitInfo = (PurchaseOrgUnitInfo)this.prmtPurchaseOrgUnit.getData();
        ObjectUuidPK userPK = new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId());
        ObjectUuidPK orgPK = new ObjectUuidPK(purchaseOrgUnitInfo.getId());
        boolean isHasPermission = PermissionFactory.getRemoteInstance().hasFunctionPermission((IObjectPK)userPK, (IObjectPK)orgPK, "purorderc_price_view");
        this.kdtEntries.getColumn(PRICE).getStyleAttributes().setHided(!isHasPermission);
        int width = isHasPermission ? 100 : -1;
        this.kdtEntries.getColumn(PRICE).setWidth(width);
    }

    @Override
    protected void kdtEntries_editStarting(KDTEditEvent e) throws Exception {
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        String fieldName = this.kdtEntries.getColumnKey(colIndex);
        if (PURORDERNUMBER.equalsIgnoreCase(fieldName)) {
            this.initPurOrderF7();
        }
    }

    @Override
    public void kdtEntries_editStopped(KDTEditEvent e) throws Exception {
        Object oldValue = null;
        Object newValue = e.getValue();
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        String fieldName = this.kdtEntries.getColumnKey(colIndex);
        if (PURORDERNUMBER.equalsIgnoreCase(fieldName)) {
            if (e.getOldValue() == e.getValue()) {
                return;
            }
            if (e.getValue() == null) {
                this.clearEntryParams(rowIndex, colIndex);
            } else {
                this.afterSelectPurOrder(rowIndex, colIndex);
            }
        } else if (CHANGEQTY.equalsIgnoreCase(fieldName)) {
            if (this.kdtEntries.getCell(e.getRowIndex(), PURORDERNUMBER).getValue() == null) {
                this.kdtEntries.getCell(e.getRowIndex(), CHANGEQTY).setValue((Object)new BigDecimal("0.00"));
            } else {
                BigDecimal oldchangeQty = (BigDecimal)e.getOldValue();
                BigDecimal changeQty = new BigDecimal(this.kdtEntries.getCell(e.getRowIndex(), CHANGEQTY).getValue().toString());
                PurOrderEntryInfo info = (PurOrderEntryInfo)this.kdtEntries.getCell(e.getRowIndex(), PURORDERNUMBER).getValue();
                BigDecimal approvalQty = new BigDecimal(this.kdtEntries.getCell(e.getRowIndex(), APPROVALQTY).getValue().toString());
                PurOrderEntryInfo entry = (PurOrderEntryInfo)this.kdtEntries.getCell(rowIndex, PURORDERNUMBER).getValue();
                if (entry.getBaseStatus() != EntryBaseStatusEnum.CLOSED && changeQty.add(approvalQty).compareTo(BIGZERO) < 0) {
                    this.kdtEntries.getCell(rowIndex, CHANGEQTY).setValue((Object)oldchangeQty);
                    return;
                }
                this.kdtEntries.getCell(e.getRowIndex(), CHANGEBASEQTY).setValue((Object)this.getCommomBaseQty(e.getRowIndex(), CHANGEQTY, info));
                if (changeQty.compareTo(BIGZERO) == -1) {
                    this.kdtEntries.getCell(rowIndex, CHANGEQTY).getStyleAttributes().setFontColor(Color.RED);
                    this.kdtEntries.getCell(rowIndex, CHANGEBASEQTY).getStyleAttributes().setFontColor(Color.RED);
                } else {
                    this.kdtEntries.getCell(rowIndex, CHANGEQTY).getStyleAttributes().setFontColor(Color.black);
                    this.kdtEntries.getCell(rowIndex, CHANGEBASEQTY).getStyleAttributes().setFontColor(Color.black);
                }
            }
        } else if (CHANGEDELIVERTIME.equalsIgnoreCase(fieldName)) {
            Date oldDay = (Date)this.kdtEntries.getCell(rowIndex, ORIGINDELIVER).getValue();
            Date changeDay = (Date)this.kdtEntries.getCell(rowIndex, CHANGEDELIVERTIME).getValue();
            if (null == changeDay) {
                this.kdtEntries.getCell(rowIndex, CHANGEDELIVERTIME).setValue((Object)oldDay);
                this.kdtEntries.getCell(rowIndex, CHANGEDAYS).setValue((Object)0);
                return;
            }
            if (null != oldDay) {
                this.calchangeDays(rowIndex, oldDay, changeDay);
            }
        }
    }

    private void afterSelectPurOrder(int rowIndex, int colIndex) throws EASBizException, BOSException {
        ICell cell = this.kdtEntries.getCell(rowIndex, PURORDERNUMBER);
        if (cell.getValue() == null) {
            return;
        }
        if (cell.getValue() instanceof PurOrderEntryInfo[]) {
            PurOrderEntryInfo[] purOrderEntryAtr = (PurOrderEntryInfo[])cell.getValue();
            this.setMultiEntryByPurOrder(rowIndex, colIndex, purOrderEntryAtr);
        } else if (cell.getValue() instanceof Object[]) {
            Object[] objects = (Object[])cell.getValue();
            if (objects.length == 0) {
                return;
            }
            PurOrderEntryInfo[] purOrderEntryAtr = new PurOrderEntryInfo[objects.length];
            System.arraycopy(objects, 0, purOrderEntryAtr, 0, objects.length);
            this.setMultiEntryByPurOrder(rowIndex, colIndex, purOrderEntryAtr);
        } else if (cell.getValue() instanceof PurOrderEntryInfo) {
            PurOrderEntryInfo purOrderEntry = (PurOrderEntryInfo)cell.getValue();
            this.purOrderLinkOther(rowIndex, colIndex, purOrderEntry);
        }
    }

    private void setMultiEntryByPurOrder(int rowIndex, int colIndex, PurOrderEntryInfo[] purOrderEntryAtr) throws EASBizException, BOSException {
        int insertAddRow = 0;
        for (int i = 0; i < purOrderEntryAtr.length; ++i) {
            PurOrderEntryInfo purOrderEntryInfo = purOrderEntryAtr[i];
            if (i == 0) {
                this.purOrderLinkOther(rowIndex, colIndex, purOrderEntryInfo);
                continue;
            }
            super.insertLine(rowIndex + insertAddRow + 1);
            this.purOrderLinkOther(rowIndex + insertAddRow + 1, colIndex, purOrderEntryInfo);
            ++insertAddRow;
        }
    }

    private BigDecimal getCommomBaseQty(int rowIndex, String qty, PurOrderEntryInfo purOrderInfo) throws BOSException, EASBizException {
        BigDecimal approvalQty = new BigDecimal("0.00");
        BigDecimal targetQty = new BigDecimal("0.00");
        MeasureUnitInfo baseUnit = purOrderInfo.getUnit();
        if (purOrderInfo.getMaterial() == null) {
            MeasureUnitInfo baseUnitInfo = (MeasureUnitInfo)this.getDetailTable().getRow(rowIndex).getCell(BASEUNIT).getValue();
            if (this.kdtEntries.getCell(rowIndex, qty).getValue() != null) {
                approvalQty = new BigDecimal(this.kdtEntries.getCell(rowIndex, qty).getValue().toString());
            }
            targetQty = SCMUtils.getExchangeQtyForClient((String)baseUnitInfo.getId().toString(), (MeasureUnitInfo)baseUnit, (MeasureUnitInfo)purOrderInfo.getBaseUnit(), (BigDecimal)approvalQty);
        } else {
            if (this.kdtEntries.getCell(rowIndex, qty).getValue() != null) {
                approvalQty = new BigDecimal(this.kdtEntries.getCell(rowIndex, qty).getValue().toString());
            }
            targetQty = SCMUtils.getExchangeQtyForClient((String)purOrderInfo.getMaterial().getId().toString(), (MeasureUnitInfo)baseUnit, (MeasureUnitInfo)purOrderInfo.getBaseUnit(), (BigDecimal)approvalQty);
        }
        if (targetQty == null) {
            targetQty = BIGZERO;
        }
        return targetQty;
    }

    private void changeQtyChange(KDTEditEvent e) throws EASBizException, BOSException {
        int rowIndex = e.getRowIndex();
        PurOrderEntryInfo purOrderInfo = (PurOrderEntryInfo)this.kdtEntries.getCell(rowIndex, PURORDERNUMBER).getValue();
        BigDecimal targetQty = this.getCommomBaseQty(e.getRowIndex(), CHANGEQTY, purOrderInfo);
        this.kdtEntries.getCell(rowIndex, CHANGEBASEQTY).setValue((Object)targetQty);
        BigDecimal changeQty = new BigDecimal("0.00");
        if (this.kdtEntries.getCell(rowIndex, CHANGEQTY).getValue() != null) {
            changeQty = new BigDecimal(this.kdtEntries.getCell(rowIndex, CHANGEQTY).getValue().toString());
        }
        this.kdtEntries.getCell(rowIndex, CHANGEQTY).setValue((Object)changeQty);
        BigDecimal compare = new BigDecimal("0.00");
        if (targetQty.compareTo(compare) == -1) {
            if (changeQty.compareTo(allowChangeQty) == 1) {
                this.kdtEntries.getCell(rowIndex, REALCHANGEQTY).setValue((Object)targetQty);
                this.kdtEntries.getCell(rowIndex, REALCHANGEBASEQTY).setValue((Object)this.getCommomBaseQty(e.getRowIndex(), REALCHANGEQTY, purOrderInfo));
            } else {
                BigDecimal baseQty = new BigDecimal(this.kdtEntries.getCell(rowIndex, BASEQTY).getValue().toString());
                this.kdtEntries.getCell(rowIndex, REALCHANGEQTY).setValue((Object)baseQty);
                this.kdtEntries.getCell(rowIndex, REALCHANGEBASEQTY).setValue((Object)this.getCommomBaseQty(e.getRowIndex(), REALCHANGEQTY, purOrderInfo));
            }
        } else if (targetQty.compareTo(compare) == 1) {
            BigDecimal baseQty = new BigDecimal(this.kdtEntries.getCell(rowIndex, BASEQTY).getValue().toString());
            this.kdtEntries.getCell(rowIndex, REALCHANGEQTY).setValue((Object)baseQty);
            this.kdtEntries.getCell(rowIndex, REALCHANGEBASEQTY).setValue((Object)this.getCommomBaseQty(e.getRowIndex(), REALCHANGEQTY, purOrderInfo));
        } else {
            BigDecimal baseQty = new BigDecimal(this.kdtEntries.getCell(rowIndex, BASEQTY).getValue().toString());
            this.kdtEntries.getCell(rowIndex, REALCHANGEQTY).setValue((Object)targetQty);
            this.kdtEntries.getCell(rowIndex, REALCHANGEBASEQTY).setValue((Object)this.getCommomBaseQty(e.getRowIndex(), REALCHANGEQTY, purOrderInfo));
        }
    }

    private void purOrderLinkOther(int rowIndex, int colIndex, PurOrderEntryInfo purOrderEntryInfo) throws BOSException, EASBizException {
        this.kdtEntries.getCell(rowIndex, PURORDERNUMBER).setValue((Object)purOrderEntryInfo);
        this.kdtEntries.getCell(rowIndex, PURORDER).setValue((Object)purOrderEntryInfo.getParent());
        this.kdtEntries.getCell(rowIndex, PURORDERENTRYSEQ).setValue((Object)purOrderEntryInfo.getSeq());
        this.kdtEntries.getCell(rowIndex, PURORDERID).setValue((Object)purOrderEntryInfo.getParent().getId());
        this.kdtEntries.getCell(rowIndex, PURORDERENTRYID).setValue((Object)purOrderEntryInfo.getId());
        RowTypeInfo rowType = purOrderEntryInfo.getRowType();
        if (rowType.isIsHasMaterialNumber()) {
            this.kdtEntries.getCell(rowIndex, MATERIALNUMBER).setValue((Object)purOrderEntryInfo.getMaterial());
            if (purOrderEntryInfo.getMaterial() != null) {
                this.kdtEntries.getCell(rowIndex, MATERIALNAME).setValue((Object)purOrderEntryInfo.getMaterial().getName());
                this.kdtEntries.getCell(rowIndex, MODEL).setValue((Object)purOrderEntryInfo.getMaterial().getModel());
            }
        } else {
            this.kdtEntries.getCell(rowIndex, MATERIALNAME).setValue((Object)purOrderEntryInfo.getMaterialName());
            this.kdtEntries.getCell(rowIndex, MODEL).setValue((Object)purOrderEntryInfo.getNoNumMaterialModel());
        }
        this.kdtEntries.getCell(rowIndex, BASEUNIT).setValue((Object)purOrderEntryInfo.getBaseUnit());
        this.kdtEntries.getCell(rowIndex, MEASUREUNIT).setValue((Object)purOrderEntryInfo.getUnit());
        this.kdtEntries.getCell(rowIndex, PRICE).setValue((Object)purOrderEntryInfo.getPrice());
        this.kdtEntries.getCell(rowIndex, ORIGINDELIVER).setValue((Object)purOrderEntryInfo.getDeliveryDate());
        this.kdtEntries.getCell(rowIndex, CHANGEDELIVERTIME).setValue((Object)purOrderEntryInfo.getDeliveryDate());
        if (purOrderEntryInfo.getProject() != null) {
            this.kdtEntries.getCell(rowIndex, PROJECTNUMBER).setValue((Object)purOrderEntryInfo.getProject());
        }
        if (purOrderEntryInfo.getTrackNo() != null) {
            this.kdtEntries.getCell(rowIndex, TRACENUMBER).setValue((Object)purOrderEntryInfo.getTrackNo());
        }
        if (purOrderEntryInfo.getRemark() != null) {
            this.kdtEntries.getCell(rowIndex, REMARK).setValue((Object)purOrderEntryInfo.getRemark());
        }
        if (purOrderEntryInfo.getParent().getPurchaseGroup() != null) {
            this.kdtEntries.getCell(rowIndex, PURCHASEGROUP).setValue((Object)purOrderEntryInfo.getParent().getPurchaseGroup());
        }
        if (purOrderEntryInfo.getParent().getPurchasePerson() != null) {
            this.kdtEntries.getCell(rowIndex, PURCHASER).setValue((Object)purOrderEntryInfo.getParent().getPurchasePerson());
        }
        if (purOrderEntryInfo.getParent().getSupplier() != null) {
            this.kdtEntries.getCell(rowIndex, SUPPLIER).setValue((Object)purOrderEntryInfo.getParent().getSupplier());
        }
        this.kdtEntries.getCell(rowIndex, APPROVALQTY).setValue((Object)purOrderEntryInfo.getQty());
        this.kdtEntries.getCell(rowIndex, BASEQTY).setValue((Object)this.getCommomBaseQty(rowIndex, APPROVALQTY, purOrderEntryInfo));
        this.kdtEntries.getCell(rowIndex, ID).setValue((Object)purOrderEntryInfo.getId());
        if (purOrderEntryInfo.getSourceBillType() != null && purOrderEntryInfo.getSourceBillType().getId().toString().equals("510b6503-0105-1000-e000-0107c0a812fd463ED552")) {
            this.kdtEntries.getCell(rowIndex, PURREQUEST).setValue((Object)purOrderEntryInfo.getSourceBillEntrySeq());
        } else {
            this.kdtEntries.getCell(rowIndex, PURREQUEST).setValue(null);
        }
        this.setQtyColPrecision(rowIndex);
    }

    public void calchangeDays(int rowIndex, Date date1, Date date2) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String day1 = sdf.format(date1);
        String day2 = sdf.format(date2);
        date1 = sdf.parse(day1);
        date2 = sdf.parse(day2);
        Integer changeDays = (int)((date2.getTime() - date1.getTime()) / 86400000L);
        this.kdtEntries.getCell(rowIndex, CHANGEDAYS).setValue((Object)changeDays);
    }

    private void setQtyColPrecision(int rowIndex) {
        MeasureUnitInfo measureUnitInfo;
        MaterialInfo materialInfo = (MaterialInfo)this.kdtEntries.getCell(rowIndex, MATERIALNUMBER).getValue();
        if (this.kdtEntries.getRow(rowIndex).getCell(MEASUREUNIT) != null && (measureUnitInfo = (MeasureUnitInfo)this.kdtEntries.getRow(rowIndex).getCell(MEASUREUNIT).getValue()) != null) {
            try {
                if (null != materialInfo) {
                    SCMClientUtils.changeTableColPrecisionByMaterial((MaterialInfo)materialInfo, (MeasureUnitInfo)measureUnitInfo, (KDTable)this.kdtEntries, (String[])QTYPRECISION_QTY, (int)rowIndex, (boolean)true);
                } else {
                    SCMClientUtils.changeTableColPrecision((int)measureUnitInfo.getQtyPrecision(), (KDTable)this.kdtEntries, (String[])QTYPRECISION_QTY, (int)rowIndex, (boolean)true);
                }
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
        if (this.kdtEntries.getRow(rowIndex).getCell(BASEUNIT) != null && (measureUnitInfo = (MeasureUnitInfo)this.kdtEntries.getRow(rowIndex).getCell(BASEUNIT).getValue()) != null) {
            try {
                if (null != materialInfo) {
                    SCMClientUtils.changeTableColPrecisionByMaterial((MaterialInfo)materialInfo, (MeasureUnitInfo)measureUnitInfo, (KDTable)this.kdtEntries, (String[])QTYPRECISION_BASEQTY, (int)rowIndex, (boolean)true);
                } else {
                    SCMClientUtils.changeTableColPrecision((int)measureUnitInfo.getQtyPrecision(), (KDTable)this.kdtEntries, (String[])QTYPRECISION_BASEQTY, (int)rowIndex, (boolean)true);
                }
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
        for (int i = 0; i < QTY_COL.length; ++i) {
            String col = QTY_COL[i];
            BigDecimal qty = (BigDecimal)this.kdtEntries.getCell(rowIndex, col).getValue();
            if (null == qty || qty.compareTo(BIGZERO) >= 0) continue;
            this.kdtEntries.getCell(rowIndex, col).getStyleAttributes().setFontColor(Color.RED);
        }
    }

    private void addDateEditor(String colName) {
        KDTable table = this.kdtEntries;
        table.getColumn(colName).setEditor((ICellEditor)new KDTDefaultCellEditor(new KDDatePicker()));
    }

    private void addNumEditor(String colName) {
        KDTable table = this.kdtEntries;
        table.getColumn(colName).setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)new KDBigDecimalTextField()));
    }

    private void allowNegatived(String colName) {
        KDFormattedTextField textField = new KDFormattedTextField();
        textField.setDataType(1);
        textField.setNegatived(true);
        this.kdtEntries.getColumn(colName).setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)textField));
    }

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
        this.actionAddLine.putValue("SmallIcon", (Object)EASResource.getIcon((String)"imgTbtn_addline"));
        this.actionInsertLine.putValue("SmallIcon", (Object)EASResource.getIcon((String)"imgTbtn_insert"));
        this.actionRemoveLine.putValue("SmallIcon", (Object)EASResource.getIcon((String)"imgTbtn_deleteline"));
        ArrayList<JButton> btnList = new ArrayList<JButton>();
        btnList.add(this.kDContainer1.add((Action)this.actionAddLine));
        btnList.add(this.kDContainer1.add((Action)this.actionInsertLine));
        btnList.add(this.kDContainer1.add((Action)this.actionRemoveLine));
        for (int i = 0; i < btnList.size(); ++i) {
            KDWorkButton btn = (KDWorkButton)btnList.get(i);
            btn.setText(null);
            btn.setSize(new Dimension(22, 19));
            btn.setEnabled(true);
        }
    }

    public boolean isHasWork() {
        return this.isHasWork;
    }

    public Component[] getCtrlComponents() {
        return new Component[]{this.btnEdit, this.btnPre, this.btnNext, this.btnAddLine, this.btnRemoveLine, this.btnInsertLine, this.btnCopy, this.btnSave, this.btnRemove, this.btnSubmit};
    }

    protected String getPermissionItem(String status) {
        if (status.equals("ADDNEW")) {
            return "purorderc_addnew";
        }
        return null;
    }

    public void doWork() throws Exception {
    }

    public void beforeActionPerformed(ActionEvent e) {
        this.isHasWork = false;
        super.beforeActionPerformed(e);
    }

    public void afterActionPerformed(ActionEvent e) {
        super.afterActionPerformed(e);
    }

    public boolean beforeAction(BatchActionEnum bizAction, BatchSelectionEntries selectionEntries, ActionEvent event) {
        this.getDetailTable().getEditManager().stopEditing();
        this.isHasWork = false;
        boolean result = super.beforeAction(bizAction, selectionEntries, event);
        this.curBizAction = bizAction;
        if (BatchActionEnum.SAVE.equals((Object)bizAction) || BatchActionEnum.SUBMIT.equals((Object)bizAction) || BatchActionEnum.AUDIT.equals((Object)bizAction)) {
            // empty if block
        }
        return result;
    }

    public void afterAction(BatchActionEnum bizAction, BatchSelectionEntries selectionEntries, int countSuccess) {
        super.afterAction(bizAction, selectionEntries, countSuccess);
        if (BatchActionEnum.SAVE.equals((Object)bizAction)) {
            this.initDiscardStatus();
        } else if (BatchActionEnum.SUBMIT.equals((Object)bizAction)) {
            this.initDiscardStatus();
        } else if (BatchActionEnum.AUDIT.equals((Object)bizAction)) {
            this.actionUnAudit.setEnabled(false);
            this.initDiscardStatus();
        } else if (BatchActionEnum.UNAUDIT.equals((Object)bizAction)) {
            this.initDiscardStatus();
        }
    }

    protected void initBatchActions() throws BOSException {
        this.actionManager.setClzIBizFactory(ActionLevelEnum.HEAD, PurOrderChangeFactory.class);
        this.actionManager.setClzIBizFactory(ActionLevelEnum.ENTRY, PurOrderChangeEntryFactory.class);
        this.getTableSelectionHelper().setTableProperty((ISupportBatchAction)this, this.getDetailTable(), ID, this.txtNumber, null);
        ActionProxy actionProxy = ActionProxyFactory.createActionProxy((BatchActionEnum)BatchActionEnum.CANCEL, (ItemAction)this.actionMyCancel, (String)"cancelWithReason");
        this.actionManager.registerBatchAction(actionProxy, "actionMyCancel");
        actionProxy.bindTo((AbstractButton)this.btnMyCancel);
        super.initBatchActions();
    }

    public boolean isSupportedBatchActions() {
        return true;
    }

    protected void afterAddLine(KDTable table, IObjectValue lineData) {
        super.afterAddLine(table, lineData);
        int rowCount = this.getDetailTable().getRowCount();
        int selectedrow = rowCount - 1;
        this.setDefaultPrecision(selectedrow);
    }

    private void setDefaultPrecision(int selectedrow) {
        if (selectedrow < 0) {
            return;
        }
        SCMClientUtils.changeTableColPrecision((int)2, (KDTable)this.getDetailTable(), (String[])QTYPRECISION_QTY, (int)selectedrow, (boolean)true);
        SCMClientUtils.changeTableColPrecision((int)2, (KDTable)this.getDetailTable(), (String[])QTYPRECISION_BASEQTY, (int)selectedrow, (boolean)true);
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("entries.purOrderEntry.id"));
        sic.add(new SelectorItemInfo("entries.purOrderEntry.number"));
        sic.add(new SelectorItemInfo("entries.purOrderEntry.seq"));
        sic.add(new SelectorItemInfo("entries.purOrderEntry.parent.id"));
        sic.add(new SelectorItemInfo("entries.purOrderEntry.parent.number"));
        sic.add(new SelectorItemInfo("entries.purOrderEntry.parent.purRequestID"));
        sic.add(new SelectorItemInfo("entries.purOrderEntry.parent.purchaseGroup.id"));
        sic.add(new SelectorItemInfo("entries.purOrderEntry.parent.purchaseGroup.name"));
        sic.add(new SelectorItemInfo("entries.purOrderEntry.parent.purchaseGroup.number"));
        sic.add(new SelectorItemInfo("entries.purOrderEntry.parent.purchasePerson.id"));
        sic.add(new SelectorItemInfo("entries.purOrderEntry.parent.purchasePerson.name"));
        sic.add(new SelectorItemInfo("entries.purOrderEntry.parent.purchasePerson.number"));
        sic.add(new SelectorItemInfo("entries.purOrderEntry.parent.supplier.id"));
        sic.add(new SelectorItemInfo("entries.purOrderEntry.parent.supplier.name"));
        sic.add(new SelectorItemInfo("entries.purOrderEntry.parent.supplier.number"));
        sic.add(new SelectorItemInfo("entries.purOrderEntry.project.id"));
        sic.add(new SelectorItemInfo("entries.purOrderEntry.project.name"));
        sic.add(new SelectorItemInfo("entries.purOrderEntry.project.number"));
        sic.add(new SelectorItemInfo("entries.purOrderEntry.trackNo.id"));
        sic.add(new SelectorItemInfo("entries.purOrderEntry.trackNo.name"));
        sic.add(new SelectorItemInfo("entries.purOrderEntry.trackNo.number"));
        sic.add(new SelectorItemInfo("entries.purOrderEntry.deliveryDate"));
        sic.add(new SelectorItemInfo("entries.purOrderEntry.price"));
        return sic;
    }

    private void clearEntryParams(int rowIndex, int colIndex) {
        this.kdtEntries.getCell(rowIndex, PURORDERNUMBER).setValue(null);
        this.kdtEntries.getCell(rowIndex, PURORDERENTRYSEQ).setValue(null);
        this.kdtEntries.getCell(rowIndex, PURORDER).setValue(null);
        this.kdtEntries.getCell(rowIndex, MATERIALNUMBER).setValue(null);
        this.kdtEntries.getCell(rowIndex, MATERIALNAME).setValue(null);
        this.kdtEntries.getCell(rowIndex, MODEL).setValue(null);
        this.kdtEntries.getCell(rowIndex, MEASUREUNIT).setValue(null);
        this.kdtEntries.getCell(rowIndex, BASEUNIT).setValue(null);
        this.kdtEntries.getCell(rowIndex, PROJECTNUMBER).setValue(null);
        this.kdtEntries.getCell(rowIndex, TRACENUMBER).setValue(null);
        this.kdtEntries.getCell(rowIndex, PURCHASEGROUP).setValue(null);
        this.kdtEntries.getCell(rowIndex, PURCHASER).setValue(null);
        this.kdtEntries.getCell(rowIndex, SUPPLIER).setValue(null);
        this.kdtEntries.getCell(rowIndex, PRICE).setValue(null);
        this.kdtEntries.getCell(rowIndex, ORIGINDELIVER).setValue(null);
        this.kdtEntries.getCell(rowIndex, CHANGEDELIVERTIME).setValue(null);
        this.kdtEntries.getCell(rowIndex, PRICE).setValue(null);
        this.kdtEntries.getCell(rowIndex, PURORDERID).setValue(null);
        this.kdtEntries.getCell(rowIndex, PURORDERENTRYID).setValue(null);
        this.kdtEntries.getCell(rowIndex, BASEQTY).setValue((Object)BIGZERO);
        this.kdtEntries.getCell(rowIndex, APPROVALQTY).setValue((Object)BIGZERO);
        this.kdtEntries.getCell(rowIndex, CHANGEQTY).setValue((Object)BIGZERO);
        this.kdtEntries.getCell(rowIndex, REALCHANGEQTY).setValue((Object)BIGZERO);
        this.kdtEntries.getCell(rowIndex, CHANGEBASEQTY).setValue((Object)BIGZERO);
        this.kdtEntries.getCell(rowIndex, REALCHANGEBASEQTY).setValue((Object)BIGZERO);
        this.setDefaultPrecision(rowIndex);
    }

    private void setEntriesTableStrLength() {
        String[] str255 = new String[]{REMARK};
        SCMClientUtils.setEntriesTableStrLength((KDTable)this.getDetailTable(), (String[])str255, (int)255);
    }

    protected IMetaDataPK getTDQueryPK() {
        return new MetaDataPK("com.kingdee.eas.scm.sm.pur.PurOrderChangePrintQuery");
    }

    protected String getTDFileName() {
        return "/SCM/SM/PurOrderChange";
    }

    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrint_actionPerformed(e);
        this.invokePrintFunction(true);
    }

    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrintPreview_actionPerformed(e);
        this.invokePrintFunction(false);
    }

    private void initDiscardStatus() {
        int baseStatus = this.editData.getBaseStatus().getValue();
        if (0 == baseStatus) {
            this.btnMyCancel.setVisible(true);
            this.btnMyCancel.setEnabled(false);
        } else if (1 == baseStatus) {
            this.btnMyCancel.setVisible(true);
            this.btnMyCancel.setEnabled(true);
        } else if (2 == baseStatus) {
            this.btnMyCancel.setVisible(true);
            this.btnMyCancel.setEnabled(true);
        } else if (4 == baseStatus) {
            this.btnMyCancel.setVisible(true);
            this.btnMyCancel.setEnabled(false);
            this.btnUnAudit.setEnabled(false);
        }
    }

    @Override
    public void actionMyCancel_actionPerformed(ActionEvent e) throws Exception {
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnMyCancel.setIcon(EASResource.getIcon((String)"imgTbtn_blankout"));
    }

    protected void setTableToSumField() {
        String[] sumField = new String[]{APPROVALQTY, CHANGEQTY, REALCHANGEQTY, BASEQTY, CHANGEBASEQTY, REALCHANGEBASEQTY};
        this.setTableToSumField(this.kdtEntries, sumField);
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
        this.isCopy = false;
    }

    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        super.actionCopy_actionPerformed(e);
        this.currentCopydate = SCMClientUtils.getServerDate();
        this.pkBizDate.setValue((Object)this.currentCopydate);
        this.pkAuditTime.setValue(null);
        this.prmtAuditor.setValue(null);
        this.pkLastUpdateTime.setValue(null);
        this.prmtLastUpdateUser.setValue(null);
        this.kDSourceBillType.setValue(null);
        UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
        this.prmtCreator.setValue((Object)userInfo);
        this.pkCreateTime.setValue((Object)this.currentCopydate);
        this.setDataForCarry();
    }

    private void setDataForCarry() throws BOSException, EASBizException {
        IRow row = null;
        int len = this.kdtEntries.getRowCount();
        for (int rowIndex = 0; rowIndex < len; ++rowIndex) {
            row = this.kdtEntries.getRow(rowIndex);
            PurOrderEntryInfo info = (PurOrderEntryInfo)row.getCell(PURORDERNUMBER).getValue();
            row.getCell(APPROVALQTY).setValue((Object)info.getQty());
            row.getCell(BASEQTY).setValue((Object)this.getCommomBaseQty(rowIndex, APPROVALQTY, info));
            row.getCell(CHANGEQTY).setValue((Object)BIGZERO);
            row.getCell(CHANGEBASEQTY).setValue(null);
            row.getCell(REALCHANGEQTY).setValue(null);
            row.getCell(REALCHANGEBASEQTY).setValue(null);
            row.getCell(REASON).setValue(null);
            row.getCell(AFTERCHANGEQTY).setValue(null);
            row.getCell(AFTERCHANGEBASEQTY).setValue(null);
            row.getCell(ORIGINDELIVER).setValue((Object)info.getDeliveryDate());
            row.getCell(CHANGEDELIVERTIME).setValue((Object)info.getDeliveryDate());
            row.getCell(CHANGEDAYS).setValue(null);
            row.getCell(REALCHANGEDAYS).setValue(null);
        }
    }

    protected HashMap getQueryCondition() throws Exception {
        HashMap<String, Boolean> hm = new HashMap<String, Boolean>();
        boolean isTableFocus = SCMClientUtils.isTableFocus((KDTable)this.getDetailTable());
        hm.put("TABLEHASFOCUS", isTableFocus);
        KDTSelectBlock selectBlock = this.getDetailTable().getSelectManager().get();
        if (selectBlock != null) {
            int rowIndex = selectBlock.getTop();
            IRow row = this.getDetailTable().getRow(rowIndex);
            if (row == null) {
                return hm;
            }
            ICell cell = row.getCell(MATERIALNUMBER);
            MaterialInfo material = (MaterialInfo)cell.getValue();
            if (material == null) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.scm.sm.pur.PurUIResource", (String)"NoMaterialSelected"));
                SysUtil.abort();
            }
            hm.put("MATERIAL", (Boolean)material);
        }
        return hm;
    }

    public void TpurreQuo_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData.getBaseStatus().equals((Object)BillBaseStatusEnum.AUDITED)) {
            HashSet<BOSUuid> idSet = new HashSet<BOSUuid>();
            String purchaseOrgUnitId = null;
            if (this.prmtPurchaseOrgUnit != null) {
                PurchaseOrgUnitInfo sInfo = (PurchaseOrgUnitInfo)this.prmtPurchaseOrgUnit.getValue();
                purchaseOrgUnitId = sInfo.getId().toString();
            }
            Uuid uuid = Uuid.create();
            MutexParameter param = this.getMutexParameter(uuid, "SM_QUOTA", "QUOTA", MutexLockType.EXCLUSIVE_LOCK, BOSUuid.read((String)purchaseOrgUnitId));
            boolean result = MutexServiceControlFactory.getRemoteInstance().requestMutex(param);
            if (result) {
                idSet.add(this.editData.getId());
                UIContext uiContext = new UIContext((Object)this);
                uiContext.put((Object)"mutexKey", (Object)uuid);
                uiContext.put((Object)"mainOrgId", (Object)((OrgUnitInfo)this.getUIContext().get(this.getMainBizOrgType())));
                uiContext.put((Object)"idSet", idSet);
                uiContext.put((Object)"isEditUI", (Object)true);
                uiContext.put((Object)"purorgpk", (Object)new ObjectStringPK(purchaseOrgUnitId));
                if (this.isSubContractBill()) {
                    uiContext.put((Object)"isSubContract", (Object)true);
                }
                IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory");
                IUIWindow window = uiFactory.create("com.kingdee.eas.scm.sm.pur.client.QuotaAllocationForRequestUI", (Map)uiContext, null);
                window.show();
            } else {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.scm.sm.pur.PurUIResource", (String)"QUOTA_FININIT"));
            }
        } else {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.scm.sm.pur.PurUIResource", (String)"BILLNOTAUDIT"));
        }
    }

    private MutexParameter getMutexParameter(Uuid uuid, String mutextName, String actionName, MutexLockType lockType, BOSUuid companyID) {
        SysContext ctx = SysContext.getSysContext();
        MutexParameter param = new MutexParameter();
        param.setRequestId(uuid);
        param.setMutexName(mutextName + companyID.toString());
        param.setActionName(actionName);
        param.setUserID(ctx.getCurrentUserInfo().getId());
        param.setOrgUnitID(companyID);
        param.setMutexLockType(lockType);
        param.setDcName(ctx.getDcName());
        param.setSessionID(ctx.getSessionID());
        return param;
    }

    private void setMaterialF7() {
        KDBizPromptBox materialNumber = new KDBizPromptBox();
        ObjectValueRender avrNum = new ObjectValueRender();
        avrNum.setFormat((IDataFormat)new BizDataFormat("$number$"));
        materialNumber.setEditFormat("$number$");
        materialNumber.setDisplayFormat("$number$");
        materialNumber.setCommitFormat("$number$");
        materialNumber.setQueryInfo("com.kingdee.eas.basedata.master.material.app.F7MaterialInventoryNoGroupQuery");
        materialNumber.setEnabledMultiSelection(true);
        KDTDefaultCellEditor materialNumberEditor = new KDTDefaultCellEditor((IKDEditor)materialNumber);
        this.kdtEntries.getColumn(MATERIALNUMBER).setEditor((ICellEditor)materialNumberEditor);
        this.kdtEntries.getColumn(MATERIALNUMBER).setRenderer((IBasicRender)avrNum);
    }

    @Override
    public void actionUnionOrder_actionPerformed(ActionEvent e) throws Exception {
        ArrayList<String> retList;
        ArrayList<String> idList = new ArrayList<String>();
        idList.add(this.getCurrentBillID());
        String[] entryIds = null;
        entryIds = SCMClientUtils.getSelectRowFieldValue((KDTable)this.kdtEntries, (String)PURORDERNUMBER);
        String[] purOrderID = KDTableUtil.getSelectRowFieldValue((KDTable)this.kdtEntries, (String)PURORDERID);
        String[] purOrderentryID = KDTableUtil.getSelectRowFieldValue((KDTable)this.kdtEntries, (String)PURORDERENTRYID);
        StringBuffer idBuffer = new StringBuffer();
        StringBuffer entryId = new StringBuffer();
        if (entryIds == null) {
            retList = new ArrayList<String>();
            PurOrderEntryInfo value = null;
            for (int i = 0; i < this.kdtEntries.getRowCount(); ++i) {
                IRow row = this.kdtEntries.getRow(i);
                value = (PurOrderEntryInfo)row.getCell(PURORDERNUMBER).getValue();
                if (value == null || value.toString().trim().length() == 0) continue;
                String retStr = value.getParent().getId().toString() + "," + value.getId().toString();
                retList.add(retStr);
                idBuffer.append(value.getParent().getId().toString());
                entryId.append(value.getId().toString());
                if (i == this.kdtEntries.getRowCount() - 1) continue;
                idBuffer.append(",");
                entryId.append(",");
            }
            retList.trimToSize();
            if (retList.size() == 0) {
                return;
            }
            entryIds = new String[retList.size()];
            entryIds = retList.toArray(entryIds);
        } else {
            retList = new ArrayList();
            for (int i = 0; i < entryIds.length; ++i) {
                String retStr = purOrderID[i].toString() + "," + purOrderentryID[i].toString();
                retList.add(retStr);
                idBuffer.append(purOrderID[i].toString());
                entryId.append(purOrderentryID[i].toString());
                if (i == entryIds.length - 1) continue;
                idBuffer.append(",");
                entryId.append(",");
            }
            retList.trimToSize();
            if (retList.size() == 0) {
                return;
            }
            entryIds = new String[retList.size()];
            entryIds = retList.toArray(entryIds);
        }
        FilterItemInfo idFilter = new FilterItemInfo("id", (Object)idBuffer.toString(), CompareType.INCLUDE);
        FilterItemInfo entryIdFilter = new FilterItemInfo("entries.id", (Object)entryId.toString(), CompareType.INCLUDE);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(idFilter);
        filter.getFilterItems().add(entryIdFilter);
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filter);
        HashMap<String, Integer> uiContext = new HashMap<String, Integer>();
        uiContext.put("BOTPViewStatus", 1);
        uiContext.put("BOTPFilter", (Integer)viewInfo);
        IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory");
        IUIWindow window = uiFactory.create("com.kingdee.eas.scm.sm.pur.client.PurOrderListUI", uiContext, null);
        window.show();
    }

    public ArrayList convertStringToArrayList(String[] pkStrs) {
        if (pkStrs == null || pkStrs.length == 0) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        int num = pkStrs.length;
        for (int i = 0; i < num; ++i) {
            list.add(pkStrs[i]);
        }
        return list;
    }
}

