/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.pur.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.KDTableHelper;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.PreChangeEvent;
import com.kingdee.bos.ctrl.swing.event.PreChangeListener;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.ConvertModeEnum;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.AsstAttrValueInfo;
import com.kingdee.eas.basedata.master.material.IMultiMeasureUnit;
import com.kingdee.eas.basedata.master.material.MaterialGroupInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.common.DestinationTypeEnum;
import com.kingdee.eas.basedata.scm.common.IRowType;
import com.kingdee.eas.basedata.scm.common.RequestOrgTypeEnum;
import com.kingdee.eas.basedata.scm.common.RowTypeFactory;
import com.kingdee.eas.basedata.scm.common.RowTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.batchaction.ActionLevelEnum;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchSelectionEntries;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.action.ActionProxy;
import com.kingdee.eas.scm.common.action.ActionProxyFactory;
import com.kingdee.eas.scm.common.action.ISupportBatchAction;
import com.kingdee.eas.scm.common.client.SCMBillEditUI;
import com.kingdee.eas.scm.common.client.SCMClientHelper;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.client.SCMGroupClientUtils;
import com.kingdee.eas.scm.sm.pur.PurOrderException;
import com.kingdee.eas.scm.sm.pur.PurPlanEntryAgent;
import com.kingdee.eas.scm.sm.pur.PurPlanEntryFactory;
import com.kingdee.eas.scm.sm.pur.PurPlanEntryInfo;
import com.kingdee.eas.scm.sm.pur.PurPlanException;
import com.kingdee.eas.scm.sm.pur.PurPlanFacadeFactory;
import com.kingdee.eas.scm.sm.pur.PurPlanFactory;
import com.kingdee.eas.scm.sm.pur.PurPlanInfo;
import com.kingdee.eas.scm.sm.pur.PurRequestEntryCollection;
import com.kingdee.eas.scm.sm.pur.PurRequestEntryFactory;
import com.kingdee.eas.scm.sm.pur.PurRequestEntryInfo;
import com.kingdee.eas.scm.sm.pur.client.AbstractPurPlanEditUI;
import com.kingdee.eas.scm.sm.pur.util.PurUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class PurPlanEditUI
extends AbstractPurPlanEditUI {
    private static final Logger logger = CoreUIObject.getLogger(PurPlanEditUI.class);
    private static final String TB_ID = "id";
    public static final String TB_MATERIAL_NUMBER = "materialNum";
    public static final String TB_MATERIAL_NAME = "materialName";
    public static final String TB_MATERIAL_MODEL = "model";
    public static final String TB_MATERIAL_GROUP = "materialGroup";
    public static final String TB_MATERIAL_CLASS = "materialBaseClass";
    public static final String TB_MATERIAL_UNIT = "unit";
    public static final String TB_MATERIAL_QUANTITY = "qty";
    public static final String TB_MATERIAL_ASSISTANTUNIT = "assistUnit";
    public static final String TB_MATERIAL_ASSISTQUANTIRTY = "assistQty";
    public static final String TB_BASEUNIT = "baseUnit";
    public static final String TB_BASEQTY = "baseQty";
    public static final String TB_MATERIAL_CURRENCY = "currency";
    public static final String TB_MATERIAL_EXCHRATE = "exchangeRate";
    public static final String TB_MATERIAL_PRICE = "price";
    public static final String TB_MATERIAL_AMOUNT = "amount";
    public static final String TB_MATERIAL_LOCALAMOUNT = "localAmount";
    public static final String TB_MATERIAL_REQDATE = "requirementDate";
    public static final String TB_MATERIAL_STOREORG = "storageOrgUnit";
    public static final String TB_MATERIAL_ADMINORGUNIT = "adminOrgUnit";
    public static final String TB_MATERIAL_RECEIVEDORGUNIT = "receivedOrgUnit";
    public static final String TB_USEDADMINORGUNIT = "useAdminOrgUnit";
    public static final String TB_COMPANYORGUNIT = "companyOrgUnit";
    public static final String TB_MATERIAL_PROPOSEDELIVERYDATE = "proposeDeliveryDate";
    public static final String TB_MATERIAL_PROPOSEPURCHASEDATE = "proposePurchaseDate";
    public static final String TB_MATERIAL_ASSISTPROPERTY = "asistProperty";
    public static final String TB_MATERIAL_SUPPLIER = "supplier";
    public static final String TB_MATERIAL_SUPPLIER_NAME = "supplierName";
    private static final String TB_DELIVERYADDRESS = "deliveryAddress";
    private static final String TB_BASESTATUS = "baseStatus";
    public static final String TB_ENTRY_ID = "id";
    public static final String TB_ENTRY_REASONCODE = "reason";
    public static final String TB_ROWTYPE = "rowType";
    public static final String TB_DESTINATIONTYPE = "destinationType";
    public static final String TB_WAREHOUSE = "warehosue";
    public static final String TB_PURCHASEPERSON = "purchasePerson";
    private static final String TB_SALEORDERNUMBER = "saleOrderNumber";
    private static final String TB_ISQUANTITYUNCTRL = "isQuantityUnCtrl";
    private static final String TB_QUOTATIONCOUNT = "quotationCount";
    private static final String TB_ISURGENT = "isUrgent";
    private static final String TB_REMARK = "remark";
    private static final String TB_MATERIAL_TOTALORDERQTY = "totalOrderQty";
    private static final String TB_MATERIAL_TOTALORDERBASEQTY = "totalOrderBaseQty";
    private CompanyOrgUnitInfo ficompanyOrgInfo = null;
    private CurrencyInfo baseCurrInfo = null;
    private MaterialInfo oldMaterialInfo = null;
    public static final int DEFAULTPRECISION0 = 0;
    public static final int DEFAULTPRECISION = 2;
    public static final int DEFAULTPRECISION4 = 4;
    public static final int MAXPRECISION = 10;
    public static final BigDecimal ZERO = new BigDecimal("0.00");
    public static final BigDecimal ONE = new BigDecimal("1.00");
    public static final BigDecimal HUNDRED = new BigDecimal("100.00");
    private static final String[] TB_QTY_TABS = new String[]{"qty"};
    private static final String[] TB_BASEQTY_TABS = new String[]{"baseQty"};
    private static final String[] TB_ASSISTQTY_TABS = new String[]{"assistQty"};
    private static final String[] TB_PRICE_TABS = new String[]{"price"};
    private static final String[] TB_AMOUNT_TABS = new String[]{"amount"};
    private static final String[] TB_LOCALAMOUNT_TABS = new String[]{"localAmount"};
    protected HashMap hmDataChangeListeners = new HashMap();
    protected HashMap hmPreChangeListeners = new HashMap();
    protected HashMap hmItemListeners = new HashMap();
    protected DataChangeListener dataChangeListener = null;
    protected PreChangeListener preChangeListener = null;
    protected ItemListener itemListener = null;
    protected KDTSelectListener tableSelectListener = null;
    protected KDTEditListener tableEditListener = null;
    protected KDTSelectListener table2SelectListener = null;
    protected KDTMouseListener table2MouseListener = null;
    protected KDTEditListener table2EditListener = null;
    KDCheckBox cbkSelect = new KDCheckBox();
    protected boolean isListenerEnable = true;
    protected boolean isUIFirstOnLoad = true;
    private KDBizPromptBox bizStorageOrgUnitBox = null;
    private KDBizPromptBox bizRecStorageOrgUnitBox = null;
    private KDBizPromptBox bizAdminOrgUnitBox = null;
    private KDBizPromptBox bizCompanyOrgUnitBox = null;
    private KDBizPromptBox bizMaterialBox = null;
    private KDBizPromptBox bizSupplierBox = null;
    private Map multiUnitQtyPrecisionMap;

    public PurPlanEditUI() throws Exception {
        this.setUITitle(EASResource.getString((String)"com.kingdee.eas.scm.sm.pur.PURAutoGenerateResource", (String)"4_PurPlanEditUI"));
        this.setCacheParameters(new String[]{"PURSUP004", "PURSUP005", "PURORDER001", "PURSUP001", "PURORDER002", "PURORDER003", "PURSUP003", "PURORDER004", "PURSUP002", "PURORDER005", "PURORDERALTER3", "PURORDER006", "PURORDER007", "PURORDER100", "PURORDERALTER4", "PURSUP007"});
        HashMap<Object, Object> orgMap = new HashMap<Object, Object>();
        orgMap.put(this.prmtPurchaseOrgUnit, OrgType.Purchase);
        orgMap.put(TB_MATERIAL_STOREORG, new OrgType[]{OrgType.Company, OrgType.Storage});
        orgMap.put(TB_MATERIAL_ADMINORGUNIT, OrgType.Admin);
        orgMap.put(TB_USEDADMINORGUNIT, OrgType.Admin);
        orgMap.put(TB_COMPANYORGUNIT, OrgType.Company);
        this.setDefaultOrgMap(orgMap);
    }

    public void onLoad() throws Exception {
        if (this.isUIFirstOnLoad) {
            this.initUIComonents();
            this.initListeners();
        }
        super.onLoad();
        this.initUIComonentsControl();
        if (this.isUIFirstOnLoad) {
            KDTable table = this.getDetailTable();
            this.f7Manager.registerAssistPropertyF7(table, TB_MATERIAL_NUMBER, TB_MATERIAL_ASSISTPROPERTY, (SCMBillEditUI)this);
            this.f7Manager.registerMeasureUnitF7(table, TB_MATERIAL_NUMBER, TB_MATERIAL_UNIT);
            this.f7Manager.registerWarehouseF7(table, TB_MATERIAL_RECEIVEDORGUNIT, TB_WAREHOUSE);
        }
        this.isUIFirstOnLoad = false;
        this.initPrecisions();
    }

    protected KDBizPromptBox getHeadBizTypeF7() {
        return this.prmtBizType;
    }

    protected void initUIComonents() {
        this.getDetailTable().checkParsed();
        this.enableExportExcel(this.getDetailTable());
        KDTableHelper.setEnterKeyJumpOrientation((KDTable)this.getDetailTable(), (int)0);
        this.initTableKeyStrokeUdf(this.getDetailTable(), true);
        this.initBtnIcon();
        this.getNumTextField().setRequired(true);
        this.comboPurchaseType.setEditable(false);
        this.comboPurchaseType.setEnabled(false);
        this.comboPurchaseTypeFilter.setEditable(false);
        this.comboPurchaseTypeFilter.setEnabled(false);
        this.prmtBizType.setEditable(false);
        this.prmtBizType.setEnabled(false);
        if (!this.getOprtState().equals("ADDNEW")) {
            this.prmtPurchaseOrgUnit.setEditable(false);
            this.prmtPurchaseOrgUnit.setEnabled(false);
            this.prmtPurchaseOrgUnitFilter.setEditable(false);
            this.prmtPurchaseOrgUnitFilter.setEnabled(false);
        }
        this.confirmChangeBizOrgUnit(this.prmtPurchaseOrgUnit, TB_MATERIAL_NUMBER);
        this.getDetailTable().getActionMap().remove("Paste");
        this.initEntries();
    }

    protected void confirmChangeBizOrgUnit(KDBizPromptBox prmtBizOrg, String materialFieldName) {
        final String fieldName = materialFieldName;
        PreChangeListener prmtBizOrgPreChangeListener = new PreChangeListener(){

            public void preChange(PreChangeEvent arg0) {
                if (PurPlanEditUI.this.skipCheckBizorgUnitChange(arg0)) {
                    return;
                }
                if (arg0.getData() != null && arg0.getData().equals(arg0.getOldData())) {
                    return;
                }
                String strTemp = null;
                if (!PurPlanEditUI.this.checkCanChangeBizOrg()) {
                    arg0.setResult(0);
                    return;
                }
                if (!PurPlanEditUI.this.isBotpBill()) {
                    if (!SCMClientUtils.checkEntryIsBlank((KDTable)PurPlanEditUI.this.getDetailTable(), (String)fieldName) && arg0.getOldData() != null) {
                        strTemp = SCMClientUtils.getResource((String)"CLEARENTRYAFTERORGCHANGED");
                        int ret = MsgBox.showConfirm2((String)strTemp);
                        if (ret == 2) {
                            arg0.setResult(0);
                            return;
                        }
                        if (!PurPlanEditUI.this.isBotpBill()) {
                            PurPlanEditUI.this.cleanEntry();
                        }
                    }
                } else {
                    PurPlanEditUI.this.checkPurOrgUnitForStorageOrgUnit();
                }
                PurPlanEditUI.this.afterConfirmChangeBizOrgUnit();
            }
        };
        prmtBizOrg.addPreChangeListener(prmtBizOrgPreChangeListener);
    }

    protected void initListeners() {
        int i;
        this.dataChangeListener = new PurPlanDataChangeListener();
        this.hmDataChangeListeners.put(this.prmtPurchaseOrgUnit, this.dataChangeListener);
        this.hmDataChangeListeners.put(this.prmtPurchaseOrgUnitFilter, this.dataChangeListener);
        this.hmDataChangeListeners.put(this.pkRequestDateFilter, this.dataChangeListener);
        this.hmDataChangeListeners.put(this.pkRequestDateToFilter, this.dataChangeListener);
        this.itemListener = new PurPlanItemListener();
        this.hmItemListeners.put(this.kDChkAllSelect, this.itemListener);
        this.hmItemListeners.put(this.kDChkDisplay, this.itemListener);
        this.hmItemListeners.put(this.kDCheckInv, this.itemListener);
        this.hmItemListeners.put(this.kDCheckWareHs, this.itemListener);
        this.hmItemListeners.put(this.comboPurchaseTypeFilter, this.itemListener);
        this.hmItemListeners.put(this.cbkSelect, this.itemListener);
        this.getDetailTable2().checkParsed();
        this.getDetailTable2().getColumn("select").setEditor((ICellEditor)new KDTDefaultCellEditor((JCheckBox)this.cbkSelect));
        KDTSelectListener[] listenerList = (KDTSelectListener[])this.getDetailTable().getListenerList().getListeners(KDTSelectListener.class);
        int n = listenerList.length;
        for (i = 0; i < n; ++i) {
            this.getDetailTable().removeKDTSelectListener(listenerList[i]);
        }
        this.tableSelectListener = new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                int rowIndex = e.getSelectBlock().getBeginRow();
                PurPlanEditUI.this.kdtEntriesSelected(rowIndex);
            }
        };
        this.getDetailTable().addKDTSelectListener(this.tableSelectListener);
        n = listenerList.length;
        for (i = 0; i < n; ++i) {
            this.getDetailTable().addKDTSelectListener(listenerList[i]);
        }
        this.tableEditListener = new PurPlanKdtEditlistener();
        this.getDetailTable().addKDTEditListener(this.tableEditListener);
        this.kDTabbedPaneEntry.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                try {
                    PurPlanEditUI.this.tabbedPaneEntryChanged(PurPlanEditUI.this.kDTabbedPaneEntry.getSelectedIndex());
                }
                catch (Exception exc) {
                    PurPlanEditUI.this.handUIException(exc);
                }
            }
        });
    }

    protected void kdtEntriesRequest_tableClicked(KDTMouseEvent e) throws Exception {
        KDTable table = this.getDetailTable2();
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        IRow row = table.getRow(rowIndex);
        if (e.getColIndex() == table.getColumnIndex("select")) {
            Boolean isSelect = (Boolean)table.getCell(rowIndex, colIndex).getValue();
            if (isSelect.booleanValue()) {
                table.getCell(rowIndex, "select").setValue((Object)Boolean.FALSE);
                this.deleteRowFromPurPlanEntriesTable(table.getCell(rowIndex, "entryid").getValue().toString());
            } else {
                try {
                    table.getCell(rowIndex, "select").setValue((Object)Boolean.TRUE);
                    this.fillPurPlanEntriesTable(row);
                }
                catch (EASBizException e1) {
                    this.handleException((Exception)((Object)e1));
                }
                catch (BOSException e1) {
                    this.handleException((Exception)((Object)e1));
                }
            }
        }
    }

    protected void tabbedPaneEntryChanged(int componentIndex) {
        if (componentIndex == 1) {
            try {
                this.calculateTotal();
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
    }

    private void kdtEntriesSelected(int rowIndex) {
        if (rowIndex < 0) {
            return;
        }
    }

    private void calculateTotal() throws Exception {
        HashMap<String, PurRequestEntryInfo> map = new HashMap<String, PurRequestEntryInfo>();
        LinkedList<String> keyList = new LinkedList<String>();
        StringBuffer bf = new StringBuffer();
        BigDecimal ZERO = new BigDecimal(0);
        int count = this.kdtEntries.getRowCount();
        for (int i = 0; i < count; ++i) {
            RowTypeInfo rowType = (RowTypeInfo)this.kdtEntries.getRow(i).getCell(TB_ROWTYPE).getValue();
            MaterialInfo material = (MaterialInfo)this.kdtEntries.getCell(i, TB_MATERIAL_NUMBER).getValue();
            AsstAttrValueInfo asstAttr = (AsstAttrValueInfo)this.kdtEntries.getCell(i, TB_MATERIAL_ASSISTPROPERTY).getValue();
            MeasureUnitInfo unit = (MeasureUnitInfo)this.kdtEntries.getCell(i, TB_MATERIAL_UNIT).getValue();
            BigDecimal qty = (BigDecimal)this.kdtEntries.getCell(i, TB_MATERIAL_QUANTITY).getValue();
            BigDecimal assistQty = (BigDecimal)this.kdtEntries.getCell(i, TB_MATERIAL_ASSISTQUANTIRTY).getValue();
            MaterialGroupInfo materialGroup = (MaterialGroupInfo)this.kdtEntries.getRow(i).getCell(TB_MATERIAL_GROUP).getValue();
            MeasureUnitInfo assistUnit = (MeasureUnitInfo)this.kdtEntries.getRow(i).getCell(TB_MATERIAL_ASSISTANTUNIT).getValue();
            String materialName = null;
            String model = null;
            if (material == null) {
                materialName = (String)this.kdtEntries.getCell(i, TB_MATERIAL_NAME).getValue();
                model = (String)this.kdtEntries.getCell(i, TB_MATERIAL_MODEL).getValue();
            }
            if (null == unit || ZERO.compareTo(qty) == 0) continue;
            if (null == qty) {
                qty = ZERO;
            }
            if (null == assistQty || assistQty.toString().endsWith("0E-8")) {
                assistQty = ZERO;
            }
            String key = null;
            bf.setLength(0);
            bf = null != rowType ? bf.append(rowType.getId().toString()) : bf.append("");
            StringBuffer stringBuffer = bf = null != materialGroup ? bf.append(materialGroup.getId().toString()) : bf.append("");
            bf = null != material && null != material.getNumber() ? bf.append(null != material.getNumber()) : bf.append("");
            bf = null != material && null != material.getName() ? bf.append(material.getName()) : bf.append("");
            bf = null != asstAttr ? bf.append(asstAttr.getId().toString()) : bf.append("");
            bf = bf.append(unit.getId().toString());
            key = bf.toString();
            PurRequestEntryInfo entry = null;
            if (keyList.contains(key)) {
                entry = (PurRequestEntryInfo)map.get(key);
                entry.setQty(entry.getQty().add(qty));
                entry.setAssistQty(entry.getAssistQty().add(assistQty));
                continue;
            }
            entry = new PurRequestEntryInfo();
            entry.setRowType(rowType);
            entry.setMaterial(material);
            entry.setAssistProperty(asstAttr);
            entry.setUnit(unit);
            entry.setQty(qty);
            entry.setAssistUnit(assistUnit);
            entry.setAssistQty(assistQty);
            entry.setMaterialName(materialName);
            entry.setString(TB_MATERIAL_MODEL, model);
            map.put(key, entry);
            keyList.add(key);
        }
        this.kdtEntriesSum.removeRows();
        Iterator keyIter = keyList.iterator();
        while (keyIter.hasNext()) {
            IRow row = this.kdtEntriesSum.addRow();
            PurRequestEntryInfo entry = (PurRequestEntryInfo)map.get(keyIter.next());
            row.getCell(TB_ROWTYPE).setValue(entry.getRowType() != null ? entry.getRowType().getName() : null);
            row.getCell(TB_MATERIAL_NUMBER).setValue(entry.getMaterial() != null ? entry.getMaterial().getNumber() : null);
            row.getCell(TB_MATERIAL_NAME).setValue((Object)(entry.getMaterial() != null ? entry.getMaterial().getName() : entry.getMaterialName()));
            row.getCell(TB_MATERIAL_MODEL).setValue(entry.getMaterial() != null ? entry.getMaterial().getModel() : entry.get(TB_MATERIAL_MODEL));
            row.getCell(TB_MATERIAL_ASSISTPROPERTY).setValue(entry.getAssistProperty() != null ? entry.getAssistProperty().getName() : null);
            row.getCell(TB_MATERIAL_UNIT).setValue((Object)entry.getUnit().getName());
            row.getCell(TB_MATERIAL_ASSISTANTUNIT).setValue(entry.getAssistUnit() != null ? entry.getAssistUnit().getName() : null);
            int qtyPrecision = 4;
            int assisttQtyPrecision = 4;
            int baseQtyPrecision = 4;
            if (entry.getMaterial() != null && entry.getUnit() != null) {
                qtyPrecision = this.getQtyPrecisionFromMap(entry.getMaterial().getId().toString(), entry.getUnit().getId().toString());
            }
            if (entry.getMaterial() != null && entry.getAssistUnit() != null) {
                assisttQtyPrecision = this.getQtyPrecisionFromMap(entry.getMaterial().getId().toString(), entry.getAssistUnit().getId().toString());
            }
            if (entry.getMaterial() != null && entry.getBaseUnit() != null) {
                baseQtyPrecision = this.getQtyPrecisionFromMap(entry.getMaterial().getId().toString(), entry.getBaseUnit().getId().toString());
            }
            SCMClientUtils.changeTableColPrecision((int)qtyPrecision, (KDTable)this.kdtEntriesSum, (String[])TB_QTY_TABS, (int)row.getRowIndex());
            SCMClientUtils.changeTableColPrecision((int)baseQtyPrecision, (KDTable)this.kdtEntriesSum, (String[])TB_BASEQTY_TABS, (int)row.getRowIndex());
            SCMClientUtils.changeTableColPrecision((int)assisttQtyPrecision, (KDTable)this.kdtEntriesSum, (String[])TB_ASSISTQTY_TABS, (int)row.getRowIndex());
            row.getCell(TB_MATERIAL_QUANTITY).setValue((Object)entry.getQty());
            row.getCell(TB_MATERIAL_ASSISTQUANTIRTY).setValue((Object)entry.getAssistQty());
        }
    }

    public int getQtyPrecisionFromMap(String materialId, String unitId) throws Exception {
        if (this.multiUnitQtyPrecisionMap == null) {
            this.multiUnitQtyPrecisionMap = new HashMap();
        }
        int qtyPrecision = 4;
        StringBuffer preKey = new StringBuffer(materialId).append(unitId);
        if (this.multiUnitQtyPrecisionMap.get(preKey.toString()) != null) {
            qtyPrecision = Integer.parseInt(this.multiUnitQtyPrecisionMap.get(preKey.toString()).toString());
        } else {
            IMultiMeasureUnit imultiUnit = MultiMeasureUnitFactory.getRemoteInstance();
            MultiMeasureUnitInfo multiUnitInfo = imultiUnit.getMultiUnit(materialId, unitId);
            qtyPrecision = multiUnitInfo != null ? multiUnitInfo.getQtyPrecision() : 4;
            this.multiUnitQtyPrecisionMap.put(preKey.toString(), new Integer(qtyPrecision));
        }
        return qtyPrecision;
    }

    protected void initEntries() {
        KDTable table = this.getDetailTable();
        SCMClientHelper scmClientHelper = new SCMClientHelper((SCMBillEditUI)this);
        ObjectValueRender numberRender = new ObjectValueRender();
        numberRender.setFormat((IDataFormat)new BizDataFormat("$number$"));
        ObjectValueRender nameRender = new ObjectValueRender();
        nameRender.setFormat((IDataFormat)new BizDataFormat("$name$"));
        table.getColumn(TB_MATERIAL_NUMBER).setRenderer((IBasicRender)numberRender);
        table.getColumn(TB_MATERIAL_ASSISTPROPERTY).setRenderer((IBasicRender)nameRender);
        table.getColumn(TB_MATERIAL_UNIT).setRenderer((IBasicRender)nameRender);
        table.getColumn(TB_BASEUNIT).setRenderer((IBasicRender)nameRender);
        table.getColumn(TB_MATERIAL_ASSISTANTUNIT).setRenderer((IBasicRender)nameRender);
        table.getColumn(TB_MATERIAL_STOREORG).setRenderer((IBasicRender)nameRender);
        table.getColumn(TB_MATERIAL_ADMINORGUNIT).setRenderer((IBasicRender)nameRender);
        table.getColumn(TB_MATERIAL_RECEIVEDORGUNIT).setRenderer((IBasicRender)nameRender);
        table.getColumn(TB_USEDADMINORGUNIT).setRenderer((IBasicRender)nameRender);
        table.getColumn(TB_COMPANYORGUNIT).setRenderer((IBasicRender)nameRender);
        KDComboBox comboDestinationType = new KDComboBox();
        comboDestinationType.addItems(DestinationTypeEnum.getEnumList().toArray());
        table.getColumn(TB_DESTINATIONTYPE).setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)comboDestinationType));
        KDBizPromptBox bizBoxWareHouse = new KDBizPromptBox();
        bizBoxWareHouse.setQueryInfo("com.kingdee.eas.basedata.scm.im.inv.app.F7WarehouseQuery");
        bizBoxWareHouse.setEditFormat("$number$");
        bizBoxWareHouse.setCommitFormat("$number$");
        bizBoxWareHouse.setDisplayFormat("$number$");
        table.getColumn(TB_WAREHOUSE).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)bizBoxWareHouse));
        KDBizPromptBox purperson = new KDBizPromptBox();
        purperson.setEditFormat("$number$");
        purperson.setDisplayFormat("$name$");
        purperson.setCommitFormat("$person.number$;$person.idNum$");
        purperson.setQueryInfo("com.kingdee.eas.basedata.scm.sm.pur.app.F7PurPersonQuery");
        KDTDefaultCellEditor bizboxEditor = new KDTDefaultCellEditor((IKDEditor)purperson);
        table.getColumn(TB_PURCHASEPERSON).setEditor((ICellEditor)bizboxEditor);
        scmClientHelper.initPurPersonDisplay(purperson);
        scmClientHelper.setPurPersonDisplay(purperson);
        KDBizPromptBox prmtCurrency = new KDBizPromptBox();
        prmtCurrency.setQueryInfo("com.kingdee.eas.basedata.assistant.app.F7CurrencyQuery");
        prmtCurrency.setEditable(false);
        prmtCurrency.setDisplayFormat("$name$");
        prmtCurrency.setEditFormat("$number$");
        bizboxEditor = new KDTDefaultCellEditor((IKDEditor)prmtCurrency);
        table.getColumn(TB_MATERIAL_CURRENCY).setEditor((ICellEditor)bizboxEditor);
        String format = CtrlFormatUtilities.getDateFormatString();
        KDDatePicker dpDeliveryDate = new KDDatePicker();
        table.getColumn(TB_MATERIAL_PROPOSEDELIVERYDATE).setEditor((ICellEditor)new KDTDefaultCellEditor(dpDeliveryDate));
        table.getColumn(TB_MATERIAL_PROPOSEDELIVERYDATE).getStyleAttributes().setNumberFormat(format);
        KDDatePicker dpPurchaseDate = new KDDatePicker();
        table.getColumn(TB_MATERIAL_PROPOSEPURCHASEDATE).setEditor((ICellEditor)new KDTDefaultCellEditor(dpPurchaseDate));
        table.getColumn(TB_MATERIAL_PROPOSEPURCHASEDATE).getStyleAttributes().setNumberFormat(format);
        KDBizPromptBox bizBoxDeliveryAddress = new KDBizPromptBox();
        bizBoxDeliveryAddress.setQueryInfo("com.kingdee.eas.basedata.assistant.app.F7AddressQuery");
        bizBoxDeliveryAddress.setEditFormat("$name$");
        bizBoxDeliveryAddress.setDisplayFormat("$name$");
        table.getColumn(TB_DELIVERYADDRESS).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)bizBoxDeliveryAddress));
        ObjectValueRender addressRender = new ObjectValueRender();
        addressRender.setFormat((IDataFormat)new BizDataFormat("$name$"));
        table.getColumn(TB_DELIVERYADDRESS).setRenderer((IBasicRender)addressRender);
        KDComboBox comboBaseStatus = new KDComboBox();
        comboBaseStatus.addItems(BillBaseStatusEnum.getEnumList().toArray());
        table.getColumn(TB_BASESTATUS).setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)comboBaseStatus));
        KDTextField txtRemark = new KDTextField();
        txtRemark.setMaxLength(255);
        table.getColumn(TB_REMARK).setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtRemark));
        KDTable table3 = this.getDetailTable3();
        table3.setEnabled(false);
        table3.setEditable(false);
        KDTable table4 = this.getDetailTable4();
        table4.setEnabled(false);
        table4.setEditable(false);
    }

    protected void initUIComonentsControl() {
        this.kDPanelDetail.putClientProperty((Object)"OriginalBounds", (Object)new Rectangle(0, 0, 680, 420));
        this.kDPanelSum.putClientProperty((Object)"OriginalBounds", (Object)new Rectangle(0, 0, 680, 420));
        KDTable table2 = this.getDetailTable2();
        if (table2.getColumn("select") != null) {
            table2.getColumn("select").getStyleAttributes().setLocked(false);
            table2.getColumn("number").getStyleAttributes().setLocked(true);
            table2.getColumn(TB_COMPANYORGUNIT).getStyleAttributes().setLocked(true);
            table2.getColumn("seq").getStyleAttributes().setLocked(true);
            table2.getColumn(TB_ROWTYPE).getStyleAttributes().setLocked(true);
            table2.getColumn(TB_MATERIAL_STOREORG).getStyleAttributes().setLocked(true);
            table2.getColumn("receviedOrgUnit").getStyleAttributes().setLocked(true);
            table2.getColumn("materialNumber").getStyleAttributes().setLocked(true);
            table2.getColumn(TB_MATERIAL_NAME).getStyleAttributes().setLocked(true);
            table2.getColumn("materialModel").getStyleAttributes().setLocked(true);
            table2.getColumn(TB_MATERIAL_UNIT).getStyleAttributes().setLocked(true);
            table2.getColumn(TB_MATERIAL_QUANTITY).getStyleAttributes().setLocked(true);
            table2.getColumn("requestDate").getStyleAttributes().setLocked(true);
            table2.getColumn("requestDate").getStyleAttributes().setLocked(true);
            table2.getColumn("proposeDevliveryDate").getStyleAttributes().setLocked(true);
            table2.getColumn("proposePurDate").getStyleAttributes().setLocked(true);
        }
    }

    private void initPrecisions() {
        KDTable table = this.getDetailTable();
        SCMClientUtils.changeTableColPrecisionByCol((int)10, (KDTable)table, (String[])TB_QTY_TABS);
        SCMClientUtils.changeTableColPrecisionByCol((int)10, (KDTable)table, (String[])TB_BASEQTY_TABS);
        SCMClientUtils.changeTableColPrecisionByCol((int)10, (KDTable)table, (String[])TB_ASSISTQTY_TABS);
        SCMClientUtils.changeTableColPrecisionByCol((int)10, (KDTable)table, (String[])TB_PRICE_TABS);
        this.kdtEntries.getColumn(TB_MATERIAL_QUANTITY).getStyleAttributes().setNumberFormat("%{0.##########}f");
        this.kdtEntries.getColumn(TB_MATERIAL_ASSISTQUANTIRTY).getStyleAttributes().setNumberFormat("%{0.##########}f");
        this.kdtEntries.getColumn(TB_BASEQTY).getStyleAttributes().setNumberFormat("%{0.##########}f");
        this.kdtEntries.getColumn(TB_MATERIAL_PRICE).getStyleAttributes().setNumberFormat("%{0.##########}f");
        SCMClientUtils.changeTableColPrecisionByCol((int)4, (KDTable)table, (String[])TB_AMOUNT_TABS);
        SCMClientUtils.changeTableColPrecisionByCol((int)4, (KDTable)table, (String[])TB_LOCALAMOUNT_TABS);
        KDTable table4 = this.getDetailTable4();
        SCMClientUtils.changeTableColPrecisionByCol((int)2, (KDTable)table4, (String[])TB_QTY_TABS);
        SCMClientUtils.changeTableColPrecisionByCol((int)2, (KDTable)table4, (String[])TB_BASEQTY_TABS);
        SCMClientUtils.changeTableColPrecisionByCol((int)2, (KDTable)table4, (String[])TB_ASSISTQTY_TABS);
    }

    private void initBtnIcon() {
        this.btnAudit.setIcon(EASResource.getIcon((String)"imgTbtn_auditing"));
        this.btnAudit.setEnabled(true);
        this.btnAudit.setVisible(true);
        this.btnCancel.setEnabled(false);
        this.btnCancel.setVisible(false);
        this.btnCancelCancel.setEnabled(false);
        this.btnCancelCancel.setVisible(false);
        this.btnQueryGeneralInventory.setVisible(false);
        this.btnMaterialView.setEnabled(false);
        this.btnMaterialView.setVisible(false);
        this.btnAddLine.setEnabled(false);
        this.btnAddLine.setVisible(false);
        this.btnInsertLine.setEnabled(false);
        this.btnInsertLine.setVisible(false);
        this.menuTable1.setEnabled(false);
        this.menuTable1.setVisible(false);
        this.menuItemAddLine.setEnabled(false);
        this.menuItemAddLine.setVisible(false);
        this.menuItemInsertLine.setEnabled(false);
        this.menuItemInsertLine.setVisible(false);
        this.btnDelVoucher.setEnabled(false);
        this.btnDelVoucher.setVisible(false);
        this.btnVoucher.setEnabled(false);
        this.btnVoucher.setVisible(false);
        this.btnCreateTo.setEnabled(true);
        this.btnCreateTo.setVisible(true);
        this.btnCreateFrom.setEnabled(false);
        this.btnCreateFrom.setVisible(false);
    }

    protected void initTableKeyStrokeUdf(KDTable table, boolean isDownArrow) {
        AbstractAction actionTable = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object srcObject = e.getSource();
                if (srcObject instanceof KDTable) {
                    KDTable table = (KDTable)srcObject;
                    table.removeRow(table.getRowCount() - 1);
                    PurPlanEditUI.this.addLine(table);
                }
            }
        };
        if (isDownArrow) {
            KDTableHelper.downArrowAutoAddRow((KDTable)table, (boolean)true, (Action)actionTable);
        }
    }

    public void onShow() throws Exception {
        super.onShow();
        this.txtNumber.setMaxLength(80);
        if (!this.isAutoNumber) {
            this.txtNumber.requestFocus();
        } else {
            this.txtNumber.setEditable(true);
            this.txtNumber.setEnabled(true);
            if (this.isModifiable) {
                if ("VIEW".equals(this.getOprtState()) || "FINDVIEW".equals(this.getOprtState())) {
                    this.txtNumber.setEditable(false);
                    this.txtNumber.setEnabled(false);
                } else {
                    this.txtNumber.setEditable(true);
                    this.txtNumber.setEnabled(true);
                }
            } else {
                this.txtNumber.setEditable(false);
                this.txtNumber.setEnabled(false);
            }
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public SelectorItemCollection getSelectors() {
        return super.getSelectors();
    }

    @Override
    public void loadFields() {
        KDTable table;
        this.isListenerEnable = false;
        this.beforeLoadFields();
        super.loadFields();
        this.afterLoadFields();
        this.initBOTPData();
        this.initBOTPControl();
        if (this.kDTabbedPaneEntry.getComponentCount() > 0) {
            this.kDTabbedPaneEntry.setSelectedIndex(0);
        }
        if ((table = this.getDetailTable()) != null && table.getRowCount() > 0 && table.getSelectManager() != null) {
            table.getSelectManager().select(0, table.getColumnIndex(TB_MATERIAL_NUMBER));
        }
        this.getNumTextField().requestFocus();
        this.txtDescription.setMaxLength(80);
        this.isListenerEnable = true;
        this.initCompenentFromStatus();
    }

    protected void beforeLoadFields() {
        this.removeListeners();
    }

    protected void removeListeners() {
        if (!this.isUIFirstOnLoad) {
            Iterator itr = this.hmDataChangeListeners.entrySet().iterator();
            Map.Entry entry2 = null;
            Object key = null;
            Object value = null;
            while (itr.hasNext()) {
                entry2 = itr.next();
                key = entry2.getKey();
                value = entry2.getValue();
                if (value == null) continue;
                if (key instanceof KDBizPromptBox) {
                    ((KDBizPromptBox)key).removeDataChangeListener((DataChangeListener)value);
                    continue;
                }
                if (!(key instanceof KDFormattedTextField)) continue;
                ((KDFormattedTextField)key).removeDataChangeListener((DataChangeListener)value);
            }
            for (Map.Entry entry2 : this.hmPreChangeListeners.entrySet()) {
                key = entry2.getKey();
                value = entry2.getValue();
                if (value == null || !(key instanceof KDBizPromptBox)) continue;
                ((KDBizPromptBox)key).removePreChangeListener((PreChangeListener)value);
            }
            for (Map.Entry entry2 : this.hmItemListeners.entrySet()) {
                key = entry2.getKey();
                value = entry2.getValue();
                if (value == null) continue;
                if (key instanceof KDCheckBox) {
                    ((KDCheckBox)key).removeItemListener((ItemListener)value);
                    continue;
                }
                if (!(key instanceof KDComboBox)) continue;
                ((KDComboBox)key).removeItemListener((ItemListener)value);
            }
        }
    }

    protected void afterLoadFields() {
        try {
            this.setPrecisions();
            this.initPrecisions();
        }
        catch (Exception e) {
            this.handleException(e);
        }
        int n = this.getDetailTable().getRowCount();
        for (int i = 0; i < n; ++i) {
            this.setLineStatus(this.getDetailTable(), i);
        }
        this.addListeners();
    }

    public void initBOTPData() {
        if (this.editData.getBaseStatus().getValue() == 0) {
            // empty if block
        }
    }

    public void initBOTPControl() {
        this.btnCreateFrom.setEnabled(true);
        this.btnCreateFrom.setVisible(true);
        this.btnCreateTo.setEnabled(false);
        this.btnCreateTo.setVisible(false);
        if (this.isBotpBill("510b6503-0105-1000-e000-0107c0a812fd463ED552") || this.editData.getBaseStatus().getValue() == 0) {
            this.kdtEntries.getColumn(TB_ROWTYPE).getStyleAttributes().setLocked(true);
            this.kdtEntries.getColumn(TB_MATERIAL_NAME).getStyleAttributes().setLocked(true);
            this.kdtEntries.getColumn(TB_MATERIAL_MODEL).getStyleAttributes().setLocked(true);
            this.kdtEntries.getColumn(TB_MATERIAL_STOREORG).getStyleAttributes().setLocked(true);
            this.kdtEntries.getColumn(TB_MATERIAL_ADMINORGUNIT).getStyleAttributes().setLocked(true);
            this.kdtEntries.getColumn(TB_COMPANYORGUNIT).getStyleAttributes().setLocked(true);
            this.kdtEntries.getColumn(TB_PURCHASEPERSON).getStyleAttributes().setLocked(true);
            this.kdtEntries.getColumn(TB_MATERIAL_NUMBER).getStyleAttributes().setLocked(true);
            this.kdtEntries.getColumn(TB_MATERIAL_ASSISTPROPERTY).getStyleAttributes().setLocked(true);
            this.kdtEntries.getColumn(TB_MATERIAL_RECEIVEDORGUNIT).getStyleAttributes().setLocked(true);
            this.kdtEntries.getColumn(TB_USEDADMINORGUNIT).getStyleAttributes().setLocked(true);
            this.kdtEntries.getColumn(TB_SALEORDERNUMBER).getStyleAttributes().setLocked(true);
            this.kdtEntries.getColumn(TB_BASESTATUS).getStyleAttributes().setLocked(true);
            this.kdtEntries.getColumn(TB_DESTINATIONTYPE).getStyleAttributes().setLocked(true);
            this.kdtEntries.getColumn(TB_WAREHOUSE).getStyleAttributes().setLocked(true);
            this.kdtEntries.getColumn(TB_MATERIAL_UNIT).getStyleAttributes().setLocked(true);
            this.kdtEntries.getColumn(TB_BASEUNIT).getStyleAttributes().setLocked(true);
            this.kdtEntries.getColumn(TB_BASEQTY).getStyleAttributes().setLocked(true);
            this.kdtEntries.getColumn(TB_MATERIAL_ASSISTANTUNIT).getStyleAttributes().setLocked(true);
            this.kdtEntries.getColumn(TB_DELIVERYADDRESS).getStyleAttributes().setLocked(true);
            this.kdtEntries.getColumn(TB_ISURGENT).getStyleAttributes().setLocked(true);
            this.kdtEntries.getColumn(TB_ISQUANTITYUNCTRL).getStyleAttributes().setLocked(true);
            this.kdtEntries.getColumn(TB_ENTRY_REASONCODE).getStyleAttributes().setLocked(true);
            this.kdtEntries.getColumn(TB_MATERIAL_REQDATE).getStyleAttributes().setLocked(true);
            this.kdtEntries.getColumn(TB_MATERIAL_LOCALAMOUNT).getStyleAttributes().setLocked(true);
            this.kdtEntries.getColumn(TB_REMARK).getStyleAttributes().setLocked(true);
            this.kdtEntries.getColumn(TB_MATERIAL_TOTALORDERQTY).getStyleAttributes().setLocked(true);
            this.kdtEntries.getColumn(TB_MATERIAL_TOTALORDERBASEQTY).getStyleAttributes().setLocked(true);
            this.kdtEntries.getColumn(TB_QUOTATIONCOUNT).getStyleAttributes().setLocked(true);
        }
    }

    protected void addListeners() {
        Iterator itr = this.hmDataChangeListeners.entrySet().iterator();
        Map.Entry entry2 = null;
        Object key = null;
        Object value = null;
        while (itr.hasNext()) {
            entry2 = itr.next();
            key = entry2.getKey();
            value = entry2.getValue();
            if (value == null) continue;
            if (key instanceof KDBizPromptBox) {
                ((KDBizPromptBox)key).addDataChangeListener((DataChangeListener)value);
                continue;
            }
            if (key instanceof KDFormattedTextField) {
                ((KDFormattedTextField)key).addDataChangeListener((DataChangeListener)value);
                continue;
            }
            if (!(key instanceof KDDatePicker)) continue;
            ((KDDatePicker)key).addDataChangeListener((DataChangeListener)value);
        }
        for (Map.Entry entry2 : this.hmPreChangeListeners.entrySet()) {
            key = entry2.getKey();
            value = entry2.getValue();
            if (value == null || !(key instanceof KDBizPromptBox)) continue;
            ((KDBizPromptBox)key).addPreChangeListener((PreChangeListener)value);
        }
        for (Map.Entry entry2 : this.hmItemListeners.entrySet()) {
            key = entry2.getKey();
            value = entry2.getValue();
            if (value == null) continue;
            if (key instanceof KDCheckBox) {
                ((KDCheckBox)key).addItemListener((ItemListener)value);
                continue;
            }
            if (!(key instanceof KDComboBox)) continue;
            ((KDComboBox)key).addItemListener((ItemListener)value);
        }
    }

    private void initCompenentFromStatus() {
        if (this.getOprtState().equals("ALERT") || this.editData.getBaseStatus() != null && this.editData.getBaseStatus().getValue() == -2) {
            this.txtNumber.setEnabled(false);
            this.prmtPurchaseOrgUnit.setEnabled(false);
            this.prmtPurchaseOrgUnitFilter.setEnabled(false);
        }
    }

    private void initUIData(CompanyOrgUnitInfo ficompanyOrgInfo1) throws EASBizException, BOSException {
        if (this.isCoay) {
            return;
        }
        this.ficompanyOrgInfo = (CompanyOrgUnitInfo)this.getUIContext().get(OrgType.Company);
        this.baseCurrInfo = this.getSCMBizDataVO() != null ? this.getSCMBizDataVO().getBaseCurrInfo() : null;
        this.dealWithPrmtCurrency();
    }

    private void dealWithPrmtCurrency() {
    }

    private void CurrencyChanged(CompanyOrgUnitInfo fiComOrgInfo, CurrencyInfo sourcecurrencyInfo, CurrencyInfo baseCurrencyInfo, int rowIndex) throws Exception {
        CurrencyInfo currencyInfo = sourcecurrencyInfo;
        if (currencyInfo != null) {
            this.exchangeRateChange(fiComOrgInfo, currencyInfo, baseCurrencyInfo, rowIndex);
            if (currencyInfo.getId().equals((Object)baseCurrencyInfo.getId())) {
                this.getDetailTable().getCell(rowIndex, TB_MATERIAL_EXCHRATE).getStyleAttributes().setLocked(true);
            } else {
                this.getDetailTable().getCell(rowIndex, TB_MATERIAL_EXCHRATE).getStyleAttributes().setLocked(false);
            }
        } else {
            this.getDetailTable().getCell(rowIndex, TB_MATERIAL_EXCHRATE).getStyleAttributes().setLocked(true);
        }
    }

    private void exchangeRateChange(CompanyOrgUnitInfo fiComOrgInfo, CurrencyInfo currencyInfo, CurrencyInfo baseCurrInfo, int rowIndex) throws EASBizException, BOSException {
        ObjectUuidPK destCurrPK;
        if (currencyInfo == null || baseCurrInfo == null) {
            return;
        }
        BigDecimal exchangeRate = ONE;
        ExchangeRateInfo exchangeRateinfo = null;
        ObjectUuidPK sourceCurrPK = new ObjectUuidPK(currencyInfo.getId());
        exchangeRateinfo = SCMClientUtils.getExchangeRate((CompanyOrgUnitInfo)fiComOrgInfo, (IObjectPK)sourceCurrPK, (IObjectPK)(destCurrPK = new ObjectUuidPK(baseCurrInfo.getId())));
        if (exchangeRateinfo != null) {
            exchangeRate = exchangeRateinfo.getConvertRate();
        }
        this.getDetailTable().getCell(rowIndex, TB_MATERIAL_EXCHRATE).setValue((Object)exchangeRate);
        int precision = this.getExchangeRateInfo(fiComOrgInfo, currencyInfo) != null ? this.getExchangeRateInfo(fiComOrgInfo, currencyInfo).getPrecision() : currencyInfo.getPrecision();
        SCMClientUtils.changeTableColPrecision((int)precision, (KDTable)this.getDetailTable(), (String[])new String[]{TB_MATERIAL_EXCHRATE}, (int)rowIndex);
    }

    private ExchangeRateInfo getExchangeRateInfo(CompanyOrgUnitInfo fiComOrgInfo, CurrencyInfo sourceCurrencyInfo) throws EASBizException, BOSException {
        CurrencyInfo currencyInfo = fiComOrgInfo.getBaseCurrency();
        ExchangeRateInfo exchangeRateinfo = null;
        ObjectUuidPK sourceCurrPK = new ObjectUuidPK(sourceCurrencyInfo.getId());
        ObjectUuidPK destCurrPK = new ObjectUuidPK(currencyInfo.getId());
        exchangeRateinfo = SCMClientUtils.getExchangeRate((CompanyOrgUnitInfo)fiComOrgInfo, (IObjectPK)sourceCurrPK, (IObjectPK)destCurrPK);
        return exchangeRateinfo;
    }

    private void calEntryLocalAmount(int rowIndex, int colIndex, CompanyOrgUnitInfo ficompanyOrgInfoForEntry) throws EASBizException, BOSException {
        Object newCurr = this.kdtEntries.getRow(rowIndex).getCell(TB_MATERIAL_CURRENCY).getValue();
        Object amount = this.kdtEntries.getRow(rowIndex).getCell(TB_MATERIAL_AMOUNT).getValue();
        if (newCurr == null || amount == null) {
            return;
        }
        CurrencyInfo newCurrInfo = (CurrencyInfo)newCurr;
        BigDecimal oldAmount = (BigDecimal)amount;
        ExchangeRateInfo exchangeRateInfo = null;
        CurrencyInfo baseCurrencyInfo = ficompanyOrgInfoForEntry.getBaseCurrency();
        if (newCurrInfo.equals((Object)baseCurrencyInfo)) {
            oldAmount = oldAmount.setScale(baseCurrencyInfo.getPrecision());
            this.kdtEntries.getRow(rowIndex).getCell(TB_MATERIAL_LOCALAMOUNT).setValue((Object)oldAmount);
        } else {
            exchangeRateInfo = this.getExchangeRateInfo(ficompanyOrgInfoForEntry, newCurrInfo);
            if (exchangeRateInfo == null) {
                return;
            }
            BigDecimal exchangeRate = exchangeRateInfo.getConvertRate();
            BigDecimal exchangeRate2 = exchangeRate.setScale(exchangeRateInfo.getPrecision(), 4);
            if (!(this.kdtEntries.getRow(rowIndex).getCell(TB_MATERIAL_EXCHRATE).getValue() instanceof BigDecimal)) {
                this.kdtEntries.getRow(rowIndex).getCell(TB_MATERIAL_EXCHRATE).setValue((Object)exchangeRate2);
            } else {
                exchangeRate2 = (BigDecimal)this.kdtEntries.getRow(rowIndex).getCell(TB_MATERIAL_EXCHRATE).getValue();
            }
            if (exchangeRateInfo.getExchangeAux().getConvertMode() == ConvertModeEnum.INDIRECTEXCHANGERATE) {
                this.kdtEntries.getRow(rowIndex).getCell(TB_MATERIAL_LOCALAMOUNT).setValue((Object)oldAmount.divide(exchangeRate2, this.baseCurrInfo.getPrecision(), 4));
            } else {
                this.kdtEntries.getRow(rowIndex).getCell(TB_MATERIAL_LOCALAMOUNT).setValue((Object)oldAmount.multiply(exchangeRate2).setScale(baseCurrencyInfo.getPrecision(), 4));
            }
        }
    }

    private void setPrecisions() throws Exception {
        int n = this.getDetailTable().getRowCount();
        for (int i = 0; i < n; ++i) {
            this.setPrecisionByMaterial(this.getDetailTable(), i);
            this.setPrecisionByUnits(this.getDetailTable(), i);
        }
    }

    private void setLineStatus(KDTable table, int rowIndex) {
        this.setLineStatusByMaterial(table, rowIndex);
    }

    private void setLineStatusByMaterial(KDTable table, int rowIndex) {
        IRow row = table.getRow(rowIndex);
        if (table == this.getDetailTable()) {
            MaterialInfo materialInfo = (MaterialInfo)row.getCell(TB_MATERIAL_NUMBER).getValue();
            boolean isAssistPropertyNecessary = false;
            if (materialInfo != null && materialInfo.getAssistAttr() != null) {
                isAssistPropertyNecessary = true;
            }
            SCMClientUtils.setBgColor4Cells((IRow)row, (String[])new String[]{TB_MATERIAL_ASSISTPROPERTY}, (boolean)isAssistPropertyNecessary);
        }
    }

    private void setPrecisionByMaterial(KDTable table, int rowIndex) {
        MaterialInfo material = (MaterialInfo)table.getCell(rowIndex, TB_MATERIAL_NUMBER).getValue();
        if (material != null) {
            SCMClientUtils.changeTableColPrecision((int)material.getPricePrecision(), (KDTable)table, (String[])TB_PRICE_TABS, (int)rowIndex);
        }
    }

    private void setPrecisionByUnits(KDTable table, int rowIndex) throws Exception {
        if (table.getCell(rowIndex, TB_MATERIAL_NUMBER).getValue() == null) {
            return;
        }
        MaterialInfo material = (MaterialInfo)table.getCell(rowIndex, TB_MATERIAL_NUMBER).getValue();
        int qtyPrecision = 4;
        int assisttQtyPrecision = 4;
        int baseQtyPrecision = 4;
        if (table.getCell(rowIndex, TB_MATERIAL_UNIT).getValue() != null) {
            qtyPrecision = this.getQtyPrecisionFromMap(material.getId().toString(), ((MeasureUnitInfo)table.getCell(rowIndex, TB_MATERIAL_UNIT).getValue()).getId().toString());
            SCMClientUtils.changeTableColPrecision((int)qtyPrecision, (KDTable)table, (String[])TB_QTY_TABS, (int)rowIndex);
        }
        if (table.getCell(rowIndex, TB_MATERIAL_ASSISTANTUNIT).getValue() != null) {
            assisttQtyPrecision = this.getQtyPrecisionFromMap(material.getId().toString(), ((MeasureUnitInfo)table.getCell(rowIndex, TB_MATERIAL_ASSISTANTUNIT).getValue()).getId().toString());
            SCMClientUtils.changeTableColPrecision((int)assisttQtyPrecision, (KDTable)table, (String[])TB_ASSISTQTY_TABS, (int)rowIndex);
        }
        if (table.getCell(rowIndex, TB_BASEUNIT).getValue() != null) {
            baseQtyPrecision = this.getQtyPrecisionFromMap(material.getId().toString(), ((MeasureUnitInfo)table.getCell(rowIndex, TB_BASEUNIT).getValue()).getId().toString());
            SCMClientUtils.changeTableColPrecision((int)baseQtyPrecision, (KDTable)table, (String[])TB_BASEQTY_TABS, (int)rowIndex);
        }
    }

    protected void afterMainOrgChanged(String arg0, String arg1) {
        super.afterMainOrgChanged(arg0, arg1);
        if (SCMGroupClientUtils.isDiffrent((Object)arg0, (Object)arg1)) {
            try {
                if (this.getDefaultDelegatedOrg(OrgType.Company) == null) {
                    return;
                }
                this.ficompanyOrgInfo = (CompanyOrgUnitInfo)this.getDefaultDelegatedOrg(OrgType.Company);
                this.initUIData((CompanyOrgUnitInfo)this.getDefaultDelegatedOrg(OrgType.Company));
                this.prmtPurchaseOrgUnitFilter.setValue(this.prmtPurchaseOrgUnit.getData());
            }
            catch (EASBizException e) {
                this.handleException((Exception)((Object)e));
            }
            catch (BOSException e) {
                this.handleException((Exception)((Object)e));
            }
        }
    }

    protected void kDChkAllSelectItemChanged(boolean isInTax) {
        boolean isSelect = this.kDChkAllSelect.isSelected();
        try {
            for (int i = 0; i < this.getDetailTable2().getRowCount(); ++i) {
                if (isSelect) {
                    this.getDetailTable2().getRow(i).getCell("select").setValue((Object)true);
                    continue;
                }
                this.getDetailTable2().getRow(i).getCell("select").setValue((Object)false);
            }
            KDTable table = this.getDetailTable2();
            IRow row = null;
            if (isSelect) {
                for (int i = 0; i < this.getDetailTable2().getRowCount(); ++i) {
                    row = table.getRow(i);
                    this.fillPurPlanEntriesTable(row);
                }
            } else {
                for (int i = 0; i < this.getDetailTable2().getRowCount(); ++i) {
                    row = table.getRow(i);
                    this.deleteRowFromPurPlanEntriesTable(table.getCell(i, "entryid").getValue().toString());
                }
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    protected void kDChkDisplayItemChanged(boolean isInTax) {
        boolean isSelect = this.kDChkDisplay.isSelected();
        try {
            if (isSelect) {
                this.loadPurRequestList();
                this.kDChkAllSelectItemChanged(this.kDChkAllSelect.isSelected());
            }
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
    }

    private void kDCheckInv_StateChanged(ItemEvent arg0) {
        if (this.kDCheckInv.isSelected()) {
            this.kDCheckWareHs.setSelected(true);
            this.kDCheckWareHs.setEnabled(true);
            this.kDCheckLocation.setSelected(true);
            this.kDCheckLocation.setEnabled(true);
            this.kDCheckLot.setSelected(true);
            this.kDCheckLot.setEnabled(true);
            this.checkBoxChangeToQueryInv();
        } else {
            this.kDCheckWareHs.setSelected(false);
            this.kDCheckWareHs.setEnabled(false);
            this.kDCheckLocation.setSelected(false);
            this.kDCheckLocation.setEnabled(false);
            this.kDCheckLot.setSelected(false);
            this.kDCheckLot.setEnabled(false);
        }
    }

    protected void checkBoxChangeToQueryInv() {
        int rowNum;
        if (this.kdtEntriesRequest.getSelectManager().get() != null && (rowNum = this.kdtEntriesRequest.getSelectManager().get().getBeginRow()) >= 0) {
            try {
                this.queryInventory(rowNum);
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
            catch (SQLException e) {
                this.handUIException(e);
            }
        }
    }

    private void kDCheckWareHs_StateChanged(ItemEvent arg0) {
        if (this.kDCheckWareHs.isSelected()) {
            this.kDCheckLocation.setEnabled(true);
            this.kDCheckLocation.setSelected(true);
        } else {
            this.kDCheckLocation.setSelected(false);
            this.kDCheckLocation.setEnabled(false);
        }
        this.checkBoxChangeToQueryInv();
    }

    private void cbkSelect_StateChanged(ItemEvent arg0) {
        KDTable table = this.getDetailTable2();
        int rowIndex = this.getDetailTable2().getSelectManager().getActiveRowIndex();
        IRow row = table.getRow(rowIndex);
        if (!this.cbkSelect.isSelected()) {
            this.deleteRowFromPurPlanEntriesTable(table.getCell(rowIndex, "entryid").getValue().toString());
        } else {
            try {
                this.fillPurPlanEntriesTable(row);
            }
            catch (Exception e1) {
                this.handleException(e1);
            }
        }
    }

    protected void purchaseOrgFilterChanged(PurchaseOrgUnitInfo purchaseOrgUnitInfo) {
        boolean isSelect = this.kDChkDisplay.isSelected();
        if (purchaseOrgUnitInfo != null) {
            try {
                if (isSelect) {
                    this.loadPurRequestList();
                }
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
        }
    }

    protected void pkRequestDateFilterChanged(DataChangeEvent e) {
        boolean isSelect = this.kDChkDisplay.isSelected();
        try {
            if (isSelect) {
                this.loadPurRequestList();
            }
        }
        catch (BOSException e1) {
            this.handUIException(e1);
        }
    }

    protected void pkRequestDateToFilterChanged(DataChangeEvent e) {
        boolean isSelect = this.kDChkDisplay.isSelected();
        try {
            if (isSelect) {
                this.loadPurRequestList();
            }
        }
        catch (BOSException e1) {
            this.handUIException(e1);
        }
    }

    protected void comboPurchaseTypeFilterChanged(ItemEvent e) {
        boolean isSelect = this.kDChkDisplay.isSelected();
        try {
            if (isSelect) {
                this.loadPurRequestList();
            }
        }
        catch (BOSException e1) {
            this.handUIException(e1);
        }
    }

    private void loadPurRequestList() throws BOSException {
        if (this.prmtPurchaseOrgUnitFilter.getValue() == null) {
            return;
        }
        if (this.pkRequestDateFilter.getValue() == null && this.pkRequestDateToFilter.getValue() == null) {
            return;
        }
        PurchaseOrgUnitInfo purOrgInfo = (PurchaseOrgUnitInfo)this.prmtPurchaseOrgUnitFilter.getValue();
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("parent.baseStatus", (Object)new Integer(4), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo(TB_BASESTATUS, (Object)new Integer(4), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("purchaseOrgUnit.id", (Object)purOrgInfo.getId().toString(), CompareType.EQUALS));
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        if (this.pkRequestDateFilter.getValue() != null) {
            Date reqDate = (Date)this.pkRequestDateFilter.getValue();
            filterInfo.getFilterItems().add(new FilterItemInfo(TB_MATERIAL_REQDATE, (Object)(sdf.format(reqDate) + " 00:00:00.0"), CompareType.GREATER_EQUALS));
        }
        if (this.pkRequestDateToFilter.getValue() != null) {
            Date reqToDate = (Date)this.pkRequestDateToFilter.getValue();
            filterInfo.getFilterItems().add(new FilterItemInfo(TB_MATERIAL_REQDATE, (Object)(sdf.format(reqToDate) + " 23:59:59.0"), CompareType.LESS_EQUALS));
        }
        ev.setFilter(filterInfo);
        ev.getSelector().add(new SelectorItemInfo("parent.number"));
        ev.getSelector().add(new SelectorItemInfo("parent.companyOrgUnit.id"));
        ev.getSelector().add(new SelectorItemInfo("parent.companyOrgUnit.name"));
        ev.getSelector().add(new SelectorItemInfo("parent.id"));
        ev.getSelector().add(new SelectorItemInfo("seq"));
        ev.getSelector().add(new SelectorItemInfo("rowType.id"));
        ev.getSelector().add(new SelectorItemInfo("rowType.name"));
        ev.getSelector().add(new SelectorItemInfo(TB_MATERIAL_NAME));
        ev.getSelector().add(new SelectorItemInfo("rowType.number"));
        ev.getSelector().add(new SelectorItemInfo("storageOrgUnit.id"));
        ev.getSelector().add(new SelectorItemInfo("storageOrgUnit.name"));
        ev.getSelector().add(new SelectorItemInfo("receivedOrgUnit.id"));
        ev.getSelector().add(new SelectorItemInfo("receivedOrgUnit.name"));
        ev.getSelector().add(new SelectorItemInfo("material.id"));
        ev.getSelector().add(new SelectorItemInfo("material.number"));
        ev.getSelector().add(new SelectorItemInfo("material.name"));
        ev.getSelector().add(new SelectorItemInfo("material.model"));
        ev.getSelector().add(new SelectorItemInfo("unit.id"));
        ev.getSelector().add(new SelectorItemInfo("unit.name"));
        ev.getSelector().add(new SelectorItemInfo(TB_MATERIAL_QUANTITY));
        ev.getSelector().add(new SelectorItemInfo(TB_MATERIAL_REQDATE));
        ev.getSelector().add(new SelectorItemInfo(TB_MATERIAL_PROPOSEDELIVERYDATE));
        ev.getSelector().add(new SelectorItemInfo(TB_MATERIAL_PROPOSEPURCHASEDATE));
        SorterItemInfo sort = new SorterItemInfo("parent.bizDate");
        sort.setSortType(SortType.DESCEND);
        ev.getSorter().add(sort);
        sort = new SorterItemInfo("parent.number");
        sort.setSortType(SortType.DESCEND);
        ev.getSorter().add(sort);
        sort = new SorterItemInfo("seq");
        sort.setSortType(SortType.DESCEND);
        ev.getSorter().add(sort);
        PurRequestEntryInfo purRequestEntryInfo = null;
        PurRequestEntryCollection purReqEntryColl = PurRequestEntryFactory.getRemoteInstance().getPurRequestEntryCollection(ev);
        int index = 0;
        IRow row = null;
        this.getDetailTable2().removeRows();
        if (purReqEntryColl != null && purReqEntryColl.size() > 0) {
            int c = purReqEntryColl.size();
            for (int i = 0; i < c; ++i) {
                purRequestEntryInfo = purReqEntryColl.get(i);
                if (purRequestEntryInfo == null) continue;
                row = this.getDetailTable2().addRow(index);
                row.getCell("select").setValue((Object)false);
                row.getCell("number").setValue((Object)purRequestEntryInfo.getParent().getNumber());
                row.getCell(TB_COMPANYORGUNIT).setValue((Object)purRequestEntryInfo.getParent().getCompanyOrgUnit().getName());
                row.getCell("seq").setValue((Object)new Integer(purRequestEntryInfo.getSeq()));
                row.getCell(TB_ROWTYPE).setValue((Object)purRequestEntryInfo.getRowType());
                if (purRequestEntryInfo.getStorageOrgUnit() != null) {
                    row.getCell(TB_MATERIAL_STOREORG).setValue((Object)purRequestEntryInfo.getStorageOrgUnit().getName());
                }
                row.getCell("receviedOrgUnit").setValue(purRequestEntryInfo.getReceivedOrgUnit() == null ? null : purRequestEntryInfo.getReceivedOrgUnit().getName());
                row.getCell("materialNumber").setValue(purRequestEntryInfo.getMaterial() == null ? null : purRequestEntryInfo.getMaterial().getNumber());
                row.getCell(TB_MATERIAL_NAME).setValue((Object)(purRequestEntryInfo.getMaterial() == null ? purRequestEntryInfo.getMaterialName() : purRequestEntryInfo.getMaterial().getName()));
                row.getCell("materialModel").setValue((Object)(purRequestEntryInfo.getMaterial() == null ? purRequestEntryInfo.getNoNumMaterialModel() : purRequestEntryInfo.getMaterial().getModel()));
                row.getCell(TB_MATERIAL_UNIT).setValue((Object)purRequestEntryInfo.getUnit().getName());
                row.getCell(TB_MATERIAL_QUANTITY).setValue((Object)purRequestEntryInfo.getQty());
                row.getCell("requestDate").setValue((Object)purRequestEntryInfo.getRequirementDate());
                row.getCell("proposeDevliveryDate").setValue((Object)purRequestEntryInfo.getProposeDeliveryDate());
                row.getCell("proposePurDate").setValue((Object)purRequestEntryInfo.getProposePurchaseDate());
                row.getCell("id").setValue((Object)purRequestEntryInfo.getParent().getId().toString());
                row.getCell("entryid").setValue((Object)purRequestEntryInfo.getId().toString());
                row.getCell("material.id").setValue(purRequestEntryInfo.getMaterial() == null ? null : purRequestEntryInfo.getMaterial().getId().toString());
                row.getCell("receviedOrgUnit.id").setValue(purRequestEntryInfo.getReceivedOrgUnit() == null ? null : purRequestEntryInfo.getReceivedOrgUnit().getId().toString());
            }
        }
    }

    private String getQueryType() {
        String queryType = null;
        if (this.kDCheckWareHs.isSelected()) {
            queryType = queryType + "a";
        }
        if (this.kDCheckLocation.isSelected()) {
            queryType = queryType + "b";
        }
        if (this.kDCheckLot.isSelected()) {
            queryType = queryType + "c";
        }
        return queryType;
    }

    protected void queryInventory(int rowNum) throws BOSException, SQLException {
        this.kdtEntriesInv.removeRows();
        if (this.kDCheckInv.isSelected()) {
            String materialId = this.kdtEntriesRequest.getCell(rowNum, "material.id").getValue().toString();
            String stroageId = this.kdtEntriesRequest.getCell(rowNum, "receviedOrgUnit.id").getValue().toString();
            IRowSet rs = PurPlanFacadeFactory.getRemoteInstance().getInventoryInfo(materialId, stroageId, this.getQueryType());
            this.fullTbInvenInfo(rs);
        }
    }

    private void fullTbInvenInfo(IRowSet rs) throws SQLException {
        int i = 0;
        IRow iRow = null;
        while (rs.next()) {
            iRow = this.kdtEntriesInv.addRow();
            for (int j = 0; j < this.kdtEntriesInv.getColumnCount(); ++j) {
                iRow.getCell(j).setValue((Object)rs.getString(this.kdtEntriesInv.getColumnKey(j)));
            }
            ++i;
        }
    }

    private void deleteRowFromPurPlanEntriesTable(String entryId) {
        for (int i = 0; i < this.kdtEntries.getRowCount(); ++i) {
            if (entryId == null || this.kdtEntries.getCell(i, "sourceBillEntryID").getValue() == null || !entryId.equals(this.kdtEntries.getCell(i, "sourceBillEntryID").getValue().toString())) continue;
            this.kdtEntries.removeRow(i);
            return;
        }
    }

    private void fillPurPlanEntriesTable(IRow iRow) throws Exception {
        String billID = iRow.getCell("id").getValue().toString();
        String billNumber = iRow.getCell("number").getValue().toString();
        String entryID = iRow.getCell("entryid").getValue().toString();
        String seq = iRow.getCell("seq").getValue().toString();
        for (int i = 0; i < this.kdtEntries.getRowCount(); ++i) {
            if (this.kdtEntries.getCell(i, "sourceBillEntryID").getValue() == null || !entryID.endsWith(this.kdtEntries.getCell(i, "sourceBillEntryID").getValue().toString())) continue;
            return;
        }
        int rowIndex = this.kdtEntries.getRowCount();
        IRow purPlanRow = this.kdtEntries.addRow(rowIndex);
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("parent.baseStatus", (Object)new Integer(4), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo(TB_BASESTATUS, (Object)new Integer(4), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)entryID, CompareType.EQUALS));
        ev.setFilter(filterInfo);
        ev.getSelector().add(new SelectorItemInfo("parent.id"));
        ev.getSelector().add(new SelectorItemInfo("parent.number"));
        ev.getSelector().add(new SelectorItemInfo("parent.companyOrgUnit.id"));
        ev.getSelector().add(new SelectorItemInfo("parent.companyOrgUnit.name"));
        ev.getSelector().add(new SelectorItemInfo("parent.companyOrgUnit.number"));
        ev.getSelector().add(new SelectorItemInfo("parent.isUrgent"));
        ev.getSelector().add(new SelectorItemInfo("rowType.id"));
        ev.getSelector().add(new SelectorItemInfo("rowType.name"));
        ev.getSelector().add(new SelectorItemInfo("rowType.number"));
        ev.getSelector().add(new SelectorItemInfo("storageOrgUnit.id"));
        ev.getSelector().add(new SelectorItemInfo("storageOrgUnit.name"));
        ev.getSelector().add(new SelectorItemInfo("storageOrgUnit.number"));
        ev.getSelector().add(new SelectorItemInfo("receivedOrgUnit.id"));
        ev.getSelector().add(new SelectorItemInfo("receivedOrgUnit.name"));
        ev.getSelector().add(new SelectorItemInfo("receivedOrgUnit.number"));
        ev.getSelector().add(new SelectorItemInfo("material.id"));
        ev.getSelector().add(new SelectorItemInfo("material.number"));
        ev.getSelector().add(new SelectorItemInfo("material.name"));
        ev.getSelector().add(new SelectorItemInfo("material.model"));
        ev.getSelector().add(new SelectorItemInfo("assistProperty.id"));
        ev.getSelector().add(new SelectorItemInfo("assistProperty.number"));
        ev.getSelector().add(new SelectorItemInfo("assistProperty.name"));
        ev.getSelector().add(new SelectorItemInfo("unit.id"));
        ev.getSelector().add(new SelectorItemInfo("unit.name"));
        ev.getSelector().add(new SelectorItemInfo("unit.number"));
        ev.getSelector().add(new SelectorItemInfo("unit.qtyPrecision"));
        ev.getSelector().add(new SelectorItemInfo("baseUnit.id"));
        ev.getSelector().add(new SelectorItemInfo("baseUnit.name"));
        ev.getSelector().add(new SelectorItemInfo("baseUnit.number"));
        ev.getSelector().add(new SelectorItemInfo("baseUnit.qtyPrecision"));
        ev.getSelector().add(new SelectorItemInfo("assistUnit.id"));
        ev.getSelector().add(new SelectorItemInfo("assistUnit.name"));
        ev.getSelector().add(new SelectorItemInfo("assistUnit.number"));
        ev.getSelector().add(new SelectorItemInfo("assistUnit.qtyPrecision"));
        ev.getSelector().add(new SelectorItemInfo("purchasePerson.id"));
        ev.getSelector().add(new SelectorItemInfo("purchasePerson.name"));
        ev.getSelector().add(new SelectorItemInfo("purchasePerson.number"));
        ev.getSelector().add(new SelectorItemInfo("warehosue.id"));
        ev.getSelector().add(new SelectorItemInfo("warehosue.name"));
        ev.getSelector().add(new SelectorItemInfo("warehosue.number"));
        ev.getSelector().add(new SelectorItemInfo("currency.id"));
        ev.getSelector().add(new SelectorItemInfo("currency.name"));
        ev.getSelector().add(new SelectorItemInfo("currency.number"));
        ev.getSelector().add(new SelectorItemInfo("supplier.id"));
        ev.getSelector().add(new SelectorItemInfo("supplier.name"));
        ev.getSelector().add(new SelectorItemInfo("supplier.number"));
        ev.getSelector().add(new SelectorItemInfo("*"));
        PurRequestEntryInfo purRequestEntryInfo = null;
        PurRequestEntryCollection purReqEntryColl = PurRequestEntryFactory.getRemoteInstance().getPurRequestEntryCollection(ev);
        if (purReqEntryColl != null && purReqEntryColl.size() > 0) {
            int j = purReqEntryColl.size();
            for (int i = 0; i < j; ++i) {
                purRequestEntryInfo = purReqEntryColl.get(i);
                if (purRequestEntryInfo == null) continue;
                this.setPrecisionByUnits(this.kdtEntries, rowIndex);
                purPlanRow.getCell("sourceBillID").setValue((Object)billID);
                purPlanRow.getCell("sourceBillNumber").setValue((Object)billNumber);
                purPlanRow.getCell("sourceBillEntrySeq").setValue((Object)seq);
                purPlanRow.getCell("sourceBillEntryID").setValue((Object)entryID);
                BillTypeInfo billTypeInfo = new BillTypeInfo();
                billTypeInfo.setId(BOSUuid.read((String)"510b6503-0105-1000-e000-0107c0a812fd463ED552"));
                purPlanRow.getCell("sourceBillTypeID").setValue((Object)billTypeInfo.getId().toString());
                purPlanRow.getCell(TB_ROWTYPE).setValue((Object)purRequestEntryInfo.getRowType());
                purPlanRow.getCell(TB_MATERIAL_STOREORG).setValue((Object)purRequestEntryInfo.getStorageOrgUnit());
                purPlanRow.getCell(TB_MATERIAL_ADMINORGUNIT).setValue((Object)purRequestEntryInfo.getAdminOrgUnit());
                purPlanRow.getCell(TB_COMPANYORGUNIT).setValue((Object)purRequestEntryInfo.getParent().getCompanyOrgUnit());
                purPlanRow.getCell(TB_MATERIAL_RECEIVEDORGUNIT).setValue((Object)purRequestEntryInfo.getReceivedOrgUnit());
                purPlanRow.getCell(TB_USEDADMINORGUNIT).setValue((Object)purRequestEntryInfo.getUseAdminOrgUnit());
                purPlanRow.getCell(TB_MATERIAL_NUMBER).setValue((Object)purRequestEntryInfo.getMaterial());
                purPlanRow.getCell(TB_MATERIAL_NAME).setValue((Object)(purRequestEntryInfo.getMaterial() == null ? purRequestEntryInfo.getMaterialName() : purRequestEntryInfo.getMaterial().getName()));
                purPlanRow.getCell(TB_MATERIAL_MODEL).setValue((Object)(purRequestEntryInfo.getMaterial() == null ? purRequestEntryInfo.getNoNumMaterialModel() : purRequestEntryInfo.getMaterial().getModel()));
                purPlanRow.getCell(TB_MATERIAL_ASSISTPROPERTY).setValue((Object)purRequestEntryInfo.getAssistProperty());
                purPlanRow.getCell(TB_PURCHASEPERSON).setValue((Object)purRequestEntryInfo.getPurchasePerson());
                purPlanRow.getCell(TB_SALEORDERNUMBER).setValue((Object)purRequestEntryInfo.getSaleOrderNumber());
                purPlanRow.getCell(TB_DESTINATIONTYPE).setValue((Object)purRequestEntryInfo.getDestinationType());
                purPlanRow.getCell(TB_MATERIAL_UNIT).setValue((Object)purRequestEntryInfo.getUnit());
                purPlanRow.getCell(TB_MATERIAL_QUANTITY).setValue((Object)purRequestEntryInfo.getQty());
                purPlanRow.getCell(TB_BASEUNIT).setValue((Object)purRequestEntryInfo.getBaseUnit());
                purPlanRow.getCell(TB_BASEQTY).setValue((Object)purRequestEntryInfo.getBaseQty());
                purPlanRow.getCell(TB_MATERIAL_ASSISTANTUNIT).setValue((Object)purRequestEntryInfo.getAssistUnit());
                purPlanRow.getCell(TB_MATERIAL_ASSISTQUANTIRTY).setValue((Object)purRequestEntryInfo.getAssistQty());
                purPlanRow.getCell(TB_ISQUANTITYUNCTRL).setValue((Object)purRequestEntryInfo.isIsQuantityUnCtrl());
                purPlanRow.getCell(TB_MATERIAL_CURRENCY).setValue((Object)purRequestEntryInfo.getCurrency());
                purPlanRow.getCell(TB_MATERIAL_EXCHRATE).setValue((Object)purRequestEntryInfo.getExchangeRate());
                purPlanRow.getCell(TB_MATERIAL_PRICE).setValue((Object)purRequestEntryInfo.getPrice());
                purPlanRow.getCell(TB_MATERIAL_AMOUNT).setValue((Object)purRequestEntryInfo.getAmount());
                purPlanRow.getCell(TB_MATERIAL_LOCALAMOUNT).setValue((Object)purRequestEntryInfo.getLocalAmount());
                purPlanRow.getCell(TB_MATERIAL_REQDATE).setValue((Object)purRequestEntryInfo.getRequirementDate());
                purPlanRow.getCell(TB_MATERIAL_PROPOSEDELIVERYDATE).setValue((Object)purRequestEntryInfo.getProposeDeliveryDate());
                purPlanRow.getCell(TB_MATERIAL_PROPOSEPURCHASEDATE).setValue((Object)purRequestEntryInfo.getProposePurchaseDate());
                purPlanRow.getCell(TB_DELIVERYADDRESS).setValue((Object)purRequestEntryInfo.getDeliveryAddress());
                purPlanRow.getCell(TB_WAREHOUSE).setValue((Object)purRequestEntryInfo.getWarehosue());
                purPlanRow.getCell(TB_MATERIAL_SUPPLIER).setValue((Object)purRequestEntryInfo.getSupplier());
                purPlanRow.getCell(TB_ISURGENT).setValue((Object)purRequestEntryInfo.getParent().isIsUrgent());
                purPlanRow.getCell(TB_REMARK).setValue((Object)purRequestEntryInfo.getRemark());
            }
        }
    }

    protected boolean isBigDeciamlEqual(Object oldValue, Object newValue) {
        if (newValue == oldValue) {
            return true;
        }
        if (newValue instanceof BigDecimal && oldValue instanceof BigDecimal) {
            return ((BigDecimal)newValue).compareTo((BigDecimal)oldValue) == 0;
        }
        return false;
    }

    protected boolean isDateEqual(Object newValue, Object oldValue) {
        if (newValue == oldValue) {
            return true;
        }
        if (newValue instanceof Date && oldValue instanceof Date) {
            Date d1 = (Date)newValue;
            Date d2 = (Date)oldValue;
            return d1.getTime() / 86400L / 1000L == d2.getTime() / 86400L / 1000L;
        }
        return false;
    }

    protected boolean isCoreBaseEqual(Object oldValue, Object newValue) {
        if (newValue == oldValue) {
            return true;
        }
        if (newValue instanceof CoreBaseInfo && oldValue instanceof CoreBaseInfo) {
            return ((CoreBaseInfo)newValue).getId().equals((Object)((CoreBaseInfo)oldValue).getId());
        }
        return false;
    }

    protected IObjectValue createNewData() {
        PurPlanInfo purPlanInfo = null;
        try {
            Context objectCtx = this.getMainOrgContext();
            if (objectCtx == null) {
                objectCtx = new Context();
            }
            purPlanInfo = (PurPlanInfo)PurPlanFactory.getRemoteInstanceWithObjectContext(objectCtx).createNewData(this.isUseAgent());
            if (this.getDefaultMainBizOrg() instanceof PurchaseOrgUnitInfo) {
                purPlanInfo.setPurchaseOrgUnit((PurchaseOrgUnitInfo)this.getDefaultMainBizOrg());
            } else {
                purPlanInfo.setPurchaseOrgUnit(null);
            }
            purPlanInfo.setCreator(SysContext.getSysContext().getCurrentUserInfo());
            UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
            purPlanInfo.setCreator(userInfo);
            purPlanInfo.setAuditTime(null);
            this.pkAuditTime.setValue(null);
            purPlanInfo.setModificationTime(null);
            this.pkModificationTime.setValue(null);
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return purPlanInfo;
    }

    protected IObjectValue createNewDetailData(KDTable table) {
        PurPlanEntryInfo purPlanEntryInfo = null;
        try {
            purPlanEntryInfo = this.isUseAgent() ? PurPlanEntryAgent.create() : new PurPlanEntryInfo();
            BigDecimal defaultQty = SysConstant.BIGZERO;
            purPlanEntryInfo.setQty(defaultQty);
            purPlanEntryInfo.setAssistQty(defaultQty);
            purPlanEntryInfo.setAmount(defaultQty);
            purPlanEntryInfo.setPrice(defaultQty);
            purPlanEntryInfo.setAssociateQty(defaultQty);
            purPlanEntryInfo.setRequirementDate(new Timestamp(System.currentTimeMillis()));
            purPlanEntryInfo.setProposeDeliveryDate(new Timestamp(System.currentTimeMillis()));
            purPlanEntryInfo.setProposePurchaseDate(new Timestamp(System.currentTimeMillis()));
            if (this.baseCurrInfo != null) {
                purPlanEntryInfo.setCurrency(this.baseCurrInfo);
            }
            purPlanEntryInfo.setExchangeRate(new BigDecimal("1.00"));
            IRowType irowtype = RowTypeFactory.getRemoteInstance();
            RowTypeInfo rowType = irowtype.getRowTypeInfo((IObjectPK)new ObjectStringPK("00000000-0000-0000-0000-0000000000017C7DC4A3"));
            purPlanEntryInfo.setRowType(rowType);
            purPlanEntryInfo.setDestinationType(rowType.getDestinationType());
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return purPlanEntryInfo;
    }

    protected KDTable getDetailTable() {
        return this.kdtEntries;
    }

    protected KDTable getDetailTable2() {
        return this.kdtEntriesRequest;
    }

    protected KDTable getDetailTable3() {
        return this.kdtEntriesInv;
    }

    protected KDTable getDetailTable4() {
        return this.kdtEntriesSum;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return PurPlanFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
    }

    protected String getBillTypeId() {
        return "Htzs+wEkEADgAAMJwKg9YtAMSuo=";
    }

    protected KDBizPromptBox getMainBizOrg() {
        return this.prmtPurchaseOrgUnit;
    }

    public KDBizPromptBox getMainOrgUnit() {
        return this.prmtPurchaseOrgUnit;
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Purchase;
    }

    public OrgUnitInfo getMainOrgInfo() {
        return super.getMainOrgInfo();
    }

    protected String getPermissionItem(String status) {
        if (status.equals("ADDNEW")) {
            return "purplan_addnew";
        }
        return null;
    }

    protected String getOnloadPermItemName() {
        return null;
    }

    protected int getDefaultOrgMask() {
        return 18;
    }

    protected void checkIsOUSealUp() throws Exception {
        super.checkIsOUSealUp();
    }

    protected String[] getSumColNames() {
        return new String[]{TB_MATERIAL_QUANTITY, TB_BASEQTY, TB_MATERIAL_ASSISTQUANTIRTY, TB_MATERIAL_LOCALAMOUNT};
    }

    public KDTextField getNumTextField() {
        return this.txtNumber;
    }

    protected void initNeedMainOrgF7s() {
        super.registerRowType(this.prmtBizType, TB_ROWTYPE);
        this.setMainBizOrgF7(this.prmtPurchaseOrgUnit, OrgType.Purchase);
        this.setMainBizOrgF7(this.prmtPurchaseOrgUnitFilter, OrgType.Purchase);
        this.bizStorageOrgUnitBox = this.getBizOrgF7(OrgType.Storage, this.kdtEntries.getColumn(TB_MATERIAL_STOREORG));
        this.bizRecStorageOrgUnitBox = this.getBizOrgF7(OrgType.Storage, this.kdtEntries.getColumn(TB_MATERIAL_RECEIVEDORGUNIT));
        this.bizAdminOrgUnitBox = this.getBizOrgF7(OrgType.Admin, this.kdtEntries.getColumn(TB_MATERIAL_ADMINORGUNIT));
        this.bizAdminOrgUnitBox = this.getBizOrgF7(OrgType.Admin, this.kdtEntries.getColumn(TB_USEDADMINORGUNIT));
        this.bizCompanyOrgUnitBox = this.getBizOrgF7(OrgType.Company, this.kdtEntries.getColumn(TB_COMPANYORGUNIT));
        this.bizMaterialBox = this.getBizMaterialF7(this.kdtEntries.getColumn(TB_MATERIAL_NUMBER), null);
        this.bizSupplierBox = this.getBizSupplierF7(this.kdtEntries.getColumn(TB_MATERIAL_SUPPLIER), null);
        this.setNeedMainOrgF7s(new KDBizPromptBox[]{this.bizStorageOrgUnitBox, this.bizRecStorageOrgUnitBox, this.bizAdminOrgUnitBox, this.bizAdminOrgUnitBox, this.bizCompanyOrgUnitBox, this.bizMaterialBox, this.bizSupplierBox});
    }

    public boolean isSupportedBatchActions() {
        return true;
    }

    protected void initBatchActions() throws BOSException {
        this.actionManager.setClzIBizFactory(ActionLevelEnum.HEAD, PurPlanFactory.class);
        this.actionManager.setClzIBizFactory(ActionLevelEnum.ENTRY, PurPlanEntryFactory.class);
        this.getTableSelectionHelper().setTableProperty((ISupportBatchAction)this, this.getDetailTable(), "id", this.txtNumber, null);
        ActionProxy actionProxy = ActionProxyFactory.createActionProxy((BatchActionEnum)BatchActionEnum.CANCEL, (ItemAction)this.actionRevoke, (String)"revoke");
        this.actionManager.registerBatchAction(actionProxy, "actionRevoke");
        actionProxy.bindTo((AbstractButton)this.btnRevoke);
        actionProxy.bindTo((AbstractButton)this.menuItemRevoke);
        super.initBatchActions();
    }

    public boolean beforeAction(BatchActionEnum bizAction, BatchSelectionEntries selectionEntries, ActionEvent event) {
        boolean result = super.beforeAction(bizAction, selectionEntries, event);
        SCMBillBaseInfo scmInfo = (SCMBillBaseInfo)selectionEntries.getEditdata();
        if (bizAction.equals((Object)BatchActionEnum.SUBMIT)) {
            try {
                this.menuItemMultiapprove.setEnabled(true);
                this.btnMultiapprove.setEnabled(true);
            }
            catch (Exception e) {
                return false;
            }
            selectionEntries.setEditdata((IObjectValue)scmInfo);
        }
        return result;
    }

    protected void checkValidDataForSubmit() throws Exception {
        int nrow;
        if (this.txtNumber.isEditable() && StringUtils.isEmpty((String)this.txtNumber.getText())) {
            this.txtNumber.requestFocus();
            super.handleException((Exception)((Object)new PurPlanException(PurPlanException.FIELD_CANNOT_EMPTY, new String[]{PurUtil.getUIResource("BILL_FIELD_NUMBER")})));
            SysUtil.abort();
        }
        if (this.prmtPurchaseOrgUnit.getData() == null) {
            this.prmtPurchaseOrgUnit.requestFocus();
            super.handleException((Exception)((Object)new PurPlanException(PurPlanException.FIELD_CANNOT_EMPTY, new String[]{PurUtil.getUIResource("ORDER_FIELD_PURCHASEORGUNIT")})));
            SysUtil.abort();
        }
        if (this.pkBizDate.getValue() == null) {
            this.pkBizDate.requestFocus();
            super.handleException((Exception)((Object)new PurOrderException(PurOrderException.FIELD_CANNOT_EMPTY, new String[]{PurUtil.getUIResource("BILL_FIELD_ORDERDATE")})));
            SysUtil.abort();
        }
        if (this.prmtBizType.getData() == null) {
            this.prmtBizType.requestFocus();
            super.handleException((Exception)((Object)new PurOrderException(PurOrderException.FIELD_CANNOT_EMPTY, new String[]{PurUtil.getUIResource("ORDER_FIELD_BIZTYPE")})));
            SysUtil.abort();
        }
        if ((nrow = this.kdtEntries.getRowCount()) <= 0) {
            throw new PurPlanException(PurPlanException.ENTRY_CANNOT_EMPTY);
        }
        RowTypeInfo rowTypeInfo = null;
        for (int row = 0; row < nrow; ++row) {
            String rowStr;
            String noStr;
            IRow arow = this.kdtEntries.getRow(row);
            rowTypeInfo = (RowTypeInfo)arow.getCell(TB_ROWTYPE).getValue();
            if (rowTypeInfo == null) continue;
            if (this.getDetailTable().getRow(row).getCell(TB_MATERIAL_STOREORG).getStyleAttributes().getBackground().equals(SCMClientUtils.necessaryColor) && rowTypeInfo.getRequestOrgType() == RequestOrgTypeEnum.STORAGEORGUNIT && arow.getCell(TB_MATERIAL_STOREORG).getValue() == null) {
                noStr = PurUtil.getUIResource("NO");
                rowStr = PurUtil.getUIResource("ROW");
                MsgBox.showInfo((String)(noStr + (row + 1) + rowStr + this.getDetailTable().getHeadRow(0).getCell(TB_MATERIAL_STOREORG).getValue().toString() + SCMClientUtils.getResource((String)"EntryFieldCheck_NotSet")));
                SysUtil.abort();
            }
            if (!rowTypeInfo.isIsHasMaterialNumber() || !this.getDetailTable().getRow(row).getCell(TB_MATERIAL_STOREORG).getStyleAttributes().getBackground().equals(SCMClientUtils.necessaryColor) || arow.getCell(TB_MATERIAL_STOREORG).getValue() != null) continue;
            noStr = PurUtil.getUIResource("NO");
            rowStr = PurUtil.getUIResource("ROW");
            MsgBox.showInfo((String)(noStr + (row + 1) + rowStr + this.getDetailTable().getHeadRow(0).getCell(TB_MATERIAL_STOREORG).getValue().toString() + SCMClientUtils.getResource((String)"EntryFieldCheck_NotSet")));
            SysUtil.abort();
        }
    }

    public void calEntryBaseQty(int rowIndex, int colIndex) throws EASBizException, BOSException {
        BigDecimal baseUnitQty = SCMClientUtils.getBaseUnitQty((KDTable)this.kdtEntries, (int)rowIndex, (String)TB_MATERIAL_NUMBER, (String)TB_BASEUNIT, (String)TB_MATERIAL_UNIT, (String)TB_MATERIAL_QUANTITY);
        if (baseUnitQty != null) {
            int scale = this.kdtEntries.getRow(rowIndex).getCell(TB_BASEQTY).getEditor() == null ? 2 : ((KDFormattedTextField)this.kdtEntries.getRow(rowIndex).getCell(TB_BASEQTY).getEditor().getComponent()).getPrecision();
            baseUnitQty = baseUnitQty.setScale(scale, 4);
        }
        this.kdtEntries.getRow(rowIndex).getCell(TB_BASEQTY).setValue((Object)baseUnitQty);
    }

    public void calEntryAssistQty(int rowIndex, int colIndex) throws EASBizException, BOSException {
        BigDecimal assistUnitQty = SCMClientUtils.getBaseUnitQty((KDTable)this.kdtEntries, (int)rowIndex, (String)TB_MATERIAL_NUMBER, (String)TB_MATERIAL_ASSISTANTUNIT, (String)TB_MATERIAL_UNIT, (String)TB_MATERIAL_QUANTITY);
        if (assistUnitQty != null) {
            int scale = this.kdtEntries.getRow(rowIndex).getCell(TB_MATERIAL_ASSISTQUANTIRTY).getEditor() == null ? 2 : ((KDFormattedTextField)this.kdtEntries.getRow(rowIndex).getCell(TB_MATERIAL_ASSISTQUANTIRTY).getEditor().getComponent()).getPrecision();
            assistUnitQty = assistUnitQty.setScale(scale, 4);
        }
        this.kdtEntries.getRow(rowIndex).getCell(TB_MATERIAL_ASSISTQUANTIRTY).setValue((Object)assistUnitQty);
    }

    private class PurPlanKdtEditlistener
    extends KDTEditAdapter {
        private PurPlanKdtEditlistener() {
        }

        public void editStarting(KDTEditEvent e) {
            if (!PurPlanEditUI.this.isListenerEnable) {
                PurPlanEditUI.this.isListenerEnable = true;
                e.setCancel(true);
                return;
            }
            KDTable table = PurPlanEditUI.this.getDetailTable();
            int rowIndex = e.getRowIndex();
            int colIndex = e.getColIndex();
            String fieldName = table.getColumnKey(colIndex);
            IRow row = table.getRow(rowIndex);
            MaterialInfo materialInfo = (MaterialInfo)row.getCell(PurPlanEditUI.TB_MATERIAL_NUMBER).getValue();
            PurPlanEditUI.this.oldMaterialInfo = materialInfo;
            if (PurPlanEditUI.TB_MATERIAL_QUANTITY.equals(fieldName) && row.getCell(PurPlanEditUI.TB_MATERIAL_UNIT).getValue() == null) {
                e.setCancel(true);
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void editStopped(KDTEditEvent e) {
            if (!PurPlanEditUI.this.isListenerEnable) {
                return;
            }
            Object oldValue = e.getOldValue();
            Object newValue = e.getValue();
            PurPlanEditUI.this.isListenerEnable = false;
            try {
                KDTable table = PurPlanEditUI.this.getDetailTable();
                int rowIndex = e.getRowIndex();
                int colIndex = e.getColIndex();
                String fieldName = table.getColumnKey(colIndex);
                if (PurPlanEditUI.TB_MATERIAL_NUMBER.equals(fieldName)) {
                    oldValue = PurPlanEditUI.this.oldMaterialInfo;
                }
                if (PurPlanEditUI.this.isBigDeciamlEqual(newValue, oldValue) || PurPlanEditUI.this.isDateEqual(newValue, oldValue) || PurPlanEditUI.this.isCoreBaseEqual(newValue, oldValue)) {
                    return;
                }
                if (PurPlanEditUI.TB_MATERIAL_NUMBER.equals(fieldName)) {
                } else if (PurPlanEditUI.TB_MATERIAL_UNIT.equals(fieldName)) {
                } else if (PurPlanEditUI.TB_MATERIAL_QUANTITY.equals(fieldName)) {
                    try {
                        PurPlanEditUI.this.calEntryAssistQty(rowIndex, colIndex);
                        PurPlanEditUI.this.calEntryBaseQty(rowIndex, colIndex);
                    }
                    catch (Exception e1) {
                        PurPlanEditUI.this.handUIException(e1);
                    }
                } else if (PurPlanEditUI.TB_MATERIAL_CURRENCY.equalsIgnoreCase(fieldName)) {
                    if (newValue != null) {
                        CurrencyInfo currencyInfo = (CurrencyInfo)PurPlanEditUI.this.kdtEntries.getRow(rowIndex).getCell(PurPlanEditUI.TB_MATERIAL_CURRENCY).getValue();
                        CompanyOrgUnitInfo ficompanyOrgInfoForEntry = (CompanyOrgUnitInfo)PurPlanEditUI.this.kdtEntries.getRow(rowIndex).getCell(PurPlanEditUI.TB_COMPANYORGUNIT).getValue();
                        if (currencyInfo != null && ficompanyOrgInfoForEntry != null) {
                            try {
                                ICompanyOrgUnit iCompanyOrg = CompanyOrgUnitFactory.getRemoteInstance();
                                ficompanyOrgInfoForEntry = iCompanyOrg.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(ficompanyOrgInfoForEntry.getId()));
                                CurrencyInfo baseCurrencyInfo = ficompanyOrgInfoForEntry.getBaseCurrency();
                                PurPlanEditUI.this.CurrencyChanged(ficompanyOrgInfoForEntry, currencyInfo, baseCurrencyInfo, rowIndex);
                                int precision = PurPlanEditUI.this.getExchangeRateInfo(ficompanyOrgInfoForEntry, currencyInfo) != null ? PurPlanEditUI.this.getExchangeRateInfo(ficompanyOrgInfoForEntry, currencyInfo).getPrecision() : currencyInfo.getPrecision();
                                SCMClientUtils.changeTableColPrecision((int)precision, (KDTable)PurPlanEditUI.this.kdtEntries, (String[])new String[]{PurPlanEditUI.TB_MATERIAL_EXCHRATE, PurPlanEditUI.TB_MATERIAL_PRICE, PurPlanEditUI.TB_MATERIAL_AMOUNT, PurPlanEditUI.TB_MATERIAL_LOCALAMOUNT}, (int)rowIndex);
                                PurPlanEditUI.this.calEntryAmount(rowIndex, colIndex);
                                PurPlanEditUI.this.calEntryLocalAmount(rowIndex, colIndex, ficompanyOrgInfoForEntry);
                            }
                            catch (Exception e1) {
                                PurPlanEditUI.this.handleException(e1);
                            }
                        }
                    } else {
                        PurPlanEditUI.this.kdtEntries.getCell(rowIndex, PurPlanEditUI.TB_MATERIAL_EXCHRATE).getStyleAttributes().setLocked(true);
                    }
                }
            }
            finally {
                PurPlanEditUI.this.isListenerEnable = true;
            }
        }
    }

    private class PurPlanDataChangeListener
    implements DataChangeListener {
        private PurPlanDataChangeListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dataChanged(DataChangeEvent eventObj) {
            if (!PurPlanEditUI.this.isListenerEnable) {
                return;
            }
            PurPlanEditUI.this.isListenerEnable = false;
            try {
                Object srcObject = eventObj.getSource();
                Object oldValue = eventObj.getOldValue();
                Object newValue = eventObj.getNewValue();
                if (!(PurPlanEditUI.this.isCoreBaseEqual(oldValue, newValue) || PurPlanEditUI.this.isBigDeciamlEqual(oldValue, newValue) || PurPlanEditUI.this.isDateEqual(newValue, oldValue))) {
                    if (srcObject == PurPlanEditUI.this.prmtPurchaseOrgUnitFilter && newValue != null && newValue.getClass() == PurchaseOrgUnitInfo.class) {
                        PurPlanEditUI.this.purchaseOrgFilterChanged((PurchaseOrgUnitInfo)newValue);
                    }
                    if (srcObject == PurPlanEditUI.this.pkRequestDateFilter) {
                        PurPlanEditUI.this.pkRequestDateFilterChanged(eventObj);
                    }
                    if (srcObject == PurPlanEditUI.this.pkRequestDateToFilter) {
                        PurPlanEditUI.this.pkRequestDateToFilterChanged(eventObj);
                    }
                }
            }
            finally {
                PurPlanEditUI.this.isListenerEnable = true;
            }
        }
    }

    private class PurPlanItemListener
    implements ItemListener {
        private PurPlanItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (!PurPlanEditUI.this.isListenerEnable) {
                return;
            }
            PurPlanEditUI.this.isListenerEnable = false;
            try {
                Object srcObject = e.getSource();
                if (srcObject == PurPlanEditUI.this.kDChkAllSelect) {
                    PurPlanEditUI.this.kDChkAllSelectItemChanged(PurPlanEditUI.this.kDChkAllSelect.isSelected());
                }
                if (srcObject == PurPlanEditUI.this.kDChkDisplay) {
                    PurPlanEditUI.this.kDChkDisplayItemChanged(PurPlanEditUI.this.kDChkAllSelect.isSelected());
                }
                if (srcObject == PurPlanEditUI.this.comboPurchaseTypeFilter) {
                    PurPlanEditUI.this.comboPurchaseTypeFilterChanged(e);
                }
                if (srcObject == PurPlanEditUI.this.kDCheckInv) {
                    PurPlanEditUI.this.kDCheckInv_StateChanged(e);
                }
                if (srcObject == PurPlanEditUI.this.kDCheckWareHs) {
                    PurPlanEditUI.this.kDCheckWareHs_StateChanged(e);
                }
                if (srcObject == PurPlanEditUI.this.cbkSelect) {
                    PurPlanEditUI.this.cbkSelect_StateChanged(e);
                }
            }
            finally {
                PurPlanEditUI.this.isListenerEnable = true;
            }
        }
    }
}

