/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.pur.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectManager;
import com.kingdee.bos.ctrl.kdf.table.KDTView;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.BeforeActionEvent;
import com.kingdee.bos.ctrl.kdf.table.event.BeforeActionListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.master.material.AsstAttrValueInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.BizTypeInfo;
import com.kingdee.eas.basedata.scm.sm.srm.EditCtrlStrategyEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.common.PurchaseTypeEnum;
import com.kingdee.eas.scm.common.util.CalculateUtils;
import com.kingdee.eas.scm.sm.pur.CheckPriceResult;
import com.kingdee.eas.scm.sm.pur.PriceSourceEnum;
import com.kingdee.eas.scm.sm.pur.PurPriceInfo;
import com.kingdee.eas.scm.sm.pur.PurPriceInfoCollection;
import com.kingdee.eas.scm.sm.pur.PurPriceParam;
import com.kingdee.eas.scm.sm.pur.PurPriceParamCollection;
import com.kingdee.eas.scm.sm.pur.PurServiceFacadeFactory;
import com.kingdee.eas.scm.sm.pur.QueryPurPriceAssistor;
import com.kingdee.eas.scm.sm.pur.client.IExtendPoint4Client;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Point;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PurPriceCtrlStrategy {
    protected CoreUI parentUI = null;
    protected KDTable table = null;
    public String TB_MATERIAL = "material";
    public String TB_UNIT = "unit";
    public String TB_BASEUNIT = "baseUnit";
    public String TB_RECORGUNIT = "recOrgUnit";
    public String TB_DELIVERYDATE = "deliveryDate";
    public String TB_QTY = "qty";
    public String TB_TAXPRICE = "taxPrice";
    public String TB_PRICE = "price";
    public String TB_ACTUALTAXPRICE = "actualTaxPrice";
    public String TB_ACTUALPRICE = "actualPrice";
    public String TB_TAXRATE = "taxRate";
    public String TB_DISCOUNTRATE = "discountRate";
    public String TB_DISCOUNTAMOUNT = "discountAmount";
    public String TB_ASSISTPROPERTY = "assistProperty";
    public String TB_ISPRESENT = "isPresent";
    public String TB_TAXAMOUNT = "taxAmount";
    public String TB_AMOUNT = "amount";
    public String TB_SUPPLIER = "supplier";
    public String TB_PURORGUNIT = "purOrgUnit";
    public String TB_CURRENCY = "currency";
    public String TB_EDITCTRL = "editCtrl";
    public String TB_ISSUPPLIERTAXRATE = "isSupplierTaxRate";
    public String TB_TAX = "tax";
    protected boolean isMerge = false;
    protected String source = null;
    protected String billTypeId = null;
    protected boolean isAllowTaxAmountEdit = false;
    private PriceSourceEnum priceSource = null;
    protected PurchaseTypeEnum materialPurchaseType = PurchaseTypeEnum.PURCHASE;
    protected KDBizPromptBox prmtPurchaseOrgUnit = null;
    protected KDBizPromptBox prmtSupplier = null;
    protected KDBizPromptBox prmtCurrency = null;
    protected KDDatePicker pkBizDate = null;
    protected KDCheckBox chkIsInTax = null;
    protected KDCheckBox chkIsPriceInTax = null;
    protected KDBizPromptBox prmtBizType = null;
    protected BigDecimal zero = new BigDecimal("0.00");
    protected BigDecimal one = new BigDecimal("1.00");
    protected BigDecimal hundrud = new BigDecimal("100.00");
    protected Map<String, String> columns = new HashMap<String, String>();
    protected List<String> editCtrlFields = new ArrayList<String>();
    protected QueryPurPriceAssistor queryPurPriceAssistor = null;
    protected PurPriceParam paramInfo = null;
    protected IExtendPoint4Client extendPoint4Client = null;
    private String sourceBillTypeid = null;

    public PriceSourceEnum getPriceSource() {
        return this.priceSource;
    }

    public void setPriceSource(PriceSourceEnum priceSource) {
        this.priceSource = priceSource;
    }

    public String getSourceBillTypeid() {
        return this.sourceBillTypeid;
    }

    public void setSourceBillTypeid(String sourceBillTypeid) {
        this.sourceBillTypeid = sourceBillTypeid;
    }

    public PurPriceCtrlStrategy(KDTable table) {
        this.table = table;
        this.table.addAfterActionListener(new BeforeActionListener(){

            public void beforeAction(BeforeActionEvent e) {
                PurPriceCtrlStrategy.this.executeAction(e);
            }
        });
    }

    public void registerColumn(Map<String, String> columns) {
        this.columns = columns;
        this.TB_MATERIAL = this.columns.get("material");
        this.TB_UNIT = this.columns.get("unit");
        this.TB_BASEUNIT = this.columns.get("baseUnit");
        this.TB_RECORGUNIT = this.columns.get("recOrgUnit");
        this.TB_DELIVERYDATE = this.columns.get("deliveryDate");
        this.TB_QTY = this.columns.get("qty");
        this.TB_TAXPRICE = this.columns.get("taxPrice");
        this.TB_PRICE = this.columns.get("price");
        this.TB_ACTUALTAXPRICE = this.columns.get("actualTaxPrice");
        this.TB_ACTUALPRICE = this.columns.get("actualPrice");
        this.TB_TAXRATE = this.columns.get("taxRate");
        this.TB_DISCOUNTRATE = this.columns.get("discountRate");
        this.TB_DISCOUNTAMOUNT = this.columns.get("discountAmount");
        this.TB_ASSISTPROPERTY = this.columns.get("assistProperty");
        this.TB_ISPRESENT = this.columns.get("isPresent");
        this.TB_TAXAMOUNT = this.columns.get("taxAmount");
        this.TB_AMOUNT = this.columns.get("amount");
        this.TB_SUPPLIER = this.columns.get("supplier");
        this.TB_PURORGUNIT = this.columns.get("purOrgUnit");
        this.TB_CURRENCY = this.columns.get("currency");
        this.TB_EDITCTRL = this.columns.get("editCtrl");
        this.TB_ISSUPPLIERTAXRATE = this.columns.get("isSupplierTaxRate");
        this.TB_TAX = this.columns.get("tax");
        this.editCtrlFields.add(this.TB_TAXPRICE);
        this.editCtrlFields.add(this.TB_PRICE);
        this.editCtrlFields.add(this.TB_DISCOUNTRATE);
        this.editCtrlFields.add(this.TB_DISCOUNTAMOUNT);
        this.editCtrlFields.add(this.TB_TAXAMOUNT);
        this.editCtrlFields.add(this.TB_AMOUNT);
    }

    public QueryPurPriceAssistor getQueryPurPriceAssistor() {
        return this.queryPurPriceAssistor;
    }

    protected String getColumn(String key) {
        return this.columns.get(key);
    }

    protected void setColumn(String key, String columnName) {
        if (this.columns.get(key) == null) {
            this.columns.put(key, columnName);
        }
    }

    public PurPriceParam getPurPriceParam() {
        return this.paramInfo;
    }

    public void setPurPriceParam(PurPriceParam paramInfo) {
        this.paramInfo = paramInfo;
    }

    public CoreUI getParentUI() {
        return this.parentUI;
    }

    public void setParentUI(CoreUI parentUI) {
        this.parentUI = parentUI;
    }

    public boolean isAllowTaxAmountEdit() {
        return this.isAllowTaxAmountEdit;
    }

    public void setAllowTaxAmountEdit(boolean isAllowTaxAmountEdit) {
        this.isAllowTaxAmountEdit = isAllowTaxAmountEdit;
    }

    public String getBillTypeId() {
        return this.billTypeId;
    }

    public void setBillTypeId(String billTypeId) {
        this.billTypeId = billTypeId;
    }

    public PurchaseTypeEnum getMaterialPurchaseType() {
        return this.materialPurchaseType;
    }

    public void setMaterialPurchaseType(PurchaseTypeEnum materialPurchaseType) {
        this.materialPurchaseType = materialPurchaseType;
    }

    public KDBizPromptBox getPrmtPurchaseOrgUnit() {
        return this.prmtPurchaseOrgUnit;
    }

    public void setPrmtPurchaseOrgUnit(KDBizPromptBox prmtPurchaseOrgUnit) {
        this.prmtPurchaseOrgUnit = prmtPurchaseOrgUnit;
    }

    public KDBizPromptBox getPrmtSupplier() {
        return this.prmtSupplier;
    }

    public void setPrmtSupplier(KDBizPromptBox prmtSupplier) {
        this.prmtSupplier = prmtSupplier;
    }

    public KDBizPromptBox getPrmtCurrency() {
        return this.prmtCurrency;
    }

    public void setPrmtCurrency(KDBizPromptBox prmtCurrency) {
        this.prmtCurrency = prmtCurrency;
    }

    public KDDatePicker getPkBizDate() {
        return this.pkBizDate;
    }

    public void setPkBizDate(KDDatePicker pkBizDate) {
        this.pkBizDate = pkBizDate;
    }

    public KDCheckBox getChkIsInTax() {
        return this.chkIsInTax;
    }

    public void setChkIsInTax(KDCheckBox chkIsInTax) {
        this.chkIsInTax = chkIsInTax;
    }

    public KDCheckBox getChkIsPriceInTax() {
        return this.chkIsPriceInTax;
    }

    public void setChkIsPriceInTax(KDCheckBox chkIsPriceInTax) {
        this.chkIsPriceInTax = chkIsPriceInTax;
    }

    public KDBizPromptBox getPrmtBizType() {
        return this.prmtBizType;
    }

    public void setPrmtBizType(KDBizPromptBox prmtBizType) {
        this.prmtBizType = prmtBizType;
    }

    public void setExtendPoint4Client(IExtendPoint4Client extendPoint4Client) {
        this.extendPoint4Client = extendPoint4Client;
    }

    public void fetchPrice(boolean isMerge, String source) throws EASBizException, BOSException {
        boolean isPurOrderEdit = false;
        if (this.parentUI.getClass().getName().contains("com.kingdee.eas.scm.sm.pur.client.PurOrderEditUI") || this.parentUI.getClass().getName().contains("com.kingdee.eas.scm.sm.pur.client.PurContractEditUI")) {
            isPurOrderEdit = true;
        }
        if (PriceSourceEnum.PRICEFROMBOTP.equals((Object)this.getPriceSource()) && !"supplier".equals(source)) {
            return;
        }
        if (!this.beforeFetchPrice(isMerge, source, 0, 0) && !isPurOrderEdit) {
            return;
        }
        if (isPurOrderEdit && ("510b6503-0105-1000-e000-010bc0a814fd463ED552".equals(this.getSourceBillTypeid()) || "510b6503-0105-1000-e000-010bc0b814fd463ED552".equals(this.getSourceBillTypeid()))) {
            return;
        }
        PurPriceParamCollection paramCol = this.getParamCol(isMerge, source);
        PurPriceInfoCollection priceInfoCol = PurServiceFacadeFactory.getRemoteInstance().fetchPrice(paramCol);
        this.setPrice(0, this.table.getRowCount(), priceInfoCol);
    }

    public PurPriceInfoCollection fetchContractPrice(boolean isMerge, String source) throws EASBizException, BOSException {
        boolean isPurOrderEdit = false;
        if (PriceSourceEnum.PRICEFROMBOTP.equals((Object)this.getPriceSource()) && !"supplier".equals(source)) {
            return null;
        }
        if (isPurOrderEdit && ("510b6503-0105-1000-e000-010bc0a814fd463ED552".equals(this.getSourceBillTypeid()) || "510b6503-0105-1000-e000-010bc0b814fd463ED552".equals(this.getSourceBillTypeid()))) {
            return null;
        }
        PurPriceParamCollection paramCol = this.getParamCol(isMerge, source);
        PurPriceInfoCollection priceInfoCol = PurServiceFacadeFactory.getRemoteInstance().fetchPrice(paramCol);
        this.setPrice(0, this.table.getRowCount(), priceInfoCol);
        return priceInfoCol;
    }

    public void fetchPrice(int startRowIndex, int length, boolean isMerge, String source) throws EASBizException, BOSException {
        boolean isPurOrderEdit = false;
        if (this.parentUI.getClass().getName().contains("com.kingdee.eas.scm.sm.pur.client.PurOrderEditUI") || this.parentUI.getClass().getName().contains("com.kingdee.eas.scm.sm.pur.client.PurContractEditUI")) {
            isPurOrderEdit = true;
        }
        if (PriceSourceEnum.PRICEFROMBOTP.equals((Object)this.getPriceSource()) && !"supplier".equals(source)) {
            return;
        }
        if (!this.beforeFetchPrice(isMerge, source, startRowIndex, length) && !isPurOrderEdit) {
            return;
        }
        if (isPurOrderEdit && ("510b6503-0105-1000-e000-010bc0a814fd463ED552".equals(this.getSourceBillTypeid()) || "510b6503-0105-1000-e000-010bc0b814fd463ED552".equals(this.getSourceBillTypeid()))) {
            return;
        }
        PurPriceParamCollection paramCol = this.getParamCol(startRowIndex, length, isMerge, source);
        PurPriceInfoCollection priceInfoCol = PurServiceFacadeFactory.getRemoteInstance().fetchPrice(paramCol);
        this.setPrice(startRowIndex, length, priceInfoCol);
    }

    public void fetchPrice(int[] selectRows, boolean isMerge, String source) throws EASBizException, BOSException {
        if (selectRows == null || selectRows.length <= 0) {
            return;
        }
        PurPriceParamCollection paramCol = this.getParamCol(selectRows, isMerge, source);
        PurPriceInfoCollection priceInfoCol = PurServiceFacadeFactory.getRemoteInstance().fetchPrice(paramCol);
        this.setPrice(selectRows, priceInfoCol);
    }

    public void fetchPriceForCopy(boolean isMerge, String source) throws EASBizException, BOSException {
        boolean isPurOrderEdit = false;
        if (this.parentUI.getClass().getName().contains("com.kingdee.eas.scm.sm.pur.client.PurOrderEditUI") || this.parentUI.getClass().getName().contains("com.kingdee.eas.scm.sm.pur.client.PurContractEditUI")) {
            isPurOrderEdit = true;
        }
        if (PriceSourceEnum.PRICEFROMBOTP.equals((Object)this.getPriceSource()) && !"supplier".equals(source)) {
            return;
        }
        if (!this.beforeFetchPrice(isMerge, source, 0, 0) && !isPurOrderEdit) {
            return;
        }
        if (isPurOrderEdit && ("510b6503-0105-1000-e000-010bc0a814fd463ED552".equals(this.getSourceBillTypeid()) || "510b6503-0105-1000-e000-010bc0b814fd463ED552".equals(this.getSourceBillTypeid()))) {
            return;
        }
        PurPriceParamCollection paramCol = this.getParamCol(isMerge, source);
        PurPriceInfoCollection priceInfoCol = PurServiceFacadeFactory.getRemoteInstance().fetchPrice(paramCol);
        this.setPriceForCopy(0, this.table.getRowCount(), priceInfoCol);
    }

    public boolean beforeFetchPrice(boolean isMerge, String source, int startRowIndex, int length) {
        String oprtState = this.parentUI.getOprtState();
        if (("ALERT".equals(oprtState) || "ALTER".equals(oprtState)) && !isMerge) {
            if (source == null || "material".equals(source)) {
                return true;
            }
            return this.isAddLineFetchPrice(startRowIndex, length);
        }
        return true;
    }

    public boolean isAddLineFetchPrice(int startRowIndex, int length) {
        if (1 == length) {
            IRow row = this.table.getRow(startRowIndex);
            return null == row.getCell("id").getValue();
        }
        return false;
    }

    private boolean isGetPrice(int rowIndex, boolean isMerge) {
        String oprtState = this.parentUI.getOprtState();
        ICell cell = this.table.getRow(rowIndex).getCell("baseStatus");
        if (cell != null) {
            Object entryStatusO = cell.getValue();
            if (oprtState.equals("ALERT") && entryStatusO != null && (EntryBaseStatusEnum)entryStatusO != EntryBaseStatusEnum.ADD && !isMerge) {
                return false;
            }
        }
        return true;
    }

    public void checkPrice(int startRowIndex, int length) throws EASBizException, BOSException {
        PurPriceParamCollection paramCol = this.getParamCol4FetchStrategy(startRowIndex, length);
        CheckPriceResult checkResult = PurServiceFacadeFactory.getRemoteInstance().topPriceCtrl(paramCol);
        if (checkResult.hasErrorMsg()) {
            if (checkResult.getMessageType() == 2) {
                if (!MsgBox.isYes((int)MsgBox.showConfirm3a((Component)this.parentUI, (String)checkResult.getMessage(), (String)checkResult.getDetailMsg()))) {
                    SysUtil.abort();
                }
            } else {
                MsgBox.showDetailAndOK((Component)this.parentUI, (String)checkResult.getMessage(), (String)checkResult.getDetailMsg(), (int)0);
                SysUtil.abort();
            }
        }
    }

    public void editCtrl(int startRowIndex, int length) throws EASBizException, BOSException {
        PurPriceParamCollection paramCol = this.getParamCol4FetchStrategy(startRowIndex, length);
        PurPriceInfoCollection priceInfoCol = PurServiceFacadeFactory.getRemoteInstance().fetchCtrlStrategy(paramCol);
        for (int i = startRowIndex; i < startRowIndex + length; ++i) {
            IRow row = this.table.getRow(i);
            PurPriceInfo priceInfo = priceInfoCol.getPurPriceInfoBySeq(i + 1);
            if (priceInfo != null) {
                row.getCell(this.TB_EDITCTRL).setValue((Object)priceInfo.getEditCtrl());
            }
            if (priceInfo != null && row.getCell(this.TB_ISSUPPLIERTAXRATE) != null) {
                row.getCell(this.TB_ISSUPPLIERTAXRATE).setValue((Object)priceInfo.isSupplierTaxRate());
                this.setCtrlStatus(row, priceInfo.isSupplierTaxRate());
                continue;
            }
            if (priceInfo == null || row.getCell(this.TB_ISSUPPLIERTAXRATE) != null) continue;
            this.setCtrlStatus(row, priceInfo.isSupplierTaxRate());
        }
    }

    public PurPriceParamCollection getParamCol(boolean isMerge, String source) {
        return this.getParamCol(0, this.table.getRowCount(), isMerge, source);
    }

    public PurPriceParamCollection getParamCol(int startRowIndex, int length, boolean isMerge, String source) {
        PurPriceParamCollection paramCol = new PurPriceParamCollection();
        paramCol.setBillTypeId(this.billTypeId);
        paramCol.setMerge(isMerge);
        paramCol.setSource(source);
        paramCol.setBizTypeId(this.getBizTypeId());
        boolean isPurOrderEdit = this.parentUI.getClass().getName().contains("com.kingdee.eas.scm.sm.pur.client.PurOrderEditUI");
        for (int i = startRowIndex; i < startRowIndex + length; ++i) {
            PurPriceParam param;
            if (isPurOrderEdit) {
                if (!this.isHasParam(i) || !this.isGetPrice(i, isMerge)) continue;
                param = this.getParamInfo(i);
                paramCol.addPurPriceParam(param);
                continue;
            }
            if (!this.isHasParam(i)) continue;
            param = this.getParamInfo(i);
            paramCol.addPurPriceParam(param);
        }
        return paramCol;
    }

    public PurPriceParamCollection getParamCol(int[] selectRows, boolean isMerge, String source) {
        PurPriceParamCollection paramCol = new PurPriceParamCollection();
        paramCol.setBillTypeId(this.billTypeId);
        paramCol.setMerge(isMerge);
        paramCol.setSource(source);
        paramCol.setBizTypeId(this.getBizTypeId());
        for (int i = 0; i < selectRows.length; ++i) {
            if (!this.isHasParam(selectRows[i])) continue;
            PurPriceParam param = this.getParamInfo(selectRows[i]);
            paramCol.addPurPriceParam(param);
        }
        return paramCol;
    }

    protected String getBizTypeId() {
        String bizTypeId = null;
        if (this.prmtBizType != null) {
            BizTypeInfo bizTypeInfo = (BizTypeInfo)this.prmtBizType.getValue();
            if (bizTypeInfo != null) {
                bizTypeId = bizTypeInfo.getId().toString();
            }
        } else {
            bizTypeId = "d8e80652-0106-1000-e000-04c5c0a812202407435C";
        }
        return bizTypeId;
    }

    public PurPriceParamCollection getParamCol4FetchStrategy(int startRowIndex, int length) {
        PurPriceParamCollection paramCol = new PurPriceParamCollection();
        paramCol.setBillTypeId(this.billTypeId);
        paramCol.setBizTypeId(this.getBizTypeId());
        for (int i = startRowIndex; i < startRowIndex + length; ++i) {
            if (!this.isHasParam(i)) continue;
            PurPriceParam param = this.getParam4FetchStrategy(i);
            paramCol.addPurPriceParam(param);
        }
        return paramCol;
    }

    protected boolean isHasParam(int rowIndex) {
        Boolean isPresent;
        IRow row = this.table.getRow(rowIndex);
        if (row.getCell(this.TB_MATERIAL).getValue() == null) {
            return false;
        }
        return this.TB_ISPRESENT == null || (isPresent = (Boolean)row.getCell(this.TB_ISPRESENT).getValue()) == false;
    }

    public PurPriceParam getParamInfo(int rowIndex) {
        Date extDate;
        PurPriceParam param = new PurPriceParam();
        IRow row = this.table.getRow(rowIndex);
        param.setMaterialPurchaseType(this.materialPurchaseType.getValue());
        param.setBillTypeId(this.billTypeId);
        param.setSeq(rowIndex);
        if (this.chkIsInTax != null && this.chkIsInTax.isSelected()) {
            param.setInTax(true);
        }
        OrgUnitInfo purchaseOrgUnit = null;
        SupplierInfo supplier = null;
        CurrencyInfo currency = null;
        if ("510b6503-0105-1000-e000-0107c0a812fd463ED552".equals(this.billTypeId)) {
            purchaseOrgUnit = (OrgUnitInfo)row.getCell(this.TB_PURORGUNIT).getValue();
            supplier = (SupplierInfo)row.getCell(this.TB_SUPPLIER).getValue();
            currency = (CurrencyInfo)row.getCell(this.TB_CURRENCY).getValue();
        } else if ("510b6503-0105-1000-e000-010bc0b814fd463ED552".equals(this.billTypeId)) {
            purchaseOrgUnit = (OrgUnitInfo)this.prmtPurchaseOrgUnit.getValue();
            supplier = (SupplierInfo)row.getCell(this.TB_SUPPLIER).getValue();
            currency = (CurrencyInfo)row.getCell(this.TB_CURRENCY).getValue();
        } else {
            purchaseOrgUnit = (OrgUnitInfo)this.prmtPurchaseOrgUnit.getValue();
            supplier = (SupplierInfo)this.prmtSupplier.getValue();
            currency = (CurrencyInfo)this.prmtCurrency.getValue();
        }
        param.setPurOrgUnitId(purchaseOrgUnit != null ? purchaseOrgUnit.getId().toString() : null);
        param.setSupplierId(supplier != null ? supplier.getId().toString() : null);
        param.setCurrencyId(currency != null ? currency.getId().toString() : null);
        param.setBizDate((Date)this.pkBizDate.getValue());
        MaterialInfo material = null;
        Object obj = row.getCell(this.TB_MATERIAL).getValue();
        material = obj != null && obj instanceof Object[] ? (MaterialInfo)((Object[])obj)[0] : (MaterialInfo)obj;
        param.setMaterialId(material != null ? material.getId().toString() : null);
        MeasureUnitInfo unit = (MeasureUnitInfo)row.getCell(this.TB_UNIT).getValue();
        param.setUnitId(unit != null ? unit.getId().toString() : null);
        MeasureUnitInfo baseUnit = (MeasureUnitInfo)row.getCell(this.TB_BASEUNIT).getValue();
        param.setBaseUnitId(baseUnit != null ? baseUnit.getId().toString() : null);
        if (row.getCell(this.TB_RECORGUNIT) != null) {
            OrgUnitInfo recOrgUnit = (OrgUnitInfo)row.getCell(this.TB_RECORGUNIT).getValue();
            param.setRecOrgUnitId(recOrgUnit != null ? recOrgUnit.getId().toString() : null);
        }
        param.setDeliveryDate((Date)row.getCell(this.TB_DELIVERYDATE).getValue());
        BigDecimal qty = (BigDecimal)row.getCell(this.TB_QTY).getValue();
        param.setQty(qty);
        AsstAttrValueInfo assistProperty = (AsstAttrValueInfo)row.getCell(this.TB_ASSISTPROPERTY).getValue();
        param.setAssistPropertyId(assistProperty != null ? assistProperty.getId().toString() : null);
        param.setBizTypeId(this.getBizTypeId());
        String oprtState = this.parentUI.getOprtState();
        if (this.extendPoint4Client != null && ("ALERT".equals(oprtState) || "ALTER".equals(oprtState)) && (extDate = this.extendPoint4Client.getDateOnBillChange(this.parentUI)) != null) {
            param.setBizDate(extDate);
            param.setDeliveryDate(extDate);
        }
        return param;
    }

    public PurPriceParam getParam4FetchStrategy(int rowIndex) {
        PurPriceParam param = new PurPriceParam();
        IRow row = this.table.getRow(rowIndex);
        param.setMaterialPurchaseType(this.materialPurchaseType.getValue());
        param.setBillTypeId(this.billTypeId);
        param.setSeq(rowIndex + 1);
        OrgUnitInfo purchaseOrgUnit = null;
        CurrencyInfo currency = null;
        if ("510b6503-0105-1000-e000-0107c0a812fd463ED552".equals(this.billTypeId)) {
            purchaseOrgUnit = (OrgUnitInfo)row.getCell(this.TB_PURORGUNIT).getValue();
            currency = (CurrencyInfo)row.getCell(this.TB_CURRENCY).getValue();
        } else {
            purchaseOrgUnit = (OrgUnitInfo)this.prmtPurchaseOrgUnit.getValue();
            currency = (CurrencyInfo)this.prmtCurrency.getValue();
        }
        param.setPurOrgUnitId(purchaseOrgUnit != null ? purchaseOrgUnit.getId().toString() : null);
        param.setCurrencyId(currency != null ? currency.getId().toString() : null);
        MaterialInfo material = null;
        Object obj = row.getCell(this.TB_MATERIAL).getValue();
        material = obj != null && obj instanceof Object[] ? (MaterialInfo)((Object[])obj)[0] : (MaterialInfo)obj;
        param.setMaterialId(material != null ? material.getId().toString() : null);
        MeasureUnitInfo unit = (MeasureUnitInfo)row.getCell(this.TB_UNIT).getValue();
        param.setUnitId(unit != null ? unit.getId().toString() : null);
        BigDecimal actualPrice = (BigDecimal)row.getCell(this.TB_ACTUALPRICE).getValue();
        param.setActualPrice(actualPrice);
        BigDecimal actualTaxPrice = (BigDecimal)row.getCell(this.TB_ACTUALTAXPRICE).getValue();
        param.setActualTaxPrice(actualTaxPrice);
        param.setBizTypeId(this.getBizTypeId());
        return param;
    }

    protected void setPrice(int startRowIndex, int length, PurPriceInfoCollection priceInfoCol) {
        for (int i = startRowIndex; i < startRowIndex + length; ++i) {
            this.setPrice(priceInfoCol, i);
        }
    }

    protected void setPrice(int[] selectRows, PurPriceInfoCollection priceInfoCol) {
        for (int i = 0; i < selectRows.length; ++i) {
            this.setPrice(priceInfoCol, selectRows[i]);
        }
    }

    protected void setPriceForCopy(int startRowIndex, int length, PurPriceInfoCollection priceInfoCol) {
        for (int i = startRowIndex; i < startRowIndex + length; ++i) {
            IRow row = this.table.getRow(i);
            BigDecimal taxPrice = (BigDecimal)row.getCell(this.TB_PRICE).getValue();
            if (null != taxPrice && taxPrice.compareTo(BigDecimal.ZERO) != 0) continue;
            this.setPrice(priceInfoCol, i);
        }
    }

    protected void setPrice(PurPriceInfoCollection priceInfoCol, int rowIndex) {
        IRow row = this.table.getRow(rowIndex);
        PurPriceInfo priceInfo = priceInfoCol.getPurPriceInfoBySeq(rowIndex);
        row.getCell(this.TB_PRICE).setUserObject(null);
        if (priceInfo == null) {
            return;
        }
        if (priceInfo != null && row.getCell(this.TB_EDITCTRL) != null) {
            row.getCell(this.TB_EDITCTRL).setValue((Object)priceInfo.getEditCtrl());
            if (row.getCell(this.TB_ISSUPPLIERTAXRATE) != null) {
                row.getCell(this.TB_ISSUPPLIERTAXRATE).setValue((Object)priceInfo.isSupplierTaxRate());
            }
            this.setCtrlStatusByIsInTax(row);
            this.setCtrlStatus(row, priceInfo.isSupplierTaxRate());
        }
        if ("510b6503-0105-1000-e000-0107c0a812fd463ED552".equals(this.billTypeId) && row.getCell(this.TB_SUPPLIER).getValue() == null) {
            row.getCell(this.TB_SUPPLIER).setValue((Object)priceInfo.getSupplier());
            if (priceInfo.getTaxRate() != null && !priceInfo.isHasPriceProvider()) {
                row.getCell(this.TB_TAXRATE).setValue((Object)priceInfo.getTaxRate().setScale(2));
            }
        }
        if (priceInfo.getPrice() == null) {
            if ("currency".equals(priceInfo.getSource()) || "unit".equals(priceInfo.getSource()) || "bizDate".equals(priceInfo.getSource()) || !priceInfo.isHasPriceProvider()) {
                return;
            }
            if (priceInfo.getTaxRate() != null && priceInfo.isHasPriceProvider()) {
                row.getCell(this.TB_TAXRATE).setValue((Object)priceInfo.getTaxRate().setScale(2));
            }
            priceInfo.setPrice(this.zero.setScale(priceInfo.getPricePrecision(), 4));
        } else if (priceInfo.getTaxRate() != null && priceInfo.isHasPriceProvider()) {
            row.getCell(this.TB_TAXRATE).setValue((Object)priceInfo.getTaxRate().setScale(2));
        }
        if (this.sourceBillTypeid != null || priceInfo.getPrice() != null && priceInfo.getPrice().compareTo(BigDecimal.ZERO) != 0) {
            if (priceInfo.isInTaxPrice()) {
                row.getCell(this.TB_TAXPRICE).setValue((Object)this.preProcessPrice(priceInfo));
                if (row.getCell(this.TB_TAXPRICE).getEditor() != null) {
                    row.getCell(this.TB_TAXPRICE).getEditor().setValue(row.getCell(this.TB_TAXPRICE).getValue());
                }
                this.calEntryPriceByTaxPrice(row, priceInfo);
            } else {
                row.getCell(this.TB_PRICE).setValue((Object)this.preProcessPrice(priceInfo));
                if (row.getCell(this.TB_PRICE).getEditor() != null) {
                    row.getCell(this.TB_PRICE).getEditor().setValue(row.getCell(this.TB_PRICE).getValue());
                }
                this.calEntryTaxPricebyPrice(row, priceInfo);
            }
        }
        if (this.TB_DISCOUNTRATE != null) {
            row.getCell(this.TB_DISCOUNTRATE).setValue((Object)priceInfo.getDiscountRate());
        }
        row.getCell(this.TB_PRICE).setUserObject((Object)priceInfo);
        row.getCell(this.TB_TAXPRICE).setUserObject((Object)priceInfo);
    }

    private BigDecimal preProcessPrice(PurPriceInfo priceInfo) {
        BigDecimal discountRate;
        BigDecimal price = priceInfo.getPrice();
        if ("50957179-0105-1000-e006-6152c0a812fd463ED552".equals(this.billTypeId) && (discountRate = priceInfo.getDiscountRate()).compareTo(this.zero) > 0) {
            discountRate = discountRate.divide(this.hundrud, discountRate.scale() + 2, 4);
            price = priceInfo.getPrice().multiply(this.one.subtract(discountRate));
            price = price.setScale(priceInfo.getPricePrecision(), 4);
        }
        return price;
    }

    public void calEntryPriceByTaxPrice(IRow row, PurPriceInfo priceInfo) {
        int precision = priceInfo.getPricePrecision();
        BigDecimal taxPrice = (BigDecimal)row.getCell(this.TB_TAXPRICE).getValue();
        BigDecimal taxRate = this.zero;
        BigDecimal price = this.zero;
        BigDecimal kdtTaxRate = (BigDecimal)row.getCell(this.TB_TAXRATE).getValue();
        taxRate = kdtTaxRate != null ? kdtTaxRate : taxRate;
        price = CalculateUtils.calPrice((BigDecimal)taxPrice, (BigDecimal)taxRate, (int)precision);
        if (this.chkIsPriceInTax != null && !this.chkIsPriceInTax.isSelected()) {
            price = CalculateUtils.calPriceIsPriceInTax((BigDecimal)taxRate, (BigDecimal)taxPrice, (int)precision);
        }
        row.getCell(this.TB_PRICE).setValue((Object)price);
    }

    public void calEntryTaxPricebyPrice(IRow row, PurPriceInfo priceInfo) {
        BigDecimal taxRate = (BigDecimal)row.getCell(this.TB_TAXRATE).getValue();
        BigDecimal price = (BigDecimal)row.getCell(this.TB_PRICE).getValue();
        if (taxRate == null) {
            taxRate = this.zero;
        }
        BigDecimal taxPrice = CalculateUtils.calTaxPrice((BigDecimal)price, (BigDecimal)taxRate, (int)priceInfo.getPricePrecision());
        if (this.chkIsPriceInTax != null && !this.chkIsPriceInTax.isSelected()) {
            taxPrice = this.calTaxPriceIsPriceInTax(price, taxRate, priceInfo.getPricePrecision());
        }
        row.getCell(this.TB_TAXPRICE).setValue((Object)taxPrice);
    }

    public BigDecimal calTaxPriceIsPriceInTax(BigDecimal price, BigDecimal taxRate, int scale) {
        if (price == null) {
            return null;
        }
        taxRate = taxRate == null ? this.zero : taxRate;
        BigDecimal taxPrice = this.zero;
        BigDecimal one = new BigDecimal("1.0");
        BigDecimal oneHundred = new BigDecimal("100.0");
        taxRate = taxRate.divide(oneHundred, this.getScale(taxRate), 4);
        taxPrice = price.divide(one.subtract(taxRate), scale, 4);
        return taxPrice;
    }

    private int getScale(BigDecimal num) {
        return num.scale() + 2;
    }

    public void setCtrlStatusByIsInTax(IRow row) {
        if (this.chkIsInTax != null && this.chkIsInTax.isSelected()) {
            this.setLockStatus(row, new String[]{this.TB_ACTUALPRICE, this.TB_ACTUALTAXPRICE}, true);
            if (this.isAllowTaxAmountEdit) {
                this.setLockStatus(row, new String[]{this.TB_TAXAMOUNT}, false);
            } else {
                this.setLockStatus(row, new String[]{this.TB_TAXAMOUNT}, true);
            }
            if ("510b6503-0105-1000-e000-0107c0a812fd463ED552".equals(this.billTypeId)) {
                this.setLockStatus(row, new String[]{this.TB_TAXRATE, this.TB_TAXPRICE, this.TB_DISCOUNTRATE, this.TB_TAX}, false);
            } else {
                this.setLockStatus(row, new String[]{this.TB_TAXRATE, this.TB_TAXPRICE, this.TB_DISCOUNTRATE}, false);
            }
        } else {
            this.setLockStatus(row, new String[]{this.TB_ACTUALPRICE, this.TB_ACTUALTAXPRICE}, true);
            if ("510b6503-0105-1000-e000-0107c0a812fd463ED552".equals(this.billTypeId)) {
                this.setLockStatus(row, new String[]{this.TB_PRICE, this.TB_TAXRATE, this.TB_DISCOUNTRATE, this.TB_AMOUNT, this.TB_TAX}, false);
            } else {
                this.setLockStatus(row, new String[]{this.TB_PRICE, this.TB_TAXRATE, this.TB_DISCOUNTRATE, this.TB_AMOUNT}, false);
            }
        }
    }

    public void setCtrlStatus(IRow row) {
        boolean isSupplierTaxRate = false;
        if (row.getCell(this.TB_ISSUPPLIERTAXRATE) != null && row.getCell(this.TB_ISSUPPLIERTAXRATE).getValue() != null) {
            isSupplierTaxRate = Boolean.parseBoolean(row.getCell(this.TB_ISSUPPLIERTAXRATE).getValue().toString());
        }
        this.setCtrlStatus(row, isSupplierTaxRate);
    }

    public void setCtrlStatus(IRow row, boolean isSupplierTaxRate) {
        if (row.getCell(this.TB_EDITCTRL) == null) {
            return;
        }
        EditCtrlStrategyEnum editCtrl = (EditCtrlStrategyEnum)row.getCell(this.TB_EDITCTRL).getValue();
        boolean isLock = EditCtrlStrategyEnum.EDIT_FORBIDDEN.equals((Object)editCtrl);
        if (isLock) {
            for (int i = 0; i < this.editCtrlFields.size(); ++i) {
                ICell cell = row.getCell(this.editCtrlFields.get(i));
                if (cell == null) continue;
                cell.getStyleAttributes().setLocked(isLock);
            }
        }
    }

    public void setLockStatus(IRow row, String[] fieldNames, boolean isLock) {
        for (int i = 0; i < fieldNames.length; ++i) {
            ICell cell = row.getCell(fieldNames[i]);
            if (cell == null) continue;
            cell.getStyleAttributes().setLocked(isLock);
        }
    }

    public ICell getPriceCell4QueryPrice(int rowIndex) {
        ICell cell;
        ICell priceCell = null;
        String priceColName = null;
        if (this.table.isEditable() && (cell = this.table.getCell(rowIndex, priceColName = this.chkIsInTax != null && this.chkIsInTax.isSelected() ? this.TB_TAXPRICE : this.TB_PRICE)) != null && !cell.getStyleAttributes().isLocked()) {
            priceCell = cell;
        }
        return priceCell;
    }

    protected void executeAction(BeforeActionEvent e) {
        if (1 == e.getType() && this.queryPurPriceAssistor != null) {
            this.queryPurPriceAssistor.showPop(false);
        }
    }

    public PurPriceInfoCollection getPurPriceInfoCollection(int selectRow, PurPriceParamCollection paramCol) throws EASBizException, BOSException {
        PurPriceParam param = null;
        if (this.billTypeId.equals("aErYRJ8ShO3gQKjACw4w8MtHWDQ=")) {
            param = this.getPurPriceParam();
            paramCol.addPurPriceParam(param);
        } else if (this.isHasParam(selectRow)) {
            param = this.getParamInfo(selectRow);
            paramCol.addPurPriceParam(param);
        }
        if (paramCol.size() == 0) {
            SysUtil.abort();
        }
        PurPriceInfoCollection priceInfoCol = PurServiceFacadeFactory.getRemoteInstance().queryPurPrice(paramCol);
        return priceInfoCol;
    }

    public void queyrPurPriceBySmallPanel(KDTEditEvent e, KDTable kdtEntries, CoreUI parentUI) throws Exception {
        int colIndex = e.getColIndex();
        int rowIndex = e.getRowIndex();
        ICell cell = kdtEntries.getRow(rowIndex).getCell(colIndex);
        String colKey = kdtEntries.getColumnKey(colIndex);
        MaterialInfo materialInfo = (MaterialInfo)kdtEntries.getRow(rowIndex).getCell(this.TB_MATERIAL).getValue();
        if (materialInfo == null) {
            return;
        }
        if ((colKey.equalsIgnoreCase(this.TB_PRICE) || colKey.equalsIgnoreCase(this.TB_TAXPRICE)) && e.getType() == 1 && !cell.getStyleAttributes().isLocked()) {
            String userInfoID = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
            boolean isHasFunction = false;
            if (this.prmtPurchaseOrgUnit != null && this.prmtPurchaseOrgUnit.getValue() != null) {
                isHasFunction = PermissionFactory.getRemoteInstance().hasFunctionPermission((IObjectPK)new ObjectUuidPK(userInfoID), (IObjectPK)new ObjectUuidPK(((PurchaseOrgUnitInfo)this.prmtPurchaseOrgUnit.getValue()).getId().toString()), "purPriceQuery_view");
            } else {
                PurchaseOrgUnitInfo purInfo = (PurchaseOrgUnitInfo)kdtEntries.getRow(rowIndex).getCell(this.TB_PURORGUNIT).getValue();
                isHasFunction = PermissionFactory.getRemoteInstance().hasFunctionPermission((IObjectPK)new ObjectUuidPK(userInfoID), (IObjectPK)new ObjectUuidPK(purInfo.getId().toString()), "purPriceQuery_view");
            }
            if (!isHasFunction) {
                return;
            }
            if (this.queryPurPriceAssistor == null) {
                this.queryPurPriceAssistor = new QueryPurPriceAssistor(cell, parentUI, this, kdtEntries, rowIndex);
            }
            if (this.TB_TAXPRICE != null) {
                this.queryPurPriceAssistor.setIsTaxPrice(colKey.equalsIgnoreCase(this.TB_TAXPRICE));
            }
            Point tablePoint = kdtEntries.getLocationOnScreen();
            Point point = this.getCellPosition(kdtEntries);
            if (point == null) {
                return;
            }
            int pixX = (int)point.getX() + (int)tablePoint.getX();
            int pixY = (int)point.getY() + (int)tablePoint.getY();
            KDTView view = (KDTView)this.table.getViewManager().getView(1, this.table.getHorizonCount() - 1);
            if (view.getRightCol() > colIndex) {
                int with = 0;
                for (int i = colIndex + 1; i <= view.getRightCol(); ++i) {
                    IColumn column = this.table.getColumn(i);
                    if (column.getStyleAttributes().isHided()) continue;
                    int colWith = column.getWidth();
                    if (colWith == -1) {
                        colWith = this.table.getDefaultColumnWidth();
                    }
                    with += colWith;
                }
                with = with + pixX + this.table.getColumn(colIndex).getWidth() / 2;
                this.queryPurPriceAssistor.setRightX(with);
            } else {
                this.queryPurPriceAssistor.setRightX(pixX + this.table.getColumn(colIndex).getWidth() / 2);
            }
            this.queryPurPriceAssistor.setLeftX((int)tablePoint.getX());
            this.queryPurPriceAssistor.setPixX(pixX);
            this.queryPurPriceAssistor.setPixY(pixY);
            this.queryPurPriceAssistor.setCurrentCell(cell);
            this.queryPurPriceAssistor.setTable(kdtEntries);
            this.queryPurPriceAssistor.setSelectRow(rowIndex);
            if (this.prmtPurchaseOrgUnit != null) {
                this.queryPurPriceAssistor.setPurOrgUnitInfo((PurchaseOrgUnitInfo)this.prmtPurchaseOrgUnit.getValue());
            } else {
                PurchaseOrgUnitInfo purOrgInfo = (PurchaseOrgUnitInfo)kdtEntries.getRow(rowIndex).getCell(this.TB_PURORGUNIT).getValue();
                this.queryPurPriceAssistor.setPurOrgUnitInfo(purOrgInfo);
            }
            System.out.println("\u83b7\u5f97\u7126\u70b9");
            this.queryPurPriceAssistor.getPurprice();
        } else if (this.queryPurPriceAssistor != null) {
            this.queryPurPriceAssistor.showPop(false);
        }
    }

    public Point getCellPosition(KDTable table) {
        KDTView view = (KDTView)table.getViewManager().getView(1, table.getHorizonCount() - 1);
        KDTSelectManager selectManager = table.getSelectManager();
        KDTSelectBlock block = selectManager.get(0);
        int top = block.getTop();
        int left = block.getLeft();
        int bottom = block.getBottom();
        int right = block.getRight();
        int bottomRow = view.getBottomRow();
        int rightCol = view.getRightCol();
        int topRow = view.getTopRow();
        int leftCol = view.getLeftCol();
        if (top > bottomRow || left > rightCol || bottom < topRow || right < leftCol) {
            return null;
        }
        top = top < topRow ? topRow : top;
        left = left < leftCol ? leftCol : left;
        bottom = bottom > bottomRow ? bottomRow : bottom;
        right = right > rightCol ? rightCol : right;
        int x = this.getWidth(table, leftCol, left - 1);
        int w = this.getWidth(table, left, right) - 1;
        int y = this.getHeight(table, topRow, top - 1);
        int h = this.getHeight(table, top, bottom) - 1;
        x += w / 2;
        y += table.getHead().getHeight();
        boolean freezed = table.getViewManager().isFreeze();
        if (freezed) {
            int freezeCol = table.getViewManager().getFreezeCol();
            x += this.getWidth(table, 0, freezeCol - 1);
        }
        return new Point(x, y);
    }

    public int getWidth(KDTable table, int left, int right) {
        if (left < 0) {
            left = 0;
        }
        if (right >= table.getColumnCount()) {
            right = table.getColumnCount() - 1;
        }
        int width = 0;
        for (int i = left; i <= right; ++i) {
            IColumn column = table.getColumn(i);
            if (column.getStyleAttributes().isHided()) continue;
            int colWith = column.getWidth();
            if (colWith == -1) {
                colWith = table.getDefaultColumnWidth();
            }
            width += colWith;
        }
        return width;
    }

    private int getHeight(KDTable table, int top, int bottom) {
        int height = 0;
        for (int i = top; i <= bottom; ++i) {
            height += table.getRow(i).getHeight();
        }
        return height;
    }

    public BigDecimal calEntryPriceByTaxPrice(BigDecimal taxPrice, BigDecimal taxRate, PurPriceInfo priceInfo) {
        int precision = priceInfo.getPricePrecision();
        BigDecimal price = this.zero;
        taxRate = taxRate != null ? taxRate : this.zero;
        price = CalculateUtils.calPrice((BigDecimal)taxPrice, (BigDecimal)taxRate, (int)precision);
        if (this.getChkIsPriceInTax() != null && !this.getChkIsPriceInTax().isSelected()) {
            price = CalculateUtils.calPriceIsPriceInTax((BigDecimal)taxRate, (BigDecimal)taxPrice, (int)precision);
        }
        return price;
    }

    public BigDecimal calEntryTaxPricebyPrice(BigDecimal price, BigDecimal taxRate, PurPriceInfo priceInfo) {
        if (taxRate == null) {
            taxRate = this.zero;
        }
        BigDecimal taxPrice = CalculateUtils.calTaxPrice((BigDecimal)price, (BigDecimal)taxRate, (int)priceInfo.getPricePrecision());
        if (this.getChkIsPriceInTax() != null && !this.getChkIsPriceInTax().isSelected()) {
            taxPrice = this.calTaxPriceIsPriceInTax(price, taxRate, priceInfo.getPricePrecision());
        }
        return taxPrice;
    }
}

