/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.pur.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.event.CommitEvent;
import com.kingdee.bos.ctrl.swing.event.CommitListener;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.IMultiMeasureUnit;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialPurchasingFactory;
import com.kingdee.eas.basedata.master.material.MaterialPurchasingInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.DelegationPartsEnum;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.OrgUnitDelegationF7;
import com.kingdee.eas.basedata.scm.common.DestinationTypeEnum;
import com.kingdee.eas.basedata.scm.common.RowTypeInfo;
import com.kingdee.eas.basedata.scm.sm.sc.MaterialPurchaseTypeEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.ICoreBillEntryBase;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.common.client.UIHelper;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.PurchaseTypeEnum;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.constants.QueryInfoConstants;
import com.kingdee.eas.scm.common.loadmass.PurEntryDataVO;
import com.kingdee.eas.scm.common.loadmass.SCMEntryDataVO;
import com.kingdee.eas.scm.common.util.PrecisionUtil;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.sm.pur.IPurRequest;
import com.kingdee.eas.scm.sm.pur.IPurRequestBatchEditFacade;
import com.kingdee.eas.scm.sm.pur.IPurRequestEntry;
import com.kingdee.eas.scm.sm.pur.PurOrderBatchEditFacadeFactory;
import com.kingdee.eas.scm.sm.pur.PurPriceInfo;
import com.kingdee.eas.scm.sm.pur.PurPriceInfoCollection;
import com.kingdee.eas.scm.sm.pur.PurPriceParam;
import com.kingdee.eas.scm.sm.pur.PurPriceParamCollection;
import com.kingdee.eas.scm.sm.pur.PurRequestBatchEditFacadeFactory;
import com.kingdee.eas.scm.sm.pur.PurRequestCollection;
import com.kingdee.eas.scm.sm.pur.PurRequestEntryCollection;
import com.kingdee.eas.scm.sm.pur.PurRequestEntryFactory;
import com.kingdee.eas.scm.sm.pur.PurRequestEntryInfo;
import com.kingdee.eas.scm.sm.pur.PurRequestFactory;
import com.kingdee.eas.scm.sm.pur.PurRequestInfo;
import com.kingdee.eas.scm.sm.pur.PurServiceFacadeFactory;
import com.kingdee.eas.scm.sm.pur.calculate.PurRequestBatchEditCal;
import com.kingdee.eas.scm.sm.pur.client.AbstractPurRequestBatchEditUI;
import com.kingdee.eas.scm.util.string.StringUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.enums.EnumUtils;
import java.awt.Component;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class PurRequestBatchEditUI
extends AbstractPurRequestBatchEditUI {
    private static final long serialVersionUID = -190059107957442931L;
    private static final Logger logger = CoreUIObject.getLogger(PurRequestBatchEditUI.class);
    public static final String TB_ID = "id";
    public static final String TB_NUMBER = "number";
    public static final String TB_BASESTATUS = "baseStatus";
    public static final String TB_ENTRYID = "entries.id";
    public static final String TB_SEQ = "seq";
    public static final String TB_MATERIAL_NUMBER = "material.number";
    public static final String TB_MATERIAL_NAME = "material.name";
    public static final String TB_MATERIAL_MODEL = "material.model";
    public static final String TB_UNIT = "unit";
    public static final String TB_REQUESTQTY = "requestQty";
    public static final String TB_QTY = "qty";
    public static final String TB_CURRENCY = "currency";
    public static final String TB_PRICE = "price";
    public static final String TB_TAXPRICE = "taxPrice";
    public static final String TB_AMOUNT = "amount";
    public static final String TB_PROJECT = "project";
    public static final String TB_TRACKNO = "trackNo";
    public static final String TB_REQUIREMENTDATE = "requirementDate";
    public static final String TB_PURCHASEORGUNIT = "purchaseOrgUnit";
    public static final String TB_COMPANYORGUNIT = "companyOrgUnit";
    public static final String TB_REQADMINORGUNIT = "reqAdminOrgUnit";
    public static final String TB_ISINTAX = "isintax";
    public static final String TB_TAXRATE = "taxRate";
    private static final String[] MATERIALUNITTAB = new String[]{"unit"};
    private List<String> NEDD_FETCHPRICE_COLUMN = new ArrayList<String>(){
        {
            this.add(PurRequestBatchEditUI.TB_UNIT);
            this.add(PurRequestBatchEditUI.TB_REQUESTQTY);
            this.add(PurRequestBatchEditUI.TB_QTY);
            this.add(PurRequestBatchEditUI.TB_REQUIREMENTDATE);
            this.add(PurRequestBatchEditUI.TB_PURCHASEORGUNIT);
        }
    };
    private List<String> NEDD_CALPRICE_COLUMN = new ArrayList<String>(){
        {
            this.add(PurRequestBatchEditUI.TB_UNIT);
            this.add(PurRequestBatchEditUI.TB_REQUESTQTY);
            this.add(PurRequestBatchEditUI.TB_QTY);
            this.add(PurRequestBatchEditUI.TB_PRICE);
            this.add(PurRequestBatchEditUI.TB_TAXPRICE);
        }
    };
    private static final String[] QTYPRECISION_QTY = new String[]{"requestQty", "qty"};
    private static final String[] PRICEPRECISIONTAB = new String[]{"price", "taxPrice"};
    private static final String[] CURRENCYPRECISIONTAB = new String[]{"amount"};
    Map<String, PurRequestInfo> rowData = new HashMap<String, PurRequestInfo>();
    private KDTEditAdapter entryTableChange = null;
    private PurEntryDataVO purEntryVO = new PurEntryDataVO();

    @Override
    public void onLoad() throws Exception {
        this.BILLTYPE_ID = "510b6503-0105-1000-e000-0107c0a812fd463ED552";
        super.onLoad();
    }

    protected void initListener() {
        super.initListener();
        if (this.entryTableChange == null) {
            this.entryTableChange = new KDTEditAdapter(){

                public void editStarting(KDTEditEvent e) {
                    try {
                        PurRequestBatchEditUI.this.kdtEntries_editStarting(e);
                    }
                    catch (Exception exc) {
                        PurRequestBatchEditUI.this.handUIException(exc);
                    }
                }

                public void editStopped(KDTEditEvent e) {
                    try {
                        PurRequestBatchEditUI.this.kdtEntries_editStopped(e);
                    }
                    catch (Exception exc) {
                        PurRequestBatchEditUI.this.handUIException(exc);
                    }
                }
            };
        }
        this.getDetailTable().addKDTEditListener((KDTEditListener)this.entryTableChange);
    }

    protected void removeListener() {
        if (this.entryTableChange != null) {
            this.getDetailTable().removeKDTEditListener((KDTEditListener)this.entryTableChange);
        }
    }

    @Override
    protected void doBizSure(IObjectCollection batchCollection) throws Exception {
        super.doBizSure(batchCollection);
        this.loadTableToData();
        if (this.rowData != null && this.rowData.size() > 0) {
            this.getPurRequestFacadeInterface().batchUpdate(this.rowData);
            this.showSuccessMsg("PUR_BATCH_SUCCESS");
        } else {
            logger.error((Object)"@@@@PurRequestBatchEditUI.doBizSure(),\u6ca1\u6709\u83b7\u53d6\u5230\u8868\u683c\u6570\u636e");
        }
    }

    public void kdtEntries_editStarting(KDTEditEvent e) throws Exception {
        int rowIndex = e.getRowIndex();
        int collIndex = e.getColIndex();
        String fieldName = this.getDetailTable().getColumnKey(collIndex);
        Object oldValue = e.getOldValue();
        Object newValue = e.getValue();
        IRow row = this.getDetailTable().getRow(rowIndex);
        PurRequestInfo info = (PurRequestInfo)row.getCell("info").getValue();
        PurRequestEntryInfo entryInfo = info.getEntries().get(0);
        if (info.getCompanyOrgUnit() == null) {
            e.setCancel(true);
            SysUtil.abort();
        }
        boolean isIntax = info.isIsInTax();
        if (TB_PRICE.equalsIgnoreCase(fieldName) && isIntax) {
            e.setCancel(true);
            SysUtil.abort();
        }
        if (TB_TAXPRICE.equalsIgnoreCase(fieldName)) {
            if (!isIntax) {
                e.setCancel(true);
                SysUtil.abort();
            }
            String orgUnitPK = null;
            if (entryInfo.getPurchaseOrgUnit() != null && entryInfo.getPurchaseOrgUnit().getId() != null) {
                orgUnitPK = entryInfo.getPurchaseOrgUnit().getId().toString();
            }
        }
        if (TB_PURCHASEORGUNIT.equalsIgnoreCase(fieldName)) {
            StorageOrgUnitInfo storageOrgUnitInfo = entryInfo.getStorageOrgUnit();
            AdminOrgUnitInfo adminOrgUnitInfo = entryInfo.getAdminOrgUnit();
            RowTypeInfo rowType = entryInfo.getRowType();
            OrgUnitDelegationF7 oudf7 = new OrgUnitDelegationF7((KDBizPromptBox)this.getDetailTable().getColumn(TB_PURCHASEORGUNIT).getEditor().getComponent(), DelegationPartsEnum.THE_TO_UNIT, OrgType.Purchase);
            if (this.isBotpBill("7UcZ6QEUEADgAAYawKg9C0Y+1VI=", info)) {
                if (storageOrgUnitInfo != null) {
                    oudf7.setTheGivenOrgUnit(storageOrgUnitInfo.getId().toString(), OrgType.Storage);
                }
            } else if (rowType != null && DestinationTypeEnum.STORAGE == rowType.getDestinationType()) {
                if (storageOrgUnitInfo != null) {
                    oudf7.setTheGivenOrgUnit(storageOrgUnitInfo.getId().toString(), OrgType.Storage);
                } else {
                    ((KDBizPromptBox)this.getDetailTable().getColumn(TB_PURCHASEORGUNIT).getEditor().getComponent()).setEntityViewInfo(null);
                }
            } else if (adminOrgUnitInfo != null) {
                oudf7.setTheGivenOrgUnit(adminOrgUnitInfo.getId().toString(), OrgType.Admin);
            } else {
                ((KDBizPromptBox)this.getDetailTable().getColumn(TB_PURCHASEORGUNIT).getEditor().getComponent()).setEntityViewInfo(null);
            }
        }
    }

    public void kdtEntries_editStopped(KDTEditEvent e) throws Exception {
        int rowIndex = e.getRowIndex();
        int collIndex = e.getColIndex();
        String fieldName = this.getDetailTable().getColumnKey(collIndex);
        Object oldValue = e.getOldValue();
        Object newValue = e.getValue();
        IRow row = this.getDetailTable().getRow(rowIndex);
        if (oldValue != null && newValue != null && oldValue.equals(newValue) || oldValue == null && newValue == null) {
            return;
        }
        if (oldValue instanceof BigDecimal && newValue instanceof BigDecimal && ((BigDecimal)oldValue).compareTo((BigDecimal)newValue) == 0) {
            return;
        }
        List<String> requiredColumn = this.getRequiredColumn();
        if (requiredColumn.contains(fieldName) && oldValue != null && newValue == null) {
            row.getCell(fieldName).setValue(oldValue);
            return;
        }
        boolean isNeedUpdateOther = false;
        ArrayList<String> headUpdateFieldList = new ArrayList<String>();
        headUpdateFieldList.add(fieldName);
        PurRequestInfo info = (PurRequestInfo)row.getCell("info").getValue();
        PurRequestEntryInfo entryInfo = info.getEntries().get(0);
        entryInfo.setDiscountRate(entryInfo.getDiscountRate().setScale(2, 4));
        RowTypeInfo rowTypeInfo = entryInfo.getRowType();
        if (TB_REQUIREMENTDATE.equalsIgnoreCase(fieldName)) {
            Date requirementDate = (Date)newValue;
            entryInfo.setRequirementDate(requirementDate);
        }
        if (TB_PROJECT.equalsIgnoreCase(fieldName)) {
            ProjectInfo project = (ProjectInfo)newValue;
            entryInfo.setProject(project);
        }
        if (TB_TRACKNO.equalsIgnoreCase(fieldName)) {
            TrackNumberInfo trackNo = (TrackNumberInfo)newValue;
            entryInfo.setTrackNo(trackNo);
        }
        if (TB_PURCHASEORGUNIT.equalsIgnoreCase(fieldName)) {
            PurchaseOrgUnitInfo purchaseOrgUnit = (PurchaseOrgUnitInfo)newValue;
            boolean isSuccess = true;
            if (rowTypeInfo.isIsHasMaterialNumber()) {
                MaterialInfo materialInfo = entryInfo.getMaterial();
                isSuccess = this.checkForMaterialAndPurchase(rowIndex, materialInfo.getId().toString(), purchaseOrgUnit.getId().toString(), true);
            }
            if (isSuccess) {
                entryInfo.setPurchaseOrgUnit(purchaseOrgUnit);
            } else {
                this.getDetailTable().getCell(rowIndex, TB_PURCHASEORGUNIT).setValue(oldValue);
            }
        }
        if (TB_UNIT.equalsIgnoreCase(fieldName)) {
            MeasureUnitInfo oldUnitInfo;
            MeasureUnitInfo newUnitInfo = (MeasureUnitInfo)newValue;
            entryInfo.setUnit(newUnitInfo);
            IMultiMeasureUnit imultiUnit = MultiMeasureUnitFactory.getRemoteInstance();
            MultiMeasureUnitInfo multiUnitInfo = null;
            MaterialInfo materialInfo = (MaterialInfo)this.getDetailTable().getCell(rowIndex, TB_MATERIAL_NUMBER).getValue();
            if (materialInfo != null && newUnitInfo != null) {
                multiUnitInfo = imultiUnit.getMultiUnit(materialInfo.getId().toString(), newUnitInfo.getId().toString());
            }
            if (oldValue instanceof MeasureUnitInfo && newValue instanceof MeasureUnitInfo && !oldValue.equals(newValue)) {
                oldUnitInfo = (MeasureUnitInfo)oldValue;
                this.calEntryQtyForUnit(entryInfo, rowIndex, oldUnitInfo, multiUnitInfo);
            }
            if (materialInfo != null && newUnitInfo != null) {
                BigDecimal baseUnitPrice;
                oldUnitInfo = (MeasureUnitInfo)oldValue;
                if (info.isIsInTax()) {
                    BigDecimal taxPrice = (BigDecimal)this.getDetailTable().getCell(rowIndex, TB_TAXPRICE).getValue();
                    baseUnitPrice = SCMClientUtils.getBaseUnitQtyFromData((MeasureUnitInfo)oldUnitInfo, (MeasureUnitInfo)newUnitInfo, (MaterialInfo)materialInfo, (BigDecimal)taxPrice);
                    if (baseUnitPrice != null) {
                        baseUnitPrice = baseUnitPrice.setScale(materialInfo.getPricePrecision(), 4);
                        this.getDetailTable().getCell(rowIndex, TB_TAXPRICE).setValue((Object)baseUnitPrice);
                        entryInfo.setTaxPrice(baseUnitPrice);
                    }
                } else {
                    BigDecimal price = (BigDecimal)this.getDetailTable().getCell(rowIndex, TB_PRICE).getValue();
                    baseUnitPrice = SCMClientUtils.getBaseUnitQtyFromData((MeasureUnitInfo)oldUnitInfo, (MeasureUnitInfo)newUnitInfo, (MaterialInfo)materialInfo, (BigDecimal)price);
                    if (baseUnitPrice != null) {
                        baseUnitPrice = baseUnitPrice.setScale(materialInfo.getPricePrecision(), 4);
                        this.getDetailTable().getCell(rowIndex, TB_PRICE).setValue((Object)baseUnitPrice);
                        entryInfo.setPrice(baseUnitPrice);
                    }
                }
                PurRequestBatchEditCal purRequestBatchEditCal = new PurRequestBatchEditCal();
                purRequestBatchEditCal.setInTax(info.isIsInTax());
                purRequestBatchEditCal.calByEntryUnitChange(info, entryInfo);
                purRequestBatchEditCal.setAmoutscale(entryInfo.getCurrency().getPrecision());
                if (!info.isIsInTax()) {
                    purRequestBatchEditCal.calEntryTaxPrice(info, entryInfo);
                } else {
                    purRequestBatchEditCal.calEntryPrice(info, entryInfo);
                }
            } else {
                entryInfo.setBaseUnit(newUnitInfo);
            }
        }
        if (TB_REQUESTQTY.equalsIgnoreCase(fieldName) || TB_QTY.equalsIgnoreCase(fieldName)) {
            BigDecimal requestQty = BIGZERO;
            BigDecimal qty = BIGZERO;
            if (newValue != null && TB_REQUESTQTY.equalsIgnoreCase(fieldName)) {
                requestQty = (BigDecimal)newValue;
                entryInfo.setRequestQty(requestQty);
                qty = requestQty;
                row.getCell(TB_QTY).setValue((Object)qty);
                entryInfo.setQty(qty);
            }
            if (newValue != null && TB_QTY.equalsIgnoreCase(fieldName)) {
                qty = (BigDecimal)newValue;
                entryInfo.setQty(qty);
            }
            entryInfo.setAssociateQty(qty);
            this.calEntryBaseQty(entryInfo, rowIndex);
        }
        if (TB_PRICE.equalsIgnoreCase(fieldName)) {
            BigDecimal price = BIGZERO;
            if (newValue != null) {
                price = (BigDecimal)newValue;
            }
            entryInfo.setPrice(price);
        }
        if (TB_TAXPRICE.equalsIgnoreCase(fieldName)) {
            BigDecimal taxPrice = BIGZERO;
            if (newValue != null) {
                taxPrice = (BigDecimal)newValue;
            }
            entryInfo.setTaxPrice(taxPrice);
        }
        if (this.NEDD_FETCHPRICE_COLUMN.contains(fieldName) || this.NEDD_CALPRICE_COLUMN.contains(fieldName)) {
            entryInfo.put("oldAmount", entryInfo.getAmount() == null ? BIGZERO : entryInfo.getAmount());
            entryInfo.put("oldLocalAmount", entryInfo.getLocalAmount() == null ? BIGZERO : entryInfo.getLocalAmount());
            entryInfo.put("oldTaxAmount", entryInfo.getTaxAmount() == null ? BIGZERO : entryInfo.getTaxAmount());
            entryInfo.put("oldLocalTaxAmount", entryInfo.getLocalTaxAmount() == null ? BIGZERO : entryInfo.getLocalTaxAmount());
            entryInfo.put("oldTax", entryInfo.getTax() == null ? BIGZERO : entryInfo.getTax());
            if (this.NEDD_CALPRICE_COLUMN.contains(fieldName)) {
                this.tableChange_Cal(info, entryInfo, fieldName);
            }
            if (this.NEDD_FETCHPRICE_COLUMN.contains(fieldName) && entryInfo.getMaterial() != null && entryInfo.getMaterial().getId() != null) {
                int seq = entryInfo.getSeq();
                PurPriceParamCollection paramCol = new PurPriceParamCollection();
                paramCol.setBillTypeId("510b6503-0105-1000-e000-0107c0a812fd463ED552");
                if (PurchaseTypeEnum.SUBCONTRACT.equals((Object)info.getPurchaseType())) {
                    paramCol.setPurchaseType(MaterialPurchaseTypeEnum.SUBCONTRACT);
                }
                paramCol.setBizTypeId(info.getBillType() != null ? info.getBizType().getId().toString() : null);
                PurPriceParam param = PurRequestBatchEditCal.getPriceParam(seq, info, entryInfo);
                paramCol.addPurPriceParam(param);
                this.fetchPrice(info, entryInfo, seq, paramCol);
            }
            this.getDetailTable().getCell(rowIndex, TB_PRICE).setValue((Object)entryInfo.getPrice());
            this.getDetailTable().getCell(rowIndex, TB_TAXPRICE).setValue((Object)entryInfo.getTaxPrice());
            this.getDetailTable().getCell(rowIndex, TB_AMOUNT).setValue((Object)entryInfo.getAmount());
            this.getDetailTable().getCell(rowIndex, TB_TAXRATE).setValue((Object)entryInfo.getTaxRate());
        }
        this.setTableCellValue(this.getDetailTable(), rowIndex, "info", info);
        if (isNeedUpdateOther) {
            this.getDetailTable().setRefresh(false);
            this.getDetailTable().enableRepaint(false);
            PurRequestInfo fromInfo = null;
            PurRequestInfo toInfo = null;
            PurRequestEntryInfo toEntryInfo = null;
            String id = info.getId().toString();
            String otherID = null;
            String uptField = null;
            int rowCount = this.getDetailTable().getRowCount();
            PurRequestInfo otherInfo = (PurRequestInfo)info.clone();
            otherInfo.getEntries().clear();
            for (int i = 0; i < rowCount; ++i) {
                otherID = this.getDetailTable().getCell(i, TB_ID).getValue().toString();
                if (id == null || otherID == null || !id.equals(otherID)) continue;
                toInfo = (PurRequestInfo)this.getDetailTable().getCell(i, "info").getValue();
                toEntryInfo = (PurRequestEntryInfo)toInfo.getEntries().get(0).clone();
                fromInfo = (PurRequestInfo)otherInfo.clone();
                fromInfo.getEntries().add(toEntryInfo);
                this.getDetailTable().getCell(i, "info").setValue((Object)fromInfo);
                if (headUpdateFieldList.size() == 1) {
                    this.getDetailTable().getCell(i, fieldName).setValue(newValue);
                    continue;
                }
                if (headUpdateFieldList.size() <= 1) continue;
                int len = headUpdateFieldList.size();
                for (int j = 0; j < len; ++j) {
                    uptField = (String)headUpdateFieldList.get(j);
                    this.getDetailTable().getCell(i, uptField).setValue(fromInfo.get(uptField));
                }
            }
        }
        this.updateRowDataByNewInfo(rowIndex, info, entryInfo);
        this.getDetailTable().setRefresh(true);
        this.getDetailTable().enableRepaint(true);
        this.getDetailTable().repaint();
    }

    private void fetchPrice(PurRequestInfo info, PurRequestEntryInfo entryInfo, int seq, PurPriceParamCollection paramCol) throws EASBizException, BOSException {
        PurPriceInfoCollection cols = PurServiceFacadeFactory.getRemoteInstance().fetchPrice(paramCol);
        CurrencyInfo currencyInfo = entryInfo.getCurrency();
        if (paramCol.size() > 0) {
            PurPriceInfo priceInfo = cols.getPurPriceInfoBySeq(seq);
            if (entryInfo.getSupplier() == null && priceInfo != null) {
                entryInfo.setSupplier(priceInfo.getSupplier());
            }
            if (priceInfo != null && priceInfo.getTaxRate() != null) {
                entryInfo.setTaxRate(priceInfo.getTaxRate());
            } else {
                entryInfo.setTaxRate(BIGZERO);
            }
            if (priceInfo != null && priceInfo.getPrice() != null) {
                PurRequestBatchEditCal purRequestBatchEditCal = new PurRequestBatchEditCal();
                purRequestBatchEditCal.setInTax(priceInfo.isInTaxPrice());
                if (priceInfo.getDiscountRate() != null) {
                    entryInfo.setDiscountRate(priceInfo.getDiscountRate());
                }
                if (currencyInfo != null) {
                    purRequestBatchEditCal.setAmoutscale(currencyInfo.getPrecision());
                }
                if (priceInfo.isInTaxPrice()) {
                    entryInfo.setTaxPrice(priceInfo.getPrice());
                    purRequestBatchEditCal.calByEntryTaxPriceChange(info, entryInfo);
                } else {
                    entryInfo.setPrice(priceInfo.getPrice());
                    purRequestBatchEditCal.calByEntryPriceChange(info, entryInfo);
                }
            }
        }
    }

    private void tableChange_Cal(PurRequestInfo info, PurRequestEntryInfo entryInfo, String fieldName) {
        PurRequestBatchEditCal purRequestBatchEditCal = new PurRequestBatchEditCal();
        purRequestBatchEditCal.setInTax(info.isIsInTax());
        purRequestBatchEditCal.setAmoutscale(entryInfo.getCurrency().getPrecision());
        if (TB_REQUESTQTY.equalsIgnoreCase(fieldName) || TB_QTY.equalsIgnoreCase(fieldName) || TB_UNIT.equalsIgnoreCase(fieldName)) {
            purRequestBatchEditCal.calByEntryQtyChange(info, entryInfo);
        }
        if (TB_PRICE.equalsIgnoreCase(fieldName)) {
            purRequestBatchEditCal.calByEntryPriceChange(info, entryInfo);
        }
        if (TB_TAXPRICE.equalsIgnoreCase(fieldName)) {
            purRequestBatchEditCal.calByEntryTaxPriceChange(info, entryInfo);
        }
    }

    public void calEntryQtyForUnit(PurRequestEntryInfo entryInfo, int rowIndex, MeasureUnitInfo oldUnitInfo, MultiMeasureUnitInfo newMultiUnitInfo) throws EASBizException, BOSException {
        if (newMultiUnitInfo != null) {
            KDFormattedTextField qtyformatedTxtField = new KDFormattedTextField();
            qtyformatedTxtField.setDataType(1);
            qtyformatedTxtField.setNegatived(false);
            qtyformatedTxtField.setPrecision(newMultiUnitInfo.getQtyPrecision());
            KDTDefaultCellEditor qtynumber_CellEditor = new KDTDefaultCellEditor((JTextField)qtyformatedTxtField);
            String qtyPrecisionString = PrecisionUtil.getFormatString((int)newMultiUnitInfo.getQtyPrecision());
            this.getDetailTable().getCell(rowIndex, TB_REQUESTQTY).setEditor((ICellEditor)qtynumber_CellEditor);
            this.getDetailTable().getCell(rowIndex, TB_REQUESTQTY).getStyleAttributes().setNumberFormat(qtyPrecisionString);
            this.getDetailTable().getCell(rowIndex, TB_QTY).setEditor((ICellEditor)qtynumber_CellEditor);
            this.getDetailTable().getCell(rowIndex, TB_QTY).getStyleAttributes().setNumberFormat(qtyPrecisionString);
        }
        BigDecimal newQty = null;
        BigDecimal newRequestQty = null;
        MaterialInfo materialInfo = (MaterialInfo)this.getDetailTable().getRow(rowIndex).getCell(TB_MATERIAL_NUMBER).getValue();
        MeasureUnitInfo newUnitInfo = (MeasureUnitInfo)this.getDetailTable().getRow(rowIndex).getCell(TB_UNIT).getValue();
        BigDecimal qty = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(TB_QTY).getValue();
        BigDecimal requestQty = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(TB_REQUESTQTY).getValue();
        if (materialInfo != null) {
            int scale;
            if (requestQty != null && oldUnitInfo != null && newUnitInfo != null) {
                newRequestQty = SCMUtils.getExchangeQtyForClient((String)materialInfo.getId().toString(), (MeasureUnitInfo)oldUnitInfo, (MeasureUnitInfo)newUnitInfo, (BigDecimal)requestQty.setScale(10));
                scale = newMultiUnitInfo.getQtyPrecision();
                BigDecimal newRequestQty2 = newRequestQty.setScale(scale, 4);
                this.getDetailTable().getRow(rowIndex).getCell(TB_REQUESTQTY).setValue((Object)newRequestQty2);
                entryInfo.setRequestQty(newRequestQty2);
            }
            if (qty != null && oldUnitInfo != null && newUnitInfo != null) {
                newQty = SCMUtils.getExchangeQtyForClient((String)materialInfo.getId().toString(), (MeasureUnitInfo)oldUnitInfo, (MeasureUnitInfo)newUnitInfo, (BigDecimal)qty.setScale(10));
                scale = newMultiUnitInfo.getQtyPrecision();
                BigDecimal newQty2 = newQty.setScale(scale, 4);
                this.getDetailTable().getRow(rowIndex).getCell(TB_QTY).setValue((Object)newQty2);
                entryInfo.setQty(newQty2);
            }
        } else {
            entryInfo.setQty(qty);
            if (newUnitInfo != null) {
                int scale = newUnitInfo.getQtyPrecision();
                entryInfo.setRequestQty(requestQty.setScale(scale));
                entryInfo.setQty(qty.setScale(scale));
            }
        }
    }

    public void calEntryBaseQty(PurRequestEntryInfo entryInfo, int rowIndex) throws EASBizException, BOSException {
        MeasureUnitInfo baseUnitInfo = entryInfo.getBaseUnit();
        MeasureUnitInfo unitInfo = entryInfo.getUnit();
        MaterialInfo materialInfo = entryInfo.getMaterial();
        BigDecimal qty = entryInfo.getQty();
        if (baseUnitInfo == null || unitInfo == null || materialInfo == null || qty == null) {
            return;
        }
        BigDecimal baseUnitQty = this.getExchangeQty(materialInfo.getId().toString(), unitInfo, baseUnitInfo, qty);
        entryInfo.setBaseQty(baseUnitQty);
    }

    @Override
    protected void doQuery() throws Exception {
        super.doQuery();
        PurchaseOrgUnitInfo purchaseOrgUnitInfo = (PurchaseOrgUnitInfo)this.prmtPurchaseOrgUnit.getValue();
        StorageOrgUnitInfo storageOrgUnitInfo = (StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue();
        AdminOrgUnitInfo adminOrgUnitInfo = (AdminOrgUnitInfo)this.prmtAdminOrgUnit.getValue();
        BillBaseStatusEnum baseStaus = (BillBaseStatusEnum)this.cobbaseStatus.getSelectedItem();
        PurRequestInfo numFrom = (PurRequestInfo)this.prmtNumberFrom.getValue();
        PurRequestInfo numTo = (PurRequestInfo)this.prmtNumberTo.getValue();
        String numberFrom = null;
        String numberTo = null;
        if (numFrom != null) {
            numberFrom = numFrom.getNumber();
        }
        if (numTo != null) {
            numberTo = numTo.getNumber();
        }
        MaterialInfo materialFrom = (MaterialInfo)this.prmtMaterialNumFrom.getValue();
        MaterialInfo materialTo = (MaterialInfo)this.prmtMaterialNumTo.getValue();
        ProjectInfo projectFrom = (ProjectInfo)this.prmtProjectFrom.getValue();
        ProjectInfo projectTo = (ProjectInfo)this.prmtProjectTo.getValue();
        TrackNumberInfo trackNumberFrom = (TrackNumberInfo)this.prmtTrackNumberFrom.getValue();
        TrackNumberInfo trackNumberTo = (TrackNumberInfo)this.prmtTrackNumberTo.getValue();
        StringBuffer sql1 = new StringBuffer();
        StringBuffer sql2 = new StringBuffer();
        sql1.append("select entry.FID id from T_SM_PurRequestEntry entry left join T_SM_PurRequest bill on  bill.FID = entry.FParentID ");
        if (baseStaus != null && baseStaus != BillBaseStatusEnum.NULL) {
            sql2.append(" where bill.FBaseStatus = ").append(baseStaus.getValue());
        } else {
            sql2.append(" where (bill.FBaseStatus = 1 or bill.FBaseStatus = 2) ");
        }
        if (purchaseOrgUnitInfo != null && purchaseOrgUnitInfo.getId() != null) {
            sql1.append(" left join T_ORG_Purchase AS PURCHASEORGUNIT on entry.FPurchaseOrgUnitID = PURCHASEORGUNIT.FID ");
            sql2.append(" and entry.FPurchaseOrgUnitID = '").append(purchaseOrgUnitInfo.getId().toString()).append("' ");
        }
        if (storageOrgUnitInfo != null && storageOrgUnitInfo.getId() != null) {
            sql1.append(" left join T_ORG_Storage AS STORAGEORGUNIT on entry.FStorageOrgUnitID = STORAGEORGUNIT.FID ");
            sql2.append(" and entry.FStorageOrgUnitID = '").append(storageOrgUnitInfo.getId().toString()).append("' ");
        }
        if (adminOrgUnitInfo != null && adminOrgUnitInfo.getId() != null) {
            sql1.append(" left join T_ORG_Admin AS ADMINORG on entry.FReqAdminOrgUnitID = ADMINORG.FID ");
            sql2.append(" and entry.FReqAdminOrgUnitID = '").append(adminOrgUnitInfo.getId().toString()).append("' ");
        }
        if (numberFrom != null) {
            sql2.append(" and bill.FNumber >= '").append(numberFrom).append("' ");
        }
        if (numberTo != null) {
            sql2.append(" and bill.FNumber <= '").append(numberTo).append("' ");
        }
        if (materialFrom != null || materialTo != null) {
            sql1.append(" left join T_BD_Material AS MATERIAL on entry.FMaterialID = MATERIAL.FID ");
        }
        if (materialFrom != null) {
            sql2.append(" and MATERIAL.FNumber >= '").append(materialFrom.getNumber()).append("' ");
        }
        if (materialTo != null) {
            sql2.append(" and MATERIAL.FNumber <= '").append(materialTo.getNumber()).append("' ");
        }
        if (projectFrom != null || projectTo != null) {
            sql1.append(" left join T_MM_Project AS PROJECT on entry.FProjectID = PROJECT.FID ");
        }
        if (projectFrom != null) {
            sql2.append(" and PROJECT.FNumber >= '").append(projectFrom.getNumber()).append("' ");
        }
        if (projectTo != null) {
            sql2.append(" and PROJECT.FNumber <= '").append(projectTo.getNumber()).append("' ");
        }
        if (trackNumberFrom != null || trackNumberTo != null) {
            sql1.append(" left join T_MM_TrackNumber AS TRACKNO on entry.FTrackNoID = TRACKNO.FID ");
        }
        if (trackNumberFrom != null) {
            sql2.append(" and TRACKNO.FNumber >= '").append(trackNumberFrom.getNumber()).append("' ");
        }
        if (trackNumberTo != null) {
            sql2.append(" and TRACKNO.FNumber <= '").append(trackNumberTo.getNumber()).append("' ");
        }
        sql1.append(sql2.toString());
        sql1.append(" and bill.FID in ").append(this.convertSet2Sql(this.billIdSet));
        sql1.append(" and entry.FID in ").append(this.convertSet2Sql(this.billEntryIdSet));
        sql1.append(" order by bill.FNumber desc ,entry.fseq asc");
        Map map = PurRequestBatchEditFacadeFactory.getRemoteInstance().excuteQuery(sql1.toString());
        List entryIdList = null;
        if (map.get("entryIdList") != null) {
            entryIdList = (List)map.get("entryIdList");
        }
        this.currentQueryIdList = entryIdList;
        this.getDetailTable().setRefresh(false);
        this.getDetailTable().enableRepaint(false);
        this.setPositionForRow(this.previousQueryIdList, true);
        this.setPositionForRow(this.currentQueryIdList, false);
        this.getDetailTable().setRefresh(true);
        this.getDetailTable().enableRepaint(true);
        this.getDetailTable().repaint();
        this.previousQueryIdList = this.currentQueryIdList;
        if (this.currentQueryIdList == null || this.currentQueryIdList.size() == 0) {
            this.showMsgBoxInfo("PUR_BATCH_QUERYNULLDATA");
        }
        this.currentQueryIdList = new ArrayList();
    }

    @Override
    protected IObjectCollection getCollection(Set<String> idSet, Set<String> entryIdSet) throws Exception {
        EntityViewInfo ev = null;
        FilterInfo filter = null;
        PurRequestInfo info = null;
        PurRequestEntryInfo entryInfo = null;
        PurRequestCollection col = new PurRequestCollection();
        PurRequestEntryCollection entryCol = new PurRequestEntryCollection();
        PurRequestCollection newCol = new PurRequestCollection();
        ev = new EntityViewInfo();
        filter = new FilterInfo();
        if (idSet != null) {
            filter.getFilterItems().add(new FilterItemInfo(this.getKeyFieldName(), idSet, CompareType.INCLUDE));
        } else {
            filter.getFilterItems().add(new FilterItemInfo((String)this.tableToBillRelation.get(TB_BASESTATUS), (Object)-8, CompareType.EQUALS));
        }
        SorterItemCollection sortcol = new SorterItemCollection();
        SorterItemInfo sorterItemInfo = new SorterItemInfo((String)this.tableToBillRelation.get(TB_NUMBER));
        sorterItemInfo.setSortType(SortType.DESCEND);
        sortcol.add(sorterItemInfo);
        ev.setSorter(sortcol);
        ev.setFilter(filter);
        ev.setSelector(this.getBillSelectors());
        col = ((IPurRequest)this.getBizInterface()).getPurRequestCollection(ev);
        ev = new EntityViewInfo();
        filter = new FilterInfo();
        if (idSet != null) {
            filter.getFilterItems().add(new FilterItemInfo(this.getKeyFieldName(), entryIdSet, CompareType.INCLUDE));
        } else {
            filter.getFilterItems().add(new FilterItemInfo((String)this.tableToBillRelation.get(TB_BASESTATUS), (Object)-8, CompareType.EQUALS));
        }
        sortcol = new SorterItemCollection();
        SorterItemInfo parentnumbersort = new SorterItemInfo("parent.number");
        parentnumbersort.setSortType(SortType.DESCEND);
        sortcol.add(parentnumbersort);
        sortcol.add(new SorterItemInfo((String)this.tableToEntryRelation.get(TB_SEQ)));
        ev.setSorter(sortcol);
        ev.setFilter(filter);
        ev.setSelector(this.getEntrySelectors());
        entryCol = ((IPurRequestEntry)this.getBizEntryInterface()).getPurRequestEntryCollection(ev);
        LinkedHashMap<String, PurRequestInfo> billMap = new LinkedHashMap<String, PurRequestInfo>();
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            info = col.get(i);
            info.getEntries().clear();
            col.set(i, info);
            billMap.put(info.getId().toString(), info);
        }
        String parentId = null;
        int size2 = entryCol.size();
        for (int i = 0; i < size2; ++i) {
            entryInfo = entryCol.get(i);
            parentId = entryInfo.getParent().getId().toString();
            if (!billMap.containsKey(parentId)) continue;
            info = (PurRequestInfo)billMap.get(parentId);
            if (entryInfo.getMaterial() != null && StringUtil.isEmpty((String)entryInfo.getMaterialName())) {
                entryInfo.setMaterialName(entryInfo.getMaterial().getName());
            }
            info.getEntries().add(entryInfo);
            billMap.put(parentId, info);
        }
        for (Map.Entry entry : billMap.entrySet()) {
            info = (PurRequestInfo)entry.getValue();
            newCol.add(info);
        }
        return newCol;
    }

    @Override
    protected void loadDataToTable() throws Exception {
        PurRequestCollection purRequestCol = (PurRequestCollection)this.getCollection(this.billIdSet, this.billEntryIdSet);
        if (purRequestCol == null || purRequestCol.size() == 0) {
            return;
        }
        this.getDetailTable().setRefresh(false);
        this.getDetailTable().enableRepaint(false);
        PurRequestInfo info = null;
        PurRequestInfo newInfo = null;
        PurRequestEntryCollection entryCol = null;
        PurRequestEntryInfo entryInfo = null;
        int columnCount = this.getDetailTable().getColumnCount();
        int rowCount = 0;
        int billCount = 0;
        int size = purRequestCol.size();
        for (int i = 0; i < size; ++i) {
            info = purRequestCol.get(i);
            rowCount += info.getEntries().size();
            ++billCount;
        }
        String colName = null;
        Object value = null;
        IRow row = null;
        this.getDetailTable().removeRows();
        long time1 = System.currentTimeMillis();
        logger.debug((Object)"@@@@PurRequestBatchEditUI.loadTableData()\u5c06\u96c6\u5408\u5bf9\u8c61\u89e3\u6790\u6210\u8868\u683c\u6570\u7ec4\u5f00\u59cb.................");
        int size2 = purRequestCol.size();
        for (int i = 0; i < size2; ++i) {
            info = purRequestCol.get(i);
            entryCol = info.getEntries();
            int lengh = entryCol.size();
            for (int j = 0; j < lengh; ++j) {
                entryInfo = entryCol.get(j);
                if (entryInfo == null) continue;
                row = this.getDetailTable().addRow();
                for (int k = 0; k < columnCount; ++k) {
                    colName = this.getDetailTable().getColumn(k).getKey();
                    if ("info".equals(colName)) {
                        newInfo = (PurRequestInfo)info.clone();
                        newInfo.getEntries().clear();
                        newInfo.getEntries().add(entryInfo);
                        value = newInfo;
                    } else {
                        value = this.tableToEntryRelation.containsKey(colName) ? entryInfo.get((String)this.tableToEntryRelation.get(colName)) : (this.tableToBillRelation.containsKey(colName) ? info.get((String)this.tableToBillRelation.get(colName)) : null);
                    }
                    if (TB_BASESTATUS.equals(colName)) {
                        int enumValue = 0;
                        if (null != value) {
                            enumValue = Integer.parseInt(value.toString());
                        }
                        value = BillBaseStatusEnum.getEnum((int)enumValue);
                    }
                    this.setTableCellValue(this.getDetailTable(), row.getRowIndex(), colName, value);
                }
            }
        }
        long time2 = System.currentTimeMillis();
        logger.debug((Object)("@@@@PurRequestBatchEditUI.loadTableData()\u89e3\u6790\u6210\u8868\u683c\u5bf9\u8c61\u5355\u636e\u6570\uff1a" + billCount + "\u5206\u5f55\u6570\uff1a" + rowCount));
        logger.debug((Object)("@@@@PurRequestBatchEditUI.loadTableData()\u5c06\u96c6\u5408\u5bf9\u8c61\u89e3\u6790\u6210\u8868\u683c\u6570\u7ec4\u8017\u65f6\uff1a" + (time2 - time1)));
        this.setTableColumnAttr(this.getDetailTable(), this.getLockColumn(), this.getHideColumn(), null);
        this.getDetailTable().setRefresh(true);
        this.getDetailTable().enableRepaint(true);
        this.getDetailTable().repaint();
        this.editCtrl(0, this.getDetailTable().getRowCount());
    }

    protected void loadTableToData() {
        PurRequestInfo info = null;
        String entryId = null;
        int rowCount = this.getDetailTable().getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            info = (PurRequestInfo)this.getDetailTable().getCell(i, "info").getValue();
            entryId = info.getEntries().get(0).getId().toString();
            this.rowData.put(entryId, info);
        }
    }

    @Override
    protected void initEntryPrecisionForEdit() throws EASBizException, BOSException {
        int i;
        PurRequestInfo info = null;
        PurRequestEntryInfo entryInfo = null;
        RowTypeInfo rowTypeInfo = null;
        int num = this.getDetailTable().getRowCount();
        CurrencyInfo currencyInfo = null;
        MaterialInfo[] materialInfos = new MaterialInfo[num];
        MeasureUnitInfo[] measureUnitInfos = new MeasureUnitInfo[num];
        for (int i2 = 0; i2 < num; ++i2) {
            info = (PurRequestInfo)this.getDetailTable().getRow(i2).getCell("info").getValue();
            entryInfo = info.getEntries().get(0);
            materialInfos[i2] = entryInfo.getMaterial();
            measureUnitInfos[i2] = entryInfo.getUnit();
        }
        this.purEntryVO = new PurEntryDataVO();
        this.purEntryVO.setMaterialInfos(materialInfos);
        this.purEntryVO.setMeasureUnitInfos(measureUnitInfos);
        this.purEntryVO.setIsLoadingMmuPrecision(true);
        try {
            this.purEntryVO = (PurEntryDataVO)PurOrderBatchEditFacadeFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext()).batchMmuData((SCMEntryDataVO)this.purEntryVO);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        int qtycision = 2;
        if (materialInfos == null || measureUnitInfos == null) {
            int size = this.getDetailTable().getRowCount();
            for (i = 0; i < size; ++i) {
                info = (PurRequestInfo)this.getDetailTable().getRow(i).getCell("info").getValue();
                entryInfo = info.getEntries().get(0);
                rowTypeInfo = entryInfo.getRowType();
                if (!rowTypeInfo.isIsHasMaterialNumber() && !rowTypeInfo.isIsHasMaterialNumber() && measureUnitInfos != null && measureUnitInfos[i] != null) {
                    qtycision = measureUnitInfos[i].getQtyPrecision();
                }
                SCMClientUtils.changeTableColPrecision((int)qtycision, (KDTable)this.getDetailTable(), (String[])QTYPRECISION_QTY, (int)i);
            }
        } else {
            if (this.purEntryVO == null) {
                return;
            }
            Map mulUnitMap = this.purEntryVO.getMmuPrecisions();
            int size = materialInfos.length;
            for (int i3 = 0; i3 < size; ++i3) {
                info = (PurRequestInfo)this.getDetailTable().getRow(i3).getCell("info").getValue();
                entryInfo = info.getEntries().get(0);
                rowTypeInfo = entryInfo.getRowType();
                if (rowTypeInfo == null) continue;
                if (rowTypeInfo.isIsHasMaterialNumber()) {
                    SCMClientUtils.changeTableColPrecision((Map)mulUnitMap, (MaterialInfo)materialInfos[i3], (MeasureUnitInfo)measureUnitInfos[i3], (KDTable)this.getDetailTable(), (String[])QTYPRECISION_QTY, (int)i3);
                    continue;
                }
                qtycision = measureUnitInfos[i3] != null ? measureUnitInfos[i3].getQtyPrecision() : 2;
                SCMClientUtils.changeTableColPrecision((int)qtycision, (KDTable)this.getDetailTable(), (String[])QTYPRECISION_QTY, (int)i3);
            }
        }
        for (i = 0; i < num; ++i) {
            info = (PurRequestInfo)this.getDetailTable().getRow(i).getCell("info").getValue();
            entryInfo = info.getEntries().get(0);
            rowTypeInfo = entryInfo.getRowType();
            currencyInfo = entryInfo.getCurrency();
            SCMClientUtils.changeTableColPrecisionByCurrency((CurrencyInfo)currencyInfo, (KDTable)this.getDetailTable(), (String[])CURRENCYPRECISIONTAB);
            if (rowTypeInfo == null) continue;
            if (rowTypeInfo.isIsHasMaterialNumber()) {
                SCMClientUtils.changeTableRowColPrecisionByMaterial((MaterialInfo)materialInfos[i], (KDTable)this.getDetailTable(), (String[])PRICEPRECISIONTAB, (int)i);
                continue;
            }
            SCMClientUtils.changeTableColPrecision((int)rowTypeInfo.getPrecision(), (KDTable)this.getDetailTable(), (String[])PRICEPRECISIONTAB, (int)i);
        }
    }

    @Override
    protected void initEntryPrecisionForRow(int rowIndex) throws EASBizException, BOSException {
        if (this.purEntryVO == null) {
            this.initEntryPrecisionForEdit();
            return;
        }
        PurRequestInfo info = (PurRequestInfo)this.getDetailTable().getRow(rowIndex).getCell("info").getValue();
        PurRequestEntryInfo entryInfo = info.getEntries().get(0);
        CurrencyInfo currencyInfo = entryInfo.getCurrency();
        RowTypeInfo rowTypeInfo = entryInfo.getRowType();
        MaterialInfo materialInfo = entryInfo.getMaterial();
        MeasureUnitInfo unit = entryInfo.getUnit();
        MeasureUnitInfo baseUnit = entryInfo.getBaseUnit();
        if (rowTypeInfo == null) {
            return;
        }
        int qtycision = 2;
        if (materialInfo == null || unit == null && baseUnit == null) {
            if (!rowTypeInfo.isIsHasMaterialNumber()) {
                qtycision = unit.getQtyPrecision();
            }
            SCMClientUtils.changeTableColPrecision((int)qtycision, (KDTable)this.getDetailTable(), (String[])QTYPRECISION_QTY, (int)rowIndex);
        } else {
            Map mulUnitMap = this.purEntryVO.getMmuPrecisions();
            if (rowTypeInfo.isIsHasMaterialNumber()) {
                String key = materialInfo.getId().toString() + unit.getId().toString();
                if (!mulUnitMap.containsKey(key)) {
                    this.cacheMmuPrecision(materialInfo.getId().toString(), unit.getId().toString());
                }
                SCMClientUtils.changeTableColPrecision((Map)mulUnitMap, (MaterialInfo)materialInfo, (MeasureUnitInfo)unit, (KDTable)this.getDetailTable(), (String[])QTYPRECISION_QTY, (int)rowIndex);
            } else {
                qtycision = unit != null ? unit.getQtyPrecision() : 2;
                SCMClientUtils.changeTableColPrecision((int)qtycision, (KDTable)this.getDetailTable(), (String[])QTYPRECISION_QTY, (int)rowIndex);
            }
        }
        SCMClientUtils.changeTableColPrecisionByCurrency((CurrencyInfo)currencyInfo, (KDTable)this.getDetailTable(), (String[])CURRENCYPRECISIONTAB);
        if (rowTypeInfo.isIsHasMaterialNumber()) {
            SCMClientUtils.changeTableRowColPrecisionByMaterial((MaterialInfo)materialInfo, (KDTable)this.getDetailTable(), (String[])PRICEPRECISIONTAB, (int)rowIndex);
        } else {
            SCMClientUtils.changeTableColPrecision((int)rowTypeInfo.getPrecision(), (KDTable)this.getDetailTable(), (String[])PRICEPRECISIONTAB, (int)rowIndex);
        }
    }

    @Override
    protected void initWorkButton() {
        super.initWorkButton();
    }

    @Override
    protected void initUIControl() throws Exception {
        super.initUIControl();
        EntityViewInfo view = null;
        FilterInfo filterInfo = null;
        CtrlUnitInfo cuInfo = SysContext.getSysContext().getCurrentCtrlUnit();
        String cuID = cuInfo.getId().toString();
        view = new EntityViewInfo();
        filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("cu.id", (Object)cuID, CompareType.EQUALS));
        view.setFilter(filterInfo);
        this.prmtPurchaseOrgUnit.setEntityViewInfo(view);
        view = new EntityViewInfo();
        filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("cu.id", (Object)cuID, CompareType.EQUALS));
        view.setFilter(filterInfo);
        this.prmtStorageOrgUnit.setEntityViewInfo(view);
        this.formatBillStatus(this.cobbaseStatus);
        view = new EntityViewInfo();
        filterInfo = new FilterInfo();
        FilterInfo userFilterInfo = SCMClientUtils.getF7FilterInfoByAuthorizedCompanyOrg((String)"companyOrgUnit.id");
        HashSet<Integer> status = new HashSet<Integer>();
        status.add(new Integer(1));
        status.add(new Integer(2));
        filterInfo.getFilterItems().add(new FilterItemInfo(TB_BASESTATUS, status, CompareType.INCLUDE));
        userFilterInfo.mergeFilter(filterInfo, "and");
        view.setFilter(userFilterInfo);
        this.prmtNumberFrom.setEntityViewInfo(view);
        this.prmtNumberTo.setEntityViewInfo(view);
        this.setBizMaterialF7(this.prmtMaterialNumFrom, false, null);
        this.setBizMaterialF7(this.prmtMaterialNumTo, false, null);
        this.registerProjectF7ForFilter(this.prmtProjectFrom);
        this.registerProjectF7ForFilter(this.prmtProjectTo);
        this.registerTrackNumberF7ForFilter(this.prmtTrackNumberFrom);
        this.registerTrackNumberF7ForFilter(this.prmtTrackNumberTo);
        this.setF7RangeChange((Component)this.prmtNumberFrom, (Component)this.prmtNumberTo);
        this.setF7RangeChange((Component)this.prmtMaterialNumFrom, (Component)this.prmtMaterialNumTo);
        this.setF7RangeChange((Component)this.prmtProjectFrom, (Component)this.prmtProjectTo);
        this.setF7RangeChange((Component)this.prmtTrackNumberFrom, (Component)this.prmtTrackNumberTo);
        KDComboBox baseStatusComboBox = new KDComboBox();
        baseStatusComboBox.addItems(EnumUtils.getEnumList((String)"com.kingdee.eas.scm.common.BillBaseStatusEnum").toArray());
        KDTDefaultCellEditor baseStatusCellEditor = new KDTDefaultCellEditor((JComboBox)baseStatusComboBox);
        this.getDetailTable().getColumn(TB_BASESTATUS).setEditor((ICellEditor)baseStatusCellEditor);
        KDBizPromptBox bizMaterialBox = new KDBizPromptBox();
        bizMaterialBox.setQueryInfo(QueryInfoConstants.getMaterialNoGroupQueryInfo((OrgType)OrgType.Company));
        bizMaterialBox.setEditFormat("$number$");
        bizMaterialBox.setDisplayFormat("$number$");
        KDTDefaultCellEditor bizMaterialCellEditor = new KDTDefaultCellEditor((IKDEditor)bizMaterialBox);
        this.getDetailTable().getColumn(TB_MATERIAL_NUMBER).setEditor((ICellEditor)bizMaterialCellEditor);
        ObjectValueRender bizMaterialOVR = new ObjectValueRender();
        bizMaterialOVR.setFormat((IDataFormat)new BizDataFormat("$number$"));
        this.getDetailTable().getColumn(TB_MATERIAL_NUMBER).setRenderer((IBasicRender)bizMaterialOVR);
        this.initEntryUnitF7();
        UIHelper.registerProjectF7((KDBizPromptBox)this.getMainBizOrg(), null, (KDTable)this.getDetailTable(), (String)TB_PROJECT);
        UIHelper.registerTrackNumberF7((KDBizPromptBox)this.getMainBizOrg(), null, (KDTable)this.getDetailTable(), (String)TB_PROJECT, (String)TB_TRACKNO, (boolean)false);
        KDBizPromptBox prmtCurrency = new KDBizPromptBox();
        prmtCurrency.setQueryInfo("com.kingdee.eas.basedata.assistant.app.F7CurrencyQuery");
        prmtCurrency.setEditable(false);
        prmtCurrency.setDisplayFormat("$name$");
        prmtCurrency.setEditFormat("$number$");
        KDTDefaultCellEditor currencyEditor = new KDTDefaultCellEditor((IKDEditor)prmtCurrency);
        this.getDetailTable().getColumn(TB_CURRENCY).setEditor((ICellEditor)currencyEditor);
        KDBizPromptBox prmtPurOrgUnitEntry = new KDBizPromptBox();
        prmtPurOrgUnitEntry.setQueryInfo("com.kingdee.eas.basedata.org.app.PurchaseOrgUnitQuery");
        prmtPurOrgUnitEntry.setDisplayFormat("$name$");
        prmtPurOrgUnitEntry.setEditFormat("$number$");
        prmtPurOrgUnitEntry.setCommitFormat(TB_NUMBER);
        view = new EntityViewInfo();
        filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("cu.id", (Object)cuID, CompareType.EQUALS));
        view.setFilter(filterInfo);
        prmtPurOrgUnitEntry.setEntityViewInfo(view);
        KDTDefaultCellEditor prmtPurOrgCellEditor = new KDTDefaultCellEditor((IKDEditor)prmtPurOrgUnitEntry);
        this.getDetailTable().getColumn(TB_PURCHASEORGUNIT).setEditor((ICellEditor)prmtPurOrgCellEditor);
        KDFormattedTextField qtyTxtField = new KDFormattedTextField();
        qtyTxtField.setDataType(1);
        qtyTxtField.setNegatived(false);
        qtyTxtField.setMaximumIntegerDigits(12);
        KDTDefaultCellEditor qtyCellEditor = new KDTDefaultCellEditor((JTextField)qtyTxtField);
        this.getDetailTable().getColumn(TB_REQUESTQTY).setEditor((ICellEditor)qtyCellEditor);
        this.getDetailTable().getColumn(TB_QTY).setEditor((ICellEditor)qtyCellEditor);
        KDFormattedTextField amountTxtField = new KDFormattedTextField();
        amountTxtField.setDataType(1);
        amountTxtField.setSupportedEmpty(true);
        KDTDefaultCellEditor amountCellEditor = new KDTDefaultCellEditor((JTextField)amountTxtField);
        this.getDetailTable().getColumn(TB_PRICE).setEditor((ICellEditor)amountCellEditor);
        this.getDetailTable().getColumn(TB_TAXPRICE).setEditor((ICellEditor)amountCellEditor);
        this.getDetailTable().getColumn(TB_AMOUNT).setEditor((ICellEditor)amountCellEditor);
        KDDatePicker datePicker = new KDDatePicker();
        this.getDetailTable().getColumn(TB_REQUIREMENTDATE).setEditor((ICellEditor)new KDTDefaultCellEditor(datePicker));
        this.getDetailTable().getColumn(TB_REQUIREMENTDATE).getStyleAttributes().setNumberFormat(SCMClientUtils.strDateFormat);
    }

    private void initEntryUnitF7() {
        KDBizPromptBox bizUnitBox = null;
        int num = MATERIALUNITTAB.length;
        for (int i = 0; i < num; ++i) {
            bizUnitBox = new KDBizPromptBox();
            bizUnitBox.setEditFormat("$number$");
            bizUnitBox.setDisplayFormat("$name$");
            bizUnitBox.setCommitFormat("$number$");
            this.getDetailTable().getColumn(TB_UNIT).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)bizUnitBox));
            bizUnitBox.addDataChangeListener(new DataChangeListener(){

                public void dataChanged(DataChangeEvent e) {
                    try {
                        SCMClientUtils.setMultiToMeasureUnit((KDBizPromptBox)((KDBizPromptBox)e.getSource()));
                    }
                    catch (Exception ex) {
                        PurRequestBatchEditUI.this.handUIException(ex);
                    }
                }
            });
            bizUnitBox.addCommitListener(new CommitListener(){

                public void willCommit(CommitEvent e) {
                    try {
                        PurRequestBatchEditUI.this.registerUnit();
                    }
                    catch (Exception exc) {
                        PurRequestBatchEditUI.this.handUIException(exc);
                    }
                }
            });
            bizUnitBox.addSelectorListener(new SelectorListener(){

                public void willShow(SelectorEvent e) {
                    try {
                        PurRequestBatchEditUI.this.registerUnit();
                    }
                    catch (Exception exc) {
                        PurRequestBatchEditUI.this.handUIException(exc);
                    }
                }
            });
        }
    }

    private void registerUnit() {
        int rowIndex = this.getDetailTable().getSelectManager().getActiveRowIndex();
        if (rowIndex >= 0) {
            MaterialInfo materialInfo = (MaterialInfo)this.getDetailTable().getRow(rowIndex).getCell(TB_MATERIAL_NUMBER).getValue();
            ICellEditor cellGEditor = this.getDetailTable().getColumn(TB_UNIT).getEditor();
            if (cellGEditor != null) {
                KDBizPromptBox bizUnitBox = (KDBizPromptBox)cellGEditor.getComponent();
                if (materialInfo != null) {
                    bizUnitBox.setQueryInfo("com.kingdee.eas.basedata.master.material.app.F7MultiMeasureUnitQuery");
                    SCMClientUtils.setF7MeasureUnit((KDBizPromptBox)bizUnitBox, (String)materialInfo.getId().toString());
                    bizUnitBox.getQueryAgent().resetRuntimeEntityView();
                } else {
                    bizUnitBox.setQueryInfo("com.kingdee.eas.basedata.assistant.app.F7MeasureUnitQuery");
                    bizUnitBox.getQueryAgent().resetRuntimeEntityView();
                }
            }
        }
    }

    protected boolean checkForMaterialAndPurchase(int rowIndex, String materialId, String orgId, boolean isMaterial) {
        boolean isSuccess = true;
        try {
            MaterialPurchasingInfo info;
            if (materialId != null && orgId != null && ((info = MaterialPurchasingFactory.getRemoteInstance().getPurchasingInfo(materialId, orgId)) == null || info.getStatus().getValue() != 1)) {
                isSuccess = false;
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.scm.sm.pur.PurUIResource", (String)"Material_Purchase_Not"));
            }
        }
        catch (BOSException bex) {
            this.handleException((Exception)((Object)bex));
        }
        catch (EASBizException ex) {
            this.handleException((Exception)((Object)ex));
        }
        return isSuccess;
    }

    @Override
    protected List<String> getLockColumn() {
        ArrayList<String> lockColumn = new ArrayList<String>();
        lockColumn.add(TB_NUMBER);
        lockColumn.add(TB_BASESTATUS);
        lockColumn.add(TB_SEQ);
        lockColumn.add(TB_MATERIAL_NUMBER);
        lockColumn.add(TB_MATERIAL_NAME);
        lockColumn.add(TB_MATERIAL_MODEL);
        lockColumn.add(TB_ID);
        lockColumn.add(TB_ENTRYID);
        lockColumn.add(TB_COMPANYORGUNIT);
        lockColumn.add(TB_REQADMINORGUNIT);
        lockColumn.add(TB_CURRENCY);
        lockColumn.add(TB_TAXRATE);
        return lockColumn;
    }

    @Override
    protected List<String> getHideColumn() {
        ArrayList<String> hideColumn = new ArrayList<String>();
        hideColumn.add(TB_ID);
        hideColumn.add(TB_ENTRYID);
        hideColumn.add(TB_COMPANYORGUNIT);
        return hideColumn;
    }

    @Override
    protected List<String> getRequiredColumn() {
        ArrayList<String> requiredColumn = new ArrayList<String>();
        requiredColumn.add(TB_UNIT);
        requiredColumn.add(TB_PURCHASEORGUNIT);
        requiredColumn.add(TB_REQUIREMENTDATE);
        return requiredColumn;
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return PurRequestFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
    }

    @Override
    protected ICoreBillEntryBase getBizEntryInterface() throws Exception {
        return PurRequestEntryFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
    }

    protected IPurRequestBatchEditFacade getPurRequestFacadeInterface() throws Exception {
        return PurRequestBatchEditFacadeFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
    }

    @Override
    protected String getEntryIDName() {
        return TB_ENTRYID;
    }

    @Override
    protected String getEntryIDColumnName() {
        return TB_ENTRYID;
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Company;
    }

    @Override
    protected void registerTableRelation() {
        super.registerTableRelation();
        this.tableToBillRelation.put(TB_ID, TB_ID);
        this.tableToBillRelation.put(TB_NUMBER, TB_NUMBER);
        this.tableToBillRelation.put(TB_BASESTATUS, TB_BASESTATUS);
        this.tableToBillRelation.put(TB_COMPANYORGUNIT, TB_COMPANYORGUNIT);
        this.tableToBillRelation.put(TB_ISINTAX, TB_ISINTAX);
        this.tableToEntryRelation.put(TB_ENTRYID, TB_ID);
        this.tableToEntryRelation.put(TB_SEQ, TB_SEQ);
        this.tableToEntryRelation.put(TB_MATERIAL_NUMBER, "material");
        this.tableToEntryRelation.put(TB_MATERIAL_NAME, "materialName");
        this.tableToEntryRelation.put(TB_MATERIAL_MODEL, "noNumMaterialModel");
        this.tableToEntryRelation.put(TB_UNIT, TB_UNIT);
        this.tableToEntryRelation.put(TB_REQUESTQTY, TB_REQUESTQTY);
        this.tableToEntryRelation.put(TB_QTY, TB_QTY);
        this.tableToEntryRelation.put(TB_PRICE, TB_PRICE);
        this.tableToEntryRelation.put(TB_TAXRATE, TB_TAXRATE);
        this.tableToEntryRelation.put(TB_TAXPRICE, TB_TAXPRICE);
        this.tableToEntryRelation.put(TB_AMOUNT, TB_AMOUNT);
        this.tableToEntryRelation.put(TB_PURCHASEORGUNIT, TB_PURCHASEORGUNIT);
        this.tableToEntryRelation.put(TB_PROJECT, TB_PROJECT);
        this.tableToEntryRelation.put(TB_TRACKNO, TB_TRACKNO);
        this.tableToEntryRelation.put(TB_REQUIREMENTDATE, TB_REQUIREMENTDATE);
        this.tableToEntryRelation.put(TB_CURRENCY, TB_CURRENCY);
        this.tableToEntryRelation.put(TB_REQADMINORGUNIT, TB_REQADMINORGUNIT);
    }

    @Override
    protected SelectorItemCollection getBillSelectors() {
        SelectorItemCollection sic = super.getBillSelectors();
        sic.add(new SelectorItemInfo(TB_NUMBER));
        sic.add(new SelectorItemInfo(TB_BASESTATUS));
        sic.add(new SelectorItemInfo("companyOrgUnit.id"));
        sic.add(new SelectorItemInfo("companyOrgUnit.number"));
        sic.add(new SelectorItemInfo("companyOrgUnit.name"));
        sic.add(new SelectorItemInfo("billType"));
        sic.add(new SelectorItemInfo("bizType"));
        sic.add(new SelectorItemInfo("purchaseType"));
        sic.add(new SelectorItemInfo("bizDate"));
        sic.add(new SelectorItemInfo("isInTax"));
        sic.add(new SelectorItemInfo("isPriceInTax"));
        sic.add(new SelectorItemInfo("totalAmount"));
        sic.add(new SelectorItemInfo("localTotalAmount"));
        sic.add(new SelectorItemInfo("totalTax"));
        sic.add(new SelectorItemInfo("totalTaxAmount"));
        sic.add(new SelectorItemInfo("localTotalTaxAmount"));
        return sic;
    }

    @Override
    protected SelectorItemCollection getEntrySelectors() {
        SelectorItemCollection sic = super.getEntrySelectors();
        sic.add(new SelectorItemInfo("storageOrgUnit.id"));
        sic.add(new SelectorItemInfo("storageOrgUnit.number"));
        sic.add(new SelectorItemInfo("storageOrgUnit.name"));
        sic.add(new SelectorItemInfo("adminOrgUnit.id"));
        sic.add(new SelectorItemInfo("adminOrgUnit.number"));
        sic.add(new SelectorItemInfo("adminOrgUnit.name"));
        sic.add(new SelectorItemInfo("reqAdminOrgUnit.id"));
        sic.add(new SelectorItemInfo("reqAdminOrgUnit.number"));
        sic.add(new SelectorItemInfo("reqAdminOrgUnit.name"));
        sic.add(new SelectorItemInfo("material.id"));
        sic.add(new SelectorItemInfo(TB_MATERIAL_NUMBER));
        sic.add(new SelectorItemInfo(TB_MATERIAL_NAME));
        sic.add(new SelectorItemInfo("material.pricePrecision"));
        sic.add(new SelectorItemInfo("materialName"));
        sic.add(new SelectorItemInfo("noNumMaterialModel"));
        sic.add(new SelectorItemInfo("unit.id"));
        sic.add(new SelectorItemInfo("unit.number"));
        sic.add(new SelectorItemInfo("unit.name"));
        sic.add(new SelectorItemInfo("unit.qtyPrecision"));
        sic.add(new SelectorItemInfo(TB_REQUESTQTY));
        sic.add(new SelectorItemInfo(TB_QTY));
        sic.add(new SelectorItemInfo(TB_PRICE));
        sic.add(new SelectorItemInfo(TB_TAXPRICE));
        sic.add(new SelectorItemInfo(TB_AMOUNT));
        sic.add(new SelectorItemInfo("purchaseOrgUnit.id"));
        sic.add(new SelectorItemInfo("purchaseOrgUnit.number"));
        sic.add(new SelectorItemInfo("purchaseOrgUnit.name"));
        sic.add(new SelectorItemInfo("project.id"));
        sic.add(new SelectorItemInfo("project.number"));
        sic.add(new SelectorItemInfo("project.name"));
        sic.add(new SelectorItemInfo("trackNo.id"));
        sic.add(new SelectorItemInfo("trackNo.number"));
        sic.add(new SelectorItemInfo("trackNo.name"));
        sic.add(new SelectorItemInfo(TB_REQUIREMENTDATE));
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("currency.number"));
        sic.add(new SelectorItemInfo("currency.name"));
        sic.add(new SelectorItemInfo("currency.precision"));
        sic.add(new SelectorItemInfo("rowType.id"));
        sic.add(new SelectorItemInfo("rowType.number"));
        sic.add(new SelectorItemInfo("rowType.name"));
        sic.add(new SelectorItemInfo("rowType.precision"));
        sic.add(new SelectorItemInfo("rowType.destinationType"));
        sic.add(new SelectorItemInfo("rowType.isHasMaterialNumber"));
        sic.add(new SelectorItemInfo("rowType.requestOrgType"));
        sic.add(new SelectorItemInfo("baseUnit.id"));
        sic.add(new SelectorItemInfo("baseUnit.number"));
        sic.add(new SelectorItemInfo("baseUnit.name"));
        sic.add(new SelectorItemInfo("baseUnit.qtyPrecision"));
        sic.add(new SelectorItemInfo("baseQty"));
        sic.add(new SelectorItemInfo("assistUnit.id"));
        sic.add(new SelectorItemInfo("assistUnit.number"));
        sic.add(new SelectorItemInfo("assistUnit.name"));
        sic.add(new SelectorItemInfo("assistUnit.qtyPrecision"));
        sic.add(new SelectorItemInfo("assistQty"));
        sic.add(new SelectorItemInfo("associateQty"));
        sic.add(new SelectorItemInfo("tax"));
        sic.add(new SelectorItemInfo(TB_TAXRATE));
        sic.add(new SelectorItemInfo(TB_TAXPRICE));
        sic.add(new SelectorItemInfo("taxAmount"));
        sic.add(new SelectorItemInfo("discountRate"));
        sic.add(new SelectorItemInfo("discountAmount"));
        sic.add(new SelectorItemInfo(TB_AMOUNT));
        sic.add(new SelectorItemInfo("actualPrice"));
        sic.add(new SelectorItemInfo("actualTaxPrice"));
        sic.add(new SelectorItemInfo("proposeDeliveryDate"));
        sic.add(new SelectorItemInfo("supplier.id"));
        sic.add(new SelectorItemInfo("supplier.number"));
        sic.add(new SelectorItemInfo("supplier.name"));
        sic.add(new SelectorItemInfo("assistProperty.id"));
        sic.add(new SelectorItemInfo("assistProperty.number"));
        sic.add(new SelectorItemInfo("assistProperty.name"));
        sic.add(new SelectorItemInfo("localTax"));
        sic.add(new SelectorItemInfo("localTaxAmount"));
        sic.add(new SelectorItemInfo("localAmount"));
        return sic;
    }

    protected void cacheMmuPrecision(String materialId, String unitId) throws BOSException, EASBizException {
        IMultiMeasureUnit imultiUnit = MultiMeasureUnitFactory.getRemoteInstance();
        MultiMeasureUnitInfo multiUnitInfo = imultiUnit.getMultiUnit(materialId, unitId);
        if (multiUnitInfo != null) {
            this.purEntryVO.getMmuPrecisions().put(materialId + unitId, multiUnitInfo.getQtyPrecision());
        }
    }
}

