/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.pur.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTActiveCellEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTActiveCellListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.base.commonquery.client.IProcessor;
import com.kingdee.eas.base.commonquery.client.IPromptBoxFactory;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.scm.common.ReasonCodeInfo;
import com.kingdee.eas.basedata.scm.common.client.ReasonF7Until;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.FrameWorkException;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.batchaction.ActionLevelEnum;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchSelectionEntries;
import com.kingdee.eas.framework.client.CoreBillListUI;
import com.kingdee.eas.framework.query.QuickFilteringSupportItems;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.common.action.ActionProxy;
import com.kingdee.eas.scm.common.action.ActionProxyFactory;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.client.SCMPromptBoxFactory;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.sm.pur.IPurReturns;
import com.kingdee.eas.scm.sm.pur.IPurReturnsEntry;
import com.kingdee.eas.scm.sm.pur.PurReturnsEntryFactory;
import com.kingdee.eas.scm.sm.pur.PurReturnsEntryInfo;
import com.kingdee.eas.scm.sm.pur.PurReturnsFactory;
import com.kingdee.eas.scm.sm.pur.PurReturnsInfo;
import com.kingdee.eas.scm.sm.pur.client.AbstractPurReturnsListUI;
import com.kingdee.eas.scm.sm.pur.client.PurReturnsEditUI;
import com.kingdee.eas.scm.sm.pur.client.PurReturnsQueryUI;
import com.kingdee.eas.tools.datatask.DatataskParameter;
import com.kingdee.eas.tools.datatask.client.DatataskCaller;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import javax.swing.AbstractButton;

public class PurReturnsListUI
extends AbstractPurReturnsListUI {
    public static final String RES_PROMPT = "com.kingdee.eas.scm.sm.pur.PurReturnsResource";
    public static final String TB_BASESTATE = "baseStatus";
    public static final String TB_NUMBER = "number";
    CommonQueryDialog conditionDialog = null;
    PurReturnsQueryUI conditionPanel = null;
    private QuickFilteringSupportItems qfsi = new QuickFilteringSupportItems(true, true);

    protected QuickFilteringSupportItems getQuickFilteringSupport() {
        return this.qfsi;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initForm();
        this.setTableFreeze();
        this.tblMain.getGroupManager().setGroup(true);
        this.tblMain.getColumn("entries.assistQuantity").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.addKDTDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
            }
        });
        this.tblMain.repaint();
        String format = CtrlFormatUtilities.getDateFormatString();
        this.tblMain.getColumn("createTime").setEditor((ICellEditor)new KDTDefaultCellEditor(new KDDatePicker()));
        this.tblMain.getColumn("createTime").getStyleAttributes().setNumberFormat(format);
        this.tblMain.getColumn("modifyTime").setEditor((ICellEditor)new KDTDefaultCellEditor(new KDDatePicker()));
        this.tblMain.getColumn("modifyTime").getStyleAttributes().setNumberFormat(format);
        this.tblMain.getColumn("auditTime").setEditor((ICellEditor)new KDTDefaultCellEditor(new KDDatePicker()));
        this.tblMain.getColumn("auditTime").getStyleAttributes().setNumberFormat(format);
        this.btnSubmit.setVisible(true);
        this.btnSubmit.setEnabled(true);
        this.menuItemSubmit.setVisible(true);
        this.menuItemSubmit.setEnabled(true);
        this.actionExportData.setVisible(true);
    }

    public void actionExportData_actionPerformed(ActionEvent e) throws Exception {
        this.logUIOperation("LOG_EXPORT");
        ArrayList para = this.getExportParam();
        if (para == null || para.size() <= 0) {
            throw new FrameWorkException(FrameWorkException.EXPORTDATAPARANULL);
        }
        DatataskCaller dc = new DatataskCaller();
        dc.setParentComponent((Component)((Object)this));
        Context ctx = this.getMainOrgContext();
        dc.setMainOrgContext(ctx);
        dc.invoke(para, 1);
    }

    protected ArrayList getExportParam() {
        String solutionName;
        DatataskParameter param = new DatataskParameter();
        param.solutionName = solutionName = "eas.scm.purreturns";
        param.alias = EASResource.getString((String)RES_PROMPT, (String)"purreturns");
        param.datataskMode = 1;
        Hashtable<String, FilterInfo> hashtable = new Hashtable<String, FilterInfo>();
        hashtable.put("filter", this.mainQuery.getFilter());
        param.setContextParam(hashtable);
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        return paramList;
    }

    public String[] getMergeColumnKeys() {
        return new String[]{"id", TB_NUMBER, TB_BASESTATE, "bizType.name", "bizDate", "sourceBillType.name", "PurchaseOrgUnit.name", "purchaseGroup.name", "purchasePerson.name", "supplier.name", "currency.name", "exchangeRate", "processNode"};
    }

    private void setTableFreeze() {
        this.tblMain.getViewManager().setFreezeView(0, this.tblMain.getColumnIndex("bizType.name"));
    }

    private void initForm() {
        this.btnAudit.setIcon(EASResource.getIcon((String)"imgTbtn_auditing"));
        this.btnClose.setIcon(EASResource.getIcon((String)"imgTbtn_close"));
        this.btnUnClose.setIcon(EASResource.getIcon((String)"imgTbtn_fclose"));
        this.btnBlock.setIcon(EASResource.getIcon((String)"imgTbtn_freeze"));
        this.btnUnBlock.setIcon(EASResource.getIcon((String)"imgTbtn_ffreeze"));
        this.btnCancel.setIcon(EASResource.getIcon((String)"imgTbtn_blankout"));
        this.btnRevoke.setIcon(EASResource.getIcon((String)"imgTbtn_blankout"));
        this.kDMenuItemClose.setIcon(EASResource.getIcon((String)"imgTbtn_close"));
        this.kDMenuItemUnClose.setIcon(EASResource.getIcon((String)"imgTbtn_fclose"));
        this.kDMenuItemBlock.setIcon(EASResource.getIcon((String)"imgTbtn_freeze"));
        this.kDMenuItemUnBlock.setIcon(EASResource.getIcon((String)"imgTbtn_ffreeze"));
        this.kDMenuItemCancel.setIcon(EASResource.getIcon((String)"imgTbtn_blankout"));
        this.btnAuditResult.setVisible(false);
        this.tblMain.addKDTActiveCellListener(new KDTActiveCellListener(){

            public void activeCellChanged(KDTActiveCellEvent e) {
            }
        });
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected String getEditUIName() {
        return PurReturnsEditUI.class.getName();
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return PurReturnsFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
    }

    @Override
    public void actionClose_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String[] selIDs = SCMClientUtils.getSelectRowFieldValue((KDTable)this.tblMain, (String)this.getEntriesPKName());
        IObjectPK[] pks = SCMUtils.convertStringToObjectPK((String[])selIDs);
        this.checkClose(pks);
        IPurReturns iPurReturns = PurReturnsFactory.getRemoteInstance();
        try {
            Object reasonCodeInfo = ReasonF7Until.getReason((IUIWindow)ReasonF7Until.showClosedReasonUI((Map)this.getUIContext(), (IUIWindow)this.getUIWindow()));
            if (reasonCodeInfo == null) {
                SysUtil.abort();
            } else {
                int i;
                int num;
                Object[] reasonCodeInfos;
                if (reasonCodeInfo instanceof IObjectValue) {
                    reasonCodeInfos = new ReasonCodeInfo[selIDs.length];
                    num = selIDs.length;
                    for (i = 0; i < num; ++i) {
                        reasonCodeInfos[i] = (ReasonCodeInfo)reasonCodeInfo;
                    }
                    iPurReturns.closeWithReason(pks, (IObjectValue[])reasonCodeInfos);
                }
                if (reasonCodeInfo instanceof String) {
                    reasonCodeInfos = new String[selIDs.length];
                    num = selIDs.length;
                    for (i = 0; i < num; ++i) {
                        reasonCodeInfos[i] = (String)reasonCodeInfo;
                    }
                    iPurReturns.closeWithReason(pks, (String[])reasonCodeInfos);
                }
            }
            this.setMessageText(EASResource.getString((String)RES_PROMPT, (String)"prompt_close_success"));
            this.showMessage();
            this.refreshList();
        }
        catch (EASBizException ex) {
            this.handleException((Exception)((Object)ex));
        }
    }

    private void checkClose(IObjectPK[] pks) throws Exception {
        IPurReturnsEntry iEntry = PurReturnsEntryFactory.getRemoteInstance();
        IPurReturns iPur = PurReturnsFactory.getRemoteInstance();
        int size = pks.length;
        for (int i = 0; i < size; ++i) {
            PurReturnsEntryInfo tempEntryInfo = (PurReturnsEntryInfo)iEntry.getValue(pks[i]);
            PurReturnsInfo info = iPur.getPurReturnsInfo((IObjectPK)new ObjectUuidPK(tempEntryInfo.getParent().getId()));
            if ((info == null || info.getBaseStatus().equals((Object)BillBaseStatusEnum.AUDITED)) && !tempEntryInfo.getBaseStatus().equals((Object)EntryBaseStatusEnum.CLOSED)) continue;
            MsgBox.showError((String)EASResource.getString((String)RES_PROMPT, (String)"check_close"));
            SysUtil.abort();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionRevoke_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.checkCancel();
        super.actionRevoke_actionPerformed(e);
        String[] billIdlist = SCMClientUtils.filterDistnctID((String[])SCMClientUtils.getSelectRowFieldValue((KDTable)this.tblMain, (String)this.getKeyFieldName()));
        int count = billIdlist.length;
        if (count != 0) {
            try {
                this.setOprtState("REVOKE");
                int num = billIdlist.length;
                for (int j = 0; j < num; ++j) {
                    this.pubFireVOChangeListener(billIdlist[j]);
                }
                Object reasonCodeInfo = ReasonF7Until.getReason((IUIWindow)ReasonF7Until.showRevokedReasonUI((Map)this.getUIContext(), (IUIWindow)this.getUIWindow()));
                IObjectPK[] pks = new IObjectPK[count];
                if (reasonCodeInfo == null) {
                    SysUtil.abort();
                } else {
                    int i;
                    Object[] reasonCodeInfos;
                    if (reasonCodeInfo instanceof IObjectValue) {
                        reasonCodeInfos = new ReasonCodeInfo[count];
                        for (i = 0; i < count; ++i) {
                            pks[i] = new ObjectStringPK(billIdlist[i]);
                            reasonCodeInfos[i] = (ReasonCodeInfo)reasonCodeInfo;
                        }
                        ((IPurReturns)this.getBizInterface()).cancelWithReason(pks, (IObjectValue[])reasonCodeInfos);
                        this.setMessageText(EASResource.getString((String)RES_PROMPT, (String)"prompt_cancel_success"));
                        this.showMessage();
                        this.refreshList();
                    }
                    if (reasonCodeInfo instanceof String) {
                        reasonCodeInfos = new String[count];
                        for (i = 0; i < count; ++i) {
                            pks[i] = new ObjectStringPK(billIdlist[i]);
                            reasonCodeInfos[i] = (String)reasonCodeInfo;
                        }
                        ((IPurReturns)this.getBizInterface()).cancelWithReason(pks, (String[])reasonCodeInfos);
                        this.setMessageText(EASResource.getString((String)RES_PROMPT, (String)"prompt_cancel_success"));
                        this.showMessage();
                        this.refreshList();
                    }
                }
            }
            catch (Exception ex) {
                this.handleException(ex);
            }
            catch (Throwable t) {
                this.handUIException(t);
            }
            finally {
                this.setOprtState("RELEASEALL");
                try {
                    this.pubFireVOChangeListener(null);
                }
                catch (Throwable t) {
                    this.handUIException(t);
                }
            }
        }
    }

    private void checkCancel() {
        int size = this.tblMain.getSelectManager().size();
        for (int j = 0; j < size; ++j) {
            KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get(j);
            if (selectBlock == null) continue;
            int num = selectBlock.getEndRow();
            for (int i = selectBlock.getTop(); i <= num && i >= 0; ++i) {
                IRow row = this.tblMain.getRow(i);
                String baseStatus = row.getCell(TB_BASESTATE).getValue().toString();
                if (baseStatus.trim().equals(BillBaseStatusEnum.SUBMITED.toString())) continue;
                MsgBox.showError((String)EASResource.getString((String)RES_PROMPT, (String)"check_cancel"));
                SysUtil.abort();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.checkAudit();
        String[] billIdlist = SCMClientUtils.filterDistnctID((String[])SCMClientUtils.getSelectRowFieldValue((KDTable)this.tblMain, (String)this.getKeyFieldName()));
        SCMClientUtils.checkCurrentBillIsInActiveWorkFlow((String[])billIdlist);
        int count = billIdlist.length;
        if (count != 0) {
            IObjectPK[] pks = new IObjectPK[count];
            for (int i = 0; i < count; ++i) {
                pks[i] = new ObjectStringPK(billIdlist[i]);
            }
            try {
                this.setOprtState("AUDIT");
                int num = billIdlist.length;
                for (int j = 0; j < num; ++j) {
                    this.pubFireVOChangeListener(billIdlist[j]);
                }
                ((IPurReturns)this.getBizInterface()).audit(pks);
                this.setMessageText(EASResource.getString((String)RES_PROMPT, (String)"prompt_audit_success"));
                this.showMessage();
                this.refreshList();
            }
            catch (Exception ex) {
                this.handleException(ex);
            }
            catch (Throwable t) {
                this.handUIException(t);
            }
            finally {
                this.setOprtState("RELEASEALL");
                try {
                    this.pubFireVOChangeListener(null);
                }
                catch (Throwable t) {
                    this.handUIException(t);
                }
            }
        }
    }

    @Override
    public void actionBlock_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String[] selIDs = SCMClientUtils.getSelectRowFieldValue((KDTable)this.tblMain, (String)this.getEntriesPKName());
        super.actionBlock_actionPerformed(e);
        IObjectPK[] pks = SCMUtils.convertStringToObjectPK((String[])selIDs);
        this.checkBlock(pks);
        IPurReturns iPurReturns = PurReturnsFactory.getRemoteInstance();
        try {
            Object reasonCodeInfo = ReasonF7Until.getReason((IUIWindow)ReasonF7Until.showBlockedReasonUI((Map)this.getUIContext(), (IUIWindow)this.getUIWindow()));
            if (reasonCodeInfo == null) {
                SysUtil.abort();
            } else {
                int i;
                int num;
                Object[] reasonCodeInfos;
                if (reasonCodeInfo instanceof IObjectValue) {
                    reasonCodeInfos = new ReasonCodeInfo[selIDs.length];
                    num = selIDs.length;
                    for (i = 0; i < num; ++i) {
                        reasonCodeInfos[i] = (ReasonCodeInfo)reasonCodeInfo;
                    }
                    iPurReturns.blockWithReason(pks, (IObjectValue[])reasonCodeInfos);
                }
                if (reasonCodeInfo instanceof String) {
                    reasonCodeInfos = new String[selIDs.length];
                    num = selIDs.length;
                    for (i = 0; i < num; ++i) {
                        reasonCodeInfos[i] = (String)reasonCodeInfo;
                    }
                    iPurReturns.blockWithReason(pks, (String[])reasonCodeInfos);
                }
            }
            this.setMessageText(EASResource.getString((String)RES_PROMPT, (String)"prompt_block_success"));
            this.showMessage();
            this.refreshList();
        }
        catch (EASBizException ex) {
            this.handleException((Exception)((Object)ex));
        }
    }

    private void checkBlock(IObjectPK[] pks) throws Exception {
        IPurReturnsEntry iEntry = PurReturnsEntryFactory.getRemoteInstance();
        IPurReturns iPur = PurReturnsFactory.getRemoteInstance();
        int size = pks.length;
        for (int i = 0; i < size; ++i) {
            PurReturnsEntryInfo tempEntryInfo = (PurReturnsEntryInfo)iEntry.getValue(pks[i]);
            PurReturnsInfo info = iPur.getPurReturnsInfo((IObjectPK)new ObjectUuidPK(tempEntryInfo.getParent().getId()));
            if (info.getBaseStatus().equals((Object)BillBaseStatusEnum.AUDITED) && tempEntryInfo.getBaseStatus().equals((Object)EntryBaseStatusEnum.AUDITED)) continue;
            MsgBox.showError((String)EASResource.getString((String)RES_PROMPT, (String)"check_block"));
            SysUtil.abort();
        }
    }

    @Override
    public void actionUnBlock_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String[] selIDs = SCMClientUtils.getSelectRowFieldValue((KDTable)this.tblMain, (String)this.getEntriesPKName());
        super.actionClose_actionPerformed(e);
        IObjectPK[] pks = SCMUtils.convertStringToObjectPK((String[])selIDs);
        this.checkUnBlock(pks);
        IPurReturns iPurReturns = PurReturnsFactory.getRemoteInstance();
        try {
            iPurReturns.unBlock(pks);
            this.setMessageText(EASResource.getString((String)RES_PROMPT, (String)"prompt_unBlock_success"));
            this.showMessage();
            this.refreshList();
        }
        catch (EASBizException ex) {
            this.handleException((Exception)((Object)ex));
        }
    }

    protected IMetaDataPK getTDQueryPK() {
        return new MetaDataPK("com.kingdee.eas.scm.sm.pur.PurReturnsPrintQuery");
    }

    protected String getTDFileName() {
        return "/SCM/SM/PurReturns";
    }

    private void checkUnBlock(IObjectPK[] pks) throws Exception {
        IPurReturnsEntry iEntry = PurReturnsEntryFactory.getRemoteInstance();
        int size = pks.length;
        for (int i = 0; i < size; ++i) {
            PurReturnsEntryInfo tempEntryInfo = (PurReturnsEntryInfo)iEntry.getValue(pks[i]);
            if (tempEntryInfo.getBaseStatus().equals((Object)EntryBaseStatusEnum.BLOCKED)) continue;
            MsgBox.showError((String)EASResource.getString((String)RES_PROMPT, (String)"check_unblock"));
            SysUtil.abort();
        }
    }

    public CommonQueryDialog initCommonQueryDialog() {
        if (this.conditionDialog == null) {
            if (this.mainQuery == null) {
                this.mainQuery = new EntityViewInfo();
            }
            this.conditionDialog = super.initCommonQueryDialog();
            this.conditionDialog.setWidth(540);
            this.conditionDialog.setHeight(315);
            try {
                SCMPromptBoxFactory scmF7Factory = new SCMPromptBoxFactory(this.getFilterUI(), this.getMainBizOrgType());
                this.conditionDialog.setPromptBoxFactory((IPromptBoxFactory)scmF7Factory);
                this.conditionDialog.addUserPanel((KDPanel)this.getFilterUI());
                this.conditionDialog.setProcessor((IProcessor)((PurReturnsQueryUI)this.getFilterUI()).getQueryProcessor());
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
        return this.conditionDialog;
    }

    protected CustomerQueryPanel getFilterUI() throws Exception {
        if (this.conditionPanel == null) {
            this.conditionPanel = new PurReturnsQueryUI();
        }
        return this.conditionPanel;
    }

    protected boolean initDefaultFilter() {
        return true;
    }

    public KDPanel getConditionPanel() throws Exception {
        if (this.conditionPanel == null) {
            this.conditionPanel = new PurReturnsQueryUI();
        }
        return this.conditionPanel;
    }

    @Override
    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkRemove();
        super.actionRemove_actionPerformed(e);
    }

    private void checkRemove() {
        int size = this.tblMain.getSelectManager().size();
        for (int j = 0; j < size; ++j) {
            KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get(j);
            if (selectBlock == null) continue;
            int num = selectBlock.getEndRow();
            for (int i = selectBlock.getTop(); i <= num && i >= 0; ++i) {
                IRow row = this.tblMain.getRow(i);
                String baseStatus = row.getCell(TB_BASESTATE).getValue().toString();
                if (baseStatus.trim().equalsIgnoreCase(BillBaseStatusEnum.SUBMITED.toString()) || baseStatus.trim().equalsIgnoreCase(BillBaseStatusEnum.TEMPORARILYSAVED.toString())) continue;
                MsgBox.showError((String)EASResource.getString((String)RES_PROMPT, (String)"check_delete"));
                SysUtil.abort();
            }
        }
    }

    private void logUIOperation(String key) {
        String operName = SCMClientUtils.getResource((String)key);
        IObjectPK pk = LogUtil.beginLog(null, (String)operName, (BOSObjectType)new PurReturnsInfo().getBOSType(), null, (String)operName);
        LogUtil.afterLog(null, (IObjectPK)pk);
    }

    public void actionImportData_actionPerformed(ActionEvent e) throws Exception {
        this.logUIOperation("LOG_IMPORT");
        super.actionImportData_actionPerformed(e);
    }

    protected IObjectPK getOrgPK(ItemAction action) {
        ObjectUuidPK pk = null;
        if (action != null && "ActionImportData".equals(action.getClass().getSimpleName())) {
            if (this.getOrgUnitInfo() != null && this.getOrgUnitInfo().getId() != null) {
                pk = new ObjectUuidPK(this.getOrgUnitInfo().getId());
                return pk;
            }
            return super.getOrgPK(action);
        }
        return super.getOrgPK(action);
    }

    protected ArrayList getImportParam() {
        String solutionName;
        DatataskParameter param = new DatataskParameter();
        param.solutionName = solutionName = "eas.scm.purreturns";
        param.alias = EASResource.getString((String)RES_PROMPT, (String)"purreturns");
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        return paramList;
    }

    @Override
    public SelectorItemCollection getBOTPSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("billType.id"));
        sic.add(new SelectorItemInfo("billType.name"));
        sic.add(new SelectorItemInfo("billType.number"));
        sic.add(new SelectorItemInfo("bizType.id"));
        sic.add(new SelectorItemInfo("bizType.name"));
        sic.add(new SelectorItemInfo("bizType.number"));
        sic.add(new SelectorItemInfo("supplier.id"));
        sic.add(new SelectorItemInfo("supplier.name"));
        sic.add(new SelectorItemInfo("supplier.number"));
        sic.add(new SelectorItemInfo("PurchaseOrgUnit.id"));
        sic.add(new SelectorItemInfo("PurchaseOrgUnit.name"));
        sic.add(new SelectorItemInfo("PurchaseOrgUnit.number"));
        sic.add(new SelectorItemInfo("purchaseGroup.id"));
        sic.add(new SelectorItemInfo("purchaseGroup.name"));
        sic.add(new SelectorItemInfo("purchaseGroup.number"));
        sic.add(new SelectorItemInfo("purchasePerson.id"));
        sic.add(new SelectorItemInfo("purchasePerson.name"));
        sic.add(new SelectorItemInfo("purchasePerson.number"));
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("currency.name"));
        sic.add(new SelectorItemInfo("currency.number"));
        sic.add(new SelectorItemInfo("entries.material.id"));
        sic.add(new SelectorItemInfo("entries.material.name"));
        sic.add(new SelectorItemInfo("entries.material.number"));
        sic.add(new SelectorItemInfo("entries.material.model"));
        sic.add(new SelectorItemInfo("entries.material.pricePrecision"));
        sic.add(new SelectorItemInfo("entries.baseUnit.id"));
        sic.add(new SelectorItemInfo("entries.baseUnit.name"));
        sic.add(new SelectorItemInfo("entries.baseUnit.number"));
        sic.add(new SelectorItemInfo("entries.unit.id"));
        sic.add(new SelectorItemInfo("entries.unit.name"));
        sic.add(new SelectorItemInfo("entries.unit.number"));
        sic.add(new SelectorItemInfo("entries.assistUnit.id"));
        sic.add(new SelectorItemInfo("entries.assistUnit.name"));
        sic.add(new SelectorItemInfo("entries.assistUnit.number"));
        sic.add(new SelectorItemInfo("entries.assistProperty.id"));
        sic.add(new SelectorItemInfo("entries.assistProperty.name"));
        sic.add(new SelectorItemInfo("entries.assistProperty.number"));
        sic.add(new SelectorItemInfo("entries.storageOrgUnit.id"));
        sic.add(new SelectorItemInfo("entries.storageOrgUnit.name"));
        sic.add(new SelectorItemInfo("entries.storageOrgUnit.number"));
        sic.add(new SelectorItemInfo("entries.warehouse.id"));
        sic.add(new SelectorItemInfo("entries.warehouse.name"));
        sic.add(new SelectorItemInfo("entries.warehouse.number"));
        sic.add(new SelectorItemInfo("entries.stocker.id"));
        sic.add(new SelectorItemInfo("entries.stocker.name"));
        sic.add(new SelectorItemInfo("entries.stocker.number"));
        sic.add(new SelectorItemInfo("entries.location.id"));
        sic.add(new SelectorItemInfo("entries.location.name"));
        sic.add(new SelectorItemInfo("entries.location.number"));
        sic.add(new SelectorItemInfo("entries.reasonCode.id"));
        sic.add(new SelectorItemInfo("entries.reasonCode.name"));
        sic.add(new SelectorItemInfo("entries.reasonCode.number"));
        sic.add(new SelectorItemInfo("entries.companyOrgUnit.id"));
        sic.add(new SelectorItemInfo("entries.companyOrgUnit.name"));
        sic.add(new SelectorItemInfo("entries.companyOrgUnit.number"));
        sic.add(new SelectorItemInfo("entries.returnsReason.id"));
        sic.add(new SelectorItemInfo("entries.returnsReason.name"));
        sic.add(new SelectorItemInfo("entries.returnsReason.number"));
        sic.add(new SelectorItemInfo("entries.basePrice"));
        sic.add(new SelectorItemInfo("entries.taxRate"));
        sic.add(new SelectorItemInfo("entries.taxPrice"));
        sic.add(new SelectorItemInfo("entry.material.pricePrecision"));
        return sic;
    }

    protected void getRowSetBeforeFillTable(IRowSet rowSet) {
        int ratePre = 2;
        int amountPre = 2;
        String[] QTY_COLUMNS = new String[]{"entries.returnsQty", "entries.nonReturnsQty", "entries.invoiceQty", "entries.nonInvoiceQty", "entries.hadReturnsQty"};
        String[] ASSISQTY_COLUMNS = new String[]{"entries.assistQuantity"};
        String[] PRICE_COLUMNS = new String[]{"entries.basePrice", "entries.taxPrice"};
        String[] Amount_Columns = new String[]{"entries.amount", "entries.taxAmount", "entries.totalReturnAmt", "entries.totalTaxAmount", "entries.invoiceAmount"};
        String[] RATE_COLUMNS = new String[]{"entries.taxRate"};
        try {
            rowSet.beforeFirst();
            while (rowSet.next()) {
                amountPre = rowSet.getInt("currency.precision");
                SCMClientUtils.iniColumnsPrecision((int)this.qtyPrecision, (String[])QTY_COLUMNS, (IRowSet)rowSet);
                SCMClientUtils.iniColumnsPrecision((int)this.qtyPrecision, (String[])ASSISQTY_COLUMNS, (IRowSet)rowSet);
                SCMClientUtils.iniColumnsPrecision((int)this.pricePrecision, (String[])PRICE_COLUMNS, (IRowSet)rowSet);
                SCMClientUtils.iniColumnsPrecision((int)amountPre, (String[])Amount_Columns, (IRowSet)rowSet);
                SCMClientUtils.iniColumnsPrecision((int)ratePre, (String[])RATE_COLUMNS, (IRowSet)rowSet);
            }
        }
        catch (SQLException ex) {
            this.handUIException(ex);
        }
    }

    protected boolean isSupportDynQuery() {
        return true;
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("currency.precision"));
        sic.add(new SelectorItemInfo("entries.baseQty"));
        return sic;
    }

    public String[] getAmountColumns() {
        return new String[]{"entries.amount", "entries.taxAmount", "totalReturnsAmt", "entries.totalTaxAmount", "entries.invoiceAmount"};
    }

    protected String[] getQtyColumns() throws Exception {
        return new String[]{"returnsQty", "entries.nonReturnsQty", "entries.invoiceQty", "entries.nonInvoiceQty", "entries.hadReturnsQty", "entries.assistQuantity"};
    }

    protected String[] getPriceColumns() throws Exception {
        return new String[]{"entries.basePrice", "entries.taxPrice"};
    }

    protected void logPrint() {
        this.logUIOperation("LOG_PRINT");
    }

    @Override
    public OrgType getMainBizOrgType() {
        return OrgType.Purchase;
    }

    protected String getPropertyOfBizOrg(OrgType orgType) {
        if (orgType.equals((Object)OrgType.Purchase)) {
            return "purchaseOrgUnit.id";
        }
        if (orgType.equals((Object)OrgType.Company)) {
            return "companyOrgUnit.id";
        }
        if (orgType.equals((Object)OrgType.Storage)) {
            return "storageOrgUnit.id";
        }
        return null;
    }

    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.PURCHASINGMANAGEMENT;
    }

    protected String[] getExColumns() throws Exception {
        return new String[]{"exchangeRate"};
    }

    public void initBatchActions() throws BOSException {
        this.actionManager.setClzIBizFactory(ActionLevelEnum.HEAD, PurReturnsFactory.class);
        this.actionManager.setClzIBizFactory(ActionLevelEnum.ENTRY, PurReturnsEntryFactory.class);
        this.getTableSelectionHelper().setTableProperty((CoreBillListUI)this, this.mainQueryPK, this.tblMain, "id", "entries.id", TB_NUMBER, "entries.seq", "purchaseOrgUnit.id");
        ActionProxy actionProxy = ActionProxyFactory.createActionProxy((BatchActionEnum)BatchActionEnum.CLOSE, (ItemAction)this.actionClose, (String)"closeWithReason");
        this.actionManager.registerBatchAction(actionProxy, "actionClose");
        actionProxy.bindTo((AbstractButton)this.btnClose);
        actionProxy.bindTo((AbstractButton)this.kDMenuItemClose);
        actionProxy = ActionProxyFactory.createActionProxy((BatchActionEnum)BatchActionEnum.UNCLOSE, (ItemAction)this.actionUnClose, (String)"unClose");
        this.actionManager.registerBatchAction(actionProxy, "actionUnClose");
        actionProxy.bindTo((AbstractButton)this.btnUnClose);
        actionProxy.bindTo((AbstractButton)this.kDMenuItemUnClose);
        actionProxy = ActionProxyFactory.createActionProxy((BatchActionEnum)BatchActionEnum.FREEZE, (ItemAction)this.actionBlock, (String)"blockWithReason");
        this.actionManager.registerBatchAction(actionProxy, "actionBlock");
        actionProxy.bindTo((AbstractButton)this.btnBlock);
        actionProxy.bindTo((AbstractButton)this.kDMenuItemBlock);
        actionProxy = ActionProxyFactory.createActionProxy((BatchActionEnum)BatchActionEnum.UNFREEZE, (ItemAction)this.actionUnBlock, (String)"unBlock");
        this.actionManager.registerBatchAction(actionProxy, "actionUnBlock");
        actionProxy.bindTo((AbstractButton)this.btnUnBlock);
        actionProxy.bindTo((AbstractButton)this.kDMenuItemUnBlock);
        actionProxy = ActionProxyFactory.createActionProxy((BatchActionEnum)BatchActionEnum.CANCEL, (ItemAction)this.actionCancel, (String)"cancelWithReason");
        this.actionManager.registerBatchAction(actionProxy, "actionCancel");
        actionProxy.bindTo((AbstractButton)this.btnRevoke);
        actionProxy.bindTo((AbstractButton)this.kDMenuItemCancel);
        super.initBatchActions();
    }

    public boolean isSupportedBatchActions() {
        return true;
    }

    public boolean beforeAction(BatchActionEnum bizAction, BatchSelectionEntries selectionEntries, ActionEvent event) {
        this.getMainOrgContext().put((Object)"CONTEXT_KEY_ISBATCHACTION", (Object)Boolean.FALSE);
        boolean result = super.beforeAction(bizAction, selectionEntries, event);
        if (bizAction.equals((Object)BatchActionEnum.CLOSE) ? selectionEntries == null : (bizAction.equals((Object)BatchActionEnum.FREEZE) ? selectionEntries == null : bizAction.equals((Object)BatchActionEnum.CANCEL) && selectionEntries == null)) {
            return false;
        }
        return result;
    }

    public String getsourceBillEntryId() {
        return "entries.sourceBillEntryId";
    }

    protected String getBaseQtyName() throws Exception {
        return "returnsQty";
    }

    protected String getBillEntryName() {
        return "entries";
    }
}

