/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.pur.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.basedata.scm.sm.pur.IPurchasePerson;
import com.kingdee.eas.basedata.scm.sm.pur.PurchaseGroupInfo;
import com.kingdee.eas.basedata.scm.sm.pur.PurchasePersonCollection;
import com.kingdee.eas.basedata.scm.sm.pur.PurchasePersonFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.AbstractCoreBaseInfo;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.EventListener;
import java.util.List;
import javax.swing.JComponent;

public final class SDSMUtil {
    public static boolean isPurParamPUR(String companyInfoID, String key, boolean defaultValue) throws EASBizException, BOSException {
        ObjectUuidPK pk;
        boolean isPurParam = defaultValue;
        IParamControl ipc = ParamControlFactory.getRemoteInstance();
        String strPurParam = ipc.getParamValue((IObjectPK)(pk = new ObjectUuidPK(companyInfoID)), key);
        if (strPurParam != null && strPurParam.trim().length() != 0 && strPurParam.trim().equalsIgnoreCase("true")) {
            isPurParam = true;
        }
        if (strPurParam != null && strPurParam.trim().length() != 0 && strPurParam.trim().equalsIgnoreCase("false")) {
            isPurParam = false;
        }
        return isPurParam;
    }

    public static void removeDataChangeListeners(JComponent owner) {
        EventListener[] listeners;
        if (owner != null && (listeners = owner.getListeners(DataChangeListener.class)) != null && listeners.length > 0) {
            EventListener event2 = null;
            for (EventListener event2 : listeners) {
                if (event2 == null || !(event2 instanceof DataChangeListener) || !(owner instanceof IKDEditor)) continue;
                ((IKDEditor)owner).removeDataChangeListener((DataChangeListener)event2);
            }
        }
    }

    public static void addDataChangeListeners(JComponent owner, EventListener[] listeners) {
        if (owner == null || listeners == null || listeners.length < 0) {
            SysUtil.abort();
            return;
        }
        EventListener event2 = null;
        for (EventListener event2 : listeners) {
            if (event2 == null || !(event2 instanceof DataChangeListener) || !(owner instanceof IKDEditor)) continue;
            ((IKDEditor)owner).addDataChangeListener((DataChangeListener)event2);
        }
    }

    public static Boolean reverseBoolean(Boolean b) {
        return b == false;
    }

    public static boolean noBigDecimal(BigDecimal bd) {
        return bd == null || bd.compareTo(new BigDecimal("0.0")) <= 0;
    }

    public static Date addDate(Date curDate, int dateField, int delta) {
        Calendar calender = Calendar.getInstance();
        if (curDate != null) {
            calender.setTime(curDate);
        }
        calender.add(dateField, delta);
        return calender.getTime();
    }

    public static void setF7Range(String field, String compareIds, IObjectValue range, KDTable kdtEntries, int rowIndex, String col) {
        if (compareIds != null) {
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo(field, (Object)compareIds, CompareType.INCLUDE));
            viewInfo.setFilter(filter);
            ICellEditor cellEditor = kdtEntries.getColumn(col).getEditor();
            if (cellEditor != null) {
                KDBizPromptBox prmtF7 = (KDBizPromptBox)cellEditor.getComponent();
                prmtF7.setEntityViewInfo(viewInfo);
                prmtF7.setMergeColumnKeys(new String[]{"number", "name"});
                prmtF7.setSelector(null);
                kdtEntries.getCell(rowIndex, col).setEditor(cellEditor);
            }
        }
    }

    public static StringBuffer insertDelimit(String[] pks, String ch) {
        if (ch == null || pks == null) {
            return null;
        }
        StringBuffer strParameter = new StringBuffer();
        int len = pks.length;
        for (int i = 0; i < len; ++i) {
            if (pks[i] == null) continue;
            if (i > 0) {
                strParameter.append(ch);
            }
            strParameter.append(pks[i]);
        }
        return strParameter;
    }

    public static String[] getIds(List entries) {
        int size = entries.size();
        if (size == 0) {
            return null;
        }
        String[] entriesIds = new String[size];
        for (int i = 0; i < size; ++i) {
            entriesIds[i] = ((AbstractCoreBaseInfo)entries.get(i)).getId().toString();
        }
        return entriesIds;
    }

    public static String[] getIds(KDTable kdt, String column) {
        int rows = kdt.getRowCount();
        if (rows < 1) {
            return null;
        }
        int col = kdt.getColumnIndex(column);
        ArrayList<AbstractCoreBaseInfo> entries = new ArrayList<AbstractCoreBaseInfo>(rows);
        AbstractCoreBaseInfo entry = null;
        for (int i = 0; i < kdt.getRowCount(); ++i) {
            entry = (AbstractCoreBaseInfo)kdt.getValueAt(i, col);
            if (entry == null) continue;
            entries.add(entry);
        }
        String[] ids = SDSMUtil.getIds(entries);
        return ids;
    }

    public static boolean checkEquality(String[] ids) {
        if (ids != null) {
            Arrays.sort(ids);
            if (!ids[0].equals(ids[ids.length - 1])) {
                return false;
            }
        }
        return true;
    }

    public static boolean botpCheckPassed(String[] checkArray, boolean[] checkItems, KDTable tblMain) {
        String[] msgs = new String[]{"EQUELSUPPLIER", "EQUELPURUNIT", "EQUELCURRENCY", "EQUELBIZTYPE"};
        String[] entriesColsIds = null;
        for (int i = 0; i < checkArray.length; ++i) {
            if (!checkItems[i] || SDSMUtil.checkEquality(entriesColsIds = SCMClientUtils.getSelectRowFieldValue((KDTable)tblMain, (String)checkArray[i]))) continue;
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.scm.sm.pur.PurUIResource", (String)msgs[i]));
            return false;
        }
        return true;
    }

    public static void setMergeColumn(KDTable tblMain, String[] mergeColumnKeys) {
        if (mergeColumnKeys != null && mergeColumnKeys.length > 0) {
            tblMain.checkParsed();
            tblMain.getGroupManager().setGroup(true);
            for (int i = 0; i < mergeColumnKeys.length; ++i) {
                tblMain.getColumn(mergeColumnKeys[i]).setGroup(true);
                tblMain.getColumn(mergeColumnKeys[i]).setMergeable(true);
            }
        }
    }

    public static boolean isInGroup(PurchaseGroupInfo info, PersonInfo info2) throws BOSException {
        boolean flag = false;
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("purGroup.id", (Object)info.getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)info2.getId().toString(), CompareType.EQUALS));
        filter.setMaskString("#0 and #1");
        viewInfo.setFilter(filter);
        IPurchasePerson ip = null;
        ip = PurchasePersonFactory.getRemoteInstance();
        PurchasePersonCollection ppc = ip.getPurchasePersonCollection(viewInfo);
        if (ppc.size() > 0) {
            flag = true;
        }
        return flag;
    }
}

