/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.pur.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.ma.nbudget.BgControlCaller;
import com.kingdee.eas.ma.nbudget.face.IControlResult;
import com.kingdee.eas.scm.common.PurControlBudgetFieldsEnum;
import com.kingdee.eas.scm.common.PurchaseTypeEnum;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.SCMBillParamFactory;
import com.kingdee.eas.scm.common.app.bizprocess.util.SCMBizProcessorUtil;
import com.kingdee.eas.scm.sm.pur.PurOrderEntryCollection;
import com.kingdee.eas.scm.sm.pur.PurOrderEntryFactory;
import com.kingdee.eas.scm.sm.pur.PurOrderEntryInfo;
import com.kingdee.eas.scm.sm.pur.PurRequestCollection;
import com.kingdee.eas.scm.sm.pur.PurRequestEntryCollection;
import com.kingdee.eas.scm.sm.pur.PurRequestEntryFactory;
import com.kingdee.eas.scm.sm.pur.PurRequestEntryInfo;
import com.kingdee.eas.scm.sm.pur.PurRequestFactory;
import com.kingdee.eas.scm.sm.pur.PurRequestInfo;
import com.kingdee.eas.scm.sm.pur.constant.PurBgCtrlConstant;
import com.kingdee.eas.scm.util.SCMSelectorFactory;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class PurBgCtrlUtil {
    private static Logger logger = Logger.getLogger(PurBgCtrlUtil.class);
    private static BgControlCaller caller = new BgControlCaller();

    public static boolean requestBudget(Context ctx, BOSUuid billId) throws EASBizException, BOSException {
        IControlResult callerResult = null;
        boolean result = false;
        callerResult = ctx == null ? caller.requestBudget(billId) : caller.requestBudget(ctx, billId);
        if (callerResult.getResult() != 1) {
            List cause = callerResult.getCause();
            if (cause.size() > 0) {
                logger.error((Object)cause);
                throw new EASBizException(new NumericExceptionSubItem("12348888", (String)cause.get(0)));
            }
        } else {
            result = true;
        }
        return result;
    }

    public static void requestBudgetForPurReqest(Context ctx, Set<String> billIdSet, BatchActionEnum action, boolean isSameMainOrgUnit) throws BOSException, EASBizException {
        if (billIdSet == null || billIdSet.size() == 0) {
            logger.debug((Object)"@@@@\u8c03\u7528\u9884\u7b97\u6263\u51cf\u63a5\u53e3\u5355\u636e\u4e3a\u7a7a\u4e86..............");
            return;
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.setSelector(PurBgCtrlUtil.getBudgetSelector(PurBgCtrlConstant.PURREQUEST_BILLTYPEID));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", billIdSet, CompareType.INCLUDE));
        evi.setFilter(filter);
        PurRequestCollection billCols = PurRequestFactory.getLocalInstance(ctx).getPurRequestCollection(evi);
        PurBgCtrlUtil.requestBudgetForPurReqest(ctx, billCols, action, isSameMainOrgUnit);
    }

    public static void requestBudgetForPurRequest(Context ctx, PurRequestInfo billInfo, BatchActionEnum action) throws BOSException, EASBizException {
        PurRequestCollection col = new PurRequestCollection();
        col.add(billInfo);
        PurBgCtrlUtil.requestBudgetForPurReqest(ctx, col, action, true);
    }

    public static void requestBudgetForPurReqest(Context ctx, PurRequestCollection billCols, BatchActionEnum action, boolean isSameMainOrgUnit) throws BOSException, EASBizException {
        if (billCols == null || billCols.size() == 0) {
            logger.debug((Object)"@@@@\u8c03\u7528\u9884\u7b97\u6263\u51cf\u63a5\u53e3\u5355\u636e\u4e3a\u7a7a\u4e86..............");
            return;
        }
        Map<String, PurRequestCollection> billMap = PurBgCtrlUtil.classifyBillCollection(ctx, billCols, isSameMainOrgUnit);
        boolean isCtrlBg = true;
        for (Map.Entry<String, PurRequestCollection> entry : billMap.entrySet()) {
            isCtrlBg = PurBgCtrlUtil.isAuditControlBudget(ctx, entry.getKey(), 1, PurBgCtrlConstant.PURREQUEST_BILLTYPEID);
            if (isCtrlBg) {
                PurBgCtrlUtil.requestBgForAudit(ctx, entry.getKey(), entry.getValue());
                continue;
            }
            isCtrlBg = PurBgCtrlUtil.isSubmitControlBudget(ctx, entry.getKey(), 1, PurBgCtrlConstant.PURREQUEST_BILLTYPEID);
            if (!isCtrlBg) continue;
            PurBgCtrlUtil.requestBgForSubmit(ctx, entry.getKey(), entry.getValue());
        }
    }

    public static void requestBudgetForPurReqestEntry(Context ctx, PurRequestInfo billInfo, String[] entryIds, BatchActionEnum action, boolean isSameMainOrgUnit) throws BOSException, EASBizException {
        boolean isTrue = PurBgCtrlUtil.batchCheckAndUpdateReqEntryBgField(ctx, billInfo, entryIds, null);
        if (isTrue) {
            PurBgCtrlUtil.requestBudget(ctx, billInfo.getId());
        }
    }

    private static void requestBgForSubmit(Context ctx, String mainOrgId, PurRequestCollection billCols) throws EASBizException, BOSException {
    }

    private static void requestBgForAudit(Context ctx, String mainOrgId, PurRequestCollection billCols) throws EASBizException, BOSException {
        String purBudgetField = PurBgCtrlUtil.getBillFieldsForBudget(ctx, PurBgCtrlConstant.PURREQUEST_BILLTYPEID, mainOrgId);
        PurRequestInfo info = null;
        boolean isTrue = true;
        int size = billCols.size();
        for (int i = 0; i < size; ++i) {
            info = billCols.get(i);
            isTrue = PurBgCtrlUtil.batchCheckAndUpdateReqEntryBgField(ctx, info, null, purBudgetField);
            if (!isTrue) continue;
            PurBgCtrlUtil.requestBudget(ctx, info.getId());
        }
    }

    public static boolean batchCheckAndUpdateReqEntryBgField(Context ctx, PurRequestInfo info, String[] entryIds, String purBudgetField) throws BOSException, EASBizException {
        int i;
        if (info == null) {
            return false;
        }
        if (!PurBgCtrlUtil.checkBgConditionsForBill(ctx, info, BatchActionEnum.AUDIT)) {
            return false;
        }
        String billId = info.getId().toString();
        StringBuffer entryIdFilter = new StringBuffer();
        int size = 0;
        PurRequestEntryCollection entryCol = null;
        if (entryIds == null || entryIds.length == 0) {
            entryCol = info.getEntries();
            size = entryCol.size();
            if (size == 1) {
                entryIdFilter.append(" = '").append(entryCol.get(0).getId().toString()).append("'");
            } else if (size > 1) {
                entryIdFilter.append(" in (");
                for (i = 0; i < size; ++i) {
                    if (i == 0) {
                        entryIdFilter.append("'").append(entryCol.get(i).getId().toString()).append("'");
                        continue;
                    }
                    entryIdFilter.append(",'").append(entryCol.get(i).getId().toString()).append("'");
                }
                entryIdFilter.append(")");
            } else {
                logger.error((Object)"@@@@\u5355\u636e\u5206\u5f55\u4e3a\u7a7a\u3002\u3002\u3002\u3002\u3002\u3002\u3002");
            }
        } else {
            size = entryIds.length;
            if (size == 1) {
                entryIdFilter.append(" = '").append(entryIds[0]).append("'");
            } else if (size > 1) {
                entryIdFilter.append(" in (");
                for (i = 0; i < size; ++i) {
                    if (i == 0) {
                        entryIdFilter.append("'").append(entryIds[i]).append("'");
                        continue;
                    }
                    entryIdFilter.append(",'").append(entryIds[i]).append("'");
                }
                entryIdFilter.append(")");
            } else {
                logger.error((Object)"@@@@\u5355\u636e\u5206\u5f55\u4e3a\u7a7a\u3002\u3002\u3002\u3002\u3002\u3002\u3002");
            }
        }
        if (purBudgetField == null) {
            purBudgetField = PurBgCtrlUtil.getBillFieldsForBudget(ctx, PurBgCtrlConstant.PURREQUEST_BILLTYPEID, info.getCompanyOrgUnit().getId().toString());
        }
        int bgFieldValue = PurBgCtrlUtil.getParamValueByField(purBudgetField);
        StringBuffer sql = new StringBuffer();
        sql.append(" update T_SM_PurRequestEntry A set (FPurBgField,FReqBudgetAmt) = (select ").append(bgFieldValue);
        sql.append(",case when isnull(B.F").append(purBudgetField).append(",0) ");
        sql.append(" > isnull(B.FExecuteAmout,0) then isnull(B.F").append(purBudgetField).append(",0) else isnull(B.FExecuteAmout,0) end ");
        sql.append(" from T_SM_PurRequestEntry B where A.FID = B.FID ");
        sql.append(" and B.FBaseStatus = ").append(4);
        sql.append(" and B.FParentID = '").append(billId).append("'");
        sql.append(" and B.FID ").append(entryIdFilter);
        sql.append(" )");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql = new StringBuffer();
        sql.append(" update T_SM_PurRequestEntry A set (FPurBgField,FReqBudgetAmt) = (select ").append(bgFieldValue);
        sql.append(",B.FExecuteAmout");
        sql.append(" from T_SM_PurRequestEntry B where A.FID = B.FID ");
        sql.append(" and B.FBaseStatus = ").append(7);
        sql.append(" and B.FParentID = '").append(billId).append("'");
        sql.append(" and B.FID ").append(entryIdFilter);
        sql.append(" )");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql = new StringBuffer();
        sql.append(" update T_SM_PurRequestEntry A set (FPurBgField,FReqBudgetAmt) = (select ").append(bgFieldValue);
        sql.append(",0 ");
        sql.append(" from T_SM_PurRequestEntry B where A.FID = B.FID ");
        sql.append(" and B.FBaseStatus != ").append(4);
        sql.append(" and B.FBaseStatus != ").append(7);
        sql.append(" and B.FID ").append(entryIdFilter);
        sql.append(" )");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        return true;
    }

    public static void batchWriteBgExecuteAmoutFromPurOrder(Context ctx, IObjectPK[] pks, BatchActionEnum action) throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        String symbol = "+";
        if (action != BatchActionEnum.AUDIT && action == BatchActionEnum.UNAUDIT) {
            symbol = "-";
        }
        int size = pks.length;
        StringBuffer purOrderIdFilter = new StringBuffer();
        if (size == 1) {
            purOrderIdFilter.append(" = '").append(pks[0]).append("'");
        } else if (size > 1) {
            purOrderIdFilter.append(" in (");
            for (int i = 0; i < size; ++i) {
                if (i == 0) {
                    purOrderIdFilter.append("'").append(pks[i]).append("'");
                    continue;
                }
                purOrderIdFilter.append(",'").append(pks[i]).append("'");
            }
            purOrderIdFilter.append(")");
        } else {
            logger.error((Object)"@@@@\u5355\u636e\u4e3a\u7a7a\u3002\u3002\u3002\u3002\u3002\u3002\u3002");
        }
        sql.setLength(0);
        sql.append(" update T_SM_PurRequestEntry set (FExecuteAmout) = ");
        sql.append(" (select T_SM_PurRequestEntry.FExecuteAmout").append(symbol).append("B.amount from ");
        sql.append(" (select t1.FPurRequestEntryID id, ");
        sql.append(" sum(t1.F").append("amount").append(")").append(" amount ");
        sql.append(" from T_SM_PurRequestEntry t,T_SM_PurOrderEntry t1  ");
        sql.append(" where t1.FPurRequestEntryID = t.FID ");
        sql.append(" and (t1.FSourceBillTypeID ='").append(PurBgCtrlConstant.PURREQUEST_BILLTYPEID).append("' ");
        sql.append(" or t1.FSourceBillTypeID ='").append("510b6503-0105-1000-e000-010bc0a814fd463ED552").append("' ");
        sql.append(" or t1.FSourceBillTypeID ='").append("510b6503-0105-1000-e000-010bc0b814fd463ED552").append("') ");
        sql.append(" and t.FPurBgField = ").append(10);
        sql.append(" and t1.FParentID ").append(purOrderIdFilter);
        sql.append(" group by t1.FPurRequestEntryID) B where T_SM_PurRequestEntry.FID = B.id)");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql.setLength(0);
        sql.append(" update T_SM_PurRequestEntry set (FExecuteAmout) = ");
        sql.append(" (select T_SM_PurRequestEntry.FExecuteAmout").append(symbol).append("B.amount from ");
        sql.append(" (select t1.FPurRequestEntryID id, ");
        sql.append(" sum(t1.F").append("localAmount").append(")").append(" amount ");
        sql.append(" from T_SM_PurRequestEntry t,T_SM_PurOrderEntry t1  ");
        sql.append(" where t1.FPurRequestEntryID = t.FID ");
        sql.append(" and (t1.FSourceBillTypeID ='").append(PurBgCtrlConstant.PURREQUEST_BILLTYPEID).append("' ");
        sql.append(" or t1.FSourceBillTypeID ='").append("510b6503-0105-1000-e000-010bc0a814fd463ED552").append("' ");
        sql.append(" or t1.FSourceBillTypeID ='").append("510b6503-0105-1000-e000-010bc0b814fd463ED552").append("') ");
        sql.append(" and t.FPurBgField = ").append(20);
        sql.append(" and t1.FParentID ").append(purOrderIdFilter);
        sql.append(" group by t1.FPurRequestEntryID) B where T_SM_PurRequestEntry.FID = B.id)");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql.setLength(0);
        sql.append(" update T_SM_PurRequestEntry set (FExecuteAmout) = ");
        sql.append(" (select T_SM_PurRequestEntry.FExecuteAmout").append(symbol).append("B.amount from ");
        sql.append(" (select t1.FPurRequestEntryID id, ");
        sql.append(" sum(t1.F").append("taxAmount").append(")").append(" amount ");
        sql.append(" from T_SM_PurRequestEntry t,T_SM_PurOrderEntry t1  ");
        sql.append(" where t1.FPurRequestEntryID = t.FID ");
        sql.append(" and (t1.FSourceBillTypeID ='").append(PurBgCtrlConstant.PURREQUEST_BILLTYPEID).append("' ");
        sql.append(" or t1.FSourceBillTypeID ='").append("510b6503-0105-1000-e000-010bc0a814fd463ED552").append("' ");
        sql.append(" or t1.FSourceBillTypeID ='").append("510b6503-0105-1000-e000-010bc0b814fd463ED552").append("') ");
        sql.append(" and t.FPurBgField = ").append(30);
        sql.append(" and t1.FParentID ").append(purOrderIdFilter);
        sql.append(" group by t1.FPurRequestEntryID) B where T_SM_PurRequestEntry.FID = B.id)");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql.setLength(0);
        sql.append(" update T_SM_PurRequestEntry set (FExecuteAmout) = ");
        sql.append(" (select T_SM_PurRequestEntry.FExecuteAmout").append(symbol).append("B.amount from ");
        sql.append(" (select t1.FPurRequestEntryID id, ");
        sql.append(" sum(t1.F").append("localTaxAmount").append(")").append(" amount ");
        sql.append(" from T_SM_PurRequestEntry t,T_SM_PurOrderEntry t1  ");
        sql.append(" where t1.FPurRequestEntryID = t.FID ");
        sql.append(" and (t1.FSourceBillTypeID ='").append(PurBgCtrlConstant.PURREQUEST_BILLTYPEID).append("' ");
        sql.append(" or t1.FSourceBillTypeID ='").append("510b6503-0105-1000-e000-010bc0a814fd463ED552").append("' ");
        sql.append(" or t1.FSourceBillTypeID ='").append("510b6503-0105-1000-e000-010bc0b814fd463ED552").append("') ");
        sql.append(" and t.FPurBgField = ").append(40);
        sql.append(" and t1.FParentID ").append(purOrderIdFilter);
        sql.append(" group by t1.FPurRequestEntryID) B where T_SM_PurRequestEntry.FID = B.id)");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    public static void writeBgExecuteAmoutFromPurOrderChange(Context ctx, Set<String> oldPurOrderIdSet, Set<String> oldPurOrderEntryIdSet, Map<String, PurOrderEntryInfo> oldPurOrderEntryMap) throws BOSException, EASBizException {
        if (oldPurOrderIdSet == null || oldPurOrderIdSet.size() == 0 || oldPurOrderEntryIdSet == null || oldPurOrderEntryIdSet.size() == 0) {
            return;
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.setSelector(PurBgCtrlUtil.getPurOrderEntryForBgSelector());
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", oldPurOrderEntryIdSet, CompareType.INCLUDE));
        evi.setFilter(filter);
        PurOrderEntryCollection newPurOrderCol = PurOrderEntryFactory.getLocalInstance(ctx).getPurOrderEntryCollection(evi);
        HashMap<String, BigDecimal> amountMap = new HashMap<String, BigDecimal>();
        HashMap<String, BigDecimal> localAmountMap = new HashMap<String, BigDecimal>();
        HashMap<String, BigDecimal> taxAmountMap = new HashMap<String, BigDecimal>();
        HashMap<String, BigDecimal> localTaxAmountMap = new HashMap<String, BigDecimal>();
        HashMap<String, String> reqToOrderEntryIdMap = new HashMap<String, String>();
        HashSet<String> purRequestIdSet = new HashSet<String>();
        HashSet<String> purRequestEntryIdSet = new HashSet<String>();
        String orderEntryId = null;
        PurOrderEntryInfo oldPurOrderEntryInfo = null;
        PurOrderEntryInfo newPurOrderEntryInfo = null;
        String purRequestEntryId = null;
        int size = newPurOrderCol.size();
        for (int i = 0; i < size; ++i) {
            newPurOrderEntryInfo = newPurOrderCol.get(i);
            orderEntryId = newPurOrderEntryInfo.getId().toString();
            purRequestEntryId = newPurOrderEntryInfo.getSourceBillEntryId();
            oldPurOrderEntryInfo = oldPurOrderEntryMap.get(orderEntryId);
            purRequestIdSet.add(newPurOrderEntryInfo.getSourceBillId());
            purRequestEntryIdSet.add(purRequestEntryId);
            reqToOrderEntryIdMap.put(orderEntryId, purRequestEntryId);
            amountMap.put(purRequestEntryId, PurBgCtrlUtil.toNotNull(newPurOrderEntryInfo.getAmount()).subtract(PurBgCtrlUtil.toNotNull(oldPurOrderEntryInfo.getAmount())));
            localAmountMap.put(purRequestEntryId, PurBgCtrlUtil.toNotNull(newPurOrderEntryInfo.getLocalAmount()).subtract(PurBgCtrlUtil.toNotNull(oldPurOrderEntryInfo.getLocalAmount())));
            taxAmountMap.put(purRequestEntryId, PurBgCtrlUtil.toNotNull(newPurOrderEntryInfo.getTaxAmount()).subtract(PurBgCtrlUtil.toNotNull(oldPurOrderEntryInfo.getTaxAmount())));
            localTaxAmountMap.put(purRequestEntryId, PurBgCtrlUtil.toNotNull(newPurOrderEntryInfo.getLocalTaxAmount()).subtract(PurBgCtrlUtil.toNotNull(oldPurOrderEntryInfo.getLocalTaxAmount())));
        }
        evi = new EntityViewInfo();
        evi.setSelector(PurBgCtrlUtil.getPurRequestEntryForBgSelector());
        filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", purRequestEntryIdSet, CompareType.INCLUDE));
        evi.setFilter(filter);
        PurRequestEntryCollection purRequestEntryCol = PurRequestEntryFactory.getLocalInstance(ctx).getPurRequestEntryCollection(evi);
        Connection con = null;
        try {
            con = SCMBizProcessorUtil.getConnection((Context)ctx);
            String updateSql = "update T_SM_PurRequestEntry set FExecuteAmout = (FExecuteAmout + ?) where FID = ? and FPurBgField is not null";
            PreparedStatement updateStatement = con.prepareStatement(updateSql);
            PurRequestEntryInfo purRequestEntryInfo = null;
            purRequestEntryId = null;
            String purRequestId = null;
            PurControlBudgetFieldsEnum purBgField = null;
            int size2 = purRequestEntryCol.size();
            for (int i = 0; i < size2; ++i) {
                purRequestEntryInfo = purRequestEntryCol.get(i);
                purRequestId = purRequestEntryInfo.getParent().getId().toString();
                purBgField = purRequestEntryInfo.getPurBgField();
                if (purBgField != null) {
                    purRequestEntryId = purRequestEntryInfo.getId().toString();
                    if (PurControlBudgetFieldsEnum.BUDGET_AMOUNT.equals((Object)purBgField)) {
                        updateStatement.setBigDecimal(1, (BigDecimal)amountMap.get(purRequestEntryId));
                    } else if (PurControlBudgetFieldsEnum.BUDGET_LOCALAMOUNT.equals((Object)purBgField)) {
                        updateStatement.setBigDecimal(1, (BigDecimal)localAmountMap.get(purRequestEntryId));
                    } else if (PurControlBudgetFieldsEnum.BUDGET_TAXAMOUNT.equals((Object)purBgField)) {
                        updateStatement.setBigDecimal(1, (BigDecimal)taxAmountMap.get(purRequestEntryId));
                    } else if (PurControlBudgetFieldsEnum.BUDGET_LOCALTAXAMOUNT.equals((Object)purBgField)) {
                        updateStatement.setBigDecimal(1, (BigDecimal)localTaxAmountMap.get(purRequestEntryId));
                    }
                    updateStatement.setString(2, purRequestEntryId);
                    updateStatement.addBatch();
                    continue;
                }
                if (!purRequestIdSet.contains(purRequestId)) continue;
                purRequestIdSet.remove(purRequestId);
            }
            updateStatement.executeBatch();
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage());
        }
        finally {
            SQLUtils.cleanup((Connection)con);
        }
        PurBgCtrlUtil.requestBudgetForPurReqest(ctx, purRequestIdSet, null, false);
    }

    public static SelectorItemCollection getPurOrderEntryForBgSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("sourceBillId"));
        sic.add(new SelectorItemInfo("sourceBillEntryId"));
        sic.add(new SelectorItemInfo("amount"));
        sic.add(new SelectorItemInfo("localAmount"));
        sic.add(new SelectorItemInfo("taxAmount"));
        sic.add(new SelectorItemInfo("localTaxAmount"));
        sic.add(new SelectorItemInfo("parent.id"));
        sic.add(new SelectorItemInfo("parent.sourceBillType.id"));
        return sic;
    }

    public static SelectorItemCollection getPurRequestEntryForBgSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("purBgField"));
        sic.add(new SelectorItemInfo("parent.id"));
        return sic;
    }

    public static BigDecimal toNotNull(BigDecimal arg) {
        return arg == null ? BigDecimal.ZERO : arg;
    }

    private static Map<String, PurRequestCollection> classifyBillCollection(Context ctx, PurRequestCollection billCols, boolean isSameMainOrgUnit) throws BOSException, EASBizException {
        HashMap<String, PurRequestCollection> billMap = new HashMap<String, PurRequestCollection>();
        PurRequestCollection newCol = null;
        PurRequestInfo bill = null;
        String mainOrgId = null;
        if (isSameMainOrgUnit) {
            if (billCols.get(0).getCompanyOrgUnit() == null) {
                logger.debug((Object)"@@@@\u8c03\u7528\u9884\u7b97\u6263\u51cf\u63a5\u53e3\u5355\u636e\u4e3b\u4e1a\u52a1\u7ec4\u7ec7\u4e3a\u7a7a\u4e86..............");
                return null;
            }
            billMap.put(billCols.get(0).getCompanyOrgUnit().getId().toString(), billCols);
        } else {
            int size = billCols.size();
            for (int i = 0; i < size; ++i) {
                bill = billCols.get(i);
                if (bill.getCompanyOrgUnit() != null) {
                    mainOrgId = bill.getCompanyOrgUnit().getId().toString();
                    if (billMap.containsKey(mainOrgId)) {
                        newCol = (PurRequestCollection)((Object)billMap.get(mainOrgId));
                        newCol.add(bill);
                        billMap.put(mainOrgId, newCol);
                        continue;
                    }
                    newCol = new PurRequestCollection();
                    newCol.add(bill);
                    billMap.put(mainOrgId, newCol);
                    continue;
                }
                logger.debug((Object)"@@@@\u8c03\u7528\u9884\u7b97\u6263\u51cf\u63a5\u53e3\u5355\u636e\u4e3b\u4e1a\u52a1\u7ec4\u7ec7\u4e3a\u7a7a\u4e86..............");
            }
        }
        return billMap;
    }

    public static boolean checkBgConditionsForBill(Context ctx, SCMBillBaseInfo model, BatchActionEnum action) throws EASBizException, BOSException {
        boolean isPass = false;
        if (model == null) {
            return isPass;
        }
        String billtypeID = model.getBillType().getId().toString();
        if (PurBgCtrlConstant.PURREQUEST_BILLTYPEID.equals(billtypeID)) {
            PurRequestInfo purRequestInfo = (PurRequestInfo)model;
            if (purRequestInfo.getCompanyOrgUnit() != null && !purRequestInfo.isIsMergeBill() && PurchaseTypeEnum.PURCHASE == purRequestInfo.getPurchaseType()) {
                if (BatchActionEnum.SUBMIT == action) {
                    isPass = PurBgCtrlUtil.isSubmitControlBudget(ctx, purRequestInfo.getCompanyOrgUnit().getId().toString(), 1, PurBgCtrlConstant.PURREQUEST_BILLTYPEID);
                } else if (BatchActionEnum.AUDIT == action) {
                    isPass = PurBgCtrlUtil.isAuditControlBudget(ctx, purRequestInfo.getCompanyOrgUnit().getId().toString(), 1, PurBgCtrlConstant.PURREQUEST_BILLTYPEID);
                }
            }
        } else if (PurBgCtrlConstant.PURORDER_BILLTYPEID.equals(billtypeID) || PurBgCtrlConstant.PURCONTRACT_BILLTYPEID.equals(billtypeID)) {
            // empty if block
        }
        return isPass;
    }

    public static boolean isSubmitControlBudget(Context ctx, String orgUnitID, int orgType, String billTypeID) throws BOSException, EASBizException {
        boolean isSubmitControlBudget = false;
        int isControlBudget = PurBgCtrlUtil.isControlBudget(ctx, orgUnitID, orgType, billTypeID);
        if (isControlBudget == 2) {
            isSubmitControlBudget = true;
        }
        return isSubmitControlBudget;
    }

    public static boolean isAuditControlBudget(Context ctx, String orgUnitID, int orgType, String billTypeID) throws BOSException, EASBizException {
        boolean isAuditControlBudget = false;
        int isControlBudget = PurBgCtrlUtil.isControlBudget(ctx, orgUnitID, orgType, billTypeID);
        if (isControlBudget == 1) {
            isAuditControlBudget = true;
        }
        return isAuditControlBudget;
    }

    public static int isControlBudget(Context ctx, String orgUnitID, int orgType, String billTypeID) throws BOSException, EASBizException {
        int isControlBudget = 0;
        String strControlBudget = PurBgCtrlUtil.getScmBillParams(ctx, PurBgCtrlConstant.ISCONTROLBG, orgType, orgUnitID, billTypeID);
        if (strControlBudget != null && strControlBudget.trim().length() != 0) {
            isControlBudget = Integer.parseInt(strControlBudget);
        }
        return isControlBudget;
    }

    public static String getScmBillParams(Context ctx, String paramNumber, int orgType, String orgUnitID, String billTypeID) throws EASBizException, BOSException {
        String param = null;
        param = ctx == null ? SCMBillParamFactory.getRemoteInstance().getParamByBillTypeID(paramNumber, orgType, orgUnitID, billTypeID) : SCMBillParamFactory.getLocalInstance((Context)ctx).getParamByBillTypeID(paramNumber, orgType, orgUnitID, billTypeID);
        return param;
    }

    public static String getBillFieldsForBudget(Context ctx, String billTypeId, String mainOrgId) throws EASBizException, BOSException {
        return PurBgCtrlUtil.getFieldByParamValue(PurBgCtrlUtil.getBillField(ctx, billTypeId, mainOrgId));
    }

    private static int getBillField(Context ctx, String billTypeId, String mainOrgId) throws EASBizException, BOSException {
        String strPurBudgetFields;
        int field = 10;
        if (billTypeId == null || mainOrgId == null) {
            logger.error((Object)"@@@@\u5355\u636e\u7c7b\u578b\u6216\u8005\u4e3b\u4e1a\u52a1\u7ec4\u7ec7ID\u4e3a\u7a7a\uff0c\u53d6\u9ed8\u8ba4\u9884\u7b97\u6263\u51cf\u5b57\u6bb5\u91d1\u989d\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002");
            return field;
        }
        if (PurBgCtrlConstant.PURREQUEST_BILLTYPEID.equals(billTypeId) && (strPurBudgetFields = PurBgCtrlUtil.getScmBillParams(ctx, "PUR_BudgetFields", 1, mainOrgId, PurBgCtrlConstant.PURREQUEST_BILLTYPEID)) != null && strPurBudgetFields.trim().length() != 0) {
            field = Integer.parseInt(strPurBudgetFields);
        }
        return field;
    }

    private static String getFieldByParamValue(int paramValue) {
        String field = "amount";
        if (paramValue == 10) {
            field = "amount";
        } else if (paramValue == 20) {
            field = "localAmount";
        } else if (paramValue == 30) {
            field = "taxAmount";
        } else if (paramValue == 40) {
            field = "localTaxAmount";
        }
        return field;
    }

    private static int getParamValueByField(String field) {
        int value = 10;
        if ("amount".equals(field)) {
            value = 10;
        } else if ("localAmount".equals(field)) {
            value = 20;
        } else if ("taxAmount".equals(field)) {
            value = 30;
        } else if ("localTaxAmount".equals(field)) {
            value = 40;
        }
        return value;
    }

    public static Boolean isNewPurBudget(Context ctx) throws EASBizException, BOSException {
        boolean isNewPurBudget = true;
        Map<String, Boolean> param = PurBgCtrlUtil.getScmSpecialParams(ctx, new String[]{"isNewPurBudget"});
        if (param != null && param.size() > 0) {
            isNewPurBudget = param.get("isNewPurBudget");
        }
        return isNewPurBudget;
    }

    public static Map<String, Boolean> getScmSpecialParams(Context ctx, String[] keys) throws BOSException, EASBizException {
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        StringBuffer buff = new StringBuffer();
        if (keys != null && keys.length > 0) {
            int len = keys.length;
            for (int i = 0; i < len; ++i) {
                if (i != len - 1) {
                    buff.append("'").append(keys[i]).append("', ");
                    continue;
                }
                buff.append("'").append(keys[i]).append("'");
            }
        }
        try {
            if (buff.length() <= 0) {
                return map;
            }
            StringBuffer sql = new StringBuffer();
            sql.append("SELECT FKey,FValue From T_DT_DTTempParam WHERE FKey in (");
            sql.append(buff.toString());
            sql.append(")");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            String key = "";
            boolean value = true;
            while (rs.next()) {
                key = rs.getString("FKey");
                value = rs.getBoolean("FValue");
                map.put(key, new Boolean(value));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return map;
    }

    public static SelectorItemCollection getBudgetSelector(String billtype) {
        SelectorItemCollection selector = new SelectorItemCollection();
        if (PurBgCtrlConstant.PURREQUEST_BILLTYPEID.equals(billtype)) {
            selector = PurBgCtrlUtil.getPurRequestBgSelector();
        }
        return selector;
    }

    private static SelectorItemCollection getPurRequestBgSelector() {
        return SCMSelectorFactory.getPurRequestSelector((boolean)true);
    }

    public static void checkBudget4Submit(Context ctx, PurRequestInfo billInfo) throws EASBizException, BOSException {
        String purBudgetField = PurBgCtrlUtil.getBillFieldsForBudget(ctx, PurBgCtrlConstant.PURREQUEST_BILLTYPEID, billInfo.getCompanyOrgUnit().getId().toString());
        int bgFieldValue = PurBgCtrlUtil.getParamValueByField(purBudgetField);
        StringBuffer sql = new StringBuffer();
        sql.append(" update T_SM_PurRequestEntry A set (FPurBgField,FReqBudgetAmt) = (select ").append(bgFieldValue);
        sql.append(", isnull(B.F").append(purBudgetField).append(",0) ");
        sql.append(" from T_SM_PurRequestEntry B where A.FID = B.FID ");
        sql.append(" and B.FParentID = '").append(billInfo.getId().toString()).append("'");
        sql.append(" )");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        int controlBudget = PurBgCtrlUtil.isControlBudget(ctx, billInfo.getCompanyOrgUnit().getId().toString(), 1, PurBgCtrlConstant.PURREQUEST_BILLTYPEID);
        if (controlBudget != 0) {
            BgControlCaller bgCaller = new BgControlCaller();
            bgCaller.checkBudget(ctx, billInfo.getId());
        }
    }
}

