/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.pur.util;

import com.kingdee.bos.ctrl.kdf.data.logging.Logger;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.scm.common.InvoiceTypeEnum;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.sm.pur.PurInvoiceEntryCollection;
import com.kingdee.eas.scm.sm.pur.PurInvoiceEntryInfo;
import com.kingdee.eas.scm.sm.pur.PurInvoiceInfo;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class PurInvoiceUtil {
    public static BigDecimal calculateLocalAmount(BigDecimal amount, ExchangeRateInfo exchangeRateinfo) {
        return SCMUtils.calculateLocalAmount((BigDecimal)amount, (ExchangeRateInfo)exchangeRateinfo);
    }

    public static Date getFirstDayofMonth(Date d) {
        Date date = null;
        SimpleDateFormat formater = new SimpleDateFormat("yyyy-MM-dd");
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(d);
        try {
            date = formater.parse(calendar.get(1) + "-" + calendar.get(2) + "-01");
        }
        catch (ParseException pex) {
            Logger.error((Throwable)pex);
            date = d;
        }
        return date;
    }

    public static BigDecimal calculatePrice(BigDecimal taxRate, BigDecimal taxPrice, InvoiceTypeEnum invoiceType) {
        BigDecimal price = null;
        if (taxRate == null) {
            taxRate = new BigDecimal("0.00");
        }
        if (taxPrice != null) {
            if (!invoiceType.equals((Object)InvoiceTypeEnum.GENERAL)) {
                taxRate = PurInvoiceUtil.getLittleRate(taxRate);
                int scale = taxRate.scale() + taxPrice.scale();
                price = taxPrice.divide(taxRate.add(new BigDecimal("1.00")), scale, 4);
            } else {
                taxRate = PurInvoiceUtil.getLittleRate(taxRate);
                price = taxPrice.multiply(new BigDecimal("1.00").subtract(taxRate));
            }
        }
        return price;
    }

    public static BigDecimal calculateTaxPrice(BigDecimal taxRate, BigDecimal price, InvoiceTypeEnum invoiceType) {
        BigDecimal taxPrice = null;
        if (taxRate == null) {
            taxRate = new BigDecimal("0.00");
        }
        if (price != null) {
            if (!invoiceType.equals((Object)InvoiceTypeEnum.GENERAL)) {
                taxRate = PurInvoiceUtil.getLittleRate(taxRate);
                taxPrice = price.multiply(taxRate.add(new BigDecimal("1.00")));
            } else {
                taxRate = PurInvoiceUtil.getLittleRate(taxRate);
                int scale = taxRate.scale() + price.scale();
                taxPrice = price.divide(new BigDecimal("1.00").subtract(taxRate), scale, 4);
            }
        }
        return taxPrice;
    }

    public static BigDecimal getLittleRate(BigDecimal ratePercent) {
        BigDecimal rate = null;
        if (ratePercent == null) {
            return new BigDecimal("0.00");
        }
        int length = ratePercent.toString().length();
        if (length < 4) {
            length = 4;
        }
        rate = ratePercent.divide(new BigDecimal("100.0"), length, 4);
        return rate;
    }

    public static BigDecimal calculateDiscountAmount(BigDecimal taxPrice, BigDecimal qty, BigDecimal discountRate) {
        BigDecimal discountAmount = null;
        if (taxPrice == null || qty == null || discountRate == null) {
            discountAmount = new BigDecimal("0.00");
        } else {
            discountRate = PurInvoiceUtil.getLittleRate(discountRate);
            discountAmount = taxPrice.multiply(qty).multiply(discountRate);
        }
        return discountAmount;
    }

    public static BigDecimal calculateDealPrice(BigDecimal taxPrice, BigDecimal discountRate) {
        BigDecimal dealPrice = new BigDecimal("0.00");
        if (discountRate == null) {
            discountRate = new BigDecimal("0.0");
        }
        if (taxPrice != null) {
            discountRate = PurInvoiceUtil.getLittleRate(discountRate);
            BigDecimal temp1 = new BigDecimal("1.00").subtract(discountRate);
            dealPrice = taxPrice.multiply(temp1);
        }
        return dealPrice;
    }

    public static BigDecimal calculateTotalTaxPriceForGeneral(BigDecimal dealPrice, BigDecimal qty) {
        BigDecimal totalTaxPrice = null;
        totalTaxPrice = dealPrice.multiply(qty);
        return totalTaxPrice;
    }

    public static BigDecimal calculateTaxForGeneral(BigDecimal totalTaxPrice, BigDecimal taxRate) {
        BigDecimal taxAmount = null;
        taxRate = PurInvoiceUtil.getLittleRate(taxRate);
        taxAmount = totalTaxPrice.multiply(taxRate);
        return taxAmount;
    }

    public static BigDecimal calculateAmountForGeneral(BigDecimal totalTaxPrice, BigDecimal taxAmount) {
        BigDecimal amount = null;
        amount = totalTaxPrice.subtract(taxAmount);
        return amount;
    }

    public static BigDecimal calculateAmount(BigDecimal price, BigDecimal qty, BigDecimal discountRate, int pricePrecision) {
        BigDecimal amount = new BigDecimal("0.0");
        if (discountRate == null) {
            discountRate = new BigDecimal("0.0");
        }
        if (price != null && qty != null && discountRate != null) {
            discountRate = PurInvoiceUtil.getLittleRate(discountRate);
            BigDecimal temp = new BigDecimal("1.00").subtract(discountRate);
            BigDecimal realPrice = price.multiply(temp).setScale(pricePrecision, 4);
            amount = realPrice.multiply(qty);
        }
        return amount;
    }

    public static BigDecimal calculateTax(BigDecimal amount, BigDecimal taxRate) {
        BigDecimal taxAmount = null;
        if (taxRate == null) {
            taxRate = new BigDecimal("0.00");
        }
        if (amount == null) {
            amount = new BigDecimal("0.00");
        }
        taxRate = PurInvoiceUtil.getLittleRate(taxRate);
        taxAmount = amount.multiply(taxRate);
        return taxAmount;
    }

    public static BigDecimal calculateTotalTaxPrice(BigDecimal amount, BigDecimal taxAmount) {
        if (amount == null) {
            amount = new BigDecimal("0.00");
        }
        if (taxAmount == null) {
            taxAmount = new BigDecimal("0.00");
        }
        return amount.add(taxAmount);
    }

    public static void storeDefaultValues(PurInvoiceInfo editData, ExchangeRateInfo exchangeRateinfo) {
        BigDecimal totalTaxPrice = editData.getTotalTaxAmount();
        BigDecimal totalAmount = editData.getTotalAmount();
        if (exchangeRateinfo != null && exchangeRateinfo.getConvertRate() != null) {
            if (totalTaxPrice != null) {
                BigDecimal localTotalTaxPrice = PurInvoiceUtil.calculateLocalAmount(totalTaxPrice, exchangeRateinfo);
                editData.setLocalTotalTaxAmount(localTotalTaxPrice);
            }
            if (totalAmount != null) {
                BigDecimal localTotalAmount = PurInvoiceUtil.calculateLocalAmount(totalAmount, exchangeRateinfo);
                editData.setLocalTotalAmount(localTotalAmount);
            }
        } else {
            editData.setLocalTotalTaxAmount(totalTaxPrice);
            editData.setLocalTotalAmount(totalAmount);
        }
        PurInvoiceEntryCollection entryCollection = editData.getEntries();
        PurInvoiceEntryInfo entryInfo = null;
        int num = entryCollection.size();
        for (int i = 0; i < num; ++i) {
            entryInfo = entryCollection.get(i);
            BigDecimal entrylocalAmount = entryInfo.getLocalAmount();
            BigDecimal entryBaseQty = entryInfo.getBaseQty();
            BigDecimal entryQty = entryInfo.getQty();
            if (entrylocalAmount != null) {
                entryInfo.setUnWriteOffAmount(entrylocalAmount);
                entryInfo.setLocalUnwriteOffAmount(entrylocalAmount);
            }
            if (entryBaseQty != null) {
                entryInfo.setUnwriteOffBaseQty(entryBaseQty);
            }
            if (entryQty == null) continue;
            entryInfo.setUnwriteOffQty(entryQty);
        }
    }
}

