/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.report.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.headfootdesigner.HeadFootModel;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestListener;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.IQuerySolutionFacade;
import com.kingdee.eas.base.commonquery.QueryPanelInfo;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.config.ITablePreferenceHelper;
import com.kingdee.eas.framework.report.CommRptBaseFactory;
import com.kingdee.eas.framework.report.ICommRptBase;
import com.kingdee.eas.framework.report.client.CommRptBaseConditionUI;
import com.kingdee.eas.framework.report.util.DefaultKDTableInsertHandler;
import com.kingdee.eas.framework.report.util.KDTableInsertHandler;
import com.kingdee.eas.framework.report.util.KDTableUtil;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptParamsUtil;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.framework.report.util.RptTableHeader;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.client.SCMBillFilterUI;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.util.SCMUtil;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.sm.report.PurOrderScoutRptFacadeFactory;
import com.kingdee.eas.scm.sm.report.client.AbstractPurOrderScoutRptUI;
import com.kingdee.eas.scm.sm.report.client.PurOrderScoutRptConditionUI;
import com.kingdee.eas.scm.util.SCMRptUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class PurOrderScoutRptUI
extends AbstractPurOrderScoutRptUI {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = CoreUIObject.getLogger(PurOrderScoutRptUI.class);
    private static final String resClassName = "com.kingdee.eas.scm.sm.report.SMReportResource";
    private boolean firstLoadData = true;
    private String orgTempTable;
    private CustomerQueryPanel userPanel = null;
    private CommonQueryDialog queryDialog = new CommonQueryDialog();
    RptParams pp = new RptParams();

    public PurOrderScoutRptUI() throws Exception {
        this.tblMain.checkParsed();
        this.tblMain.getDataRequestManager().addDataRequestListener((KDTDataRequestListener)this);
        this.tblMain.getDataRequestManager().setDataRequestMode(1);
        this.enableExportExcel(this.tblMain);
        this.tblMain.getStyleAttributes().setLocked(true);
        this.prmtDateRange.setEnabled(false);
        this.prmtSupplierRange.setEnabled(false);
        this.prmtPurchaseOrg.setEnabled(false);
        this.tblMain.getDataRequestManager().setExportMemoryCallback(false);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        if (this.tHelper != null) {
            this.tHelper.setCanMoveColumn(true);
        }
    }

    protected void handlePermissionForItemAction(ItemAction action) {
        String actionName = action.getClass().getName();
        if (actionName.indexOf("$") >= 0) {
            actionName = actionName.substring(actionName.indexOf("$") + 1);
        }
        if ("ActionOnLoad".equals(actionName) && this.getOnloadPermItemName() == null) {
            return;
        }
        super.handlePermissionForItemAction(action);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void actionPageSetup_actionPerformed(ActionEvent e) throws Exception {
        super.actionPageSetup_actionPerformed(e);
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    public void actionHelp_actionPerformed(ActionEvent e) throws Exception {
        super.actionHelp_actionPerformed(e);
    }

    public void actionAbout_actionPerformed(ActionEvent e) throws Exception {
        super.actionAbout_actionPerformed(e);
    }

    public void actionOnLoad_actionPerformed(ActionEvent e) throws Exception {
        super.actionOnLoad_actionPerformed(e);
    }

    public void actionSendMessage_actionPerformed(ActionEvent e) throws Exception {
        super.actionSendMessage_actionPerformed(e);
    }

    public void actionCalculator_actionPerformed(ActionEvent e) throws Exception {
        super.actionCalculator_actionPerformed(e);
    }

    public void actionExport_actionPerformed(ActionEvent e) throws Exception {
        super.actionExport_actionPerformed(e);
    }

    public void actionExportSelected_actionPerformed(ActionEvent e) throws Exception {
        super.actionExportSelected_actionPerformed(e);
    }

    public void actionRegProduct_actionPerformed(ActionEvent e) throws Exception {
        super.actionRegProduct_actionPerformed(e);
    }

    public void actionPersonalSite_actionPerformed(ActionEvent e) throws Exception {
        super.actionPersonalSite_actionPerformed(e);
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.firstLoadData = true;
        this.insertRowCount = 0;
        super.actionRefresh_actionPerformed(e);
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        this.firstLoadData = true;
        this.insertRowCount = 0;
        super.actionQuery_actionPerformed(e);
    }

    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrint_actionPerformed(e);
    }

    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrintPreview_actionPerformed(e);
    }

    public void actionChart_actionPerformed(ActionEvent e) throws Exception {
        super.actionChart_actionPerformed(e);
    }

    @Override
    public void actionOrderQuerySetup_actionPerformed(ActionEvent e) throws Exception {
        super.actionOrderQuerySetup_actionPerformed(e);
    }

    protected ICommRptBase getRemoteInstance() throws BOSException {
        return PurOrderScoutRptFacadeFactory.getRemoteInstance();
    }

    protected KDTable getTableForPrintSetting() {
        return this.tblMain;
    }

    protected RptParams getParamsForInit() {
        RptParams initParam = new RptParams();
        return initParam;
    }

    protected CommRptBaseConditionUI getQueryDialogUserPanel() throws Exception {
        return null;
    }

    protected CustomerQueryPanel getCustomerQueryPanel() throws Exception {
        return new PurOrderScoutRptConditionUI();
    }

    protected void query() {
        this.tblMain.removeColumns();
        this.tblMain.removeRows();
        super.query();
        Calendar tempBDCalendar = Calendar.getInstance();
        Calendar tempEDCalendar = Calendar.getInstance();
        DateFormat format = CtrlFormatUtilities.getDateFormat();
        String bd = this.params.getString("dateStart");
        String ed = this.params.getString("dateEnd");
        tempBDCalendar.set(new Integer(bd.substring(0, 4)), new Integer(bd.substring(5, 7)) - 1, new Integer(bd.substring(8, 10)));
        tempEDCalendar.set(new Integer(ed.substring(0, 4)), new Integer(ed.substring(5, 7)) - 1, new Integer(ed.substring(8, 10)));
        Date beginDate = tempBDCalendar.getTime();
        Date endDate = tempEDCalendar.getTime();
        this.prmtDateRange.setText(format.format(beginDate) + "-" + format.format(endDate));
        StringBuffer purchaseOrgUnitbf = new StringBuffer();
        Object[] purchaseOrgUnit = (Object[])this.params.getObject("fullOrgUnit");
        int n = purchaseOrgUnit.length;
        for (int i = 0; i < n; ++i) {
            purchaseOrgUnitbf.append((String)((FullOrgUnitInfo)purchaseOrgUnit[i]).get("name") + ";");
        }
        this.params.setString("OrgUnitFilter", purchaseOrgUnitbf.toString());
        this.prmtPurchaseOrg.setText(purchaseOrgUnitbf.toString());
        String supplierFromNumber = null;
        String supplierFromNumbers = null;
        if (this.params.getObject("SupplierFrom") != null) {
            String[] numArray = SCMUtil.getF7Numbers((Object)this.params.getObject("SupplierFrom"), (Boolean)false, (String)";");
            supplierFromNumber = numArray[0];
            supplierFromNumbers = numArray[1];
        }
        String supplierTo = this.params.getObject("SupplierTo") != null ? this.params.getObject("SupplierTo").toString() : "";
        if (supplierFromNumber != null && this.params.getObject("SupplierTo") != null) {
            this.prmtSupplierRange.setText(supplierFromNumber + "_" + supplierTo);
        } else if (supplierFromNumber == null && supplierFromNumbers == null && this.params.getObject("SupplierTo") == null) {
            this.prmtSupplierRange.setText(EASResource.getString((String)resClassName, (String)"AllSupplier"));
        } else {
            if (supplierFromNumber != null) {
                this.prmtSupplierRange.setText(supplierFromNumber);
            }
            if (supplierFromNumbers != null) {
                this.prmtSupplierRange.setText(supplierFromNumbers);
            }
            if (!StringUtils.isEmpty((String)supplierTo)) {
                this.prmtSupplierRange.setText(supplierTo);
            }
        }
    }

    public void getData(KDTDataRequestEvent e) {
        this.tblMain.getDataRequestManager().removeDataRequestListener((KDTDataRequestListener)this);
        int from = e.getFirstRow();
        int len = e.getLastRow() - from + 1;
        int precision = 10;
        this.tblMain.getMergeManager().setMergeMode(0);
        try {
            if (from == 0 && this.firstLoadData) {
                int freezeCol;
                this.pp.clear();
                this.pp.putAll(this.params.toMap());
                RptParams rpt = PurOrderScoutRptFacadeFactory.getRemoteInstance().createTempTable(this.pp);
                this.setTempTable(rpt.getString("tempTable"));
                RptTableHeader header = (RptTableHeader)rpt.getObject("header");
                this.pp.setString("tempTable", rpt.getString("tempTable"));
                this.orgTempTable = rpt.getString("PurChaseUnitTempTable");
                this.pp.setString("PurChaseUnitTempTable", this.orgTempTable);
                KDTableUtil.setHeader((RptTableHeader)header, (KDTable)this.tblMain);
                if (this.params.getBoolean("ckBxShowMShortName")) {
                    freezeCol = this.tblMain.getColumnIndex("MATERIAL_SHORTNAME");
                    this.tblMain.getViewManager().setFreezeView(-1, freezeCol + 1);
                } else {
                    freezeCol = this.tblMain.getColumnIndex("MATERIAL_NUMBER");
                    this.tblMain.getViewManager().setFreezeView(-1, freezeCol + 1);
                }
                this.tblMain.getColumn("MATERIAL_FID").getStyleAttributes().setHided(true);
                if (rpt.getObject("verticalCount") != null) {
                    this.tblMain.setRowCount(rpt.getInt("verticalCount"));
                }
                this.tblMain.getColumn(this.getTreeCol()).getStyleAttributes().setLocked(true);
                if (this.tHelper != null) {
                    this.tHelper.setDefaultUserData(null);
                }
                this.initUserConfig();
                rpt = PurOrderScoutRptFacadeFactory.getRemoteInstance().query(this.pp, from, len);
                RptRowSet rs = (RptRowSet)rpt.getObject("rowset");
                this.insertRows(rs, from, this.tblMain, true, (KDTableInsertHandler)new DefaultKDTableInsertHandler(rs), 0);
                this.setTableColumnsFormat(this.tblMain, SCMClientUtils.getFormatPattern((int)precision, (boolean)true));
                this.firstLoadData = false;
            } else {
                RptParams rpt = PurOrderScoutRptFacadeFactory.getRemoteInstance().query(this.pp, from, len);
                RptRowSet rs = (RptRowSet)rpt.getObject("rowset");
                this.insertRows(rs, from, this.tblMain, true, (KDTableInsertHandler)new DefaultKDTableInsertHandler(rs), 0);
            }
            this.setTableColumnsFormat(this.tblMain, SCMClientUtils.getFormatPattern((int)precision, (boolean)true));
            this.tblMain.getDataRequestManager().addDataRequestListener((KDTDataRequestListener)this);
        }
        catch (Exception ee) {
            logger.error((Object)ee);
            this.handUIExceptionAndAbort(ee);
        }
    }

    private void setTableColumnsFormat(KDTable kdtEntries, String strFormat) {
        IColumn col = null;
        for (int i = 0; i < kdtEntries.getColumnCount(); ++i) {
            col = kdtEntries.getColumn(i);
            if (col != null && this.isQtyColumn(col.getKey())) {
                col.getStyleAttributes().setNumberFormat(strFormat);
            }
            if (col == null || !col.getKey().equals("DELIVERYDATE")) continue;
            String format = CtrlFormatUtilities.getDateFormatString();
            col.getStyleAttributes().setNumberFormat(format);
        }
    }

    private boolean isQtyColumn(String columnName) {
        boolean isQtyColumn = false;
        if (columnName == null) {
            return false;
        }
        if (columnName.equals("ORDER_QTY") || columnName.equals("TOTALRECEIVE_QTY") || columnName.equals("NOINWAREHS_QTY")) {
            isQtyColumn = true;
        }
        return isQtyColumn;
    }

    public void insertRows(RptRowSet rs, int insertRowIndex, KDTable table, boolean refreshUI, KDTableInsertHandler handler, int insertRowCount) {
        table.setRefresh(false);
        int rowIndex = insertRowIndex + insertRowCount;
        Object[] rowData = null;
        while (rs.next()) {
            IRow row = table.addRow(rowIndex++);
            if (rs.getInt("FBASESTATUS") == 4) {
                rs.setValue("FBASESTATUS", (Object)BillBaseStatusEnum.AUDITED.getAlias());
            } else if (rs.getInt("FBASESTATUS") == -2) {
                rs.setValue("FBASESTATUS", (Object)BillBaseStatusEnum.ALTERING.getAlias());
            } else if (rs.getInt("FBASESTATUS") == 1) {
                rs.setValue("FBASESTATUS", (Object)BillBaseStatusEnum.TEMPORARILYSAVED.getAlias());
            } else if (rs.getInt("FBASESTATUS") == 2) {
                rs.setValue("FBASESTATUS", (Object)BillBaseStatusEnum.SUBMITED.getAlias());
            } else if (rs.getInt("FBASESTATUS") == 7) {
                rs.setValue("FBASESTATUS", (Object)BillBaseStatusEnum.CLOSED.getAlias());
            }
            Object[] data = rs.toRowArray();
            for (int i = 0; i < data.length; ++i) {
                if (!(data[i] instanceof BigDecimal) || ((BigDecimal)data[i]).compareTo(new BigDecimal("0.0")) != 0) continue;
                data[i] = new BigDecimal("0.0");
            }
            rowData = SCMRptUtil.sortRowData((Object[])data, (CoreUI)this, (KDTable)table, (ITablePreferenceHelper)this.tHelper);
            handler.setTableRowData(row, rowData);
        }
        if (refreshUI) {
            table.setRefresh(true);
        }
        if (rs.getRowCount() > 0) {
            table.reLayoutAndPaint();
        } else {
            table.repaint();
        }
    }

    public static String getFormatString(int scale) {
        String temp = "";
        for (int i = 0; i < scale; ++i) {
            temp = temp + '0';
        }
        if (scale >= 0) {
            temp = temp.equals("") ? "%r{#,##0}f" : "%r{#,##0." + temp + "}f";
        }
        return temp;
    }

    public String[] getMergeColumnKeys() {
        String[] strMergeColKeys = new String[]{"MATERIAL_NUMBER", "MATERIAL_NAME", "MATERIAL_MODEL", "MATERIALGROUP_NAME", "UNIT_NAME"};
        return strMergeColKeys;
    }

    public String getTreeCol() {
        return "PURCHASEORG_NAME";
    }

    public void beforePrint() {
        this.logUIOperation("LOG_REPORT9");
    }

    private void logUIOperation(String key) {
        String operName = EASResource.getString((String)resClassName, (String)key);
        IObjectPK pk = LogUtil.beginLog(null, (String)operName, (BOSObjectType)new BOSObjectType("05BCC5DC"), null, (String)operName);
        LogUtil.afterLog(null, (IObjectPK)pk);
    }

    protected KDTable getTable() {
        return this.tblMain;
    }

    protected void preparePrintPageHeader(HeadFootModel header) {
        StyleAttributes sa = Styles.getDefaultSA();
        StringBuffer sb = new StringBuffer();
        sb.append(EASResource.getString((String)resClassName, (String)"Date"));
        sb.append(" : &[DateStart]");
        sb.append(" - &[DateEnd]");
        sb.append(" ");
        sb.append(EASResource.getString((String)resClassName, (String)"supplierNameABC"));
        sb.append(" : &[SupplierRange]");
        sb.append("&|");
        header.addRow(sb.toString(), sa);
    }

    protected Map preparePrintVariantMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        Calendar tempBDCalendar = Calendar.getInstance();
        Calendar tempEDCalendar = Calendar.getInstance();
        String str = this.prmtSupplierRange.getText();
        String bd = this.params.getString("dateStart");
        String ed = this.params.getString("dateEnd");
        tempBDCalendar.set(new Integer(bd.substring(0, 4)), new Integer(bd.substring(5, 7)) - 1, new Integer(bd.substring(8, 10)));
        tempEDCalendar.set(new Integer(ed.substring(0, 4)), new Integer(ed.substring(5, 7)) - 1, new Integer(bd.substring(8, 10)));
        Date beginDate = tempBDCalendar.getTime();
        Date endDate = tempEDCalendar.getTime();
        DateFormat format = CtrlFormatUtilities.getDateFormat();
        String dateStart = format.format(beginDate).toString();
        String dateEnd = format.format(endDate).toString();
        map.put("DateStart", dateStart);
        map.put("DateEnd", dateEnd);
        map.put("SupplierRange", str);
        return map;
    }

    protected boolean isLoadPrintSetting() {
        return false;
    }

    public String getServerResource(String key, Context ctx) {
        return SCMUtils.getResource((String)resClassName, (String)key, (Context)ctx);
    }

    protected boolean showQueryDialog(boolean useDefaultSolution) {
        CustomerParams cp = null;
        try {
            SCMBillFilterUI rbqp;
            this.initQueryDialog();
            this.userPanel.getUIContext().clear();
            this.userPanel.getUIContext().putAll(this.getUIContext());
            if (useDefaultSolution) {
                IQuerySolutionFacade iQuery = QuerySolutionFacadeFactory.getRemoteInstance();
                String queryName = MetaDataLoaderFactory.getRemoteMetaDataLoader().getQuery(this.getQueryMetaDataPK()).getFullName();
                if (iQuery.hasDefaultSolution(this.getMetaDataPK().getFullName(), queryName)) {
                    QuerySolutionInfo solution = iQuery.getDefaultSolution(this.getMetaDataPK().getFullName(), queryName);
                    this.queryDialog.setCurrentSolutionInfo(solution);
                    QueryPanelInfo qpi = solution.getQueryPanelInfo().get(0);
                    if (qpi != null) {
                        try {
                            cp = CustomerParams.getCustomerParams2((String)qpi.getCustomerParams());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            }
            boolean ok = false;
            if ((cp == null || !useDefaultSolution) && this.queryDialog.show()) {
                rbqp = (SCMBillFilterUI)this.queryDialog.getUserPanel(0);
                this.params = rbqp.getCustomCondition();
                ok = true;
            }
            if (cp != null) {
                rbqp = (SCMBillFilterUI)this.getCustomerQueryPanel();
                rbqp.setCustomerParams(cp);
                rbqp.loadData(null);
                this.params = rbqp.getCustomCondition();
            }
            if (this.params != null && (ok || useDefaultSolution)) {
                this.queryWithWrap();
                return true;
            }
        }
        catch (Exception e) {
            logger.error((Object)"@showQueryDialog", (Throwable)e);
            this.handleException(e);
        }
        return false;
    }

    private void initQueryDialog() throws Exception {
        if (this.userPanel == null) {
            this.userPanel = this.getCustomerQueryPanel();
            this.userPanel.loadFields();
            Dimension dd = this.userPanel.getSize();
            this.queryDialog.setMaxReturnCountVisible(false);
            this.queryDialog.setWidth(540);
            this.queryDialog.setHeight(310);
            this.queryDialog.addUserPanel((KDPanel)this.userPanel);
            this.queryDialog.setOwner((Component)this.getUIContext().get("Owner"));
            this.queryDialog.setTitle(this.userPanel.getUITitle());
            this.queryDialog.setQueryObjectPK(this.getQueryMetaDataPK());
            this.queryDialog.setShowFilter(false);
            this.queryDialog.setShowSorter(false);
            this.queryDialog.setParentUIClassName(this.getMetaDataPK().getFullName());
            Method m = this.userPanel.getClass().getMethod("onInit", RptParams.class);
            m.invoke((Object)this.userPanel, this.getUIContextInitParams());
            this.userPanel.initLayout();
            if (this.params != null) {
                this.userPanel.setCustomerParams(RptParamsUtil.setToCustomerParams((CustomerParams)new CustomerParams(), (Object)this.params));
            }
        }
    }

    protected String getUIFullName() {
        return "com.kingdee.eas.scm.sm.report.client.PurOrderScoutRptUI";
    }

    public boolean isAsynchronism() {
        return true;
    }

    protected void disposeUIWindow() {
        if (this.orgTempTable != null) {
            try {
                CommRptBaseFactory.getRemoteInstance().dropPoolTempTable(this.orgTempTable);
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
        super.disposeUIWindow();
    }

    public Object getTablePreferenceSchemaKey() {
        BOSUuid object = null;
        if (this.queryDialog.getCurrentSolutionInfo() != null) {
            object = this.queryDialog.getCurrentSolutionInfo().getId();
        }
        if (object == null && this.queryDialog.getCommonQueryParam().getCurrentSolutionInfo() != null) {
            object = this.queryDialog.getCommonQueryParam().getCurrentSolutionInfo().getId();
        }
        return object;
    }
}

