/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.report.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.extendcontrols.ext.IFilterInfoProducer;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.NewOrgUnitFilterInfoProducer;
import com.kingdee.eas.basedata.scm.sm.pur.DemandTypeCollection;
import com.kingdee.eas.basedata.scm.sm.pur.DemandTypeFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.client.SCMGroupClientUtils;
import com.kingdee.eas.scm.common.filter.CompositeFilterElement;
import com.kingdee.eas.scm.common.filter.FilterElement;
import com.kingdee.eas.scm.common.filter.MultiF7FilterElement;
import com.kingdee.eas.scm.common.filter.SingleFilterElement;
import com.kingdee.eas.scm.common.util.OrgUnitUtils;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.common.verify.VerifyItem;
import com.kingdee.eas.scm.common.verify.VerifyType;
import com.kingdee.eas.scm.sm.report.client.AbstractPurRequestTotalConditionUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.util.Date;
import org.apache.log4j.Logger;

public class PurRequestTotalConditionUI
extends AbstractPurRequestTotalConditionUI {
    private static final long serialVersionUID = -5595862492631421148L;
    private static final Logger logger = CoreUIObject.getLogger(PurRequestTotalConditionUI.class);

    public PurRequestTotalConditionUI() throws Exception {
        this.setBizMaterialF7(this.prmtMaterialFrom, true, null);
        this.setBizMaterialF7(this.prmtMaterialTo, false, null);
        SCMClientUtils.addListenerForMultiF7((KDBizPromptBox)this.prmtMaterialFrom, (KDBizPromptBox)this.prmtMaterialTo);
        NewOrgUnitFilterInfoProducer iProducerAdm = new NewOrgUnitFilterInfoProducer(OrgType.Admin);
        this.prmtAdminOrg.setQueryInfo("com.kingdee.eas.basedata.org.app.AdminOrgUnitQuery");
        this.prmtAdminOrg.setFilterInfoProducer((IFilterInfoProducer)iProducerAdm);
        NewOrgUnitFilterInfoProducer iProducerSt = new NewOrgUnitFilterInfoProducer(OrgType.Storage);
        this.prtReqStorageOrgTo.setQueryInfo("com.kingdee.eas.basedata.org.app.StorageOrgUnitQuery");
        this.prtReqStorageOrgTo.setFilterInfoProducer((IFilterInfoProducer)iProducerSt);
        NewOrgUnitFilterInfoProducer iProducer = new NewOrgUnitFilterInfoProducer(OrgType.Purchase);
        this.prtPurchaseOrg.setQueryInfo("com.kingdee.eas.basedata.org.app.PurchaseOrgUnitQuery");
        this.prtPurchaseOrg.setFilterInfoProducer((IFilterInfoProducer)iProducer);
        DataChangeListener purDataChangeListener = new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                try {
                    PurRequestTotalConditionUI.this.prmtPurchaseOrgUnit_dataChanged(e);
                }
                catch (Exception exc) {
                    PurRequestTotalConditionUI.this.handUIException(exc);
                }
            }
        };
        this.prtPurchaseOrg.addDataChangeListener(purDataChangeListener);
        EntityViewInfo view = this.getDemandTypeFilter();
        this.prmtDemandType.setEntityViewInfo(view);
        CompositeFilterElement elements = new CompositeFilterElement(0);
        Date date = SCMClientUtils.getServerDate2();
        SingleFilterElement element = new SingleFilterElement("dateFrom", (Component)this.dtpDateFrom);
        element.setCompareType(CompareType.GREATER_EQUALS);
        elements.add((FilterElement)element);
        element = new SingleFilterElement("dateTo", (Component)this.dtpDateTo);
        element.setCompareType(CompareType.LESS_EQUALS);
        elements.add((FilterElement)element);
        element = new SingleFilterElement("fromCompanys", (Component)this.prtFromCompanys);
        element.setCompareType(CompareType.INCLUDE);
        elements.add((FilterElement)element);
        element = new SingleFilterElement("purchaseOrgFrom", (Component)this.prtPurchaseOrg);
        element.setCompareType(CompareType.EQUALS);
        element.addVerifyItem(new VerifyItem(VerifyType.REQUIRED_TYPE, this.getResource("PurOrgFromIsRequired")));
        elements.add((FilterElement)element);
        MultiF7FilterElement materialElement = new MultiF7FilterElement("materialFrom", this.prmtMaterialFrom, Boolean.valueOf(false));
        elements.add((FilterElement)materialElement);
        element = new SingleFilterElement("materialTo", (Component)this.prmtMaterialTo);
        element.setCompareType(CompareType.LESS_EQUALS);
        elements.add((FilterElement)element);
        element = new SingleFilterElement("traceNoFrom", (Component)this.txtTraceNoFrom);
        element.setCompareType(CompareType.GREATER_EQUALS);
        elements.add((FilterElement)element);
        element = new SingleFilterElement("traceNoTo", (Component)this.txtTraceNoTo);
        element.setCompareType(CompareType.LESS_EQUALS);
        elements.add((FilterElement)element);
        element = new SingleFilterElement("trackNo", (Component)this.prmtTrackNumber);
        element.setCompareType(CompareType.EQUALS);
        elements.add((FilterElement)element);
        element = new SingleFilterElement("fprojectID", (Component)this.prmtProject);
        element.setCompareType(CompareType.EQUALS);
        elements.add((FilterElement)element);
        element = new SingleFilterElement("requestorFrom", (Component)this.prmtRequestorFrom);
        element.setCompareType(CompareType.GREATER_EQUALS);
        elements.add((FilterElement)element);
        element = new SingleFilterElement("requestorTo", (Component)this.prmtRequestorTo);
        element.setCompareType(CompareType.LESS_EQUALS);
        elements.add((FilterElement)element);
        element = new SingleFilterElement("conatainRevoke", (Component)this.chkContainRevoked);
        element.setCompareType(CompareType.EQUALS);
        element.setDefaultValue((Object)Boolean.FALSE);
        elements.add((FilterElement)element);
        element = new SingleFilterElement("conatainClose", (Component)this.chkContainClosed);
        element.setCompareType(CompareType.EQUALS);
        element.setDefaultValue((Object)Boolean.FALSE);
        elements.add((FilterElement)element);
        element = new SingleFilterElement("requestOrgTo", (Component)this.prtReqStorageOrgTo);
        element.setCompareType(CompareType.EQUALS);
        elements.add((FilterElement)element);
        element = new SingleFilterElement("demandType", (Component)this.prmtDemandType);
        element.setCompareType(CompareType.EQUALS);
        elements.add((FilterElement)element);
        element = new SingleFilterElement("adminOrg", (Component)this.prmtAdminOrg);
        element.setCompareType(CompareType.EQUALS);
        elements.add((FilterElement)element);
        this.getFilterManager().setElement((FilterElement)elements);
        this.setNeedMainOrgF7s(new KDBizPromptBox[]{this.prmtMaterialFrom, this.prmtMaterialTo});
    }

    protected void setDefaultValue() {
        Date date = SCMClientUtils.getServerDate2();
        this.dtpDateFrom.setValue((Object)SCMUtils.getSCMQueryTime((Date)date, (String)"startDate"));
        this.dtpDateTo.setValue((Object)SCMUtils.getSCMQueryTime((Date)date, (String)"endDate"));
        try {
            EntityViewInfo view = this.getDemandTypeFilter();
            DemandTypeCollection col = DemandTypeFactory.getRemoteInstance().getDemandTypeCollection(view);
            if (col != null && col.size() > 0) {
                this.prmtDemandType.setValue((Object)col.get(0));
            }
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.prtFromCompanys.setRequired(false);
        this.kDLabel1.setVisible(false);
    }

    protected void prmtPurchaseOrgUnit_dataChanged(DataChangeEvent e) {
        if (e.getNewValue() != null) {
            try {
                OrgUnitInfo purchaseInfo = (OrgUnitInfo)e.getNewValue();
                this.prtReqStorageOrgTo.setDisplayFormat("$name$");
                this.prtReqStorageOrgTo.setEditFormat("$number$");
                this.prtReqStorageOrgTo.setCommitFormat("$number$;$code$");
                SCMGroupClientUtils.setBizOrgF7ByType((KDBizPromptBox)this.prtReqStorageOrgTo, (OrgType)OrgType.Storage, (OrgType)OrgType.Purchase, (boolean)true);
                this.prtReqStorageOrgTo.setCurrentMainBizOrgUnit(purchaseInfo, OrgType.Purchase);
                this.prtReqStorageOrgTo.setEditable(true);
                this.prtReqStorageOrgTo.setData(null);
                this.prmtAdminOrg.setDisplayFormat("$name$");
                this.prmtAdminOrg.setEditFormat("$number$");
                this.prmtAdminOrg.setCommitFormat("$number$;$code$");
                SCMGroupClientUtils.setBizOrgF7ByType((KDBizPromptBox)this.prmtAdminOrg, (OrgType)OrgType.Admin, (OrgType)OrgType.Purchase, (boolean)true);
                this.prmtAdminOrg.setCurrentMainBizOrgUnit(purchaseInfo, OrgType.Purchase);
                this.prmtAdminOrg.setEditable(true);
                this.prmtAdminOrg.setData(null);
                this.prmtTrackNumber.setCurrentMainBizOrgUnit(purchaseInfo, OrgType.Purchase);
                this.prmtTrackNumber.setValue(null);
            }
            catch (Exception exp) {
                this.handUIException(exp);
            }
        }
    }

    public boolean verify() {
        boolean ret = super.verify();
        if (!ret) {
            return false;
        }
        if (this.dtpDateFrom.getTimestamp() != null && this.dtpDateTo.getTimestamp() != null && this.dtpDateFrom.getTimestamp().getTime() > this.dtpDateTo.getTimestamp().getTime()) {
            String errMsg = this.getResource("DateRangeError");
            MsgBox.showInfo((Component)((Object)this), (String)errMsg);
            this.dtpDateFrom.requestFocus();
            return false;
        }
        String adminOrgToNum = this.prmtAdminOrg.getText();
        if (this.prmtAdminOrg.getData() == null && adminOrgToNum != null && adminOrgToNum.trim().length() > 0) {
            OrgUnitInfo orgAdmin = null;
            try {
                orgAdmin = OrgUnitUtils.getOrgUnitInfoByNum(null, (String)adminOrgToNum);
            }
            catch (Exception e) {
                this.handUIException(e);
                return false;
            }
            AdminOrgUnitInfo adminOrg = new AdminOrgUnitInfo();
            adminOrg.setId(orgAdmin.getId());
            adminOrg.setName(orgAdmin.getName());
            adminOrg.setNumber(orgAdmin.getNumber());
            this.prmtAdminOrg.setData((Object)adminOrg);
        }
        String requestOrgToNum = this.prtReqStorageOrgTo.getText();
        if (this.prtReqStorageOrgTo.getData() == null && requestOrgToNum != null && requestOrgToNum.trim().length() > 0) {
            try {
                OrgUnitInfo orgReq = OrgUnitUtils.getOrgUnitInfoByNum(null, (String)requestOrgToNum);
                StorageOrgUnitInfo storageOrg = new StorageOrgUnitInfo();
                storageOrg.setId(orgReq.getId());
                storageOrg.setName(orgReq.getName());
                storageOrg.setNumber(orgReq.getNumber());
                this.prtReqStorageOrgTo.setData((Object)storageOrg);
            }
            catch (Exception e) {
                this.handUIException(e);
                return false;
            }
        }
        if (this.prtReqStorageOrgTo.getData() == null) {
            String errMsg = this.getResource("ReqeustOrgIsRequried");
            MsgBox.showInfo((Component)((Object)this), (String)errMsg);
            this.prtReqStorageOrgTo.requestFocus();
            return false;
        }
        String demandType = this.prmtDemandType.getText();
        if (this.prmtDemandType.getData() == null && demandType != null && demandType.trim().length() > 0) {
            try {
                CoreBaseCollection col = DemandTypeFactory.getRemoteInstance().getCollection("where number = '" + demandType + "'");
                if (null != col && col.size() > 0) {
                    this.prmtDemandType.setData((Object)col.get(0));
                }
            }
            catch (Exception e) {
                this.handUIException(e);
                return false;
            }
        }
        if (this.prmtDemandType.getData() == null) {
            String errMsg = this.getResource("DemandTypeIsRequried");
            MsgBox.showInfo((Component)((Object)this), (String)errMsg);
            this.prmtDemandType.requestFocus();
            return false;
        }
        return true;
    }

    public void clear() {
        block5: {
            this.dtpDateFrom.setValue(null);
            this.dtpDateTo.setValue(null);
            super.clear();
            this.prtFromCompanys.setData(null);
            this.prtPurchaseOrg.setData(null);
            try {
                IPermission iPerm = PermissionFactory.getRemoteInstance();
                ObjectUuidPK userPk = new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId());
                FullOrgUnitCollection orgCol = iPerm.getAuthorizedOrg((IObjectPK)userPk, OrgType.Purchase, null, null);
                OrgUnitInfo[] purOrgUnits = SCMGroupClientUtils.getOrgUnitInfosByType((FullOrgUnitCollection)orgCol, (OrgType)OrgType.Purchase);
                FullOrgUnitInfo ouInfo = (FullOrgUnitInfo)SysContext.getSysContext().getCurrentOrgUnit();
                if (purOrgUnits == null) break block5;
                int size = purOrgUnits.length;
                for (int i = 0; i < size; ++i) {
                    PurchaseOrgUnitInfo org = (PurchaseOrgUnitInfo)purOrgUnits[i];
                    if (!org.isIsBizUnit()) continue;
                    if (ouInfo != null && ouInfo.getId().equals((Object)org.getId())) {
                        this.prtPurchaseOrg.setData((Object)org);
                        break;
                    }
                    this.prtPurchaseOrg.setData((Object)org);
                }
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
            catch (EASBizException e) {
                this.handUIException(e);
            }
        }
    }

    private EntityViewInfo getDemandTypeFilter() {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)1));
        filter.getFilterItems().add(new FilterItemInfo("purchanseType", (Object)0));
        filter.getFilterItems().add(new FilterItemInfo("rowType.destinationType", (Object)10));
        view.setFilter(filter);
        SorterItemCollection sort = new SorterItemCollection();
        sort.add(new SorterItemInfo("number"));
        view.setSorter(sort);
        return view;
    }

    protected String getPropertyOfMainBizOrg() {
        return "id";
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.prtFromCompanys;
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Company;
    }

    protected String getViewPermission() {
        return "purreqtotal_view";
    }

    private String getResource(String key) {
        return EASResource.getString((String)"com.kingdee.eas.scm.sm.report.PurRequestTotalResource", (String)key);
    }
}

