/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.report.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTActiveCellListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDLayout;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.commonquery.IQuerySolutionFacade;
import com.kingdee.eas.base.commonquery.QueryPanelInfo;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.ConvertModeEnum;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateFactory;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.ExchangeTableInfo;
import com.kingdee.eas.basedata.assistant.IExchangeRate;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.cssp.CSSPGroupInfo;
import com.kingdee.eas.basedata.master.cssp.ISupplierPurchaseInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierPurchaseInfoCollection;
import com.kingdee.eas.basedata.master.cssp.SupplierPurchaseInfoFactory;
import com.kingdee.eas.basedata.master.cssp.UsedStatusEnum;
import com.kingdee.eas.basedata.master.material.AsstAttrValueInfo;
import com.kingdee.eas.basedata.master.material.IMultiMeasureUnit;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitCollection;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.BizTypeInfo;
import com.kingdee.eas.basedata.scm.common.RowTypeInfo;
import com.kingdee.eas.basedata.scm.sm.pur.DemandTypeFactory;
import com.kingdee.eas.basedata.scm.sm.pur.DemandTypeInfo;
import com.kingdee.eas.basedata.scm.sm.pur.IDemandType;
import com.kingdee.eas.basedata.scm.sm.srm.ApprovedSupplierCollection;
import com.kingdee.eas.basedata.scm.sm.srm.ApprovedSupplierFactory;
import com.kingdee.eas.basedata.scm.sm.srm.IApprovedSupplier;
import com.kingdee.eas.basedata.scm.sm.srm.ISupplyInfo;
import com.kingdee.eas.basedata.scm.sm.srm.SupplyInfoFactory;
import com.kingdee.eas.basedata.scm.sm.srm.SupplyInfoInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.FrameWorkUtils;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.report.ICommRptBase;
import com.kingdee.eas.framework.report.client.CommRptBaseConditionUI;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptParamsUtil;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.SCMBillException;
import com.kingdee.eas.scm.common.client.GeneralKDPromptSelectorAdaptor;
import com.kingdee.eas.scm.common.client.MaterialQueryListUI;
import com.kingdee.eas.scm.common.client.SCMBillFilterUI;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.util.CalculateUtils;
import com.kingdee.eas.scm.common.util.CurrencyExchangeRateUtils;
import com.kingdee.eas.scm.common.util.OrgUnitUtils;
import com.kingdee.eas.scm.common.util.ResourceUtils;
import com.kingdee.eas.scm.sm.pur.PurOrderException;
import com.kingdee.eas.scm.sm.pur.PurOrderInfo;
import com.kingdee.eas.scm.sm.pur.PurRequestEntryInfo;
import com.kingdee.eas.scm.sm.pur.PurRequestInfo;
import com.kingdee.eas.scm.sm.report.IPurRequestTotalFacade;
import com.kingdee.eas.scm.sm.report.PurRequestTotalFacadeFactory;
import com.kingdee.eas.scm.sm.report.SMReportException;
import com.kingdee.eas.scm.sm.report.client.AbstractPurRequestTotalUI;
import com.kingdee.eas.scm.sm.report.client.PurRequestTotalConditionUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.swing.ActionMap;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class PurRequestTotalUI
extends AbstractPurRequestTotalUI {
    private static final long serialVersionUID = 7221640834141578939L;
    private static final Logger logger = CoreUIObject.getLogger(PurRequestTotalUI.class);
    public static final BigDecimal MAXVAL = new BigDecimal("9999999999999");
    private IUIWindow materialWindow = null;
    ArrayList assistantList = null;
    RptRowSet rowSet = null;
    KDTEditAdapter editAdapter = null;
    KDTActiveCellListener activeCellListener = null;
    private boolean autoNumber = false;
    private CompanyOrgUnitInfo companyInfo = null;
    private CurrencyInfo baseCurrencyInfo = null;
    private StorageOrgUnitInfo reqStorageOrg = null;
    private AdminOrgUnitInfo adminOrg = null;
    private DemandTypeInfo demandType = null;
    private boolean isOnlyAvailableSupplier = true;
    private static String ConfirmQty_F = "confirmqty";
    private static String MaterialId_F = "fmaterialid";
    private static String SupplierId_F = "fsupplierid";
    private static String SupplierName_F = "supplierName";
    private static String CurrencyId_F = "fcurrencyid";
    private static String CurrencyName_F = "bdCurrencyName";
    private static String PurchasePrice_F = "FPrice";
    private static String DemandDate_F = "frequirementdate";
    private static String DeliveryDate_F = "fproposedeliverydate";
    private static String TraceNum_F = "ftracknumber";
    private static String TrackNumber_F = "trackNo";
    private static String Project_F = "fprojectID";
    private static String PricePrc_F = "PricePrecision";
    private ISupplierPurchaseInfo iSupplierPurchaseInfo = null;
    private IApprovedSupplier iApprovedSupplier = null;
    private static final String allSupplierQery = "com.kingdee.eas.basedata.master.cssp.app.F7SupplierQueryWithDefaultStandard";
    private static final String[] unlockedColumns = new String[]{"confirmqty", "supplierName", "frequirementdate", "fproposedeliverydate", "bdCurrencyName", "FPrice", "ftracknumber"};
    private static final String[] hideColumns = new String[]{"billstate", "receivingOrgName", "RowType", "matrerilGroupName", "AssistProperty", "requestQty", "supplierName", "fproposedeliverydate", "ftracknumber", "fprojectID"};
    public Map<String, ExchangeRateInfo> ExchangeRateMap = new HashMap<String, ExchangeRateInfo>();

    public PurRequestTotalUI() throws Exception {
        this.tblMain.getDataRequestManager().addDataRequestListener((KDTDataRequestListener)this);
        this.tblMain.getDataRequestManager().setDataRequestMode(0);
        this.tblMain.checkParsed();
        this.enableExportExcel(this.tblMain);
        ActionMap actionMap = this.tblMain.getActionMap();
        actionMap.remove("AddRow");
        actionMap.remove("RemoveRow");
        actionMap.remove("Delete");
        this.btnGenOrderBill.setIcon(EASResource.getIcon((String)"imgTbtn_output"));
        this.btnGenRequestBill.setIcon(EASResource.getIcon((String)"imgTbtn_output"));
        this.btnQueryStorage.setIcon(EASResource.getIcon((String)"imgTbtn_demandcollateresult"));
        this.btnGetAvailableSupplier.setIcon(EASResource.getIcon((String)"imgTbtn_affixmanage"));
    }

    private void isAutoNumber() {
        try {
            ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
            SCMBillBaseInfo objectValue = null;
            String bizOrgUnitID = null;
            if (this.companyInfo == null) {
                return;
            }
            if (this.params.getInt("targetBill") == 1) {
                objectValue = new PurRequestInfo();
                bizOrgUnitID = this.companyInfo.getId().toString();
            } else {
                objectValue = new PurOrderInfo();
                bizOrgUnitID = ((OrgUnitInfo)this.params.getObject("purchaseOrgTo")).getId().toString();
            }
            this.autoNumber = codingRuleManager.isExist((IObjectValue)objectValue, bizOrgUnitID);
        }
        catch (Exception exp) {
            this.handUIExceptionAndAbort(exp);
        }
        this.lblContainer.setVisible(!this.autoNumber);
        int y = this.autoNumber ? 13 : 44;
        this.tblMain.setBounds(10, y, 973, 567 - y);
        this.add((Component)this.tblMain, new KDLayout.Constraints(10, y, 973, 567 - y, 15));
        this.updateUI();
    }

    private String getBillNumber(PurRequestInfo purReq) {
        if (this.companyInfo == null) {
            return null;
        }
        String num = null;
        if (this.autoNumber) {
            try {
                ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
                SCMBillBaseInfo objectValue = null;
                String bizOrgUnitID = null;
                if (this.params.getInt("targetBill") == 1) {
                    objectValue = purReq;
                    bizOrgUnitID = this.companyInfo.getId().toString();
                } else {
                    objectValue = new PurOrderInfo();
                    bizOrgUnitID = ((OrgUnitInfo)this.params.getObject("purchaseOrgTo")).getId().toString();
                }
                num = codingRuleManager.getNumber((IObjectValue)objectValue, bizOrgUnitID);
            }
            catch (Exception exp) {
                this.handUIExceptionAndAbort(exp);
            }
        } else if (this.txtNum.getText() == null || this.txtNum.getText().length() == 0) {
            this.txtNum.requestFocus();
            this.handUIExceptionAndAbort((Exception)((Object)new SMReportException(SMReportException.INPUT_BILLNUMBER)));
        } else {
            num = this.txtNum.getText();
        }
        return num;
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void beforePrint() {
        this.logUIOperation("LOG_REPORT6");
    }

    private void logUIOperation(String key) {
        String operName = EASResource.getString((String)"com.kingdee.eas.scm.sm.report.SMReportResource", (String)key);
        IObjectPK pk = LogUtil.beginLog(null, (String)operName, (BOSObjectType)new PurOrderInfo().getBOSType(), null, (String)operName);
        LogUtil.afterLog(null, (IObjectPK)pk);
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
        int rowCount = this.tblMain.getRowCount();
        for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
            this.tblMain.getCell(rowIndex, TrackNumber_F).getStyleAttributes().setLocked(true);
            this.tblMain.getCell(rowIndex, Project_F).getStyleAttributes().setLocked(true);
        }
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        super.actionQuery_actionPerformed(e);
        int rowCount = this.tblMain.getRowCount();
        for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
            this.tblMain.getCell(rowIndex, TrackNumber_F).getStyleAttributes().setLocked(true);
            this.tblMain.getCell(rowIndex, Project_F).getStyleAttributes().setLocked(true);
        }
        this.setSupplierF7(null);
    }

    @Override
    public void actionGenRequestBill_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        if (this.rowSet == null || this.rowSet.getRowCount() <= 0) {
            return;
        }
        super.actionGenRequestBill_actionPerformed(e);
        if (this.params.getInt("targetBill") == 1) {
            this.genRequestBill();
        } else {
            this.genOrderBill();
        }
        this.actionRefresh_actionPerformed(e);
    }

    @Override
    public void actionGetAvailableSupplier_actionPerformed(ActionEvent e) throws Exception {
        this.getOnlyAvailableSupplier();
    }

    @Override
    public void actionSelectSupplierF7_actionPerformed(ActionEvent e) throws Exception {
        this.isOnlyAvailableSupplier = this.menuAvailableSupplierF7.isSelected();
        this.setSupplierF7(null);
    }

    private void genRequestBill() {
        BOSUuid id = BOSUuid.create((String)"25428F2E");
        PurRequestInfo requestInfo = new PurRequestInfo();
        requestInfo.setId(id);
        UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
        requestInfo.setCompanyOrgUnit(this.companyInfo);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("CU.id"));
        sic.add(new SelectorItemInfo("CU.name"));
        sic.add(new SelectorItemInfo("CU.number"));
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)this.companyInfo.getId().toString()));
        view.setFilter(filter);
        view.setSelector(sic);
        try {
            CompanyOrgUnitCollection compCol = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitCollection(view);
            if (null != compCol && compCol.size() > 0) {
                requestInfo.setCU(compCol.get(0).getCU());
            }
        }
        catch (Exception e2) {
            this.handUIException(e2);
        }
        requestInfo.setCreator(userInfo);
        Timestamp theTime = null;
        try {
            theTime = SCMClientUtils.getServerDate();
        }
        catch (Exception e1) {
            this.handUIException(e1);
        }
        requestInfo.setCreateTime(theTime);
        requestInfo.setBizDate(theTime);
        requestInfo.setPerson(userInfo.getPerson());
        DemandTypeInfo demand = (DemandTypeInfo)this.params.getObject("demandType");
        requestInfo.setDemandType(demand);
        BizTypeInfo bizTypeInfo = new BizTypeInfo();
        bizTypeInfo.setId(BOSUuid.read((String)"d8e80652-0106-1000-e000-04c5c0a812202407435C"));
        requestInfo.setBizType(bizTypeInfo);
        requestInfo.setBaseStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
        HashSet billIdSet = new HashSet();
        ArrayList entryIdList = new ArrayList();
        if (this.isAllRow()) {
            this.getEntrys(0, this.rowSet.getRowCount(), requestInfo, billIdSet, entryIdList);
        } else {
            int firstRow = -1;
            int lastRow = -1;
            ArrayList blocks = this.tblMain.getSelectManager().getBlocks();
            for (int blockIndex = 0; blockIndex < blocks.size(); ++blockIndex) {
                int i;
                KDTSelectBlock block = (KDTSelectBlock)blocks.get(blockIndex);
                int rowIndex = block.getTop();
                if (rowIndex >= firstRow && rowIndex <= lastRow) continue;
                AssistantInfo assitInfo = (AssistantInfo)this.assistantList.get(rowIndex);
                if (!assitInfo.isAvailable) continue;
                firstRow = block.getTop();
                for (i = block.getTop(); i >= 0; --i) {
                    assitInfo = (AssistantInfo)this.assistantList.get(i);
                    if (!assitInfo.isGroupFirstLine) continue;
                    firstRow = i;
                    break;
                }
                lastRow = block.getBottom();
                for (i = block.getBottom(); i < this.tblMain.getRowCount(); ++i) {
                    assitInfo = (AssistantInfo)this.assistantList.get(i);
                    if (!assitInfo.isTotalLine) continue;
                    lastRow = i + 1;
                    break;
                }
                this.getEntrys(firstRow, lastRow, requestInfo, billIdSet, entryIdList);
            }
        }
        String num = this.getBillNumber(requestInfo);
        requestInfo.setNumber(num);
        BigDecimal localTotalAmount = SysConstant.BIGZERO;
        for (int rowInx = 0; rowInx < requestInfo.getEntries().size(); ++rowInx) {
            PurRequestEntryInfo entry = requestInfo.getEntries().get(rowInx);
            entry.setSeq(rowInx);
            localTotalAmount = localTotalAmount.add(entry.getLocalAmount());
        }
        requestInfo.setLocalTotalAmount(localTotalAmount);
        requestInfo.setTotalAmount(localTotalAmount);
        String[] billIdArray = billIdSet.toArray(new String[billIdSet.size()]);
        String[] entryIdArray = entryIdList.toArray(new String[entryIdList.size()]);
        if (requestInfo.getEntries().size() > 0 && entryIdArray.length > 0) {
            try {
                IPurRequestTotalFacade purRequestCtrl = (IPurRequestTotalFacade)this.getRemoteInstance();
                purRequestCtrl.genRequestBill(requestInfo, billIdArray, entryIdArray);
                String infoMsg = ResourceUtils.getMessage((String)"com.kingdee.eas.scm.sm.report.PurRequestTotalResource", (String)"GEN_PURREQBILL_01", (String[])new String[]{requestInfo.getNumber()});
                MsgBox.showInfo((Component)((Object)this), (String)infoMsg);
            }
            catch (Exception e) {
                this.handUIExceptionAndAbort(e);
            }
        } else {
            String infoMsg = this.getResource("NO_Avaialable_Material");
            MsgBox.showInfo((Component)((Object)this), (String)infoMsg);
        }
    }

    private void getEntrys(int fromRow, int toRow, PurRequestInfo requestInfo, HashSet billIdSet, ArrayList entryIdList) {
        for (int rowIndex = fromRow; rowIndex < toRow; ++rowIndex) {
            this.rowSet.moveTo(rowIndex);
            AssistantInfo assitInfo = (AssistantInfo)this.assistantList.get(rowIndex);
            if (!assitInfo.isAvailable) continue;
            if (this.rowSet.getObject("entrystate") != null && 4 != this.rowSet.getInt("entrystate")) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.scm.sm.pur.PurUIResource", (String)"PurRequestAuditForGather"));
                SysUtil.abort();
            }
            if (assitInfo.isTotalLine) {
                PurRequestEntryInfo entry = this.getEntry(requestInfo);
                requestInfo.getEntries().add(entry);
                continue;
            }
            if (!billIdSet.contains(this.rowSet.getString("reqfid"))) {
                billIdSet.add(this.rowSet.getString("reqfid"));
            }
            entryIdList.add(this.rowSet.getString("entryfid"));
        }
    }

    private PurRequestEntryInfo getEntry(PurRequestInfo requestInfo) {
        PurRequestEntryInfo entry = new PurRequestEntryInfo();
        if (null != this.rowSet.getBigDecimal("isInTax") && this.rowSet.getBigDecimal("isInTax").compareTo(BigDecimal.ONE) == 0) {
            requestInfo.setIsInTax(true);
        } else {
            requestInfo.setIsInTax(false);
        }
        if (null != this.rowSet.getBigDecimal("isPriceInTax") && this.rowSet.getBigDecimal("isPriceInTax").compareTo(BigDecimal.ONE) == 0) {
            requestInfo.setIsPriceInTax(true);
        } else {
            requestInfo.setIsPriceInTax(false);
        }
        entry.setParent(requestInfo);
        if (this.rowSet.getString(MaterialId_F) != null) {
            MaterialInfo material = new MaterialInfo();
            material.setId(BOSUuid.read((String)this.rowSet.getString(MaterialId_F)));
            entry.setMaterial(material);
            entry.setMaterialName(this.rowSet.getString("materialName"));
            entry.setNoNumMaterialModel(this.rowSet.getString("fmodel"));
        } else {
            entry.setMaterialName(this.rowSet.getString("materialName"));
            entry.setNoNumMaterialModel(this.rowSet.getString("fmodel"));
        }
        if (this.rowSet.getString(CurrencyId_F) != null) {
            CurrencyInfo currency = new CurrencyInfo();
            currency.setId(BOSUuid.read((String)this.rowSet.getString(CurrencyId_F)));
            entry.setCurrency(currency);
        } else {
            entry.setCurrency(this.baseCurrencyInfo);
        }
        if (this.rowSet.getBigDecimal("fexchangerate") == null) {
            entry.setExchangeRate(new BigDecimal("1.0"));
        } else {
            entry.setExchangeRate(this.rowSet.getBigDecimal("fexchangerate"));
        }
        entry.setPurchaseOrgUnit(this.getPurchaseOrgFromParam());
        Date reqDate = (Date)this.rowSet.getObject(DemandDate_F);
        Date deliveryDate = (Date)this.rowSet.getObject(DeliveryDate_F);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(deliveryDate);
        calendar.add(5, -1);
        Date purchaseDate = calendar.getTime();
        entry.setRequirementDate(reqDate);
        entry.setProposeDeliveryDate(deliveryDate);
        entry.setProposePurchaseDate(purchaseDate);
        MeasureUnitInfo baseUnit = new MeasureUnitInfo();
        baseUnit.setId(BOSUuid.read((String)this.rowSet.getString("fbaseunitid")));
        entry.setBaseUnit(baseUnit);
        MeasureUnitInfo purUnit = new MeasureUnitInfo();
        purUnit.setId(BOSUuid.read((String)this.rowSet.getString("fpurUnitid")));
        entry.setUnit(purUnit);
        if (this.rowSet.getString("fassistunitid") == null) {
            entry.setAssistUnit(null);
        } else {
            MeasureUnitInfo assistUnit = new MeasureUnitInfo();
            assistUnit.setId(BOSUuid.read((String)this.rowSet.getString("fassistunitid")));
            entry.setAssistUnit(assistUnit);
        }
        entry.setBaseQty(this.rowSet.getBigDecimal(ConfirmQty_F));
        BigDecimal qty = this.rowSet.getBigDecimal(ConfirmQty_F);
        BigDecimal reqQty = this.rowSet.getBigDecimal(ConfirmQty_F);
        reqQty = reqQty.divide(this.rowSet.getBigDecimal("FpurConvsRate"), this.rowSet.getInt("fpurQtyPrecision"), 4);
        qty = qty.divide(this.rowSet.getBigDecimal("FpurConvsRate"), this.rowSet.getInt("fpurQtyPrecision"), 4);
        entry.setQty(qty);
        entry.setRequestQty(reqQty);
        entry.setAssistQty(SysConstant.BIGZERO);
        if (this.rowSet.getString(SupplierId_F) == null) {
            entry.setSupplier(null);
        } else {
            SupplierInfo supplier = new SupplierInfo();
            supplier.setId(BOSUuid.read((String)this.rowSet.getString(SupplierId_F)));
            entry.setSupplier(supplier);
        }
        if (this.rowSet.getBigDecimal(PurchasePrice_F) == null) {
            entry.setPrice(SysConstant.BIGZERO);
        } else {
            entry.setPrice(this.rowSet.getBigDecimal("FPrice").multiply(this.rowSet.getBigDecimal("FpurConvsRate")).setScale(this.rowSet.getInt("PRICEPREC"), 4));
        }
        BigDecimal amount = entry.getBaseQty().multiply(entry.getPrice());
        BigDecimal localAmount = amount.multiply(entry.getExchangeRate());
        localAmount = localAmount.setScale(this.baseCurrencyInfo.getPrecision(), 4);
        entry.setAmount(amount);
        entry.setLocalAmount(localAmount);
        entry.setBaseStatus(EntryBaseStatusEnum.SUBMITED);
        entry.setOrderedBaseQty(SysConstant.BIGZERO);
        entry.setOrderedQty(SysConstant.BIGZERO);
        entry.setUnOrderedQty(this.rowSet.getBigDecimal(ConfirmQty_F));
        entry.setUnOrderedBaseQty(this.rowSet.getBigDecimal(ConfirmQty_F));
        if (this.rowSet.getString("fassistPropertyid") == null) {
            entry.setAssistProperty(null);
        } else {
            AsstAttrValueInfo assAttr = new AsstAttrValueInfo();
            assAttr.setId(BOSUuid.read((String)this.rowSet.getString("fassistPropertyid")));
            entry.setAssistProperty(assAttr);
        }
        entry.setTrackNumber(this.rowSet.getString(TraceNum_F));
        if (this.rowSet.getString(TrackNumber_F) != null) {
            TrackNumberInfo trackNo = new TrackNumberInfo();
            trackNo.setId(BOSUuid.read((String)this.rowSet.getString(TrackNumber_F)));
            entry.setTrackNo(trackNo);
        }
        if (this.rowSet.getString(Project_F) != null) {
            ProjectInfo projectInfo = new ProjectInfo();
            projectInfo.setId(BOSUuid.read((String)this.rowSet.getString(Project_F)));
            entry.setProject(projectInfo);
        }
        RowTypeInfo rowtype = new RowTypeInfo();
        rowtype.setId(BOSUuid.read((String)this.rowSet.getString("rowTypeId")));
        entry.setRowType(rowtype);
        if (this.rowSet.getString("receivingOrgId") != null) {
            StorageOrgUnitInfo recOrg = new StorageOrgUnitInfo();
            recOrg.setId(BOSUuid.read((String)this.rowSet.getString("receivingOrgId")));
            entry.setReceivedOrgUnit(recOrg);
        }
        if (this.reqStorageOrg != null) {
            entry.setStorageOrgUnit(this.reqStorageOrg);
        }
        if (this.adminOrg != null) {
            entry.setAdminOrgUnit(this.adminOrg);
        }
        if (entry.getQty().compareTo(SysConstant.BIGZERO) <= 0) {
            MsgBox.showInfo((Component)((Object)this), (String)this.getPurResource("QTY_MUST_LARGER_ZERO"));
            SysUtil.abort();
        }
        if (entry.getQty() != null && entry.getQty().compareTo(MAXVAL) > 0) {
            MsgBox.showInfo((Component)((Object)this), (String)this.getPurResource("QTY_LARGER_MAX"));
            SysUtil.abort();
        }
        entry.setTaxRate(this.rowSet.getBigDecimal("taxRate"));
        entry.setDiscountRate(this.rowSet.getBigDecimal("discountRate"));
        if (null != entry.getPrice() && entry.getPrice().compareTo(SysConstant.BIGZERO) > 0) {
            BigDecimal taxRate = BigDecimal.ZERO;
            if (null != entry.getTaxRate() && entry.getTaxRate().compareTo(SysConstant.BIGZERO) > 0) {
                taxRate = entry.getTaxRate();
            }
            BigDecimal taxPrice = entry.getPrice().multiply(BigDecimal.ONE.add(taxRate.divide(new BigDecimal(100))));
            entry.setTaxPrice(taxPrice.setScale(this.rowSet.getInt("PRICEPREC"), 4));
        }
        this.calDiscountAmountByTaxPrice(this.rowSet, entry);
        this.calTaxAmountByTaxPrice(this.rowSet, entry);
        this.calTax(this.rowSet, entry);
        try {
            ExchangeRateInfo exchangeRateinfo = this.getExchangeRateInfo(entry);
            this.calLocalTaxAmount(entry, exchangeRateinfo);
            this.calAmount(entry);
            this.calLocalTax(entry, exchangeRateinfo);
            this.calActualTaxPrice(entry);
            this.calActualPrice(entry);
            this.calLocalAmount(entry, exchangeRateinfo);
        }
        catch (Exception e) {
            this.handUIExceptionAndAbort(e);
        }
        entry.setSourceBillId(null);
        entry.setSourceBillNumber(null);
        entry.setSourceBillEntryId(null);
        entry.setSourceBillEntrySeq(0);
        entry.setAssCoefficient(SysConstant.BIGZERO);
        entry.setAssociateQty(SysConstant.BIGZERO);
        entry.setSourceBillType(null);
        entry.setMaterialBaseClass(null);
        entry.setPurpose(null);
        entry.setRemark(null);
        entry.setReason(null);
        entry.setReasonCode(null);
        return entry;
    }

    private ExchangeRateInfo getExchangeRateInfo(PurRequestEntryInfo entry) throws EASBizException, BOSException {
        if (this.companyInfo != null && entry.getCurrency() != null && this.baseCurrencyInfo != null && !entry.getCurrency().equals((Object)this.baseCurrencyInfo)) {
            String key = this.companyInfo.getId().toString() + entry.getCurrency().getId().toString() + this.baseCurrencyInfo.getId().toString();
            if (this.ExchangeRateMap.containsKey(key)) {
                return this.ExchangeRateMap.get(key);
            }
            ObjectUuidPK excTablepk = null;
            ObjectUuidPK sourceCurrPK = null;
            ObjectUuidPK destCurrPK = null;
            ExchangeTableInfo baseExchangeTableInfo = this.companyInfo.getBaseExchangeTable();
            if (baseExchangeTableInfo == null) {
                CompanyOrgUnitInfo icomUnit = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(this.companyInfo.getId()));
                baseExchangeTableInfo = icomUnit.getBaseExchangeTable();
            }
            if (baseExchangeTableInfo == null) {
                throw new PurOrderException(PurOrderException.EXCHANGETABLENULL);
            }
            excTablepk = new ObjectUuidPK(baseExchangeTableInfo.getId());
            sourceCurrPK = new ObjectUuidPK(entry.getCurrency().getId());
            destCurrPK = new ObjectUuidPK(this.baseCurrencyInfo.getId());
            IExchangeRate iexchangRate = ExchangeRateFactory.getRemoteInstance();
            ExchangeRateInfo tempexrateinfo = iexchangRate.getExchangeRate((IObjectPK)excTablepk, (IObjectPK)sourceCurrPK, (IObjectPK)destCurrPK, Calendar.getInstance().getTime());
            this.ExchangeRateMap.put(key, tempexrateinfo);
            return tempexrateinfo;
        }
        return null;
    }

    public void calDiscountAmountByTaxPrice(RptRowSet rowSet, PurRequestEntryInfo entry) {
        int scale = 8;
        BigDecimal taxPrice = entry.getTaxPrice();
        BigDecimal qty = entry.getQty();
        BigDecimal discountRate = entry.getDiscountRate();
        BigDecimal oneHundred = new BigDecimal("100.0");
        taxPrice = this.validateNullValue(taxPrice);
        qty = this.validateNullValue(qty);
        discountRate = this.validateNullValue(discountRate);
        BigDecimal discountAmount = taxPrice.multiply(qty).multiply(discountRate.divide(oneHundred, 10, 4)).setScale(scale, 4);
        entry.setDiscountAmount(discountAmount);
    }

    public void calTaxAmountByTaxPrice(RptRowSet rowSet, PurRequestEntryInfo entry) {
        int scale = 8;
        if (null != rowSet.getBigDecimal("isInTax") && rowSet.getBigDecimal("isInTax").compareTo(BigDecimal.ONE) == 0) {
            BigDecimal taxPrice = entry.getTaxPrice();
            BigDecimal qty = entry.getQty();
            BigDecimal discountAmount = entry.getDiscountAmount();
            taxPrice = this.validateNullValue(taxPrice);
            qty = this.validateNullValue(qty);
            discountAmount = this.validateNullValue(discountAmount);
            BigDecimal taxAmount = taxPrice.multiply(qty).subtract(discountAmount);
            taxAmount = taxAmount.setScale(scale, 4);
            entry.setTaxAmount(taxAmount);
        } else {
            BigDecimal amount = entry.getAmount();
            BigDecimal tax = entry.getTax();
            amount = this.validateNullValue(amount);
            tax = this.validateNullValue(tax);
            BigDecimal taxAmount = amount.add(tax);
            taxAmount = taxAmount.setScale(scale, 4);
            entry.setTaxAmount(taxAmount);
        }
    }

    public void calTax(RptRowSet rowSet, PurRequestEntryInfo entry) {
        int scale = 8;
        if (null != rowSet.getBigDecimal("isInTax") && rowSet.getBigDecimal("isInTax").compareTo(BigDecimal.ONE) == 0) {
            BigDecimal one = new BigDecimal("1.0");
            BigDecimal taxAmount = entry.getTaxAmount();
            BigDecimal taxRate = entry.getTaxRate();
            taxAmount = this.validateNullValue(taxAmount);
            taxRate = this.validateNullValue(taxRate);
            BigDecimal tax = SysConstant.BIGZERO;
            BigDecimal oneHundred = new BigDecimal("100.0");
            if (taxAmount != null && taxRate != null) {
                taxRate = taxRate.divide(oneHundred, 10, 4);
                tax = taxAmount.divide(taxRate.add(one), 10, 4).multiply(taxRate);
                if (rowSet.getBigDecimal("isPriceInTax") != null && rowSet.getBigDecimal("isPriceInTax").compareTo(BigDecimal.ONE) != 0) {
                    tax = taxAmount.multiply(taxRate);
                }
                tax = tax.setScale(scale, 4);
            }
            entry.setTax(tax);
        } else {
            BigDecimal amount = entry.getAmount();
            amount = this.validateNullValue(amount);
            BigDecimal taxRate = entry.getTaxRate();
            BigDecimal tax = CalculateUtils.calTax((BigDecimal)amount, (BigDecimal)(taxRate = this.validateNullValue(taxRate)), (int)scale);
            if (tax != null) {
                entry.setTax(tax);
            } else {
                entry.setTax(SysConstant.BIGZERO);
            }
        }
    }

    public void calLocalTaxAmount(PurRequestEntryInfo entry, ExchangeRateInfo exchangeRateinfo) {
        int scale = 8;
        BigDecimal taxAmount = entry.getTaxAmount();
        BigDecimal exchangerate = entry.getExchangeRate();
        taxAmount = this.validateNullValue(taxAmount);
        exchangerate = this.validateNullValue(exchangerate);
        if (exchangeRateinfo != null && exchangerate.compareTo(new BigDecimal("0.00")) != 0) {
            if (exchangeRateinfo.getExchangeAux().getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE) {
                entry.setLocalTaxAmount(taxAmount.multiply(exchangerate).setScale(scale, 4));
            } else {
                entry.setLocalTaxAmount(taxAmount.divide(exchangerate, scale, 4));
            }
        } else if (exchangeRateinfo == null && exchangerate.compareTo(new BigDecimal("0.00")) != 0) {
            entry.setLocalTaxAmount(taxAmount.multiply(exchangerate).setScale(scale, 4));
        } else {
            entry.setLocalTaxAmount(taxAmount);
        }
    }

    public void calAmount(PurRequestEntryInfo entry) {
        int scale = 8;
        if (null != this.rowSet.getBigDecimal("isInTax") && this.rowSet.getBigDecimal("isInTax").compareTo(BigDecimal.ONE) == 0) {
            BigDecimal taxAmount = entry.getTaxAmount();
            BigDecimal tax = entry.getTax();
            taxAmount = this.validateNullValue(taxAmount);
            tax = this.validateNullValue(tax);
            entry.setAmount(SysConstant.BIGZERO);
            if (taxAmount != null && tax != null) {
                BigDecimal actualTaxPrice = taxAmount.subtract(tax);
                actualTaxPrice = actualTaxPrice.setScale(scale, 4);
                entry.setAmount(actualTaxPrice);
            }
        } else {
            BigDecimal price = entry.getPrice();
            BigDecimal discountRate = entry.getDiscountRate();
            BigDecimal qty = entry.getQty();
            BigDecimal one = new BigDecimal("1.0");
            BigDecimal oneHundred = new BigDecimal("100.0");
            price = this.validateNullValue(price);
            discountRate = this.validateNullValue(discountRate);
            qty = this.validateNullValue(qty);
            BigDecimal amount = qty.multiply(price).multiply(one.subtract(discountRate.divide(oneHundred, 10, 4)));
            amount = amount.setScale(scale, 4);
            entry.setAmount(amount);
        }
    }

    public void calLocalTax(PurRequestEntryInfo entry, ExchangeRateInfo exchangeRateinfo) {
        int scale = 8;
        BigDecimal tax = entry.getTax();
        BigDecimal exchangerate = entry.getExchangeRate();
        tax = this.validateNullValue(tax);
        exchangerate = this.validateNullValue(exchangerate);
        if (exchangeRateinfo != null && exchangerate.compareTo(new BigDecimal("0.00")) != 0) {
            if (exchangeRateinfo.getExchangeAux().getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE) {
                entry.setLocalTax(tax.multiply(exchangerate).setScale(scale, 4));
            } else {
                entry.setLocalTax(tax.divide(exchangerate, scale, 4));
            }
        } else if (exchangeRateinfo == null && exchangerate.compareTo(new BigDecimal("0.00")) != 0) {
            entry.setLocalTax(tax.multiply(exchangerate).setScale(scale, 4));
        } else {
            entry.setLocalTax(tax);
        }
    }

    public void calActualTaxPrice(PurRequestEntryInfo entry) {
        BigDecimal discountRate = entry.getDiscountRate();
        BigDecimal zero = new BigDecimal("0.0");
        int scale = 8;
        if ((discountRate == null || discountRate.compareTo(zero) == 0) && entry.getTaxPrice() != null) {
            BigDecimal taxPrice = entry.getTaxPrice().abs();
            entry.setActualTaxPrice(taxPrice);
        } else {
            BigDecimal taxAmount = entry.getTaxAmount();
            BigDecimal qty = entry.getQty();
            taxAmount = this.validateNullValue(taxAmount);
            qty = this.validateNullValue(qty);
            BigDecimal actualTaxPrice = SysConstant.BIGZERO;
            if (taxAmount != null && qty != null && qty.compareTo(zero) != 0) {
                actualTaxPrice = taxAmount.divide(qty, scale, 4);
                entry.setActualTaxPrice(actualTaxPrice);
            }
        }
    }

    public void calActualPrice(PurRequestEntryInfo entry) {
        BigDecimal zero = new BigDecimal("0.0");
        int scale = 8;
        BigDecimal amount = entry.getAmount();
        BigDecimal qty = entry.getQty();
        amount = this.validateNullValue(amount);
        qty = this.validateNullValue(qty);
        BigDecimal discountRate = entry.getDiscountRate();
        if (discountRate == null || discountRate.compareTo(zero) == 0) {
            BigDecimal price = entry.getPrice();
            entry.setActualPrice(price);
        } else if (amount != null && qty != null && qty.compareTo(zero) != 0) {
            BigDecimal actualPrice = amount.divide(qty, scale, 4);
            entry.setActualPrice(actualPrice);
        }
    }

    public void calLocalAmount(PurRequestEntryInfo entry, ExchangeRateInfo exchangeRateinfo) {
        int scale = 8;
        BigDecimal zero = new BigDecimal("0.0");
        BigDecimal amount = entry.getAmount();
        BigDecimal exchangerate = entry.getExchangeRate();
        amount = this.validateNullValue(amount);
        exchangerate = this.validateNullValue(exchangerate);
        if (exchangeRateinfo != null && exchangerate.compareTo(zero) != 0) {
            if (exchangeRateinfo.getExchangeAux().getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE) {
                entry.setLocalTaxAmount(amount.multiply(exchangerate).setScale(scale, 4));
            } else {
                entry.setLocalTaxAmount(amount.divide(exchangerate, scale, 4));
            }
        } else if (exchangeRateinfo == null && exchangerate.compareTo(zero) != 0) {
            entry.setLocalTaxAmount(amount.multiply(exchangerate).setScale(scale, 4));
        } else {
            entry.setLocalTaxAmount(amount);
        }
    }

    private BigDecimal validateNullValue(BigDecimal value) {
        if (value == null) {
            return new BigDecimal("0.00");
        }
        return value;
    }

    private String getPurResource(String str) {
        return EASResource.getString((String)"com.kingdee.eas.scm.sm.pur.PurUIResource", (String)str);
    }

    private String getResource(String key) {
        return EASResource.getString((String)"com.kingdee.eas.scm.sm.report.PurRequestTotalResource", (String)key);
    }

    private boolean isAllRow() {
        KDTSelectBlock firstBlock;
        ArrayList blocks = this.tblMain.getSelectManager().getBlocks();
        if (blocks == null || blocks.size() == 0) {
            return true;
        }
        return blocks.size() == 1 && (firstBlock = (KDTSelectBlock)blocks.get(0)).getTop() == firstBlock.getBottom() && firstBlock.getLeft() == firstBlock.getRight();
    }

    private void genOrderBill() {
    }

    @Override
    public void actionGetOrderBill_actionPerformed(ActionEvent e) throws Exception {
        super.actionGetOrderBill_actionPerformed(e);
    }

    protected ICommRptBase getRemoteInstance() throws BOSException {
        return PurRequestTotalFacadeFactory.getRemoteInstance();
    }

    protected KDTable getTableForPrintSetting() {
        return this.tblMain;
    }

    protected RptParams getParamsForInit() {
        return null;
    }

    protected CommRptBaseConditionUI getQueryDialogUserPanel() throws Exception {
        return null;
    }

    protected CustomerQueryPanel getCustomerQueryPanel() throws Exception {
        return new PurRequestTotalConditionUI();
    }

    protected boolean showQueryDialog(boolean useDefaultSolution) {
        CustomerParams cp = null;
        try {
            SCMBillFilterUI rbqp;
            this.initQueryDialog();
            this.userPanel.getUIContext().clear();
            this.userPanel.getUIContext().putAll(this.getUIContext());
            if (useDefaultSolution) {
                QuerySolutionInfo solution;
                QueryPanelInfo qpi;
                IQuerySolutionFacade iQuery = QuerySolutionFacadeFactory.getRemoteInstance();
                String queryName = MetaDataLoaderFactory.getRemoteMetaDataLoader().getQuery(this.getQueryMetaDataPK()).getFullName();
                if (iQuery.hasDefaultSolution(this.getMetaDataPK().getFullName(), queryName) && (qpi = (solution = iQuery.getDefaultSolution(this.getMetaDataPK().getFullName(), queryName)).getQueryPanelInfo().get(0)) != null) {
                    try {
                        cp = CustomerParams.getCustomerParams2((String)qpi.getCustomerParams());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            boolean ok = false;
            if ((cp == null || !useDefaultSolution) && this.queryDialog.show()) {
                rbqp = (SCMBillFilterUI)this.queryDialog.getUserPanel(0);
                this.params = rbqp.getCustomCondition();
                ok = true;
            }
            if (cp != null) {
                rbqp = (SCMBillFilterUI)this.getCustomerQueryPanel();
                rbqp.setCustomerParams(cp);
                rbqp.loadData(null);
                this.params = rbqp.getCustomCondition();
            }
            if (this.params != null && (ok || useDefaultSolution)) {
                this.queryWithWrap();
                return true;
            }
        }
        catch (Exception e) {
            logger.error((Object)"@showQueryDialog", (Throwable)e);
            this.handleException(e);
        }
        return false;
    }

    private void initQueryDialog() throws Exception {
        if (this.userPanel == null) {
            this.userPanel = this.getCustomerQueryPanel();
            this.userPanel.loadFields();
            this.queryDialog.setMaxReturnCountVisible(false);
            this.queryDialog.setWidth(582);
            this.queryDialog.setHeight(325);
            this.queryDialog.addUserPanel((KDPanel)this.userPanel);
            this.queryDialog.setOwner((Component)this.getUIContext().get("Owner"));
            this.queryDialog.setTitle(this.userPanel.getUITitle());
            this.queryDialog.setQueryObjectPK(this.getQueryMetaDataPK());
            this.queryDialog.setShowFilter(false);
            this.queryDialog.setShowSorter(false);
            this.queryDialog.setParentUIClassName(this.getMetaDataPK().getFullName());
            Method m = this.userPanel.getClass().getMethod("onInit", RptParams.class);
            m.invoke((Object)this.userPanel, this.getUIContextInitParams());
            this.userPanel.initLayout();
            if (this.params != null) {
                this.userPanel.setCustomerParams(RptParamsUtil.setToCustomerParams((CustomerParams)new CustomerParams(), (Object)this.params));
            }
        }
    }

    protected void query() {
        this.processParams();
        this.isAutoNumber();
        if (this.editAdapter != null) {
            this.tblMain.removeKDTEditListener((KDTEditListener)this.editAdapter);
        }
        if (this.activeCellListener != null) {
            this.tblMain.removeKDTActiveCellListener(this.activeCellListener);
        }
        this.tblMain.removeRows();
    }

    private void processParams() {
        if (this.params.getObject("requestOrgTo") instanceof StorageOrgUnitInfo || this.params.getObject("adminOrgTo") instanceof AdminOrgUnitInfo || this.params.getObject("demandType") instanceof DemandTypeInfo) {
            return;
        }
        this.params.setInt("targetBill", 1);
        try {
            DemandTypeInfo demandInfo;
            String adminOrgToNum = this.params.getString("adminOrg");
            String requestOrgToNum = this.params.getString("requestOrgTo");
            String purchaseOrgFromNum = this.params.getString("purchaseOrgFrom");
            String demandTypeNum = this.params.getString("demandType");
            this.adminOrg = null;
            if (adminOrgToNum != null && adminOrgToNum.trim().length() > 0) {
                OrgUnitInfo orgAdmin = OrgUnitUtils.getOrgUnitInfoByNum(null, (String)adminOrgToNum);
                this.adminOrg = new AdminOrgUnitInfo();
                this.adminOrg.setId(orgAdmin.getId());
                this.adminOrg.setName(orgAdmin.getName());
                this.adminOrg.setNumber(orgAdmin.getNumber());
            }
            this.params.setObject("adminOrgTo", (Object)this.adminOrg);
            this.reqStorageOrg = null;
            if (requestOrgToNum != null && requestOrgToNum.trim().length() > 0) {
                OrgUnitInfo orgReq = OrgUnitUtils.getOrgUnitInfoByNum(null, (String)requestOrgToNum);
                StorageOrgUnitInfo storageOrg = new StorageOrgUnitInfo();
                storageOrg.setId(orgReq.getId());
                storageOrg.setName(orgReq.getName());
                storageOrg.setNumber(orgReq.getNumber());
                this.reqStorageOrg = storageOrg;
            }
            this.params.setObject("requestOrgTo", (Object)this.reqStorageOrg);
            OrgUnitInfo orgPur = OrgUnitUtils.getOrgUnitInfoByNum(null, (String)purchaseOrgFromNum);
            PurchaseOrgUnitInfo purchaseOrg = new PurchaseOrgUnitInfo();
            purchaseOrg.setId(orgPur.getId());
            purchaseOrg.setName(orgPur.getName());
            purchaseOrg.setNumber(orgPur.getNumber());
            this.params.setObject("purchaseOrgFrom", (Object)purchaseOrg);
            if (this.adminOrg == null && this.reqStorageOrg == null) {
                String errMsg = this.getResource("SELECT_ORG");
                MsgBox.showInfo((Component)((Object)this), (String)errMsg);
                SysUtil.abort();
            }
            if (this.adminOrg != null) {
                this.companyInfo = OrgUnitUtils.readCompanyOrgUnitInfo(null, (OrgUnitInfo)this.adminOrg, (boolean)true);
                if (this.companyInfo == null) {
                    MsgBox.showInfo((Component)((Object)this), (String)("[" + this.adminOrg.getName() + "]" + this.getResource("ADMINORG_CANNT_MAINTAIN_COMPANYORG")));
                    SysUtil.abort();
                }
            } else {
                this.companyInfo = OrgUnitUtils.readCompanyOrgUnitInfo(null, (OrgUnitInfo)this.reqStorageOrg, (boolean)true);
            }
            this.demandType = null;
            if (demandTypeNum != null && demandTypeNum.trim().length() > 0 && (demandInfo = this.getDemandTypeInfoByNum(demandTypeNum)) != null && demandInfo.getId() != null) {
                this.demandType = new DemandTypeInfo();
                this.demandType.setId(demandInfo.getId());
                this.demandType.setName(demandInfo.getName());
                this.demandType.setNumber(demandInfo.getNumber());
            }
            this.params.setObject("demandType", (Object)this.demandType);
        }
        catch (Exception e) {
            this.handUIExceptionAndAbort(e);
        }
        this.baseCurrencyInfo = this.getBaseCurrency();
    }

    public DemandTypeInfo getDemandTypeInfoByNum(String demandTypeNum) throws Exception {
        IDemandType demandTypeCtrl = DemandTypeFactory.getRemoteInstance();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)demandTypeNum));
        view.setFilter(filter);
        view.getSelector().add(new SelectorItemInfo("id"));
        view.getSelector().add(new SelectorItemInfo("number"));
        view.getSelector().add(new SelectorItemInfo("longNumber"));
        view.getSelector().add(new SelectorItemInfo("name"));
        CoreBaseCollection col = demandTypeCtrl.getCollection(view);
        if (col != null && col.size() > 0) {
            return (DemandTypeInfo)col.get(0);
        }
        return null;
    }

    public void tableDataRequest(KDTDataRequestEvent e) {
        if (e.getLastCol() == -1) {
            return;
        }
        this.tblMain.getDataRequestManager().removeDataRequestListener((KDTDataRequestListener)this);
        if (this.params.getInt("targetBill") == 1) {
            this.btnGenRequestBill.setEnabled(true);
            this.btnGenOrderBill.setEnabled(false);
        } else {
            this.btnGenRequestBill.setEnabled(true);
            this.btnGenOrderBill.setEnabled(false);
        }
        try {
            ICommRptBase reportFacade = this.getRemoteInstance();
            RptParams pp = reportFacade.query(this.params);
            this.rowSet = (RptRowSet)pp.getObject("rowSet");
            this.processSubtotal(this.rowSet);
            this.filldata();
            this.formatTable();
            if (this.editAdapter == null) {
                this.editAdapter = new KDTEditAdapter(){

                    public void editStopped(KDTEditEvent e) {
                        try {
                            PurRequestTotalUI.this.tblMain_ChangedStopped(e);
                        }
                        catch (Exception exc) {
                            PurRequestTotalUI.this.handUIException(exc);
                        }
                    }

                    public void editStarting(KDTEditEvent e) {
                        PurRequestTotalUI.this.tblMain_ChangedStarting(e);
                    }
                };
            }
            this.tblMain.addKDTEditListener((KDTEditListener)this.editAdapter);
            this.tblMain.addKDTActiveCellListener(this.activeCellListener);
        }
        catch (Exception exp) {
            this.handUIException(exp);
        }
        this.tblMain.getDataRequestManager().addDataRequestListener((KDTDataRequestListener)this);
    }

    private void filldata() throws EASBizException, BOSException {
        this.rowSet.reset();
        while (this.rowSet.next()) {
            IRow row = this.tblMain.addRow();
            row.getCell("RequestId").setValue((Object)this.rowSet.getString("reqfid"));
            row.getCell("RequestDate").setValue(this.rowSet.getObject("fbizdate"));
            if (this.rowSet.getBigDecimal("billstate") != null) {
                row.getCell("billstate").setValue((Object)BillBaseStatusEnum.getEnum((int)this.rowSet.getInt("billstate")));
            } else {
                row.getCell("billstate").setValue((Object)this.rowSet.getString("billstate"));
            }
            row.getCell("RequestBillNum").setValue((Object)this.rowSet.getString("reqNumber"));
            row.getCell("FromCompanyId").setValue((Object)this.rowSet.getString("fcompanyorgunitid"));
            row.getCell("FromCompany").setValue((Object)this.rowSet.getString("fromCompanyName"));
            row.getCell("EntryId").setValue((Object)this.rowSet.getString("entryfid"));
            if (this.rowSet.getBigDecimal("entrystate") != null) {
                row.getCell("entrystate").setValue((Object)EntryBaseStatusEnum.getEnum((int)this.rowSet.getInt("entrystate")));
            } else {
                row.getCell("entrystate").setValue((Object)this.rowSet.getString("entrystate"));
            }
            row.getCell("matrerilGroupName").setValue((Object)this.rowSet.getString("matrerilGroupName"));
            row.getCell("MaterialNum").setValue((Object)this.rowSet.getString("materialNumber"));
            row.getCell("MaterialName").setValue((Object)this.rowSet.getString("materialName"));
            row.getCell("Model").setValue((Object)this.rowSet.getString("fmodel"));
            row.getCell("AssistPropertyId").setValue((Object)this.rowSet.getString("fassistPropertyid"));
            row.getCell("AssistProperty").setValue((Object)this.rowSet.getString("assitName"));
            row.getCell("BaseUnitId").setValue((Object)this.rowSet.getString("fbaseunitid"));
            row.getCell("BaseUnit").setValue((Object)this.rowSet.getString("baseUnitName"));
            row.getCell("CurrencyPrecision").setValue((Object)new Integer(this.rowSet.getInt("curPrecision")));
            row.getCell("ExchangeRate").setValue(this.rowSet.getObject("fexchangerate"));
            row.getCell("rowtypeId").setValue(this.rowSet.getObject("rowTypeId"));
            row.getCell("RowType").setValue(this.rowSet.getObject("rowtypeName"));
            row.getCell("IsAvailable").setValue((Object)this.rowSet.getString("FAvailable"));
            row.getCell("QtyPrecision").setValue((Object)new Integer(this.rowSet.getInt("QtyPrec")));
            row.getCell(PricePrc_F).setValue((Object)new Integer(this.rowSet.getInt("PricePrec")));
            row.getCell("AssitUnitId").setValue((Object)this.rowSet.getString("fassistunitid"));
            row.getCell("receivingOrgId").setValue((Object)this.rowSet.getString("receivingOrgId"));
            row.getCell("receivingOrgNum").setValue((Object)this.rowSet.getString("receivingOrgNum"));
            row.getCell("receivingOrgName").setValue((Object)this.rowSet.getString("receivingOrgName"));
            row.getCell("adminOrgId").setValue((Object)this.rowSet.getString("adminOrgId"));
            row.getCell("adminOrgNum").setValue((Object)this.rowSet.getString("adminOrgNum"));
            row.getCell("adminOrgName").setValue((Object)this.rowSet.getString("adminOrgName"));
            row.getCell("PurOrgUnit").setValue((Object)this.getPurchaseOrgFromParam().getName());
            row.getCell("ToCompany").setValue((Object)this.companyInfo.getName());
            row.getCell("taxRate").setValue((Object)this.rowSet.getBigDecimal("taxRate"));
            if (null != this.rowSet.getBigDecimal("isInTax") && this.rowSet.getBigDecimal("isInTax").compareTo(BigDecimal.ONE) == 0) {
                row.getCell("isInTax").setValue((Object)true);
            } else {
                row.getCell("isInTax").setValue((Object)false);
            }
            if (null != this.rowSet.getBigDecimal("isPriceInTax") && this.rowSet.getBigDecimal("isPriceInTax").compareTo(BigDecimal.ONE) == 0) {
                row.getCell("isPriceInTax").setValue((Object)true);
            } else {
                row.getCell("isPriceInTax").setValue((Object)false);
            }
            row.getCell("discountRate").setValue((Object)this.rowSet.getBigDecimal("discountRate"));
            if (this.adminOrg != null) {
                row.getCell("adminOrgToNum").setValue((Object)this.adminOrg.getNumber());
                row.getCell("adminOrgToName").setValue((Object)this.adminOrg.getName());
            }
            row.getCell("trackNo").setValue((Object)this.rowSet.getString("trackNumber"));
            row.getCell("fprojectID").setValue((Object)this.rowSet.getString("projectNumber"));
            row.getCell(MaterialId_F).setValue((Object)this.rowSet.getString(MaterialId_F));
            row.getCell("requestQty").setValue((Object)this.rowSet.getBigDecimal("requestQty"));
            row.getCell("BaseQty").setValue((Object)this.rowSet.getBigDecimal("qty"));
            row.getCell(ConfirmQty_F).setValue((Object)this.rowSet.getBigDecimal("qty"));
            row.getCell(SupplierId_F).setValue((Object)this.rowSet.getString(SupplierId_F));
            row.getCell(SupplierName_F).setValue((Object)this.rowSet.getString(SupplierName_F));
            row.getCell(CurrencyId_F).setValue((Object)this.rowSet.getString(CurrencyId_F));
            row.getCell(CurrencyName_F).setValue((Object)this.rowSet.getString(CurrencyName_F));
            row.getCell(PurchasePrice_F).setValue(this.rowSet.getObject(PurchasePrice_F));
            row.getCell(DemandDate_F).setValue(this.rowSet.getObject(DemandDate_F));
            row.getCell(DeliveryDate_F).setValue(this.rowSet.getObject(DeliveryDate_F));
            row.getCell(TraceNum_F).setValue(this.rowSet.getObject(TraceNum_F));
        }
    }

    private void getOnlyAvailableSupplier() {
        String purOrgId = this.getPurchaseOrgFromParam().getId().toString();
        RptRowSet paramRowSet = new RptRowSet(new String[]{"rowIndex", "purOrgId", "materialId", "demandDate"}, new ArrayList());
        for (int rowIndex = 0; rowIndex < this.tblMain.getRowCount(); ++rowIndex) {
            AssistantInfo assitInfo = (AssistantInfo)this.assistantList.get(rowIndex);
            if (!assitInfo.isAvailable || !assitInfo.isGroupFirstLine || this.tblMain.getCell(rowIndex, MaterialId_F).getValue() == null) continue;
            String materialId = (String)this.tblMain.getCell(rowIndex, MaterialId_F).getValue();
            Object[] data = new Object[4];
            data[0] = new Integer(rowIndex);
            data[1] = purOrgId;
            data[2] = materialId;
            paramRowSet.addRow(data);
        }
        if (paramRowSet.getRowCount() > 0) {
            try {
                IPurRequestTotalFacade purRequestCtrl = (IPurRequestTotalFacade)this.getRemoteInstance();
                RptRowSet retRS = purRequestCtrl.getOnlyAvailableSupplier(paramRowSet);
                while (retRS.next()) {
                    int rowIndex = retRS.getInt("rowIndex");
                    SupplierInfo supplier = (SupplierInfo)retRS.getObject("supplier");
                    this.tblMain.getCell(rowIndex, SupplierName_F).setValue((Object)supplier);
                    int colIndex = this.tblMain.getColumnIndex(SupplierName_F);
                    this.assignedTotal(rowIndex, colIndex, SupplierName_F);
                }
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
    }

    private void setSupplierF7(String materialID) {
        StringBuffer strbuffer = new StringBuffer();
        FilterInfo filterInfo = new FilterInfo();
        EntityViewInfo view = new EntityViewInfo();
        if (!this.isOnlyAvailableSupplier) {
            SupplierPurchaseInfoCollection purChaseInfoCollection = null;
            filterInfo.getFilterItems().add(new FilterItemInfo("purchaseOrgUnit", (Object)this.getPurchaseOrgFromParam().getId().toString(), CompareType.INCLUDE));
            filterInfo.getFilterItems().add(new FilterItemInfo("IsFreezeMakeOrder", (Object)new Integer(0), CompareType.EQUALS));
            view.setFilter(filterInfo);
            try {
                if (this.iSupplierPurchaseInfo == null) {
                    this.iSupplierPurchaseInfo = SupplierPurchaseInfoFactory.getRemoteInstance();
                }
                purChaseInfoCollection = this.iSupplierPurchaseInfo.getSupplierPurchaseInfoCollection(view);
            }
            catch (BOSException e1) {
                this.handleException((Exception)((Object)e1));
            }
            filterInfo.getFilterItems().resetValue();
            filterInfo.getFilterItems().clear();
            if (purChaseInfoCollection != null && !purChaseInfoCollection.isEmpty()) {
                int c = purChaseInfoCollection.size();
                for (int i = 0; i < c; ++i) {
                    if (i > 0) {
                        strbuffer.append(",");
                    }
                    strbuffer.append(purChaseInfoCollection.get(i).getSupplier().getId().toString());
                }
            }
        } else {
            ApprovedSupplierCollection approvedSupplierCollection = null;
            if (materialID != null) {
                filterInfo.getFilterItems().add(new FilterItemInfo("materialItem", (Object)materialID.toString(), CompareType.EQUALS));
            }
            filterInfo.getFilterItems().add(new FilterItemInfo("purchaseOrg", (Object)this.getPurchaseOrgFromParam().getId().toString(), CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("isUseable", (Object)new Integer(1), CompareType.EQUALS));
            view.setFilter(filterInfo);
            try {
                if (this.iApprovedSupplier == null) {
                    this.iApprovedSupplier = ApprovedSupplierFactory.getRemoteInstance();
                }
                approvedSupplierCollection = this.iApprovedSupplier.getApprovedSupplierCollection(view);
            }
            catch (BOSException e1) {
                this.handleException((Exception)((Object)e1));
            }
            filterInfo.getFilterItems().resetValue();
            filterInfo.getFilterItems().clear();
            if (approvedSupplierCollection != null && !approvedSupplierCollection.isEmpty()) {
                int c = approvedSupplierCollection.size();
                for (int i = 0; i < c; ++i) {
                    if (i > 0) {
                        strbuffer.append(",");
                    }
                    strbuffer.append(approvedSupplierCollection.get(i).getSupplier().getId().toString());
                }
            }
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("usedStatus", (Object)String.valueOf(UsedStatusEnum.APPROVED.getValue()), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)strbuffer.toString(), CompareType.INCLUDE));
        view.setFilter(filterInfo);
        ((KDBizPromptBox)this.tblMain.getColumn(SupplierName_F).getEditor().getComponent()).setEntityViewInfo(view);
    }

    private void tblMain_ChangedStarting(KDTEditEvent e) {
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        if (!this.isOnlyAvailableSupplier) {
            return;
        }
        if (rowIndex < 0) {
            return;
        }
        String materialID = (String)this.tblMain.getCell(rowIndex, MaterialId_F).getValue();
        this.setSupplierF7(materialID);
    }

    private void tblMain_ChangedStopped(KDTEditEvent e) {
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        String fieldName = this.tblMain.getColumnKey(colIndex);
        AssistantInfo assitInfo = (AssistantInfo)this.assistantList.get(rowIndex);
        if (assitInfo.isAvailable) {
            if (fieldName.equalsIgnoreCase(ConfirmQty_F)) {
                BigDecimal newQty = (BigDecimal)e.getValue();
                BigDecimal oldQty = (BigDecimal)e.getOldValue();
                BigDecimal auditQty = (BigDecimal)this.tblMain.getCell(rowIndex, "BaseQty").getValue();
                if (newQty != null && newQty.compareTo(auditQty) > 0) {
                    String msg = this.getResource("ComfirmQtyMoreThanBaseQty");
                    MsgBox.showError((String)msg);
                    this.tblMain.getCell(rowIndex, ConfirmQty_F).setValue((Object)oldQty);
                    this.tblMain.getEditManager().editCellAt(rowIndex, colIndex);
                }
                this.subTotal(rowIndex, colIndex);
            } else {
                if (fieldName.equalsIgnoreCase(DemandDate_F) || fieldName.equalsIgnoreCase(DeliveryDate_F)) {
                    Date demandDate = (Date)this.tblMain.getCell(rowIndex, DemandDate_F).getValue();
                    Date deliveryDate = (Date)this.tblMain.getCell(rowIndex, DeliveryDate_F).getValue();
                    if (demandDate == null || deliveryDate == null) {
                        String msg = this.getResource("DATE_IS_NULL");
                        MsgBox.showError((String)msg);
                        this.tblMain.getEditManager().editCellAt(rowIndex, colIndex);
                        return;
                    }
                    demandDate = this.getDayTime(demandDate);
                    if ((deliveryDate = this.getDayTime(deliveryDate)).after(demandDate)) {
                        String msg = this.getResource("DATE_ERROR");
                        MsgBox.showError((String)msg);
                        this.tblMain.getEditManager().editCellAt(rowIndex, colIndex);
                        return;
                    }
                }
                this.assignedTotal(rowIndex, colIndex, fieldName);
            }
        }
    }

    public Date getDayTime(Date date) {
        if (date == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    private void subTotal(int rowIndex, int colIndex) {
        int j;
        this.rowSet.moveTo(rowIndex);
        this.rowSet.setValue(ConfirmQty_F, this.tblMain.getCell(rowIndex, colIndex).getValue());
        int firstRow = rowIndex;
        for (int i = rowIndex; i >= 0; --i) {
            AssistantInfo assitInfo = (AssistantInfo)this.assistantList.get(i);
            if (!assitInfo.isGroupFirstLine) continue;
            firstRow = i;
            break;
        }
        BigDecimal totalQty = SysConstant.BIGZERO;
        for (j = firstRow; j < this.assistantList.size(); ++j) {
            this.rowSet.moveTo(j);
            AssistantInfo assitInfo = (AssistantInfo)this.assistantList.get(j);
            if (assitInfo.isTotalLine) break;
            totalQty = totalQty.add(this.rowSet.getBigDecimal(ConfirmQty_F));
        }
        this.rowSet.setValue(ConfirmQty_F, (Object)totalQty);
        this.tblMain.getCell(j, colIndex).setValue((Object)totalQty);
    }

    private void assignedTotal(int rowIndex, int colIndex, String fieldName) {
        Object newValue = this.tblMain.getCell(rowIndex, colIndex).getValue();
        if ((fieldName.equalsIgnoreCase(SupplierName_F) || fieldName.equalsIgnoreCase(CurrencyName_F)) && newValue instanceof String) {
            return;
        }
        AssistantInfo assitInfo = (AssistantInfo)this.assistantList.get(rowIndex);
        this.rowSet.moveTo(rowIndex);
        this.rowSet.setValue(fieldName, newValue);
        if (assitInfo.isGroupFirstLine) {
            if (this.tblMain.getCell(rowIndex, MaterialId_F).getValue() != null && fieldName.equalsIgnoreCase(SupplierName_F) && newValue != null) {
                SupplyInfoInfo supplyInfo = null;
                supplyInfo = this.getSupplyInfo(rowIndex);
                if (supplyInfo != null) {
                    BigDecimal rate = new BigDecimal("1.0");
                    if (this.rowSet.getBigDecimal("fexchangerate") != null) {
                        rate = this.rowSet.getBigDecimal("fexchangerate");
                    }
                    BigDecimal purchasePrice = this.converPurchasePrice(supplyInfo, rowIndex);
                    int precision = Integer.parseInt(this.tblMain.getCell(rowIndex, PricePrc_F).getValue().toString());
                    BigDecimal newPrice = purchasePrice.divide(rate, precision, 4);
                    this.assignPrice(rowIndex, newPrice);
                }
            }
            int subLineRow = rowIndex;
            for (int i = rowIndex; i <= this.assistantList.size(); ++i) {
                assitInfo = (AssistantInfo)this.assistantList.get(i);
                if (!assitInfo.isTotalLine) continue;
                subLineRow = i;
                break;
            }
            this.rowSet.moveTo(subLineRow);
            this.rowSet.setValue(fieldName, newValue);
            this.tblMain.getCell(subLineRow, colIndex).setValue(newValue);
            if (fieldName.equalsIgnoreCase(SupplierName_F) || fieldName.equalsIgnoreCase(CurrencyName_F)) {
                String idColName;
                String string = idColName = fieldName.equalsIgnoreCase(SupplierName_F) ? SupplierId_F : CurrencyId_F;
                if (newValue instanceof CoreBaseInfo) {
                    CoreBaseInfo s = (CoreBaseInfo)newValue;
                    this.rowSet.setValue(idColName, (Object)s.getId().toString());
                } else {
                    this.rowSet.setValue(idColName, null);
                }
                if (fieldName.equalsIgnoreCase(CurrencyName_F) && newValue instanceof CurrencyInfo) {
                    CurrencyInfo currency = (CurrencyInfo)newValue;
                    ExchangeRateInfo rateInfo = this.getExchangeRate(currency, this.baseCurrencyInfo);
                    this.tblMain.getCell(rowIndex, "ExchangeRate").setValue((Object)rateInfo.getConvertRate());
                    this.rowSet.setValueAt(rowIndex, "fexchangerate", (Object)rateInfo.getConvertRate());
                    this.tblMain.getCell(subLineRow, "ExchangeRate").setValue((Object)rateInfo.getConvertRate());
                    this.rowSet.setValue("fexchangerate", (Object)rateInfo.getConvertRate());
                }
            }
        }
    }

    private BigDecimal converPurchasePrice(SupplyInfoInfo supplyInfo, int rowIndex) {
        BigDecimal newPrice = supplyInfo.getPrice();
        String materialId = supplyInfo.getMaterialItem().getString("id");
        String unitId = supplyInfo.getPurMeasureUnit().getString("id");
        String baseUnitId = this.tblMain.getCell(rowIndex, "BaseUnitId").getValue().toString();
        if (!baseUnitId.equals(unitId)) {
            try {
                IMultiMeasureUnit multiMeasureUnitCtrl = MultiMeasureUnitFactory.getRemoteInstance();
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("material", (Object)materialId));
                filter.getFilterItems().add(new FilterItemInfo("measureUnit", (Object)unitId));
                view.setFilter(filter);
                MultiMeasureUnitCollection col = multiMeasureUnitCtrl.getMultiMeasureUnitCollection(view);
                if (col.size() > 0) {
                    MultiMeasureUnitInfo mm = col.get(0);
                    int precision = Integer.parseInt(this.tblMain.getCell(rowIndex, PricePrc_F).getValue().toString());
                    newPrice = newPrice.divide(mm.getBaseConvsRate(), precision, 4);
                }
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
        }
        return newPrice;
    }

    private void assignPrice(int rowIndex, BigDecimal newPrice) {
        this.tblMain.getCell(rowIndex, PurchasePrice_F).setValue((Object)newPrice);
        this.rowSet.setValueAt(rowIndex, PurchasePrice_F, (Object)newPrice);
        int colIndex = this.tblMain.getColumnIndex(PurchasePrice_F);
        this.assignedTotal(rowIndex, colIndex, PurchasePrice_F);
    }

    private SupplyInfoInfo getSupplyInfo(int rowIndex) {
        SupplyInfoInfo result = null;
        try {
            ISupplyInfo supplyCtrl = SupplyInfoFactory.getRemoteInstance();
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            PurchaseOrgUnitInfo purchaseInfo = this.getPurchaseOrgFromParam();
            SupplierInfo supplier = (SupplierInfo)this.tblMain.getCell(rowIndex, SupplierName_F).getValue();
            String materialId = (String)this.tblMain.getCell(rowIndex, MaterialId_F).getValue();
            Date demandDate = (Date)this.tblMain.getCell(rowIndex, DemandDate_F).getValue();
            filter.getFilterItems().add(new FilterItemInfo("isUseable", (Object)Boolean.TRUE));
            filter.getFilterItems().add(new FilterItemInfo("purchaseOrg", (Object)purchaseInfo.getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("supplier", (Object)supplier.getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("materialItem", (Object)materialId));
            filter.getFilterItems().add(new FilterItemInfo("effectualDate", (Object)demandDate, CompareType.LESS_EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("uneffectualDate", (Object)demandDate, CompareType.GREATER_EQUALS));
            view.setFilter(filter);
            CoreBaseCollection col = supplyCtrl.getCollection(view);
            if (col.size() >= 1) {
                result = (SupplyInfoInfo)col.get(0);
            }
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        return result;
    }

    private CoreBaseCollection getAllAvailabeSupplier(int rowIndex, boolean isOnlyAvailableSupplier) {
        CoreBaseCollection col = new CoreBaseCollection();
        if (this.tblMain.getCell(rowIndex, MaterialId_F).getValue() != null) {
            try {
                Context mainOrgContext = null;
                PurchaseOrgUnitInfo purchaseInfo = this.getPurchaseOrgFromParam();
                if (mainOrgContext == null) {
                    mainOrgContext = new Context();
                }
                try {
                    FrameWorkUtils.switchOrg((Context)mainOrgContext, (String)purchaseInfo.getId().toString());
                }
                catch (Exception e) {
                    this.handUIException(e);
                }
                Context purMainOrgContext = new Context();
                purMainOrgContext = mainOrgContext;
                purMainOrgContext.put((Object)OrgType.Purchase, (Object)purchaseInfo);
                ISupplyInfo supplyCtrl = SupplyInfoFactory.getRemoteInstanceWithObjectContext((Context)purMainOrgContext);
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                String materialId = (String)this.tblMain.getCell(rowIndex, MaterialId_F).getValue();
                Date demandDate = (Date)this.tblMain.getCell(rowIndex, DemandDate_F).getValue();
                filter.getFilterItems().add(new FilterItemInfo("isUseable", (Object)Boolean.TRUE));
                filter.getFilterItems().add(new FilterItemInfo("purchaseOrg", (Object)purchaseInfo.getId().toString()));
                filter.getFilterItems().add(new FilterItemInfo("materialItem", (Object)materialId));
                filter.getFilterItems().add(new FilterItemInfo("effectualDate", (Object)demandDate, CompareType.LESS_EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("uneffectualDate", (Object)demandDate, CompareType.GREATER_EQUALS));
                if (isOnlyAvailableSupplier) {
                    filter.getFilterItems().add(new FilterItemInfo("materialItem", (Object)materialId));
                }
                view.setFilter(filter);
                col = supplyCtrl.getCollection(view);
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
        }
        return col;
    }

    private PurchaseOrgUnitInfo getPurchaseOrgFromParam() {
        return (PurchaseOrgUnitInfo)this.params.getObject("purchaseOrgFrom");
    }

    private void processSubtotal(RptRowSet rowSet) throws EASBizException, BOSException {
        AssistantInfo materialGroup;
        this.assistantList = new ArrayList();
        if (!rowSet.next()) {
            return;
        }
        String oldMaterial = null;
        boolean oldIsValiable = false;
        int groupNum = 0;
        boolean isGroupFirstLine = true;
        boolean isTotalLine = false;
        BigDecimal subTotalQty = SysConstant.BIGZERO;
        BigDecimal subTotalRequestQty = SysConstant.BIGZERO;
        Object[] totalLineData = null;
        while (true) {
            if (isGroupFirstLine) {
                totalLineData = rowSet.toRowArray();
                for (int j = 0; j < 5; ++j) {
                    totalLineData[j] = null;
                }
                String subString = this.getResource("SUBSTRING");
                totalLineData[5] = subString;
            }
            materialGroup = new AssistantInfo();
            materialGroup.groupNum = groupNum;
            materialGroup.isGroupFirstLine = isGroupFirstLine;
            materialGroup.isTotalLine = isTotalLine;
            materialGroup.isAvailable = rowSet.getString("FAvailable").equals("0");
            this.assistantList.add(materialGroup);
            isGroupFirstLine = false;
            oldMaterial = rowSet.getString(MaterialId_F) == null ? rowSet.getString("matrerilGroupName") + rowSet.getString("materialName") + rowSet.getString("fbaseunitid") + rowSet.getString("rowTypeId") : rowSet.getString(MaterialId_F);
            oldIsValiable = rowSet.getString("FAvailable").equals("0");
            subTotalQty = subTotalQty.add(rowSet.getBigDecimal("qty"));
            BigDecimal requestQty = rowSet.getBigDecimal("requestQty") == null ? new BigDecimal("0") : rowSet.getBigDecimal("requestQty");
            subTotalRequestQty = subTotalRequestQty.add(requestQty);
            if (!rowSet.next()) break;
            String theMaterial = null;
            theMaterial = rowSet.getString(MaterialId_F) == null ? rowSet.getString("materialName") + rowSet.getString("fbaseunitid") + rowSet.getString("rowTypeId") : rowSet.getString(MaterialId_F);
            if (oldMaterial.equals(theMaterial)) continue;
            materialGroup = new AssistantInfo();
            materialGroup.groupNum = groupNum++;
            materialGroup.isGroupFirstLine = false;
            materialGroup.isTotalLine = true;
            materialGroup.isAvailable = oldIsValiable;
            this.assistantList.add(materialGroup);
            rowSet.insertRow(rowSet.getRow(), totalLineData);
            rowSet.setValue("qty", (Object)subTotalQty);
            rowSet.setValue(ConfirmQty_F, (Object)subTotalQty);
            rowSet.setValue("requestqty", (Object)subTotalRequestQty);
            rowSet.next();
            subTotalQty = SysConstant.BIGZERO;
            subTotalRequestQty = SysConstant.BIGZERO;
            isGroupFirstLine = true;
            isTotalLine = false;
        }
        materialGroup = new AssistantInfo();
        materialGroup.groupNum = groupNum;
        materialGroup.isGroupFirstLine = false;
        materialGroup.isTotalLine = true;
        materialGroup.isAvailable = oldIsValiable;
        this.assistantList.add(materialGroup);
        rowSet.addRow(totalLineData);
        rowSet.next();
        rowSet.setValue("qty", (Object)subTotalQty);
        rowSet.setValue(ConfirmQty_F, (Object)subTotalQty);
        rowSet.setValue("requestqty", (Object)subTotalRequestQty);
    }

    private void formatTable() {
        String format = CtrlFormatUtilities.getDateFormatString();
        this.tblMain.getColumn("RequestDate").getStyleAttributes().setNumberFormat(format);
        KDDatePicker demandDate = new KDDatePicker();
        this.tblMain.getColumn(DemandDate_F).setEditor((ICellEditor)new KDTDefaultCellEditor(demandDate));
        this.tblMain.getColumn(DemandDate_F).getStyleAttributes().setNumberFormat(format);
        KDDatePicker deliveryDate = new KDDatePicker();
        this.tblMain.getColumn(DeliveryDate_F).setEditor((ICellEditor)new KDTDefaultCellEditor(deliveryDate));
        this.tblMain.getColumn(DeliveryDate_F).getStyleAttributes().setNumberFormat(format);
        this.tblMain.getColumn(PurchasePrice_F).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn(PurchasePrice_F).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        KDBizPromptBox prmtCurrency = new KDBizPromptBox();
        prmtCurrency.setQueryInfo("com.kingdee.eas.basedata.assistant.app.F7CurrencyQuery");
        prmtCurrency.setEditable(false);
        prmtCurrency.setDisplayFormat("$name$");
        prmtCurrency.setEditFormat("$number$");
        KDTDefaultCellEditor currencyEditor = new KDTDefaultCellEditor((IKDEditor)prmtCurrency);
        this.tblMain.getColumn(CurrencyName_F).setEditor((ICellEditor)currencyEditor);
        KDTextField trackTxt = new KDTextField();
        trackTxt.setMaxLength(80);
        KDTDefaultCellEditor trackEditor = new KDTDefaultCellEditor((JTextField)trackTxt);
        this.tblMain.getColumn(TraceNum_F).setEditor((ICellEditor)trackEditor);
        this.initSupplierF7();
        this.tblMain.getColumn("BaseQty").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn(ConfirmQty_F).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn("requestQty").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        for (int rowIndex = 0; rowIndex < this.tblMain.getRowCount(); ++rowIndex) {
            StyleAttributes style;
            IRow row = this.tblMain.getRow(rowIndex);
            int qtyPre = Integer.parseInt(row.getCell("QtyPrecision").getValue().toString());
            String qtyPreString = SCMClientUtils.getFormatPattern((int)qtyPre);
            row.getCell("BaseQty").getStyleAttributes().setNumberFormat(qtyPreString);
            row.getCell("requestQty").getStyleAttributes().setNumberFormat(qtyPreString);
            KDFormattedTextField txtConfirmQty = new KDFormattedTextField();
            txtConfirmQty.setDataType(1);
            txtConfirmQty.setPrecision(qtyPre);
            txtConfirmQty.setNegatived(false);
            KDTDefaultCellEditor qtyEditor = new KDTDefaultCellEditor((JTextField)txtConfirmQty);
            row.getCell(ConfirmQty_F).getStyleAttributes().setNumberFormat(qtyPreString);
            row.getCell(ConfirmQty_F).setEditor((ICellEditor)qtyEditor);
            int pricePrec = Integer.parseInt(row.getCell(PricePrc_F).getValue().toString());
            KDFormattedTextField txtPrice = new KDFormattedTextField();
            txtPrice.setDataType(1);
            txtPrice.setNegatived(false);
            txtPrice.setPrecision(pricePrec);
            KDTDefaultCellEditor priceEditor = new KDTDefaultCellEditor((JTextField)txtPrice);
            row.getCell(PurchasePrice_F).setEditor((ICellEditor)priceEditor);
            String pricePreString = SCMClientUtils.getFormatPattern((int)pricePrec);
            row.getCell(PurchasePrice_F).getStyleAttributes().setNumberFormat(pricePreString);
            AssistantInfo assitInfo = (AssistantInfo)this.assistantList.get(rowIndex);
            if (assitInfo.isAvailable) {
                Color necessaryColor = new Color(252, 251, 223);
                if (assitInfo.isGroupFirstLine) {
                    ICell cell = null;
                    for (int i = 0; i < unlockedColumns.length; ++i) {
                        cell = row.getCell(unlockedColumns[i]);
                        style = cell.getStyleAttributes();
                        style.setLocked(false);
                        style.setBackground(necessaryColor);
                    }
                } else {
                    ICell cell = row.getCell(ConfirmQty_F);
                    StyleAttributes style2 = cell.getStyleAttributes();
                    style2.setLocked(false);
                    style2.setBackground(necessaryColor);
                }
            }
            if (!assitInfo.isTotalLine && assitInfo.isAvailable) continue;
            int cellCount = this.tblMain.getColumnCount();
            for (int cellIndex = 0; cellIndex < cellCount; ++cellIndex) {
                ICell cell = row.getCell(cellIndex);
                style = cell.getStyleAttributes();
                style.setBackground(Color.lightGray);
                style.setLocked(true);
            }
        }
    }

    private void initSupplierF7() {
        KDBizPromptBox prmtSupplier = new KDBizPromptBox();
        prmtSupplier.setQueryInfo(allSupplierQery);
        prmtSupplier.setEditable(true);
        prmtSupplier.setDisplayFormat("$name$");
        prmtSupplier.setEditFormat("$number$");
        prmtSupplier.setCommitFormat("$number$;$mnemonicCode$");
        GeneralKDPromptSelectorAdaptor selectorLisenter = null;
        selectorLisenter = new GeneralKDPromptSelectorAdaptor((KDPromptBox)prmtSupplier, "com.kingdee.eas.basedata.master.cssp.client.F7SupplierTreeDetailListUI", (Object)this, CSSPGroupInfo.getBosType(), allSupplierQery, "browseGroup.id");
        selectorLisenter.isCurrentMainOrgChanged();
        prmtSupplier.setSelector((KDPromptSelector)selectorLisenter);
        prmtSupplier.addSelectorListener((SelectorListener)selectorLisenter);
        KDTDefaultCellEditor itemEditor = new KDTDefaultCellEditor((IKDEditor)prmtSupplier);
        this.tblMain.getColumn(SupplierName_F).setEditor((ICellEditor)itemEditor);
    }

    private CurrencyInfo getBaseCurrency() {
        if (this.companyInfo == null) {
            return null;
        }
        ObjectUuidPK currencyPK = new ObjectUuidPK(this.companyInfo.getBaseCurrency().getId());
        CurrencyInfo baseCurrInfo = null;
        try {
            baseCurrInfo = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)currencyPK);
        }
        catch (Exception e) {
            this.handUIExceptionAndAbort(e);
        }
        return baseCurrInfo;
    }

    private ExchangeRateInfo getExchangeRate(CurrencyInfo srcCurrency, CurrencyInfo destCurrency) {
        ExchangeRateInfo exchangeRateInfo = CurrencyExchangeRateUtils.baseExchangeRateInfo();
        if (!destCurrency.getId().toString().equals(srcCurrency.getId().toString())) {
            ObjectUuidPK exchangeTablePK = null;
            ExchangeTableInfo exchangeTableInfo = this.companyInfo.getBaseExchangeTable();
            if (exchangeTableInfo != null) {
                exchangeTablePK = new ObjectUuidPK(exchangeTableInfo.getId());
            } else {
                this.handUIExceptionAndAbort((Exception)((Object)new SMReportException(SMReportException.COMPANY_EXCHANGETABLE_NULL, new Object[]{this.companyInfo.getName()})));
            }
            try {
                ObjectUuidPK sourceCurrPK = new ObjectUuidPK(srcCurrency.getId());
                ObjectUuidPK destCurrPK = new ObjectUuidPK(destCurrency.getId());
                IExchangeRate exchangRateCtrl = ExchangeRateFactory.getRemoteInstance();
                exchangeRateInfo = exchangRateCtrl.getExchangeRate((IObjectPK)exchangeTablePK, (IObjectPK)sourceCurrPK, (IObjectPK)destCurrPK, null);
                if (exchangeRateInfo == null) {
                    throw new SCMBillException(SCMBillException.NULL_EXCHANGERATE);
                }
            }
            catch (Exception e) {
                this.handUIExceptionAndAbort(e);
            }
        }
        return exchangeRateInfo;
    }

    @Override
    public void actionQueryStorage_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        HashMap<String, Boolean> hm = new HashMap<String, Boolean>();
        boolean isTableFocus = SCMClientUtils.isTableFocus((KDTable)this.tblMain);
        hm.put("TABLEHASFOCUS", isTableFocus);
        KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get();
        if (selectBlock != null) {
            int rowIndex = selectBlock.getTop();
            this.rowSet.moveTo(rowIndex);
            if (this.rowSet.getString(MaterialId_F) != null && this.rowSet.getString("receivingOrgId") != null) {
                MaterialInfo material = new MaterialInfo();
                material.setId(BOSUuid.read((String)this.rowSet.getString(MaterialId_F)));
                material.setName(this.rowSet.getString("materialName"));
                material.setNumber(this.rowSet.getString("materialNumber"));
                material.setModel(this.rowSet.getString("fmodel"));
                MeasureUnitInfo unitInfo = new MeasureUnitInfo();
                unitInfo.setId(BOSUuid.read((String)this.rowSet.getString("fbaseunitid")));
                unitInfo.setName(this.rowSet.getString("baseUnitName"));
                material.setBaseUnit(unitInfo);
                hm.put("MATERIAL", (Boolean)material);
                StorageOrgUnitInfo storageOrgUnitInfo = null;
                storageOrgUnitInfo = new StorageOrgUnitInfo();
                storageOrgUnitInfo.setId(BOSUuid.read((String)this.rowSet.getString("receivingOrgId")));
                storageOrgUnitInfo.setName(this.rowSet.getString("receivingOrgName"));
                storageOrgUnitInfo.setNumber(this.rowSet.getString("receivingOrgNum"));
                hm.put("STORAGEORGUNIT", (Boolean)storageOrgUnitInfo);
                UIContext uiContext = new UIContext((Object)this);
                if (this.materialWindow == null) {
                    this.materialWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.scm.common.client.MaterialQueryListUI", (Map)uiContext, null, OprtState.EDIT);
                }
                MaterialQueryListUI aMaterialQueryListUI = (MaterialQueryListUI)this.materialWindow.getUIObject();
                aMaterialQueryListUI.setHmQueryCon(hm);
                aMaterialQueryListUI.executQuery();
                this.materialWindow.show();
            }
            if (this.rowSet.getString(MaterialId_F) == null) {
                MsgBox.showInfo((String)this.getResource("NOMATERIALSELECTED"));
                SysUtil.abort();
            }
        } else {
            MsgBox.showInfo((String)this.getResource("NOMATERIALSELECTED"));
            SysUtil.abort();
        }
    }

    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.PURCHASINGMANAGEMENT;
    }

    private void setMainTableFreeze() {
        this.tblMain.getViewManager().setFreezeView(0, this.tblMain.getColumnIndex("Model") + 1);
    }

    public void onLoad() throws Exception {
        this.btnGenOrderBill.setVisible(false);
        this.btnGetAvailableSupplier.setVisible(false);
        super.onLoad();
        this.setMainTableFreeze();
        if (this.tHelper != null) {
            this.tHelper.setCanMoveColumn(true);
        }
        int rowCount = this.tblMain.getRowCount();
        for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
            this.tblMain.getCell(rowIndex, TrackNumber_F).getStyleAttributes().setLocked(true);
            this.tblMain.getCell(rowIndex, Project_F).getStyleAttributes().setLocked(true);
        }
        this.mnuQueryStorage.setIcon(EASResource.getIcon((String)"imgTbtn_demandcollateresult"));
    }

    public void checkSelected() {
        if (this.tblMain.getRowCount() == 0 || this.tblMain.getSelectManager().size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
    }

    class AssistantInfo {
        public boolean isGroupFirstLine = false;
        public int groupNum = 0;
        public boolean isTotalLine = false;
        public boolean isAvailable = false;
    }
}

