/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.report.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.IPurchaseOrgUnit;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitFactory;
import com.kingdee.eas.basedata.org.client.f7.NewOrgUnitFilterInfoProducer;
import com.kingdee.eas.basedata.org.client.f7.SCMRptMultiOrgsF7;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.filter.CompositeFilterElement;
import com.kingdee.eas.scm.common.filter.FilterElement;
import com.kingdee.eas.scm.common.filter.MultiOrgsFilterElement;
import com.kingdee.eas.scm.common.filter.RangeFilterElement;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.common.verify.VerifyItem;
import com.kingdee.eas.scm.common.verify.VerifyType;
import com.kingdee.eas.scm.sm.report.client.AbstractSupplierTradeDetailQueryUI;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Component;
import java.sql.Timestamp;
import org.apache.log4j.Logger;

public class SupplierTradeDetailQueryUI
extends AbstractSupplierTradeDetailQueryUI {
    private static final Logger logger = CoreUIObject.getLogger(SupplierTradeDetailQueryUI.class);
    private static SCMRptMultiOrgsF7 f7;
    private String purchaseOrgIDs = null;
    private static final String resClassName = "com.kingdee.eas.scm.sm.report.SMReportResource";

    public SupplierTradeDetailQueryUI() throws Exception {
        this.setIsSupportMultiOrgs(true);
        this.isReport = true;
        f7 = new SCMRptMultiOrgsF7(this.prmtPurOrgUnitFrom, OrgType.Purchase, EASResource.getString((String)resClassName, (String)"purchaseOrgUnitMutilF7"));
        f7.setUseCache(true);
        f7.setNeedWait4UIOpen(false);
        CompositeFilterElement elements = new CompositeFilterElement(0);
        MultiOrgsFilterElement mainOrgElement = new MultiOrgsFilterElement("PURCHASEORGUNIT.ID", f7, this.prmtPurOrgUnitFrom);
        mainOrgElement.addVerifyItem(new VerifyItem(VerifyType.REQUIRED_TYPE, EASResource.getString((String)resClassName, (String)"purChaseOrgUnitNotNull")));
        elements.add((FilterElement)mainOrgElement);
        elements.add((FilterElement)new RangeFilterElement("StorageOrgUnit.number", (Component)this.prmtStorageOrgUnitFrom, (Component)this.prmtStorageOrgUnitTo));
        elements.add((FilterElement)new RangeFilterElement("supplier.number", (Component)this.prmtSupplierNumFrom, (Component)this.prmtSupplierNumTo));
        RangeFilterElement element = new RangeFilterElement("bizDate", (Component)this.pkBizDateFrom, (Component)this.pkBizDateTo);
        element.addVerifyItem(new VerifyItem(VerifyType.LESS_EQUAL_TYPE, SCMClientUtils.getResource((String)"CompareDate")));
        element.setDefaultValue((Object)new Timestamp[]{SCMUtils.getSCMQueryTime(null, (String)"startDate"), SCMUtils.getSCMQueryTime(null, (String)"endDate")});
        elements.add((FilterElement)element);
        this.getFilterManager().setElement((FilterElement)elements);
        this.getFilterManager().setMainOrgElement((FilterElement)mainOrgElement, "purchaseOrgUnit.id");
        this.setBizOrgF7ByType(this.prmtStorageOrgUnitFrom, OrgType.Storage, this.getMainBizOrgType(), true);
        this.setBizOrgF7ByType(this.prmtStorageOrgUnitTo, OrgType.Storage, this.getMainBizOrgType(), true);
        this.setBizSupplierF7(this.prmtSupplierNumFrom, null);
        this.setBizSupplierF7(this.prmtSupplierNumTo, null);
        this.setNeedMainOrgF7s(new KDBizPromptBox[]{this.prmtStorageOrgUnitFrom, this.prmtStorageOrgUnitTo, this.prmtSupplierNumFrom, this.prmtSupplierNumTo});
    }

    private void setPurOrderF7(KDBizPromptBox prmtPurOrder) {
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(SCMClientUtils.getF7FilterInfoByAuthorizedPurOrg((String)"purchaseOrgUnit.id"));
        prmtPurOrder.setEntityViewInfo(viewInfo);
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void setBizTypeF7(KDBizPromptBox bizPrompt) {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("billType.number", (Object)"220", CompareType.EQUALS));
        viewInfo.setFilter(filter);
        bizPrompt.setEntityViewInfo(viewInfo);
    }

    public Object[] getUnVisibleBillStatus() {
        return new Object[]{BillBaseStatusEnum.ADD, BillBaseStatusEnum.RELEASED};
    }

    public Object[] getAdditiveBillStatus() {
        return null;
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.prmtPurOrgUnitFrom;
    }

    protected String getViewPermission() {
        return "supplierTrade_view";
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Purchase;
    }

    public void afterMainOrgChanged(String ids) {
        this.prmtStorageOrgUnitFrom.setValue(null);
        this.prmtStorageOrgUnitTo.setValue(null);
    }

    private String getPurchaseOrgIds() {
        if (this.purchaseOrgIDs != null) {
            return this.purchaseOrgIDs;
        }
        StringBuffer ids = new StringBuffer();
        try {
            IPurchaseOrgUnit orgCtrl = PurchaseOrgUnitFactory.getRemoteInstance();
            NewOrgUnitFilterInfoProducer iProducer = new NewOrgUnitFilterInfoProducer(OrgType.Purchase);
            EntityViewInfo viewInfo = new EntityViewInfo();
            viewInfo.setFilter(iProducer.getFilterInfo());
            CoreBaseCollection orgCol = orgCtrl.getCollection(viewInfo);
            for (int i = 0; i < orgCol.size(); ++i) {
                if (i == orgCol.size() - 1) {
                    ids.append(orgCol.get(i).getId().toString());
                    continue;
                }
                ids.append(orgCol.get(i).getId().toString()).append(",");
            }
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        this.purchaseOrgIDs = ids.toString();
        return this.purchaseOrgIDs;
    }

    public void clear() {
        super.clear();
    }
}

