/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.sc.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.data.event.RequestRowSetEvent;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.DefaultNoteDataProvider;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.KDRSException;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.basedata.assistant.AbstractPrintIntegrationInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.IPrintIntegration;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.assistant.PrintIntegrationFactory;
import com.kingdee.eas.basedata.assistant.util.PrintIntegrationManager;
import com.kingdee.eas.basedata.framework.util.KDTableUtil;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.common.ReasonCodeInfo;
import com.kingdee.eas.basedata.scm.common.client.ReasonF7Until;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.batchaction.ActionLevelEnum;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchSelectionEntries;
import com.kingdee.eas.framework.client.CoreBillListUI;
import com.kingdee.eas.framework.query.QuickFilteringSupportItems;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.ISCMBillBase;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.action.ActionProxy;
import com.kingdee.eas.scm.common.action.ActionProxyFactory;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.sm.pur.CheckPriceResult;
import com.kingdee.eas.scm.sm.pur.IPurServiceFacade;
import com.kingdee.eas.scm.sm.pur.PurOrderException;
import com.kingdee.eas.scm.sm.pur.PurPriceParam;
import com.kingdee.eas.scm.sm.pur.PurPriceParamCollection;
import com.kingdee.eas.scm.sm.pur.PurServiceFacadeFactory;
import com.kingdee.eas.scm.sm.sc.ISubContractOrder;
import com.kingdee.eas.scm.sm.sc.ISubContractOrderEntry;
import com.kingdee.eas.scm.sm.sc.SubContractOrderCollection;
import com.kingdee.eas.scm.sm.sc.SubContractOrderEntryCollection;
import com.kingdee.eas.scm.sm.sc.SubContractOrderEntryFactory;
import com.kingdee.eas.scm.sm.sc.SubContractOrderEntryInfo;
import com.kingdee.eas.scm.sm.sc.SubContractOrderFactory;
import com.kingdee.eas.scm.sm.sc.SubContractOrderInfo;
import com.kingdee.eas.scm.sm.sc.client.AbstractSubContractOrderListUI;
import com.kingdee.eas.scm.sm.sc.client.SubContractOrderEditUI;
import com.kingdee.eas.scm.sm.sc.client.SubContractOrderQueryUI;
import com.kingdee.eas.scm.util.collection.CollectionUtil;
import com.kingdee.eas.scm.util.constant.SCMConstant;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class SubContractOrderListUI
extends AbstractSubContractOrderListUI {
    private static final long serialVersionUID = 1L;
    private static final String TB_ID = "id";
    private static final String TB_ENTRY_ID = "entries.id";
    private static final String TB_TOTALAMOUNT = "totalAmount";
    private static final String TB_TOTALTAX = "totalTax";
    private static final String TB_TOTALTAXAMOUNT = "totalTaxAmount";
    private static final String TB_LOCALTOTALAMOUNT = "localTotalAmount";
    private static final String TB_LOCALTOTALTAX = "localTotalTax";
    private static final String TB_LOCALTOTALTAXAMOUNT = "localTotalTaxAmount";
    private static final String TB_ENTRY_QTY = "entries.qty";
    private static final String TB_ENTRY_BASEQTY = "entries.baseQty";
    private static final String TB_ENTRY_ASSISTQTY = "entries.assistQty";
    private static final String TB_ENTRY_PRICE = "entries.price";
    private static final String TB_ENTRY_TAXPRICE = "entries.taxPrice";
    private static final String TB_ENTRY_ACTUALPRICE = "entries.actualPrice";
    private static final String TB_ENTRY_ACTUALTAXPRICE = "entries.actualTaxPrice";
    private static final String TB_ENTRY_AMOUNT = "entries.amount";
    private static final String TB_ENTRY_TAX = "entries.tax";
    private static final String TB_ENTRY_TAXAMOUNT = "entries.taxAmount";
    private static final String TB_ENTRY_LOCALAMOUNT = "entries.localAmount";
    private static final String TB_ENTRY_LOCALTAX = "entries.localTax";
    private static final String TB_ENTRY_LOCALTAXAMOUNT = "entries.localTaxAmount";
    private static final String TB_ENTRY_TOTALPAIDAMOUNT = "entries.totalPaidAmount";
    private static final String TB_ENTRY_TOTALAPAMOUNT = "entries.totalApAmount";
    private static final String TB_ENTRY_PREPAIDAMOUNT = "entries.prepaidAmount";
    private static final String TB_ENTRY_TOTALRECEIVEQTY = "entries.totalReceiveQty";
    private static final String TB_ENTRY_UNRECEIVEQTY = "entries.unReceiveQty";
    private static final String TB_ENTRY_TOTALRECEIPTQTY = "entries.totalReceiptQty";
    private static final String TB_ENTRY_UNRECEIPTQTY = "entries.unReceiptQty";
    private static final String TB_ENTRY_TOTALAPQTY = "entries.totalApQty";
    private static final String TB_ENTRY_TOTALRETURNSTOCKQTY = "entries.totalReturnStockQty";
    private static final String TB_TOTALINSTOCKNEEDQTY = "entries.totalInStockNeedQty";
    private static final String TB_TOTALINSTOCKNEEDBASEQTY = "entries.totalInStockNeedBaseQty";
    private static final String TB_ENTRY_TAXRATE = "entries.taxRate";
    private static final String[] EXCHANGERATE_TABS = new String[]{"exchangeRate"};
    private static final String[] QTY_TABS = new String[]{"entries.qty", "entries.baseQty", "entries.assistQty", "entries.totalReceiveQty", "entries.unReceiveQty", "entries.totalReceiptQty", "entries.unReceiptQty", "entries.totalApQty", "entries.totalReturnStockQty", "entries.totalInStockNeedQty", "entries.totalInStockNeedBaseQty"};
    private static final String[] PRICE_TABS = new String[]{"entries.price", "entries.taxPrice", "entries.actualPrice", "entries.actualTaxPrice"};
    private static final String[] AMOUNT_TABS = new String[]{"totalAmount", "totalTax", "totalTaxAmount", "localTotalAmount", "localTotalTax", "localTotalTaxAmount", "entries.amount", "entries.tax", "entries.taxAmount", "entries.localAmount", "entries.localTax", "entries.localTaxAmount", "entries.totalPaidAmount", "entries.totalApAmount", "entries.prepaidAmount"};
    private static final String[] TAXRATE_TABS = new String[]{"entries.taxRate"};
    private static final String[] MERGE_TABS = new String[]{"number", "bizDate", "bizType.name", "supplier.name", "baseStatus", "purchaseOrgUnit.number", "purchaseOrgUnit.name", "purchaseGroup.name", "purchasePerson.name", "saleOrgUnit.name", "currency.name", "exchangeRate", "supplierOrderNumber", "adminOrgUnit.name", "totalAmount", "totalTax", "totalTaxAmount", "localTotalAmount", "localTotalTax", "localTotalTaxAmount", "creator.name", "createTime", "modifier.name", "modificationTime", "auditor.name", "auditTime", "version"};
    private CustomerQueryPanel customerQueryPanel = null;
    private Logger logger = Logger.getLogger(SubContractOrderListUI.class);
    private QuickFilteringSupportItems qfsi = new QuickFilteringSupportItems(true, true);

    public SubContractOrderListUI() throws Exception {
        Map uiContext = this.getUIContext();
        if (uiContext != null) {
            uiContext.put("isSubContract", Boolean.TRUE);
        }
    }

    protected ICoreBase getBizInterface() throws Exception {
        return SubContractOrderFactory.getRemoteInstanceWithObjectContext(this.getMainContext());
    }

    protected ICoreBase getEntryBizInterface() throws Exception {
        return SubContractOrderEntryFactory.getRemoteInstanceWithObjectContext(this.getMainContext());
    }

    protected String getEditUIName() {
        return SubContractOrderEditUI.class.getName();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initUIComponents();
        String format = CtrlFormatUtilities.getDateTimeFormatString();
        this.tblMain.getColumn("auditTime").getStyleAttributes().setNumberFormat(format);
        this.tblMain.getColumn("createTime").getStyleAttributes().setNumberFormat(format);
        this.tblMain.getColumn("modificationTime").getStyleAttributes().setNumberFormat(format);
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    protected QuickFilteringSupportItems getQuickFilteringSupport() {
        return this.qfsi;
    }

    public void initUnReceiptQty() {
        BigDecimal ZERO;
        KDTable table = this.getMainTable();
        table.checkParsed();
        BigDecimal qty = ZERO = SCMConstant.BIGDECIMAL_ZERO;
        BigDecimal totalReceiptQty = ZERO;
        BigDecimal unReceiptQty = ZERO;
        for (int i = 0; i < table.getRowCount(); ++i) {
            qty = table.getRow(i).getCell(TB_ENTRY_QTY).getValue() != null ? (BigDecimal)table.getRow(i).getCell(TB_ENTRY_QTY).getValue() : ZERO;
            unReceiptQty = qty.subtract(totalReceiptQty = table.getRow(i).getCell(TB_ENTRY_TOTALRECEIPTQTY).getValue() != null ? (BigDecimal)table.getRow(i).getCell(TB_ENTRY_TOTALRECEIPTQTY).getValue() : ZERO);
            if (unReceiptQty.compareTo(ZERO) > 0) {
                table.getRow(i).getCell(TB_ENTRY_UNRECEIPTQTY).setValue((Object)unReceiptQty);
                continue;
            }
            table.getRow(i).getCell(TB_ENTRY_UNRECEIPTQTY).setValue((Object)ZERO);
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void initUIComponents() {
        KDTable table = this.getMainTable();
        table.checkParsed();
        String format = CtrlFormatUtilities.getDateFormatString();
        table.getColumn("bizDate").getStyleAttributes().setNumberFormat(format);
        table.getColumn("entries.deliveryDate").getStyleAttributes().setNumberFormat(format);
        table.getColumn("createTime").getStyleAttributes().setNumberFormat(format);
        table.getColumn("modificationTime").getStyleAttributes().setNumberFormat(format);
        table.getColumn("auditTime").getStyleAttributes().setNumberFormat(format);
        table.getViewManager().setFreezeView(0, 5);
        this.actionMultiPrint.setVisible(true);
        this.actionMultiPrintPreview.setVisible(true);
        this.btnSubmit.setVisible(true);
        this.btnSubmit.setEnabled(true);
        this.menuItemSubmit.setVisible(true);
        this.menuItemSubmit.setEnabled(true);
    }

    public String[] getMergeColumnKeys() {
        return MERGE_TABS;
    }

    protected CustomerQueryPanel getFilterUI() throws Exception {
        if (this.customerQueryPanel == null) {
            this.customerQueryPanel = new SubContractOrderQueryUI();
        }
        return this.customerQueryPanel;
    }

    protected boolean initDefaultFilter() {
        return true;
    }

    protected IMetaDataPK getTDQueryPK() {
        return new MetaDataPK("com.kingdee.eas.scm.sm.sc.SubContractOrderPrintQuery");
    }

    protected String getTDFileName() {
        return "/SCM/SM/SubContract/SubContractOrder";
    }

    protected void getRowSetBeforeFillTable(IRowSet rowSet) {
        int currencyPrecision = 2;
        try {
            rowSet.beforeFirst();
            while (rowSet.next()) {
                SCMClientUtils.iniColumnsPrecision((int)this.qtyPrecision, (String[])QTY_TABS, (IRowSet)rowSet);
                SCMClientUtils.iniColumnsPrecision((int)this.pricePrecision, (String[])PRICE_TABS, (IRowSet)rowSet);
                currencyPrecision = rowSet.getInt("currency.precision");
                SCMClientUtils.iniColumnsPrecision((int)currencyPrecision, (String[])AMOUNT_TABS, (IRowSet)rowSet);
            }
        }
        catch (SQLException ex) {
            this.handUIException(ex);
        }
    }

    protected boolean isSupportDynQuery() {
        return true;
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("currency.precision"));
        return sic;
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
    }

    protected void refresh(ActionEvent e) throws Exception {
        super.refresh(e);
    }

    protected String[] getQtyColumns() throws Exception {
        return QTY_TABS;
    }

    protected String[] getPriceColumns() throws Exception {
        return PRICE_TABS;
    }

    public String[] getAmountColumns() {
        return AMOUNT_TABS;
    }

    protected String[] getExColumns() throws Exception {
        return EXCHANGERATE_TABS;
    }

    protected String[] getTaxRateColumns() {
        return TAXRATE_TABS;
    }

    public OrgType getMainBizOrgType() {
        return OrgType.Purchase;
    }

    protected String getPropertyOfBizOrg(OrgType orgType) {
        if (orgType.equals((Object)OrgType.Purchase)) {
            return "purchaseOrgUnit.id";
        }
        if (orgType.equals((Object)OrgType.Storage)) {
            return "receiveOrgUnit.id";
        }
        if (orgType.equals((Object)OrgType.Company)) {
            return "companyOrgUnit.id";
        }
        return null;
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filterInfo = super.getDefaultFilterForQuery();
        return filterInfo;
    }

    public boolean isSupportedBatchActions() {
        return true;
    }

    public void initBatchActions() throws BOSException {
        this.actionManager.setClzIBizFactory(ActionLevelEnum.HEAD, SubContractOrderFactory.class);
        this.actionManager.setClzIBizFactory(ActionLevelEnum.ENTRY, SubContractOrderEntryFactory.class);
        this.getTableSelectionHelper().setTableProperty((CoreBillListUI)this, this.mainQueryPK, this.tblMain, TB_ID, TB_ENTRY_ID, "number", "entries.seq", "purchaseOrgUnit.id");
        ActionProxy actionProxy = null;
        actionProxy = ActionProxyFactory.createActionProxy((BatchActionEnum)BatchActionEnum.CANCEL, (ItemAction)this.actionRevoke, (String)"revoke");
        this.actionManager.registerBatchAction(actionProxy, "actionRevoke");
        actionProxy.bindTo((AbstractButton)this.btnRevoke);
        actionProxy.bindTo((AbstractButton)this.menuItemRevoke);
        actionProxy = ActionProxyFactory.createActionProxy((BatchActionEnum)BatchActionEnum.CLOSE, (ItemAction)this.actionClose, (String)"close");
        this.actionManager.registerBatchAction(actionProxy, "actionClose");
        actionProxy.bindTo((AbstractButton)this.btnClose);
        actionProxy.bindTo((AbstractButton)this.menuItemClose);
        actionProxy = ActionProxyFactory.createActionProxy((BatchActionEnum)BatchActionEnum.UNCLOSE, (ItemAction)this.actionUnclose, (String)"unclose");
        this.actionManager.registerBatchAction(actionProxy, "actionUnclose");
        actionProxy.bindTo((AbstractButton)this.btnUnclose);
        actionProxy.bindTo((AbstractButton)this.menuItemUnclose);
        actionProxy = ActionProxyFactory.createActionProxy((BatchActionEnum)BatchActionEnum.FREEZE, (ItemAction)this.actionFreeze, (String)"freeze");
        this.actionManager.registerBatchAction(actionProxy, "actionFreeze");
        actionProxy.bindTo((AbstractButton)this.btnFreeze);
        actionProxy.bindTo((AbstractButton)this.menuItemFreeze);
        actionProxy = ActionProxyFactory.createActionProxy((BatchActionEnum)BatchActionEnum.UNFREEZE, (ItemAction)this.actionUnclose, (String)"unfreeze");
        this.actionManager.registerBatchAction(actionProxy, "actionUnfreeze");
        actionProxy.bindTo((AbstractButton)this.btnUnfreeze);
        actionProxy.bindTo((AbstractButton)this.menuItemUnfreeze);
        this.btnUnclose.setIcon(EASResource.getIcon((String)"imgTbtn_fclose"));
        this.menuItemUnclose.setIcon(EASResource.getIcon((String)"imgTbtn_fclose"));
        super.initBatchActions();
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        super.actionView_actionPerformed(e);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemove_actionPerformed(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionRevoke_actionPerformed(ActionEvent e) throws Exception {
        String[] selectedIDs = SCMClientUtils.getSelectRowFieldValue((KDTable)this.getMainTable(), (String)TB_ID);
        if (selectedIDs == null || selectedIDs.length == 0 || selectedIDs[0] == null) {
            return;
        }
        try {
            this.setOprtState("REVOKE");
            int n = selectedIDs.length;
            for (int i = 0; i < n; ++i) {
                this.pubFireVOChangeListener(selectedIDs[i]);
            }
            Object reasonObject = ReasonF7Until.getReason((IUIWindow)ReasonF7Until.showClosedReasonUI((Map)this.getUIContext(), (IUIWindow)this.getUIWindow()));
            String reason = null;
            if (reasonObject instanceof String) {
                reason = (String)reasonObject;
            } else if (reasonObject instanceof ReasonCodeInfo) {
                reason = ((ReasonCodeInfo)reasonObject).getName();
            }
            IObjectPK[] pks = SCMUtils.convertStringToObjectPK((String[])selectedIDs);
            ISubContractOrder subContractOrder = (ISubContractOrder)this.getBizInterface();
            subContractOrder.revoke(pks, reason);
            this.setOprtState(OprtState.VIEW);
            this.refreshList();
        }
        catch (Throwable t) {
            this.handUIException(t);
        }
        finally {
            this.setOprtState("RELEASEALL");
            try {
                int n = selectedIDs.length;
                for (int i = 0; i < n; ++i) {
                    this.pubFireVOChangeListener(selectedIDs[i]);
                }
            }
            catch (Throwable t) {
                this.handUIException(t);
            }
        }
    }

    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        super.actionAudit_actionPerformed(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionUnAudit_actionPerformed(ActionEvent e) throws Exception {
        String[] selectedIDs = SCMClientUtils.getSelectRowFieldValue((KDTable)this.getMainTable(), (String)TB_ID);
        if (selectedIDs == null || selectedIDs.length == 0 || selectedIDs[0] == null) {
            return;
        }
        try {
            this.setOprtState("UNAUDIT");
            int n = selectedIDs.length;
            for (int i = 0; i < n; ++i) {
                this.pubFireVOChangeListener(selectedIDs[i]);
            }
            IObjectPK[] pks = SCMUtils.convertStringToObjectPK((String[])selectedIDs);
            ISubContractOrder subContractOrder = (ISubContractOrder)this.getBizInterface();
            subContractOrder.unAudit(pks);
            this.setOprtState(OprtState.VIEW);
            this.refreshList();
        }
        catch (Throwable t) {
            this.handUIException(t);
        }
        finally {
            this.setOprtState("RELEASEALL");
            try {
                int n = selectedIDs.length;
                for (int i = 0; i < n; ++i) {
                    this.pubFireVOChangeListener(selectedIDs[i]);
                }
            }
            catch (Throwable t) {
                this.handUIException(t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionClose_actionPerformed(ActionEvent e) throws Exception {
        String[] selectedIDs = SCMClientUtils.getSelectRowFieldValue((KDTable)this.getMainTable(), (String)TB_ID);
        if (selectedIDs == null || selectedIDs.length == 0 || selectedIDs[0] == null) {
            return;
        }
        try {
            this.setOprtState("CLOSE");
            int n = selectedIDs.length;
            for (int i = 0; i < n; ++i) {
                this.pubFireVOChangeListener(selectedIDs[i]);
            }
            Object reasonObject = ReasonF7Until.getReason((IUIWindow)ReasonF7Until.showClosedReasonUI((Map)this.getUIContext(), (IUIWindow)this.getUIWindow()));
            String reason = null;
            if (reasonObject instanceof String) {
                reason = (String)reasonObject;
            } else if (reasonObject instanceof ReasonCodeInfo) {
                reason = ((ReasonCodeInfo)reasonObject).getName();
            }
            String[] selectedEntryIDs = SCMClientUtils.getSelectRowFieldValue((KDTable)this.getMainTable(), (String)TB_ENTRY_ID);
            IObjectPK[] entryPKs = SCMUtils.convertStringToObjectPK((String[])selectedEntryIDs);
            ISubContractOrderEntry subContractOrderEntry = (ISubContractOrderEntry)this.getEntryBizInterface();
            subContractOrderEntry.close(entryPKs, reason);
            this.setOprtState(OprtState.VIEW);
            this.refreshList();
        }
        catch (Throwable t) {
            this.handUIException(t);
        }
        finally {
            this.setOprtState("RELEASEALL");
            try {
                int n = selectedIDs.length;
                for (int i = 0; i < n; ++i) {
                    this.pubFireVOChangeListener(selectedIDs[i]);
                }
            }
            catch (Throwable t) {
                this.handUIException(t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionUnclose_actionPerformed(ActionEvent e) throws Exception {
        String[] selectedIDs = SCMClientUtils.getSelectRowFieldValue((KDTable)this.getMainTable(), (String)TB_ID);
        if (selectedIDs == null || selectedIDs.length == 0 || selectedIDs[0] == null) {
            return;
        }
        try {
            this.setOprtState("UNCLOSE");
            int n = selectedIDs.length;
            for (int i = 0; i < n; ++i) {
                this.pubFireVOChangeListener(selectedIDs[i]);
            }
            String[] selectedEntryIDs = SCMClientUtils.getSelectRowFieldValue((KDTable)this.getMainTable(), (String)TB_ENTRY_ID);
            IObjectPK[] entryPKs = SCMUtils.convertStringToObjectPK((String[])selectedEntryIDs);
            ISubContractOrderEntry subContractOrderEntry = (ISubContractOrderEntry)this.getEntryBizInterface();
            subContractOrderEntry.unclose(entryPKs);
            this.setOprtState(OprtState.VIEW);
            this.refreshList();
        }
        catch (Throwable t) {
            this.handUIException(t);
        }
        finally {
            this.setOprtState("RELEASEALL");
            try {
                int n = selectedIDs.length;
                for (int i = 0; i < n; ++i) {
                    this.pubFireVOChangeListener(selectedIDs[i]);
                }
            }
            catch (Throwable t) {
                this.handUIException(t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionFreeze_actionPerformed(ActionEvent e) throws Exception {
        String[] selectedIDs = SCMClientUtils.getSelectRowFieldValue((KDTable)this.getMainTable(), (String)TB_ID);
        if (selectedIDs == null || selectedIDs.length == 0 || selectedIDs[0] == null) {
            return;
        }
        try {
            this.setOprtState("FREEZE");
            int n = selectedIDs.length;
            for (int i = 0; i < n; ++i) {
                this.pubFireVOChangeListener(selectedIDs[i]);
            }
            Object reasonObject = ReasonF7Until.getReason((IUIWindow)ReasonF7Until.showClosedReasonUI((Map)this.getUIContext(), (IUIWindow)this.getUIWindow()));
            String reason = null;
            if (reasonObject instanceof String) {
                reason = (String)reasonObject;
            } else if (reasonObject instanceof ReasonCodeInfo) {
                reason = ((ReasonCodeInfo)reasonObject).getName();
            }
            String[] selectedEntryIDs = SCMClientUtils.getSelectRowFieldValue((KDTable)this.getMainTable(), (String)TB_ENTRY_ID);
            IObjectPK[] entryPKs = SCMUtils.convertStringToObjectPK((String[])selectedEntryIDs);
            ISubContractOrderEntry subContractOrderEntry = (ISubContractOrderEntry)this.getEntryBizInterface();
            subContractOrderEntry.freeze(entryPKs, reason);
            this.setOprtState(OprtState.VIEW);
            this.refreshList();
        }
        catch (Throwable t) {
            this.handUIException(t);
        }
        finally {
            this.setOprtState("RELEASEALL");
            try {
                int n = selectedIDs.length;
                for (int i = 0; i < n; ++i) {
                    this.pubFireVOChangeListener(selectedIDs[i]);
                }
            }
            catch (Throwable t) {
                this.handUIException(t);
            }
        }
    }

    protected void invokeMultiPrintFunction(List idList, boolean isPrint) {
        if (idList == null || idList.size() == 0 || this.gettDQueryPKEx() == null || this.getTDFileName() == null) {
            return;
        }
        StringBuffer err = new StringBuffer();
        CoreBaseCollection collection = new CoreBaseCollection();
        collection = this.getScmBillCollection(idList);
        SCMBillBaseInfo aSCMBillBaseInfo = null;
        for (int i = 0; i < collection.size(); ++i) {
            aSCMBillBaseInfo = (SCMBillBaseInfo)collection.get(i);
            if (aSCMBillBaseInfo.getBaseStatus() != BillBaseStatusEnum.TEMPORARILYSAVED) continue;
            err.append(EASResource.getString((String)"com.kingdee.eas.scm.common.SCMResource", (String)"BILL") + aSCMBillBaseInfo.getNumber() + EASResource.getString((String)"com.kingdee.eas.scm.common.SCMResource", (String)"CANNOTPRINT") + "\n");
        }
        if (err.length() > 0) {
            MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.scm.common.SCMResource", (String)"SELECTBILLCANNOTPRINT"), (String)err.toString(), (int)2);
            SysUtil.abort();
        }
        StringBuffer failToPrintMsg = new StringBuffer();
        KDNoteHelper tpHelper = new KDNoteHelper();
        BOSObjectType bosObjectType = null;
        try {
            int curNum = 1;
            bosObjectType = this.getBizInterface().getType();
            String bosType = bosObjectType.toString();
            IPrintIntegration pinfo = PrintIntegrationFactory.getRemoteInstance();
            List infoList = pinfo.getBillsPrintInfoByList(idList, bosType);
            tpHelper.prepareBizCall(this.getTDFileName());
            boolean isTimesCtrl = tpHelper.isPrintTimesControllable2(this.getTDFileName());
            if (this.getTDFileName() != null && this.getTDFileName().trim().length() > 0 && isTimesCtrl) {
                for (int i = 0; i < infoList.size(); ++i) {
                    Object[] objs;
                    String msgInfo;
                    String billNumber;
                    this.logger.info((Object)"start the print control!");
                    int maxNum = tpHelper.getMaxPrintTimes2(this.getTDFileName());
                    int pnum = ((AbstractPrintIntegrationInfo)infoList.get(i)).getPrintedNumber();
                    String billID = ((AbstractPrintIntegrationInfo)infoList.get(i)).getPrintBillID();
                    this.logger.info((Object)("Max print number:>>" + maxNum));
                    this.logger.info((Object)("Alreadey print number:>>" + pnum));
                    this.logger.info((Object)("current print number:>>" + curNum));
                    if (pnum >= maxNum) {
                        idList.remove(billID);
                        billNumber = pinfo.getBillNumberByBosType(bosType, billID);
                        msgInfo = EASResource.getString((String)"com.kingdee.eas.basedata.assistant.PrintIntegrationResource", (String)"pi.controlinfo1");
                        objs = new Object[]{billNumber, String.valueOf(curNum), String.valueOf(pnum), String.valueOf(maxNum)};
                        failToPrintMsg.append(MessageFormat.format(msgInfo, objs) + "\n");
                        continue;
                    }
                    if (curNum + pnum <= maxNum) continue;
                    idList.remove(billID);
                    billNumber = pinfo.getBillNumberByBosType(bosType, billID);
                    msgInfo = EASResource.getString((String)"com.kingdee.eas.basedata.assistant.PrintIntegrationResource", (String)"pi.controlinfo2");
                    objs = new Object[]{billNumber, String.valueOf(curNum), String.valueOf(pnum), String.valueOf(maxNum)};
                    failToPrintMsg.append(MessageFormat.format(msgInfo, objs) + "\n");
                }
                if (failToPrintMsg.toString().trim().length() > 0) {
                    String error = EASResource.getString((String)"com.kingdee.eas.scm.common.SCMResource", (String)"FailToPrintMsg");
                    MsgBox.showDetailAndOK(null, (String)error, (String)failToPrintMsg.toString(), (int)8188);
                }
            }
        }
        catch (KDRSException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        if (idList == null || idList.size() == 0 || this.gettDQueryPKEx() == null || this.getTDFileName() == null) {
            return;
        }
        DefaultNoteDataProvider data = new DefaultNoteDataProvider(idList, this.getTDQueryPK());
        KDNoteHelper appHlp = new KDNoteHelper();
        PrintIntegrationManager.initPrint((KDNoteHelper)appHlp, (BOSObjectType)bosObjectType, (List)idList, (String)this.getTDFileName(), (String)"com.kingdee.eas.scm.common.SCMResource", (boolean)true);
        if (isPrint) {
            tpHelper.print(this.getTDFileName(), (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
        } else {
            tpHelper.printPreview(this.getTDFileName(), (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
        }
        this.setMessageText(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionUnfreeze_actionPerformed(ActionEvent e) throws Exception {
        String[] selectedIDs = SCMClientUtils.getSelectRowFieldValue((KDTable)this.getMainTable(), (String)TB_ID);
        if (selectedIDs == null || selectedIDs.length == 0 || selectedIDs[0] == null) {
            return;
        }
        try {
            this.setOprtState("UNFREEZE");
            int n = selectedIDs.length;
            for (int i = 0; i < n; ++i) {
                this.pubFireVOChangeListener(selectedIDs[i]);
            }
            String[] selectedEntryIDs = SCMClientUtils.getSelectRowFieldValue((KDTable)this.getMainTable(), (String)TB_ENTRY_ID);
            IObjectPK[] entryPKs = SCMUtils.convertStringToObjectPK((String[])selectedEntryIDs);
            ISubContractOrderEntry subContractOrderEntry = (ISubContractOrderEntry)this.getEntryBizInterface();
            subContractOrderEntry.unclose(entryPKs);
            this.setOprtState(OprtState.VIEW);
            this.refreshList();
        }
        catch (Throwable t) {
            this.handUIException(t);
        }
        finally {
            this.setOprtState("RELEASEALL");
            try {
                int n = selectedIDs.length;
                for (int i = 0; i < n; ++i) {
                    this.pubFireVOChangeListener(selectedIDs[i]);
                }
            }
            catch (Throwable t) {
                this.handUIException(t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionAlter_actionPerformed(ActionEvent e) throws Exception {
        super.actionAlter_actionPerformed(e);
        this.checkSelected();
        ArrayList ids = super.getSelectedIdValues();
        ISubContractOrder iSubContractOrder = SubContractOrderFactory.getRemoteInstance();
        try {
            this.setOprtState("REVOKE");
            this.pubFireVOChangeListener(ids.get(0).toString());
            iSubContractOrder.checkAlert((IObjectPK)new ObjectUuidPK(ids.get(0).toString()));
            this.showAlertUI(e);
        }
        catch (EASBizException ex) {
            this.handleException((Exception)((Object)ex));
        }
        catch (Throwable t) {
            this.handUIException(t);
        }
        finally {
            this.setOprtState("RELEASEALL");
            try {
                this.pubFireVOChangeListener(null);
            }
            catch (Throwable t) {
                this.handUIException(t);
            }
        }
    }

    public void showAlertUI(ActionEvent e) throws Exception {
        IUIWindow uiWindow = this.getAlertUI(e);
        uiWindow.show();
        if (this.isDoRefresh(uiWindow)) {
            this.refresh(e);
        }
    }

    private IUIWindow getAlertUI(ActionEvent e) throws Exception {
        this.checkSelected();
        this.checkObjectExists();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)this.getSelectedKeyValue());
        this.prepareUIContext(uiContext, e);
        IUIWindow uiWindow = null;
        uiWindow = SwingUtilities.getWindowAncestor((Component)((Object)this)) != null && SwingUtilities.getWindowAncestor((Component)((Object)this)) instanceof JDialog ? UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(this.getEditUIName(), (Map)uiContext, null, "ALTER") : UIFactory.createUIFactory((String)this.getEditUIModal()).create(this.getEditUIName(), (Map)uiContext, null, "ALTER");
        return uiWindow;
    }

    private void checkObjectExists() throws BOSException, EASBizException, Exception {
        if (this.getSelectedKeyValue() == null) {
            return;
        }
        if (!this.getBizInterface().exists((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)this.getSelectedKeyValue())))) {
            this.refreshList();
            throw new EASBizException(EASBizException.CHECKEXIST);
        }
    }

    @Override
    public void actionViewVersion_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String[] selIDs = SCMClientUtils.getSelectRowFieldValue((KDTable)this.tblMain, (String)TB_ID);
        if (selIDs == null) {
            this.handleException((Exception)((Object)new PurOrderException(PurOrderException.ORDER_MUSTSELECT_ONEENTRY, new String[]{""})));
            return;
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"BillID", (Object)SCMUtils.convertStringToObjectPK((String[])selIDs));
        uiContext.put((Object)"mainOrgId", (Object)((OrgUnitInfo)this.getUIContext().get(this.getMainBizOrgType())));
        IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        IUIWindow window = uiFactory.create("com.kingdee.eas.scm.sm.sc.client.SubContractOrderVersionUI", (Map)uiContext, null);
        window.show();
    }

    public boolean isSubContractBill() {
        return true;
    }

    protected FilterInfo getBOTPFilterByBillType(String BillTypeId, OrgType destType, String destOrgId) {
        FilterInfo bizFilterInfo = null;
        if (this.getBOTPViewStatus() == 1) {
            String billTypeId;
            HashMap botpMap = this.getBOTPMap();
            if (botpMap != null && botpMap.containsKey("ISARAP")) {
                bizFilterInfo = new FilterInfo();
                if (botpMap.containsKey("ARAPCOMPANY")) {
                    CompanyOrgUnitInfo companyOrgInfo = (CompanyOrgUnitInfo)botpMap.get("ARAPCOMPANY");
                    bizFilterInfo.getFilterItems().add(new FilterItemInfo("receiveCompanyOrgUnit.id", (Object)companyOrgInfo.getId().toString(), CompareType.EQUALS));
                }
            }
            if (botpMap != null && botpMap.containsKey("DESTBILLTYPE.ID") && botpMap.get("DESTBILLTYPE.ID") != null && (billTypeId = botpMap.get("DESTBILLTYPE.ID").toString()).equals("50957179-0105-1000-e000-0163c0a812fd463ED552")) {
                bizFilterInfo = new FilterInfo();
                StorageOrgUnitInfo storageOrgUnitInfo = (StorageOrgUnitInfo)botpMap.get("MAINBIZORG");
                bizFilterInfo.getFilterItems().add(new FilterItemInfo("requestOrgUnit.id", (Object)storageOrgUnitInfo.getId().toString()));
            }
            OrgType srcType = this.getMainBizOrgType();
            String srcOrgProp = this.getPropertyOfBizOrg(srcType);
            OrgUnitCollection collection = null;
            ISCMBillBase iBiz = null;
            if (srcType.equals((Object)destType)) {
                this.getUIContext().put(this.getMainBizOrgType(), (OrgUnitInfo)botpMap.get("MAINBIZORG"));
                this.initUIMainOrgContext(destOrgId);
            } else if (srcOrgProp != null) {
                try {
                    iBiz = (ISCMBillBase)this.getBizInterface();
                    collection = iBiz.getAuthOrgsByRelation(destType, srcType, destOrgId, this.mainQueryPK);
                }
                catch (Exception e) {
                    this.handUIException(e);
                }
                if (collection != null && collection.size() > 0) {
                    this.getUIContext().put(this.getMainBizOrgType(), collection.get(0));
                    this.initUIMainOrgContext(collection.get(0).getId().toString());
                    botpMap.put(this.getMainBizOrgType(), collection.get(0));
                } else {
                    if (bizFilterInfo == null) {
                        bizFilterInfo = new FilterInfo();
                    }
                    bizFilterInfo.getFilterItems().add(new FilterItemInfo(TB_ID, (Object)"NotExists"));
                }
            }
        }
        return bizFilterInfo;
    }

    public String getsourceBillEntryId() {
        return "entries.sourceBillEntryId";
    }

    public CommonQueryDialog initCommonQueryDialog() {
        super.initCommonQueryDialog();
        this.commonQueryDialog.setWidth(580);
        this.commonQueryDialog.setHeight(355);
        return this.commonQueryDialog;
    }

    protected void tblMain_doRequestRowSet(RequestRowSetEvent e) {
        if (this.getUIContext().get("BTPEDITPARAMETER") != null && "PaymentBill".equals(((Map)this.getUIContext().get("BTPEDITPARAMETER")).get("TargetBillType"))) {
            CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)((Map)this.getUIContext().get("BTPEDITPARAMETER")).get("ARAPCOMPANY");
            FilterInfo fi = new FilterInfo();
            if (company != null) {
                fi.getFilterItems().add(new FilterItemInfo("companyOrgUnit.id", (Object)company.getId().toString()));
                try {
                    this.mainQuery.getFilter().mergeFilter(fi, "AND");
                }
                catch (BOSException ex) {
                    this.handUIException(ex);
                }
            } else if (SysContext.getSysContext().getCurrentFIUnit() != null) {
                fi.getFilterItems().add(new FilterItemInfo("companyOrgUnit.id", (Object)SysContext.getSysContext().getCurrentFIUnit().getId().toString()));
                try {
                    this.mainQuery.getFilter().mergeFilter(fi, "AND");
                }
                catch (BOSException ex) {
                    this.handUIException(ex);
                }
            }
        }
        super.tblMain_doRequestRowSet(e);
    }

    public boolean beforeAction(BatchActionEnum bizAction, BatchSelectionEntries selectionEntries, ActionEvent event) {
        this.getMainOrgContext().put((Object)"CONTEXT_KEY_ISBATCHACTION", (Object)Boolean.FALSE);
        boolean result = super.beforeAction(bizAction, selectionEntries, event);
        super.checkSelected();
        if (BatchActionEnum.SUBMIT.equals((Object)bizAction)) {
            String[] strID = KDTableUtil.getSelectRowFieldValue((KDTable)this.tblMain, (String)TB_ID);
            IObjectPK[] pks = SCMUtils.convertStringToObjectPK((String[])strID);
            HashSet<String> idSet = new HashSet<String>();
            int len = pks.length;
            for (int i = 0; i < len; ++i) {
                idSet.add(pks[i].toString());
            }
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo(TB_ID, idSet, CompareType.INCLUDE));
            view.setFilter(filter);
            try {
                ISubContractOrder iSub = SubContractOrderFactory.getRemoteInstance();
                SubContractOrderCollection col = iSub.getSubContractOrderCollection(view);
                SubContractOrderInfo bill = null;
                IPurServiceFacade iPurService = PurServiceFacadeFactory.getRemoteInstance();
                int size = col.size();
                for (int i = 0; i < size; ++i) {
                    PurPriceParamCollection paramCol;
                    CheckPriceResult checkResult;
                    bill = col.get(i);
                    if (this.isBotpBill(bill, "9XXvbVGlRtym/0qtqeIXXrhE1B8=")) {
                        bill.put("PlannedOrder", "PlannedOrder");
                    }
                    if (!(checkResult = iPurService.topPriceCtrl(paramCol = this.getParamCol4FetchStrategy((IObjectValue)bill))).hasErrorMsg()) continue;
                    if (checkResult.getMessageType() == 2) {
                        MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.scm.sm.pur.PurUIResource", (String)"MSG_TOPPRICE", (Object[])new Object[]{bill.getNumber()}));
                        return false;
                    }
                    MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.scm.sm.pur.PurUIResource", (String)"ERROR_TOPPRICE", (Object[])new Object[]{bill.getNumber()}));
                    return false;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    private PurPriceParamCollection getParamCol4FetchStrategy(IObjectValue model) {
        SubContractOrderInfo pr = (SubContractOrderInfo)model;
        PurPriceParamCollection paramCol = new PurPriceParamCollection();
        paramCol.setBillTypeId(pr.getBillType() != null ? pr.getBillType().getId().toString() : null);
        paramCol.setBizTypeId(pr.getBizType() != null ? pr.getBizType().getId().toString() : null);
        SubContractOrderEntryCollection col = pr.getEntries();
        if (CollectionUtil.isEmpty((AbstractObjectCollection)col)) {
            return null;
        }
        int size = col.size();
        SubContractOrderEntryInfo entry = null;
        for (int i = 0; i < size; ++i) {
            entry = col.get(i);
            if (!this.isHasParam((IObjectValue)entry)) continue;
            PurPriceParam param = this.getParam4FetchStrategy((IObjectValue)pr, (IObjectValue)entry);
            paramCol.addPurPriceParam(param);
        }
        return paramCol;
    }

    protected boolean isHasParam(IObjectValue model) {
        SubContractOrderEntryInfo entry = (SubContractOrderEntryInfo)model;
        return entry.getMaterial() != null;
    }

    public PurPriceParam getParam4FetchStrategy(IObjectValue billModel, IObjectValue entryModel) {
        SubContractOrderInfo bill = (SubContractOrderInfo)billModel;
        SubContractOrderEntryInfo entry = (SubContractOrderEntryInfo)entryModel;
        PurPriceParam param = new PurPriceParam();
        param.setMaterialPurchaseType(this.isSubContractBill() ? 1 : 0);
        String billTypeId = bill.getBillType() == null ? null : bill.getBillType().getId().toString();
        param.setBillTypeId(billTypeId);
        param.setSeq(entry.getSeq());
        PurchaseOrgUnitInfo purchaseOrgUnit = null;
        CurrencyInfo currency = null;
        purchaseOrgUnit = bill.getPurchaseOrgUnit();
        currency = bill.getCurrency();
        param.setPurOrgUnitId(purchaseOrgUnit != null ? purchaseOrgUnit.getId().toString() : null);
        param.setCurrencyId(currency != null ? currency.getId().toString() : null);
        MaterialInfo material = null;
        MaterialInfo obj = entry.getMaterial();
        material = obj != null && obj instanceof Object[] ? (MaterialInfo)((Object[])obj)[0] : obj;
        param.setMaterialId(material != null ? material.getId().toString() : null);
        MeasureUnitInfo unit = entry.getUnit();
        param.setUnitId(unit != null ? unit.getId().toString() : null);
        BigDecimal actualPrice = entry.getPrice();
        param.setActualPrice(actualPrice);
        BigDecimal actualTaxPrice = entry.getPrice();
        param.setActualTaxPrice(actualTaxPrice);
        param.setBizTypeId(bill.getBizType() == null ? null : bill.getBizType().getId().toString());
        return param;
    }

    protected boolean isBotpBill(SubContractOrderInfo info) {
        if (info == null) {
            return false;
        }
        BillTypeInfo billType = info.getSourceBillType();
        return billType != null;
    }

    protected boolean isBotpBill(SubContractOrderInfo info, String billTypeID) {
        if (this.isBotpBill(info)) {
            return info.getSourceBillType().getId().toString().equals(billTypeID);
        }
        return false;
    }
}

