/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.srm.supm.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.data.logging.Logger;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.CellCheckBoxRenderer;
import com.kingdee.bos.ctrl.kdf.util.render.CellTextRender;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.codingrule.CodingRuleException;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.CompanyF7;
import com.kingdee.eas.basedata.org.client.f7.PurchaseF7;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.scm.srm.supm.EvalTypeEnum;
import java.awt.Component;
import java.math.BigDecimal;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTextField;

public class SupmHelper {
    public static final String RESOURCE_FILE_NAME = "com.kingdee.eas.scm.srm.supm.client.SupmResource";
    public static final BigDecimal ZERO = new BigDecimal("0");
    public static final BigDecimal HUNDRED = new BigDecimal("100");

    public static KDFormattedTextField initFormattedTextCell(KDTable tblMain, String name, BigDecimal maxScore, BigDecimal minScore) {
        KDFormattedTextField formatField = new KDFormattedTextField(1);
        formatField.setMaximumValue((Comparable)maxScore);
        formatField.setMinimumValue((Comparable)minScore);
        KDTDefaultCellEditor editor = new KDTDefaultCellEditor((JTextField)formatField);
        tblMain.getColumn(name).setEditor((ICellEditor)editor);
        tblMain.getColumn(name).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        tblMain.getColumn(name).getStyleAttributes().setNumberFormat(SupmHelper.getKDTCurrencyFormat(2));
        return formatField;
    }

    public static void lockColumn(KDTable tblMain, String[] names, boolean lock) {
        for (int i = 0; i < names.length; ++i) {
            tblMain.getColumn(names[i]).getStyleAttributes().setLocked(lock);
        }
    }

    public static KDFormattedTextField initFormattedTextCell(KDTable tblMain, String name) {
        KDFormattedTextField formatField = new KDFormattedTextField(1);
        KDTDefaultCellEditor editor = new KDTDefaultCellEditor((JTextField)formatField);
        tblMain.getColumn(name).setEditor((ICellEditor)editor);
        tblMain.getColumn(name).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        tblMain.getColumn(name).getStyleAttributes().setNumberFormat(SupmHelper.getKDTCurrencyFormat(2));
        return formatField;
    }

    public static KDBizPromptBox initF7Cell(KDTable tblMain, String name) {
        KDBizPromptBox box = new KDBizPromptBox();
        KDTDefaultCellEditor editor = new KDTDefaultCellEditor((IKDEditor)box);
        tblMain.getColumn(name).setEditor((ICellEditor)editor);
        return box;
    }

    public static void initFilterF7Format(KDBizPromptBox box) {
        box.setDisplayFormat("$name$");
        box.setEditFormat("$number$");
        box.setCommitFormat("$number$");
    }

    public static void initTextColumn(KDTable tblMain, String name) {
        KDTextField txt = new KDTextField();
        txt.setMaxLength(80);
        KDTDefaultCellEditor editor = new KDTDefaultCellEditor((JTextField)txt);
        tblMain.getColumn(name).setEditor((ICellEditor)editor);
    }

    public static void initEvalClass(KDBizPromptBox box) {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("usedState", (Object)String.valueOf(1)));
        try {
            filter.mergeFilter(SupmHelper.getDefaultCUFilter(), "and");
        }
        catch (BOSException e) {
            Logger.error((Throwable)e);
        }
        EntityViewInfo evalvi = new EntityViewInfo();
        evalvi.setFilter(filter);
        box.setDisplayFormat("$name$");
        box.setEditFormat("$number$");
        box.setCommitFormat("$number$");
        box.setQueryInfo("com.kingdee.eas.scm.srm.supm.app.EvalClassQuery");
        box.setEntityViewInfo(evalvi);
        box.getQueryAgent().resetRuntimeEntityView();
    }

    public static KDFormattedTextField initNumberTextCell(KDTable tblMain, String name, boolean isNegative) {
        KDFormattedTextField formatField = new KDFormattedTextField(0);
        formatField.setNegatived(isNegative);
        KDTDefaultCellEditor editor = new KDTDefaultCellEditor((JTextField)formatField);
        tblMain.getColumn(name).setEditor((ICellEditor)editor);
        tblMain.getColumn(name).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        return formatField;
    }

    public static void initPurchaseOrg(IUIObject ui, CtrlUnitInfo curCtrlUnitInfo, KDBizPromptBox prmtpurchaseOrg) {
        PurchaseF7 f7PurchaseOrg = new PurchaseF7(ui);
        f7PurchaseOrg.setMultiSelect(false);
        f7PurchaseOrg.setIsCUFilter(false);
        prmtpurchaseOrg.setSelector((KDPromptSelector)f7PurchaseOrg);
        prmtpurchaseOrg.setDisplayFormat("$number$");
        prmtpurchaseOrg.setCommitFormat("$number$");
    }

    public static void initCompanyOrg(IUIObject ui, CtrlUnitInfo curCtrlUnitInfo, KDBizPromptBox prmtcompayOrg) {
        CompanyF7 f7CompanyOrg = new CompanyF7(ui);
        f7CompanyOrg.setMultiSelect(false);
        f7CompanyOrg.setIsCUFilter(false);
        f7CompanyOrg.setPermissionItem("Suppliercompanyinfo_View");
        prmtcompayOrg.setDisplayFormat("$number$");
        prmtcompayOrg.setCommitFormat("$number$");
        prmtcompayOrg.setSelector((KDPromptSelector)f7CompanyOrg);
    }

    public static void initPrmtCompany(IUIObject ui, KDBizPromptBox box) {
        box.setDisplayFormat("$name$");
        box.setEditFormat("$number$");
        box.setCommitFormat("$number$");
        CompanyF7 f7 = new CompanyF7(ui);
        f7.disablePerm();
        box.setSelector((KDPromptSelector)f7);
    }

    public static KDComboBox initComboBoxCell(KDTable tblMain, String name) {
        KDComboBox box = new KDComboBox();
        KDTDefaultCellEditor editor = new KDTDefaultCellEditor((JComboBox)box);
        tblMain.getColumn(name).setEditor((ICellEditor)editor);
        tblMain.getColumn(name).setRenderer((IBasicRender)new CellTextRender());
        return box;
    }

    public static KDCheckBox initCheckBoxCell(KDTable tblMain, String name) {
        KDCheckBox box = new KDCheckBox();
        KDTDefaultCellEditor editor = new KDTDefaultCellEditor((JCheckBox)box);
        tblMain.getColumn(name).setEditor((ICellEditor)editor);
        tblMain.getColumn(name).setRenderer((IBasicRender)new CellCheckBoxRenderer());
        return box;
    }

    public static KDDatePicker initDateCell(KDTable tblMain, String name) {
        KDDatePicker box = new KDDatePicker();
        KDTDefaultCellEditor editor = new KDTDefaultCellEditor(box);
        tblMain.getColumn(name).setEditor((ICellEditor)editor);
        tblMain.getColumn(name).getStyleAttributes().setNumberFormat("yyyy-MM-dd");
        return box;
    }

    public static String getKDTCurrencyFormat(int precision) {
        return "%r-[ ]0." + precision + "n";
    }

    public static void initPrmtEvalItem(KDBizPromptBox prmtEvalItem) {
        prmtEvalItem.setQueryInfo("com.kingdee.eas.scm.srm.supm.app.EvalItemQuery");
        prmtEvalItem.setDisplayFormat("$number$");
        prmtEvalItem.setEditFormat("$number$");
        prmtEvalItem.setCommitFormat("$number$");
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)new Integer(1)));
        evi.setFilter(filter);
        prmtEvalItem.setEntityViewInfo(evi);
    }

    public static void initPrmtEvalMethod(KDBizPromptBox prmtEvalItem) {
        prmtEvalItem.setQueryInfo("com.kingdee.eas.scm.srm.supm.app.EvalMethodQuery");
        prmtEvalItem.setDisplayFormat("$number$");
        prmtEvalItem.setEditFormat("$number$");
        prmtEvalItem.setCommitFormat("$number$");
        prmtEvalItem.setMergeColumnKeys(new String[]{"number", "name", "entrys.isPass"});
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("usedState", (Object)new Integer(1)));
        evi.setFilter(filter);
        prmtEvalItem.setEntityViewInfo(evi);
        prmtEvalItem.getQueryAgent().resetRuntimeEntityView();
    }

    public static void initPrmtEvalGroup(KDBizPromptBox prmtEvalGroup) {
        prmtEvalGroup.setQueryInfo("com.kingdee.eas.scm.srm.supm.app.EvalGroupQuery");
        prmtEvalGroup.setDisplayFormat("$number$");
        prmtEvalGroup.setEditFormat("$number$");
        prmtEvalGroup.setCommitFormat("$number$");
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("usedState", (Object)new Integer(1)));
        evi.setFilter(filter);
        prmtEvalGroup.setEntityViewInfo(evi);
    }

    public static void initPrmtEvalProgram(KDBizPromptBox box, SelectorItemCollection sic, EvalTypeEnum evalType) {
        FilterInfo filter = new FilterInfo();
        if (evalType != null) {
            filter.getFilterItems().add(new FilterItemInfo("evalType", (Object)String.valueOf(evalType.getValue())));
        }
        filter.getFilterItems().add(new FilterItemInfo("baseStatus", (Object)String.valueOf(4)));
        EntityViewInfo evalvi = new EntityViewInfo();
        evalvi.setFilter(filter);
        box.setDisplayFormat("$name$");
        box.setEditFormat("$number$");
        box.setCommitFormat("$number$");
        box.setQueryInfo("com.kingdee.eas.scm.srm.supm.app.F7EvalProgramQuery");
        box.setEntityViewInfo(evalvi);
        if (sic != null) {
            box.setSelectorCollection(sic);
        }
        box.getQueryAgent().resetRuntimeEntityView();
    }

    public static void setSelectObject(KDComboBox cbo, Object anObject) {
        if (CoreBaseInfo.class.isInstance(anObject)) {
            CoreBaseInfo newObject = (CoreBaseInfo)anObject;
            for (int i = 0; i < cbo.getItemCount(); ++i) {
                Object obj = cbo.getItemAt(i);
                if (!(obj instanceof CoreBaseInfo)) continue;
                CoreBaseInfo info = (CoreBaseInfo)cbo.getItemAt(i);
                if (obj == null || !newObject.getId().equals((Object)info.getId())) continue;
                cbo.setSelectedIndex(i);
                break;
            }
        } else {
            cbo.setSelectedItem(anObject);
        }
    }

    public static void setComponentEnable(JComponent source, boolean enable) {
        for (int i = 0; i < source.getComponentCount(); ++i) {
            Component c = source.getComponent(i);
            if (c instanceof JComponent && ((JComponent)c).getComponentCount() > 0) {
                if (c instanceof KDBizPromptBox) {
                    ((KDBizPromptBox)c).setEnabled(enable);
                }
                if (c instanceof KDDatePicker) {
                    ((KDDatePicker)c).setEnabled(enable);
                }
                if (c instanceof KDComboBox) {
                    ((KDComboBox)c).setEnabled(enable);
                }
                if (c instanceof KDTable) {
                    ((KDTable)c).getStyleAttributes().setLocked(!enable);
                }
                SupmHelper.setComponentEnable((JComponent)c, enable);
                continue;
            }
            if (c instanceof KDFormattedTextField) {
                ((KDFormattedTextField)c).setEnabled(enable);
            }
            if (c instanceof KDTextField) {
                ((KDTextField)c).setEnabled(enable);
            }
            if (c instanceof KDWorkButton) {
                ((KDWorkButton)c).setEnabled(enable);
            }
            if (!(c instanceof KDCheckBox)) continue;
            ((KDCheckBox)c).setEnabled(enable);
        }
    }

    public static void initPrmtRecommForm(KDBizPromptBox box, SelectorItemCollection sic) {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("baseStatus", (Object)new Integer(4)));
        filter.getFilterItems().add(new FilterItemInfo("isEaluated", (Object)new Integer("0")));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        box.setDisplayFormat("$name$");
        box.setEditFormat("$number$");
        box.setCommitFormat("$number$");
        box.setQueryInfo("com.kingdee.eas.scm.srm.supm.app.F7RecommFormQuery");
        box.setEntityViewInfo(evi);
        if (sic != null) {
            box.setSelectorCollection(sic);
        }
        box.getQueryAgent().resetRuntimeEntityView();
    }

    protected static FilterInfo getDefaultCUFilter() {
        FilterInfo filter = new FilterInfo();
        if (SysContext.getSysContext().getCurrentCtrlUnit() == null) {
            return filter;
        }
        filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)SysContext.getSysContext().getCurrentCtrlUnit().getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)"11111111-1111-1111-1111-111111111111CCE7AED4", CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)"00000000-0000-0000-0000-000000000000CCE7AED4", CompareType.EQUALS));
        filter.setMaskString("#0 or #1 or #2");
        return filter;
    }

    public static void initNumber(CoreBaseInfo info, KDTextField txtField, String companyId) {
        if (!EmptyUtil.isEmpty((String)info.getString("number"))) {
            txtField.setEnabled(false);
            return;
        }
        boolean rst = SupmHelper.hasNumber(info, companyId);
        if (rst) {
            txtField.setEditable(false);
            txtField.setEnabled(false);
            txtField.setRequired(false);
            String number = SupmHelper.getDispNumber(info, companyId);
            if (!EmptyUtil.isEmpty((String)number)) {
                info.setString("number", number);
                txtField.setText(number);
            }
            if (SupmHelper.isModifiable(info, companyId)) {
                txtField.setEditable(true);
                txtField.setEnabled(true);
                txtField.setRequired(true);
            }
        } else {
            txtField.setEnabled(true);
            txtField.setEditable(true);
            txtField.setRequired(true);
        }
    }

    public static boolean hasNumber(CoreBaseInfo info, String companyId) {
        if (info == null || companyId == null || companyId.equals("")) {
            return false;
        }
        boolean result = false;
        try {
            ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
            result = codingRuleManager.isExist((IObjectValue)info, companyId);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static boolean isModifiable(CoreBaseInfo info, String companyId) {
        boolean result = false;
        try {
            ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
            result = codingRuleManager.isModifiable((IObjectValue)info, companyId);
        }
        catch (Exception e) {
            Logger.error((Throwable)e);
        }
        return result;
    }

    private static String getDispNumber(CoreBaseInfo info, String companyId) {
        String number = null;
        try {
            ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
            if (codingRuleManager.isAddView((IObjectValue)info, companyId) && !codingRuleManager.isUseIntermitNumber((IObjectValue)info, companyId)) {
                if (info instanceof SupplierInfo) {
                    return codingRuleManager.getNumber((IObjectValue)info, companyId, "browseGroup.number");
                }
                number = codingRuleManager.getNumber((IObjectValue)info, companyId);
            }
        }
        catch (BOSException e) {
        }
        catch (CodingRuleException e) {
        }
        catch (EASBizException e) {
            // empty catch block
        }
        return number;
    }
}

