/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.calculate.cache;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.shr.base.syssetting.app.filter.HRFilterUtils;
import com.kingdee.shr.compensation.app.calculate.CmpCalTaskFacadeFactory;
import com.kingdee.shr.compensation.app.calculate.CmpCalTaskFactory;
import com.kingdee.shr.compensation.app.calculate.CmpCalTaskInfo;
import com.kingdee.shr.compensation.app.calculate.SalaryCalProcessEnum;
import com.kingdee.shr.compensation.calculate.cache.SalaryCalProcess;
import com.kingdee.shr.compensation.calculate.helper.CalculateTool;
import com.kingdee.shr.compensation.calculate.thread.CalInitData;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class SalaryCalProcessCache {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.compensation.calculate.cache.SalaryCalProcessCache");
    private static volatile Map<String, SalaryCalProcess> calCache = new HashMap<String, SalaryCalProcess>();

    public static SalaryCalProcess getProcess(Context ctx, String calSchemeId) {
        SalaryCalProcess process = null;
        String key = CalculateTool.getCacheKey(HRFilterUtils.getCurrentUserId((Context)ctx), calSchemeId);
        if (calCache.containsKey(key)) {
            return calCache.get(key);
        }
        try {
            process = SalaryCalProcess.getProcess(ctx, calSchemeId);
            calCache.put(key, process);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return process;
    }

    public static void updateProcess(String key, int calCount, int exceptionCount) {
        if (!calCache.containsKey(key)) {
            return;
        }
        SalaryCalProcess salaryCalProcess = calCache.get(key);
        salaryCalProcess.setExceptionCount(exceptionCount);
        salaryCalProcess.setCalCountForCal(calCount);
    }

    public static void updateProcess(Context ctx, String cacheKey, SalaryCalProcessEnum processEnum, String desc) {
        SalaryCalProcess salaryCalProcess = calCache.get(cacheKey);
        salaryCalProcess.setDesc(desc);
        SalaryCalProcessCache.updateProcess(ctx, cacheKey, processEnum);
    }

    public static void updateProcess(Context ctx, String cacheKey, SalaryCalProcessEnum processEnum) {
        if (!calCache.containsKey(cacheKey)) {
            return;
        }
        SalaryCalProcess salaryCalProcess = calCache.get(cacheKey);
        salaryCalProcess.setProcessEnumForCal(processEnum);
        CmpCalTaskInfo taskInfo = new CmpCalTaskInfo();
        taskInfo.setId(BOSUuid.read((String)salaryCalProcess.getCalTaskId()));
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("process");
        taskInfo.setProcess(processEnum);
        switch (processEnum.getValue()) {
            case 15: {
                selector.add("beginTime");
                selector.add("sum");
                taskInfo.setSum(salaryCalProcess.getTotalCount());
                taskInfo.setBeginTime(new Timestamp(System.currentTimeMillis()));
                break;
            }
            case 30: {
                salaryCalProcess.setPercent("5%");
                break;
            }
            case 20: {
                salaryCalProcess.setPercent("10%");
                break;
            }
            case 40: {
                salaryCalProcess.setPercent("20%");
                break;
            }
            case 50: {
                salaryCalProcess.setPercent("80%");
                break;
            }
            case 70: {
                selector.add("endTime");
                selector.add("sum");
                selector.add("noCal");
                selector.add("success");
                selector.add("fail");
                taskInfo.setEndTime(new Timestamp(System.currentTimeMillis()));
                taskInfo.setSum(salaryCalProcess.getTotalCount());
                taskInfo.setNoCal(salaryCalProcess.getNoCalCount());
                taskInfo.setSuccess(salaryCalProcess.getCalCount());
                taskInfo.setFail(salaryCalProcess.getExceptionCount());
                salaryCalProcess.setPercent("100%");
                break;
            }
            case 75: {
                selector.add("endTime");
                selector.add("sum");
                selector.add("noCal");
                selector.add("success");
                selector.add("fail");
                taskInfo.setEndTime(new Timestamp(System.currentTimeMillis()));
                taskInfo.setSum(salaryCalProcess.getTotalCount());
                taskInfo.setNoCal(salaryCalProcess.getNoCalCount());
                taskInfo.setSuccess(salaryCalProcess.getCalCount());
                taskInfo.setFail(salaryCalProcess.getExceptionCount());
                salaryCalProcess.setPercent("100%");
                break;
            }
            case 65: {
                selector.add("endTime");
                taskInfo.setEndTime(new Timestamp(System.currentTimeMillis()));
            }
        }
        try {
            CmpCalTaskFactory.getLocalInstance((Context)ctx).updatePartial(taskInfo, selector);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public static void stopCalTask(String cacheKey) {
        if (!calCache.containsKey(cacheKey)) {
            return;
        }
        SalaryCalProcess calProcess = calCache.get(cacheKey);
        if (calProcess.getProcessEnum().equals((Object)SalaryCalProcessEnum.SAVING) || calProcess.getProcessEnum().equals((Object)SalaryCalProcessEnum.FINISH) || calProcess.getProcessEnum().equals((Object)SalaryCalProcessEnum.NO_CHANGE)) {
            return;
        }
        calProcess.setProcessEnumForCal(SalaryCalProcessEnum.STOPPING);
    }

    public static void relaseProcess(String key) {
        calCache.remove(key);
    }

    public static boolean initProcess(int totalCount, int noCalCount, CalInitData initData) {
        SalaryCalProcess calProcess = new SalaryCalProcess(totalCount, noCalCount);
        try {
            CmpCalTaskInfo calTaskInfo = (CmpCalTaskInfo)CmpCalTaskFacadeFactory.getLocalInstance((Context)initData.getCtx()).addCalTalk(initData);
            initData.setCalTaskId(calTaskInfo.getId().toString());
            initData.setTaskBaseId(calTaskInfo.getTaskBase().getId().toString());
            calProcess.setCalTaskId(calTaskInfo.getId().toString());
            calProcess.setCalculatorTime(calTaskInfo.getTaskBase().getCount());
            calCache.put(initData.getCacheKey(), calProcess);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return true;
    }
}

