/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.calculate.thread;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.shr.compensation.CalFormulaInfo;
import com.kingdee.shr.compensation.CmpItemFactory;
import com.kingdee.shr.compensation.CmpItemInfo;
import com.kingdee.shr.compensation.app.calculate.CmpCalStatisFactory;
import com.kingdee.shr.compensation.app.calculate.CmpCalStatisInfo;
import com.kingdee.shr.compensation.app.calculate.CmpCalTaskBaseInfo;
import com.kingdee.shr.compensation.app.calculate.CmpCalTypeEnum;
import com.kingdee.shr.compensation.app.calculate.SalaryCalProcessEnum;
import com.kingdee.shr.compensation.app.formula.SalaryCalFunction;
import com.kingdee.shr.compensation.app.formula.data.Tools;
import com.kingdee.shr.compensation.calculate.cache.SalaryCalProcessCache;
import com.kingdee.shr.compensation.calculate.combine.ICombineData;
import com.kingdee.shr.compensation.calculate.combine.TempTableData;
import com.kingdee.shr.compensation.calculate.combine.calData.CalFormulaService;
import com.kingdee.shr.compensation.calculate.helper.CalculateTool;
import com.kingdee.shr.compensation.calculate.model.ITable;
import com.kingdee.shr.compensation.calculate.pt.ISalaryCalFunmgr;
import com.kingdee.shr.compensation.calculate.result.StandardDataService;
import com.kingdee.shr.compensation.calculate.thread.CalInitData;
import com.kingdee.shr.compensation.calculate.thread.SalaryCalExecutor;
import com.kingdee.shr.compensation.calculate.thread.log.SalaryCalculatorLog;
import com.kingdee.shr.compensation.util.CmpCalUtil;
import com.kingdee.shr.validaterule.formula.callback.IValidateRuleCallBack;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.lucene.util.RamUsageEstimator;

public class SalaryCalculator
implements Runnable {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.shr.compensation.calculate.thread.SalaryCalculator");
    ICombineData combineData;
    private ISalaryCalFunmgr calFunction;
    private CalInitData initData;

    public SalaryCalculator(ISalaryCalFunmgr calFunction, ICombineData combineData, CalInitData initData) {
        this.calFunction = calFunction;
        this.combineData = combineData;
        this.initData = initData;
        if (!initData.getCalType().equals((Object)CmpCalTypeEnum.SIMULATION)) {
            SalaryCalProcessCache.updateProcess(initData.getCtx(), initData.getCacheKey(), SalaryCalProcessEnum.BEING_CALCULATE);
        }
        Tools.getInstance().setCtx(initData.getCtx());
    }

    @Override
    public void run() {
        String cacheKey = this.initData.getCacheKey();
        SalaryCalProcessCache.updateProcess(this.initData.getCtx(), cacheKey, SalaryCalProcessEnum.FORMUL_INIT);
        List<CalFormulaInfo> formulaList = null;
        SalaryCalFunction instance = null;
        Map calRecordMap = null;
        String calSchemeId = this.initData.getSchemeInfo().getId().toString();
        try {
            formulaList = this.getFormulaList();
            instance = this.calFunction.getInstance(this.initData, formulaList);
            instance.setType("cal");
            instance.setMainTableRowFilter("t_hr_scmpcaltable.fid in (" + this.initData.getFilterSql() + ")");
            instance.setCtx(this.initData.getCtx());
            calRecordMap = instance.getCalRecordMap();
        }
        catch (Exception e) {
            SalaryCalProcessCache.updateProcess(this.initData.getCtx(), cacheKey, SalaryCalProcessEnum.EXCEPTION, e.getMessage());
            logger.error((Object)e.getMessage(), (Throwable)e);
            return;
        }
        try {
            this.initStatisticsLog(instance);
        }
        catch (BOSException e) {
            SalaryCalProcessCache.updateProcess(this.initData.getCtx(), cacheKey, SalaryCalProcessEnum.EXCEPTION);
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        ITable dataTable = null;
        Map<String, Map<String, Object>> tempTableData = null;
        try {
            SalaryCalProcessCache.updateProcess(this.initData.getCtx(), cacheKey, SalaryCalProcessEnum.COMBINE_DATA);
            long l1 = System.currentTimeMillis();
            dataTable = this.combineData.getInitData(formulaList);
            TempTableData tableData = new TempTableData(this.initData);
            tempTableData = tableData.combineTempTable(formulaList);
            long l2 = System.currentTimeMillis();
            CalculateTool.resourceStatistics(calRecordMap, "CAL_RECORD_MAP_TIME", "CAL_RECORD_MAP_TIME_SCHEMEINIT", l2 - l1);
            CalculateTool.resourceStatistics(calRecordMap, "CAL_RECORD_MAP_MEMORY", "CAL_RECORD_MAP_MEMORY_INITDATA", RamUsageEstimator.humanReadableUnits((long)RamUsageEstimator.sizeOfObject((Object)dataTable)));
        }
        catch (Exception e) {
            SalaryCalProcessCache.updateProcess(this.initData.getCtx(), cacheKey, SalaryCalProcessEnum.EXCEPTION, e.getMessage());
            logger.error((Object)e.getMessage(), (Throwable)e);
            return;
        }
        if (SalaryCalProcessCache.getProcess(this.initData.getCtx(), calSchemeId).getProcessEnum().equals((Object)SalaryCalProcessEnum.STOPPING)) {
            SalaryCalProcessCache.updateProcess(this.initData.getCtx(), cacheKey, SalaryCalProcessEnum.STOPPED);
            return;
        }
        try {
            boolean isChange;
            SalaryCalProcessCache.updateProcess(this.initData.getCtx(), cacheKey, SalaryCalProcessEnum.CAL_PERSON);
            SalaryCalExecutor executor = new SalaryCalExecutor(this.initData, instance, dataTable, tempTableData);
            Map<String, Object> calDataMap = executor.doExecute();
            if (SalaryCalProcessCache.getProcess(this.initData.getCtx(), calSchemeId).getProcessEnum().equals((Object)SalaryCalProcessEnum.STOPPING)) {
                SalaryCalProcessCache.updateProcess(this.initData.getCtx(), cacheKey, SalaryCalProcessEnum.STOPPED);
                return;
            }
            SalaryCalProcessCache.updateProcess(this.initData.getCtx(), cacheKey, SalaryCalProcessEnum.SAVING);
            long l3 = System.currentTimeMillis();
            List dataList = (List)calDataMap.get("calUpdateDataList");
            List stateList = (List)calDataMap.get("calUpdateStateDataList");
            boolean bl = isChange = dataList.size() > 0 || stateList.size() > 0;
            if (isChange) {
                StandardDataService dataService = new StandardDataService(this.initData);
                dataService.saveData(calDataMap);
            }
            long l4 = System.currentTimeMillis();
            CalculateTool.resourceStatistics(calRecordMap, "CAL_RECORD_MAP_TIME_SAVERESULT", "CAL_RECORD_MAP_TIME_SAVERESULT_CAL", l4 - l3);
            CalculateTool.resourceStatistics(calRecordMap, "CAL_RECORD_MAP_MEMORY", "CAL_RECORD_MAP_MEMORY_CALRESULT", RamUsageEstimator.humanReadableUnits((long)RamUsageEstimator.sizeOfObject(calDataMap)));
            SalaryCalculatorLog calculatorLog = new SalaryCalculatorLog(this.initData, calRecordMap);
            calculatorLog.saveResourceStatistics();
            if (isChange) {
                SalaryCalProcessCache.updateProcess(this.initData.getCtx(), cacheKey, SalaryCalProcessEnum.FINISH);
            } else {
                SalaryCalProcessCache.updateProcess(this.initData.getCtx(), cacheKey, SalaryCalProcessEnum.NO_CHANGE);
            }
            CmpCalUtil.updateNewCalSchemeState(this.initData.getCtx(), this.initData.getSchemeInfo().getId().toString());
            this.callBackAfterCalculate(true);
        }
        catch (Exception e) {
            SalaryCalProcessCache.updateProcess(this.initData.getCtx(), cacheKey, SalaryCalProcessEnum.EXCEPTION);
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private void callBackAfterCalculate(boolean isSuccess) {
        List<IValidateRuleCallBack> calSuccessCallBacks = this.initData.getCalSuccessCallBack();
        if (null != calSuccessCallBacks) {
            for (IValidateRuleCallBack callBack : calSuccessCallBacks) {
                if (isSuccess) {
                    callBack.begin((Object)this.initData);
                    callBack.result((Object)this.initData);
                    continue;
                }
                callBack.failed((Object)this.initData);
            }
        }
    }

    private void initStatisticsLog(SalaryCalFunction instance) throws BOSException {
        CmpCalStatisInfo logInfo = new CmpCalStatisInfo();
        CmpCalTaskBaseInfo baseInfo = new CmpCalTaskBaseInfo();
        IObjectPK pk = null;
        baseInfo.setId(BOSUuid.read((String)this.initData.getTaskBaseId()));
        logInfo.setTaskBase(baseInfo);
        try {
            pk = CmpCalStatisFactory.getLocalInstance((Context)this.initData.getCtx()).addnew(logInfo);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException(e.getMessage());
        }
        instance.getCalRecordMap().put("CAL_RECORD_MAP_STATISTICS_KEY", pk.toString());
    }

    public List<CalFormulaInfo> getFormulaList() throws BOSException {
        List<CalFormulaInfo> formulaList = null;
        String formulaKey = this.initData.getCalType().equals((Object)CmpCalTypeEnum.SIMULATION) ? this.initData.getFormulaId() : this.initData.getSchemeInfo().getId().toString();
        try {
            formulaList = CalFormulaService.getCalFormula(this.initData, formulaKey);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException(e.getMessage());
        }
        return formulaList;
    }

    public String simulationCal() throws Exception {
        Map<String, Object> calDataMap = null;
        List<CalFormulaInfo> formulaList = null;
        try {
            formulaList = this.getFormulaList();
            if (formulaList.size() < 1) {
                return null;
            }
            SalaryCalFunction instance = this.calFunction.getInstance(this.initData, formulaList);
            instance.setType("test");
            ITable dataTable = this.combineData.getInitData(formulaList);
            TempTableData tableData = new TempTableData(this.initData);
            Map<String, Map<String, Object>> tempTableData = tableData.combineTempTable(formulaList);
            SalaryCalExecutor executor = new SalaryCalExecutor(this.initData, instance, dataTable, tempTableData);
            calDataMap = executor.doExecute();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new Exception(e.getMessage());
        }
        int itemFieldSn = Integer.valueOf(formulaList.get(0).getCalItem().substring(1));
        CmpItemInfo itemInfo = CmpItemFactory.getLocalInstance(this.initData.getCtx()).getCmpItemInfo("where fieldsn = " + itemFieldSn);
        Map paraMap = (Map)calDataMap.get("simulation");
        String itemKey = "T_HR_SCMPCALTABLE_" + formulaList.get(0).getCalItem().toUpperCase();
        return CalculateTool.getDoubleByScienNotation(paraMap.get(itemKey), itemInfo.getDataDot().toString());
    }
}

